/* */ 
"format cjs";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { isPresent, isBlank, isArray, isNumber } from 'angular2/src/facade/lang';
import { RenderComponentTemplate } from 'angular2/src/core/render/api';
import { Optional, Injectable, resolveForwardRef, Inject } from 'angular2/src/core/di';
import { PipeProvider } from '../pipes/pipe_provider';
import { ProtoPipes } from '../pipes/pipes';
import { AppProtoView, AppProtoViewMergeInfo, ViewType } from './view';
import { ElementBinder } from './element_binder';
import { ProtoElementInjector, DirectiveProvider } from './element_injector';
import { DirectiveResolver } from './directive_resolver';
import { ViewResolver } from './view_resolver';
import { PipeResolver } from './pipe_resolver';
import { ViewEncapsulation } from '../metadata/view';
import { PLATFORM_PIPES } from 'angular2/src/core/platform_directives_and_pipes';
import { visitAllCommands, EmbeddedTemplateCmd, BeginComponentCmd } from './template_commands';
import { Renderer } from 'angular2/src/core/render/api';
import { APP_ID } from 'angular2/src/core/application_tokens';
export let ProtoViewFactory = class {
    constructor(_renderer, _platformPipes, _directiveResolver, _viewResolver, _pipeResolver, _appId) {
        this._renderer = _renderer;
        this._platformPipes = _platformPipes;
        this._directiveResolver = _directiveResolver;
        this._viewResolver = _viewResolver;
        this._pipeResolver = _pipeResolver;
        this._appId = _appId;
        this._cache = new Map();
        this._nextTemplateId = 0;
    }
    clearCache() { this._cache.clear(); }
    createHost(compiledHostTemplate) {
        var compiledTemplate = compiledHostTemplate.template;
        var result = this._cache.get(compiledTemplate.id);
        if (isBlank(result)) {
            var emptyMap = {};
            var shortId = `${this._appId}-${this._nextTemplateId++}`;
            this._renderer.registerComponentTemplate(new RenderComponentTemplate(compiledTemplate.id, shortId, ViewEncapsulation.None, compiledTemplate.commands, []));
            result =
                new AppProtoView(compiledTemplate.id, compiledTemplate.commands, ViewType.HOST, true, compiledTemplate.changeDetectorFactory, null, new ProtoPipes(emptyMap));
            this._cache.set(compiledTemplate.id, result);
        }
        return result;
    }
    _createComponent(cmd) {
        var nestedProtoView = this._cache.get(cmd.templateId);
        if (isBlank(nestedProtoView)) {
            var component = cmd.directives[0];
            var view = this._viewResolver.resolve(component);
            var compiledTemplate = cmd.templateGetter();
            var styles = _flattenStyleArr(compiledTemplate.styles, []);
            var shortId = `${this._appId}-${this._nextTemplateId++}`;
            this._renderer.registerComponentTemplate(new RenderComponentTemplate(compiledTemplate.id, shortId, cmd.encapsulation, compiledTemplate.commands, styles));
            var boundPipes = this._flattenPipes(view).map(pipe => this._bindPipe(pipe));
            nestedProtoView = new AppProtoView(compiledTemplate.id, compiledTemplate.commands, ViewType.COMPONENT, true, compiledTemplate.changeDetectorFactory, null, ProtoPipes.fromProviders(boundPipes));
            // Note: The cache is updated before recursing
            // to be able to resolve cycles
            this._cache.set(compiledTemplate.id, nestedProtoView);
            this._initializeProtoView(nestedProtoView, null);
        }
        return nestedProtoView;
    }
    _createEmbeddedTemplate(cmd, parent) {
        var nestedProtoView = new AppProtoView(parent.templateId, cmd.children, ViewType.EMBEDDED, cmd.isMerged, cmd.changeDetectorFactory, arrayToMap(cmd.variableNameAndValues, true), new ProtoPipes(parent.pipes.config));
        if (cmd.isMerged) {
            this.initializeProtoViewIfNeeded(nestedProtoView);
        }
        return nestedProtoView;
    }
    initializeProtoViewIfNeeded(protoView) {
        if (!protoView.isInitialized()) {
            var render = this._renderer.createProtoView(protoView.templateId, protoView.templateCmds);
            this._initializeProtoView(protoView, render);
        }
    }
    _initializeProtoView(protoView, render) {
        var initializer = new _ProtoViewInitializer(protoView, this._directiveResolver, this);
        visitAllCommands(initializer, protoView.templateCmds);
        var mergeInfo = new AppProtoViewMergeInfo(initializer.mergeEmbeddedViewCount, initializer.mergeElementCount, initializer.mergeViewCount);
        protoView.init(render, initializer.elementBinders, initializer.boundTextCount, mergeInfo, initializer.variableLocations);
    }
    _bindPipe(typeOrProvider) {
        let meta = this._pipeResolver.resolve(typeOrProvider);
        return PipeProvider.createFromType(typeOrProvider, meta);
    }
    _flattenPipes(view) {
        let pipes = [];
        if (isPresent(this._platformPipes)) {
            _flattenArray(this._platformPipes, pipes);
        }
        if (isPresent(view.pipes)) {
            _flattenArray(view.pipes, pipes);
        }
        return pipes;
    }
};
ProtoViewFactory = __decorate([
    Injectable(),
    __param(1, Optional()),
    __param(1, Inject(PLATFORM_PIPES)),
    __param(5, Inject(APP_ID)), 
    __metadata('design:paramtypes', [Renderer, Array, DirectiveResolver, ViewResolver, PipeResolver, String])
], ProtoViewFactory);
function createComponent(protoViewFactory, cmd) {
    return protoViewFactory._createComponent(cmd);
}
function createEmbeddedTemplate(protoViewFactory, cmd, parent) {
    return protoViewFactory._createEmbeddedTemplate(cmd, parent);
}
class _ProtoViewInitializer {
    constructor(_protoView, _directiveResolver, _protoViewFactory) {
        this._protoView = _protoView;
        this._directiveResolver = _directiveResolver;
        this._protoViewFactory = _protoViewFactory;
        this.variableLocations = new Map();
        this.boundTextCount = 0;
        this.boundElementIndex = 0;
        this.elementBinderStack = [];
        this.distanceToParentElementBinder = 0;
        this.distanceToParentProtoElementInjector = 0;
        this.elementBinders = [];
        this.mergeEmbeddedViewCount = 0;
        this.mergeElementCount = 0;
        this.mergeViewCount = 1;
    }
    visitText(cmd, context) {
        if (cmd.isBound) {
            this.boundTextCount++;
        }
        return null;
    }
    visitNgContent(cmd, context) { return null; }
    visitBeginElement(cmd, context) {
        if (cmd.isBound) {
            this._visitBeginBoundElement(cmd, null);
        }
        else {
            this._visitBeginElement(cmd, null, null);
        }
        return null;
    }
    visitEndElement(context) { return this._visitEndElement(); }
    visitBeginComponent(cmd, context) {
        var nestedProtoView = createComponent(this._protoViewFactory, cmd);
        return this._visitBeginBoundElement(cmd, nestedProtoView);
    }
    visitEndComponent(context) { return this._visitEndElement(); }
    visitEmbeddedTemplate(cmd, context) {
        var nestedProtoView = createEmbeddedTemplate(this._protoViewFactory, cmd, this._protoView);
        if (cmd.isMerged) {
            this.mergeEmbeddedViewCount++;
        }
        this._visitBeginBoundElement(cmd, nestedProtoView);
        return this._visitEndElement();
    }
    _visitBeginBoundElement(cmd, nestedProtoView) {
        if (isPresent(nestedProtoView) && nestedProtoView.isMergable) {
            this.mergeElementCount += nestedProtoView.mergeInfo.elementCount;
            this.mergeViewCount += nestedProtoView.mergeInfo.viewCount;
            this.mergeEmbeddedViewCount += nestedProtoView.mergeInfo.embeddedViewCount;
        }
        var elementBinder = _createElementBinder(this._directiveResolver, nestedProtoView, this.elementBinderStack, this.boundElementIndex, this.distanceToParentElementBinder, this.distanceToParentProtoElementInjector, cmd);
        this.elementBinders.push(elementBinder);
        var protoElementInjector = elementBinder.protoElementInjector;
        for (var i = 0; i < cmd.variableNameAndValues.length; i += 2) {
            this.variableLocations.set(cmd.variableNameAndValues[i], this.boundElementIndex);
        }
        this.boundElementIndex++;
        this.mergeElementCount++;
        return this._visitBeginElement(cmd, elementBinder, protoElementInjector);
    }
    _visitBeginElement(cmd, elementBinder, protoElementInjector) {
        this.distanceToParentElementBinder =
            isPresent(elementBinder) ? 1 : this.distanceToParentElementBinder + 1;
        this.distanceToParentProtoElementInjector =
            isPresent(protoElementInjector) ? 1 : this.distanceToParentProtoElementInjector + 1;
        this.elementBinderStack.push(elementBinder);
        return null;
    }
    _visitEndElement() {
        var parentElementBinder = this.elementBinderStack.pop();
        var parentProtoElementInjector = isPresent(parentElementBinder) ? parentElementBinder.protoElementInjector : null;
        this.distanceToParentElementBinder = isPresent(parentElementBinder) ?
            parentElementBinder.distanceToParent :
            this.distanceToParentElementBinder - 1;
        this.distanceToParentProtoElementInjector = isPresent(parentProtoElementInjector) ?
            parentProtoElementInjector.distanceToParent :
            this.distanceToParentProtoElementInjector - 1;
        return null;
    }
}
function _createElementBinder(directiveResolver, nestedProtoView, elementBinderStack, boundElementIndex, distanceToParentBinder, distanceToParentPei, beginElementCmd) {
    var parentElementBinder = null;
    var parentProtoElementInjector = null;
    if (distanceToParentBinder > 0) {
        parentElementBinder = elementBinderStack[elementBinderStack.length - distanceToParentBinder];
    }
    if (isBlank(parentElementBinder)) {
        distanceToParentBinder = -1;
    }
    if (distanceToParentPei > 0) {
        var peiBinder = elementBinderStack[elementBinderStack.length - distanceToParentPei];
        if (isPresent(peiBinder)) {
            parentProtoElementInjector = peiBinder.protoElementInjector;
        }
    }
    if (isBlank(parentProtoElementInjector)) {
        distanceToParentPei = -1;
    }
    var componentDirectiveProvider = null;
    var isEmbeddedTemplate = false;
    var directiveProviders = beginElementCmd.directives.map(type => provideDirective(directiveResolver, type));
    if (beginElementCmd instanceof BeginComponentCmd) {
        componentDirectiveProvider = directiveProviders[0];
    }
    else if (beginElementCmd instanceof EmbeddedTemplateCmd) {
        isEmbeddedTemplate = true;
    }
    var protoElementInjector = null;
    // Create a protoElementInjector for any element that either has bindings *or* has one
    // or more var- defined *or* for <template> elements:
    // - Elements with a var- defined need a their own element injector
    //   so that, when hydrating, $implicit can be set to the element.
    // - <template> elements need their own ElementInjector so that we can query their TemplateRef
    var hasVariables = beginElementCmd.variableNameAndValues.length > 0;
    if (directiveProviders.length > 0 || hasVariables || isEmbeddedTemplate) {
        var directiveVariableBindings = new Map();
        if (!isEmbeddedTemplate) {
            directiveVariableBindings = createDirectiveVariableBindings(beginElementCmd.variableNameAndValues, directiveProviders);
        }
        protoElementInjector = ProtoElementInjector.create(parentProtoElementInjector, boundElementIndex, directiveProviders, isPresent(componentDirectiveProvider), distanceToParentPei, directiveVariableBindings);
        protoElementInjector.attributes = arrayToMap(beginElementCmd.attrNameAndValues, false);
    }
    return new ElementBinder(boundElementIndex, parentElementBinder, distanceToParentBinder, protoElementInjector, componentDirectiveProvider, nestedProtoView);
}
function provideDirective(directiveResolver, type) {
    let annotation = directiveResolver.resolve(type);
    return DirectiveProvider.createFromType(type, annotation);
}
export function createDirectiveVariableBindings(variableNameAndValues, directiveProviders) {
    var directiveVariableBindings = new Map();
    for (var i = 0; i < variableNameAndValues.length; i += 2) {
        var templateName = variableNameAndValues[i];
        var dirIndex = variableNameAndValues[i + 1];
        if (isNumber(dirIndex)) {
            directiveVariableBindings.set(templateName, dirIndex);
        }
        else {
            // a variable without a directive index -> reference the element
            directiveVariableBindings.set(templateName, null);
        }
    }
    return directiveVariableBindings;
}
function arrayToMap(arr, inverse) {
    var result = new Map();
    for (var i = 0; i < arr.length; i += 2) {
        if (inverse) {
            result.set(arr[i + 1], arr[i]);
        }
        else {
            result.set(arr[i], arr[i + 1]);
        }
    }
    return result;
}
function _flattenArray(tree, out) {
    for (var i = 0; i < tree.length; i++) {
        var item = resolveForwardRef(tree[i]);
        if (isArray(item)) {
            _flattenArray(item, out);
        }
        else {
            out.push(item);
        }
    }
}
function _flattenStyleArr(arr, out) {
    for (var i = 0; i < arr.length; i++) {
        var entry = arr[i];
        if (isArray(entry)) {
            _flattenStyleArr(entry, out);
        }
        else {
            out.push(entry);
        }
    }
    return out;
}
//# sourceMappingURL=data:application/json;base64,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