/* */ 
"format cjs";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Inject, Injectable, forwardRef } from 'angular2/src/core/di';
import { isPresent, isBlank } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import * as viewModule from './view';
import { internalView, internalProtoView } from './view_ref';
import { Renderer } from 'angular2/src/core/render/api';
import { AppViewManagerUtils } from './view_manager_utils';
import { AppViewPool } from './view_pool';
import { AppViewListener } from './view_listener';
import { wtfCreateScope, wtfLeave } from '../profile/profile';
import { ProtoViewFactory } from './proto_view_factory';
/**
 * Service exposing low level API for creating, moving and destroying Views.
 *
 * Most applications should use higher-level abstractions like {@link DynamicComponentLoader} and
 * {@link ViewContainerRef} instead.
 */
export class AppViewManager {
    /**
     * Returns the {@link ElementRef} that makes up the specified Host View.
     */
    getHostElement(hostViewRef) {
        var hostView = internalView(hostViewRef);
        if (hostView.proto.type !== viewModule.ViewType.HOST) {
            throw new BaseException('This operation is only allowed on host views');
        }
        return hostView.elementRefs[hostView.elementOffset];
    }
}
export let AppViewManager_ = class extends AppViewManager {
    constructor(_viewPool, _viewListener, _utils, _renderer, _protoViewFactory) {
        super();
        this._viewPool = _viewPool;
        this._viewListener = _viewListener;
        this._utils = _utils;
        this._renderer = _renderer;
        /** @internal */
        this._createRootHostViewScope = wtfCreateScope('AppViewManager#createRootHostView()');
        /** @internal */
        this._destroyRootHostViewScope = wtfCreateScope('AppViewManager#destroyRootHostView()');
        /** @internal */
        this._createEmbeddedViewInContainerScope = wtfCreateScope('AppViewManager#createEmbeddedViewInContainer()');
        /** @internal */
        this._createHostViewInContainerScope = wtfCreateScope('AppViewManager#createHostViewInContainer()');
        /** @internal */
        this._destroyViewInContainerScope = wtfCreateScope('AppViewMananger#destroyViewInContainer()');
        /** @internal */
        this._attachViewInContainerScope = wtfCreateScope('AppViewMananger#attachViewInContainer()');
        /** @internal */
        this._detachViewInContainerScope = wtfCreateScope('AppViewMananger#detachViewInContainer()');
        this._protoViewFactory = _protoViewFactory;
    }
    getViewContainer(location) {
        var hostView = internalView(location.parentView);
        return hostView.elementInjectors[location.boundElementIndex]
            .getViewContainerRef();
    }
    getNamedElementInComponentView(hostLocation, variableName) {
        var hostView = internalView(hostLocation.parentView);
        var boundElementIndex = hostLocation.boundElementIndex;
        var componentView = hostView.getNestedView(boundElementIndex);
        if (isBlank(componentView)) {
            throw new BaseException(`There is no component directive at element ${boundElementIndex}`);
        }
        var binderIdx = componentView.proto.variableLocations.get(variableName);
        if (isBlank(binderIdx)) {
            throw new BaseException(`Could not find variable ${variableName}`);
        }
        return componentView.elementRefs[componentView.elementOffset + binderIdx];
    }
    getComponent(hostLocation) {
        var hostView = internalView(hostLocation.parentView);
        var boundElementIndex = hostLocation.boundElementIndex;
        return this._utils.getComponentInstance(hostView, boundElementIndex);
    }
    createRootHostView(hostProtoViewRef, overrideSelector, injector) {
        var s = this._createRootHostViewScope();
        var hostProtoView = internalProtoView(hostProtoViewRef);
        this._protoViewFactory.initializeProtoViewIfNeeded(hostProtoView);
        var hostElementSelector = overrideSelector;
        if (isBlank(hostElementSelector)) {
            hostElementSelector = hostProtoView.elementBinders[0].componentDirective.metadata.selector;
        }
        var renderViewWithFragments = this._renderer.createRootHostView(hostProtoView.render, hostProtoView.mergeInfo.embeddedViewCount + 1, hostElementSelector);
        var hostView = this._createMainView(hostProtoView, renderViewWithFragments);
        this._renderer.hydrateView(hostView.render);
        this._utils.hydrateRootHostView(hostView, injector);
        return wtfLeave(s, hostView.ref);
    }
    destroyRootHostView(hostViewRef) {
        // Note: Don't put the hostView into the view pool
        // as it is depending on the element for which it was created.
        var s = this._destroyRootHostViewScope();
        var hostView = internalView(hostViewRef);
        this._renderer.detachFragment(hostView.renderFragment);
        this._renderer.dehydrateView(hostView.render);
        this._viewDehydrateRecurse(hostView);
        this._viewListener.onViewDestroyed(hostView);
        this._renderer.destroyView(hostView.render);
        wtfLeave(s);
    }
    createEmbeddedViewInContainer(viewContainerLocation, index, templateRef) {
        var s = this._createEmbeddedViewInContainerScope();
        var protoView = internalProtoView(templateRef.protoViewRef);
        if (protoView.type !== viewModule.ViewType.EMBEDDED) {
            throw new BaseException('This method can only be called with embedded ProtoViews!');
        }
        this._protoViewFactory.initializeProtoViewIfNeeded(protoView);
        return wtfLeave(s, this._createViewInContainer(viewContainerLocation, index, protoView, templateRef.elementRef, null));
    }
    createHostViewInContainer(viewContainerLocation, index, protoViewRef, imperativelyCreatedInjector) {
        var s = this._createHostViewInContainerScope();
        var protoView = internalProtoView(protoViewRef);
        if (protoView.type !== viewModule.ViewType.HOST) {
            throw new BaseException('This method can only be called with host ProtoViews!');
        }
        this._protoViewFactory.initializeProtoViewIfNeeded(protoView);
        return wtfLeave(s, this._createViewInContainer(viewContainerLocation, index, protoView, viewContainerLocation, imperativelyCreatedInjector));
    }
    /**
     *
     * See {@link AppViewManager#destroyViewInContainer}.
     * @internal
     */
    _createViewInContainer(viewContainerLocation, index, protoView, context, imperativelyCreatedInjector) {
        var parentView = internalView(viewContainerLocation.parentView);
        var boundElementIndex = viewContainerLocation.boundElementIndex;
        var contextView = internalView(context.parentView);
        var contextBoundElementIndex = context.boundElementIndex;
        var embeddedFragmentView = contextView.getNestedView(contextBoundElementIndex);
        var view;
        if (protoView.type === viewModule.ViewType.EMBEDDED && isPresent(embeddedFragmentView) &&
            !embeddedFragmentView.hydrated()) {
            // Case 1: instantiate the first view of a template that has been merged into a parent
            view = embeddedFragmentView;
            this._attachRenderView(parentView, boundElementIndex, index, view);
        }
        else {
            // Case 2: instantiate another copy of the template or a host ProtoView.
            // This is a separate case
            // as we only inline one copy of the template into the parent view.
            view = this._createPooledView(protoView);
            this._attachRenderView(parentView, boundElementIndex, index, view);
            this._renderer.hydrateView(view.render);
        }
        this._utils.attachViewInContainer(parentView, boundElementIndex, contextView, contextBoundElementIndex, index, view);
        try {
            this._utils.hydrateViewInContainer(parentView, boundElementIndex, contextView, contextBoundElementIndex, index, imperativelyCreatedInjector);
        }
        catch (e) {
            this._utils.detachViewInContainer(parentView, boundElementIndex, index);
            throw e;
        }
        return view.ref;
    }
    /** @internal */
    _attachRenderView(parentView, boundElementIndex, index, view) {
        var elementRef = parentView.elementRefs[boundElementIndex];
        if (index === 0) {
            this._renderer.attachFragmentAfterElement(elementRef, view.renderFragment);
        }
        else {
            var prevView = parentView.viewContainers[boundElementIndex].views[index - 1];
            this._renderer.attachFragmentAfterFragment(prevView.renderFragment, view.renderFragment);
        }
    }
    destroyViewInContainer(viewContainerLocation, index) {
        var s = this._destroyViewInContainerScope();
        var parentView = internalView(viewContainerLocation.parentView);
        var boundElementIndex = viewContainerLocation.boundElementIndex;
        this._destroyViewInContainer(parentView, boundElementIndex, index);
        wtfLeave(s);
    }
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    attachViewInContainer(viewContainerLocation, index, viewRef) {
        var s = this._attachViewInContainerScope();
        var view = internalView(viewRef);
        var parentView = internalView(viewContainerLocation.parentView);
        var boundElementIndex = viewContainerLocation.boundElementIndex;
        // TODO(tbosch): the public methods attachViewInContainer/detachViewInContainer
        // are used for moving elements without the same container.
        // We will change this into an atomic `move` operation, which should preserve the
        // previous parent injector (see https://github.com/angular/angular/issues/1377).
        // Right now we are destroying any special
        // context view that might have been used.
        this._utils.attachViewInContainer(parentView, boundElementIndex, null, null, index, view);
        this._attachRenderView(parentView, boundElementIndex, index, view);
        return wtfLeave(s, viewRef);
    }
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    detachViewInContainer(viewContainerLocation, index) {
        var s = this._detachViewInContainerScope();
        var parentView = internalView(viewContainerLocation.parentView);
        var boundElementIndex = viewContainerLocation.boundElementIndex;
        var viewContainer = parentView.viewContainers[boundElementIndex];
        var view = viewContainer.views[index];
        this._utils.detachViewInContainer(parentView, boundElementIndex, index);
        this._renderer.detachFragment(view.renderFragment);
        return wtfLeave(s, view.ref);
    }
    /** @internal */
    _createMainView(protoView, renderViewWithFragments) {
        var mergedParentView = this._utils.createView(protoView, renderViewWithFragments, this, this._renderer);
        this._renderer.setEventDispatcher(mergedParentView.render, mergedParentView);
        this._viewListener.onViewCreated(mergedParentView);
        return mergedParentView;
    }
    /** @internal */
    _createPooledView(protoView) {
        var view = this._viewPool.getView(protoView);
        if (isBlank(view)) {
            view = this._createMainView(protoView, this._renderer.createView(protoView.render, protoView.mergeInfo.embeddedViewCount + 1));
        }
        return view;
    }
    /** @internal */
    _destroyPooledView(view) {
        var wasReturned = this._viewPool.returnView(view);
        if (!wasReturned) {
            this._viewListener.onViewDestroyed(view);
            this._renderer.destroyView(view.render);
        }
    }
    /** @internal */
    _destroyViewInContainer(parentView, boundElementIndex, index) {
        var viewContainer = parentView.viewContainers[boundElementIndex];
        var view = viewContainer.views[index];
        this._viewDehydrateRecurse(view);
        this._utils.detachViewInContainer(parentView, boundElementIndex, index);
        if (view.viewOffset > 0) {
            // Case 1: a view that is part of another view.
            // Just detach the fragment
            this._renderer.detachFragment(view.renderFragment);
        }
        else {
            // Case 2: a view that is not part of another view.
            // dehydrate and destroy it.
            this._renderer.dehydrateView(view.render);
            this._renderer.detachFragment(view.renderFragment);
            this._destroyPooledView(view);
        }
    }
    /** @internal */
    _viewDehydrateRecurse(view) {
        if (view.hydrated()) {
            this._utils.dehydrateView(view);
        }
        var viewContainers = view.viewContainers;
        var startViewOffset = view.viewOffset;
        var endViewOffset = view.viewOffset + view.proto.mergeInfo.viewCount - 1;
        var elementOffset = view.elementOffset;
        for (var viewIdx = startViewOffset; viewIdx <= endViewOffset; viewIdx++) {
            var currView = view.views[viewIdx];
            for (var binderIdx = 0; binderIdx < currView.proto.elementBinders.length; binderIdx++, elementOffset++) {
                var vc = viewContainers[elementOffset];
                if (isPresent(vc)) {
                    for (var j = vc.views.length - 1; j >= 0; j--) {
                        this._destroyViewInContainer(currView, elementOffset, j);
                    }
                }
            }
        }
    }
};
AppViewManager_ = __decorate([
    Injectable(),
    __param(4, Inject(forwardRef(() => ProtoViewFactory))), 
    __metadata('design:paramtypes', [AppViewPool, AppViewListener, AppViewManagerUtils, Renderer, Object])
], AppViewManager_);
//# sourceMappingURL=data:application/json;base64,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