/* */ 
"format cjs";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Injector, Injectable } from 'angular2/src/core/di';
import { ListWrapper } from 'angular2/src/facade/collection';
import * as eli from './element_injector';
import { isPresent, isBlank } from 'angular2/src/facade/lang';
import * as viewModule from './view';
import { ElementRef_ } from './element_ref';
import { TemplateRef_ } from './template_ref';
import { Pipes } from 'angular2/src/core/pipes/pipes';
export let AppViewManagerUtils = class {
    constructor() {
    }
    getComponentInstance(parentView, boundElementIndex) {
        var eli = parentView.elementInjectors[boundElementIndex];
        return eli.getComponent();
    }
    createView(mergedParentViewProto, renderViewWithFragments, viewManager, renderer) {
        var renderFragments = renderViewWithFragments.fragmentRefs;
        var renderView = renderViewWithFragments.viewRef;
        var elementCount = mergedParentViewProto.mergeInfo.elementCount;
        var viewCount = mergedParentViewProto.mergeInfo.viewCount;
        var elementRefs = ListWrapper.createFixedSize(elementCount);
        var viewContainers = ListWrapper.createFixedSize(elementCount);
        var preBuiltObjects = ListWrapper.createFixedSize(elementCount);
        var elementInjectors = ListWrapper.createFixedSize(elementCount);
        var views = ListWrapper.createFixedSize(viewCount);
        var elementOffset = 0;
        var textOffset = 0;
        var fragmentIdx = 0;
        var containerElementIndicesByViewIndex = ListWrapper.createFixedSize(viewCount);
        for (var viewOffset = 0; viewOffset < viewCount; viewOffset++) {
            var containerElementIndex = containerElementIndicesByViewIndex[viewOffset];
            var containerElementInjector = isPresent(containerElementIndex) ? elementInjectors[containerElementIndex] : null;
            var parentView = isPresent(containerElementInjector) ? preBuiltObjects[containerElementIndex].view : null;
            var protoView = isPresent(containerElementIndex) ?
                parentView.proto.elementBinders[containerElementIndex - parentView.elementOffset]
                    .nestedProtoView :
                mergedParentViewProto;
            var renderFragment = null;
            if (viewOffset === 0 || protoView.type === viewModule.ViewType.EMBEDDED) {
                renderFragment = renderFragments[fragmentIdx++];
            }
            var currentView = new viewModule.AppView(renderer, protoView, viewOffset, elementOffset, textOffset, protoView.protoLocals, renderView, renderFragment, containerElementInjector);
            views[viewOffset] = currentView;
            if (isPresent(containerElementIndex)) {
                preBuiltObjects[containerElementIndex].nestedView = currentView;
            }
            var rootElementInjectors = [];
            var nestedViewOffset = viewOffset + 1;
            for (var binderIdx = 0; binderIdx < protoView.elementBinders.length; binderIdx++) {
                var binder = protoView.elementBinders[binderIdx];
                var boundElementIndex = elementOffset + binderIdx;
                var elementInjector = null;
                if (isPresent(binder.nestedProtoView) && binder.nestedProtoView.isMergable) {
                    containerElementIndicesByViewIndex[nestedViewOffset] = boundElementIndex;
                    nestedViewOffset += binder.nestedProtoView.mergeInfo.viewCount;
                }
                // elementInjectors and rootElementInjectors
                var protoElementInjector = binder.protoElementInjector;
                if (isPresent(protoElementInjector)) {
                    if (isPresent(protoElementInjector.parent)) {
                        var parentElementInjector = elementInjectors[elementOffset + protoElementInjector.parent.index];
                        elementInjector = protoElementInjector.instantiate(parentElementInjector);
                    }
                    else {
                        elementInjector = protoElementInjector.instantiate(null);
                        rootElementInjectors.push(elementInjector);
                    }
                }
                elementInjectors[boundElementIndex] = elementInjector;
                // elementRefs
                var el = new ElementRef_(currentView.ref, boundElementIndex, renderer);
                elementRefs[el.boundElementIndex] = el;
                // preBuiltObjects
                if (isPresent(elementInjector)) {
                    var templateRef = isPresent(binder.nestedProtoView) &&
                        binder.nestedProtoView.type === viewModule.ViewType.EMBEDDED ?
                        new TemplateRef_(el) :
                        null;
                    preBuiltObjects[boundElementIndex] =
                        new eli.PreBuiltObjects(viewManager, currentView, el, templateRef);
                }
            }
            currentView.init(protoView.changeDetectorFactory(currentView), elementInjectors, rootElementInjectors, preBuiltObjects, views, elementRefs, viewContainers);
            if (isPresent(parentView) && protoView.type === viewModule.ViewType.COMPONENT) {
                parentView.changeDetector.addViewChild(currentView.changeDetector);
            }
            elementOffset += protoView.elementBinders.length;
            textOffset += protoView.textBindingCount;
        }
        return views[0];
    }
    hydrateRootHostView(hostView, injector) {
        this._hydrateView(hostView, injector, null, new Object(), null);
    }
    // Misnomer: this method is attaching next to the view container.
    attachViewInContainer(parentView, boundElementIndex, contextView, contextBoundElementIndex, index, view) {
        if (isBlank(contextView)) {
            contextView = parentView;
            contextBoundElementIndex = boundElementIndex;
        }
        parentView.changeDetector.addContentChild(view.changeDetector);
        var viewContainer = parentView.viewContainers[boundElementIndex];
        if (isBlank(viewContainer)) {
            viewContainer = new viewModule.AppViewContainer();
            parentView.viewContainers[boundElementIndex] = viewContainer;
        }
        ListWrapper.insert(viewContainer.views, index, view);
        var elementInjector = contextView.elementInjectors[contextBoundElementIndex];
        for (var i = view.rootElementInjectors.length - 1; i >= 0; i--) {
            if (isPresent(elementInjector.parent)) {
                view.rootElementInjectors[i].link(elementInjector.parent);
            }
        }
        elementInjector.traverseAndSetQueriesAsDirty();
    }
    detachViewInContainer(parentView, boundElementIndex, index) {
        var viewContainer = parentView.viewContainers[boundElementIndex];
        var view = viewContainer.views[index];
        parentView.elementInjectors[boundElementIndex].traverseAndSetQueriesAsDirty();
        view.changeDetector.remove();
        ListWrapper.removeAt(viewContainer.views, index);
        for (var i = 0; i < view.rootElementInjectors.length; ++i) {
            var inj = view.rootElementInjectors[i];
            inj.unlink();
        }
    }
    hydrateViewInContainer(parentView, boundElementIndex, contextView, contextBoundElementIndex, index, imperativelyCreatedProviders) {
        if (isBlank(contextView)) {
            contextView = parentView;
            contextBoundElementIndex = boundElementIndex;
        }
        var viewContainer = parentView.viewContainers[boundElementIndex];
        var view = viewContainer.views[index];
        var elementInjector = contextView.elementInjectors[contextBoundElementIndex];
        var injector = isPresent(imperativelyCreatedProviders) ?
            Injector.fromResolvedProviders(imperativelyCreatedProviders) :
            null;
        this._hydrateView(view, injector, elementInjector.getHost(), contextView.context, contextView.locals);
    }
    /** @internal */
    _hydrateView(initView, imperativelyCreatedInjector, hostElementInjector, context, parentLocals) {
        var viewIdx = initView.viewOffset;
        var endViewOffset = viewIdx + initView.proto.mergeInfo.viewCount - 1;
        while (viewIdx <= endViewOffset) {
            var currView = initView.views[viewIdx];
            var currProtoView = currView.proto;
            if (currView !== initView && currView.proto.type === viewModule.ViewType.EMBEDDED) {
                // Don't hydrate components of embedded fragment views.
                viewIdx += currView.proto.mergeInfo.viewCount;
            }
            else {
                if (currView !== initView) {
                    // hydrate a nested component view
                    imperativelyCreatedInjector = null;
                    parentLocals = null;
                    hostElementInjector = currView.containerElementInjector;
                    context = hostElementInjector.getComponent();
                }
                currView.context = context;
                currView.locals.parent = parentLocals;
                var binders = currProtoView.elementBinders;
                for (var binderIdx = 0; binderIdx < binders.length; binderIdx++) {
                    var boundElementIndex = binderIdx + currView.elementOffset;
                    var elementInjector = initView.elementInjectors[boundElementIndex];
                    if (isPresent(elementInjector)) {
                        elementInjector.hydrate(imperativelyCreatedInjector, hostElementInjector, currView.preBuiltObjects[boundElementIndex]);
                        this._populateViewLocals(currView, elementInjector, boundElementIndex);
                        this._setUpEventEmitters(currView, elementInjector, boundElementIndex);
                    }
                }
                var pipes = isPresent(hostElementInjector) ?
                    new Pipes(currView.proto.pipes, hostElementInjector.getInjector()) :
                    null;
                currView.changeDetector.hydrate(currView.context, currView.locals, currView, pipes);
                viewIdx++;
            }
        }
    }
    /** @internal */
    _populateViewLocals(view, elementInjector, boundElementIdx) {
        if (isPresent(elementInjector.getDirectiveVariableBindings())) {
            elementInjector.getDirectiveVariableBindings().forEach((directiveIndex, name) => {
                if (isBlank(directiveIndex)) {
                    view.locals.set(name, view.elementRefs[boundElementIdx].nativeElement);
                }
                else {
                    view.locals.set(name, elementInjector.getDirectiveAtIndex(directiveIndex));
                }
            });
        }
    }
    /** @internal */
    _setUpEventEmitters(view, elementInjector, boundElementIndex) {
        var emitters = elementInjector.getEventEmitterAccessors();
        for (var directiveIndex = 0; directiveIndex < emitters.length; ++directiveIndex) {
            var directiveEmitters = emitters[directiveIndex];
            var directive = elementInjector.getDirectiveAtIndex(directiveIndex);
            for (var eventIndex = 0; eventIndex < directiveEmitters.length; ++eventIndex) {
                var eventEmitterAccessor = directiveEmitters[eventIndex];
                eventEmitterAccessor.subscribe(view, boundElementIndex, directive);
            }
        }
    }
    dehydrateView(initView) {
        var endViewOffset = initView.viewOffset + initView.proto.mergeInfo.viewCount - 1;
        for (var viewIdx = initView.viewOffset; viewIdx <= endViewOffset; viewIdx++) {
            var currView = initView.views[viewIdx];
            if (currView.hydrated()) {
                if (isPresent(currView.locals)) {
                    currView.locals.clearValues();
                }
                currView.context = null;
                currView.changeDetector.dehydrate();
                var binders = currView.proto.elementBinders;
                for (var binderIdx = 0; binderIdx < binders.length; binderIdx++) {
                    var eli = initView.elementInjectors[currView.elementOffset + binderIdx];
                    if (isPresent(eli)) {
                        eli.dehydrate();
                    }
                }
            }
        }
    }
};
AppViewManagerUtils = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [])
], AppViewManagerUtils);
//# sourceMappingURL=data:application/json;base64,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