/* */ 
"format cjs";
import { BaseException } from 'angular2/src/facade/exceptions';
import { ListWrapper, Map } from 'angular2/src/facade/collection';
import { isPresent } from 'angular2/src/facade/lang';
import { RenderViewRef, RenderProtoViewRef, RenderFragmentRef } from './api';
export class DefaultProtoViewRef extends RenderProtoViewRef {
    constructor(template, cmds) {
        super();
        this.template = template;
        this.cmds = cmds;
    }
}
export class DefaultRenderFragmentRef extends RenderFragmentRef {
    constructor(nodes) {
        super();
        this.nodes = nodes;
    }
}
export class DefaultRenderView extends RenderViewRef {
    constructor(fragments, boundTextNodes, boundElements, nativeShadowRoots, globalEventAdders, rootContentInsertionPoints) {
        super();
        this.fragments = fragments;
        this.boundTextNodes = boundTextNodes;
        this.boundElements = boundElements;
        this.nativeShadowRoots = nativeShadowRoots;
        this.globalEventAdders = globalEventAdders;
        this.rootContentInsertionPoints = rootContentInsertionPoints;
        this.hydrated = false;
        this.eventDispatcher = null;
        this.globalEventRemovers = null;
    }
    hydrate() {
        if (this.hydrated)
            throw new BaseException('The view is already hydrated.');
        this.hydrated = true;
        this.globalEventRemovers = ListWrapper.createFixedSize(this.globalEventAdders.length);
        for (var i = 0; i < this.globalEventAdders.length; i++) {
            this.globalEventRemovers[i] = this.globalEventAdders[i]();
        }
    }
    dehydrate() {
        if (!this.hydrated)
            throw new BaseException('The view is already dehydrated.');
        for (var i = 0; i < this.globalEventRemovers.length; i++) {
            this.globalEventRemovers[i]();
        }
        this.globalEventRemovers = null;
        this.hydrated = false;
    }
    setEventDispatcher(dispatcher) { this.eventDispatcher = dispatcher; }
    dispatchRenderEvent(boundElementIndex, eventName, event) {
        var allowDefaultBehavior = true;
        if (isPresent(this.eventDispatcher)) {
            var locals = new Map();
            locals.set('$event', event);
            allowDefaultBehavior =
                this.eventDispatcher.dispatchRenderEvent(boundElementIndex, eventName, locals);
        }
        return allowDefaultBehavior;
    }
}
//# sourceMappingURL=data:application/json;base64,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