/* */ 
"format cjs";
import { isBlank, isPresent, StringWrapper } from 'angular2/src/facade/lang';
import { DefaultRenderView, DefaultRenderFragmentRef } from './view';
import { ViewEncapsulation } from 'angular2/src/core/metadata';
import { ListWrapper } from 'angular2/src/facade/collection';
export function encapsulateStyles(componentTemplate) {
    var processedStyles = componentTemplate.styles;
    if (componentTemplate.encapsulation === ViewEncapsulation.Emulated) {
        processedStyles = ListWrapper.createFixedSize(componentTemplate.styles.length);
        for (var i = 0; i < componentTemplate.styles.length; i++) {
            processedStyles[i] = StringWrapper.replaceAll(componentTemplate.styles[i], COMPONENT_REGEX, componentTemplate.shortId);
        }
    }
    return processedStyles;
}
export function createRenderView(componentTemplate, cmds, inplaceElement, nodeFactory) {
    var view;
    var eventDispatcher = (boundElementIndex, eventName, event) => view.dispatchRenderEvent(boundElementIndex, eventName, event);
    var context = new BuildContext(eventDispatcher, nodeFactory, inplaceElement);
    context.build(componentTemplate, cmds);
    var fragments = [];
    for (var i = 0; i < context.fragments.length; i++) {
        fragments.push(new DefaultRenderFragmentRef(context.fragments[i]));
    }
    view = new DefaultRenderView(fragments, context.boundTextNodes, context.boundElements, context.nativeShadowRoots, context.globalEventAdders, context.rootContentInsertionPoints);
    return view;
}
class BuildContext {
    constructor(_eventDispatcher, factory, _inplaceElement) {
        this._eventDispatcher = _eventDispatcher;
        this.factory = factory;
        this._inplaceElement = _inplaceElement;
        this._builders = [];
        this.globalEventAdders = [];
        this.boundElements = [];
        this.boundTextNodes = [];
        this.nativeShadowRoots = [];
        this.fragments = [];
        this.rootContentInsertionPoints = [];
        this.componentCount = 0;
        this.isHost = isPresent((_inplaceElement));
    }
    build(template, cmds) {
        this.enqueueRootBuilder(template, cmds);
        this._build(this._builders[0]);
    }
    _build(builder) {
        this._builders = [];
        builder.build(this);
        var enqueuedBuilders = this._builders;
        for (var i = 0; i < enqueuedBuilders.length; i++) {
            this._build(enqueuedBuilders[i]);
        }
    }
    enqueueComponentBuilder(component) {
        this.componentCount++;
        this._builders.push(new RenderViewBuilder(component, null, component.template, component.template.commands));
    }
    enqueueFragmentBuilder(parentComponent, parentTemplate, commands) {
        var rootNodes = [];
        this.fragments.push(rootNodes);
        this._builders.push(new RenderViewBuilder(parentComponent, rootNodes, parentTemplate, commands));
    }
    enqueueRootBuilder(template, cmds) {
        var rootNodes = [];
        this.fragments.push(rootNodes);
        this._builders.push(new RenderViewBuilder(null, rootNodes, template, cmds));
    }
    consumeInplaceElement() {
        var result = this._inplaceElement;
        this._inplaceElement = null;
        return result;
    }
    addEventListener(boundElementIndex, target, eventName) {
        if (isPresent(target)) {
            var handler = createEventHandler(boundElementIndex, `${target}:${eventName}`, this._eventDispatcher);
            this.globalEventAdders.push(createGlobalEventAdder(target, eventName, handler, this.factory));
        }
        else {
            var handler = createEventHandler(boundElementIndex, eventName, this._eventDispatcher);
            this.factory.on(this.boundElements[boundElementIndex], eventName, handler);
        }
    }
}
function createEventHandler(boundElementIndex, eventName, eventDispatcher) {
    return ($event) => eventDispatcher(boundElementIndex, eventName, $event);
}
function createGlobalEventAdder(target, eventName, eventHandler, nodeFactory) {
    return () => nodeFactory.globalOn(target, eventName, eventHandler);
}
class RenderViewBuilder {
    constructor(parentComponent, fragmentRootNodes, template, cmds) {
        this.parentComponent = parentComponent;
        this.fragmentRootNodes = fragmentRootNodes;
        this.template = template;
        this.cmds = cmds;
        var rootNodesParent = isPresent(fragmentRootNodes) ? null : parentComponent.shadowRoot;
        this.parentStack = [rootNodesParent];
    }
    build(context) {
        var cmds = this.cmds;
        for (var i = 0; i < cmds.length; i++) {
            cmds[i].visit(this, context);
        }
    }
    get parent() { return this.parentStack[this.parentStack.length - 1]; }
    visitText(cmd, context) {
        var text = context.factory.createText(cmd.value);
        this._addChild(text, cmd.ngContentIndex, context);
        if (cmd.isBound) {
            context.boundTextNodes.push(text);
        }
        return null;
    }
    visitNgContent(cmd, context) {
        if (isPresent(this.parentComponent)) {
            if (this.parentComponent.isRoot) {
                var insertionPoint = context.factory.createRootContentInsertionPoint();
                if (this.parent instanceof Component) {
                    context.factory.appendChild(this.parent.shadowRoot, insertionPoint);
                }
                else {
                    context.factory.appendChild(this.parent, insertionPoint);
                }
                context.rootContentInsertionPoints.push(insertionPoint);
            }
            else {
                var projectedNodes = this.parentComponent.project(cmd.index);
                for (var i = 0; i < projectedNodes.length; i++) {
                    var node = projectedNodes[i];
                    this._addChild(node, cmd.ngContentIndex, context);
                }
            }
        }
        return null;
    }
    visitBeginElement(cmd, context) {
        this.parentStack.push(this._beginElement(cmd, context, null));
        return null;
    }
    visitEndElement(context) {
        this._endElement();
        return null;
    }
    visitBeginComponent(cmd, context) {
        var templateId = cmd.templateId;
        var tpl = context.factory.resolveComponentTemplate(templateId);
        var el = this._beginElement(cmd, context, tpl);
        var root = el;
        if (tpl.encapsulation === ViewEncapsulation.Native) {
            root = context.factory.createShadowRoot(el, templateId);
            context.nativeShadowRoots.push(root);
        }
        var isRoot = context.componentCount === 0 && context.isHost;
        var component = new Component(el, root, isRoot, tpl);
        context.enqueueComponentBuilder(component);
        this.parentStack.push(component);
        return null;
    }
    visitEndComponent(context) {
        this._endElement();
        return null;
    }
    visitEmbeddedTemplate(cmd, context) {
        var el = context.factory.createTemplateAnchor(cmd.attrNameAndValues);
        this._addChild(el, cmd.ngContentIndex, context);
        context.boundElements.push(el);
        if (cmd.isMerged) {
            context.enqueueFragmentBuilder(this.parentComponent, this.template, cmd.children);
        }
        return null;
    }
    _beginElement(cmd, context, componentTemplate) {
        var el = context.consumeInplaceElement();
        var attrNameAndValues = cmd.attrNameAndValues;
        var templateEmulatedEncapsulation = this.template.encapsulation === ViewEncapsulation.Emulated;
        var componentEmulatedEncapsulation = isPresent(componentTemplate) &&
            componentTemplate.encapsulation === ViewEncapsulation.Emulated;
        var newAttrLength = attrNameAndValues.length + (templateEmulatedEncapsulation ? 2 : 0) +
            (componentEmulatedEncapsulation ? 2 : 0);
        if (newAttrLength > attrNameAndValues.length) {
            // Note: Need to clone attrNameAndValues to make it writable!
            var newAttrNameAndValues = ListWrapper.createFixedSize(newAttrLength);
            var attrIndex;
            for (attrIndex = 0; attrIndex < attrNameAndValues.length; attrIndex++) {
                newAttrNameAndValues[attrIndex] = attrNameAndValues[attrIndex];
            }
            if (templateEmulatedEncapsulation) {
                newAttrNameAndValues[attrIndex++] = _shimContentAttribute(this.template.shortId);
                newAttrNameAndValues[attrIndex++] = '';
            }
            if (componentEmulatedEncapsulation) {
                newAttrNameAndValues[attrIndex++] = _shimHostAttribute(componentTemplate.shortId);
                newAttrNameAndValues[attrIndex++] = '';
            }
            attrNameAndValues = newAttrNameAndValues;
        }
        if (isPresent(el)) {
            context.factory.mergeElement(el, attrNameAndValues);
            this.fragmentRootNodes.push(el);
        }
        else {
            el = context.factory.createElement(cmd.name, attrNameAndValues);
            this._addChild(el, cmd.ngContentIndex, context);
        }
        if (cmd.isBound) {
            var boundElementIndex = context.boundElements.length;
            context.boundElements.push(el);
            for (var i = 0; i < cmd.eventTargetAndNames.length; i += 2) {
                var target = cmd.eventTargetAndNames[i];
                var eventName = cmd.eventTargetAndNames[i + 1];
                context.addEventListener(boundElementIndex, target, eventName);
            }
        }
        return el;
    }
    _endElement() { this.parentStack.pop(); }
    _addChild(node, ngContentIndex, context) {
        var parent = this.parent;
        if (isPresent(parent)) {
            if (parent instanceof Component) {
                parent.addContentNode(ngContentIndex, node, context);
            }
            else {
                context.factory.appendChild(parent, node);
            }
        }
        else {
            this.fragmentRootNodes.push(node);
        }
    }
}
class Component {
    constructor(hostElement, shadowRoot, isRoot, template) {
        this.hostElement = hostElement;
        this.shadowRoot = shadowRoot;
        this.isRoot = isRoot;
        this.template = template;
        this.contentNodesByNgContentIndex = [];
    }
    addContentNode(ngContentIndex, node, context) {
        if (isBlank(ngContentIndex)) {
            if (this.template.encapsulation === ViewEncapsulation.Native) {
                context.factory.appendChild(this.hostElement, node);
            }
        }
        else {
            while (this.contentNodesByNgContentIndex.length <= ngContentIndex) {
                this.contentNodesByNgContentIndex.push([]);
            }
            this.contentNodesByNgContentIndex[ngContentIndex].push(node);
        }
    }
    project(ngContentIndex) {
        return ngContentIndex < this.contentNodesByNgContentIndex.length ?
            this.contentNodesByNgContentIndex[ngContentIndex] :
            [];
    }
}
var COMPONENT_REGEX = /%COMP%/g;
export const COMPONENT_VARIABLE = '%COMP%';
export const HOST_ATTR = `_nghost-${COMPONENT_VARIABLE}`;
export const CONTENT_ATTR = `_ngcontent-${COMPONENT_VARIABLE}`;
function _shimContentAttribute(componentShortId) {
    return StringWrapper.replaceAll(CONTENT_ATTR, COMPONENT_REGEX, componentShortId);
}
function _shimHostAttribute(componentShortId) {
    return StringWrapper.replaceAll(HOST_ATTR, COMPONENT_REGEX, componentShortId);
}
//# sourceMappingURL=data:application/json;base64,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