/* */ 
(function(process) {
  'use strict';
  var __extends = (this && this.__extends) || function(d, b) {
    for (var p in b)
      if (b.hasOwnProperty(p))
        d[p] = b[p];
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var __decorate = (this && this.__decorate) || function(decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
      r = Reflect.decorate(decorators, target, key, desc);
    else
      for (var i = decorators.length - 1; i >= 0; i--)
        if (d = decorators[i])
          r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
  };
  var __metadata = (this && this.__metadata) || function(k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
      return Reflect.metadata(k, v);
  };
  var __param = (this && this.__param) || function(paramIndex, decorator) {
    return function(target, key) {
      decorator(target, key, paramIndex);
    };
  };
  var collection_1 = require('../facade/collection');
  var lang_1 = require('../facade/lang');
  var core_1 = require('../../core');
  var lang_2 = require('../facade/lang');
  var exceptions_1 = require('../facade/exceptions');
  var change_detection_1 = require('../core/change_detection/change_detection');
  var html_parser_1 = require('./html_parser');
  var html_tags_1 = require('./html_tags');
  var parse_util_1 = require('./parse_util');
  var template_ast_1 = require('./template_ast');
  var selector_1 = require('./selector');
  var element_schema_registry_1 = require('./schema/element_schema_registry');
  var template_preparser_1 = require('./template_preparser');
  var style_url_resolver_1 = require('./style_url_resolver');
  var html_ast_1 = require('./html_ast');
  var util_1 = require('./util');
  var BIND_NAME_REGEXP = /^(?:(?:(?:(bind-)|(var-|#)|(on-)|(bindon-))(.+))|\[\(([^\)]+)\)\]|\[([^\]]+)\]|\(([^\)]+)\))$/g;
  var TEMPLATE_ELEMENT = 'template';
  var TEMPLATE_ATTR = 'template';
  var TEMPLATE_ATTR_PREFIX = '*';
  var CLASS_ATTR = 'class';
  var PROPERTY_PARTS_SEPARATOR = '.';
  var ATTRIBUTE_PREFIX = 'attr';
  var CLASS_PREFIX = 'class';
  var STYLE_PREFIX = 'style';
  var TEXT_CSS_SELECTOR = selector_1.CssSelector.parse('*')[0];
  exports.TEMPLATE_TRANSFORMS = lang_2.CONST_EXPR(new core_1.OpaqueToken('TemplateTransforms'));
  var TemplateParseError = (function(_super) {
    __extends(TemplateParseError, _super);
    function TemplateParseError(message, location) {
      _super.call(this, location, message);
    }
    return TemplateParseError;
  })(parse_util_1.ParseError);
  exports.TemplateParseError = TemplateParseError;
  var TemplateParser = (function() {
    function TemplateParser(_exprParser, _schemaRegistry, _htmlParser, transforms) {
      this._exprParser = _exprParser;
      this._schemaRegistry = _schemaRegistry;
      this._htmlParser = _htmlParser;
      this.transforms = transforms;
    }
    TemplateParser.prototype.parse = function(template, directives, templateUrl) {
      var parseVisitor = new TemplateParseVisitor(directives, this._exprParser, this._schemaRegistry);
      var htmlAstWithErrors = this._htmlParser.parse(template, templateUrl);
      var result = html_ast_1.htmlVisitAll(parseVisitor, htmlAstWithErrors.rootNodes, EMPTY_COMPONENT);
      var errors = htmlAstWithErrors.errors.concat(parseVisitor.errors);
      if (errors.length > 0) {
        var errorString = errors.join('\n');
        throw new exceptions_1.BaseException("Template parse errors:\n" + errorString);
      }
      if (lang_1.isPresent(this.transforms)) {
        this.transforms.forEach(function(transform) {
          result = template_ast_1.templateVisitAll(transform, result);
        });
      }
      return result;
    };
    TemplateParser = __decorate([core_1.Injectable(), __param(3, core_1.Optional()), __param(3, core_1.Inject(exports.TEMPLATE_TRANSFORMS)), __metadata('design:paramtypes', [change_detection_1.Parser, element_schema_registry_1.ElementSchemaRegistry, html_parser_1.HtmlParser, Array])], TemplateParser);
    return TemplateParser;
  })();
  exports.TemplateParser = TemplateParser;
  var TemplateParseVisitor = (function() {
    function TemplateParseVisitor(directives, _exprParser, _schemaRegistry) {
      var _this = this;
      this._exprParser = _exprParser;
      this._schemaRegistry = _schemaRegistry;
      this.errors = [];
      this.directivesIndex = new Map();
      this.ngContentCount = 0;
      this.selectorMatcher = new selector_1.SelectorMatcher();
      collection_1.ListWrapper.forEachWithIndex(directives, function(directive, index) {
        var selector = selector_1.CssSelector.parse(directive.selector);
        _this.selectorMatcher.addSelectables(selector, directive);
        _this.directivesIndex.set(directive, index);
      });
    }
    TemplateParseVisitor.prototype._reportError = function(message, sourceSpan) {
      this.errors.push(new TemplateParseError(message, sourceSpan.start));
    };
    TemplateParseVisitor.prototype._parseInterpolation = function(value, sourceSpan) {
      var sourceInfo = sourceSpan.start.toString();
      try {
        return this._exprParser.parseInterpolation(value, sourceInfo);
      } catch (e) {
        this._reportError("" + e, sourceSpan);
        return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
      }
    };
    TemplateParseVisitor.prototype._parseAction = function(value, sourceSpan) {
      var sourceInfo = sourceSpan.start.toString();
      try {
        return this._exprParser.parseAction(value, sourceInfo);
      } catch (e) {
        this._reportError("" + e, sourceSpan);
        return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
      }
    };
    TemplateParseVisitor.prototype._parseBinding = function(value, sourceSpan) {
      var sourceInfo = sourceSpan.start.toString();
      try {
        return this._exprParser.parseBinding(value, sourceInfo);
      } catch (e) {
        this._reportError("" + e, sourceSpan);
        return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
      }
    };
    TemplateParseVisitor.prototype._parseTemplateBindings = function(value, sourceSpan) {
      var sourceInfo = sourceSpan.start.toString();
      try {
        return this._exprParser.parseTemplateBindings(value, sourceInfo);
      } catch (e) {
        this._reportError("" + e, sourceSpan);
        return [];
      }
    };
    TemplateParseVisitor.prototype.visitText = function(ast, component) {
      var ngContentIndex = component.findNgContentIndex(TEXT_CSS_SELECTOR);
      var expr = this._parseInterpolation(ast.value, ast.sourceSpan);
      if (lang_1.isPresent(expr)) {
        return new template_ast_1.BoundTextAst(expr, ngContentIndex, ast.sourceSpan);
      } else {
        return new template_ast_1.TextAst(ast.value, ngContentIndex, ast.sourceSpan);
      }
    };
    TemplateParseVisitor.prototype.visitAttr = function(ast, contex) {
      return new template_ast_1.AttrAst(ast.name, ast.value, ast.sourceSpan);
    };
    TemplateParseVisitor.prototype.visitElement = function(element, component) {
      var _this = this;
      var nodeName = element.name;
      var preparsedElement = template_preparser_1.preparseElement(element);
      if (preparsedElement.type === template_preparser_1.PreparsedElementType.SCRIPT || preparsedElement.type === template_preparser_1.PreparsedElementType.STYLE) {
        return null;
      }
      if (preparsedElement.type === template_preparser_1.PreparsedElementType.STYLESHEET && style_url_resolver_1.isStyleUrlResolvable(preparsedElement.hrefAttr)) {
        return null;
      }
      var matchableAttrs = [];
      var elementOrDirectiveProps = [];
      var vars = [];
      var events = [];
      var templateElementOrDirectiveProps = [];
      var templateVars = [];
      var templateMatchableAttrs = [];
      var hasInlineTemplates = false;
      var attrs = [];
      element.attrs.forEach(function(attr) {
        matchableAttrs.push([attr.name, attr.value]);
        var hasBinding = _this._parseAttr(attr, matchableAttrs, elementOrDirectiveProps, events, vars);
        var hasTemplateBinding = _this._parseInlineTemplateBinding(attr, templateMatchableAttrs, templateElementOrDirectiveProps, templateVars);
        if (!hasBinding && !hasTemplateBinding) {
          attrs.push(_this.visitAttr(attr, null));
        }
        if (hasTemplateBinding) {
          hasInlineTemplates = true;
        }
      });
      var lcElName = html_tags_1.splitNsName(nodeName.toLowerCase())[1];
      var isTemplateElement = lcElName == TEMPLATE_ELEMENT;
      var elementCssSelector = createElementCssSelector(nodeName, matchableAttrs);
      var directives = this._createDirectiveAsts(element.name, this._parseDirectives(this.selectorMatcher, elementCssSelector), elementOrDirectiveProps, isTemplateElement ? [] : vars, element.sourceSpan);
      var elementProps = this._createElementPropertyAsts(element.name, elementOrDirectiveProps, directives);
      var children = html_ast_1.htmlVisitAll(preparsedElement.nonBindable ? NON_BINDABLE_VISITOR : this, element.children, Component.create(directives));
      var elementNgContentIndex = hasInlineTemplates ? null : component.findNgContentIndex(elementCssSelector);
      var parsedElement;
      if (preparsedElement.type === template_preparser_1.PreparsedElementType.NG_CONTENT) {
        if (lang_1.isPresent(element.children) && element.children.length > 0) {
          this._reportError("<ng-content> element cannot have content. <ng-content> must be immediately followed by </ng-content>", element.sourceSpan);
        }
        parsedElement = new template_ast_1.NgContentAst(this.ngContentCount++, elementNgContentIndex, element.sourceSpan);
      } else if (isTemplateElement) {
        this._assertAllEventsPublishedByDirectives(directives, events);
        this._assertNoComponentsNorElementBindingsOnTemplate(directives, elementProps, element.sourceSpan);
        parsedElement = new template_ast_1.EmbeddedTemplateAst(attrs, events, vars, directives, children, elementNgContentIndex, element.sourceSpan);
      } else {
        this._assertOnlyOneComponent(directives, element.sourceSpan);
        var elementExportAsVars = vars.filter(function(varAst) {
          return varAst.value.length === 0;
        });
        parsedElement = new template_ast_1.ElementAst(nodeName, attrs, elementProps, events, elementExportAsVars, directives, children, elementNgContentIndex, element.sourceSpan);
      }
      if (hasInlineTemplates) {
        var templateCssSelector = createElementCssSelector(TEMPLATE_ELEMENT, templateMatchableAttrs);
        var templateDirectives = this._createDirectiveAsts(element.name, this._parseDirectives(this.selectorMatcher, templateCssSelector), templateElementOrDirectiveProps, [], element.sourceSpan);
        var templateElementProps = this._createElementPropertyAsts(element.name, templateElementOrDirectiveProps, templateDirectives);
        this._assertNoComponentsNorElementBindingsOnTemplate(templateDirectives, templateElementProps, element.sourceSpan);
        parsedElement = new template_ast_1.EmbeddedTemplateAst([], [], templateVars, templateDirectives, [parsedElement], component.findNgContentIndex(templateCssSelector), element.sourceSpan);
      }
      return parsedElement;
    };
    TemplateParseVisitor.prototype._parseInlineTemplateBinding = function(attr, targetMatchableAttrs, targetProps, targetVars) {
      var templateBindingsSource = null;
      if (attr.name == TEMPLATE_ATTR) {
        templateBindingsSource = attr.value;
      } else if (attr.name.startsWith(TEMPLATE_ATTR_PREFIX)) {
        var key = attr.name.substring(TEMPLATE_ATTR_PREFIX.length);
        templateBindingsSource = (attr.value.length == 0) ? key : key + ' ' + attr.value;
      }
      if (lang_1.isPresent(templateBindingsSource)) {
        var bindings = this._parseTemplateBindings(templateBindingsSource, attr.sourceSpan);
        for (var i = 0; i < bindings.length; i++) {
          var binding = bindings[i];
          if (binding.keyIsVar) {
            targetVars.push(new template_ast_1.VariableAst(binding.key, binding.name, attr.sourceSpan));
            targetMatchableAttrs.push([binding.key, binding.name]);
          } else if (lang_1.isPresent(binding.expression)) {
            this._parsePropertyAst(binding.key, binding.expression, attr.sourceSpan, targetMatchableAttrs, targetProps);
          } else {
            targetMatchableAttrs.push([binding.key, '']);
            this._parseLiteralAttr(binding.key, null, attr.sourceSpan, targetProps);
          }
        }
        return true;
      }
      return false;
    };
    TemplateParseVisitor.prototype._parseAttr = function(attr, targetMatchableAttrs, targetProps, targetEvents, targetVars) {
      var attrName = this._normalizeAttributeName(attr.name);
      var attrValue = attr.value;
      var bindParts = lang_1.RegExpWrapper.firstMatch(BIND_NAME_REGEXP, attrName);
      var hasBinding = false;
      if (lang_1.isPresent(bindParts)) {
        hasBinding = true;
        if (lang_1.isPresent(bindParts[1])) {
          this._parseProperty(bindParts[5], attrValue, attr.sourceSpan, targetMatchableAttrs, targetProps);
        } else if (lang_1.isPresent(bindParts[2])) {
          var identifier = bindParts[5];
          this._parseVariable(identifier, attrValue, attr.sourceSpan, targetVars);
        } else if (lang_1.isPresent(bindParts[3])) {
          this._parseEvent(bindParts[5], attrValue, attr.sourceSpan, targetMatchableAttrs, targetEvents);
        } else if (lang_1.isPresent(bindParts[4])) {
          this._parseProperty(bindParts[5], attrValue, attr.sourceSpan, targetMatchableAttrs, targetProps);
          this._parseAssignmentEvent(bindParts[5], attrValue, attr.sourceSpan, targetMatchableAttrs, targetEvents);
        } else if (lang_1.isPresent(bindParts[6])) {
          this._parseProperty(bindParts[6], attrValue, attr.sourceSpan, targetMatchableAttrs, targetProps);
          this._parseAssignmentEvent(bindParts[6], attrValue, attr.sourceSpan, targetMatchableAttrs, targetEvents);
        } else if (lang_1.isPresent(bindParts[7])) {
          this._parseProperty(bindParts[7], attrValue, attr.sourceSpan, targetMatchableAttrs, targetProps);
        } else if (lang_1.isPresent(bindParts[8])) {
          this._parseEvent(bindParts[8], attrValue, attr.sourceSpan, targetMatchableAttrs, targetEvents);
        }
      } else {
        hasBinding = this._parsePropertyInterpolation(attrName, attrValue, attr.sourceSpan, targetMatchableAttrs, targetProps);
      }
      if (!hasBinding) {
        this._parseLiteralAttr(attrName, attrValue, attr.sourceSpan, targetProps);
      }
      return hasBinding;
    };
    TemplateParseVisitor.prototype._normalizeAttributeName = function(attrName) {
      return attrName.toLowerCase().startsWith('data-') ? attrName.substring(5) : attrName;
    };
    TemplateParseVisitor.prototype._parseVariable = function(identifier, value, sourceSpan, targetVars) {
      if (identifier.indexOf('-') > -1) {
        this._reportError("\"-\" is not allowed in variable names", sourceSpan);
      }
      targetVars.push(new template_ast_1.VariableAst(identifier, value, sourceSpan));
    };
    TemplateParseVisitor.prototype._parseProperty = function(name, expression, sourceSpan, targetMatchableAttrs, targetProps) {
      this._parsePropertyAst(name, this._parseBinding(expression, sourceSpan), sourceSpan, targetMatchableAttrs, targetProps);
    };
    TemplateParseVisitor.prototype._parsePropertyInterpolation = function(name, value, sourceSpan, targetMatchableAttrs, targetProps) {
      var expr = this._parseInterpolation(value, sourceSpan);
      if (lang_1.isPresent(expr)) {
        this._parsePropertyAst(name, expr, sourceSpan, targetMatchableAttrs, targetProps);
        return true;
      }
      return false;
    };
    TemplateParseVisitor.prototype._parsePropertyAst = function(name, ast, sourceSpan, targetMatchableAttrs, targetProps) {
      targetMatchableAttrs.push([name, ast.source]);
      targetProps.push(new BoundElementOrDirectiveProperty(name, ast, false, sourceSpan));
    };
    TemplateParseVisitor.prototype._parseAssignmentEvent = function(name, expression, sourceSpan, targetMatchableAttrs, targetEvents) {
      this._parseEvent(name + "Change", expression + "=$event", sourceSpan, targetMatchableAttrs, targetEvents);
    };
    TemplateParseVisitor.prototype._parseEvent = function(name, expression, sourceSpan, targetMatchableAttrs, targetEvents) {
      var parts = util_1.splitAtColon(name, [null, name]);
      var target = parts[0];
      var eventName = parts[1];
      targetEvents.push(new template_ast_1.BoundEventAst(eventName, target, this._parseAction(expression, sourceSpan), sourceSpan));
    };
    TemplateParseVisitor.prototype._parseLiteralAttr = function(name, value, sourceSpan, targetProps) {
      targetProps.push(new BoundElementOrDirectiveProperty(name, this._exprParser.wrapLiteralPrimitive(value, ''), true, sourceSpan));
    };
    TemplateParseVisitor.prototype._parseDirectives = function(selectorMatcher, elementCssSelector) {
      var _this = this;
      var directives = [];
      selectorMatcher.match(elementCssSelector, function(selector, directive) {
        directives.push(directive);
      });
      collection_1.ListWrapper.sort(directives, function(dir1, dir2) {
        var dir1Comp = dir1.isComponent;
        var dir2Comp = dir2.isComponent;
        if (dir1Comp && !dir2Comp) {
          return -1;
        } else if (!dir1Comp && dir2Comp) {
          return 1;
        } else {
          return _this.directivesIndex.get(dir1) - _this.directivesIndex.get(dir2);
        }
      });
      return directives;
    };
    TemplateParseVisitor.prototype._createDirectiveAsts = function(elementName, directives, props, possibleExportAsVars, sourceSpan) {
      var _this = this;
      var matchedVariables = new Set();
      var directiveAsts = directives.map(function(directive) {
        var hostProperties = [];
        var hostEvents = [];
        var directiveProperties = [];
        _this._createDirectiveHostPropertyAsts(elementName, directive.hostProperties, sourceSpan, hostProperties);
        _this._createDirectiveHostEventAsts(directive.hostListeners, sourceSpan, hostEvents);
        _this._createDirectivePropertyAsts(directive.inputs, props, directiveProperties);
        var exportAsVars = [];
        possibleExportAsVars.forEach(function(varAst) {
          if ((varAst.value.length === 0 && directive.isComponent) || (directive.exportAs == varAst.value)) {
            exportAsVars.push(varAst);
            matchedVariables.add(varAst.name);
          }
        });
        return new template_ast_1.DirectiveAst(directive, directiveProperties, hostProperties, hostEvents, exportAsVars, sourceSpan);
      });
      possibleExportAsVars.forEach(function(varAst) {
        if (varAst.value.length > 0 && !collection_1.SetWrapper.has(matchedVariables, varAst.name)) {
          _this._reportError("There is no directive with \"exportAs\" set to \"" + varAst.value + "\"", varAst.sourceSpan);
        }
      });
      return directiveAsts;
    };
    TemplateParseVisitor.prototype._createDirectiveHostPropertyAsts = function(elementName, hostProps, sourceSpan, targetPropertyAsts) {
      var _this = this;
      if (lang_1.isPresent(hostProps)) {
        collection_1.StringMapWrapper.forEach(hostProps, function(expression, propName) {
          var exprAst = _this._parseBinding(expression, sourceSpan);
          targetPropertyAsts.push(_this._createElementPropertyAst(elementName, propName, exprAst, sourceSpan));
        });
      }
    };
    TemplateParseVisitor.prototype._createDirectiveHostEventAsts = function(hostListeners, sourceSpan, targetEventAsts) {
      var _this = this;
      if (lang_1.isPresent(hostListeners)) {
        collection_1.StringMapWrapper.forEach(hostListeners, function(expression, propName) {
          _this._parseEvent(propName, expression, sourceSpan, [], targetEventAsts);
        });
      }
    };
    TemplateParseVisitor.prototype._createDirectivePropertyAsts = function(directiveProperties, boundProps, targetBoundDirectiveProps) {
      if (lang_1.isPresent(directiveProperties)) {
        var boundPropsByName = new Map();
        boundProps.forEach(function(boundProp) {
          var prevValue = boundPropsByName.get(boundProp.name);
          if (lang_1.isBlank(prevValue) || prevValue.isLiteral) {
            boundPropsByName.set(boundProp.name, boundProp);
          }
        });
        collection_1.StringMapWrapper.forEach(directiveProperties, function(elProp, dirProp) {
          var boundProp = boundPropsByName.get(elProp);
          if (lang_1.isPresent(boundProp)) {
            targetBoundDirectiveProps.push(new template_ast_1.BoundDirectivePropertyAst(dirProp, boundProp.name, boundProp.expression, boundProp.sourceSpan));
          }
        });
      }
    };
    TemplateParseVisitor.prototype._createElementPropertyAsts = function(elementName, props, directives) {
      var _this = this;
      var boundElementProps = [];
      var boundDirectivePropsIndex = new Map();
      directives.forEach(function(directive) {
        directive.inputs.forEach(function(prop) {
          boundDirectivePropsIndex.set(prop.templateName, prop);
        });
      });
      props.forEach(function(prop) {
        if (!prop.isLiteral && lang_1.isBlank(boundDirectivePropsIndex.get(prop.name))) {
          boundElementProps.push(_this._createElementPropertyAst(elementName, prop.name, prop.expression, prop.sourceSpan));
        }
      });
      return boundElementProps;
    };
    TemplateParseVisitor.prototype._createElementPropertyAst = function(elementName, name, ast, sourceSpan) {
      var unit = null;
      var bindingType;
      var boundPropertyName;
      var parts = name.split(PROPERTY_PARTS_SEPARATOR);
      if (parts.length === 1) {
        boundPropertyName = this._schemaRegistry.getMappedPropName(parts[0]);
        bindingType = template_ast_1.PropertyBindingType.Property;
        if (!this._schemaRegistry.hasProperty(elementName, boundPropertyName)) {
          this._reportError("Can't bind to '" + boundPropertyName + "' since it isn't a known native property", sourceSpan);
        }
      } else {
        if (parts[0] == ATTRIBUTE_PREFIX) {
          boundPropertyName = parts[1];
          bindingType = template_ast_1.PropertyBindingType.Attribute;
        } else if (parts[0] == CLASS_PREFIX) {
          boundPropertyName = parts[1];
          bindingType = template_ast_1.PropertyBindingType.Class;
        } else if (parts[0] == STYLE_PREFIX) {
          unit = parts.length > 2 ? parts[2] : null;
          boundPropertyName = parts[1];
          bindingType = template_ast_1.PropertyBindingType.Style;
        } else {
          this._reportError("Invalid property name '" + name + "'", sourceSpan);
          bindingType = null;
        }
      }
      return new template_ast_1.BoundElementPropertyAst(boundPropertyName, bindingType, ast, unit, sourceSpan);
    };
    TemplateParseVisitor.prototype._findComponentDirectiveNames = function(directives) {
      var componentTypeNames = [];
      directives.forEach(function(directive) {
        var typeName = directive.directive.type.name;
        if (directive.directive.isComponent) {
          componentTypeNames.push(typeName);
        }
      });
      return componentTypeNames;
    };
    TemplateParseVisitor.prototype._assertOnlyOneComponent = function(directives, sourceSpan) {
      var componentTypeNames = this._findComponentDirectiveNames(directives);
      if (componentTypeNames.length > 1) {
        this._reportError("More than one component: " + componentTypeNames.join(','), sourceSpan);
      }
    };
    TemplateParseVisitor.prototype._assertNoComponentsNorElementBindingsOnTemplate = function(directives, elementProps, sourceSpan) {
      var _this = this;
      var componentTypeNames = this._findComponentDirectiveNames(directives);
      if (componentTypeNames.length > 0) {
        this._reportError("Components on an embedded template: " + componentTypeNames.join(','), sourceSpan);
      }
      elementProps.forEach(function(prop) {
        _this._reportError("Property binding " + prop.name + " not used by any directive on an embedded template", sourceSpan);
      });
    };
    TemplateParseVisitor.prototype._assertAllEventsPublishedByDirectives = function(directives, events) {
      var _this = this;
      var allDirectiveEvents = new Set();
      directives.forEach(function(directive) {
        collection_1.StringMapWrapper.forEach(directive.directive.outputs, function(eventName, _) {
          allDirectiveEvents.add(eventName);
        });
      });
      events.forEach(function(event) {
        if (lang_1.isPresent(event.target) || !collection_1.SetWrapper.has(allDirectiveEvents, event.name)) {
          _this._reportError("Event binding " + event.fullName + " not emitted by any directive on an embedded template", event.sourceSpan);
        }
      });
    };
    return TemplateParseVisitor;
  })();
  var NonBindableVisitor = (function() {
    function NonBindableVisitor() {}
    NonBindableVisitor.prototype.visitElement = function(ast, component) {
      var preparsedElement = template_preparser_1.preparseElement(ast);
      if (preparsedElement.type === template_preparser_1.PreparsedElementType.SCRIPT || preparsedElement.type === template_preparser_1.PreparsedElementType.STYLE || preparsedElement.type === template_preparser_1.PreparsedElementType.STYLESHEET) {
        return null;
      }
      var attrNameAndValues = ast.attrs.map(function(attrAst) {
        return [attrAst.name, attrAst.value];
      });
      var selector = createElementCssSelector(ast.name, attrNameAndValues);
      var ngContentIndex = component.findNgContentIndex(selector);
      var children = html_ast_1.htmlVisitAll(this, ast.children, EMPTY_COMPONENT);
      return new template_ast_1.ElementAst(ast.name, html_ast_1.htmlVisitAll(this, ast.attrs), [], [], [], [], children, ngContentIndex, ast.sourceSpan);
    };
    NonBindableVisitor.prototype.visitAttr = function(ast, context) {
      return new template_ast_1.AttrAst(ast.name, ast.value, ast.sourceSpan);
    };
    NonBindableVisitor.prototype.visitText = function(ast, component) {
      var ngContentIndex = component.findNgContentIndex(TEXT_CSS_SELECTOR);
      return new template_ast_1.TextAst(ast.value, ngContentIndex, ast.sourceSpan);
    };
    return NonBindableVisitor;
  })();
  var BoundElementOrDirectiveProperty = (function() {
    function BoundElementOrDirectiveProperty(name, expression, isLiteral, sourceSpan) {
      this.name = name;
      this.expression = expression;
      this.isLiteral = isLiteral;
      this.sourceSpan = sourceSpan;
    }
    return BoundElementOrDirectiveProperty;
  })();
  function splitClasses(classAttrValue) {
    return lang_1.StringWrapper.split(classAttrValue.trim(), /\s+/g);
  }
  exports.splitClasses = splitClasses;
  var Component = (function() {
    function Component(ngContentIndexMatcher, wildcardNgContentIndex) {
      this.ngContentIndexMatcher = ngContentIndexMatcher;
      this.wildcardNgContentIndex = wildcardNgContentIndex;
    }
    Component.create = function(directives) {
      if (directives.length === 0 || !directives[0].directive.isComponent) {
        return EMPTY_COMPONENT;
      }
      var matcher = new selector_1.SelectorMatcher();
      var ngContentSelectors = directives[0].directive.template.ngContentSelectors;
      var wildcardNgContentIndex = null;
      for (var i = 0; i < ngContentSelectors.length; i++) {
        var selector = ngContentSelectors[i];
        if (lang_1.StringWrapper.equals(selector, '*')) {
          wildcardNgContentIndex = i;
        } else {
          matcher.addSelectables(selector_1.CssSelector.parse(ngContentSelectors[i]), i);
        }
      }
      return new Component(matcher, wildcardNgContentIndex);
    };
    Component.prototype.findNgContentIndex = function(selector) {
      var ngContentIndices = [];
      this.ngContentIndexMatcher.match(selector, function(selector, ngContentIndex) {
        ngContentIndices.push(ngContentIndex);
      });
      collection_1.ListWrapper.sort(ngContentIndices);
      if (lang_1.isPresent(this.wildcardNgContentIndex)) {
        ngContentIndices.push(this.wildcardNgContentIndex);
      }
      return ngContentIndices.length > 0 ? ngContentIndices[0] : null;
    };
    return Component;
  })();
  function createElementCssSelector(elementName, matchableAttrs) {
    var cssSelector = new selector_1.CssSelector();
    var elNameNoNs = html_tags_1.splitNsName(elementName)[1];
    cssSelector.setElement(elNameNoNs);
    for (var i = 0; i < matchableAttrs.length; i++) {
      var attrName = matchableAttrs[i][0];
      var attrNameNoNs = html_tags_1.splitNsName(attrName)[1];
      var attrValue = matchableAttrs[i][1];
      cssSelector.addAttribute(attrNameNoNs, attrValue);
      if (attrName.toLowerCase() == CLASS_ATTR) {
        var classes = splitClasses(attrValue);
        classes.forEach(function(className) {
          return cssSelector.addClassName(className);
        });
      }
    }
    return cssSelector;
  }
  var EMPTY_COMPONENT = new Component(new selector_1.SelectorMatcher(), null);
  var NON_BINDABLE_VISITOR = new NonBindableVisitor();
})(require('process'));
