/* */ 
'use strict';
var lang_1 = require('../facade/lang');
var instruction_1 = require('./instruction');
var AsyncRouteHandler = (function() {
  function AsyncRouteHandler(_loader, data) {
    if (data === void 0) {
      data = null;
    }
    this._loader = _loader;
    this._resolvedComponent = null;
    this.data = lang_1.isPresent(data) ? new instruction_1.RouteData(data) : instruction_1.BLANK_ROUTE_DATA;
  }
  AsyncRouteHandler.prototype.resolveComponentType = function() {
    var _this = this;
    if (lang_1.isPresent(this._resolvedComponent)) {
      return this._resolvedComponent;
    }
    return this._resolvedComponent = this._loader().then(function(componentType) {
      _this.componentType = componentType;
      return componentType;
    });
  };
  return AsyncRouteHandler;
})();
exports.AsyncRouteHandler = AsyncRouteHandler;
