/* */ 
var compactable = require('./compactable');
function populateComponents(properties, validator) {
  for (var i = properties.length - 1; i >= 0; i--) {
    var property = properties[i];
    var descriptor = compactable[property.name];
    if (descriptor && descriptor.shorthand) {
      property.shorthand = true;
      property.dirty = true;
      property.components = descriptor.breakUp(property, compactable, validator);
      if (property.components.length > 0)
        property.multiplex = property.components[0].multiplex;
      else
        property.unused = true;
    }
  }
}
module.exports = populateComponents;
