/* */ 
(function(Buffer) {
  var crypto = require('../browser');
  var test = require('tape');
  var fs = require('fs');
  test('node tests', function(t) {
    var certPem = fs.readFileSync(__dirname + '/test_cert.pem', 'ascii');
    var keyPem = fs.readFileSync(__dirname + '/test_key.pem', 'ascii');
    var rsaPubPem = fs.readFileSync(__dirname + '/test_rsa_pubkey.pem', 'ascii');
    var rsaKeyPem = fs.readFileSync(__dirname + '/test_rsa_privkey.pem', 'ascii');
    var rsaKeyPemEncrypted = fs.readFileSync(__dirname + '/test_rsa_privkey_encrypted.pem', 'ascii');
    var input = 'I AM THE WALRUS';
    var bufferToEncrypt = new Buffer(input);
    var encryptedBuffer = crypto.publicEncrypt(rsaPubPem, bufferToEncrypt);
    var decryptedBuffer = crypto.privateDecrypt(rsaKeyPem, encryptedBuffer);
    t.equal(input, decryptedBuffer.toString());
    var decryptedBufferWithPassword = crypto.privateDecrypt({
      key: rsaKeyPemEncrypted,
      passphrase: 'password'
    }, encryptedBuffer);
    t.equal(input, decryptedBufferWithPassword.toString());
    encryptedBuffer = crypto.publicEncrypt(keyPem, bufferToEncrypt);
    decryptedBuffer = crypto.privateDecrypt(keyPem, encryptedBuffer);
    t.equal(input, decryptedBuffer.toString());
    encryptedBuffer = crypto.privateEncrypt(keyPem, bufferToEncrypt);
    decryptedBuffer = crypto.publicDecrypt(keyPem, encryptedBuffer);
    t.equal(input, decryptedBuffer.toString());
    t.throws(function() {
      crypto.privateDecrypt({
        key: rsaKeyPemEncrypted,
        passphrase: 'wrong'
      }, encryptedBuffer);
    });
    t.end();
  });
})(require('buffer').Buffer);
