/* */ 
var __extends = (this && this.__extends) || function(d, b) {
  for (var p in b)
    if (b.hasOwnProperty(p))
      d[p] = b[p];
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var noop_1 = require('./util/noop');
var throwError_1 = require('./util/throwError');
var tryOrOnError_1 = require('./util/tryOrOnError');
var Subscription_1 = require('./Subscription');
var rxSubscriber_1 = require('./symbol/rxSubscriber');
var Subscriber = (function(_super) {
  __extends(Subscriber, _super);
  function Subscriber(destination) {
    _super.call(this);
    this.destination = destination;
    this._isUnsubscribed = false;
    if (!this.destination) {
      return;
    }
    var subscription = destination._subscription;
    if (subscription) {
      this._subscription = subscription;
    } else if (destination instanceof Subscriber) {
      this._subscription = destination;
    }
  }
  Subscriber.prototype[rxSubscriber_1.rxSubscriber] = function() {
    return this;
  };
  Object.defineProperty(Subscriber.prototype, "isUnsubscribed", {
    get: function() {
      var subscription = this._subscription;
      if (subscription) {
        return this._isUnsubscribed || subscription.isUnsubscribed;
      } else {
        return this._isUnsubscribed;
      }
    },
    set: function(value) {
      var subscription = this._subscription;
      if (subscription) {
        subscription.isUnsubscribed = Boolean(value);
      } else {
        this._isUnsubscribed = Boolean(value);
      }
    },
    enumerable: true,
    configurable: true
  });
  Subscriber.create = function(next, error, complete) {
    var subscriber = new Subscriber();
    subscriber._next = (typeof next === 'function') && tryOrOnError_1.tryOrOnError(next) || noop_1.noop;
    subscriber._error = (typeof error === 'function') && error || throwError_1.throwError;
    subscriber._complete = (typeof complete === 'function') && complete || noop_1.noop;
    return subscriber;
  };
  Subscriber.prototype.add = function(sub) {
    var _subscription = this._subscription;
    if (_subscription) {
      _subscription.add(sub);
    } else {
      _super.prototype.add.call(this, sub);
    }
  };
  Subscriber.prototype.remove = function(sub) {
    if (this._subscription) {
      this._subscription.remove(sub);
    } else {
      _super.prototype.remove.call(this, sub);
    }
  };
  Subscriber.prototype.unsubscribe = function() {
    if (this._isUnsubscribed) {
      return;
    } else if (this._subscription) {
      this._isUnsubscribed = true;
    } else {
      _super.prototype.unsubscribe.call(this);
    }
  };
  Subscriber.prototype._next = function(value) {
    var destination = this.destination;
    if (destination.next) {
      destination.next(value);
    }
  };
  Subscriber.prototype._error = function(err) {
    var destination = this.destination;
    if (destination.error) {
      destination.error(err);
    }
  };
  Subscriber.prototype._complete = function() {
    var destination = this.destination;
    if (destination.complete) {
      destination.complete();
    }
  };
  Subscriber.prototype.next = function(value) {
    if (!this.isUnsubscribed) {
      this._next(value);
    }
  };
  Subscriber.prototype.error = function(err) {
    if (!this.isUnsubscribed) {
      this._error(err);
      this.unsubscribe();
    }
  };
  Subscriber.prototype.complete = function() {
    if (!this.isUnsubscribed) {
      this._complete();
      this.unsubscribe();
    }
  };
  return Subscriber;
})(Subscription_1.Subscription);
exports.Subscriber = Subscriber;
