/* */ 
var __extends = (this && this.__extends) || function(d, b) {
  for (var p in b)
    if (b.hasOwnProperty(p))
      d[p] = b[p];
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Subscriber_1 = require('../Subscriber');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
function scan(accumulator, seed) {
  return this.lift(new ScanOperator(accumulator, seed));
}
exports.scan = scan;
var ScanOperator = (function() {
  function ScanOperator(accumulator, seed) {
    this.accumulator = accumulator;
    this.seed = seed;
  }
  ScanOperator.prototype.call = function(subscriber) {
    return new ScanSubscriber(subscriber, this.accumulator, this.seed);
  };
  return ScanOperator;
})();
var ScanSubscriber = (function(_super) {
  __extends(ScanSubscriber, _super);
  function ScanSubscriber(destination, accumulator, seed) {
    _super.call(this, destination);
    this.accumulator = accumulator;
    this.accumulatorSet = false;
    this.seed = seed;
    this.accumulator = accumulator;
    this.accumulatorSet = typeof seed !== 'undefined';
  }
  Object.defineProperty(ScanSubscriber.prototype, "seed", {
    get: function() {
      return this._seed;
    },
    set: function(value) {
      this.accumulatorSet = true;
      this._seed = value;
    },
    enumerable: true,
    configurable: true
  });
  ScanSubscriber.prototype._next = function(value) {
    if (!this.accumulatorSet) {
      this.seed = value;
      this.destination.next(value);
    } else {
      var result = tryCatch_1.tryCatch(this.accumulator).call(this, this.seed, value);
      if (result === errorObject_1.errorObject) {
        this.destination.error(errorObject_1.errorObject.e);
      } else {
        this.seed = result;
        this.destination.next(this.seed);
      }
    }
  };
  return ScanSubscriber;
})(Subscriber_1.Subscriber);
