/* */ 
var __extends = (this && this.__extends) || function(d, b) {
  for (var p in b)
    if (b.hasOwnProperty(p))
      d[p] = b[p];
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Subscriber_1 = require('../Subscriber');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
function skipWhile(predicate) {
  return this.lift(new SkipWhileOperator(predicate));
}
exports.skipWhile = skipWhile;
var SkipWhileOperator = (function() {
  function SkipWhileOperator(predicate) {
    this.predicate = predicate;
  }
  SkipWhileOperator.prototype.call = function(subscriber) {
    return new SkipWhileSubscriber(subscriber, this.predicate);
  };
  return SkipWhileOperator;
})();
var SkipWhileSubscriber = (function(_super) {
  __extends(SkipWhileSubscriber, _super);
  function SkipWhileSubscriber(destination, predicate) {
    _super.call(this, destination);
    this.predicate = predicate;
    this.skipping = true;
    this.index = 0;
  }
  SkipWhileSubscriber.prototype._next = function(value) {
    var destination = this.destination;
    if (this.skipping === true) {
      var index = this.index++;
      var result = tryCatch_1.tryCatch(this.predicate)(value, index);
      if (result === errorObject_1.errorObject) {
        destination.error(result.e);
      } else {
        this.skipping = Boolean(result);
      }
    }
    if (this.skipping === false) {
      destination.next(value);
    }
  };
  return SkipWhileSubscriber;
})(Subscriber_1.Subscriber);
