/* */ 
var __extends = (this && this.__extends) || function(d, b) {
  for (var p in b)
    if (b.hasOwnProperty(p))
      d[p] = b[p];
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Subscriber_1 = require('../Subscriber');
var tryCatch_1 = require('../util/tryCatch');
var errorObject_1 = require('../util/errorObject');
function takeWhile(predicate) {
  return this.lift(new TakeWhileOperator(predicate));
}
exports.takeWhile = takeWhile;
var TakeWhileOperator = (function() {
  function TakeWhileOperator(predicate) {
    this.predicate = predicate;
  }
  TakeWhileOperator.prototype.call = function(subscriber) {
    return new TakeWhileSubscriber(subscriber, this.predicate);
  };
  return TakeWhileOperator;
})();
var TakeWhileSubscriber = (function(_super) {
  __extends(TakeWhileSubscriber, _super);
  function TakeWhileSubscriber(destination, predicate) {
    _super.call(this, destination);
    this.predicate = predicate;
    this.index = 0;
  }
  TakeWhileSubscriber.prototype._next = function(value) {
    var destination = this.destination;
    var result = tryCatch_1.tryCatch(this.predicate)(value, this.index++);
    if (result == errorObject_1.errorObject) {
      destination.error(result.e);
    } else if (Boolean(result)) {
      destination.next(value);
    } else {
      destination.complete();
    }
  };
  return TakeWhileSubscriber;
})(Subscriber_1.Subscriber);
