/* */ 
var __extends = (this && this.__extends) || function(d, b) {
  for (var p in b)
    if (b.hasOwnProperty(p))
      d[p] = b[p];
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Subscriber_1 = require('../Subscriber');
var Subject_1 = require('../Subject');
function windowCount(windowSize, startWindowEvery) {
  if (startWindowEvery === void 0) {
    startWindowEvery = 0;
  }
  return this.lift(new WindowCountOperator(windowSize, startWindowEvery));
}
exports.windowCount = windowCount;
var WindowCountOperator = (function() {
  function WindowCountOperator(windowSize, startWindowEvery) {
    this.windowSize = windowSize;
    this.startWindowEvery = startWindowEvery;
  }
  WindowCountOperator.prototype.call = function(subscriber) {
    return new WindowCountSubscriber(subscriber, this.windowSize, this.startWindowEvery);
  };
  return WindowCountOperator;
})();
var WindowCountSubscriber = (function(_super) {
  __extends(WindowCountSubscriber, _super);
  function WindowCountSubscriber(destination, windowSize, startWindowEvery) {
    _super.call(this, destination);
    this.destination = destination;
    this.windowSize = windowSize;
    this.startWindowEvery = startWindowEvery;
    this.windows = [new Subject_1.Subject()];
    this.count = 0;
    var firstWindow = this.windows[0];
    destination.add(firstWindow);
    destination.next(firstWindow);
  }
  WindowCountSubscriber.prototype._next = function(value) {
    var startWindowEvery = (this.startWindowEvery > 0) ? this.startWindowEvery : this.windowSize;
    var destination = this.destination;
    var windowSize = this.windowSize;
    var windows = this.windows;
    var len = windows.length;
    for (var i = 0; i < len; i++) {
      windows[i].next(value);
    }
    var c = this.count - windowSize + 1;
    if (c >= 0 && c % startWindowEvery === 0) {
      windows.shift().complete();
    }
    if (++this.count % startWindowEvery === 0) {
      var window_1 = new Subject_1.Subject();
      windows.push(window_1);
      destination.add(window_1);
      destination.next(window_1);
    }
  };
  WindowCountSubscriber.prototype._error = function(err) {
    var windows = this.windows;
    while (windows.length > 0) {
      windows.shift().error(err);
    }
    this.destination.error(err);
  };
  WindowCountSubscriber.prototype._complete = function() {
    var windows = this.windows;
    while (windows.length > 0) {
      windows.shift().complete();
    }
    this.destination.complete();
  };
  return WindowCountSubscriber;
})(Subscriber_1.Subscriber);
