/* */ 
var __extends = (this && this.__extends) || function(d, b) {
  for (var p in b)
    if (b.hasOwnProperty(p))
      d[p] = b[p];
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var Subscription_1 = require('../Subscription');
var QueueAction = (function(_super) {
  __extends(QueueAction, _super);
  function QueueAction(scheduler, work) {
    _super.call(this);
    this.scheduler = scheduler;
    this.work = work;
  }
  QueueAction.prototype.schedule = function(state) {
    if (this.isUnsubscribed) {
      return this;
    }
    this.state = state;
    var scheduler = this.scheduler;
    scheduler.actions.push(this);
    scheduler.flush();
    return this;
  };
  QueueAction.prototype.execute = function() {
    if (this.isUnsubscribed) {
      throw new Error('How did did we execute a canceled Action?');
    }
    this.work(this.state);
  };
  QueueAction.prototype.unsubscribe = function() {
    var scheduler = this.scheduler;
    var actions = scheduler.actions;
    var index = actions.indexOf(this);
    this.work = void 0;
    this.state = void 0;
    this.scheduler = void 0;
    if (index !== -1) {
      actions.splice(index, 1);
    }
    _super.prototype.unsubscribe.call(this);
  };
  return QueueAction;
})(Subscription_1.Subscription);
exports.QueueAction = QueueAction;
