/* */ 
var SubscriptionLog_1 = require('./SubscriptionLog');
var SubscriptionLoggable = (function() {
  function SubscriptionLoggable() {
    this.subscriptions = [];
  }
  SubscriptionLoggable.prototype.logSubscribedFrame = function() {
    this.subscriptions.push(new SubscriptionLog_1.SubscriptionLog(this.scheduler.now()));
    return this.subscriptions.length - 1;
  };
  SubscriptionLoggable.prototype.logUnsubscribedFrame = function(index) {
    var subscriptionLogs = this.subscriptions;
    var oldSubscriptionLog = subscriptionLogs[index];
    subscriptionLogs[index] = new SubscriptionLog_1.SubscriptionLog(oldSubscriptionLog.subscribedFrame, this.scheduler.now());
  };
  return SubscriptionLoggable;
})();
exports.SubscriptionLoggable = SubscriptionLoggable;
