var fs = require("fs");
var path = require("path");
var readInstalled = require("read-installed");

// optional options
var fn = console.log;
var options = { dev: false, log: fn }
readInstalled(".", options, function (er, data) {
   var map = buildMap(data);
  console.log(JSON.stringify(map, null, 3));
  outputConfig(map);
});

function outputConfig(map) {
   var cfg = {
      map: map
   };
   var text = "System.config(" + JSON.stringify(cfg, null, "\t") + ");";
   fs.writeFileSync("dependencies.js", text);
}

function buildMap(data) {
   var packages = flatten(data);
   
   return Object.keys(packages).reduce((result, key) => {
      var pkg = packages[key];
      
      if (!result) 
         result = writeDeps(pkg, packages);
      else {
         var name = getPath(pkg);  
         result[name] = writeDeps(pkg, packages);
      }
         
      return result;
   }, null);
}

function writeDeps(pkg, packages) {
   return Object.keys(pkg.dependencies).reduce((result, key) => {
      var dep = pkg.dependencies[key];
      result[dep.name] = getPath(packages[dep._id], packages);
      return result;      
   }, {});   
}

function getPath(pkg) {
   var reldir = path.relative(__dirname, pkg.realPath);
   return path.join(reldir, pkg.main || "index.js");   
}

function flatten(data) {   
   var result = {};
   addToMap(data, result);
   return result;
}

function addToMap(data, map) {
   if (map[data._id]) return;
   map[data._id] = data;
   
   Object.keys(data.dependencies).forEach(key => addToMap(data.dependencies[key], map));
}

