/* */ 
var $ = require('./$'),
    has = require('./$.has'),
    $export = require('./$.export'),
    createDesc = require('./$.property-desc'),
    anObject = require('./$.an-object'),
    isObject = require('./$.is-object');
function set(target, propertyKey, V) {
  var receiver = arguments.length < 4 ? target : arguments[3],
      ownDesc = $.getDesc(anObject(target), propertyKey),
      existingDescriptor,
      proto;
  if (!ownDesc) {
    if (isObject(proto = $.getProto(target))) {
      return set(proto, propertyKey, V, receiver);
    }
    ownDesc = createDesc(0);
  }
  if (has(ownDesc, 'value')) {
    if (ownDesc.writable === false || !isObject(receiver))
      return false;
    existingDescriptor = $.getDesc(receiver, propertyKey) || createDesc(0);
    existingDescriptor.value = V;
    $.setDesc(receiver, propertyKey, existingDescriptor);
    return true;
  }
  return ownDesc.set === undefined ? false : (ownDesc.set.call(receiver, V), true);
}
$export($export.S, 'Reflect', {set: set});
