/* */ 
"format cjs";
(function(Buffer, process) {
  var ts;
  (function(ts) {
    var OperationCanceledException = (function() {
      function OperationCanceledException() {}
      return OperationCanceledException;
    })();
    ts.OperationCanceledException = OperationCanceledException;
    (function(ExitStatus) {
      ExitStatus[ExitStatus["Success"] = 0] = "Success";
      ExitStatus[ExitStatus["DiagnosticsPresent_OutputsSkipped"] = 1] = "DiagnosticsPresent_OutputsSkipped";
      ExitStatus[ExitStatus["DiagnosticsPresent_OutputsGenerated"] = 2] = "DiagnosticsPresent_OutputsGenerated";
    })(ts.ExitStatus || (ts.ExitStatus = {}));
    var ExitStatus = ts.ExitStatus;
    (function(TypeReferenceSerializationKind) {
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["Unknown"] = 0] = "Unknown";
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["TypeWithConstructSignatureAndValue"] = 1] = "TypeWithConstructSignatureAndValue";
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["VoidType"] = 2] = "VoidType";
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["NumberLikeType"] = 3] = "NumberLikeType";
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["StringLikeType"] = 4] = "StringLikeType";
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["BooleanType"] = 5] = "BooleanType";
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["ArrayLikeType"] = 6] = "ArrayLikeType";
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["ESSymbolType"] = 7] = "ESSymbolType";
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["TypeWithCallSignature"] = 8] = "TypeWithCallSignature";
      TypeReferenceSerializationKind[TypeReferenceSerializationKind["ObjectType"] = 9] = "ObjectType";
    })(ts.TypeReferenceSerializationKind || (ts.TypeReferenceSerializationKind = {}));
    var TypeReferenceSerializationKind = ts.TypeReferenceSerializationKind;
    (function(DiagnosticCategory) {
      DiagnosticCategory[DiagnosticCategory["Warning"] = 0] = "Warning";
      DiagnosticCategory[DiagnosticCategory["Error"] = 1] = "Error";
      DiagnosticCategory[DiagnosticCategory["Message"] = 2] = "Message";
    })(ts.DiagnosticCategory || (ts.DiagnosticCategory = {}));
    var DiagnosticCategory = ts.DiagnosticCategory;
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    function createFileMap(getCanonicalFileName) {
      var files = {};
      return {
        get: get,
        set: set,
        contains: contains,
        remove: remove,
        clear: clear,
        forEachValue: forEachValueInMap
      };
      function set(fileName, value) {
        files[normalizeKey(fileName)] = value;
      }
      function get(fileName) {
        return files[normalizeKey(fileName)];
      }
      function contains(fileName) {
        return hasProperty(files, normalizeKey(fileName));
      }
      function remove(fileName) {
        var key = normalizeKey(fileName);
        delete files[key];
      }
      function forEachValueInMap(f) {
        forEachValue(files, f);
      }
      function normalizeKey(key) {
        return getCanonicalFileName(normalizeSlashes(key));
      }
      function clear() {
        files = {};
      }
    }
    ts.createFileMap = createFileMap;
    function forEach(array, callback) {
      if (array) {
        for (var i = 0,
            len = array.length; i < len; i++) {
          var result = callback(array[i], i);
          if (result) {
            return result;
          }
        }
      }
      return undefined;
    }
    ts.forEach = forEach;
    function contains(array, value) {
      if (array) {
        for (var _i = 0; _i < array.length; _i++) {
          var v = array[_i];
          if (v === value) {
            return true;
          }
        }
      }
      return false;
    }
    ts.contains = contains;
    function indexOf(array, value) {
      if (array) {
        for (var i = 0,
            len = array.length; i < len; i++) {
          if (array[i] === value) {
            return i;
          }
        }
      }
      return -1;
    }
    ts.indexOf = indexOf;
    function countWhere(array, predicate) {
      var count = 0;
      if (array) {
        for (var _i = 0; _i < array.length; _i++) {
          var v = array[_i];
          if (predicate(v)) {
            count++;
          }
        }
      }
      return count;
    }
    ts.countWhere = countWhere;
    function filter(array, f) {
      var result;
      if (array) {
        result = [];
        for (var _i = 0; _i < array.length; _i++) {
          var item = array[_i];
          if (f(item)) {
            result.push(item);
          }
        }
      }
      return result;
    }
    ts.filter = filter;
    function map(array, f) {
      var result;
      if (array) {
        result = [];
        for (var _i = 0; _i < array.length; _i++) {
          var v = array[_i];
          result.push(f(v));
        }
      }
      return result;
    }
    ts.map = map;
    function concatenate(array1, array2) {
      if (!array2 || !array2.length)
        return array1;
      if (!array1 || !array1.length)
        return array2;
      return array1.concat(array2);
    }
    ts.concatenate = concatenate;
    function deduplicate(array) {
      var result;
      if (array) {
        result = [];
        for (var _i = 0; _i < array.length; _i++) {
          var item = array[_i];
          if (!contains(result, item)) {
            result.push(item);
          }
        }
      }
      return result;
    }
    ts.deduplicate = deduplicate;
    function sum(array, prop) {
      var result = 0;
      for (var _i = 0; _i < array.length; _i++) {
        var v = array[_i];
        result += v[prop];
      }
      return result;
    }
    ts.sum = sum;
    function addRange(to, from) {
      if (to && from) {
        for (var _i = 0; _i < from.length; _i++) {
          var v = from[_i];
          to.push(v);
        }
      }
    }
    ts.addRange = addRange;
    function rangeEquals(array1, array2, pos, end) {
      while (pos < end) {
        if (array1[pos] !== array2[pos]) {
          return false;
        }
        pos++;
      }
      return true;
    }
    ts.rangeEquals = rangeEquals;
    function lastOrUndefined(array) {
      if (array.length === 0) {
        return undefined;
      }
      return array[array.length - 1];
    }
    ts.lastOrUndefined = lastOrUndefined;
    function binarySearch(array, value) {
      var low = 0;
      var high = array.length - 1;
      while (low <= high) {
        var middle = low + ((high - low) >> 1);
        var midValue = array[middle];
        if (midValue === value) {
          return middle;
        } else if (midValue > value) {
          high = middle - 1;
        } else {
          low = middle + 1;
        }
      }
      return ~low;
    }
    ts.binarySearch = binarySearch;
    function reduceLeft(array, f, initial) {
      if (array) {
        var count = array.length;
        if (count > 0) {
          var pos = 0;
          var result = arguments.length <= 2 ? array[pos++] : initial;
          while (pos < count) {
            result = f(result, array[pos++]);
          }
          return result;
        }
      }
      return initial;
    }
    ts.reduceLeft = reduceLeft;
    function reduceRight(array, f, initial) {
      if (array) {
        var pos = array.length - 1;
        if (pos >= 0) {
          var result = arguments.length <= 2 ? array[pos--] : initial;
          while (pos >= 0) {
            result = f(result, array[pos--]);
          }
          return result;
        }
      }
      return initial;
    }
    ts.reduceRight = reduceRight;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    function hasProperty(map, key) {
      return hasOwnProperty.call(map, key);
    }
    ts.hasProperty = hasProperty;
    function getProperty(map, key) {
      return hasOwnProperty.call(map, key) ? map[key] : undefined;
    }
    ts.getProperty = getProperty;
    function isEmpty(map) {
      for (var id in map) {
        if (hasProperty(map, id)) {
          return false;
        }
      }
      return true;
    }
    ts.isEmpty = isEmpty;
    function clone(object) {
      var result = {};
      for (var id in object) {
        result[id] = object[id];
      }
      return result;
    }
    ts.clone = clone;
    function extend(first, second) {
      var result = {};
      for (var id in first) {
        result[id] = first[id];
      }
      for (var id in second) {
        if (!hasProperty(result, id)) {
          result[id] = second[id];
        }
      }
      return result;
    }
    ts.extend = extend;
    function forEachValue(map, callback) {
      var result;
      for (var id in map) {
        if (result = callback(map[id]))
          break;
      }
      return result;
    }
    ts.forEachValue = forEachValue;
    function forEachKey(map, callback) {
      var result;
      for (var id in map) {
        if (result = callback(id))
          break;
      }
      return result;
    }
    ts.forEachKey = forEachKey;
    function lookUp(map, key) {
      return hasProperty(map, key) ? map[key] : undefined;
    }
    ts.lookUp = lookUp;
    function copyMap(source, target) {
      for (var p in source) {
        target[p] = source[p];
      }
    }
    ts.copyMap = copyMap;
    function arrayToMap(array, makeKey) {
      var result = {};
      forEach(array, function(value) {
        result[makeKey(value)] = value;
      });
      return result;
    }
    ts.arrayToMap = arrayToMap;
    function memoize(callback) {
      var value;
      return function() {
        if (callback) {
          value = callback();
          callback = undefined;
        }
        return value;
      };
    }
    ts.memoize = memoize;
    function formatStringFromArgs(text, args, baseIndex) {
      baseIndex = baseIndex || 0;
      return text.replace(/{(\d+)}/g, function(match, index) {
        return args[+index + baseIndex];
      });
    }
    ts.localizedDiagnosticMessages = undefined;
    function getLocaleSpecificMessage(message) {
      return ts.localizedDiagnosticMessages && ts.localizedDiagnosticMessages[message] ? ts.localizedDiagnosticMessages[message] : message;
    }
    ts.getLocaleSpecificMessage = getLocaleSpecificMessage;
    function createFileDiagnostic(file, start, length, message) {
      var end = start + length;
      Debug.assert(start >= 0, "start must be non-negative, is " + start);
      Debug.assert(length >= 0, "length must be non-negative, is " + length);
      if (file) {
        Debug.assert(start <= file.text.length, "start must be within the bounds of the file. " + start + " > " + file.text.length);
        Debug.assert(end <= file.text.length, "end must be the bounds of the file. " + end + " > " + file.text.length);
      }
      var text = getLocaleSpecificMessage(message.key);
      if (arguments.length > 4) {
        text = formatStringFromArgs(text, arguments, 4);
      }
      return {
        file: file,
        start: start,
        length: length,
        messageText: text,
        category: message.category,
        code: message.code
      };
    }
    ts.createFileDiagnostic = createFileDiagnostic;
    function createCompilerDiagnostic(message) {
      var text = getLocaleSpecificMessage(message.key);
      if (arguments.length > 1) {
        text = formatStringFromArgs(text, arguments, 1);
      }
      return {
        file: undefined,
        start: undefined,
        length: undefined,
        messageText: text,
        category: message.category,
        code: message.code
      };
    }
    ts.createCompilerDiagnostic = createCompilerDiagnostic;
    function chainDiagnosticMessages(details, message) {
      var text = getLocaleSpecificMessage(message.key);
      if (arguments.length > 2) {
        text = formatStringFromArgs(text, arguments, 2);
      }
      return {
        messageText: text,
        category: message.category,
        code: message.code,
        next: details
      };
    }
    ts.chainDiagnosticMessages = chainDiagnosticMessages;
    function concatenateDiagnosticMessageChains(headChain, tailChain) {
      Debug.assert(!headChain.next);
      headChain.next = tailChain;
      return headChain;
    }
    ts.concatenateDiagnosticMessageChains = concatenateDiagnosticMessageChains;
    function compareValues(a, b) {
      if (a === b)
        return 0;
      if (a === undefined)
        return -1;
      if (b === undefined)
        return 1;
      return a < b ? -1 : 1;
    }
    ts.compareValues = compareValues;
    function getDiagnosticFileName(diagnostic) {
      return diagnostic.file ? diagnostic.file.fileName : undefined;
    }
    function compareDiagnostics(d1, d2) {
      return compareValues(getDiagnosticFileName(d1), getDiagnosticFileName(d2)) || compareValues(d1.start, d2.start) || compareValues(d1.length, d2.length) || compareValues(d1.code, d2.code) || compareMessageText(d1.messageText, d2.messageText) || 0;
    }
    ts.compareDiagnostics = compareDiagnostics;
    function compareMessageText(text1, text2) {
      while (text1 && text2) {
        var string1 = typeof text1 === "string" ? text1 : text1.messageText;
        var string2 = typeof text2 === "string" ? text2 : text2.messageText;
        var res = compareValues(string1, string2);
        if (res) {
          return res;
        }
        text1 = typeof text1 === "string" ? undefined : text1.next;
        text2 = typeof text2 === "string" ? undefined : text2.next;
      }
      if (!text1 && !text2) {
        return 0;
      }
      return text1 ? 1 : -1;
    }
    function sortAndDeduplicateDiagnostics(diagnostics) {
      return deduplicateSortedDiagnostics(diagnostics.sort(compareDiagnostics));
    }
    ts.sortAndDeduplicateDiagnostics = sortAndDeduplicateDiagnostics;
    function deduplicateSortedDiagnostics(diagnostics) {
      if (diagnostics.length < 2) {
        return diagnostics;
      }
      var newDiagnostics = [diagnostics[0]];
      var previousDiagnostic = diagnostics[0];
      for (var i = 1; i < diagnostics.length; i++) {
        var currentDiagnostic = diagnostics[i];
        var isDupe = compareDiagnostics(currentDiagnostic, previousDiagnostic) === 0;
        if (!isDupe) {
          newDiagnostics.push(currentDiagnostic);
          previousDiagnostic = currentDiagnostic;
        }
      }
      return newDiagnostics;
    }
    ts.deduplicateSortedDiagnostics = deduplicateSortedDiagnostics;
    function normalizeSlashes(path) {
      return path.replace(/\\/g, "/");
    }
    ts.normalizeSlashes = normalizeSlashes;
    function getRootLength(path) {
      if (path.charCodeAt(0) === 47) {
        if (path.charCodeAt(1) !== 47)
          return 1;
        var p1 = path.indexOf("/", 2);
        if (p1 < 0)
          return 2;
        var p2 = path.indexOf("/", p1 + 1);
        if (p2 < 0)
          return p1 + 1;
        return p2 + 1;
      }
      if (path.charCodeAt(1) === 58) {
        if (path.charCodeAt(2) === 47)
          return 3;
        return 2;
      }
      if (path.lastIndexOf("file:///", 0) === 0) {
        return "file:///".length;
      }
      var idx = path.indexOf("://");
      if (idx !== -1) {
        return idx + "://".length;
      }
      return 0;
    }
    ts.getRootLength = getRootLength;
    ts.directorySeparator = "/";
    function getNormalizedParts(normalizedSlashedPath, rootLength) {
      var parts = normalizedSlashedPath.substr(rootLength).split(ts.directorySeparator);
      var normalized = [];
      for (var _i = 0; _i < parts.length; _i++) {
        var part = parts[_i];
        if (part !== ".") {
          if (part === ".." && normalized.length > 0 && lastOrUndefined(normalized) !== "..") {
            normalized.pop();
          } else {
            if (part) {
              normalized.push(part);
            }
          }
        }
      }
      return normalized;
    }
    function normalizePath(path) {
      path = normalizeSlashes(path);
      var rootLength = getRootLength(path);
      var normalized = getNormalizedParts(path, rootLength);
      return path.substr(0, rootLength) + normalized.join(ts.directorySeparator);
    }
    ts.normalizePath = normalizePath;
    function getDirectoryPath(path) {
      return path.substr(0, Math.max(getRootLength(path), path.lastIndexOf(ts.directorySeparator)));
    }
    ts.getDirectoryPath = getDirectoryPath;
    function isUrl(path) {
      return path && !isRootedDiskPath(path) && path.indexOf("://") !== -1;
    }
    ts.isUrl = isUrl;
    function isRootedDiskPath(path) {
      return getRootLength(path) !== 0;
    }
    ts.isRootedDiskPath = isRootedDiskPath;
    function normalizedPathComponents(path, rootLength) {
      var normalizedParts = getNormalizedParts(path, rootLength);
      return [path.substr(0, rootLength)].concat(normalizedParts);
    }
    function getNormalizedPathComponents(path, currentDirectory) {
      path = normalizeSlashes(path);
      var rootLength = getRootLength(path);
      if (rootLength === 0) {
        path = combinePaths(normalizeSlashes(currentDirectory), path);
        rootLength = getRootLength(path);
      }
      return normalizedPathComponents(path, rootLength);
    }
    ts.getNormalizedPathComponents = getNormalizedPathComponents;
    function getNormalizedAbsolutePath(fileName, currentDirectory) {
      return getNormalizedPathFromPathComponents(getNormalizedPathComponents(fileName, currentDirectory));
    }
    ts.getNormalizedAbsolutePath = getNormalizedAbsolutePath;
    function getNormalizedPathFromPathComponents(pathComponents) {
      if (pathComponents && pathComponents.length) {
        return pathComponents[0] + pathComponents.slice(1).join(ts.directorySeparator);
      }
    }
    ts.getNormalizedPathFromPathComponents = getNormalizedPathFromPathComponents;
    function getNormalizedPathComponentsOfUrl(url) {
      var urlLength = url.length;
      var rootLength = url.indexOf("://") + "://".length;
      while (rootLength < urlLength) {
        if (url.charCodeAt(rootLength) === 47) {
          rootLength++;
        } else {
          break;
        }
      }
      if (rootLength === urlLength) {
        return [url];
      }
      var indexOfNextSlash = url.indexOf(ts.directorySeparator, rootLength);
      if (indexOfNextSlash !== -1) {
        rootLength = indexOfNextSlash + 1;
        return normalizedPathComponents(url, rootLength);
      } else {
        return [url + ts.directorySeparator];
      }
    }
    function getNormalizedPathOrUrlComponents(pathOrUrl, currentDirectory) {
      if (isUrl(pathOrUrl)) {
        return getNormalizedPathComponentsOfUrl(pathOrUrl);
      } else {
        return getNormalizedPathComponents(pathOrUrl, currentDirectory);
      }
    }
    function getRelativePathToDirectoryOrUrl(directoryPathOrUrl, relativeOrAbsolutePath, currentDirectory, getCanonicalFileName, isAbsolutePathAnUrl) {
      var pathComponents = getNormalizedPathOrUrlComponents(relativeOrAbsolutePath, currentDirectory);
      var directoryComponents = getNormalizedPathOrUrlComponents(directoryPathOrUrl, currentDirectory);
      if (directoryComponents.length > 1 && lastOrUndefined(directoryComponents) === "") {
        directoryComponents.length--;
      }
      for (var joinStartIndex = 0; joinStartIndex < pathComponents.length && joinStartIndex < directoryComponents.length; joinStartIndex++) {
        if (getCanonicalFileName(directoryComponents[joinStartIndex]) !== getCanonicalFileName(pathComponents[joinStartIndex])) {
          break;
        }
      }
      if (joinStartIndex) {
        var relativePath = "";
        var relativePathComponents = pathComponents.slice(joinStartIndex, pathComponents.length);
        for (; joinStartIndex < directoryComponents.length; joinStartIndex++) {
          if (directoryComponents[joinStartIndex] !== "") {
            relativePath = relativePath + ".." + ts.directorySeparator;
          }
        }
        return relativePath + relativePathComponents.join(ts.directorySeparator);
      }
      var absolutePath = getNormalizedPathFromPathComponents(pathComponents);
      if (isAbsolutePathAnUrl && isRootedDiskPath(absolutePath)) {
        absolutePath = "file:///" + absolutePath;
      }
      return absolutePath;
    }
    ts.getRelativePathToDirectoryOrUrl = getRelativePathToDirectoryOrUrl;
    function getBaseFileName(path) {
      var i = path.lastIndexOf(ts.directorySeparator);
      return i < 0 ? path : path.substring(i + 1);
    }
    ts.getBaseFileName = getBaseFileName;
    function combinePaths(path1, path2) {
      if (!(path1 && path1.length))
        return path2;
      if (!(path2 && path2.length))
        return path1;
      if (getRootLength(path2) !== 0)
        return path2;
      if (path1.charAt(path1.length - 1) === ts.directorySeparator)
        return path1 + path2;
      return path1 + ts.directorySeparator + path2;
    }
    ts.combinePaths = combinePaths;
    function fileExtensionIs(path, extension) {
      var pathLen = path.length;
      var extLen = extension.length;
      return pathLen > extLen && path.substr(pathLen - extLen, extLen) === extension;
    }
    ts.fileExtensionIs = fileExtensionIs;
    ts.supportedExtensions = [".ts", ".tsx", ".d.ts"];
    var extensionsToRemove = [".d.ts", ".ts", ".js", ".tsx", ".jsx"];
    function removeFileExtension(path) {
      for (var _i = 0; _i < extensionsToRemove.length; _i++) {
        var ext = extensionsToRemove[_i];
        if (fileExtensionIs(path, ext)) {
          return path.substr(0, path.length - ext.length);
        }
      }
      return path;
    }
    ts.removeFileExtension = removeFileExtension;
    var backslashOrDoubleQuote = /[\"\\]/g;
    var escapedCharsRegExp = /[\u0000-\u001f\t\v\f\b\r\n\u2028\u2029\u0085]/g;
    var escapedCharsMap = {
      "\0": "\\0",
      "\t": "\\t",
      "\v": "\\v",
      "\f": "\\f",
      "\b": "\\b",
      "\r": "\\r",
      "\n": "\\n",
      "\\": "\\\\",
      "\"": "\\\"",
      "\u2028": "\\u2028",
      "\u2029": "\\u2029",
      "\u0085": "\\u0085"
    };
    function Symbol(flags, name) {
      this.flags = flags;
      this.name = name;
      this.declarations = undefined;
    }
    function Type(checker, flags) {
      this.flags = flags;
    }
    function Signature(checker) {}
    ts.objectAllocator = {
      getNodeConstructor: function(kind) {
        function Node() {}
        Node.prototype = {
          kind: kind,
          pos: -1,
          end: -1,
          flags: 0,
          parent: undefined
        };
        return Node;
      },
      getSymbolConstructor: function() {
        return Symbol;
      },
      getTypeConstructor: function() {
        return Type;
      },
      getSignatureConstructor: function() {
        return Signature;
      }
    };
    var Debug;
    (function(Debug) {
      var currentAssertionLevel = 0;
      function shouldAssert(level) {
        return currentAssertionLevel >= level;
      }
      Debug.shouldAssert = shouldAssert;
      function assert(expression, message, verboseDebugInfo) {
        if (!expression) {
          var verboseDebugString = "";
          if (verboseDebugInfo) {
            verboseDebugString = "\r\nVerbose Debug Information: " + verboseDebugInfo();
          }
          throw new Error("Debug Failure. False expression: " + (message || "") + verboseDebugString);
        }
      }
      Debug.assert = assert;
      function fail(message) {
        Debug.assert(false, message);
      }
      Debug.fail = fail;
    })(Debug = ts.Debug || (ts.Debug = {}));
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    ts.sys = (function() {
      function getWScriptSystem() {
        var fso = new ActiveXObject("Scripting.FileSystemObject");
        var fileStream = new ActiveXObject("ADODB.Stream");
        fileStream.Type = 2;
        var binaryStream = new ActiveXObject("ADODB.Stream");
        binaryStream.Type = 1;
        var args = [];
        for (var i = 0; i < WScript.Arguments.length; i++) {
          args[i] = WScript.Arguments.Item(i);
        }
        function readFile(fileName, encoding) {
          if (!fso.FileExists(fileName)) {
            return undefined;
          }
          fileStream.Open();
          try {
            if (encoding) {
              fileStream.Charset = encoding;
              fileStream.LoadFromFile(fileName);
            } else {
              fileStream.Charset = "x-ansi";
              fileStream.LoadFromFile(fileName);
              var bom = fileStream.ReadText(2) || "";
              fileStream.Position = 0;
              fileStream.Charset = bom.length >= 2 && (bom.charCodeAt(0) === 0xFF && bom.charCodeAt(1) === 0xFE || bom.charCodeAt(0) === 0xFE && bom.charCodeAt(1) === 0xFF) ? "unicode" : "utf-8";
            }
            return fileStream.ReadText();
          } catch (e) {
            throw e;
          } finally {
            fileStream.Close();
          }
        }
        function writeFile(fileName, data, writeByteOrderMark) {
          fileStream.Open();
          binaryStream.Open();
          try {
            fileStream.Charset = "utf-8";
            fileStream.WriteText(data);
            if (writeByteOrderMark) {
              fileStream.Position = 0;
            } else {
              fileStream.Position = 3;
            }
            fileStream.CopyTo(binaryStream);
            binaryStream.SaveToFile(fileName, 2);
          } finally {
            binaryStream.Close();
            fileStream.Close();
          }
        }
        function getCanonicalPath(path) {
          return path.toLowerCase();
        }
        function getNames(collection) {
          var result = [];
          for (var e = new Enumerator(collection); !e.atEnd(); e.moveNext()) {
            result.push(e.item().Name);
          }
          return result.sort();
        }
        function readDirectory(path, extension, exclude) {
          var result = [];
          exclude = ts.map(exclude, function(s) {
            return getCanonicalPath(ts.combinePaths(path, s));
          });
          visitDirectory(path);
          return result;
          function visitDirectory(path) {
            var folder = fso.GetFolder(path || ".");
            var files = getNames(folder.files);
            for (var _i = 0; _i < files.length; _i++) {
              var current = files[_i];
              var name_1 = ts.combinePaths(path, current);
              if ((!extension || ts.fileExtensionIs(name_1, extension)) && !ts.contains(exclude, getCanonicalPath(name_1))) {
                result.push(name_1);
              }
            }
            var subfolders = getNames(folder.subfolders);
            for (var _a = 0; _a < subfolders.length; _a++) {
              var current = subfolders[_a];
              var name_2 = ts.combinePaths(path, current);
              if (!ts.contains(exclude, getCanonicalPath(name_2))) {
                visitDirectory(name_2);
              }
            }
          }
        }
        return {
          args: args,
          newLine: "\r\n",
          useCaseSensitiveFileNames: false,
          write: function(s) {
            WScript.StdOut.Write(s);
          },
          readFile: readFile,
          writeFile: writeFile,
          resolvePath: function(path) {
            return fso.GetAbsolutePathName(path);
          },
          fileExists: function(path) {
            return fso.FileExists(path);
          },
          directoryExists: function(path) {
            return fso.FolderExists(path);
          },
          createDirectory: function(directoryName) {
            if (!this.directoryExists(directoryName)) {
              fso.CreateFolder(directoryName);
            }
          },
          getExecutingFilePath: function() {
            return WScript.ScriptFullName;
          },
          getCurrentDirectory: function() {
            return new ActiveXObject("WScript.Shell").CurrentDirectory;
          },
          readDirectory: readDirectory,
          exit: function(exitCode) {
            try {
              WScript.Quit(exitCode);
            } catch (e) {}
          }
        };
      }
      function getNodeSystem() {
        var _fs = require('@empty');
        var _path = require('@empty');
        var _os = require('@empty');
        var platform = _os.platform();
        var useCaseSensitiveFileNames = platform !== "win32" && platform !== "win64" && platform !== "darwin";
        function readFile(fileName, encoding) {
          if (!_fs.existsSync(fileName)) {
            return undefined;
          }
          var buffer = _fs.readFileSync(fileName);
          var len = buffer.length;
          if (len >= 2 && buffer[0] === 0xFE && buffer[1] === 0xFF) {
            len &= ~1;
            for (var i = 0; i < len; i += 2) {
              var temp = buffer[i];
              buffer[i] = buffer[i + 1];
              buffer[i + 1] = temp;
            }
            return buffer.toString("utf16le", 2);
          }
          if (len >= 2 && buffer[0] === 0xFF && buffer[1] === 0xFE) {
            return buffer.toString("utf16le", 2);
          }
          if (len >= 3 && buffer[0] === 0xEF && buffer[1] === 0xBB && buffer[2] === 0xBF) {
            return buffer.toString("utf8", 3);
          }
          return buffer.toString("utf8");
        }
        function writeFile(fileName, data, writeByteOrderMark) {
          if (writeByteOrderMark) {
            data = "\uFEFF" + data;
          }
          _fs.writeFileSync(fileName, data, "utf8");
        }
        function getCanonicalPath(path) {
          return useCaseSensitiveFileNames ? path.toLowerCase() : path;
        }
        function readDirectory(path, extension, exclude) {
          var result = [];
          exclude = ts.map(exclude, function(s) {
            return getCanonicalPath(ts.combinePaths(path, s));
          });
          visitDirectory(path);
          return result;
          function visitDirectory(path) {
            var files = _fs.readdirSync(path || ".").sort();
            var directories = [];
            for (var _i = 0; _i < files.length; _i++) {
              var current = files[_i];
              var name_3 = ts.combinePaths(path, current);
              if (!ts.contains(exclude, getCanonicalPath(name_3))) {
                var stat = _fs.statSync(name_3);
                if (stat.isFile()) {
                  if (!extension || ts.fileExtensionIs(name_3, extension)) {
                    result.push(name_3);
                  }
                } else if (stat.isDirectory()) {
                  directories.push(name_3);
                }
              }
            }
            for (var _a = 0; _a < directories.length; _a++) {
              var current = directories[_a];
              visitDirectory(current);
            }
          }
        }
        return {
          args: process.argv.slice(2),
          newLine: _os.EOL,
          useCaseSensitiveFileNames: useCaseSensitiveFileNames,
          write: function(s) {
            var buffer = new Buffer(s, "utf8");
            var offset = 0;
            var toWrite = buffer.length;
            var written = 0;
            while ((written = _fs.writeSync(1, buffer, offset, toWrite)) < toWrite) {
              offset += written;
              toWrite -= written;
            }
          },
          readFile: readFile,
          writeFile: writeFile,
          watchFile: function(fileName, callback) {
            _fs.watchFile(fileName, {
              persistent: true,
              interval: 250
            }, fileChanged);
            return {close: function() {
                _fs.unwatchFile(fileName, fileChanged);
              }};
            function fileChanged(curr, prev) {
              if (+curr.mtime <= +prev.mtime) {
                return;
              }
              callback(fileName);
            }
          },
          resolvePath: function(path) {
            return _path.resolve(path);
          },
          fileExists: function(path) {
            return _fs.existsSync(path);
          },
          directoryExists: function(path) {
            return _fs.existsSync(path) && _fs.statSync(path).isDirectory();
          },
          createDirectory: function(directoryName) {
            if (!this.directoryExists(directoryName)) {
              _fs.mkdirSync(directoryName);
            }
          },
          getExecutingFilePath: function() {
            return __filename;
          },
          getCurrentDirectory: function() {
            return process.cwd();
          },
          readDirectory: readDirectory,
          getMemoryUsage: function() {
            if (global.gc) {
              global.gc();
            }
            return process.memoryUsage().heapUsed;
          },
          exit: function(exitCode) {
            process.exit(exitCode);
          }
        };
      }
      if (typeof WScript !== "undefined" && typeof ActiveXObject === "function") {
        return getWScriptSystem();
      } else if (typeof process !== "undefined" && process.nextTick && !process.browser && typeof require !== "undefined") {
        return getNodeSystem();
      } else {
        return undefined;
      }
    })();
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    ts.Diagnostics = {
      Unterminated_string_literal: {
        code: 1002,
        category: ts.DiagnosticCategory.Error,
        key: "Unterminated string literal."
      },
      Identifier_expected: {
        code: 1003,
        category: ts.DiagnosticCategory.Error,
        key: "Identifier expected."
      },
      _0_expected: {
        code: 1005,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' expected."
      },
      A_file_cannot_have_a_reference_to_itself: {
        code: 1006,
        category: ts.DiagnosticCategory.Error,
        key: "A file cannot have a reference to itself."
      },
      Trailing_comma_not_allowed: {
        code: 1009,
        category: ts.DiagnosticCategory.Error,
        key: "Trailing comma not allowed."
      },
      Asterisk_Slash_expected: {
        code: 1010,
        category: ts.DiagnosticCategory.Error,
        key: "'*/' expected."
      },
      Unexpected_token: {
        code: 1012,
        category: ts.DiagnosticCategory.Error,
        key: "Unexpected token."
      },
      A_rest_parameter_must_be_last_in_a_parameter_list: {
        code: 1014,
        category: ts.DiagnosticCategory.Error,
        key: "A rest parameter must be last in a parameter list."
      },
      Parameter_cannot_have_question_mark_and_initializer: {
        code: 1015,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter cannot have question mark and initializer."
      },
      A_required_parameter_cannot_follow_an_optional_parameter: {
        code: 1016,
        category: ts.DiagnosticCategory.Error,
        key: "A required parameter cannot follow an optional parameter."
      },
      An_index_signature_cannot_have_a_rest_parameter: {
        code: 1017,
        category: ts.DiagnosticCategory.Error,
        key: "An index signature cannot have a rest parameter."
      },
      An_index_signature_parameter_cannot_have_an_accessibility_modifier: {
        code: 1018,
        category: ts.DiagnosticCategory.Error,
        key: "An index signature parameter cannot have an accessibility modifier."
      },
      An_index_signature_parameter_cannot_have_a_question_mark: {
        code: 1019,
        category: ts.DiagnosticCategory.Error,
        key: "An index signature parameter cannot have a question mark."
      },
      An_index_signature_parameter_cannot_have_an_initializer: {
        code: 1020,
        category: ts.DiagnosticCategory.Error,
        key: "An index signature parameter cannot have an initializer."
      },
      An_index_signature_must_have_a_type_annotation: {
        code: 1021,
        category: ts.DiagnosticCategory.Error,
        key: "An index signature must have a type annotation."
      },
      An_index_signature_parameter_must_have_a_type_annotation: {
        code: 1022,
        category: ts.DiagnosticCategory.Error,
        key: "An index signature parameter must have a type annotation."
      },
      An_index_signature_parameter_type_must_be_string_or_number: {
        code: 1023,
        category: ts.DiagnosticCategory.Error,
        key: "An index signature parameter type must be 'string' or 'number'."
      },
      Accessibility_modifier_already_seen: {
        code: 1028,
        category: ts.DiagnosticCategory.Error,
        key: "Accessibility modifier already seen."
      },
      _0_modifier_must_precede_1_modifier: {
        code: 1029,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier must precede '{1}' modifier."
      },
      _0_modifier_already_seen: {
        code: 1030,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier already seen."
      },
      _0_modifier_cannot_appear_on_a_class_element: {
        code: 1031,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier cannot appear on a class element."
      },
      super_must_be_followed_by_an_argument_list_or_member_access: {
        code: 1034,
        category: ts.DiagnosticCategory.Error,
        key: "'super' must be followed by an argument list or member access."
      },
      Only_ambient_modules_can_use_quoted_names: {
        code: 1035,
        category: ts.DiagnosticCategory.Error,
        key: "Only ambient modules can use quoted names."
      },
      Statements_are_not_allowed_in_ambient_contexts: {
        code: 1036,
        category: ts.DiagnosticCategory.Error,
        key: "Statements are not allowed in ambient contexts."
      },
      A_declare_modifier_cannot_be_used_in_an_already_ambient_context: {
        code: 1038,
        category: ts.DiagnosticCategory.Error,
        key: "A 'declare' modifier cannot be used in an already ambient context."
      },
      Initializers_are_not_allowed_in_ambient_contexts: {
        code: 1039,
        category: ts.DiagnosticCategory.Error,
        key: "Initializers are not allowed in ambient contexts."
      },
      _0_modifier_cannot_be_used_in_an_ambient_context: {
        code: 1040,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier cannot be used in an ambient context."
      },
      _0_modifier_cannot_be_used_with_a_class_declaration: {
        code: 1041,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier cannot be used with a class declaration."
      },
      _0_modifier_cannot_be_used_here: {
        code: 1042,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier cannot be used here."
      },
      _0_modifier_cannot_appear_on_a_data_property: {
        code: 1043,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier cannot appear on a data property."
      },
      _0_modifier_cannot_appear_on_a_module_element: {
        code: 1044,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier cannot appear on a module element."
      },
      A_0_modifier_cannot_be_used_with_an_interface_declaration: {
        code: 1045,
        category: ts.DiagnosticCategory.Error,
        key: "A '{0}' modifier cannot be used with an interface declaration."
      },
      A_declare_modifier_is_required_for_a_top_level_declaration_in_a_d_ts_file: {
        code: 1046,
        category: ts.DiagnosticCategory.Error,
        key: "A 'declare' modifier is required for a top level declaration in a .d.ts file."
      },
      A_rest_parameter_cannot_be_optional: {
        code: 1047,
        category: ts.DiagnosticCategory.Error,
        key: "A rest parameter cannot be optional."
      },
      A_rest_parameter_cannot_have_an_initializer: {
        code: 1048,
        category: ts.DiagnosticCategory.Error,
        key: "A rest parameter cannot have an initializer."
      },
      A_set_accessor_must_have_exactly_one_parameter: {
        code: 1049,
        category: ts.DiagnosticCategory.Error,
        key: "A 'set' accessor must have exactly one parameter."
      },
      A_set_accessor_cannot_have_an_optional_parameter: {
        code: 1051,
        category: ts.DiagnosticCategory.Error,
        key: "A 'set' accessor cannot have an optional parameter."
      },
      A_set_accessor_parameter_cannot_have_an_initializer: {
        code: 1052,
        category: ts.DiagnosticCategory.Error,
        key: "A 'set' accessor parameter cannot have an initializer."
      },
      A_set_accessor_cannot_have_rest_parameter: {
        code: 1053,
        category: ts.DiagnosticCategory.Error,
        key: "A 'set' accessor cannot have rest parameter."
      },
      A_get_accessor_cannot_have_parameters: {
        code: 1054,
        category: ts.DiagnosticCategory.Error,
        key: "A 'get' accessor cannot have parameters."
      },
      Type_0_is_not_a_valid_async_function_return_type: {
        code: 1055,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' is not a valid async function return type."
      },
      Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher: {
        code: 1056,
        category: ts.DiagnosticCategory.Error,
        key: "Accessors are only available when targeting ECMAScript 5 and higher."
      },
      An_async_function_or_method_must_have_a_valid_awaitable_return_type: {
        code: 1057,
        category: ts.DiagnosticCategory.Error,
        key: "An async function or method must have a valid awaitable return type."
      },
      Operand_for_await_does_not_have_a_valid_callable_then_member: {
        code: 1058,
        category: ts.DiagnosticCategory.Error,
        key: "Operand for 'await' does not have a valid callable 'then' member."
      },
      Return_expression_in_async_function_does_not_have_a_valid_callable_then_member: {
        code: 1059,
        category: ts.DiagnosticCategory.Error,
        key: "Return expression in async function does not have a valid callable 'then' member."
      },
      Expression_body_for_async_arrow_function_does_not_have_a_valid_callable_then_member: {
        code: 1060,
        category: ts.DiagnosticCategory.Error,
        key: "Expression body for async arrow function does not have a valid callable 'then' member."
      },
      Enum_member_must_have_initializer: {
        code: 1061,
        category: ts.DiagnosticCategory.Error,
        key: "Enum member must have initializer."
      },
      _0_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method: {
        code: 1062,
        category: ts.DiagnosticCategory.Error,
        key: "{0} is referenced directly or indirectly in the fulfillment callback of its own 'then' method."
      },
      An_export_assignment_cannot_be_used_in_a_namespace: {
        code: 1063,
        category: ts.DiagnosticCategory.Error,
        key: "An export assignment cannot be used in a namespace."
      },
      Ambient_enum_elements_can_only_have_integer_literal_initializers: {
        code: 1066,
        category: ts.DiagnosticCategory.Error,
        key: "Ambient enum elements can only have integer literal initializers."
      },
      Unexpected_token_A_constructor_method_accessor_or_property_was_expected: {
        code: 1068,
        category: ts.DiagnosticCategory.Error,
        key: "Unexpected token. A constructor, method, accessor, or property was expected."
      },
      A_0_modifier_cannot_be_used_with_an_import_declaration: {
        code: 1079,
        category: ts.DiagnosticCategory.Error,
        key: "A '{0}' modifier cannot be used with an import declaration."
      },
      Invalid_reference_directive_syntax: {
        code: 1084,
        category: ts.DiagnosticCategory.Error,
        key: "Invalid 'reference' directive syntax."
      },
      Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher: {
        code: 1085,
        category: ts.DiagnosticCategory.Error,
        key: "Octal literals are not available when targeting ECMAScript 5 and higher."
      },
      An_accessor_cannot_be_declared_in_an_ambient_context: {
        code: 1086,
        category: ts.DiagnosticCategory.Error,
        key: "An accessor cannot be declared in an ambient context."
      },
      _0_modifier_cannot_appear_on_a_constructor_declaration: {
        code: 1089,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier cannot appear on a constructor declaration."
      },
      _0_modifier_cannot_appear_on_a_parameter: {
        code: 1090,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier cannot appear on a parameter."
      },
      Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement: {
        code: 1091,
        category: ts.DiagnosticCategory.Error,
        key: "Only a single variable declaration is allowed in a 'for...in' statement."
      },
      Type_parameters_cannot_appear_on_a_constructor_declaration: {
        code: 1092,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameters cannot appear on a constructor declaration."
      },
      Type_annotation_cannot_appear_on_a_constructor_declaration: {
        code: 1093,
        category: ts.DiagnosticCategory.Error,
        key: "Type annotation cannot appear on a constructor declaration."
      },
      An_accessor_cannot_have_type_parameters: {
        code: 1094,
        category: ts.DiagnosticCategory.Error,
        key: "An accessor cannot have type parameters."
      },
      A_set_accessor_cannot_have_a_return_type_annotation: {
        code: 1095,
        category: ts.DiagnosticCategory.Error,
        key: "A 'set' accessor cannot have a return type annotation."
      },
      An_index_signature_must_have_exactly_one_parameter: {
        code: 1096,
        category: ts.DiagnosticCategory.Error,
        key: "An index signature must have exactly one parameter."
      },
      _0_list_cannot_be_empty: {
        code: 1097,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' list cannot be empty."
      },
      Type_parameter_list_cannot_be_empty: {
        code: 1098,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter list cannot be empty."
      },
      Type_argument_list_cannot_be_empty: {
        code: 1099,
        category: ts.DiagnosticCategory.Error,
        key: "Type argument list cannot be empty."
      },
      Invalid_use_of_0_in_strict_mode: {
        code: 1100,
        category: ts.DiagnosticCategory.Error,
        key: "Invalid use of '{0}' in strict mode."
      },
      with_statements_are_not_allowed_in_strict_mode: {
        code: 1101,
        category: ts.DiagnosticCategory.Error,
        key: "'with' statements are not allowed in strict mode."
      },
      delete_cannot_be_called_on_an_identifier_in_strict_mode: {
        code: 1102,
        category: ts.DiagnosticCategory.Error,
        key: "'delete' cannot be called on an identifier in strict mode."
      },
      A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement: {
        code: 1104,
        category: ts.DiagnosticCategory.Error,
        key: "A 'continue' statement can only be used within an enclosing iteration statement."
      },
      A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement: {
        code: 1105,
        category: ts.DiagnosticCategory.Error,
        key: "A 'break' statement can only be used within an enclosing iteration or switch statement."
      },
      Jump_target_cannot_cross_function_boundary: {
        code: 1107,
        category: ts.DiagnosticCategory.Error,
        key: "Jump target cannot cross function boundary."
      },
      A_return_statement_can_only_be_used_within_a_function_body: {
        code: 1108,
        category: ts.DiagnosticCategory.Error,
        key: "A 'return' statement can only be used within a function body."
      },
      Expression_expected: {
        code: 1109,
        category: ts.DiagnosticCategory.Error,
        key: "Expression expected."
      },
      Type_expected: {
        code: 1110,
        category: ts.DiagnosticCategory.Error,
        key: "Type expected."
      },
      A_class_member_cannot_be_declared_optional: {
        code: 1112,
        category: ts.DiagnosticCategory.Error,
        key: "A class member cannot be declared optional."
      },
      A_default_clause_cannot_appear_more_than_once_in_a_switch_statement: {
        code: 1113,
        category: ts.DiagnosticCategory.Error,
        key: "A 'default' clause cannot appear more than once in a 'switch' statement."
      },
      Duplicate_label_0: {
        code: 1114,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate label '{0}'"
      },
      A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement: {
        code: 1115,
        category: ts.DiagnosticCategory.Error,
        key: "A 'continue' statement can only jump to a label of an enclosing iteration statement."
      },
      A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement: {
        code: 1116,
        category: ts.DiagnosticCategory.Error,
        key: "A 'break' statement can only jump to a label of an enclosing statement."
      },
      An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode: {
        code: 1117,
        category: ts.DiagnosticCategory.Error,
        key: "An object literal cannot have multiple properties with the same name in strict mode."
      },
      An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name: {
        code: 1118,
        category: ts.DiagnosticCategory.Error,
        key: "An object literal cannot have multiple get/set accessors with the same name."
      },
      An_object_literal_cannot_have_property_and_accessor_with_the_same_name: {
        code: 1119,
        category: ts.DiagnosticCategory.Error,
        key: "An object literal cannot have property and accessor with the same name."
      },
      An_export_assignment_cannot_have_modifiers: {
        code: 1120,
        category: ts.DiagnosticCategory.Error,
        key: "An export assignment cannot have modifiers."
      },
      Octal_literals_are_not_allowed_in_strict_mode: {
        code: 1121,
        category: ts.DiagnosticCategory.Error,
        key: "Octal literals are not allowed in strict mode."
      },
      A_tuple_type_element_list_cannot_be_empty: {
        code: 1122,
        category: ts.DiagnosticCategory.Error,
        key: "A tuple type element list cannot be empty."
      },
      Variable_declaration_list_cannot_be_empty: {
        code: 1123,
        category: ts.DiagnosticCategory.Error,
        key: "Variable declaration list cannot be empty."
      },
      Digit_expected: {
        code: 1124,
        category: ts.DiagnosticCategory.Error,
        key: "Digit expected."
      },
      Hexadecimal_digit_expected: {
        code: 1125,
        category: ts.DiagnosticCategory.Error,
        key: "Hexadecimal digit expected."
      },
      Unexpected_end_of_text: {
        code: 1126,
        category: ts.DiagnosticCategory.Error,
        key: "Unexpected end of text."
      },
      Invalid_character: {
        code: 1127,
        category: ts.DiagnosticCategory.Error,
        key: "Invalid character."
      },
      Declaration_or_statement_expected: {
        code: 1128,
        category: ts.DiagnosticCategory.Error,
        key: "Declaration or statement expected."
      },
      Statement_expected: {
        code: 1129,
        category: ts.DiagnosticCategory.Error,
        key: "Statement expected."
      },
      case_or_default_expected: {
        code: 1130,
        category: ts.DiagnosticCategory.Error,
        key: "'case' or 'default' expected."
      },
      Property_or_signature_expected: {
        code: 1131,
        category: ts.DiagnosticCategory.Error,
        key: "Property or signature expected."
      },
      Enum_member_expected: {
        code: 1132,
        category: ts.DiagnosticCategory.Error,
        key: "Enum member expected."
      },
      Variable_declaration_expected: {
        code: 1134,
        category: ts.DiagnosticCategory.Error,
        key: "Variable declaration expected."
      },
      Argument_expression_expected: {
        code: 1135,
        category: ts.DiagnosticCategory.Error,
        key: "Argument expression expected."
      },
      Property_assignment_expected: {
        code: 1136,
        category: ts.DiagnosticCategory.Error,
        key: "Property assignment expected."
      },
      Expression_or_comma_expected: {
        code: 1137,
        category: ts.DiagnosticCategory.Error,
        key: "Expression or comma expected."
      },
      Parameter_declaration_expected: {
        code: 1138,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter declaration expected."
      },
      Type_parameter_declaration_expected: {
        code: 1139,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter declaration expected."
      },
      Type_argument_expected: {
        code: 1140,
        category: ts.DiagnosticCategory.Error,
        key: "Type argument expected."
      },
      String_literal_expected: {
        code: 1141,
        category: ts.DiagnosticCategory.Error,
        key: "String literal expected."
      },
      Line_break_not_permitted_here: {
        code: 1142,
        category: ts.DiagnosticCategory.Error,
        key: "Line break not permitted here."
      },
      or_expected: {
        code: 1144,
        category: ts.DiagnosticCategory.Error,
        key: "'{' or ';' expected."
      },
      Modifiers_not_permitted_on_index_signature_members: {
        code: 1145,
        category: ts.DiagnosticCategory.Error,
        key: "Modifiers not permitted on index signature members."
      },
      Declaration_expected: {
        code: 1146,
        category: ts.DiagnosticCategory.Error,
        key: "Declaration expected."
      },
      Import_declarations_in_a_namespace_cannot_reference_a_module: {
        code: 1147,
        category: ts.DiagnosticCategory.Error,
        key: "Import declarations in a namespace cannot reference a module."
      },
      Cannot_compile_modules_unless_the_module_flag_is_provided: {
        code: 1148,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot compile modules unless the '--module' flag is provided."
      },
      File_name_0_differs_from_already_included_file_name_1_only_in_casing: {
        code: 1149,
        category: ts.DiagnosticCategory.Error,
        key: "File name '{0}' differs from already included file name '{1}' only in casing"
      },
      new_T_cannot_be_used_to_create_an_array_Use_new_Array_T_instead: {
        code: 1150,
        category: ts.DiagnosticCategory.Error,
        key: "'new T[]' cannot be used to create an array. Use 'new Array<T>()' instead."
      },
      const_declarations_must_be_initialized: {
        code: 1155,
        category: ts.DiagnosticCategory.Error,
        key: "'const' declarations must be initialized"
      },
      const_declarations_can_only_be_declared_inside_a_block: {
        code: 1156,
        category: ts.DiagnosticCategory.Error,
        key: "'const' declarations can only be declared inside a block."
      },
      let_declarations_can_only_be_declared_inside_a_block: {
        code: 1157,
        category: ts.DiagnosticCategory.Error,
        key: "'let' declarations can only be declared inside a block."
      },
      Unterminated_template_literal: {
        code: 1160,
        category: ts.DiagnosticCategory.Error,
        key: "Unterminated template literal."
      },
      Unterminated_regular_expression_literal: {
        code: 1161,
        category: ts.DiagnosticCategory.Error,
        key: "Unterminated regular expression literal."
      },
      An_object_member_cannot_be_declared_optional: {
        code: 1162,
        category: ts.DiagnosticCategory.Error,
        key: "An object member cannot be declared optional."
      },
      A_yield_expression_is_only_allowed_in_a_generator_body: {
        code: 1163,
        category: ts.DiagnosticCategory.Error,
        key: "A 'yield' expression is only allowed in a generator body."
      },
      Computed_property_names_are_not_allowed_in_enums: {
        code: 1164,
        category: ts.DiagnosticCategory.Error,
        key: "Computed property names are not allowed in enums."
      },
      A_computed_property_name_in_an_ambient_context_must_directly_refer_to_a_built_in_symbol: {
        code: 1165,
        category: ts.DiagnosticCategory.Error,
        key: "A computed property name in an ambient context must directly refer to a built-in symbol."
      },
      A_computed_property_name_in_a_class_property_declaration_must_directly_refer_to_a_built_in_symbol: {
        code: 1166,
        category: ts.DiagnosticCategory.Error,
        key: "A computed property name in a class property declaration must directly refer to a built-in symbol."
      },
      A_computed_property_name_in_a_method_overload_must_directly_refer_to_a_built_in_symbol: {
        code: 1168,
        category: ts.DiagnosticCategory.Error,
        key: "A computed property name in a method overload must directly refer to a built-in symbol."
      },
      A_computed_property_name_in_an_interface_must_directly_refer_to_a_built_in_symbol: {
        code: 1169,
        category: ts.DiagnosticCategory.Error,
        key: "A computed property name in an interface must directly refer to a built-in symbol."
      },
      A_computed_property_name_in_a_type_literal_must_directly_refer_to_a_built_in_symbol: {
        code: 1170,
        category: ts.DiagnosticCategory.Error,
        key: "A computed property name in a type literal must directly refer to a built-in symbol."
      },
      A_comma_expression_is_not_allowed_in_a_computed_property_name: {
        code: 1171,
        category: ts.DiagnosticCategory.Error,
        key: "A comma expression is not allowed in a computed property name."
      },
      extends_clause_already_seen: {
        code: 1172,
        category: ts.DiagnosticCategory.Error,
        key: "'extends' clause already seen."
      },
      extends_clause_must_precede_implements_clause: {
        code: 1173,
        category: ts.DiagnosticCategory.Error,
        key: "'extends' clause must precede 'implements' clause."
      },
      Classes_can_only_extend_a_single_class: {
        code: 1174,
        category: ts.DiagnosticCategory.Error,
        key: "Classes can only extend a single class."
      },
      implements_clause_already_seen: {
        code: 1175,
        category: ts.DiagnosticCategory.Error,
        key: "'implements' clause already seen."
      },
      Interface_declaration_cannot_have_implements_clause: {
        code: 1176,
        category: ts.DiagnosticCategory.Error,
        key: "Interface declaration cannot have 'implements' clause."
      },
      Binary_digit_expected: {
        code: 1177,
        category: ts.DiagnosticCategory.Error,
        key: "Binary digit expected."
      },
      Octal_digit_expected: {
        code: 1178,
        category: ts.DiagnosticCategory.Error,
        key: "Octal digit expected."
      },
      Unexpected_token_expected: {
        code: 1179,
        category: ts.DiagnosticCategory.Error,
        key: "Unexpected token. '{' expected."
      },
      Property_destructuring_pattern_expected: {
        code: 1180,
        category: ts.DiagnosticCategory.Error,
        key: "Property destructuring pattern expected."
      },
      Array_element_destructuring_pattern_expected: {
        code: 1181,
        category: ts.DiagnosticCategory.Error,
        key: "Array element destructuring pattern expected."
      },
      A_destructuring_declaration_must_have_an_initializer: {
        code: 1182,
        category: ts.DiagnosticCategory.Error,
        key: "A destructuring declaration must have an initializer."
      },
      An_implementation_cannot_be_declared_in_ambient_contexts: {
        code: 1184,
        category: ts.DiagnosticCategory.Error,
        key: "An implementation cannot be declared in ambient contexts."
      },
      Modifiers_cannot_appear_here: {
        code: 1184,
        category: ts.DiagnosticCategory.Error,
        key: "Modifiers cannot appear here."
      },
      Merge_conflict_marker_encountered: {
        code: 1185,
        category: ts.DiagnosticCategory.Error,
        key: "Merge conflict marker encountered."
      },
      A_rest_element_cannot_have_an_initializer: {
        code: 1186,
        category: ts.DiagnosticCategory.Error,
        key: "A rest element cannot have an initializer."
      },
      A_parameter_property_may_not_be_a_binding_pattern: {
        code: 1187,
        category: ts.DiagnosticCategory.Error,
        key: "A parameter property may not be a binding pattern."
      },
      Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement: {
        code: 1188,
        category: ts.DiagnosticCategory.Error,
        key: "Only a single variable declaration is allowed in a 'for...of' statement."
      },
      The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer: {
        code: 1189,
        category: ts.DiagnosticCategory.Error,
        key: "The variable declaration of a 'for...in' statement cannot have an initializer."
      },
      The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer: {
        code: 1190,
        category: ts.DiagnosticCategory.Error,
        key: "The variable declaration of a 'for...of' statement cannot have an initializer."
      },
      An_import_declaration_cannot_have_modifiers: {
        code: 1191,
        category: ts.DiagnosticCategory.Error,
        key: "An import declaration cannot have modifiers."
      },
      Module_0_has_no_default_export: {
        code: 1192,
        category: ts.DiagnosticCategory.Error,
        key: "Module '{0}' has no default export."
      },
      An_export_declaration_cannot_have_modifiers: {
        code: 1193,
        category: ts.DiagnosticCategory.Error,
        key: "An export declaration cannot have modifiers."
      },
      Export_declarations_are_not_permitted_in_a_namespace: {
        code: 1194,
        category: ts.DiagnosticCategory.Error,
        key: "Export declarations are not permitted in a namespace."
      },
      Catch_clause_variable_name_must_be_an_identifier: {
        code: 1195,
        category: ts.DiagnosticCategory.Error,
        key: "Catch clause variable name must be an identifier."
      },
      Catch_clause_variable_cannot_have_a_type_annotation: {
        code: 1196,
        category: ts.DiagnosticCategory.Error,
        key: "Catch clause variable cannot have a type annotation."
      },
      Catch_clause_variable_cannot_have_an_initializer: {
        code: 1197,
        category: ts.DiagnosticCategory.Error,
        key: "Catch clause variable cannot have an initializer."
      },
      An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive: {
        code: 1198,
        category: ts.DiagnosticCategory.Error,
        key: "An extended Unicode escape value must be between 0x0 and 0x10FFFF inclusive."
      },
      Unterminated_Unicode_escape_sequence: {
        code: 1199,
        category: ts.DiagnosticCategory.Error,
        key: "Unterminated Unicode escape sequence."
      },
      Line_terminator_not_permitted_before_arrow: {
        code: 1200,
        category: ts.DiagnosticCategory.Error,
        key: "Line terminator not permitted before arrow."
      },
      Import_assignment_cannot_be_used_when_targeting_ECMAScript_6_or_higher_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_or_import_d_from_mod_instead: {
        code: 1202,
        category: ts.DiagnosticCategory.Error,
        key: "Import assignment cannot be used when targeting ECMAScript 6 or higher. Consider using 'import * as ns from \"mod\"', 'import {a} from \"mod\"' or 'import d from \"mod\"' instead."
      },
      Export_assignment_cannot_be_used_when_targeting_ECMAScript_6_or_higher_Consider_using_export_default_instead: {
        code: 1203,
        category: ts.DiagnosticCategory.Error,
        key: "Export assignment cannot be used when targeting ECMAScript 6 or higher. Consider using 'export default' instead."
      },
      Cannot_compile_modules_into_commonjs_amd_system_or_umd_when_targeting_ES6_or_higher: {
        code: 1204,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot compile modules into 'commonjs', 'amd', 'system' or 'umd' when targeting 'ES6' or higher."
      },
      Decorators_are_only_available_when_targeting_ECMAScript_5_and_higher: {
        code: 1205,
        category: ts.DiagnosticCategory.Error,
        key: "Decorators are only available when targeting ECMAScript 5 and higher."
      },
      Decorators_are_not_valid_here: {
        code: 1206,
        category: ts.DiagnosticCategory.Error,
        key: "Decorators are not valid here."
      },
      Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name: {
        code: 1207,
        category: ts.DiagnosticCategory.Error,
        key: "Decorators cannot be applied to multiple get/set accessors of the same name."
      },
      Cannot_compile_namespaces_when_the_isolatedModules_flag_is_provided: {
        code: 1208,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot compile namespaces when the '--isolatedModules' flag is provided."
      },
      Ambient_const_enums_are_not_allowed_when_the_isolatedModules_flag_is_provided: {
        code: 1209,
        category: ts.DiagnosticCategory.Error,
        key: "Ambient const enums are not allowed when the '--isolatedModules' flag is provided."
      },
      Invalid_use_of_0_Class_definitions_are_automatically_in_strict_mode: {
        code: 1210,
        category: ts.DiagnosticCategory.Error,
        key: "Invalid use of '{0}'. Class definitions are automatically in strict mode."
      },
      A_class_declaration_without_the_default_modifier_must_have_a_name: {
        code: 1211,
        category: ts.DiagnosticCategory.Error,
        key: "A class declaration without the 'default' modifier must have a name"
      },
      Identifier_expected_0_is_a_reserved_word_in_strict_mode: {
        code: 1212,
        category: ts.DiagnosticCategory.Error,
        key: "Identifier expected. '{0}' is a reserved word in strict mode"
      },
      Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode: {
        code: 1213,
        category: ts.DiagnosticCategory.Error,
        key: "Identifier expected. '{0}' is a reserved word in strict mode. Class definitions are automatically in strict mode."
      },
      Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode: {
        code: 1214,
        category: ts.DiagnosticCategory.Error,
        key: "Identifier expected. '{0}' is a reserved word in strict mode. Modules are automatically in strict mode."
      },
      Invalid_use_of_0_Modules_are_automatically_in_strict_mode: {
        code: 1215,
        category: ts.DiagnosticCategory.Error,
        key: "Invalid use of '{0}'. Modules are automatically in strict mode."
      },
      Export_assignment_is_not_supported_when_module_flag_is_system: {
        code: 1218,
        category: ts.DiagnosticCategory.Error,
        key: "Export assignment is not supported when '--module' flag is 'system'."
      },
      Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Specify_experimentalDecorators_to_remove_this_warning: {
        code: 1219,
        category: ts.DiagnosticCategory.Error,
        key: "Experimental support for decorators is a feature that is subject to change in a future release. Specify '--experimentalDecorators' to remove this warning."
      },
      Generators_are_only_available_when_targeting_ECMAScript_6_or_higher: {
        code: 1220,
        category: ts.DiagnosticCategory.Error,
        key: "Generators are only available when targeting ECMAScript 6 or higher."
      },
      Generators_are_not_allowed_in_an_ambient_context: {
        code: 1221,
        category: ts.DiagnosticCategory.Error,
        key: "Generators are not allowed in an ambient context."
      },
      An_overload_signature_cannot_be_declared_as_a_generator: {
        code: 1222,
        category: ts.DiagnosticCategory.Error,
        key: "An overload signature cannot be declared as a generator."
      },
      _0_tag_already_specified: {
        code: 1223,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' tag already specified."
      },
      Signature_0_must_have_a_type_predicate: {
        code: 1224,
        category: ts.DiagnosticCategory.Error,
        key: "Signature '{0}' must have a type predicate."
      },
      Cannot_find_parameter_0: {
        code: 1225,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot find parameter '{0}'."
      },
      Type_predicate_0_is_not_assignable_to_1: {
        code: 1226,
        category: ts.DiagnosticCategory.Error,
        key: "Type predicate '{0}' is not assignable to '{1}'."
      },
      Parameter_0_is_not_in_the_same_position_as_parameter_1: {
        code: 1227,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' is not in the same position as parameter '{1}'."
      },
      A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods: {
        code: 1228,
        category: ts.DiagnosticCategory.Error,
        key: "A type predicate is only allowed in return type position for functions and methods."
      },
      A_type_predicate_cannot_reference_a_rest_parameter: {
        code: 1229,
        category: ts.DiagnosticCategory.Error,
        key: "A type predicate cannot reference a rest parameter."
      },
      A_type_predicate_cannot_reference_element_0_in_a_binding_pattern: {
        code: 1230,
        category: ts.DiagnosticCategory.Error,
        key: "A type predicate cannot reference element '{0}' in a binding pattern."
      },
      An_export_assignment_can_only_be_used_in_a_module: {
        code: 1231,
        category: ts.DiagnosticCategory.Error,
        key: "An export assignment can only be used in a module."
      },
      An_import_declaration_can_only_be_used_in_a_namespace_or_module: {
        code: 1232,
        category: ts.DiagnosticCategory.Error,
        key: "An import declaration can only be used in a namespace or module."
      },
      An_export_declaration_can_only_be_used_in_a_module: {
        code: 1233,
        category: ts.DiagnosticCategory.Error,
        key: "An export declaration can only be used in a module."
      },
      An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file: {
        code: 1234,
        category: ts.DiagnosticCategory.Error,
        key: "An ambient module declaration is only allowed at the top level in a file."
      },
      A_namespace_declaration_is_only_allowed_in_a_namespace_or_module: {
        code: 1235,
        category: ts.DiagnosticCategory.Error,
        key: "A namespace declaration is only allowed in a namespace or module."
      },
      Experimental_support_for_async_functions_is_a_feature_that_is_subject_to_change_in_a_future_release_Specify_experimentalAsyncFunctions_to_remove_this_warning: {
        code: 1236,
        category: ts.DiagnosticCategory.Error,
        key: "Experimental support for async functions is a feature that is subject to change in a future release. Specify '--experimentalAsyncFunctions' to remove this warning."
      },
      with_statements_are_not_allowed_in_an_async_function_block: {
        code: 1300,
        category: ts.DiagnosticCategory.Error,
        key: "'with' statements are not allowed in an async function block."
      },
      await_expression_is_only_allowed_within_an_async_function: {
        code: 1308,
        category: ts.DiagnosticCategory.Error,
        key: "'await' expression is only allowed within an async function."
      },
      Async_functions_are_only_available_when_targeting_ECMAScript_6_and_higher: {
        code: 1311,
        category: ts.DiagnosticCategory.Error,
        key: "Async functions are only available when targeting ECMAScript 6 and higher."
      },
      The_return_type_of_a_property_decorator_function_must_be_either_void_or_any: {
        code: 1236,
        category: ts.DiagnosticCategory.Error,
        key: "The return type of a property decorator function must be either 'void' or 'any'."
      },
      The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any: {
        code: 1237,
        category: ts.DiagnosticCategory.Error,
        key: "The return type of a parameter decorator function must be either 'void' or 'any'."
      },
      Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression: {
        code: 1238,
        category: ts.DiagnosticCategory.Error,
        key: "Unable to resolve signature of class decorator when called as an expression."
      },
      Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression: {
        code: 1239,
        category: ts.DiagnosticCategory.Error,
        key: "Unable to resolve signature of parameter decorator when called as an expression."
      },
      Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression: {
        code: 1240,
        category: ts.DiagnosticCategory.Error,
        key: "Unable to resolve signature of property decorator when called as an expression."
      },
      Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression: {
        code: 1241,
        category: ts.DiagnosticCategory.Error,
        key: "Unable to resolve signature of method decorator when called as an expression."
      },
      abstract_modifier_can_only_appear_on_a_class_or_method_declaration: {
        code: 1242,
        category: ts.DiagnosticCategory.Error,
        key: "'abstract' modifier can only appear on a class or method declaration."
      },
      _0_modifier_cannot_be_used_with_1_modifier: {
        code: 1243,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' modifier cannot be used with '{1}' modifier."
      },
      Abstract_methods_can_only_appear_within_an_abstract_class: {
        code: 1244,
        category: ts.DiagnosticCategory.Error,
        key: "Abstract methods can only appear within an abstract class."
      },
      Method_0_cannot_have_an_implementation_because_it_is_marked_abstract: {
        code: 1245,
        category: ts.DiagnosticCategory.Error,
        key: "Method '{0}' cannot have an implementation because it is marked abstract."
      },
      Duplicate_identifier_0: {
        code: 2300,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate identifier '{0}'."
      },
      Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: {
        code: 2301,
        category: ts.DiagnosticCategory.Error,
        key: "Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."
      },
      Static_members_cannot_reference_class_type_parameters: {
        code: 2302,
        category: ts.DiagnosticCategory.Error,
        key: "Static members cannot reference class type parameters."
      },
      Circular_definition_of_import_alias_0: {
        code: 2303,
        category: ts.DiagnosticCategory.Error,
        key: "Circular definition of import alias '{0}'."
      },
      Cannot_find_name_0: {
        code: 2304,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot find name '{0}'."
      },
      Module_0_has_no_exported_member_1: {
        code: 2305,
        category: ts.DiagnosticCategory.Error,
        key: "Module '{0}' has no exported member '{1}'."
      },
      File_0_is_not_a_module: {
        code: 2306,
        category: ts.DiagnosticCategory.Error,
        key: "File '{0}' is not a module."
      },
      Cannot_find_module_0: {
        code: 2307,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot find module '{0}'."
      },
      An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements: {
        code: 2309,
        category: ts.DiagnosticCategory.Error,
        key: "An export assignment cannot be used in a module with other exported elements."
      },
      Type_0_recursively_references_itself_as_a_base_type: {
        code: 2310,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' recursively references itself as a base type."
      },
      A_class_may_only_extend_another_class: {
        code: 2311,
        category: ts.DiagnosticCategory.Error,
        key: "A class may only extend another class."
      },
      An_interface_may_only_extend_a_class_or_another_interface: {
        code: 2312,
        category: ts.DiagnosticCategory.Error,
        key: "An interface may only extend a class or another interface."
      },
      Constraint_of_a_type_parameter_cannot_reference_any_type_parameter_from_the_same_type_parameter_list: {
        code: 2313,
        category: ts.DiagnosticCategory.Error,
        key: "Constraint of a type parameter cannot reference any type parameter from the same type parameter list."
      },
      Generic_type_0_requires_1_type_argument_s: {
        code: 2314,
        category: ts.DiagnosticCategory.Error,
        key: "Generic type '{0}' requires {1} type argument(s)."
      },
      Type_0_is_not_generic: {
        code: 2315,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' is not generic."
      },
      Global_type_0_must_be_a_class_or_interface_type: {
        code: 2316,
        category: ts.DiagnosticCategory.Error,
        key: "Global type '{0}' must be a class or interface type."
      },
      Global_type_0_must_have_1_type_parameter_s: {
        code: 2317,
        category: ts.DiagnosticCategory.Error,
        key: "Global type '{0}' must have {1} type parameter(s)."
      },
      Cannot_find_global_type_0: {
        code: 2318,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot find global type '{0}'."
      },
      Named_property_0_of_types_1_and_2_are_not_identical: {
        code: 2319,
        category: ts.DiagnosticCategory.Error,
        key: "Named property '{0}' of types '{1}' and '{2}' are not identical."
      },
      Interface_0_cannot_simultaneously_extend_types_1_and_2: {
        code: 2320,
        category: ts.DiagnosticCategory.Error,
        key: "Interface '{0}' cannot simultaneously extend types '{1}' and '{2}'."
      },
      Excessive_stack_depth_comparing_types_0_and_1: {
        code: 2321,
        category: ts.DiagnosticCategory.Error,
        key: "Excessive stack depth comparing types '{0}' and '{1}'."
      },
      Type_0_is_not_assignable_to_type_1: {
        code: 2322,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' is not assignable to type '{1}'."
      },
      Property_0_is_missing_in_type_1: {
        code: 2324,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' is missing in type '{1}'."
      },
      Property_0_is_private_in_type_1_but_not_in_type_2: {
        code: 2325,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' is private in type '{1}' but not in type '{2}'."
      },
      Types_of_property_0_are_incompatible: {
        code: 2326,
        category: ts.DiagnosticCategory.Error,
        key: "Types of property '{0}' are incompatible."
      },
      Property_0_is_optional_in_type_1_but_required_in_type_2: {
        code: 2327,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' is optional in type '{1}' but required in type '{2}'."
      },
      Types_of_parameters_0_and_1_are_incompatible: {
        code: 2328,
        category: ts.DiagnosticCategory.Error,
        key: "Types of parameters '{0}' and '{1}' are incompatible."
      },
      Index_signature_is_missing_in_type_0: {
        code: 2329,
        category: ts.DiagnosticCategory.Error,
        key: "Index signature is missing in type '{0}'."
      },
      Index_signatures_are_incompatible: {
        code: 2330,
        category: ts.DiagnosticCategory.Error,
        key: "Index signatures are incompatible."
      },
      this_cannot_be_referenced_in_a_module_or_namespace_body: {
        code: 2331,
        category: ts.DiagnosticCategory.Error,
        key: "'this' cannot be referenced in a module or namespace body."
      },
      this_cannot_be_referenced_in_current_location: {
        code: 2332,
        category: ts.DiagnosticCategory.Error,
        key: "'this' cannot be referenced in current location."
      },
      this_cannot_be_referenced_in_constructor_arguments: {
        code: 2333,
        category: ts.DiagnosticCategory.Error,
        key: "'this' cannot be referenced in constructor arguments."
      },
      this_cannot_be_referenced_in_a_static_property_initializer: {
        code: 2334,
        category: ts.DiagnosticCategory.Error,
        key: "'this' cannot be referenced in a static property initializer."
      },
      super_can_only_be_referenced_in_a_derived_class: {
        code: 2335,
        category: ts.DiagnosticCategory.Error,
        key: "'super' can only be referenced in a derived class."
      },
      super_cannot_be_referenced_in_constructor_arguments: {
        code: 2336,
        category: ts.DiagnosticCategory.Error,
        key: "'super' cannot be referenced in constructor arguments."
      },
      Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors: {
        code: 2337,
        category: ts.DiagnosticCategory.Error,
        key: "Super calls are not permitted outside constructors or in nested functions inside constructors."
      },
      super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class: {
        code: 2338,
        category: ts.DiagnosticCategory.Error,
        key: "'super' property access is permitted only in a constructor, member function, or member accessor of a derived class."
      },
      Property_0_does_not_exist_on_type_1: {
        code: 2339,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' does not exist on type '{1}'."
      },
      Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword: {
        code: 2340,
        category: ts.DiagnosticCategory.Error,
        key: "Only public and protected methods of the base class are accessible via the 'super' keyword."
      },
      Property_0_is_private_and_only_accessible_within_class_1: {
        code: 2341,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' is private and only accessible within class '{1}'."
      },
      An_index_expression_argument_must_be_of_type_string_number_symbol_or_any: {
        code: 2342,
        category: ts.DiagnosticCategory.Error,
        key: "An index expression argument must be of type 'string', 'number', 'symbol, or 'any'."
      },
      Type_0_does_not_satisfy_the_constraint_1: {
        code: 2344,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' does not satisfy the constraint '{1}'."
      },
      Argument_of_type_0_is_not_assignable_to_parameter_of_type_1: {
        code: 2345,
        category: ts.DiagnosticCategory.Error,
        key: "Argument of type '{0}' is not assignable to parameter of type '{1}'."
      },
      Supplied_parameters_do_not_match_any_signature_of_call_target: {
        code: 2346,
        category: ts.DiagnosticCategory.Error,
        key: "Supplied parameters do not match any signature of call target."
      },
      Untyped_function_calls_may_not_accept_type_arguments: {
        code: 2347,
        category: ts.DiagnosticCategory.Error,
        key: "Untyped function calls may not accept type arguments."
      },
      Value_of_type_0_is_not_callable_Did_you_mean_to_include_new: {
        code: 2348,
        category: ts.DiagnosticCategory.Error,
        key: "Value of type '{0}' is not callable. Did you mean to include 'new'?"
      },
      Cannot_invoke_an_expression_whose_type_lacks_a_call_signature: {
        code: 2349,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot invoke an expression whose type lacks a call signature."
      },
      Only_a_void_function_can_be_called_with_the_new_keyword: {
        code: 2350,
        category: ts.DiagnosticCategory.Error,
        key: "Only a void function can be called with the 'new' keyword."
      },
      Cannot_use_new_with_an_expression_whose_type_lacks_a_call_or_construct_signature: {
        code: 2351,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot use 'new' with an expression whose type lacks a call or construct signature."
      },
      Neither_type_0_nor_type_1_is_assignable_to_the_other: {
        code: 2352,
        category: ts.DiagnosticCategory.Error,
        key: "Neither type '{0}' nor type '{1}' is assignable to the other."
      },
      Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1: {
        code: 2353,
        category: ts.DiagnosticCategory.Error,
        key: "Object literal may only specify known properties, and '{0}' does not exist in type '{1}'."
      },
      No_best_common_type_exists_among_return_expressions: {
        code: 2354,
        category: ts.DiagnosticCategory.Error,
        key: "No best common type exists among return expressions."
      },
      A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value_or_consist_of_a_single_throw_statement: {
        code: 2355,
        category: ts.DiagnosticCategory.Error,
        key: "A function whose declared type is neither 'void' nor 'any' must return a value or consist of a single 'throw' statement."
      },
      An_arithmetic_operand_must_be_of_type_any_number_or_an_enum_type: {
        code: 2356,
        category: ts.DiagnosticCategory.Error,
        key: "An arithmetic operand must be of type 'any', 'number' or an enum type."
      },
      The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_property_or_indexer: {
        code: 2357,
        category: ts.DiagnosticCategory.Error,
        key: "The operand of an increment or decrement operator must be a variable, property or indexer."
      },
      The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: {
        code: 2358,
        category: ts.DiagnosticCategory.Error,
        key: "The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter."
      },
      The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type: {
        code: 2359,
        category: ts.DiagnosticCategory.Error,
        key: "The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type."
      },
      The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol: {
        code: 2360,
        category: ts.DiagnosticCategory.Error,
        key: "The left-hand side of an 'in' expression must be of type 'any', 'string', 'number', or 'symbol'."
      },
      The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: {
        code: 2361,
        category: ts.DiagnosticCategory.Error,
        key: "The right-hand side of an 'in' expression must be of type 'any', an object type or a type parameter"
      },
      The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type: {
        code: 2362,
        category: ts.DiagnosticCategory.Error,
        key: "The left-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type."
      },
      The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type: {
        code: 2363,
        category: ts.DiagnosticCategory.Error,
        key: "The right-hand side of an arithmetic operation must be of type 'any', 'number' or an enum type."
      },
      Invalid_left_hand_side_of_assignment_expression: {
        code: 2364,
        category: ts.DiagnosticCategory.Error,
        key: "Invalid left-hand side of assignment expression."
      },
      Operator_0_cannot_be_applied_to_types_1_and_2: {
        code: 2365,
        category: ts.DiagnosticCategory.Error,
        key: "Operator '{0}' cannot be applied to types '{1}' and '{2}'."
      },
      Type_parameter_name_cannot_be_0: {
        code: 2368,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter name cannot be '{0}'"
      },
      A_parameter_property_is_only_allowed_in_a_constructor_implementation: {
        code: 2369,
        category: ts.DiagnosticCategory.Error,
        key: "A parameter property is only allowed in a constructor implementation."
      },
      A_rest_parameter_must_be_of_an_array_type: {
        code: 2370,
        category: ts.DiagnosticCategory.Error,
        key: "A rest parameter must be of an array type."
      },
      A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation: {
        code: 2371,
        category: ts.DiagnosticCategory.Error,
        key: "A parameter initializer is only allowed in a function or constructor implementation."
      },
      Parameter_0_cannot_be_referenced_in_its_initializer: {
        code: 2372,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' cannot be referenced in its initializer."
      },
      Initializer_of_parameter_0_cannot_reference_identifier_1_declared_after_it: {
        code: 2373,
        category: ts.DiagnosticCategory.Error,
        key: "Initializer of parameter '{0}' cannot reference identifier '{1}' declared after it."
      },
      Duplicate_string_index_signature: {
        code: 2374,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate string index signature."
      },
      Duplicate_number_index_signature: {
        code: 2375,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate number index signature."
      },
      A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_properties_or_has_parameter_properties: {
        code: 2376,
        category: ts.DiagnosticCategory.Error,
        key: "A 'super' call must be the first statement in the constructor when a class contains initialized properties or has parameter properties."
      },
      Constructors_for_derived_classes_must_contain_a_super_call: {
        code: 2377,
        category: ts.DiagnosticCategory.Error,
        key: "Constructors for derived classes must contain a 'super' call."
      },
      A_get_accessor_must_return_a_value_or_consist_of_a_single_throw_statement: {
        code: 2378,
        category: ts.DiagnosticCategory.Error,
        key: "A 'get' accessor must return a value or consist of a single 'throw' statement."
      },
      Getter_and_setter_accessors_do_not_agree_in_visibility: {
        code: 2379,
        category: ts.DiagnosticCategory.Error,
        key: "Getter and setter accessors do not agree in visibility."
      },
      get_and_set_accessor_must_have_the_same_type: {
        code: 2380,
        category: ts.DiagnosticCategory.Error,
        key: "'get' and 'set' accessor must have the same type."
      },
      A_signature_with_an_implementation_cannot_use_a_string_literal_type: {
        code: 2381,
        category: ts.DiagnosticCategory.Error,
        key: "A signature with an implementation cannot use a string literal type."
      },
      Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature: {
        code: 2382,
        category: ts.DiagnosticCategory.Error,
        key: "Specialized overload signature is not assignable to any non-specialized signature."
      },
      Overload_signatures_must_all_be_exported_or_not_exported: {
        code: 2383,
        category: ts.DiagnosticCategory.Error,
        key: "Overload signatures must all be exported or not exported."
      },
      Overload_signatures_must_all_be_ambient_or_non_ambient: {
        code: 2384,
        category: ts.DiagnosticCategory.Error,
        key: "Overload signatures must all be ambient or non-ambient."
      },
      Overload_signatures_must_all_be_public_private_or_protected: {
        code: 2385,
        category: ts.DiagnosticCategory.Error,
        key: "Overload signatures must all be public, private or protected."
      },
      Overload_signatures_must_all_be_optional_or_required: {
        code: 2386,
        category: ts.DiagnosticCategory.Error,
        key: "Overload signatures must all be optional or required."
      },
      Function_overload_must_be_static: {
        code: 2387,
        category: ts.DiagnosticCategory.Error,
        key: "Function overload must be static."
      },
      Function_overload_must_not_be_static: {
        code: 2388,
        category: ts.DiagnosticCategory.Error,
        key: "Function overload must not be static."
      },
      Function_implementation_name_must_be_0: {
        code: 2389,
        category: ts.DiagnosticCategory.Error,
        key: "Function implementation name must be '{0}'."
      },
      Constructor_implementation_is_missing: {
        code: 2390,
        category: ts.DiagnosticCategory.Error,
        key: "Constructor implementation is missing."
      },
      Function_implementation_is_missing_or_not_immediately_following_the_declaration: {
        code: 2391,
        category: ts.DiagnosticCategory.Error,
        key: "Function implementation is missing or not immediately following the declaration."
      },
      Multiple_constructor_implementations_are_not_allowed: {
        code: 2392,
        category: ts.DiagnosticCategory.Error,
        key: "Multiple constructor implementations are not allowed."
      },
      Duplicate_function_implementation: {
        code: 2393,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate function implementation."
      },
      Overload_signature_is_not_compatible_with_function_implementation: {
        code: 2394,
        category: ts.DiagnosticCategory.Error,
        key: "Overload signature is not compatible with function implementation."
      },
      Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local: {
        code: 2395,
        category: ts.DiagnosticCategory.Error,
        key: "Individual declarations in merged declaration '{0}' must be all exported or all local."
      },
      Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters: {
        code: 2396,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters."
      },
      Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference: {
        code: 2399,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference."
      },
      Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference: {
        code: 2400,
        category: ts.DiagnosticCategory.Error,
        key: "Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference."
      },
      Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference: {
        code: 2401,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate identifier '_super'. Compiler uses '_super' to capture base class reference."
      },
      Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference: {
        code: 2402,
        category: ts.DiagnosticCategory.Error,
        key: "Expression resolves to '_super' that compiler uses to capture base class reference."
      },
      Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2: {
        code: 2403,
        category: ts.DiagnosticCategory.Error,
        key: "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'."
      },
      The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation: {
        code: 2404,
        category: ts.DiagnosticCategory.Error,
        key: "The left-hand side of a 'for...in' statement cannot use a type annotation."
      },
      The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any: {
        code: 2405,
        category: ts.DiagnosticCategory.Error,
        key: "The left-hand side of a 'for...in' statement must be of type 'string' or 'any'."
      },
      Invalid_left_hand_side_in_for_in_statement: {
        code: 2406,
        category: ts.DiagnosticCategory.Error,
        key: "Invalid left-hand side in 'for...in' statement."
      },
      The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter: {
        code: 2407,
        category: ts.DiagnosticCategory.Error,
        key: "The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter."
      },
      Setters_cannot_return_a_value: {
        code: 2408,
        category: ts.DiagnosticCategory.Error,
        key: "Setters cannot return a value."
      },
      Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class: {
        code: 2409,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of constructor signature must be assignable to the instance type of the class"
      },
      All_symbols_within_a_with_block_will_be_resolved_to_any: {
        code: 2410,
        category: ts.DiagnosticCategory.Error,
        key: "All symbols within a 'with' block will be resolved to 'any'."
      },
      Property_0_of_type_1_is_not_assignable_to_string_index_type_2: {
        code: 2411,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' of type '{1}' is not assignable to string index type '{2}'."
      },
      Property_0_of_type_1_is_not_assignable_to_numeric_index_type_2: {
        code: 2412,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' of type '{1}' is not assignable to numeric index type '{2}'."
      },
      Numeric_index_type_0_is_not_assignable_to_string_index_type_1: {
        code: 2413,
        category: ts.DiagnosticCategory.Error,
        key: "Numeric index type '{0}' is not assignable to string index type '{1}'."
      },
      Class_name_cannot_be_0: {
        code: 2414,
        category: ts.DiagnosticCategory.Error,
        key: "Class name cannot be '{0}'"
      },
      Class_0_incorrectly_extends_base_class_1: {
        code: 2415,
        category: ts.DiagnosticCategory.Error,
        key: "Class '{0}' incorrectly extends base class '{1}'."
      },
      Class_static_side_0_incorrectly_extends_base_class_static_side_1: {
        code: 2417,
        category: ts.DiagnosticCategory.Error,
        key: "Class static side '{0}' incorrectly extends base class static side '{1}'."
      },
      Type_name_0_in_extends_clause_does_not_reference_constructor_function_for_0: {
        code: 2419,
        category: ts.DiagnosticCategory.Error,
        key: "Type name '{0}' in extends clause does not reference constructor function for '{0}'."
      },
      Class_0_incorrectly_implements_interface_1: {
        code: 2420,
        category: ts.DiagnosticCategory.Error,
        key: "Class '{0}' incorrectly implements interface '{1}'."
      },
      A_class_may_only_implement_another_class_or_interface: {
        code: 2422,
        category: ts.DiagnosticCategory.Error,
        key: "A class may only implement another class or interface."
      },
      Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor: {
        code: 2423,
        category: ts.DiagnosticCategory.Error,
        key: "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor."
      },
      Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_property: {
        code: 2424,
        category: ts.DiagnosticCategory.Error,
        key: "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member property."
      },
      Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function: {
        code: 2425,
        category: ts.DiagnosticCategory.Error,
        key: "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function."
      },
      Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function: {
        code: 2426,
        category: ts.DiagnosticCategory.Error,
        key: "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function."
      },
      Interface_name_cannot_be_0: {
        code: 2427,
        category: ts.DiagnosticCategory.Error,
        key: "Interface name cannot be '{0}'"
      },
      All_declarations_of_an_interface_must_have_identical_type_parameters: {
        code: 2428,
        category: ts.DiagnosticCategory.Error,
        key: "All declarations of an interface must have identical type parameters."
      },
      Interface_0_incorrectly_extends_interface_1: {
        code: 2430,
        category: ts.DiagnosticCategory.Error,
        key: "Interface '{0}' incorrectly extends interface '{1}'."
      },
      Enum_name_cannot_be_0: {
        code: 2431,
        category: ts.DiagnosticCategory.Error,
        key: "Enum name cannot be '{0}'"
      },
      In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element: {
        code: 2432,
        category: ts.DiagnosticCategory.Error,
        key: "In an enum with multiple declarations, only one declaration can omit an initializer for its first enum element."
      },
      A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged: {
        code: 2433,
        category: ts.DiagnosticCategory.Error,
        key: "A namespace declaration cannot be in a different file from a class or function with which it is merged"
      },
      A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged: {
        code: 2434,
        category: ts.DiagnosticCategory.Error,
        key: "A namespace declaration cannot be located prior to a class or function with which it is merged"
      },
      Ambient_modules_cannot_be_nested_in_other_modules: {
        code: 2435,
        category: ts.DiagnosticCategory.Error,
        key: "Ambient modules cannot be nested in other modules."
      },
      Ambient_module_declaration_cannot_specify_relative_module_name: {
        code: 2436,
        category: ts.DiagnosticCategory.Error,
        key: "Ambient module declaration cannot specify relative module name."
      },
      Module_0_is_hidden_by_a_local_declaration_with_the_same_name: {
        code: 2437,
        category: ts.DiagnosticCategory.Error,
        key: "Module '{0}' is hidden by a local declaration with the same name"
      },
      Import_name_cannot_be_0: {
        code: 2438,
        category: ts.DiagnosticCategory.Error,
        key: "Import name cannot be '{0}'"
      },
      Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name: {
        code: 2439,
        category: ts.DiagnosticCategory.Error,
        key: "Import or export declaration in an ambient module declaration cannot reference module through relative module name."
      },
      Import_declaration_conflicts_with_local_declaration_of_0: {
        code: 2440,
        category: ts.DiagnosticCategory.Error,
        key: "Import declaration conflicts with local declaration of '{0}'"
      },
      Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module: {
        code: 2441,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module."
      },
      Types_have_separate_declarations_of_a_private_property_0: {
        code: 2442,
        category: ts.DiagnosticCategory.Error,
        key: "Types have separate declarations of a private property '{0}'."
      },
      Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2: {
        code: 2443,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' is protected but type '{1}' is not a class derived from '{2}'."
      },
      Property_0_is_protected_in_type_1_but_public_in_type_2: {
        code: 2444,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' is protected in type '{1}' but public in type '{2}'."
      },
      Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses: {
        code: 2445,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' is protected and only accessible within class '{1}' and its subclasses."
      },
      Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1: {
        code: 2446,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' is protected and only accessible through an instance of class '{1}'."
      },
      The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead: {
        code: 2447,
        category: ts.DiagnosticCategory.Error,
        key: "The '{0}' operator is not allowed for boolean types. Consider using '{1}' instead."
      },
      Block_scoped_variable_0_used_before_its_declaration: {
        code: 2448,
        category: ts.DiagnosticCategory.Error,
        key: "Block-scoped variable '{0}' used before its declaration."
      },
      The_operand_of_an_increment_or_decrement_operator_cannot_be_a_constant: {
        code: 2449,
        category: ts.DiagnosticCategory.Error,
        key: "The operand of an increment or decrement operator cannot be a constant."
      },
      Left_hand_side_of_assignment_expression_cannot_be_a_constant: {
        code: 2450,
        category: ts.DiagnosticCategory.Error,
        key: "Left-hand side of assignment expression cannot be a constant."
      },
      Cannot_redeclare_block_scoped_variable_0: {
        code: 2451,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot redeclare block-scoped variable '{0}'."
      },
      An_enum_member_cannot_have_a_numeric_name: {
        code: 2452,
        category: ts.DiagnosticCategory.Error,
        key: "An enum member cannot have a numeric name."
      },
      The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_type_arguments_explicitly: {
        code: 2453,
        category: ts.DiagnosticCategory.Error,
        key: "The type argument for type parameter '{0}' cannot be inferred from the usage. Consider specifying the type arguments explicitly."
      },
      Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0: {
        code: 2455,
        category: ts.DiagnosticCategory.Error,
        key: "Type argument candidate '{1}' is not a valid type argument because it is not a supertype of candidate '{0}'."
      },
      Type_alias_0_circularly_references_itself: {
        code: 2456,
        category: ts.DiagnosticCategory.Error,
        key: "Type alias '{0}' circularly references itself."
      },
      Type_alias_name_cannot_be_0: {
        code: 2457,
        category: ts.DiagnosticCategory.Error,
        key: "Type alias name cannot be '{0}'"
      },
      An_AMD_module_cannot_have_multiple_name_assignments: {
        code: 2458,
        category: ts.DiagnosticCategory.Error,
        key: "An AMD module cannot have multiple name assignments."
      },
      Type_0_has_no_property_1_and_no_string_index_signature: {
        code: 2459,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' has no property '{1}' and no string index signature."
      },
      Type_0_has_no_property_1: {
        code: 2460,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' has no property '{1}'."
      },
      Type_0_is_not_an_array_type: {
        code: 2461,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' is not an array type."
      },
      A_rest_element_must_be_last_in_an_array_destructuring_pattern: {
        code: 2462,
        category: ts.DiagnosticCategory.Error,
        key: "A rest element must be last in an array destructuring pattern"
      },
      A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature: {
        code: 2463,
        category: ts.DiagnosticCategory.Error,
        key: "A binding pattern parameter cannot be optional in an implementation signature."
      },
      A_computed_property_name_must_be_of_type_string_number_symbol_or_any: {
        code: 2464,
        category: ts.DiagnosticCategory.Error,
        key: "A computed property name must be of type 'string', 'number', 'symbol', or 'any'."
      },
      this_cannot_be_referenced_in_a_computed_property_name: {
        code: 2465,
        category: ts.DiagnosticCategory.Error,
        key: "'this' cannot be referenced in a computed property name."
      },
      super_cannot_be_referenced_in_a_computed_property_name: {
        code: 2466,
        category: ts.DiagnosticCategory.Error,
        key: "'super' cannot be referenced in a computed property name."
      },
      A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type: {
        code: 2467,
        category: ts.DiagnosticCategory.Error,
        key: "A computed property name cannot reference a type parameter from its containing type."
      },
      Cannot_find_global_value_0: {
        code: 2468,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot find global value '{0}'."
      },
      The_0_operator_cannot_be_applied_to_type_symbol: {
        code: 2469,
        category: ts.DiagnosticCategory.Error,
        key: "The '{0}' operator cannot be applied to type 'symbol'."
      },
      Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object: {
        code: 2470,
        category: ts.DiagnosticCategory.Error,
        key: "'Symbol' reference does not refer to the global Symbol constructor object."
      },
      A_computed_property_name_of_the_form_0_must_be_of_type_symbol: {
        code: 2471,
        category: ts.DiagnosticCategory.Error,
        key: "A computed property name of the form '{0}' must be of type 'symbol'."
      },
      Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher: {
        code: 2472,
        category: ts.DiagnosticCategory.Error,
        key: "Spread operator in 'new' expressions is only available when targeting ECMAScript 5 and higher."
      },
      Enum_declarations_must_all_be_const_or_non_const: {
        code: 2473,
        category: ts.DiagnosticCategory.Error,
        key: "Enum declarations must all be const or non-const."
      },
      In_const_enum_declarations_member_initializer_must_be_constant_expression: {
        code: 2474,
        category: ts.DiagnosticCategory.Error,
        key: "In 'const' enum declarations member initializer must be constant expression."
      },
      const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment: {
        code: 2475,
        category: ts.DiagnosticCategory.Error,
        key: "'const' enums can only be used in property or index access expressions or the right hand side of an import declaration or export assignment."
      },
      A_const_enum_member_can_only_be_accessed_using_a_string_literal: {
        code: 2476,
        category: ts.DiagnosticCategory.Error,
        key: "A const enum member can only be accessed using a string literal."
      },
      const_enum_member_initializer_was_evaluated_to_a_non_finite_value: {
        code: 2477,
        category: ts.DiagnosticCategory.Error,
        key: "'const' enum member initializer was evaluated to a non-finite value."
      },
      const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN: {
        code: 2478,
        category: ts.DiagnosticCategory.Error,
        key: "'const' enum member initializer was evaluated to disallowed value 'NaN'."
      },
      Property_0_does_not_exist_on_const_enum_1: {
        code: 2479,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' does not exist on 'const' enum '{1}'."
      },
      let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations: {
        code: 2480,
        category: ts.DiagnosticCategory.Error,
        key: "'let' is not allowed to be used as a name in 'let' or 'const' declarations."
      },
      Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1: {
        code: 2481,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot initialize outer scoped variable '{0}' in the same scope as block scoped declaration '{1}'."
      },
      The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation: {
        code: 2483,
        category: ts.DiagnosticCategory.Error,
        key: "The left-hand side of a 'for...of' statement cannot use a type annotation."
      },
      Export_declaration_conflicts_with_exported_declaration_of_0: {
        code: 2484,
        category: ts.DiagnosticCategory.Error,
        key: "Export declaration conflicts with exported declaration of '{0}'"
      },
      The_left_hand_side_of_a_for_of_statement_cannot_be_a_previously_defined_constant: {
        code: 2485,
        category: ts.DiagnosticCategory.Error,
        key: "The left-hand side of a 'for...of' statement cannot be a previously defined constant."
      },
      The_left_hand_side_of_a_for_in_statement_cannot_be_a_previously_defined_constant: {
        code: 2486,
        category: ts.DiagnosticCategory.Error,
        key: "The left-hand side of a 'for...in' statement cannot be a previously defined constant."
      },
      Invalid_left_hand_side_in_for_of_statement: {
        code: 2487,
        category: ts.DiagnosticCategory.Error,
        key: "Invalid left-hand side in 'for...of' statement."
      },
      Type_must_have_a_Symbol_iterator_method_that_returns_an_iterator: {
        code: 2488,
        category: ts.DiagnosticCategory.Error,
        key: "Type must have a '[Symbol.iterator]()' method that returns an iterator."
      },
      An_iterator_must_have_a_next_method: {
        code: 2489,
        category: ts.DiagnosticCategory.Error,
        key: "An iterator must have a 'next()' method."
      },
      The_type_returned_by_the_next_method_of_an_iterator_must_have_a_value_property: {
        code: 2490,
        category: ts.DiagnosticCategory.Error,
        key: "The type returned by the 'next()' method of an iterator must have a 'value' property."
      },
      The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern: {
        code: 2491,
        category: ts.DiagnosticCategory.Error,
        key: "The left-hand side of a 'for...in' statement cannot be a destructuring pattern."
      },
      Cannot_redeclare_identifier_0_in_catch_clause: {
        code: 2492,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot redeclare identifier '{0}' in catch clause"
      },
      Tuple_type_0_with_length_1_cannot_be_assigned_to_tuple_with_length_2: {
        code: 2493,
        category: ts.DiagnosticCategory.Error,
        key: "Tuple type '{0}' with length '{1}' cannot be assigned to tuple with length '{2}'."
      },
      Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher: {
        code: 2494,
        category: ts.DiagnosticCategory.Error,
        key: "Using a string in a 'for...of' statement is only supported in ECMAScript 5 and higher."
      },
      Type_0_is_not_an_array_type_or_a_string_type: {
        code: 2495,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' is not an array type or a string type."
      },
      The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression: {
        code: 2496,
        category: ts.DiagnosticCategory.Error,
        key: "The 'arguments' object cannot be referenced in an arrow function in ES3 and ES5. Consider using a standard function expression."
      },
      Module_0_resolves_to_a_non_module_entity_and_cannot_be_imported_using_this_construct: {
        code: 2497,
        category: ts.DiagnosticCategory.Error,
        key: "Module '{0}' resolves to a non-module entity and cannot be imported using this construct."
      },
      Module_0_uses_export_and_cannot_be_used_with_export_Asterisk: {
        code: 2498,
        category: ts.DiagnosticCategory.Error,
        key: "Module '{0}' uses 'export =' and cannot be used with 'export *'."
      },
      An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments: {
        code: 2499,
        category: ts.DiagnosticCategory.Error,
        key: "An interface can only extend an identifier/qualified-name with optional type arguments."
      },
      A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments: {
        code: 2500,
        category: ts.DiagnosticCategory.Error,
        key: "A class can only implement an identifier/qualified-name with optional type arguments."
      },
      A_rest_element_cannot_contain_a_binding_pattern: {
        code: 2501,
        category: ts.DiagnosticCategory.Error,
        key: "A rest element cannot contain a binding pattern."
      },
      _0_is_referenced_directly_or_indirectly_in_its_own_type_annotation: {
        code: 2502,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' is referenced directly or indirectly in its own type annotation."
      },
      Cannot_find_namespace_0: {
        code: 2503,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot find namespace '{0}'."
      },
      No_best_common_type_exists_among_yield_expressions: {
        code: 2504,
        category: ts.DiagnosticCategory.Error,
        key: "No best common type exists among yield expressions."
      },
      A_generator_cannot_have_a_void_type_annotation: {
        code: 2505,
        category: ts.DiagnosticCategory.Error,
        key: "A generator cannot have a 'void' type annotation."
      },
      _0_is_referenced_directly_or_indirectly_in_its_own_base_expression: {
        code: 2506,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' is referenced directly or indirectly in its own base expression."
      },
      Type_0_is_not_a_constructor_function_type: {
        code: 2507,
        category: ts.DiagnosticCategory.Error,
        key: "Type '{0}' is not a constructor function type."
      },
      No_base_constructor_has_the_specified_number_of_type_arguments: {
        code: 2508,
        category: ts.DiagnosticCategory.Error,
        key: "No base constructor has the specified number of type arguments."
      },
      Base_constructor_return_type_0_is_not_a_class_or_interface_type: {
        code: 2509,
        category: ts.DiagnosticCategory.Error,
        key: "Base constructor return type '{0}' is not a class or interface type."
      },
      Base_constructors_must_all_have_the_same_return_type: {
        code: 2510,
        category: ts.DiagnosticCategory.Error,
        key: "Base constructors must all have the same return type."
      },
      Cannot_create_an_instance_of_the_abstract_class_0: {
        code: 2511,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot create an instance of the abstract class '{0}'."
      },
      Overload_signatures_must_all_be_abstract_or_not_abstract: {
        code: 2512,
        category: ts.DiagnosticCategory.Error,
        key: "Overload signatures must all be abstract or not abstract."
      },
      Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression: {
        code: 2513,
        category: ts.DiagnosticCategory.Error,
        key: "Abstract method '{0}' in class '{1}' cannot be accessed via super expression."
      },
      Classes_containing_abstract_methods_must_be_marked_abstract: {
        code: 2514,
        category: ts.DiagnosticCategory.Error,
        key: "Classes containing abstract methods must be marked abstract."
      },
      Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2: {
        code: 2515,
        category: ts.DiagnosticCategory.Error,
        key: "Non-abstract class '{0}' does not implement inherited abstract member '{1}' from class '{2}'."
      },
      All_declarations_of_an_abstract_method_must_be_consecutive: {
        code: 2516,
        category: ts.DiagnosticCategory.Error,
        key: "All declarations of an abstract method must be consecutive."
      },
      Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type: {
        code: 2517,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot assign an abstract constructor type to a non-abstract constructor type."
      },
      Only_an_ambient_class_can_be_merged_with_an_interface: {
        code: 2518,
        category: ts.DiagnosticCategory.Error,
        key: "Only an ambient class can be merged with an interface."
      },
      Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions: {
        code: 2520,
        category: ts.DiagnosticCategory.Error,
        key: "Duplicate identifier '{0}'. Compiler uses declaration '{1}' to support async functions."
      },
      Expression_resolves_to_variable_declaration_0_that_compiler_uses_to_support_async_functions: {
        code: 2521,
        category: ts.DiagnosticCategory.Error,
        key: "Expression resolves to variable declaration '{0}' that compiler uses to support async functions."
      },
      The_arguments_object_cannot_be_referenced_in_an_async_arrow_function_Consider_using_a_standard_async_function_expression: {
        code: 2522,
        category: ts.DiagnosticCategory.Error,
        key: "The 'arguments' object cannot be referenced in an async arrow function. Consider using a standard async function expression."
      },
      yield_expressions_cannot_be_used_in_a_parameter_initializer: {
        code: 2523,
        category: ts.DiagnosticCategory.Error,
        key: "'yield' expressions cannot be used in a parameter initializer."
      },
      await_expressions_cannot_be_used_in_a_parameter_initializer: {
        code: 2524,
        category: ts.DiagnosticCategory.Error,
        key: "'await' expressions cannot be used in a parameter initializer."
      },
      JSX_element_attributes_type_0_must_be_an_object_type: {
        code: 2600,
        category: ts.DiagnosticCategory.Error,
        key: "JSX element attributes type '{0}' must be an object type."
      },
      The_return_type_of_a_JSX_element_constructor_must_return_an_object_type: {
        code: 2601,
        category: ts.DiagnosticCategory.Error,
        key: "The return type of a JSX element constructor must return an object type."
      },
      JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist: {
        code: 2602,
        category: ts.DiagnosticCategory.Error,
        key: "JSX element implicitly has type 'any' because the global type 'JSX.Element' does not exist."
      },
      Property_0_in_type_1_is_not_assignable_to_type_2: {
        code: 2603,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' in type '{1}' is not assignable to type '{2}'"
      },
      JSX_element_type_0_does_not_have_any_construct_or_call_signatures: {
        code: 2604,
        category: ts.DiagnosticCategory.Error,
        key: "JSX element type '{0}' does not have any construct or call signatures."
      },
      JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements: {
        code: 2605,
        category: ts.DiagnosticCategory.Error,
        key: "JSX element type '{0}' is not a constructor function for JSX elements."
      },
      Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property: {
        code: 2606,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' of JSX spread attribute is not assignable to target property."
      },
      JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property: {
        code: 2607,
        category: ts.DiagnosticCategory.Error,
        key: "JSX element class does not support attributes because it does not have a '{0}' property"
      },
      The_global_type_JSX_0_may_not_have_more_than_one_property: {
        code: 2608,
        category: ts.DiagnosticCategory.Error,
        key: "The global type 'JSX.{0}' may not have more than one property"
      },
      Cannot_emit_namespaced_JSX_elements_in_React: {
        code: 2650,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot emit namespaced JSX elements in React"
      },
      A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums: {
        code: 2651,
        category: ts.DiagnosticCategory.Error,
        key: "A member initializer in a enum declaration cannot reference members declared after it, including members defined in other enums."
      },
      Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead: {
        code: 2652,
        category: ts.DiagnosticCategory.Error,
        key: "Merged declaration '{0}' cannot include a default export declaration. Consider adding a separate 'export default {0}' declaration instead."
      },
      Exported_external_package_typings_file_cannot_contain_tripleslash_references_Please_contact_the_package_author_to_update_the_package_definition: {
        code: 2654,
        category: ts.DiagnosticCategory.Error,
        key: "Exported external package typings file cannot contain tripleslash references. Please contact the package author to update the package definition."
      },
      Exported_external_package_typings_can_only_be_in_d_ts_files_Please_contact_the_package_author_to_update_the_package_definition: {
        code: 2655,
        category: ts.DiagnosticCategory.Error,
        key: "Exported external package typings can only be in '.d.ts' files. Please contact the package author to update the package definition."
      },
      Import_declaration_0_is_using_private_name_1: {
        code: 4000,
        category: ts.DiagnosticCategory.Error,
        key: "Import declaration '{0}' is using private name '{1}'."
      },
      Type_parameter_0_of_exported_class_has_or_is_using_private_name_1: {
        code: 4002,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter '{0}' of exported class has or is using private name '{1}'."
      },
      Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1: {
        code: 4004,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter '{0}' of exported interface has or is using private name '{1}'."
      },
      Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: {
        code: 4006,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."
      },
      Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: {
        code: 4008,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter '{0}' of call signature from exported interface has or is using private name '{1}'."
      },
      Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: {
        code: 4010,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter '{0}' of public static method from exported class has or is using private name '{1}'."
      },
      Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: {
        code: 4012,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter '{0}' of public method from exported class has or is using private name '{1}'."
      },
      Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: {
        code: 4014,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter '{0}' of method from exported interface has or is using private name '{1}'."
      },
      Type_parameter_0_of_exported_function_has_or_is_using_private_name_1: {
        code: 4016,
        category: ts.DiagnosticCategory.Error,
        key: "Type parameter '{0}' of exported function has or is using private name '{1}'."
      },
      Implements_clause_of_exported_class_0_has_or_is_using_private_name_1: {
        code: 4019,
        category: ts.DiagnosticCategory.Error,
        key: "Implements clause of exported class '{0}' has or is using private name '{1}'."
      },
      Extends_clause_of_exported_class_0_has_or_is_using_private_name_1: {
        code: 4020,
        category: ts.DiagnosticCategory.Error,
        key: "Extends clause of exported class '{0}' has or is using private name '{1}'."
      },
      Extends_clause_of_exported_interface_0_has_or_is_using_private_name_1: {
        code: 4022,
        category: ts.DiagnosticCategory.Error,
        key: "Extends clause of exported interface '{0}' has or is using private name '{1}'."
      },
      Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: {
        code: 4023,
        category: ts.DiagnosticCategory.Error,
        key: "Exported variable '{0}' has or is using name '{1}' from external module {2} but cannot be named."
      },
      Exported_variable_0_has_or_is_using_name_1_from_private_module_2: {
        code: 4024,
        category: ts.DiagnosticCategory.Error,
        key: "Exported variable '{0}' has or is using name '{1}' from private module '{2}'."
      },
      Exported_variable_0_has_or_is_using_private_name_1: {
        code: 4025,
        category: ts.DiagnosticCategory.Error,
        key: "Exported variable '{0}' has or is using private name '{1}'."
      },
      Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: {
        code: 4026,
        category: ts.DiagnosticCategory.Error,
        key: "Public static property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."
      },
      Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: {
        code: 4027,
        category: ts.DiagnosticCategory.Error,
        key: "Public static property '{0}' of exported class has or is using name '{1}' from private module '{2}'."
      },
      Public_static_property_0_of_exported_class_has_or_is_using_private_name_1: {
        code: 4028,
        category: ts.DiagnosticCategory.Error,
        key: "Public static property '{0}' of exported class has or is using private name '{1}'."
      },
      Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: {
        code: 4029,
        category: ts.DiagnosticCategory.Error,
        key: "Public property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."
      },
      Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: {
        code: 4030,
        category: ts.DiagnosticCategory.Error,
        key: "Public property '{0}' of exported class has or is using name '{1}' from private module '{2}'."
      },
      Public_property_0_of_exported_class_has_or_is_using_private_name_1: {
        code: 4031,
        category: ts.DiagnosticCategory.Error,
        key: "Public property '{0}' of exported class has or is using private name '{1}'."
      },
      Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: {
        code: 4032,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' of exported interface has or is using name '{1}' from private module '{2}'."
      },
      Property_0_of_exported_interface_has_or_is_using_private_name_1: {
        code: 4033,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' of exported interface has or is using private name '{1}'."
      },
      Parameter_0_of_public_static_property_setter_from_exported_class_has_or_is_using_name_1_from_private_module_2: {
        code: 4034,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public static property setter from exported class has or is using name '{1}' from private module '{2}'."
      },
      Parameter_0_of_public_static_property_setter_from_exported_class_has_or_is_using_private_name_1: {
        code: 4035,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public static property setter from exported class has or is using private name '{1}'."
      },
      Parameter_0_of_public_property_setter_from_exported_class_has_or_is_using_name_1_from_private_module_2: {
        code: 4036,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public property setter from exported class has or is using name '{1}' from private module '{2}'."
      },
      Parameter_0_of_public_property_setter_from_exported_class_has_or_is_using_private_name_1: {
        code: 4037,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public property setter from exported class has or is using private name '{1}'."
      },
      Return_type_of_public_static_property_getter_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: {
        code: 4038,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public static property getter from exported class has or is using name '{0}' from external module {1} but cannot be named."
      },
      Return_type_of_public_static_property_getter_from_exported_class_has_or_is_using_name_0_from_private_module_1: {
        code: 4039,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public static property getter from exported class has or is using name '{0}' from private module '{1}'."
      },
      Return_type_of_public_static_property_getter_from_exported_class_has_or_is_using_private_name_0: {
        code: 4040,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public static property getter from exported class has or is using private name '{0}'."
      },
      Return_type_of_public_property_getter_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: {
        code: 4041,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public property getter from exported class has or is using name '{0}' from external module {1} but cannot be named."
      },
      Return_type_of_public_property_getter_from_exported_class_has_or_is_using_name_0_from_private_module_1: {
        code: 4042,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public property getter from exported class has or is using name '{0}' from private module '{1}'."
      },
      Return_type_of_public_property_getter_from_exported_class_has_or_is_using_private_name_0: {
        code: 4043,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public property getter from exported class has or is using private name '{0}'."
      },
      Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: {
        code: 4044,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of constructor signature from exported interface has or is using name '{0}' from private module '{1}'."
      },
      Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0: {
        code: 4045,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of constructor signature from exported interface has or is using private name '{0}'."
      },
      Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: {
        code: 4046,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of call signature from exported interface has or is using name '{0}' from private module '{1}'."
      },
      Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0: {
        code: 4047,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of call signature from exported interface has or is using private name '{0}'."
      },
      Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: {
        code: 4048,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of index signature from exported interface has or is using name '{0}' from private module '{1}'."
      },
      Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0: {
        code: 4049,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of index signature from exported interface has or is using private name '{0}'."
      },
      Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: {
        code: 4050,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public static method from exported class has or is using name '{0}' from external module {1} but cannot be named."
      },
      Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: {
        code: 4051,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public static method from exported class has or is using name '{0}' from private module '{1}'."
      },
      Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0: {
        code: 4052,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public static method from exported class has or is using private name '{0}'."
      },
      Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: {
        code: 4053,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public method from exported class has or is using name '{0}' from external module {1} but cannot be named."
      },
      Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: {
        code: 4054,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public method from exported class has or is using name '{0}' from private module '{1}'."
      },
      Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0: {
        code: 4055,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of public method from exported class has or is using private name '{0}'."
      },
      Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1: {
        code: 4056,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of method from exported interface has or is using name '{0}' from private module '{1}'."
      },
      Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0: {
        code: 4057,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of method from exported interface has or is using private name '{0}'."
      },
      Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: {
        code: 4058,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of exported function has or is using name '{0}' from external module {1} but cannot be named."
      },
      Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1: {
        code: 4059,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of exported function has or is using name '{0}' from private module '{1}'."
      },
      Return_type_of_exported_function_has_or_is_using_private_name_0: {
        code: 4060,
        category: ts.DiagnosticCategory.Error,
        key: "Return type of exported function has or is using private name '{0}'."
      },
      Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: {
        code: 4061,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of constructor from exported class has or is using name '{1}' from external module {2} but cannot be named."
      },
      Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2: {
        code: 4062,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of constructor from exported class has or is using name '{1}' from private module '{2}'."
      },
      Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1: {
        code: 4063,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of constructor from exported class has or is using private name '{1}'."
      },
      Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: {
        code: 4064,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of constructor signature from exported interface has or is using name '{1}' from private module '{2}'."
      },
      Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: {
        code: 4065,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."
      },
      Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: {
        code: 4066,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of call signature from exported interface has or is using name '{1}' from private module '{2}'."
      },
      Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: {
        code: 4067,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of call signature from exported interface has or is using private name '{1}'."
      },
      Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: {
        code: 4068,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public static method from exported class has or is using name '{1}' from external module {2} but cannot be named."
      },
      Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: {
        code: 4069,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public static method from exported class has or is using name '{1}' from private module '{2}'."
      },
      Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: {
        code: 4070,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public static method from exported class has or is using private name '{1}'."
      },
      Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: {
        code: 4071,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public method from exported class has or is using name '{1}' from external module {2} but cannot be named."
      },
      Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: {
        code: 4072,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public method from exported class has or is using name '{1}' from private module '{2}'."
      },
      Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: {
        code: 4073,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of public method from exported class has or is using private name '{1}'."
      },
      Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2: {
        code: 4074,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of method from exported interface has or is using name '{1}' from private module '{2}'."
      },
      Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: {
        code: 4075,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of method from exported interface has or is using private name '{1}'."
      },
      Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: {
        code: 4076,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of exported function has or is using name '{1}' from external module {2} but cannot be named."
      },
      Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2: {
        code: 4077,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of exported function has or is using name '{1}' from private module '{2}'."
      },
      Parameter_0_of_exported_function_has_or_is_using_private_name_1: {
        code: 4078,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' of exported function has or is using private name '{1}'."
      },
      Exported_type_alias_0_has_or_is_using_private_name_1: {
        code: 4081,
        category: ts.DiagnosticCategory.Error,
        key: "Exported type alias '{0}' has or is using private name '{1}'."
      },
      Default_export_of_the_module_has_or_is_using_private_name_0: {
        code: 4082,
        category: ts.DiagnosticCategory.Error,
        key: "Default export of the module has or is using private name '{0}'."
      },
      Loop_contains_block_scoped_variable_0_referenced_by_a_function_in_the_loop_This_is_only_supported_in_ECMAScript_6_or_higher: {
        code: 4091,
        category: ts.DiagnosticCategory.Error,
        key: "Loop contains block-scoped variable '{0}' referenced by a function in the loop. This is only supported in ECMAScript 6 or higher."
      },
      The_current_host_does_not_support_the_0_option: {
        code: 5001,
        category: ts.DiagnosticCategory.Error,
        key: "The current host does not support the '{0}' option."
      },
      Cannot_find_the_common_subdirectory_path_for_the_input_files: {
        code: 5009,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot find the common subdirectory path for the input files."
      },
      Cannot_read_file_0_Colon_1: {
        code: 5012,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot read file '{0}': {1}"
      },
      Unsupported_file_encoding: {
        code: 5013,
        category: ts.DiagnosticCategory.Error,
        key: "Unsupported file encoding."
      },
      Failed_to_parse_file_0_Colon_1: {
        code: 5014,
        category: ts.DiagnosticCategory.Error,
        key: "Failed to parse file '{0}': {1}."
      },
      Unknown_compiler_option_0: {
        code: 5023,
        category: ts.DiagnosticCategory.Error,
        key: "Unknown compiler option '{0}'."
      },
      Compiler_option_0_requires_a_value_of_type_1: {
        code: 5024,
        category: ts.DiagnosticCategory.Error,
        key: "Compiler option '{0}' requires a value of type {1}."
      },
      Could_not_write_file_0_Colon_1: {
        code: 5033,
        category: ts.DiagnosticCategory.Error,
        key: "Could not write file '{0}': {1}"
      },
      Option_project_cannot_be_mixed_with_source_files_on_a_command_line: {
        code: 5042,
        category: ts.DiagnosticCategory.Error,
        key: "Option 'project' cannot be mixed with source files on a command line."
      },
      Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES6_or_higher: {
        code: 5047,
        category: ts.DiagnosticCategory.Error,
        key: "Option 'isolatedModules' can only be used when either option'--module' is provided or option 'target' is 'ES6' or higher."
      },
      Option_inlineSources_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided: {
        code: 5051,
        category: ts.DiagnosticCategory.Error,
        key: "Option 'inlineSources' can only be used when either option '--inlineSourceMap' or option '--sourceMap' is provided."
      },
      Option_0_cannot_be_specified_without_specifying_option_1: {
        code: 5052,
        category: ts.DiagnosticCategory.Error,
        key: "Option '{0}' cannot be specified without specifying option '{1}'."
      },
      Option_0_cannot_be_specified_with_option_1: {
        code: 5053,
        category: ts.DiagnosticCategory.Error,
        key: "Option '{0}' cannot be specified with option '{1}'."
      },
      A_tsconfig_json_file_is_already_defined_at_Colon_0: {
        code: 5053,
        category: ts.DiagnosticCategory.Error,
        key: "A 'tsconfig.json' file is already defined at: '{0}'."
      },
      Concatenate_and_emit_output_to_single_file: {
        code: 6001,
        category: ts.DiagnosticCategory.Message,
        key: "Concatenate and emit output to single file."
      },
      Generates_corresponding_d_ts_file: {
        code: 6002,
        category: ts.DiagnosticCategory.Message,
        key: "Generates corresponding '.d.ts' file."
      },
      Specifies_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations: {
        code: 6003,
        category: ts.DiagnosticCategory.Message,
        key: "Specifies the location where debugger should locate map files instead of generated locations."
      },
      Specifies_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations: {
        code: 6004,
        category: ts.DiagnosticCategory.Message,
        key: "Specifies the location where debugger should locate TypeScript files instead of source locations."
      },
      Watch_input_files: {
        code: 6005,
        category: ts.DiagnosticCategory.Message,
        key: "Watch input files."
      },
      Redirect_output_structure_to_the_directory: {
        code: 6006,
        category: ts.DiagnosticCategory.Message,
        key: "Redirect output structure to the directory."
      },
      Do_not_erase_const_enum_declarations_in_generated_code: {
        code: 6007,
        category: ts.DiagnosticCategory.Message,
        key: "Do not erase const enum declarations in generated code."
      },
      Do_not_emit_outputs_if_any_errors_were_reported: {
        code: 6008,
        category: ts.DiagnosticCategory.Message,
        key: "Do not emit outputs if any errors were reported."
      },
      Do_not_emit_comments_to_output: {
        code: 6009,
        category: ts.DiagnosticCategory.Message,
        key: "Do not emit comments to output."
      },
      Do_not_emit_outputs: {
        code: 6010,
        category: ts.DiagnosticCategory.Message,
        key: "Do not emit outputs."
      },
      Specify_ECMAScript_target_version_Colon_ES3_default_ES5_or_ES6_experimental: {
        code: 6015,
        category: ts.DiagnosticCategory.Message,
        key: "Specify ECMAScript target version: 'ES3' (default), 'ES5', or 'ES6' (experimental)"
      },
      Specify_module_code_generation_Colon_commonjs_amd_system_or_umd: {
        code: 6016,
        category: ts.DiagnosticCategory.Message,
        key: "Specify module code generation: 'commonjs', 'amd', 'system' or 'umd'"
      },
      Print_this_message: {
        code: 6017,
        category: ts.DiagnosticCategory.Message,
        key: "Print this message."
      },
      Print_the_compiler_s_version: {
        code: 6019,
        category: ts.DiagnosticCategory.Message,
        key: "Print the compiler's version."
      },
      Compile_the_project_in_the_given_directory: {
        code: 6020,
        category: ts.DiagnosticCategory.Message,
        key: "Compile the project in the given directory."
      },
      Syntax_Colon_0: {
        code: 6023,
        category: ts.DiagnosticCategory.Message,
        key: "Syntax: {0}"
      },
      options: {
        code: 6024,
        category: ts.DiagnosticCategory.Message,
        key: "options"
      },
      file: {
        code: 6025,
        category: ts.DiagnosticCategory.Message,
        key: "file"
      },
      Examples_Colon_0: {
        code: 6026,
        category: ts.DiagnosticCategory.Message,
        key: "Examples: {0}"
      },
      Options_Colon: {
        code: 6027,
        category: ts.DiagnosticCategory.Message,
        key: "Options:"
      },
      Version_0: {
        code: 6029,
        category: ts.DiagnosticCategory.Message,
        key: "Version {0}"
      },
      Insert_command_line_options_and_files_from_a_file: {
        code: 6030,
        category: ts.DiagnosticCategory.Message,
        key: "Insert command line options and files from a file."
      },
      File_change_detected_Starting_incremental_compilation: {
        code: 6032,
        category: ts.DiagnosticCategory.Message,
        key: "File change detected. Starting incremental compilation..."
      },
      KIND: {
        code: 6034,
        category: ts.DiagnosticCategory.Message,
        key: "KIND"
      },
      FILE: {
        code: 6035,
        category: ts.DiagnosticCategory.Message,
        key: "FILE"
      },
      VERSION: {
        code: 6036,
        category: ts.DiagnosticCategory.Message,
        key: "VERSION"
      },
      LOCATION: {
        code: 6037,
        category: ts.DiagnosticCategory.Message,
        key: "LOCATION"
      },
      DIRECTORY: {
        code: 6038,
        category: ts.DiagnosticCategory.Message,
        key: "DIRECTORY"
      },
      Compilation_complete_Watching_for_file_changes: {
        code: 6042,
        category: ts.DiagnosticCategory.Message,
        key: "Compilation complete. Watching for file changes."
      },
      Generates_corresponding_map_file: {
        code: 6043,
        category: ts.DiagnosticCategory.Message,
        key: "Generates corresponding '.map' file."
      },
      Compiler_option_0_expects_an_argument: {
        code: 6044,
        category: ts.DiagnosticCategory.Error,
        key: "Compiler option '{0}' expects an argument."
      },
      Unterminated_quoted_string_in_response_file_0: {
        code: 6045,
        category: ts.DiagnosticCategory.Error,
        key: "Unterminated quoted string in response file '{0}'."
      },
      Argument_for_module_option_must_be_commonjs_amd_system_or_umd: {
        code: 6046,
        category: ts.DiagnosticCategory.Error,
        key: "Argument for '--module' option must be 'commonjs', 'amd', 'system' or 'umd'."
      },
      Argument_for_target_option_must_be_ES3_ES5_or_ES6: {
        code: 6047,
        category: ts.DiagnosticCategory.Error,
        key: "Argument for '--target' option must be 'ES3', 'ES5', or 'ES6'."
      },
      Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1: {
        code: 6048,
        category: ts.DiagnosticCategory.Error,
        key: "Locale must be of the form <language> or <language>-<territory>. For example '{0}' or '{1}'."
      },
      Unsupported_locale_0: {
        code: 6049,
        category: ts.DiagnosticCategory.Error,
        key: "Unsupported locale '{0}'."
      },
      Unable_to_open_file_0: {
        code: 6050,
        category: ts.DiagnosticCategory.Error,
        key: "Unable to open file '{0}'."
      },
      Corrupted_locale_file_0: {
        code: 6051,
        category: ts.DiagnosticCategory.Error,
        key: "Corrupted locale file {0}."
      },
      Raise_error_on_expressions_and_declarations_with_an_implied_any_type: {
        code: 6052,
        category: ts.DiagnosticCategory.Message,
        key: "Raise error on expressions and declarations with an implied 'any' type."
      },
      File_0_not_found: {
        code: 6053,
        category: ts.DiagnosticCategory.Error,
        key: "File '{0}' not found."
      },
      File_0_has_unsupported_extension_The_only_supported_extensions_are_1: {
        code: 6054,
        category: ts.DiagnosticCategory.Error,
        key: "File '{0}' has unsupported extension. The only supported extensions are {1}."
      },
      Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures: {
        code: 6055,
        category: ts.DiagnosticCategory.Message,
        key: "Suppress noImplicitAny errors for indexing objects lacking index signatures."
      },
      Do_not_emit_declarations_for_code_that_has_an_internal_annotation: {
        code: 6056,
        category: ts.DiagnosticCategory.Message,
        key: "Do not emit declarations for code that has an '@internal' annotation."
      },
      Specifies_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir: {
        code: 6058,
        category: ts.DiagnosticCategory.Message,
        key: "Specifies the root directory of input files. Use to control the output directory structure with --outDir."
      },
      File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files: {
        code: 6059,
        category: ts.DiagnosticCategory.Error,
        key: "File '{0}' is not under 'rootDir' '{1}'. 'rootDir' is expected to contain all source files."
      },
      Specifies_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix: {
        code: 6060,
        category: ts.DiagnosticCategory.Message,
        key: "Specifies the end of line sequence to be used when emitting files: 'CRLF' (dos) or 'LF' (unix)."
      },
      NEWLINE: {
        code: 6061,
        category: ts.DiagnosticCategory.Message,
        key: "NEWLINE"
      },
      Argument_for_newLine_option_must_be_CRLF_or_LF: {
        code: 6062,
        category: ts.DiagnosticCategory.Error,
        key: "Argument for '--newLine' option must be 'CRLF' or 'LF'."
      },
      Argument_for_moduleResolution_option_must_be_node_or_classic: {
        code: 6063,
        category: ts.DiagnosticCategory.Error,
        key: "Argument for '--moduleResolution' option must be 'node' or 'classic'."
      },
      Specify_JSX_code_generation_Colon_preserve_or_react: {
        code: 6080,
        category: ts.DiagnosticCategory.Message,
        key: "Specify JSX code generation: 'preserve' or 'react'"
      },
      Argument_for_jsx_must_be_preserve_or_react: {
        code: 6081,
        category: ts.DiagnosticCategory.Message,
        key: "Argument for '--jsx' must be 'preserve' or 'react'."
      },
      Enables_experimental_support_for_ES7_decorators: {
        code: 6065,
        category: ts.DiagnosticCategory.Message,
        key: "Enables experimental support for ES7 decorators."
      },
      Enables_experimental_support_for_emitting_type_metadata_for_decorators: {
        code: 6066,
        category: ts.DiagnosticCategory.Message,
        key: "Enables experimental support for emitting type metadata for decorators."
      },
      Option_experimentalAsyncFunctions_cannot_be_specified_when_targeting_ES5_or_lower: {
        code: 6067,
        category: ts.DiagnosticCategory.Message,
        key: "Option 'experimentalAsyncFunctions' cannot be specified when targeting ES5 or lower."
      },
      Enables_experimental_support_for_ES7_async_functions: {
        code: 6068,
        category: ts.DiagnosticCategory.Message,
        key: "Enables experimental support for ES7 async functions."
      },
      Specifies_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6: {
        code: 6069,
        category: ts.DiagnosticCategory.Message,
        key: "Specifies module resolution strategy: 'node' (Node.js) or 'classic' (TypeScript pre-1.6)."
      },
      Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file: {
        code: 6070,
        category: ts.DiagnosticCategory.Message,
        key: "Initializes a TypeScript project and creates a tsconfig.json file."
      },
      Successfully_created_a_tsconfig_json_file: {
        code: 6071,
        category: ts.DiagnosticCategory.Message,
        key: "Successfully created a tsconfig.json file."
      },
      Suppress_excess_property_checks_for_object_literals: {
        code: 6072,
        category: ts.DiagnosticCategory.Message,
        key: "Suppress excess property checks for object literals."
      },
      Variable_0_implicitly_has_an_1_type: {
        code: 7005,
        category: ts.DiagnosticCategory.Error,
        key: "Variable '{0}' implicitly has an '{1}' type."
      },
      Parameter_0_implicitly_has_an_1_type: {
        code: 7006,
        category: ts.DiagnosticCategory.Error,
        key: "Parameter '{0}' implicitly has an '{1}' type."
      },
      Member_0_implicitly_has_an_1_type: {
        code: 7008,
        category: ts.DiagnosticCategory.Error,
        key: "Member '{0}' implicitly has an '{1}' type."
      },
      new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type: {
        code: 7009,
        category: ts.DiagnosticCategory.Error,
        key: "'new' expression, whose target lacks a construct signature, implicitly has an 'any' type."
      },
      _0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type: {
        code: 7010,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}', which lacks return-type annotation, implicitly has an '{1}' return type."
      },
      Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type: {
        code: 7011,
        category: ts.DiagnosticCategory.Error,
        key: "Function expression, which lacks return-type annotation, implicitly has an '{0}' return type."
      },
      Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: {
        code: 7013,
        category: ts.DiagnosticCategory.Error,
        key: "Construct signature, which lacks return-type annotation, implicitly has an 'any' return type."
      },
      Property_0_implicitly_has_type_any_because_its_set_accessor_lacks_a_type_annotation: {
        code: 7016,
        category: ts.DiagnosticCategory.Error,
        key: "Property '{0}' implicitly has type 'any', because its 'set' accessor lacks a type annotation."
      },
      Index_signature_of_object_type_implicitly_has_an_any_type: {
        code: 7017,
        category: ts.DiagnosticCategory.Error,
        key: "Index signature of object type implicitly has an 'any' type."
      },
      Object_literal_s_property_0_implicitly_has_an_1_type: {
        code: 7018,
        category: ts.DiagnosticCategory.Error,
        key: "Object literal's property '{0}' implicitly has an '{1}' type."
      },
      Rest_parameter_0_implicitly_has_an_any_type: {
        code: 7019,
        category: ts.DiagnosticCategory.Error,
        key: "Rest parameter '{0}' implicitly has an 'any[]' type."
      },
      Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: {
        code: 7020,
        category: ts.DiagnosticCategory.Error,
        key: "Call signature, which lacks return-type annotation, implicitly has an 'any' return type."
      },
      _0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or_indirectly_in_its_own_initializer: {
        code: 7022,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' implicitly has type 'any' because it does not have a type annotation and is referenced directly or indirectly in its own initializer."
      },
      _0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions: {
        code: 7023,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."
      },
      Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions: {
        code: 7024,
        category: ts.DiagnosticCategory.Error,
        key: "Function implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."
      },
      Generator_implicitly_has_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_return_type: {
        code: 7025,
        category: ts.DiagnosticCategory.Error,
        key: "Generator implicitly has type '{0}' because it does not yield any values. Consider supplying a return type."
      },
      JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists: {
        code: 7026,
        category: ts.DiagnosticCategory.Error,
        key: "JSX element implicitly has type 'any' because no interface 'JSX.{0}' exists"
      },
      You_cannot_rename_this_element: {
        code: 8000,
        category: ts.DiagnosticCategory.Error,
        key: "You cannot rename this element."
      },
      You_cannot_rename_elements_that_are_defined_in_the_standard_TypeScript_library: {
        code: 8001,
        category: ts.DiagnosticCategory.Error,
        key: "You cannot rename elements that are defined in the standard TypeScript library."
      },
      import_can_only_be_used_in_a_ts_file: {
        code: 8002,
        category: ts.DiagnosticCategory.Error,
        key: "'import ... =' can only be used in a .ts file."
      },
      export_can_only_be_used_in_a_ts_file: {
        code: 8003,
        category: ts.DiagnosticCategory.Error,
        key: "'export=' can only be used in a .ts file."
      },
      type_parameter_declarations_can_only_be_used_in_a_ts_file: {
        code: 8004,
        category: ts.DiagnosticCategory.Error,
        key: "'type parameter declarations' can only be used in a .ts file."
      },
      implements_clauses_can_only_be_used_in_a_ts_file: {
        code: 8005,
        category: ts.DiagnosticCategory.Error,
        key: "'implements clauses' can only be used in a .ts file."
      },
      interface_declarations_can_only_be_used_in_a_ts_file: {
        code: 8006,
        category: ts.DiagnosticCategory.Error,
        key: "'interface declarations' can only be used in a .ts file."
      },
      module_declarations_can_only_be_used_in_a_ts_file: {
        code: 8007,
        category: ts.DiagnosticCategory.Error,
        key: "'module declarations' can only be used in a .ts file."
      },
      type_aliases_can_only_be_used_in_a_ts_file: {
        code: 8008,
        category: ts.DiagnosticCategory.Error,
        key: "'type aliases' can only be used in a .ts file."
      },
      _0_can_only_be_used_in_a_ts_file: {
        code: 8009,
        category: ts.DiagnosticCategory.Error,
        key: "'{0}' can only be used in a .ts file."
      },
      types_can_only_be_used_in_a_ts_file: {
        code: 8010,
        category: ts.DiagnosticCategory.Error,
        key: "'types' can only be used in a .ts file."
      },
      type_arguments_can_only_be_used_in_a_ts_file: {
        code: 8011,
        category: ts.DiagnosticCategory.Error,
        key: "'type arguments' can only be used in a .ts file."
      },
      parameter_modifiers_can_only_be_used_in_a_ts_file: {
        code: 8012,
        category: ts.DiagnosticCategory.Error,
        key: "'parameter modifiers' can only be used in a .ts file."
      },
      property_declarations_can_only_be_used_in_a_ts_file: {
        code: 8014,
        category: ts.DiagnosticCategory.Error,
        key: "'property declarations' can only be used in a .ts file."
      },
      enum_declarations_can_only_be_used_in_a_ts_file: {
        code: 8015,
        category: ts.DiagnosticCategory.Error,
        key: "'enum declarations' can only be used in a .ts file."
      },
      type_assertion_expressions_can_only_be_used_in_a_ts_file: {
        code: 8016,
        category: ts.DiagnosticCategory.Error,
        key: "'type assertion expressions' can only be used in a .ts file."
      },
      decorators_can_only_be_used_in_a_ts_file: {
        code: 8017,
        category: ts.DiagnosticCategory.Error,
        key: "'decorators' can only be used in a .ts file."
      },
      Only_identifiers_Slashqualified_names_with_optional_type_arguments_are_currently_supported_in_a_class_extends_clauses: {
        code: 9002,
        category: ts.DiagnosticCategory.Error,
        key: "Only identifiers/qualified-names with optional type arguments are currently supported in a class 'extends' clauses."
      },
      class_expressions_are_not_currently_supported: {
        code: 9003,
        category: ts.DiagnosticCategory.Error,
        key: "'class' expressions are not currently supported."
      },
      JSX_attributes_must_only_be_assigned_a_non_empty_expression: {
        code: 17000,
        category: ts.DiagnosticCategory.Error,
        key: "JSX attributes must only be assigned a non-empty 'expression'."
      },
      JSX_elements_cannot_have_multiple_attributes_with_the_same_name: {
        code: 17001,
        category: ts.DiagnosticCategory.Error,
        key: "JSX elements cannot have multiple attributes with the same name."
      },
      Expected_corresponding_JSX_closing_tag_for_0: {
        code: 17002,
        category: ts.DiagnosticCategory.Error,
        key: "Expected corresponding JSX closing tag for '{0}'."
      },
      JSX_attribute_expected: {
        code: 17003,
        category: ts.DiagnosticCategory.Error,
        key: "JSX attribute expected."
      },
      Cannot_use_JSX_unless_the_jsx_flag_is_provided: {
        code: 17004,
        category: ts.DiagnosticCategory.Error,
        key: "Cannot use JSX unless the '--jsx' flag is provided."
      },
      A_constructor_cannot_contain_a_super_call_when_its_class_extends_null: {
        code: 17005,
        category: ts.DiagnosticCategory.Error,
        key: "A constructor cannot contain a 'super' call when its class extends 'null'"
      }
    };
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    var textToToken = {
      "abstract": 113,
      "any": 115,
      "as": 114,
      "boolean": 118,
      "break": 68,
      "case": 69,
      "catch": 70,
      "class": 71,
      "continue": 73,
      "const": 72,
      "constructor": 119,
      "debugger": 74,
      "declare": 120,
      "default": 75,
      "delete": 76,
      "do": 77,
      "else": 78,
      "enum": 79,
      "export": 80,
      "extends": 81,
      "false": 82,
      "finally": 83,
      "for": 84,
      "from": 131,
      "function": 85,
      "get": 121,
      "if": 86,
      "implements": 104,
      "import": 87,
      "in": 88,
      "instanceof": 89,
      "interface": 105,
      "is": 122,
      "let": 106,
      "module": 123,
      "namespace": 124,
      "new": 90,
      "null": 91,
      "number": 126,
      "package": 107,
      "private": 108,
      "protected": 109,
      "public": 110,
      "require": 125,
      "return": 92,
      "set": 127,
      "static": 111,
      "string": 128,
      "super": 93,
      "switch": 94,
      "symbol": 129,
      "this": 95,
      "throw": 96,
      "true": 97,
      "try": 98,
      "type": 130,
      "typeof": 99,
      "var": 100,
      "void": 101,
      "while": 102,
      "with": 103,
      "yield": 112,
      "async": 116,
      "await": 117,
      "of": 132,
      "{": 15,
      "}": 16,
      "(": 17,
      ")": 18,
      "[": 19,
      "]": 20,
      ".": 21,
      "...": 22,
      ";": 23,
      ",": 24,
      "<": 25,
      ">": 27,
      "<=": 28,
      ">=": 29,
      "==": 30,
      "!=": 31,
      "===": 32,
      "!==": 33,
      "=>": 34,
      "+": 35,
      "-": 36,
      "*": 37,
      "/": 38,
      "%": 39,
      "++": 40,
      "--": 41,
      "<<": 42,
      "</": 26,
      ">>": 43,
      ">>>": 44,
      "&": 45,
      "|": 46,
      "^": 47,
      "!": 48,
      "~": 49,
      "&&": 50,
      "||": 51,
      "?": 52,
      ":": 53,
      "=": 55,
      "+=": 56,
      "-=": 57,
      "*=": 58,
      "/=": 59,
      "%=": 60,
      "<<=": 61,
      ">>=": 62,
      ">>>=": 63,
      "&=": 64,
      "|=": 65,
      "^=": 66,
      "@": 54
    };
    var unicodeES3IdentifierStart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 543, 546, 563, 592, 685, 688, 696, 699, 705, 720, 721, 736, 740, 750, 750, 890, 890, 902, 902, 904, 906, 908, 908, 910, 929, 931, 974, 976, 983, 986, 1011, 1024, 1153, 1164, 1220, 1223, 1224, 1227, 1228, 1232, 1269, 1272, 1273, 1329, 1366, 1369, 1369, 1377, 1415, 1488, 1514, 1520, 1522, 1569, 1594, 1600, 1610, 1649, 1747, 1749, 1749, 1765, 1766, 1786, 1788, 1808, 1808, 1810, 1836, 1920, 1957, 2309, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2699, 2701, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2784, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2870, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 2997, 2999, 3001, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3294, 3294, 3296, 3297, 3333, 3340, 3342, 3344, 3346, 3368, 3370, 3385, 3424, 3425, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3805, 3840, 3840, 3904, 3911, 3913, 3946, 3976, 3979, 4096, 4129, 4131, 4135, 4137, 4138, 4176, 4181, 4256, 4293, 4304, 4342, 4352, 4441, 4447, 4514, 4520, 4601, 4608, 4614, 4616, 4678, 4680, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4742, 4744, 4744, 4746, 4749, 4752, 4782, 4784, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4814, 4816, 4822, 4824, 4846, 4848, 4878, 4880, 4880, 4882, 4885, 4888, 4894, 4896, 4934, 4936, 4954, 5024, 5108, 5121, 5740, 5743, 5750, 5761, 5786, 5792, 5866, 6016, 6067, 6176, 6263, 6272, 6312, 7680, 7835, 7840, 7929, 7936, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8319, 8319, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8497, 8499, 8505, 8544, 8579, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12346, 12353, 12436, 12445, 12446, 12449, 12538, 12540, 12542, 12549, 12588, 12593, 12686, 12704, 12727, 13312, 19893, 19968, 40869, 40960, 42124, 44032, 55203, 63744, 64045, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65138, 65140, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500];
    var unicodeES3IdentifierPart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 543, 546, 563, 592, 685, 688, 696, 699, 705, 720, 721, 736, 740, 750, 750, 768, 846, 864, 866, 890, 890, 902, 902, 904, 906, 908, 908, 910, 929, 931, 974, 976, 983, 986, 1011, 1024, 1153, 1155, 1158, 1164, 1220, 1223, 1224, 1227, 1228, 1232, 1269, 1272, 1273, 1329, 1366, 1369, 1369, 1377, 1415, 1425, 1441, 1443, 1465, 1467, 1469, 1471, 1471, 1473, 1474, 1476, 1476, 1488, 1514, 1520, 1522, 1569, 1594, 1600, 1621, 1632, 1641, 1648, 1747, 1749, 1756, 1759, 1768, 1770, 1773, 1776, 1788, 1808, 1836, 1840, 1866, 1920, 1968, 2305, 2307, 2309, 2361, 2364, 2381, 2384, 2388, 2392, 2403, 2406, 2415, 2433, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2492, 2494, 2500, 2503, 2504, 2507, 2509, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2562, 2562, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2649, 2652, 2654, 2654, 2662, 2676, 2689, 2691, 2693, 2699, 2701, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2784, 2790, 2799, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2870, 2873, 2876, 2883, 2887, 2888, 2891, 2893, 2902, 2903, 2908, 2909, 2911, 2913, 2918, 2927, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 2997, 2999, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3031, 3031, 3047, 3055, 3073, 3075, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3134, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3168, 3169, 3174, 3183, 3202, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3262, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3297, 3302, 3311, 3330, 3331, 3333, 3340, 3342, 3344, 3346, 3368, 3370, 3385, 3390, 3395, 3398, 3400, 3402, 3405, 3415, 3415, 3424, 3425, 3430, 3439, 3458, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3769, 3771, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3805, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3946, 3953, 3972, 3974, 3979, 3984, 3991, 3993, 4028, 4038, 4038, 4096, 4129, 4131, 4135, 4137, 4138, 4140, 4146, 4150, 4153, 4160, 4169, 4176, 4185, 4256, 4293, 4304, 4342, 4352, 4441, 4447, 4514, 4520, 4601, 4608, 4614, 4616, 4678, 4680, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4742, 4744, 4744, 4746, 4749, 4752, 4782, 4784, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4814, 4816, 4822, 4824, 4846, 4848, 4878, 4880, 4880, 4882, 4885, 4888, 4894, 4896, 4934, 4936, 4954, 4969, 4977, 5024, 5108, 5121, 5740, 5743, 5750, 5761, 5786, 5792, 5866, 6016, 6099, 6112, 6121, 6160, 6169, 6176, 6263, 6272, 6313, 7680, 7835, 7840, 7929, 7936, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8319, 8319, 8400, 8412, 8417, 8417, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8497, 8499, 8505, 8544, 8579, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12346, 12353, 12436, 12441, 12442, 12445, 12446, 12449, 12542, 12549, 12588, 12593, 12686, 12704, 12727, 13312, 19893, 19968, 40869, 40960, 42124, 44032, 55203, 63744, 64045, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65056, 65059, 65075, 65076, 65101, 65103, 65136, 65138, 65140, 65140, 65142, 65276, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65381, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500];
    var unicodeES5IdentifierStart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1319, 1329, 1366, 1369, 1369, 1377, 1415, 1488, 1514, 1520, 1522, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2208, 2208, 2210, 2220, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2423, 2425, 2431, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3133, 3133, 3160, 3161, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3333, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3424, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5108, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5872, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6263, 6272, 6312, 6314, 6314, 6320, 6389, 6400, 6428, 6480, 6509, 6512, 6516, 6528, 6571, 6593, 6599, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7401, 7404, 7406, 7409, 7413, 7414, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12589, 12593, 12686, 12704, 12730, 12784, 12799, 13312, 19893, 19968, 40908, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42647, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42894, 42896, 42899, 42912, 42922, 43000, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43648, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43968, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500];
    var unicodeES5IdentifierPart = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1319, 1329, 1366, 1369, 1369, 1377, 1415, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1520, 1522, 1552, 1562, 1568, 1641, 1646, 1747, 1749, 1756, 1759, 1768, 1770, 1788, 1791, 1791, 1808, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2048, 2093, 2112, 2139, 2208, 2208, 2210, 2220, 2276, 2302, 2304, 2403, 2406, 2415, 2417, 2423, 2425, 2431, 2433, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2902, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3073, 3075, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3123, 3125, 3129, 3133, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3161, 3168, 3171, 3174, 3183, 3202, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3330, 3331, 3333, 3340, 3342, 3344, 3346, 3386, 3389, 3396, 3398, 3400, 3402, 3406, 3415, 3415, 3424, 3427, 3430, 3439, 3450, 3455, 3458, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3769, 3771, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5108, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5872, 5888, 5900, 5902, 5908, 5920, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6108, 6109, 6112, 6121, 6155, 6157, 6160, 6169, 6176, 6263, 6272, 6314, 6320, 6389, 6400, 6428, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6912, 6987, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7376, 7378, 7380, 7414, 7424, 7654, 7676, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8204, 8205, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12589, 12593, 12686, 12704, 12730, 12784, 12799, 13312, 19893, 19968, 40908, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42647, 42655, 42737, 42775, 42783, 42786, 42888, 42891, 42894, 42896, 42899, 42912, 42922, 43000, 43047, 43072, 43123, 43136, 43204, 43216, 43225, 43232, 43255, 43259, 43259, 43264, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43643, 43648, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43968, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65024, 65039, 65056, 65062, 65075, 65076, 65101, 65103, 65136, 65140, 65142, 65276, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500];
    function lookupInUnicodeMap(code, map) {
      if (code < map[0]) {
        return false;
      }
      var lo = 0;
      var hi = map.length;
      var mid;
      while (lo + 1 < hi) {
        mid = lo + (hi - lo) / 2;
        mid -= mid % 2;
        if (map[mid] <= code && code <= map[mid + 1]) {
          return true;
        }
        if (code < map[mid]) {
          hi = mid;
        } else {
          lo = mid + 2;
        }
      }
      return false;
    }
    function isUnicodeIdentifierStart(code, languageVersion) {
      return languageVersion >= 1 ? lookupInUnicodeMap(code, unicodeES5IdentifierStart) : lookupInUnicodeMap(code, unicodeES3IdentifierStart);
    }
    ts.isUnicodeIdentifierStart = isUnicodeIdentifierStart;
    function isUnicodeIdentifierPart(code, languageVersion) {
      return languageVersion >= 1 ? lookupInUnicodeMap(code, unicodeES5IdentifierPart) : lookupInUnicodeMap(code, unicodeES3IdentifierPart);
    }
    function makeReverseMap(source) {
      var result = [];
      for (var name_4 in source) {
        if (source.hasOwnProperty(name_4)) {
          result[source[name_4]] = name_4;
        }
      }
      return result;
    }
    var tokenStrings = makeReverseMap(textToToken);
    function tokenToString(t) {
      return tokenStrings[t];
    }
    ts.tokenToString = tokenToString;
    function stringToToken(s) {
      return textToToken[s];
    }
    ts.stringToToken = stringToToken;
    function computeLineStarts(text) {
      var result = new Array();
      var pos = 0;
      var lineStart = 0;
      while (pos < text.length) {
        var ch = text.charCodeAt(pos++);
        switch (ch) {
          case 13:
            if (text.charCodeAt(pos) === 10) {
              pos++;
            }
          case 10:
            result.push(lineStart);
            lineStart = pos;
            break;
          default:
            if (ch > 127 && isLineBreak(ch)) {
              result.push(lineStart);
              lineStart = pos;
            }
            break;
        }
      }
      result.push(lineStart);
      return result;
    }
    ts.computeLineStarts = computeLineStarts;
    function getPositionOfLineAndCharacter(sourceFile, line, character) {
      return computePositionOfLineAndCharacter(getLineStarts(sourceFile), line, character);
    }
    ts.getPositionOfLineAndCharacter = getPositionOfLineAndCharacter;
    function computePositionOfLineAndCharacter(lineStarts, line, character) {
      ts.Debug.assert(line >= 0 && line < lineStarts.length);
      return lineStarts[line] + character;
    }
    ts.computePositionOfLineAndCharacter = computePositionOfLineAndCharacter;
    function getLineStarts(sourceFile) {
      return sourceFile.lineMap || (sourceFile.lineMap = computeLineStarts(sourceFile.text));
    }
    ts.getLineStarts = getLineStarts;
    function computeLineAndCharacterOfPosition(lineStarts, position) {
      var lineNumber = ts.binarySearch(lineStarts, position);
      if (lineNumber < 0) {
        lineNumber = ~lineNumber - 1;
        ts.Debug.assert(lineNumber !== -1, "position cannot precede the beginning of the file");
      }
      return {
        line: lineNumber,
        character: position - lineStarts[lineNumber]
      };
    }
    ts.computeLineAndCharacterOfPosition = computeLineAndCharacterOfPosition;
    function getLineAndCharacterOfPosition(sourceFile, position) {
      return computeLineAndCharacterOfPosition(getLineStarts(sourceFile), position);
    }
    ts.getLineAndCharacterOfPosition = getLineAndCharacterOfPosition;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    function isWhiteSpace(ch) {
      return ch === 32 || ch === 9 || ch === 11 || ch === 12 || ch === 160 || ch === 133 || ch === 5760 || ch >= 8192 && ch <= 8203 || ch === 8239 || ch === 8287 || ch === 12288 || ch === 65279;
    }
    ts.isWhiteSpace = isWhiteSpace;
    function isLineBreak(ch) {
      return ch === 10 || ch === 13 || ch === 8232 || ch === 8233;
    }
    ts.isLineBreak = isLineBreak;
    function isDigit(ch) {
      return ch >= 48 && ch <= 57;
    }
    function isOctalDigit(ch) {
      return ch >= 48 && ch <= 55;
    }
    ts.isOctalDigit = isOctalDigit;
    function couldStartTrivia(text, pos) {
      var ch = text.charCodeAt(pos);
      switch (ch) {
        case 13:
        case 10:
        case 9:
        case 11:
        case 12:
        case 32:
        case 47:
        case 60:
        case 61:
        case 62:
          return true;
        case 35:
          return pos === 0;
        default:
          return ch > 127;
      }
    }
    ts.couldStartTrivia = couldStartTrivia;
    function skipTrivia(text, pos, stopAfterLineBreak) {
      while (true) {
        var ch = text.charCodeAt(pos);
        switch (ch) {
          case 13:
            if (text.charCodeAt(pos + 1) === 10) {
              pos++;
            }
          case 10:
            pos++;
            if (stopAfterLineBreak) {
              return pos;
            }
            continue;
          case 9:
          case 11:
          case 12:
          case 32:
            pos++;
            continue;
          case 47:
            if (text.charCodeAt(pos + 1) === 47) {
              pos += 2;
              while (pos < text.length) {
                if (isLineBreak(text.charCodeAt(pos))) {
                  break;
                }
                pos++;
              }
              continue;
            }
            if (text.charCodeAt(pos + 1) === 42) {
              pos += 2;
              while (pos < text.length) {
                if (text.charCodeAt(pos) === 42 && text.charCodeAt(pos + 1) === 47) {
                  pos += 2;
                  break;
                }
                pos++;
              }
              continue;
            }
            break;
          case 60:
          case 61:
          case 62:
            if (isConflictMarkerTrivia(text, pos)) {
              pos = scanConflictMarkerTrivia(text, pos);
              continue;
            }
            break;
          case 35:
            if (pos === 0 && isShebangTrivia(text, pos)) {
              pos = scanShebangTrivia(text, pos);
              continue;
            }
            break;
          default:
            if (ch > 127 && (isWhiteSpace(ch) || isLineBreak(ch))) {
              pos++;
              continue;
            }
            break;
        }
        return pos;
      }
    }
    ts.skipTrivia = skipTrivia;
    var mergeConflictMarkerLength = "<<<<<<<".length;
    function isConflictMarkerTrivia(text, pos) {
      ts.Debug.assert(pos >= 0);
      if (pos === 0 || isLineBreak(text.charCodeAt(pos - 1))) {
        var ch = text.charCodeAt(pos);
        if ((pos + mergeConflictMarkerLength) < text.length) {
          for (var i = 0,
              n = mergeConflictMarkerLength; i < n; i++) {
            if (text.charCodeAt(pos + i) !== ch) {
              return false;
            }
          }
          return ch === 61 || text.charCodeAt(pos + mergeConflictMarkerLength) === 32;
        }
      }
      return false;
    }
    function scanConflictMarkerTrivia(text, pos, error) {
      if (error) {
        error(ts.Diagnostics.Merge_conflict_marker_encountered, mergeConflictMarkerLength);
      }
      var ch = text.charCodeAt(pos);
      var len = text.length;
      if (ch === 60 || ch === 62) {
        while (pos < len && !isLineBreak(text.charCodeAt(pos))) {
          pos++;
        }
      } else {
        ts.Debug.assert(ch === 61);
        while (pos < len) {
          var ch_1 = text.charCodeAt(pos);
          if (ch_1 === 62 && isConflictMarkerTrivia(text, pos)) {
            break;
          }
          pos++;
        }
      }
      return pos;
    }
    var shebangTriviaRegex = /^#!.*/;
    function isShebangTrivia(text, pos) {
      ts.Debug.assert(pos === 0);
      return shebangTriviaRegex.test(text);
    }
    function scanShebangTrivia(text, pos) {
      var shebang = shebangTriviaRegex.exec(text)[0];
      pos = pos + shebang.length;
      return pos;
    }
    function getCommentRanges(text, pos, trailing) {
      var result;
      var collecting = trailing || pos === 0;
      while (true) {
        var ch = text.charCodeAt(pos);
        switch (ch) {
          case 13:
            if (text.charCodeAt(pos + 1) === 10) {
              pos++;
            }
          case 10:
            pos++;
            if (trailing) {
              return result;
            }
            collecting = true;
            if (result && result.length) {
              ts.lastOrUndefined(result).hasTrailingNewLine = true;
            }
            continue;
          case 9:
          case 11:
          case 12:
          case 32:
            pos++;
            continue;
          case 47:
            var nextChar = text.charCodeAt(pos + 1);
            var hasTrailingNewLine = false;
            if (nextChar === 47 || nextChar === 42) {
              var kind = nextChar === 47 ? 2 : 3;
              var startPos = pos;
              pos += 2;
              if (nextChar === 47) {
                while (pos < text.length) {
                  if (isLineBreak(text.charCodeAt(pos))) {
                    hasTrailingNewLine = true;
                    break;
                  }
                  pos++;
                }
              } else {
                while (pos < text.length) {
                  if (text.charCodeAt(pos) === 42 && text.charCodeAt(pos + 1) === 47) {
                    pos += 2;
                    break;
                  }
                  pos++;
                }
              }
              if (collecting) {
                if (!result) {
                  result = [];
                }
                result.push({
                  pos: startPos,
                  end: pos,
                  hasTrailingNewLine: hasTrailingNewLine,
                  kind: kind
                });
              }
              continue;
            }
            break;
          default:
            if (ch > 127 && (isWhiteSpace(ch) || isLineBreak(ch))) {
              if (result && result.length && isLineBreak(ch)) {
                ts.lastOrUndefined(result).hasTrailingNewLine = true;
              }
              pos++;
              continue;
            }
            break;
        }
        return result;
      }
    }
    function getLeadingCommentRanges(text, pos) {
      return getCommentRanges(text, pos, false);
    }
    ts.getLeadingCommentRanges = getLeadingCommentRanges;
    function getTrailingCommentRanges(text, pos) {
      return getCommentRanges(text, pos, true);
    }
    ts.getTrailingCommentRanges = getTrailingCommentRanges;
    function getShebang(text) {
      return shebangTriviaRegex.test(text) ? shebangTriviaRegex.exec(text)[0] : undefined;
    }
    ts.getShebang = getShebang;
    function isIdentifierStart(ch, languageVersion) {
      return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch === 36 || ch === 95 || ch > 127 && isUnicodeIdentifierStart(ch, languageVersion);
    }
    ts.isIdentifierStart = isIdentifierStart;
    function isIdentifierPart(ch, languageVersion) {
      return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch === 36 || ch === 95 || ch > 127 && isUnicodeIdentifierPart(ch, languageVersion);
    }
    ts.isIdentifierPart = isIdentifierPart;
    function createScanner(languageVersion, skipTrivia, languageVariant, text, onError, start, length) {
      if (languageVariant === void 0) {
        languageVariant = 0;
      }
      var pos;
      var end;
      var startPos;
      var tokenPos;
      var token;
      var tokenValue;
      var precedingLineBreak;
      var hasExtendedUnicodeEscape;
      var tokenIsUnterminated;
      setText(text, start, length);
      return {
        getStartPos: function() {
          return startPos;
        },
        getTextPos: function() {
          return pos;
        },
        getToken: function() {
          return token;
        },
        getTokenPos: function() {
          return tokenPos;
        },
        getTokenText: function() {
          return text.substring(tokenPos, pos);
        },
        getTokenValue: function() {
          return tokenValue;
        },
        hasExtendedUnicodeEscape: function() {
          return hasExtendedUnicodeEscape;
        },
        hasPrecedingLineBreak: function() {
          return precedingLineBreak;
        },
        isIdentifier: function() {
          return token === 67 || token > 103;
        },
        isReservedWord: function() {
          return token >= 68 && token <= 103;
        },
        isUnterminated: function() {
          return tokenIsUnterminated;
        },
        reScanGreaterToken: reScanGreaterToken,
        reScanSlashToken: reScanSlashToken,
        reScanTemplateToken: reScanTemplateToken,
        scanJsxIdentifier: scanJsxIdentifier,
        reScanJsxToken: reScanJsxToken,
        scanJsxToken: scanJsxToken,
        scan: scan,
        setText: setText,
        setScriptTarget: setScriptTarget,
        setLanguageVariant: setLanguageVariant,
        setOnError: setOnError,
        setTextPos: setTextPos,
        tryScan: tryScan,
        lookAhead: lookAhead
      };
      function error(message, length) {
        if (onError) {
          onError(message, length || 0);
        }
      }
      function isIdentifierStart(ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch === 36 || ch === 95 || ch > 127 && isUnicodeIdentifierStart(ch, languageVersion);
      }
      function isIdentifierPart(ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch === 36 || ch === 95 || ch > 127 && isUnicodeIdentifierPart(ch, languageVersion);
      }
      function scanNumber() {
        var start = pos;
        while (isDigit(text.charCodeAt(pos)))
          pos++;
        if (text.charCodeAt(pos) === 46) {
          pos++;
          while (isDigit(text.charCodeAt(pos)))
            pos++;
        }
        var end = pos;
        if (text.charCodeAt(pos) === 69 || text.charCodeAt(pos) === 101) {
          pos++;
          if (text.charCodeAt(pos) === 43 || text.charCodeAt(pos) === 45)
            pos++;
          if (isDigit(text.charCodeAt(pos))) {
            pos++;
            while (isDigit(text.charCodeAt(pos)))
              pos++;
            end = pos;
          } else {
            error(ts.Diagnostics.Digit_expected);
          }
        }
        return +(text.substring(start, end));
      }
      function scanOctalDigits() {
        var start = pos;
        while (isOctalDigit(text.charCodeAt(pos))) {
          pos++;
        }
        return +(text.substring(start, pos));
      }
      function scanExactNumberOfHexDigits(count) {
        return scanHexDigits(count, false);
      }
      function scanMinimumNumberOfHexDigits(count) {
        return scanHexDigits(count, true);
      }
      function scanHexDigits(minCount, scanAsManyAsPossible) {
        var digits = 0;
        var value = 0;
        while (digits < minCount || scanAsManyAsPossible) {
          var ch = text.charCodeAt(pos);
          if (ch >= 48 && ch <= 57) {
            value = value * 16 + ch - 48;
          } else if (ch >= 65 && ch <= 70) {
            value = value * 16 + ch - 65 + 10;
          } else if (ch >= 97 && ch <= 102) {
            value = value * 16 + ch - 97 + 10;
          } else {
            break;
          }
          pos++;
          digits++;
        }
        if (digits < minCount) {
          value = -1;
        }
        return value;
      }
      function scanString() {
        var quote = text.charCodeAt(pos++);
        var result = "";
        var start = pos;
        while (true) {
          if (pos >= end) {
            result += text.substring(start, pos);
            tokenIsUnterminated = true;
            error(ts.Diagnostics.Unterminated_string_literal);
            break;
          }
          var ch = text.charCodeAt(pos);
          if (ch === quote) {
            result += text.substring(start, pos);
            pos++;
            break;
          }
          if (ch === 92) {
            result += text.substring(start, pos);
            result += scanEscapeSequence();
            start = pos;
            continue;
          }
          if (isLineBreak(ch)) {
            result += text.substring(start, pos);
            tokenIsUnterminated = true;
            error(ts.Diagnostics.Unterminated_string_literal);
            break;
          }
          pos++;
        }
        return result;
      }
      function scanTemplateAndSetTokenValue() {
        var startedWithBacktick = text.charCodeAt(pos) === 96;
        pos++;
        var start = pos;
        var contents = "";
        var resultingToken;
        while (true) {
          if (pos >= end) {
            contents += text.substring(start, pos);
            tokenIsUnterminated = true;
            error(ts.Diagnostics.Unterminated_template_literal);
            resultingToken = startedWithBacktick ? 11 : 14;
            break;
          }
          var currChar = text.charCodeAt(pos);
          if (currChar === 96) {
            contents += text.substring(start, pos);
            pos++;
            resultingToken = startedWithBacktick ? 11 : 14;
            break;
          }
          if (currChar === 36 && pos + 1 < end && text.charCodeAt(pos + 1) === 123) {
            contents += text.substring(start, pos);
            pos += 2;
            resultingToken = startedWithBacktick ? 12 : 13;
            break;
          }
          if (currChar === 92) {
            contents += text.substring(start, pos);
            contents += scanEscapeSequence();
            start = pos;
            continue;
          }
          if (currChar === 13) {
            contents += text.substring(start, pos);
            pos++;
            if (pos < end && text.charCodeAt(pos) === 10) {
              pos++;
            }
            contents += "\n";
            start = pos;
            continue;
          }
          pos++;
        }
        ts.Debug.assert(resultingToken !== undefined);
        tokenValue = contents;
        return resultingToken;
      }
      function scanEscapeSequence() {
        pos++;
        if (pos >= end) {
          error(ts.Diagnostics.Unexpected_end_of_text);
          return "";
        }
        var ch = text.charCodeAt(pos++);
        switch (ch) {
          case 48:
            return "\0";
          case 98:
            return "\b";
          case 116:
            return "\t";
          case 110:
            return "\n";
          case 118:
            return "\v";
          case 102:
            return "\f";
          case 114:
            return "\r";
          case 39:
            return "\'";
          case 34:
            return "\"";
          case 117:
            if (pos < end && text.charCodeAt(pos) === 123) {
              hasExtendedUnicodeEscape = true;
              pos++;
              return scanExtendedUnicodeEscape();
            }
            return scanHexadecimalEscape(4);
          case 120:
            return scanHexadecimalEscape(2);
          case 13:
            if (pos < end && text.charCodeAt(pos) === 10) {
              pos++;
            }
          case 10:
          case 8232:
          case 8233:
            return "";
          default:
            return String.fromCharCode(ch);
        }
      }
      function scanHexadecimalEscape(numDigits) {
        var escapedValue = scanExactNumberOfHexDigits(numDigits);
        if (escapedValue >= 0) {
          return String.fromCharCode(escapedValue);
        } else {
          error(ts.Diagnostics.Hexadecimal_digit_expected);
          return "";
        }
      }
      function scanExtendedUnicodeEscape() {
        var escapedValue = scanMinimumNumberOfHexDigits(1);
        var isInvalidExtendedEscape = false;
        if (escapedValue < 0) {
          error(ts.Diagnostics.Hexadecimal_digit_expected);
          isInvalidExtendedEscape = true;
        } else if (escapedValue > 0x10FFFF) {
          error(ts.Diagnostics.An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive);
          isInvalidExtendedEscape = true;
        }
        if (pos >= end) {
          error(ts.Diagnostics.Unexpected_end_of_text);
          isInvalidExtendedEscape = true;
        } else if (text.charCodeAt(pos) === 125) {
          pos++;
        } else {
          error(ts.Diagnostics.Unterminated_Unicode_escape_sequence);
          isInvalidExtendedEscape = true;
        }
        if (isInvalidExtendedEscape) {
          return "";
        }
        return utf16EncodeAsString(escapedValue);
      }
      function utf16EncodeAsString(codePoint) {
        ts.Debug.assert(0x0 <= codePoint && codePoint <= 0x10FFFF);
        if (codePoint <= 65535) {
          return String.fromCharCode(codePoint);
        }
        var codeUnit1 = Math.floor((codePoint - 65536) / 1024) + 0xD800;
        var codeUnit2 = ((codePoint - 65536) % 1024) + 0xDC00;
        return String.fromCharCode(codeUnit1, codeUnit2);
      }
      function peekUnicodeEscape() {
        if (pos + 5 < end && text.charCodeAt(pos + 1) === 117) {
          var start_1 = pos;
          pos += 2;
          var value = scanExactNumberOfHexDigits(4);
          pos = start_1;
          return value;
        }
        return -1;
      }
      function scanIdentifierParts() {
        var result = "";
        var start = pos;
        while (pos < end) {
          var ch = text.charCodeAt(pos);
          if (isIdentifierPart(ch)) {
            pos++;
          } else if (ch === 92) {
            ch = peekUnicodeEscape();
            if (!(ch >= 0 && isIdentifierPart(ch))) {
              break;
            }
            result += text.substring(start, pos);
            result += String.fromCharCode(ch);
            pos += 6;
            start = pos;
          } else {
            break;
          }
        }
        result += text.substring(start, pos);
        return result;
      }
      function getIdentifierToken() {
        var len = tokenValue.length;
        if (len >= 2 && len <= 11) {
          var ch = tokenValue.charCodeAt(0);
          if (ch >= 97 && ch <= 122 && hasOwnProperty.call(textToToken, tokenValue)) {
            return token = textToToken[tokenValue];
          }
        }
        return token = 67;
      }
      function scanBinaryOrOctalDigits(base) {
        ts.Debug.assert(base !== 2 || base !== 8, "Expected either base 2 or base 8");
        var value = 0;
        var numberOfDigits = 0;
        while (true) {
          var ch = text.charCodeAt(pos);
          var valueOfCh = ch - 48;
          if (!isDigit(ch) || valueOfCh >= base) {
            break;
          }
          value = value * base + valueOfCh;
          pos++;
          numberOfDigits++;
        }
        if (numberOfDigits === 0) {
          return -1;
        }
        return value;
      }
      function scan() {
        startPos = pos;
        hasExtendedUnicodeEscape = false;
        precedingLineBreak = false;
        tokenIsUnterminated = false;
        while (true) {
          tokenPos = pos;
          if (pos >= end) {
            return token = 1;
          }
          var ch = text.charCodeAt(pos);
          if (ch === 35 && pos === 0 && isShebangTrivia(text, pos)) {
            pos = scanShebangTrivia(text, pos);
            if (skipTrivia) {
              continue;
            } else {
              return token = 6;
            }
          }
          switch (ch) {
            case 10:
            case 13:
              precedingLineBreak = true;
              if (skipTrivia) {
                pos++;
                continue;
              } else {
                if (ch === 13 && pos + 1 < end && text.charCodeAt(pos + 1) === 10) {
                  pos += 2;
                } else {
                  pos++;
                }
                return token = 4;
              }
            case 9:
            case 11:
            case 12:
            case 32:
              if (skipTrivia) {
                pos++;
                continue;
              } else {
                while (pos < end && isWhiteSpace(text.charCodeAt(pos))) {
                  pos++;
                }
                return token = 5;
              }
            case 33:
              if (text.charCodeAt(pos + 1) === 61) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 33;
                }
                return pos += 2, token = 31;
              }
              return pos++, token = 48;
            case 34:
            case 39:
              tokenValue = scanString();
              return token = 9;
            case 96:
              return token = scanTemplateAndSetTokenValue();
            case 37:
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 60;
              }
              return pos++, token = 39;
            case 38:
              if (text.charCodeAt(pos + 1) === 38) {
                return pos += 2, token = 50;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 64;
              }
              return pos++, token = 45;
            case 40:
              return pos++, token = 17;
            case 41:
              return pos++, token = 18;
            case 42:
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 58;
              }
              return pos++, token = 37;
            case 43:
              if (text.charCodeAt(pos + 1) === 43) {
                return pos += 2, token = 40;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 56;
              }
              return pos++, token = 35;
            case 44:
              return pos++, token = 24;
            case 45:
              if (text.charCodeAt(pos + 1) === 45) {
                return pos += 2, token = 41;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 57;
              }
              return pos++, token = 36;
            case 46:
              if (isDigit(text.charCodeAt(pos + 1))) {
                tokenValue = "" + scanNumber();
                return token = 8;
              }
              if (text.charCodeAt(pos + 1) === 46 && text.charCodeAt(pos + 2) === 46) {
                return pos += 3, token = 22;
              }
              return pos++, token = 21;
            case 47:
              if (text.charCodeAt(pos + 1) === 47) {
                pos += 2;
                while (pos < end) {
                  if (isLineBreak(text.charCodeAt(pos))) {
                    break;
                  }
                  pos++;
                }
                if (skipTrivia) {
                  continue;
                } else {
                  return token = 2;
                }
              }
              if (text.charCodeAt(pos + 1) === 42) {
                pos += 2;
                var commentClosed = false;
                while (pos < end) {
                  var ch_2 = text.charCodeAt(pos);
                  if (ch_2 === 42 && text.charCodeAt(pos + 1) === 47) {
                    pos += 2;
                    commentClosed = true;
                    break;
                  }
                  if (isLineBreak(ch_2)) {
                    precedingLineBreak = true;
                  }
                  pos++;
                }
                if (!commentClosed) {
                  error(ts.Diagnostics.Asterisk_Slash_expected);
                }
                if (skipTrivia) {
                  continue;
                } else {
                  tokenIsUnterminated = !commentClosed;
                  return token = 3;
                }
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 59;
              }
              return pos++, token = 38;
            case 48:
              if (pos + 2 < end && (text.charCodeAt(pos + 1) === 88 || text.charCodeAt(pos + 1) === 120)) {
                pos += 2;
                var value = scanMinimumNumberOfHexDigits(1);
                if (value < 0) {
                  error(ts.Diagnostics.Hexadecimal_digit_expected);
                  value = 0;
                }
                tokenValue = "" + value;
                return token = 8;
              } else if (pos + 2 < end && (text.charCodeAt(pos + 1) === 66 || text.charCodeAt(pos + 1) === 98)) {
                pos += 2;
                var value = scanBinaryOrOctalDigits(2);
                if (value < 0) {
                  error(ts.Diagnostics.Binary_digit_expected);
                  value = 0;
                }
                tokenValue = "" + value;
                return token = 8;
              } else if (pos + 2 < end && (text.charCodeAt(pos + 1) === 79 || text.charCodeAt(pos + 1) === 111)) {
                pos += 2;
                var value = scanBinaryOrOctalDigits(8);
                if (value < 0) {
                  error(ts.Diagnostics.Octal_digit_expected);
                  value = 0;
                }
                tokenValue = "" + value;
                return token = 8;
              }
              if (pos + 1 < end && isOctalDigit(text.charCodeAt(pos + 1))) {
                tokenValue = "" + scanOctalDigits();
                return token = 8;
              }
            case 49:
            case 50:
            case 51:
            case 52:
            case 53:
            case 54:
            case 55:
            case 56:
            case 57:
              tokenValue = "" + scanNumber();
              return token = 8;
            case 58:
              return pos++, token = 53;
            case 59:
              return pos++, token = 23;
            case 60:
              if (isConflictMarkerTrivia(text, pos)) {
                pos = scanConflictMarkerTrivia(text, pos, error);
                if (skipTrivia) {
                  continue;
                } else {
                  return token = 7;
                }
              }
              if (text.charCodeAt(pos + 1) === 60) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 61;
                }
                return pos += 2, token = 42;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 28;
              }
              if (text.charCodeAt(pos + 1) === 47 && languageVariant === 1) {
                return pos += 2, token = 26;
              }
              return pos++, token = 25;
            case 61:
              if (isConflictMarkerTrivia(text, pos)) {
                pos = scanConflictMarkerTrivia(text, pos, error);
                if (skipTrivia) {
                  continue;
                } else {
                  return token = 7;
                }
              }
              if (text.charCodeAt(pos + 1) === 61) {
                if (text.charCodeAt(pos + 2) === 61) {
                  return pos += 3, token = 32;
                }
                return pos += 2, token = 30;
              }
              if (text.charCodeAt(pos + 1) === 62) {
                return pos += 2, token = 34;
              }
              return pos++, token = 55;
            case 62:
              if (isConflictMarkerTrivia(text, pos)) {
                pos = scanConflictMarkerTrivia(text, pos, error);
                if (skipTrivia) {
                  continue;
                } else {
                  return token = 7;
                }
              }
              return pos++, token = 27;
            case 63:
              return pos++, token = 52;
            case 91:
              return pos++, token = 19;
            case 93:
              return pos++, token = 20;
            case 94:
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 66;
              }
              return pos++, token = 47;
            case 123:
              return pos++, token = 15;
            case 124:
              if (text.charCodeAt(pos + 1) === 124) {
                return pos += 2, token = 51;
              }
              if (text.charCodeAt(pos + 1) === 61) {
                return pos += 2, token = 65;
              }
              return pos++, token = 46;
            case 125:
              return pos++, token = 16;
            case 126:
              return pos++, token = 49;
            case 64:
              return pos++, token = 54;
            case 92:
              var cookedChar = peekUnicodeEscape();
              if (cookedChar >= 0 && isIdentifierStart(cookedChar)) {
                pos += 6;
                tokenValue = String.fromCharCode(cookedChar) + scanIdentifierParts();
                return token = getIdentifierToken();
              }
              error(ts.Diagnostics.Invalid_character);
              return pos++, token = 0;
            default:
              if (isIdentifierStart(ch)) {
                pos++;
                while (pos < end && isIdentifierPart(ch = text.charCodeAt(pos)))
                  pos++;
                tokenValue = text.substring(tokenPos, pos);
                if (ch === 92) {
                  tokenValue += scanIdentifierParts();
                }
                return token = getIdentifierToken();
              } else if (isWhiteSpace(ch)) {
                pos++;
                continue;
              } else if (isLineBreak(ch)) {
                precedingLineBreak = true;
                pos++;
                continue;
              }
              error(ts.Diagnostics.Invalid_character);
              return pos++, token = 0;
          }
        }
      }
      function reScanGreaterToken() {
        if (token === 27) {
          if (text.charCodeAt(pos) === 62) {
            if (text.charCodeAt(pos + 1) === 62) {
              if (text.charCodeAt(pos + 2) === 61) {
                return pos += 3, token = 63;
              }
              return pos += 2, token = 44;
            }
            if (text.charCodeAt(pos + 1) === 61) {
              return pos += 2, token = 62;
            }
            return pos++, token = 43;
          }
          if (text.charCodeAt(pos) === 61) {
            return pos++, token = 29;
          }
        }
        return token;
      }
      function reScanSlashToken() {
        if (token === 38 || token === 59) {
          var p = tokenPos + 1;
          var inEscape = false;
          var inCharacterClass = false;
          while (true) {
            if (p >= end) {
              tokenIsUnterminated = true;
              error(ts.Diagnostics.Unterminated_regular_expression_literal);
              break;
            }
            var ch = text.charCodeAt(p);
            if (isLineBreak(ch)) {
              tokenIsUnterminated = true;
              error(ts.Diagnostics.Unterminated_regular_expression_literal);
              break;
            }
            if (inEscape) {
              inEscape = false;
            } else if (ch === 47 && !inCharacterClass) {
              p++;
              break;
            } else if (ch === 91) {
              inCharacterClass = true;
            } else if (ch === 92) {
              inEscape = true;
            } else if (ch === 93) {
              inCharacterClass = false;
            }
            p++;
          }
          while (p < end && isIdentifierPart(text.charCodeAt(p))) {
            p++;
          }
          pos = p;
          tokenValue = text.substring(tokenPos, pos);
          token = 10;
        }
        return token;
      }
      function reScanTemplateToken() {
        ts.Debug.assert(token === 16, "'reScanTemplateToken' should only be called on a '}'");
        pos = tokenPos;
        return token = scanTemplateAndSetTokenValue();
      }
      function reScanJsxToken() {
        pos = tokenPos = startPos;
        return token = scanJsxToken();
      }
      function scanJsxToken() {
        startPos = tokenPos = pos;
        if (pos >= end) {
          return token = 1;
        }
        var char = text.charCodeAt(pos);
        if (char === 60) {
          if (text.charCodeAt(pos + 1) === 47) {
            pos += 2;
            return token = 26;
          }
          pos++;
          return token = 25;
        }
        if (char === 123) {
          pos++;
          return token = 15;
        }
        while (pos < end) {
          pos++;
          char = text.charCodeAt(pos);
          if ((char === 123) || (char === 60)) {
            break;
          }
        }
        return token = 234;
      }
      function scanJsxIdentifier() {
        if (token === 67) {
          var firstCharPosition = pos;
          while (pos < end) {
            var ch = text.charCodeAt(pos);
            if (ch === 45 || ((firstCharPosition === pos) ? isIdentifierStart(ch) : isIdentifierPart(ch))) {
              pos++;
            } else {
              break;
            }
          }
          tokenValue += text.substr(firstCharPosition, pos - firstCharPosition);
        }
        return token;
      }
      function speculationHelper(callback, isLookahead) {
        var savePos = pos;
        var saveStartPos = startPos;
        var saveTokenPos = tokenPos;
        var saveToken = token;
        var saveTokenValue = tokenValue;
        var savePrecedingLineBreak = precedingLineBreak;
        var result = callback();
        if (!result || isLookahead) {
          pos = savePos;
          startPos = saveStartPos;
          tokenPos = saveTokenPos;
          token = saveToken;
          tokenValue = saveTokenValue;
          precedingLineBreak = savePrecedingLineBreak;
        }
        return result;
      }
      function lookAhead(callback) {
        return speculationHelper(callback, true);
      }
      function tryScan(callback) {
        return speculationHelper(callback, false);
      }
      function setText(newText, start, length) {
        text = newText || "";
        end = length === undefined ? text.length : start + length;
        setTextPos(start || 0);
      }
      function setOnError(errorCallback) {
        onError = errorCallback;
      }
      function setScriptTarget(scriptTarget) {
        languageVersion = scriptTarget;
      }
      function setLanguageVariant(variant) {
        languageVariant = variant;
      }
      function setTextPos(textPos) {
        ts.Debug.assert(textPos >= 0);
        pos = textPos;
        startPos = textPos;
        tokenPos = textPos;
        token = 0;
        precedingLineBreak = false;
        tokenValue = undefined;
        hasExtendedUnicodeEscape = false;
        tokenIsUnterminated = false;
      }
    }
    ts.createScanner = createScanner;
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    ts.bindTime = 0;
    function getModuleInstanceState(node) {
      if (node.kind === 213 || node.kind === 214) {
        return 0;
      } else if (ts.isConstEnumDeclaration(node)) {
        return 2;
      } else if ((node.kind === 220 || node.kind === 219) && !(node.flags & 1)) {
        return 0;
      } else if (node.kind === 217) {
        var state = 0;
        ts.forEachChild(node, function(n) {
          switch (getModuleInstanceState(n)) {
            case 0:
              return false;
            case 2:
              state = 2;
              return false;
            case 1:
              state = 1;
              return true;
          }
        });
        return state;
      } else if (node.kind === 216) {
        return getModuleInstanceState(node.body);
      } else {
        return 1;
      }
    }
    ts.getModuleInstanceState = getModuleInstanceState;
    function bindSourceFile(file) {
      var start = new Date().getTime();
      bindSourceFileWorker(file);
      ts.bindTime += new Date().getTime() - start;
    }
    ts.bindSourceFile = bindSourceFile;
    function bindSourceFileWorker(file) {
      var parent;
      var container;
      var blockScopeContainer;
      var lastContainer;
      var inStrictMode = !!file.externalModuleIndicator;
      var symbolCount = 0;
      var Symbol = ts.objectAllocator.getSymbolConstructor();
      var classifiableNames = {};
      if (!file.locals) {
        bind(file);
        file.symbolCount = symbolCount;
        file.classifiableNames = classifiableNames;
      }
      return;
      function createSymbol(flags, name) {
        symbolCount++;
        return new Symbol(flags, name);
      }
      function addDeclarationToSymbol(symbol, node, symbolFlags) {
        symbol.flags |= symbolFlags;
        node.symbol = symbol;
        if (!symbol.declarations) {
          symbol.declarations = [];
        }
        symbol.declarations.push(node);
        if (symbolFlags & 1952 && !symbol.exports) {
          symbol.exports = {};
        }
        if (symbolFlags & 6240 && !symbol.members) {
          symbol.members = {};
        }
        if (symbolFlags & 107455 && !symbol.valueDeclaration) {
          symbol.valueDeclaration = node;
        }
      }
      function getDeclarationName(node) {
        if (node.name) {
          if (node.kind === 216 && node.name.kind === 9) {
            return "\"" + node.name.text + "\"";
          }
          if (node.name.kind === 134) {
            var nameExpression = node.name.expression;
            ts.Debug.assert(ts.isWellKnownSymbolSyntactically(nameExpression));
            return ts.getPropertyNameForKnownSymbolName(nameExpression.name.text);
          }
          return node.name.text;
        }
        switch (node.kind) {
          case 142:
            return "__constructor";
          case 150:
          case 145:
            return "__call";
          case 151:
          case 146:
            return "__new";
          case 147:
            return "__index";
          case 226:
            return "__export";
          case 225:
            return node.isExportEquals ? "export=" : "default";
          case 211:
          case 212:
            return node.flags & 1024 ? "default" : undefined;
        }
      }
      function getDisplayName(node) {
        return node.name ? ts.declarationNameToString(node.name) : getDeclarationName(node);
      }
      function declareSymbol(symbolTable, parent, node, includes, excludes) {
        ts.Debug.assert(!ts.hasDynamicName(node));
        var name = node.flags & 1024 && parent ? "default" : getDeclarationName(node);
        var symbol;
        if (name !== undefined) {
          symbol = ts.hasProperty(symbolTable, name) ? symbolTable[name] : (symbolTable[name] = createSymbol(0, name));
          if (name && (includes & 788448)) {
            classifiableNames[name] = name;
          }
          if (symbol.flags & excludes) {
            if (node.name) {
              node.name.parent = node;
            }
            var message = symbol.flags & 2 ? ts.Diagnostics.Cannot_redeclare_block_scoped_variable_0 : ts.Diagnostics.Duplicate_identifier_0;
            ts.forEach(symbol.declarations, function(declaration) {
              file.bindDiagnostics.push(ts.createDiagnosticForNode(declaration.name || declaration, message, getDisplayName(declaration)));
            });
            file.bindDiagnostics.push(ts.createDiagnosticForNode(node.name || node, message, getDisplayName(node)));
            symbol = createSymbol(0, name);
          }
        } else {
          symbol = createSymbol(0, "__missing");
        }
        addDeclarationToSymbol(symbol, node, includes);
        symbol.parent = parent;
        return symbol;
      }
      function declareModuleMember(node, symbolFlags, symbolExcludes) {
        var hasExportModifier = ts.getCombinedNodeFlags(node) & 1;
        if (symbolFlags & 8388608) {
          if (node.kind === 228 || (node.kind === 219 && hasExportModifier)) {
            return declareSymbol(container.symbol.exports, container.symbol, node, symbolFlags, symbolExcludes);
          } else {
            return declareSymbol(container.locals, undefined, node, symbolFlags, symbolExcludes);
          }
        } else {
          if (hasExportModifier || container.flags & 262144) {
            var exportKind = (symbolFlags & 107455 ? 1048576 : 0) | (symbolFlags & 793056 ? 2097152 : 0) | (symbolFlags & 1536 ? 4194304 : 0);
            var local = declareSymbol(container.locals, undefined, node, exportKind, symbolExcludes);
            local.exportSymbol = declareSymbol(container.symbol.exports, container.symbol, node, symbolFlags, symbolExcludes);
            node.localSymbol = local;
            return local;
          } else {
            return declareSymbol(container.locals, undefined, node, symbolFlags, symbolExcludes);
          }
        }
      }
      function bindChildren(node) {
        var saveParent = parent;
        var saveContainer = container;
        var savedBlockScopeContainer = blockScopeContainer;
        parent = node;
        var containerFlags = getContainerFlags(node);
        if (containerFlags & 1) {
          container = blockScopeContainer = node;
          if (containerFlags & 4) {
            container.locals = {};
          }
          addToContainerChain(container);
        } else if (containerFlags & 2) {
          blockScopeContainer = node;
          blockScopeContainer.locals = undefined;
        }
        ts.forEachChild(node, bind);
        container = saveContainer;
        parent = saveParent;
        blockScopeContainer = savedBlockScopeContainer;
      }
      function getContainerFlags(node) {
        switch (node.kind) {
          case 184:
          case 212:
          case 213:
          case 215:
          case 153:
          case 163:
            return 1;
          case 145:
          case 146:
          case 147:
          case 141:
          case 140:
          case 211:
          case 142:
          case 143:
          case 144:
          case 150:
          case 151:
          case 171:
          case 172:
          case 216:
          case 246:
          case 214:
            return 5;
          case 242:
          case 197:
          case 198:
          case 199:
          case 218:
            return 2;
          case 190:
            return ts.isFunctionLike(node.parent) ? 0 : 2;
        }
        return 0;
      }
      function addToContainerChain(next) {
        if (lastContainer) {
          lastContainer.nextContainer = next;
        }
        lastContainer = next;
      }
      function declareSymbolAndAddToSymbolTable(node, symbolFlags, symbolExcludes) {
        declareSymbolAndAddToSymbolTableWorker(node, symbolFlags, symbolExcludes);
      }
      function declareSymbolAndAddToSymbolTableWorker(node, symbolFlags, symbolExcludes) {
        switch (container.kind) {
          case 216:
            return declareModuleMember(node, symbolFlags, symbolExcludes);
          case 246:
            return declareSourceFileMember(node, symbolFlags, symbolExcludes);
          case 184:
          case 212:
            return declareClassMember(node, symbolFlags, symbolExcludes);
          case 215:
            return declareSymbol(container.symbol.exports, container.symbol, node, symbolFlags, symbolExcludes);
          case 153:
          case 163:
          case 213:
            return declareSymbol(container.symbol.members, container.symbol, node, symbolFlags, symbolExcludes);
          case 150:
          case 151:
          case 145:
          case 146:
          case 147:
          case 141:
          case 140:
          case 142:
          case 143:
          case 144:
          case 211:
          case 171:
          case 172:
          case 214:
            return declareSymbol(container.locals, undefined, node, symbolFlags, symbolExcludes);
        }
      }
      function declareClassMember(node, symbolFlags, symbolExcludes) {
        return node.flags & 128 ? declareSymbol(container.symbol.exports, container.symbol, node, symbolFlags, symbolExcludes) : declareSymbol(container.symbol.members, container.symbol, node, symbolFlags, symbolExcludes);
      }
      function declareSourceFileMember(node, symbolFlags, symbolExcludes) {
        return ts.isExternalModule(file) ? declareModuleMember(node, symbolFlags, symbolExcludes) : declareSymbol(file.locals, undefined, node, symbolFlags, symbolExcludes);
      }
      function isAmbientContext(node) {
        while (node) {
          if (node.flags & 2) {
            return true;
          }
          node = node.parent;
        }
        return false;
      }
      function hasExportDeclarations(node) {
        var body = node.kind === 246 ? node : node.body;
        if (body.kind === 246 || body.kind === 217) {
          for (var _i = 0,
              _a = body.statements; _i < _a.length; _i++) {
            var stat = _a[_i];
            if (stat.kind === 226 || stat.kind === 225) {
              return true;
            }
          }
        }
        return false;
      }
      function setExportContextFlag(node) {
        if (isAmbientContext(node) && !hasExportDeclarations(node)) {
          node.flags |= 262144;
        } else {
          node.flags &= ~262144;
        }
      }
      function bindModuleDeclaration(node) {
        setExportContextFlag(node);
        if (node.name.kind === 9) {
          declareSymbolAndAddToSymbolTable(node, 512, 106639);
        } else {
          var state = getModuleInstanceState(node);
          if (state === 0) {
            declareSymbolAndAddToSymbolTable(node, 1024, 0);
          } else {
            declareSymbolAndAddToSymbolTable(node, 512, 106639);
            if (node.symbol.flags & (16 | 32 | 256)) {
              node.symbol.constEnumOnlyModule = false;
            } else {
              var currentModuleIsConstEnumOnly = state === 2;
              if (node.symbol.constEnumOnlyModule === undefined) {
                node.symbol.constEnumOnlyModule = currentModuleIsConstEnumOnly;
              } else {
                node.symbol.constEnumOnlyModule = node.symbol.constEnumOnlyModule && currentModuleIsConstEnumOnly;
              }
            }
          }
        }
      }
      function bindFunctionOrConstructorType(node) {
        var symbol = createSymbol(131072, getDeclarationName(node));
        addDeclarationToSymbol(symbol, node, 131072);
        var typeLiteralSymbol = createSymbol(2048, "__type");
        addDeclarationToSymbol(typeLiteralSymbol, node, 2048);
        typeLiteralSymbol.members = (_a = {}, _a[symbol.name] = symbol, _a);
        var _a;
      }
      function bindObjectLiteralExpression(node) {
        if (inStrictMode) {
          var seen = {};
          for (var _i = 0,
              _a = node.properties; _i < _a.length; _i++) {
            var prop = _a[_i];
            if (prop.name.kind !== 67) {
              continue;
            }
            var identifier = prop.name;
            var currentKind = prop.kind === 243 || prop.kind === 244 || prop.kind === 141 ? 1 : 2;
            var existingKind = seen[identifier.text];
            if (!existingKind) {
              seen[identifier.text] = currentKind;
              continue;
            }
            if (currentKind === 1 && existingKind === 1) {
              var span = ts.getErrorSpanForNode(file, identifier);
              file.bindDiagnostics.push(ts.createFileDiagnostic(file, span.start, span.length, ts.Diagnostics.An_object_literal_cannot_have_multiple_properties_with_the_same_name_in_strict_mode));
            }
          }
        }
        return bindAnonymousDeclaration(node, 4096, "__object");
      }
      function bindAnonymousDeclaration(node, symbolFlags, name) {
        var symbol = createSymbol(symbolFlags, name);
        addDeclarationToSymbol(symbol, node, symbolFlags);
      }
      function bindBlockScopedDeclaration(node, symbolFlags, symbolExcludes) {
        switch (blockScopeContainer.kind) {
          case 216:
            declareModuleMember(node, symbolFlags, symbolExcludes);
            break;
          case 246:
            if (ts.isExternalModule(container)) {
              declareModuleMember(node, symbolFlags, symbolExcludes);
              break;
            }
          default:
            if (!blockScopeContainer.locals) {
              blockScopeContainer.locals = {};
              addToContainerChain(blockScopeContainer);
            }
            declareSymbol(blockScopeContainer.locals, undefined, node, symbolFlags, symbolExcludes);
        }
      }
      function bindBlockScopedVariableDeclaration(node) {
        bindBlockScopedDeclaration(node, 2, 107455);
      }
      function checkStrictModeIdentifier(node) {
        if (inStrictMode && node.originalKeywordKind >= 104 && node.originalKeywordKind <= 112 && !ts.isIdentifierName(node)) {
          if (!file.parseDiagnostics.length) {
            file.bindDiagnostics.push(ts.createDiagnosticForNode(node, getStrictModeIdentifierMessage(node), ts.declarationNameToString(node)));
          }
        }
      }
      function getStrictModeIdentifierMessage(node) {
        if (ts.getContainingClass(node)) {
          return ts.Diagnostics.Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode;
        }
        if (file.externalModuleIndicator) {
          return ts.Diagnostics.Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode;
        }
        return ts.Diagnostics.Identifier_expected_0_is_a_reserved_word_in_strict_mode;
      }
      function checkStrictModeBinaryExpression(node) {
        if (inStrictMode && ts.isLeftHandSideExpression(node.left) && ts.isAssignmentOperator(node.operatorToken.kind)) {
          checkStrictModeEvalOrArguments(node, node.left);
        }
      }
      function checkStrictModeCatchClause(node) {
        if (inStrictMode && node.variableDeclaration) {
          checkStrictModeEvalOrArguments(node, node.variableDeclaration.name);
        }
      }
      function checkStrictModeDeleteExpression(node) {
        if (inStrictMode && node.expression.kind === 67) {
          var span = ts.getErrorSpanForNode(file, node.expression);
          file.bindDiagnostics.push(ts.createFileDiagnostic(file, span.start, span.length, ts.Diagnostics.delete_cannot_be_called_on_an_identifier_in_strict_mode));
        }
      }
      function isEvalOrArgumentsIdentifier(node) {
        return node.kind === 67 && (node.text === "eval" || node.text === "arguments");
      }
      function checkStrictModeEvalOrArguments(contextNode, name) {
        if (name && name.kind === 67) {
          var identifier = name;
          if (isEvalOrArgumentsIdentifier(identifier)) {
            var span = ts.getErrorSpanForNode(file, name);
            file.bindDiagnostics.push(ts.createFileDiagnostic(file, span.start, span.length, getStrictModeEvalOrArgumentsMessage(contextNode), identifier.text));
          }
        }
      }
      function getStrictModeEvalOrArgumentsMessage(node) {
        if (ts.getContainingClass(node)) {
          return ts.Diagnostics.Invalid_use_of_0_Class_definitions_are_automatically_in_strict_mode;
        }
        if (file.externalModuleIndicator) {
          return ts.Diagnostics.Invalid_use_of_0_Modules_are_automatically_in_strict_mode;
        }
        return ts.Diagnostics.Invalid_use_of_0_in_strict_mode;
      }
      function checkStrictModeFunctionName(node) {
        if (inStrictMode) {
          checkStrictModeEvalOrArguments(node, node.name);
        }
      }
      function checkStrictModeNumericLiteral(node) {
        if (inStrictMode && node.flags & 65536) {
          file.bindDiagnostics.push(ts.createDiagnosticForNode(node, ts.Diagnostics.Octal_literals_are_not_allowed_in_strict_mode));
        }
      }
      function checkStrictModePostfixUnaryExpression(node) {
        if (inStrictMode) {
          checkStrictModeEvalOrArguments(node, node.operand);
        }
      }
      function checkStrictModePrefixUnaryExpression(node) {
        if (inStrictMode) {
          if (node.operator === 40 || node.operator === 41) {
            checkStrictModeEvalOrArguments(node, node.operand);
          }
        }
      }
      function checkStrictModeWithStatement(node) {
        if (inStrictMode) {
          grammarErrorOnFirstToken(node, ts.Diagnostics.with_statements_are_not_allowed_in_strict_mode);
        }
      }
      function grammarErrorOnFirstToken(node, message, arg0, arg1, arg2) {
        var span = ts.getSpanOfTokenAtPosition(file, node.pos);
        file.bindDiagnostics.push(ts.createFileDiagnostic(file, span.start, span.length, message, arg0, arg1, arg2));
      }
      function getDestructuringParameterName(node) {
        return "__" + ts.indexOf(node.parent.parameters, node);
      }
      function bind(node) {
        node.parent = parent;
        var savedInStrictMode = inStrictMode;
        if (!savedInStrictMode) {
          updateStrictMode(node);
        }
        bindWorker(node);
        bindChildren(node);
        inStrictMode = savedInStrictMode;
      }
      function updateStrictMode(node) {
        switch (node.kind) {
          case 246:
          case 217:
            updateStrictModeStatementList(node.statements);
            return;
          case 190:
            if (ts.isFunctionLike(node.parent)) {
              updateStrictModeStatementList(node.statements);
            }
            return;
          case 212:
          case 184:
            inStrictMode = true;
            return;
        }
      }
      function updateStrictModeStatementList(statements) {
        for (var _i = 0; _i < statements.length; _i++) {
          var statement = statements[_i];
          if (!ts.isPrologueDirective(statement)) {
            return;
          }
          if (isUseStrictPrologueDirective(statement)) {
            inStrictMode = true;
            return;
          }
        }
      }
      function isUseStrictPrologueDirective(node) {
        var nodeText = ts.getTextOfNodeFromSourceText(file.text, node.expression);
        return nodeText === "\"use strict\"" || nodeText === "'use strict'";
      }
      function bindWorker(node) {
        switch (node.kind) {
          case 67:
            return checkStrictModeIdentifier(node);
          case 179:
            return checkStrictModeBinaryExpression(node);
          case 242:
            return checkStrictModeCatchClause(node);
          case 173:
            return checkStrictModeDeleteExpression(node);
          case 8:
            return checkStrictModeNumericLiteral(node);
          case 178:
            return checkStrictModePostfixUnaryExpression(node);
          case 177:
            return checkStrictModePrefixUnaryExpression(node);
          case 203:
            return checkStrictModeWithStatement(node);
          case 135:
            return declareSymbolAndAddToSymbolTable(node, 262144, 530912);
          case 136:
            return bindParameter(node);
          case 209:
          case 161:
            return bindVariableDeclarationOrBindingElement(node);
          case 139:
          case 138:
            return bindPropertyOrMethodOrAccessor(node, 4 | (node.questionToken ? 536870912 : 0), 107455);
          case 243:
          case 244:
            return bindPropertyOrMethodOrAccessor(node, 4, 107455);
          case 245:
            return bindPropertyOrMethodOrAccessor(node, 8, 107455);
          case 145:
          case 146:
          case 147:
            return declareSymbolAndAddToSymbolTable(node, 131072, 0);
          case 141:
          case 140:
            return bindPropertyOrMethodOrAccessor(node, 8192 | (node.questionToken ? 536870912 : 0), ts.isObjectLiteralMethod(node) ? 107455 : 99263);
          case 211:
            checkStrictModeFunctionName(node);
            return declareSymbolAndAddToSymbolTable(node, 16, 106927);
          case 142:
            return declareSymbolAndAddToSymbolTable(node, 16384, 0);
          case 143:
            return bindPropertyOrMethodOrAccessor(node, 32768, 41919);
          case 144:
            return bindPropertyOrMethodOrAccessor(node, 65536, 74687);
          case 150:
          case 151:
            return bindFunctionOrConstructorType(node);
          case 153:
            return bindAnonymousDeclaration(node, 2048, "__type");
          case 163:
            return bindObjectLiteralExpression(node);
          case 171:
          case 172:
            checkStrictModeFunctionName(node);
            var bindingName = node.name ? node.name.text : "__function";
            return bindAnonymousDeclaration(node, 16, bindingName);
          case 184:
          case 212:
            return bindClassLikeDeclaration(node);
          case 213:
            return bindBlockScopedDeclaration(node, 64, 792960);
          case 214:
            return bindBlockScopedDeclaration(node, 524288, 793056);
          case 215:
            return bindEnumDeclaration(node);
          case 216:
            return bindModuleDeclaration(node);
          case 219:
          case 222:
          case 224:
          case 228:
            return declareSymbolAndAddToSymbolTable(node, 8388608, 8388608);
          case 221:
            return bindImportClause(node);
          case 226:
            return bindExportDeclaration(node);
          case 225:
            return bindExportAssignment(node);
          case 246:
            return bindSourceFileIfExternalModule();
        }
      }
      function bindSourceFileIfExternalModule() {
        setExportContextFlag(file);
        if (ts.isExternalModule(file)) {
          bindAnonymousDeclaration(file, 512, "\"" + ts.removeFileExtension(file.fileName) + "\"");
        }
      }
      function bindExportAssignment(node) {
        if (!container.symbol || !container.symbol.exports) {
          bindAnonymousDeclaration(node, 8388608, getDeclarationName(node));
        } else if (node.expression.kind === 67) {
          declareSymbol(container.symbol.exports, container.symbol, node, 8388608, 107455 | 8388608);
        } else {
          declareSymbol(container.symbol.exports, container.symbol, node, 4, 107455 | 8388608);
        }
      }
      function bindExportDeclaration(node) {
        if (!container.symbol || !container.symbol.exports) {
          bindAnonymousDeclaration(node, 1073741824, getDeclarationName(node));
        } else if (!node.exportClause) {
          declareSymbol(container.symbol.exports, container.symbol, node, 1073741824, 0);
        }
      }
      function bindImportClause(node) {
        if (node.name) {
          declareSymbolAndAddToSymbolTable(node, 8388608, 8388608);
        }
      }
      function bindClassLikeDeclaration(node) {
        if (node.kind === 212) {
          bindBlockScopedDeclaration(node, 32, 899519);
        } else {
          var bindingName = node.name ? node.name.text : "__class";
          bindAnonymousDeclaration(node, 32, bindingName);
          if (node.name) {
            classifiableNames[node.name.text] = node.name.text;
          }
        }
        var symbol = node.symbol;
        var prototypeSymbol = createSymbol(4 | 134217728, "prototype");
        if (ts.hasProperty(symbol.exports, prototypeSymbol.name)) {
          if (node.name) {
            node.name.parent = node;
          }
          file.bindDiagnostics.push(ts.createDiagnosticForNode(symbol.exports[prototypeSymbol.name].declarations[0], ts.Diagnostics.Duplicate_identifier_0, prototypeSymbol.name));
        }
        symbol.exports[prototypeSymbol.name] = prototypeSymbol;
        prototypeSymbol.parent = symbol;
      }
      function bindEnumDeclaration(node) {
        return ts.isConst(node) ? bindBlockScopedDeclaration(node, 128, 899967) : bindBlockScopedDeclaration(node, 256, 899327);
      }
      function bindVariableDeclarationOrBindingElement(node) {
        if (inStrictMode) {
          checkStrictModeEvalOrArguments(node, node.name);
        }
        if (!ts.isBindingPattern(node.name)) {
          if (ts.isBlockOrCatchScoped(node)) {
            bindBlockScopedVariableDeclaration(node);
          } else if (ts.isParameterDeclaration(node)) {
            declareSymbolAndAddToSymbolTable(node, 1, 107455);
          } else {
            declareSymbolAndAddToSymbolTable(node, 1, 107454);
          }
        }
      }
      function bindParameter(node) {
        if (inStrictMode) {
          checkStrictModeEvalOrArguments(node, node.name);
        }
        if (ts.isBindingPattern(node.name)) {
          bindAnonymousDeclaration(node, 1, getDestructuringParameterName(node));
        } else {
          declareSymbolAndAddToSymbolTable(node, 1, 107455);
        }
        if (node.flags & 112 && node.parent.kind === 142 && ts.isClassLike(node.parent.parent)) {
          var classDeclaration = node.parent.parent;
          declareSymbol(classDeclaration.symbol.members, classDeclaration.symbol, node, 4, 107455);
        }
      }
      function bindPropertyOrMethodOrAccessor(node, symbolFlags, symbolExcludes) {
        return ts.hasDynamicName(node) ? bindAnonymousDeclaration(node, symbolFlags, "__computed") : declareSymbolAndAddToSymbolTable(node, symbolFlags, symbolExcludes);
      }
    }
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    function getDeclarationOfKind(symbol, kind) {
      var declarations = symbol.declarations;
      if (declarations) {
        for (var _i = 0; _i < declarations.length; _i++) {
          var declaration = declarations[_i];
          if (declaration.kind === kind) {
            return declaration;
          }
        }
      }
      return undefined;
    }
    ts.getDeclarationOfKind = getDeclarationOfKind;
    var stringWriters = [];
    function getSingleLineStringWriter() {
      if (stringWriters.length === 0) {
        var str = "";
        var writeText = function(text) {
          return str += text;
        };
        return {
          string: function() {
            return str;
          },
          writeKeyword: writeText,
          writeOperator: writeText,
          writePunctuation: writeText,
          writeSpace: writeText,
          writeStringLiteral: writeText,
          writeParameter: writeText,
          writeSymbol: writeText,
          writeLine: function() {
            return str += " ";
          },
          increaseIndent: function() {},
          decreaseIndent: function() {},
          clear: function() {
            return str = "";
          },
          trackSymbol: function() {}
        };
      }
      return stringWriters.pop();
    }
    ts.getSingleLineStringWriter = getSingleLineStringWriter;
    function releaseStringWriter(writer) {
      writer.clear();
      stringWriters.push(writer);
    }
    ts.releaseStringWriter = releaseStringWriter;
    function getFullWidth(node) {
      return node.end - node.pos;
    }
    ts.getFullWidth = getFullWidth;
    function arrayIsEqualTo(arr1, arr2, comparer) {
      if (!arr1 || !arr2) {
        return arr1 === arr2;
      }
      if (arr1.length !== arr2.length) {
        return false;
      }
      for (var i = 0; i < arr1.length; ++i) {
        var equals = comparer ? comparer(arr1[i], arr2[i]) : arr1[i] === arr2[i];
        if (!equals) {
          return false;
        }
      }
      return true;
    }
    ts.arrayIsEqualTo = arrayIsEqualTo;
    function hasResolvedModule(sourceFile, moduleNameText) {
      return sourceFile.resolvedModules && ts.hasProperty(sourceFile.resolvedModules, moduleNameText);
    }
    ts.hasResolvedModule = hasResolvedModule;
    function getResolvedModule(sourceFile, moduleNameText) {
      return hasResolvedModule(sourceFile, moduleNameText) ? sourceFile.resolvedModules[moduleNameText] : undefined;
    }
    ts.getResolvedModule = getResolvedModule;
    function setResolvedModule(sourceFile, moduleNameText, resolvedModule) {
      if (!sourceFile.resolvedModules) {
        sourceFile.resolvedModules = {};
      }
      sourceFile.resolvedModules[moduleNameText] = resolvedModule;
    }
    ts.setResolvedModule = setResolvedModule;
    function containsParseError(node) {
      aggregateChildData(node);
      return (node.parserContextFlags & 64) !== 0;
    }
    ts.containsParseError = containsParseError;
    function aggregateChildData(node) {
      if (!(node.parserContextFlags & 128)) {
        var thisNodeOrAnySubNodesHasError = ((node.parserContextFlags & 16) !== 0) || ts.forEachChild(node, containsParseError);
        if (thisNodeOrAnySubNodesHasError) {
          node.parserContextFlags |= 64;
        }
        node.parserContextFlags |= 128;
      }
    }
    function getSourceFileOfNode(node) {
      while (node && node.kind !== 246) {
        node = node.parent;
      }
      return node;
    }
    ts.getSourceFileOfNode = getSourceFileOfNode;
    function getStartPositionOfLine(line, sourceFile) {
      ts.Debug.assert(line >= 0);
      return ts.getLineStarts(sourceFile)[line];
    }
    ts.getStartPositionOfLine = getStartPositionOfLine;
    function nodePosToString(node) {
      var file = getSourceFileOfNode(node);
      var loc = ts.getLineAndCharacterOfPosition(file, node.pos);
      return file.fileName + "(" + (loc.line + 1) + "," + (loc.character + 1) + ")";
    }
    ts.nodePosToString = nodePosToString;
    function getStartPosOfNode(node) {
      return node.pos;
    }
    ts.getStartPosOfNode = getStartPosOfNode;
    function nodeIsMissing(node) {
      if (!node) {
        return true;
      }
      return node.pos === node.end && node.pos >= 0 && node.kind !== 1;
    }
    ts.nodeIsMissing = nodeIsMissing;
    function nodeIsPresent(node) {
      return !nodeIsMissing(node);
    }
    ts.nodeIsPresent = nodeIsPresent;
    function getTokenPosOfNode(node, sourceFile) {
      if (nodeIsMissing(node)) {
        return node.pos;
      }
      return ts.skipTrivia((sourceFile || getSourceFileOfNode(node)).text, node.pos);
    }
    ts.getTokenPosOfNode = getTokenPosOfNode;
    function getNonDecoratorTokenPosOfNode(node, sourceFile) {
      if (nodeIsMissing(node) || !node.decorators) {
        return getTokenPosOfNode(node, sourceFile);
      }
      return ts.skipTrivia((sourceFile || getSourceFileOfNode(node)).text, node.decorators.end);
    }
    ts.getNonDecoratorTokenPosOfNode = getNonDecoratorTokenPosOfNode;
    function getSourceTextOfNodeFromSourceFile(sourceFile, node, includeTrivia) {
      if (includeTrivia === void 0) {
        includeTrivia = false;
      }
      if (nodeIsMissing(node)) {
        return "";
      }
      var text = sourceFile.text;
      return text.substring(includeTrivia ? node.pos : ts.skipTrivia(text, node.pos), node.end);
    }
    ts.getSourceTextOfNodeFromSourceFile = getSourceTextOfNodeFromSourceFile;
    function getTextOfNodeFromSourceText(sourceText, node) {
      if (nodeIsMissing(node)) {
        return "";
      }
      return sourceText.substring(ts.skipTrivia(sourceText, node.pos), node.end);
    }
    ts.getTextOfNodeFromSourceText = getTextOfNodeFromSourceText;
    function getTextOfNode(node, includeTrivia) {
      if (includeTrivia === void 0) {
        includeTrivia = false;
      }
      return getSourceTextOfNodeFromSourceFile(getSourceFileOfNode(node), node, includeTrivia);
    }
    ts.getTextOfNode = getTextOfNode;
    function escapeIdentifier(identifier) {
      return identifier.length >= 2 && identifier.charCodeAt(0) === 95 && identifier.charCodeAt(1) === 95 ? "_" + identifier : identifier;
    }
    ts.escapeIdentifier = escapeIdentifier;
    function unescapeIdentifier(identifier) {
      return identifier.length >= 3 && identifier.charCodeAt(0) === 95 && identifier.charCodeAt(1) === 95 && identifier.charCodeAt(2) === 95 ? identifier.substr(1) : identifier;
    }
    ts.unescapeIdentifier = unescapeIdentifier;
    function makeIdentifierFromModuleName(moduleName) {
      return ts.getBaseFileName(moduleName).replace(/^(\d)/, "_$1").replace(/\W/g, "_");
    }
    ts.makeIdentifierFromModuleName = makeIdentifierFromModuleName;
    function isBlockOrCatchScoped(declaration) {
      return (getCombinedNodeFlags(declaration) & 49152) !== 0 || isCatchClauseVariableDeclaration(declaration);
    }
    ts.isBlockOrCatchScoped = isBlockOrCatchScoped;
    function getEnclosingBlockScopeContainer(node) {
      var current = node.parent;
      while (current) {
        if (isFunctionLike(current)) {
          return current;
        }
        switch (current.kind) {
          case 246:
          case 218:
          case 242:
          case 216:
          case 197:
          case 198:
          case 199:
            return current;
          case 190:
            if (!isFunctionLike(current.parent)) {
              return current;
            }
        }
        current = current.parent;
      }
    }
    ts.getEnclosingBlockScopeContainer = getEnclosingBlockScopeContainer;
    function isCatchClauseVariableDeclaration(declaration) {
      return declaration && declaration.kind === 209 && declaration.parent && declaration.parent.kind === 242;
    }
    ts.isCatchClauseVariableDeclaration = isCatchClauseVariableDeclaration;
    function declarationNameToString(name) {
      return getFullWidth(name) === 0 ? "(Missing)" : getTextOfNode(name);
    }
    ts.declarationNameToString = declarationNameToString;
    function createDiagnosticForNode(node, message, arg0, arg1, arg2) {
      var sourceFile = getSourceFileOfNode(node);
      var span = getErrorSpanForNode(sourceFile, node);
      return ts.createFileDiagnostic(sourceFile, span.start, span.length, message, arg0, arg1, arg2);
    }
    ts.createDiagnosticForNode = createDiagnosticForNode;
    function createDiagnosticForNodeFromMessageChain(node, messageChain) {
      var sourceFile = getSourceFileOfNode(node);
      var span = getErrorSpanForNode(sourceFile, node);
      return {
        file: sourceFile,
        start: span.start,
        length: span.length,
        code: messageChain.code,
        category: messageChain.category,
        messageText: messageChain.next ? messageChain : messageChain.messageText
      };
    }
    ts.createDiagnosticForNodeFromMessageChain = createDiagnosticForNodeFromMessageChain;
    function getSpanOfTokenAtPosition(sourceFile, pos) {
      var scanner = ts.createScanner(sourceFile.languageVersion, true, sourceFile.languageVariant, sourceFile.text, undefined, pos);
      scanner.scan();
      var start = scanner.getTokenPos();
      return ts.createTextSpanFromBounds(start, scanner.getTextPos());
    }
    ts.getSpanOfTokenAtPosition = getSpanOfTokenAtPosition;
    function getErrorSpanForNode(sourceFile, node) {
      var errorNode = node;
      switch (node.kind) {
        case 246:
          var pos_1 = ts.skipTrivia(sourceFile.text, 0, false);
          if (pos_1 === sourceFile.text.length) {
            return ts.createTextSpan(0, 0);
          }
          return getSpanOfTokenAtPosition(sourceFile, pos_1);
        case 209:
        case 161:
        case 212:
        case 184:
        case 213:
        case 216:
        case 215:
        case 245:
        case 211:
        case 171:
          errorNode = node.name;
          break;
      }
      if (errorNode === undefined) {
        return getSpanOfTokenAtPosition(sourceFile, node.pos);
      }
      var pos = nodeIsMissing(errorNode) ? errorNode.pos : ts.skipTrivia(sourceFile.text, errorNode.pos);
      return ts.createTextSpanFromBounds(pos, errorNode.end);
    }
    ts.getErrorSpanForNode = getErrorSpanForNode;
    function isExternalModule(file) {
      return file.externalModuleIndicator !== undefined;
    }
    ts.isExternalModule = isExternalModule;
    function isDeclarationFile(file) {
      return (file.flags & 8192) !== 0;
    }
    ts.isDeclarationFile = isDeclarationFile;
    function isConstEnumDeclaration(node) {
      return node.kind === 215 && isConst(node);
    }
    ts.isConstEnumDeclaration = isConstEnumDeclaration;
    function walkUpBindingElementsAndPatterns(node) {
      while (node && (node.kind === 161 || isBindingPattern(node))) {
        node = node.parent;
      }
      return node;
    }
    function getCombinedNodeFlags(node) {
      node = walkUpBindingElementsAndPatterns(node);
      var flags = node.flags;
      if (node.kind === 209) {
        node = node.parent;
      }
      if (node && node.kind === 210) {
        flags |= node.flags;
        node = node.parent;
      }
      if (node && node.kind === 191) {
        flags |= node.flags;
      }
      return flags;
    }
    ts.getCombinedNodeFlags = getCombinedNodeFlags;
    function isConst(node) {
      return !!(getCombinedNodeFlags(node) & 32768);
    }
    ts.isConst = isConst;
    function isLet(node) {
      return !!(getCombinedNodeFlags(node) & 16384);
    }
    ts.isLet = isLet;
    function isPrologueDirective(node) {
      return node.kind === 193 && node.expression.kind === 9;
    }
    ts.isPrologueDirective = isPrologueDirective;
    function getLeadingCommentRangesOfNode(node, sourceFileOfNode) {
      return ts.getLeadingCommentRanges(sourceFileOfNode.text, node.pos);
    }
    ts.getLeadingCommentRangesOfNode = getLeadingCommentRangesOfNode;
    function getJsDocComments(node, sourceFileOfNode) {
      var commentRanges = (node.kind === 136 || node.kind === 135) ? ts.concatenate(ts.getTrailingCommentRanges(sourceFileOfNode.text, node.pos), ts.getLeadingCommentRanges(sourceFileOfNode.text, node.pos)) : getLeadingCommentRangesOfNode(node, sourceFileOfNode);
      return ts.filter(commentRanges, isJsDocComment);
      function isJsDocComment(comment) {
        return sourceFileOfNode.text.charCodeAt(comment.pos + 1) === 42 && sourceFileOfNode.text.charCodeAt(comment.pos + 2) === 42 && sourceFileOfNode.text.charCodeAt(comment.pos + 3) !== 47;
      }
    }
    ts.getJsDocComments = getJsDocComments;
    ts.fullTripleSlashReferencePathRegEx = /^(\/\/\/\s*<reference\s+path\s*=\s*)('|")(.+?)\2.*?\/>/;
    function isTypeNode(node) {
      if (149 <= node.kind && node.kind <= 158) {
        return true;
      }
      switch (node.kind) {
        case 115:
        case 126:
        case 128:
        case 118:
        case 129:
          return true;
        case 101:
          return node.parent.kind !== 175;
        case 9:
          return node.parent.kind === 136;
        case 186:
          return !isExpressionWithTypeArgumentsInClassExtendsClause(node);
        case 67:
          if (node.parent.kind === 133 && node.parent.right === node) {
            node = node.parent;
          } else if (node.parent.kind === 164 && node.parent.name === node) {
            node = node.parent;
          }
        case 133:
        case 164:
          ts.Debug.assert(node.kind === 67 || node.kind === 133 || node.kind === 164, "'node' was expected to be a qualified name, identifier or property access in 'isTypeNode'.");
          var parent_1 = node.parent;
          if (parent_1.kind === 152) {
            return false;
          }
          if (149 <= parent_1.kind && parent_1.kind <= 158) {
            return true;
          }
          switch (parent_1.kind) {
            case 186:
              return !isExpressionWithTypeArgumentsInClassExtendsClause(parent_1);
            case 135:
              return node === parent_1.constraint;
            case 139:
            case 138:
            case 136:
            case 209:
              return node === parent_1.type;
            case 211:
            case 171:
            case 172:
            case 142:
            case 141:
            case 140:
            case 143:
            case 144:
              return node === parent_1.type;
            case 145:
            case 146:
            case 147:
              return node === parent_1.type;
            case 169:
              return node === parent_1.type;
            case 166:
            case 167:
              return parent_1.typeArguments && ts.indexOf(parent_1.typeArguments, node) >= 0;
            case 168:
              return false;
          }
      }
      return false;
    }
    ts.isTypeNode = isTypeNode;
    function forEachReturnStatement(body, visitor) {
      return traverse(body);
      function traverse(node) {
        switch (node.kind) {
          case 202:
            return visitor(node);
          case 218:
          case 190:
          case 194:
          case 195:
          case 196:
          case 197:
          case 198:
          case 199:
          case 203:
          case 204:
          case 239:
          case 240:
          case 205:
          case 207:
          case 242:
            return ts.forEachChild(node, traverse);
        }
      }
    }
    ts.forEachReturnStatement = forEachReturnStatement;
    function forEachYieldExpression(body, visitor) {
      return traverse(body);
      function traverse(node) {
        switch (node.kind) {
          case 182:
            visitor(node);
            var operand = node.expression;
            if (operand) {
              traverse(operand);
            }
          case 215:
          case 213:
          case 216:
          case 214:
          case 212:
          case 184:
            return;
          default:
            if (isFunctionLike(node)) {
              var name_5 = node.name;
              if (name_5 && name_5.kind === 134) {
                traverse(name_5.expression);
                return;
              }
            } else if (!isTypeNode(node)) {
              ts.forEachChild(node, traverse);
            }
        }
      }
    }
    ts.forEachYieldExpression = forEachYieldExpression;
    function isVariableLike(node) {
      if (node) {
        switch (node.kind) {
          case 161:
          case 245:
          case 136:
          case 243:
          case 139:
          case 138:
          case 244:
          case 209:
            return true;
        }
      }
      return false;
    }
    ts.isVariableLike = isVariableLike;
    function isAccessor(node) {
      return node && (node.kind === 143 || node.kind === 144);
    }
    ts.isAccessor = isAccessor;
    function isClassLike(node) {
      return node && (node.kind === 212 || node.kind === 184);
    }
    ts.isClassLike = isClassLike;
    function isFunctionLike(node) {
      if (node) {
        switch (node.kind) {
          case 142:
          case 171:
          case 211:
          case 172:
          case 141:
          case 140:
          case 143:
          case 144:
          case 145:
          case 146:
          case 147:
          case 150:
          case 151:
            return true;
        }
      }
      return false;
    }
    ts.isFunctionLike = isFunctionLike;
    function introducesArgumentsExoticObject(node) {
      switch (node.kind) {
        case 141:
        case 140:
        case 142:
        case 143:
        case 144:
        case 211:
        case 171:
          return true;
      }
      return false;
    }
    ts.introducesArgumentsExoticObject = introducesArgumentsExoticObject;
    function isFunctionBlock(node) {
      return node && node.kind === 190 && isFunctionLike(node.parent);
    }
    ts.isFunctionBlock = isFunctionBlock;
    function isObjectLiteralMethod(node) {
      return node && node.kind === 141 && node.parent.kind === 163;
    }
    ts.isObjectLiteralMethod = isObjectLiteralMethod;
    function getContainingFunction(node) {
      while (true) {
        node = node.parent;
        if (!node || isFunctionLike(node)) {
          return node;
        }
      }
    }
    ts.getContainingFunction = getContainingFunction;
    function getContainingClass(node) {
      while (true) {
        node = node.parent;
        if (!node || isClassLike(node)) {
          return node;
        }
      }
    }
    ts.getContainingClass = getContainingClass;
    function getThisContainer(node, includeArrowFunctions) {
      while (true) {
        node = node.parent;
        if (!node) {
          return undefined;
        }
        switch (node.kind) {
          case 134:
            if (isClassLike(node.parent.parent)) {
              return node;
            }
            node = node.parent;
            break;
          case 137:
            if (node.parent.kind === 136 && isClassElement(node.parent.parent)) {
              node = node.parent.parent;
            } else if (isClassElement(node.parent)) {
              node = node.parent;
            }
            break;
          case 172:
            if (!includeArrowFunctions) {
              continue;
            }
          case 211:
          case 171:
          case 216:
          case 139:
          case 138:
          case 141:
          case 140:
          case 142:
          case 143:
          case 144:
          case 215:
          case 246:
            return node;
        }
      }
    }
    ts.getThisContainer = getThisContainer;
    function getSuperContainer(node, includeFunctions) {
      while (true) {
        node = node.parent;
        if (!node)
          return node;
        switch (node.kind) {
          case 134:
            if (isClassLike(node.parent.parent)) {
              return node;
            }
            node = node.parent;
            break;
          case 137:
            if (node.parent.kind === 136 && isClassElement(node.parent.parent)) {
              node = node.parent.parent;
            } else if (isClassElement(node.parent)) {
              node = node.parent;
            }
            break;
          case 211:
          case 171:
          case 172:
            if (!includeFunctions) {
              continue;
            }
          case 139:
          case 138:
          case 141:
          case 140:
          case 142:
          case 143:
          case 144:
            return node;
        }
      }
    }
    ts.getSuperContainer = getSuperContainer;
    function getEntityNameFromTypeNode(node) {
      if (node) {
        switch (node.kind) {
          case 149:
            return node.typeName;
          case 186:
            return node.expression;
          case 67:
          case 133:
            return node;
        }
      }
      return undefined;
    }
    ts.getEntityNameFromTypeNode = getEntityNameFromTypeNode;
    function getInvokedExpression(node) {
      if (node.kind === 168) {
        return node.tag;
      }
      return node.expression;
    }
    ts.getInvokedExpression = getInvokedExpression;
    function nodeCanBeDecorated(node) {
      switch (node.kind) {
        case 212:
          return true;
        case 139:
          return node.parent.kind === 212;
        case 136:
          return node.parent.body && node.parent.parent.kind === 212;
        case 143:
        case 144:
        case 141:
          return node.body && node.parent.kind === 212;
      }
      return false;
    }
    ts.nodeCanBeDecorated = nodeCanBeDecorated;
    function nodeIsDecorated(node) {
      switch (node.kind) {
        case 212:
          if (node.decorators) {
            return true;
          }
          return false;
        case 139:
        case 136:
          if (node.decorators) {
            return true;
          }
          return false;
        case 143:
          if (node.body && node.decorators) {
            return true;
          }
          return false;
        case 141:
        case 144:
          if (node.body && node.decorators) {
            return true;
          }
          return false;
      }
      return false;
    }
    ts.nodeIsDecorated = nodeIsDecorated;
    function childIsDecorated(node) {
      switch (node.kind) {
        case 212:
          return ts.forEach(node.members, nodeOrChildIsDecorated);
        case 141:
        case 144:
          return ts.forEach(node.parameters, nodeIsDecorated);
      }
      return false;
    }
    ts.childIsDecorated = childIsDecorated;
    function nodeOrChildIsDecorated(node) {
      return nodeIsDecorated(node) || childIsDecorated(node);
    }
    ts.nodeOrChildIsDecorated = nodeOrChildIsDecorated;
    function isExpression(node) {
      switch (node.kind) {
        case 95:
        case 93:
        case 91:
        case 97:
        case 82:
        case 10:
        case 162:
        case 163:
        case 164:
        case 165:
        case 166:
        case 167:
        case 168:
        case 187:
        case 169:
        case 170:
        case 171:
        case 184:
        case 172:
        case 175:
        case 173:
        case 174:
        case 177:
        case 178:
        case 179:
        case 180:
        case 183:
        case 181:
        case 11:
        case 185:
        case 231:
        case 232:
        case 182:
          return true;
        case 133:
          while (node.parent.kind === 133) {
            node = node.parent;
          }
          return node.parent.kind === 152;
        case 67:
          if (node.parent.kind === 152) {
            return true;
          }
        case 8:
        case 9:
          var parent_2 = node.parent;
          switch (parent_2.kind) {
            case 209:
            case 136:
            case 139:
            case 138:
            case 245:
            case 243:
            case 161:
              return parent_2.initializer === node;
            case 193:
            case 194:
            case 195:
            case 196:
            case 202:
            case 203:
            case 204:
            case 239:
            case 206:
            case 204:
              return parent_2.expression === node;
            case 197:
              var forStatement = parent_2;
              return (forStatement.initializer === node && forStatement.initializer.kind !== 210) || forStatement.condition === node || forStatement.incrementor === node;
            case 198:
            case 199:
              var forInStatement = parent_2;
              return (forInStatement.initializer === node && forInStatement.initializer.kind !== 210) || forInStatement.expression === node;
            case 169:
            case 187:
              return node === parent_2.expression;
            case 188:
              return node === parent_2.expression;
            case 134:
              return node === parent_2.expression;
            case 137:
            case 238:
              return true;
            case 186:
              return parent_2.expression === node && isExpressionWithTypeArgumentsInClassExtendsClause(parent_2);
            default:
              if (isExpression(parent_2)) {
                return true;
              }
          }
      }
      return false;
    }
    ts.isExpression = isExpression;
    function isInstantiatedModule(node, preserveConstEnums) {
      var moduleState = ts.getModuleInstanceState(node);
      return moduleState === 1 || (preserveConstEnums && moduleState === 2);
    }
    ts.isInstantiatedModule = isInstantiatedModule;
    function isExternalModuleImportEqualsDeclaration(node) {
      return node.kind === 219 && node.moduleReference.kind === 230;
    }
    ts.isExternalModuleImportEqualsDeclaration = isExternalModuleImportEqualsDeclaration;
    function getExternalModuleImportEqualsDeclarationExpression(node) {
      ts.Debug.assert(isExternalModuleImportEqualsDeclaration(node));
      return node.moduleReference.expression;
    }
    ts.getExternalModuleImportEqualsDeclarationExpression = getExternalModuleImportEqualsDeclarationExpression;
    function isInternalModuleImportEqualsDeclaration(node) {
      return node.kind === 219 && node.moduleReference.kind !== 230;
    }
    ts.isInternalModuleImportEqualsDeclaration = isInternalModuleImportEqualsDeclaration;
    function getExternalModuleName(node) {
      if (node.kind === 220) {
        return node.moduleSpecifier;
      }
      if (node.kind === 219) {
        var reference = node.moduleReference;
        if (reference.kind === 230) {
          return reference.expression;
        }
      }
      if (node.kind === 226) {
        return node.moduleSpecifier;
      }
    }
    ts.getExternalModuleName = getExternalModuleName;
    function hasQuestionToken(node) {
      if (node) {
        switch (node.kind) {
          case 136:
          case 141:
          case 140:
          case 244:
          case 243:
          case 139:
          case 138:
            return node.questionToken !== undefined;
        }
      }
      return false;
    }
    ts.hasQuestionToken = hasQuestionToken;
    function isJSDocConstructSignature(node) {
      return node.kind === 259 && node.parameters.length > 0 && node.parameters[0].type.kind === 261;
    }
    ts.isJSDocConstructSignature = isJSDocConstructSignature;
    function getJSDocTag(node, kind) {
      if (node && node.jsDocComment) {
        for (var _i = 0,
            _a = node.jsDocComment.tags; _i < _a.length; _i++) {
          var tag = _a[_i];
          if (tag.kind === kind) {
            return tag;
          }
        }
      }
    }
    function getJSDocTypeTag(node) {
      return getJSDocTag(node, 267);
    }
    ts.getJSDocTypeTag = getJSDocTypeTag;
    function getJSDocReturnTag(node) {
      return getJSDocTag(node, 266);
    }
    ts.getJSDocReturnTag = getJSDocReturnTag;
    function getJSDocTemplateTag(node) {
      return getJSDocTag(node, 268);
    }
    ts.getJSDocTemplateTag = getJSDocTemplateTag;
    function getCorrespondingJSDocParameterTag(parameter) {
      if (parameter.name && parameter.name.kind === 67) {
        var parameterName = parameter.name.text;
        var docComment = parameter.parent.jsDocComment;
        if (docComment) {
          return ts.forEach(docComment.tags, function(t) {
            if (t.kind === 265) {
              var parameterTag = t;
              var name_6 = parameterTag.preParameterName || parameterTag.postParameterName;
              if (name_6.text === parameterName) {
                return t;
              }
            }
          });
        }
      }
    }
    ts.getCorrespondingJSDocParameterTag = getCorrespondingJSDocParameterTag;
    function hasRestParameter(s) {
      return isRestParameter(ts.lastOrUndefined(s.parameters));
    }
    ts.hasRestParameter = hasRestParameter;
    function isRestParameter(node) {
      if (node) {
        if (node.parserContextFlags & 32) {
          if (node.type && node.type.kind === 260) {
            return true;
          }
          var paramTag = getCorrespondingJSDocParameterTag(node);
          if (paramTag && paramTag.typeExpression) {
            return paramTag.typeExpression.type.kind === 260;
          }
        }
        return node.dotDotDotToken !== undefined;
      }
      return false;
    }
    ts.isRestParameter = isRestParameter;
    function isLiteralKind(kind) {
      return 8 <= kind && kind <= 11;
    }
    ts.isLiteralKind = isLiteralKind;
    function isTextualLiteralKind(kind) {
      return kind === 9 || kind === 11;
    }
    ts.isTextualLiteralKind = isTextualLiteralKind;
    function isTemplateLiteralKind(kind) {
      return 11 <= kind && kind <= 14;
    }
    ts.isTemplateLiteralKind = isTemplateLiteralKind;
    function isBindingPattern(node) {
      return !!node && (node.kind === 160 || node.kind === 159);
    }
    ts.isBindingPattern = isBindingPattern;
    function isInAmbientContext(node) {
      while (node) {
        if (node.flags & (2 | 8192)) {
          return true;
        }
        node = node.parent;
      }
      return false;
    }
    ts.isInAmbientContext = isInAmbientContext;
    function isDeclaration(node) {
      switch (node.kind) {
        case 172:
        case 161:
        case 212:
        case 184:
        case 142:
        case 215:
        case 245:
        case 228:
        case 211:
        case 171:
        case 143:
        case 221:
        case 219:
        case 224:
        case 213:
        case 141:
        case 140:
        case 216:
        case 222:
        case 136:
        case 243:
        case 139:
        case 138:
        case 144:
        case 244:
        case 214:
        case 135:
        case 209:
          return true;
      }
      return false;
    }
    ts.isDeclaration = isDeclaration;
    function isStatement(n) {
      switch (n.kind) {
        case 201:
        case 200:
        case 208:
        case 195:
        case 193:
        case 192:
        case 198:
        case 199:
        case 197:
        case 194:
        case 205:
        case 202:
        case 204:
        case 96:
        case 207:
        case 191:
        case 196:
        case 203:
        case 225:
          return true;
        default:
          return false;
      }
    }
    ts.isStatement = isStatement;
    function isClassElement(n) {
      switch (n.kind) {
        case 142:
        case 139:
        case 141:
        case 143:
        case 144:
        case 140:
        case 147:
          return true;
        default:
          return false;
      }
    }
    ts.isClassElement = isClassElement;
    function isDeclarationName(name) {
      if (name.kind !== 67 && name.kind !== 9 && name.kind !== 8) {
        return false;
      }
      var parent = name.parent;
      if (parent.kind === 224 || parent.kind === 228) {
        if (parent.propertyName) {
          return true;
        }
      }
      if (isDeclaration(parent)) {
        return parent.name === name;
      }
      return false;
    }
    ts.isDeclarationName = isDeclarationName;
    function isIdentifierName(node) {
      var parent = node.parent;
      switch (parent.kind) {
        case 139:
        case 138:
        case 141:
        case 140:
        case 143:
        case 144:
        case 245:
        case 243:
        case 164:
          return parent.name === node;
        case 133:
          if (parent.right === node) {
            while (parent.kind === 133) {
              parent = parent.parent;
            }
            return parent.kind === 152;
          }
          return false;
        case 161:
        case 224:
          return parent.propertyName === node;
        case 228:
          return true;
      }
      return false;
    }
    ts.isIdentifierName = isIdentifierName;
    function isAliasSymbolDeclaration(node) {
      return node.kind === 219 || node.kind === 221 && !!node.name || node.kind === 222 || node.kind === 224 || node.kind === 228 || node.kind === 225 && node.expression.kind === 67;
    }
    ts.isAliasSymbolDeclaration = isAliasSymbolDeclaration;
    function getClassExtendsHeritageClauseElement(node) {
      var heritageClause = getHeritageClause(node.heritageClauses, 81);
      return heritageClause && heritageClause.types.length > 0 ? heritageClause.types[0] : undefined;
    }
    ts.getClassExtendsHeritageClauseElement = getClassExtendsHeritageClauseElement;
    function getClassImplementsHeritageClauseElements(node) {
      var heritageClause = getHeritageClause(node.heritageClauses, 104);
      return heritageClause ? heritageClause.types : undefined;
    }
    ts.getClassImplementsHeritageClauseElements = getClassImplementsHeritageClauseElements;
    function getInterfaceBaseTypeNodes(node) {
      var heritageClause = getHeritageClause(node.heritageClauses, 81);
      return heritageClause ? heritageClause.types : undefined;
    }
    ts.getInterfaceBaseTypeNodes = getInterfaceBaseTypeNodes;
    function getHeritageClause(clauses, kind) {
      if (clauses) {
        for (var _i = 0; _i < clauses.length; _i++) {
          var clause = clauses[_i];
          if (clause.token === kind) {
            return clause;
          }
        }
      }
      return undefined;
    }
    ts.getHeritageClause = getHeritageClause;
    function tryResolveScriptReference(host, sourceFile, reference) {
      if (!host.getCompilerOptions().noResolve) {
        var referenceFileName = ts.isRootedDiskPath(reference.fileName) ? reference.fileName : ts.combinePaths(ts.getDirectoryPath(sourceFile.fileName), reference.fileName);
        referenceFileName = ts.getNormalizedAbsolutePath(referenceFileName, host.getCurrentDirectory());
        return host.getSourceFile(referenceFileName);
      }
    }
    ts.tryResolveScriptReference = tryResolveScriptReference;
    function getAncestor(node, kind) {
      while (node) {
        if (node.kind === kind) {
          return node;
        }
        node = node.parent;
      }
      return undefined;
    }
    ts.getAncestor = getAncestor;
    function getFileReferenceFromReferencePath(comment, commentRange) {
      var simpleReferenceRegEx = /^\/\/\/\s*<reference\s+/gim;
      var isNoDefaultLibRegEx = /^(\/\/\/\s*<reference\s+no-default-lib\s*=\s*)('|")(.+?)\2\s*\/>/gim;
      if (simpleReferenceRegEx.exec(comment)) {
        if (isNoDefaultLibRegEx.exec(comment)) {
          return {isNoDefaultLib: true};
        } else {
          var matchResult = ts.fullTripleSlashReferencePathRegEx.exec(comment);
          if (matchResult) {
            var start = commentRange.pos;
            var end = commentRange.end;
            return {
              fileReference: {
                pos: start,
                end: end,
                fileName: matchResult[3]
              },
              isNoDefaultLib: false
            };
          } else {
            return {
              diagnosticMessage: ts.Diagnostics.Invalid_reference_directive_syntax,
              isNoDefaultLib: false
            };
          }
        }
      }
      return undefined;
    }
    ts.getFileReferenceFromReferencePath = getFileReferenceFromReferencePath;
    function isKeyword(token) {
      return 68 <= token && token <= 132;
    }
    ts.isKeyword = isKeyword;
    function isTrivia(token) {
      return 2 <= token && token <= 7;
    }
    ts.isTrivia = isTrivia;
    function isAsyncFunctionLike(node) {
      return isFunctionLike(node) && (node.flags & 512) !== 0 && !isAccessor(node);
    }
    ts.isAsyncFunctionLike = isAsyncFunctionLike;
    function hasDynamicName(declaration) {
      return declaration.name && declaration.name.kind === 134 && !isWellKnownSymbolSyntactically(declaration.name.expression);
    }
    ts.hasDynamicName = hasDynamicName;
    function isWellKnownSymbolSyntactically(node) {
      return node.kind === 164 && isESSymbolIdentifier(node.expression);
    }
    ts.isWellKnownSymbolSyntactically = isWellKnownSymbolSyntactically;
    function getPropertyNameForPropertyNameNode(name) {
      if (name.kind === 67 || name.kind === 9 || name.kind === 8) {
        return name.text;
      }
      if (name.kind === 134) {
        var nameExpression = name.expression;
        if (isWellKnownSymbolSyntactically(nameExpression)) {
          var rightHandSideName = nameExpression.name.text;
          return getPropertyNameForKnownSymbolName(rightHandSideName);
        }
      }
      return undefined;
    }
    ts.getPropertyNameForPropertyNameNode = getPropertyNameForPropertyNameNode;
    function getPropertyNameForKnownSymbolName(symbolName) {
      return "__@" + symbolName;
    }
    ts.getPropertyNameForKnownSymbolName = getPropertyNameForKnownSymbolName;
    function isESSymbolIdentifier(node) {
      return node.kind === 67 && node.text === "Symbol";
    }
    ts.isESSymbolIdentifier = isESSymbolIdentifier;
    function isModifier(token) {
      switch (token) {
        case 113:
        case 116:
        case 72:
        case 120:
        case 75:
        case 80:
        case 110:
        case 108:
        case 109:
        case 111:
          return true;
      }
      return false;
    }
    ts.isModifier = isModifier;
    function isParameterDeclaration(node) {
      var root = getRootDeclaration(node);
      return root.kind === 136;
    }
    ts.isParameterDeclaration = isParameterDeclaration;
    function getRootDeclaration(node) {
      while (node.kind === 161) {
        node = node.parent.parent;
      }
      return node;
    }
    ts.getRootDeclaration = getRootDeclaration;
    function nodeStartsNewLexicalEnvironment(n) {
      return isFunctionLike(n) || n.kind === 216 || n.kind === 246;
    }
    ts.nodeStartsNewLexicalEnvironment = nodeStartsNewLexicalEnvironment;
    function cloneEntityName(node) {
      if (node.kind === 67) {
        var clone_1 = createSynthesizedNode(67);
        clone_1.text = node.text;
        return clone_1;
      } else {
        var clone_2 = createSynthesizedNode(133);
        clone_2.left = cloneEntityName(node.left);
        clone_2.left.parent = clone_2;
        clone_2.right = cloneEntityName(node.right);
        clone_2.right.parent = clone_2;
        return clone_2;
      }
    }
    ts.cloneEntityName = cloneEntityName;
    function nodeIsSynthesized(node) {
      return node.pos === -1;
    }
    ts.nodeIsSynthesized = nodeIsSynthesized;
    function createSynthesizedNode(kind, startsOnNewLine) {
      var node = ts.createNode(kind);
      node.startsOnNewLine = startsOnNewLine;
      return node;
    }
    ts.createSynthesizedNode = createSynthesizedNode;
    function createSynthesizedNodeArray() {
      var array = [];
      array.pos = -1;
      array.end = -1;
      return array;
    }
    ts.createSynthesizedNodeArray = createSynthesizedNodeArray;
    function createDiagnosticCollection() {
      var nonFileDiagnostics = [];
      var fileDiagnostics = {};
      var diagnosticsModified = false;
      var modificationCount = 0;
      return {
        add: add,
        getGlobalDiagnostics: getGlobalDiagnostics,
        getDiagnostics: getDiagnostics,
        getModificationCount: getModificationCount,
        reattachFileDiagnostics: reattachFileDiagnostics
      };
      function getModificationCount() {
        return modificationCount;
      }
      function reattachFileDiagnostics(newFile) {
        if (!ts.hasProperty(fileDiagnostics, newFile.fileName)) {
          return;
        }
        for (var _i = 0,
            _a = fileDiagnostics[newFile.fileName]; _i < _a.length; _i++) {
          var diagnostic = _a[_i];
          diagnostic.file = newFile;
        }
      }
      function add(diagnostic) {
        var diagnostics;
        if (diagnostic.file) {
          diagnostics = fileDiagnostics[diagnostic.file.fileName];
          if (!diagnostics) {
            diagnostics = [];
            fileDiagnostics[diagnostic.file.fileName] = diagnostics;
          }
        } else {
          diagnostics = nonFileDiagnostics;
        }
        diagnostics.push(diagnostic);
        diagnosticsModified = true;
        modificationCount++;
      }
      function getGlobalDiagnostics() {
        sortAndDeduplicate();
        return nonFileDiagnostics;
      }
      function getDiagnostics(fileName) {
        sortAndDeduplicate();
        if (fileName) {
          return fileDiagnostics[fileName] || [];
        }
        var allDiagnostics = [];
        function pushDiagnostic(d) {
          allDiagnostics.push(d);
        }
        ts.forEach(nonFileDiagnostics, pushDiagnostic);
        for (var key in fileDiagnostics) {
          if (ts.hasProperty(fileDiagnostics, key)) {
            ts.forEach(fileDiagnostics[key], pushDiagnostic);
          }
        }
        return ts.sortAndDeduplicateDiagnostics(allDiagnostics);
      }
      function sortAndDeduplicate() {
        if (!diagnosticsModified) {
          return;
        }
        diagnosticsModified = false;
        nonFileDiagnostics = ts.sortAndDeduplicateDiagnostics(nonFileDiagnostics);
        for (var key in fileDiagnostics) {
          if (ts.hasProperty(fileDiagnostics, key)) {
            fileDiagnostics[key] = ts.sortAndDeduplicateDiagnostics(fileDiagnostics[key]);
          }
        }
      }
    }
    ts.createDiagnosticCollection = createDiagnosticCollection;
    var escapedCharsRegExp = /[\\\"\u0000-\u001f\t\v\f\b\r\n\u2028\u2029\u0085]/g;
    var escapedCharsMap = {
      "\0": "\\0",
      "\t": "\\t",
      "\v": "\\v",
      "\f": "\\f",
      "\b": "\\b",
      "\r": "\\r",
      "\n": "\\n",
      "\\": "\\\\",
      "\"": "\\\"",
      "\u2028": "\\u2028",
      "\u2029": "\\u2029",
      "\u0085": "\\u0085"
    };
    function escapeString(s) {
      s = escapedCharsRegExp.test(s) ? s.replace(escapedCharsRegExp, getReplacement) : s;
      return s;
      function getReplacement(c) {
        return escapedCharsMap[c] || get16BitUnicodeEscapeSequence(c.charCodeAt(0));
      }
    }
    ts.escapeString = escapeString;
    function isIntrinsicJsxName(name) {
      var ch = name.substr(0, 1);
      return ch.toLowerCase() === ch;
    }
    ts.isIntrinsicJsxName = isIntrinsicJsxName;
    function get16BitUnicodeEscapeSequence(charCode) {
      var hexCharCode = charCode.toString(16).toUpperCase();
      var paddedHexCode = ("0000" + hexCharCode).slice(-4);
      return "\\u" + paddedHexCode;
    }
    var nonAsciiCharacters = /[^\u0000-\u007F]/g;
    function escapeNonAsciiCharacters(s) {
      return nonAsciiCharacters.test(s) ? s.replace(nonAsciiCharacters, function(c) {
        return get16BitUnicodeEscapeSequence(c.charCodeAt(0));
      }) : s;
    }
    ts.escapeNonAsciiCharacters = escapeNonAsciiCharacters;
    var indentStrings = ["", "    "];
    function getIndentString(level) {
      if (indentStrings[level] === undefined) {
        indentStrings[level] = getIndentString(level - 1) + indentStrings[1];
      }
      return indentStrings[level];
    }
    ts.getIndentString = getIndentString;
    function getIndentSize() {
      return indentStrings[1].length;
    }
    ts.getIndentSize = getIndentSize;
    function createTextWriter(newLine) {
      var output = "";
      var indent = 0;
      var lineStart = true;
      var lineCount = 0;
      var linePos = 0;
      function write(s) {
        if (s && s.length) {
          if (lineStart) {
            output += getIndentString(indent);
            lineStart = false;
          }
          output += s;
        }
      }
      function rawWrite(s) {
        if (s !== undefined) {
          if (lineStart) {
            lineStart = false;
          }
          output += s;
        }
      }
      function writeLiteral(s) {
        if (s && s.length) {
          write(s);
          var lineStartsOfS = ts.computeLineStarts(s);
          if (lineStartsOfS.length > 1) {
            lineCount = lineCount + lineStartsOfS.length - 1;
            linePos = output.length - s.length + ts.lastOrUndefined(lineStartsOfS);
          }
        }
      }
      function writeLine() {
        if (!lineStart) {
          output += newLine;
          lineCount++;
          linePos = output.length;
          lineStart = true;
        }
      }
      function writeTextOfNode(sourceFile, node) {
        write(getSourceTextOfNodeFromSourceFile(sourceFile, node));
      }
      return {
        write: write,
        rawWrite: rawWrite,
        writeTextOfNode: writeTextOfNode,
        writeLiteral: writeLiteral,
        writeLine: writeLine,
        increaseIndent: function() {
          return indent++;
        },
        decreaseIndent: function() {
          return indent--;
        },
        getIndent: function() {
          return indent;
        },
        getTextPos: function() {
          return output.length;
        },
        getLine: function() {
          return lineCount + 1;
        },
        getColumn: function() {
          return lineStart ? indent * getIndentSize() + 1 : output.length - linePos + 1;
        },
        getText: function() {
          return output;
        }
      };
    }
    ts.createTextWriter = createTextWriter;
    function getOwnEmitOutputFilePath(sourceFile, host, extension) {
      var compilerOptions = host.getCompilerOptions();
      var emitOutputFilePathWithoutExtension;
      if (compilerOptions.outDir) {
        emitOutputFilePathWithoutExtension = ts.removeFileExtension(getSourceFilePathInNewDir(sourceFile, host, compilerOptions.outDir));
      } else {
        emitOutputFilePathWithoutExtension = ts.removeFileExtension(sourceFile.fileName);
      }
      return emitOutputFilePathWithoutExtension + extension;
    }
    ts.getOwnEmitOutputFilePath = getOwnEmitOutputFilePath;
    function getSourceFilePathInNewDir(sourceFile, host, newDirPath) {
      var sourceFilePath = ts.getNormalizedAbsolutePath(sourceFile.fileName, host.getCurrentDirectory());
      sourceFilePath = sourceFilePath.replace(host.getCommonSourceDirectory(), "");
      return ts.combinePaths(newDirPath, sourceFilePath);
    }
    ts.getSourceFilePathInNewDir = getSourceFilePathInNewDir;
    function writeFile(host, diagnostics, fileName, data, writeByteOrderMark) {
      host.writeFile(fileName, data, writeByteOrderMark, function(hostErrorMessage) {
        diagnostics.push(ts.createCompilerDiagnostic(ts.Diagnostics.Could_not_write_file_0_Colon_1, fileName, hostErrorMessage));
      });
    }
    ts.writeFile = writeFile;
    function getLineOfLocalPosition(currentSourceFile, pos) {
      return ts.getLineAndCharacterOfPosition(currentSourceFile, pos).line;
    }
    ts.getLineOfLocalPosition = getLineOfLocalPosition;
    function getFirstConstructorWithBody(node) {
      return ts.forEach(node.members, function(member) {
        if (member.kind === 142 && nodeIsPresent(member.body)) {
          return member;
        }
      });
    }
    ts.getFirstConstructorWithBody = getFirstConstructorWithBody;
    function getSetAccessorTypeAnnotationNode(accessor) {
      return accessor && accessor.parameters.length > 0 && accessor.parameters[0].type;
    }
    ts.getSetAccessorTypeAnnotationNode = getSetAccessorTypeAnnotationNode;
    function shouldEmitToOwnFile(sourceFile, compilerOptions) {
      if (!isDeclarationFile(sourceFile)) {
        if ((isExternalModule(sourceFile) || !(compilerOptions.outFile || compilerOptions.out))) {
          return compilerOptions.isolatedModules || !ts.fileExtensionIs(sourceFile.fileName, ".js");
        }
        return false;
      }
      return false;
    }
    ts.shouldEmitToOwnFile = shouldEmitToOwnFile;
    function getAllAccessorDeclarations(declarations, accessor) {
      var firstAccessor;
      var secondAccessor;
      var getAccessor;
      var setAccessor;
      if (hasDynamicName(accessor)) {
        firstAccessor = accessor;
        if (accessor.kind === 143) {
          getAccessor = accessor;
        } else if (accessor.kind === 144) {
          setAccessor = accessor;
        } else {
          ts.Debug.fail("Accessor has wrong kind");
        }
      } else {
        ts.forEach(declarations, function(member) {
          if ((member.kind === 143 || member.kind === 144) && (member.flags & 128) === (accessor.flags & 128)) {
            var memberName = getPropertyNameForPropertyNameNode(member.name);
            var accessorName = getPropertyNameForPropertyNameNode(accessor.name);
            if (memberName === accessorName) {
              if (!firstAccessor) {
                firstAccessor = member;
              } else if (!secondAccessor) {
                secondAccessor = member;
              }
              if (member.kind === 143 && !getAccessor) {
                getAccessor = member;
              }
              if (member.kind === 144 && !setAccessor) {
                setAccessor = member;
              }
            }
          }
        });
      }
      return {
        firstAccessor: firstAccessor,
        secondAccessor: secondAccessor,
        getAccessor: getAccessor,
        setAccessor: setAccessor
      };
    }
    ts.getAllAccessorDeclarations = getAllAccessorDeclarations;
    function emitNewLineBeforeLeadingComments(currentSourceFile, writer, node, leadingComments) {
      if (leadingComments && leadingComments.length && node.pos !== leadingComments[0].pos && getLineOfLocalPosition(currentSourceFile, node.pos) !== getLineOfLocalPosition(currentSourceFile, leadingComments[0].pos)) {
        writer.writeLine();
      }
    }
    ts.emitNewLineBeforeLeadingComments = emitNewLineBeforeLeadingComments;
    function emitComments(currentSourceFile, writer, comments, trailingSeparator, newLine, writeComment) {
      var emitLeadingSpace = !trailingSeparator;
      ts.forEach(comments, function(comment) {
        if (emitLeadingSpace) {
          writer.write(" ");
          emitLeadingSpace = false;
        }
        writeComment(currentSourceFile, writer, comment, newLine);
        if (comment.hasTrailingNewLine) {
          writer.writeLine();
        } else if (trailingSeparator) {
          writer.write(" ");
        } else {
          emitLeadingSpace = true;
        }
      });
    }
    ts.emitComments = emitComments;
    function writeCommentRange(currentSourceFile, writer, comment, newLine) {
      if (currentSourceFile.text.charCodeAt(comment.pos + 1) === 42) {
        var firstCommentLineAndCharacter = ts.getLineAndCharacterOfPosition(currentSourceFile, comment.pos);
        var lineCount = ts.getLineStarts(currentSourceFile).length;
        var firstCommentLineIndent;
        for (var pos = comment.pos,
            currentLine = firstCommentLineAndCharacter.line; pos < comment.end; currentLine++) {
          var nextLineStart = (currentLine + 1) === lineCount ? currentSourceFile.text.length + 1 : getStartPositionOfLine(currentLine + 1, currentSourceFile);
          if (pos !== comment.pos) {
            if (firstCommentLineIndent === undefined) {
              firstCommentLineIndent = calculateIndent(getStartPositionOfLine(firstCommentLineAndCharacter.line, currentSourceFile), comment.pos);
            }
            var currentWriterIndentSpacing = writer.getIndent() * getIndentSize();
            var spacesToEmit = currentWriterIndentSpacing - firstCommentLineIndent + calculateIndent(pos, nextLineStart);
            if (spacesToEmit > 0) {
              var numberOfSingleSpacesToEmit = spacesToEmit % getIndentSize();
              var indentSizeSpaceString = getIndentString((spacesToEmit - numberOfSingleSpacesToEmit) / getIndentSize());
              writer.rawWrite(indentSizeSpaceString);
              while (numberOfSingleSpacesToEmit) {
                writer.rawWrite(" ");
                numberOfSingleSpacesToEmit--;
              }
            } else {
              writer.rawWrite("");
            }
          }
          writeTrimmedCurrentLine(pos, nextLineStart);
          pos = nextLineStart;
        }
      } else {
        writer.write(currentSourceFile.text.substring(comment.pos, comment.end));
      }
      function writeTrimmedCurrentLine(pos, nextLineStart) {
        var end = Math.min(comment.end, nextLineStart - 1);
        var currentLineText = currentSourceFile.text.substring(pos, end).replace(/^\s+|\s+$/g, "");
        if (currentLineText) {
          writer.write(currentLineText);
          if (end !== comment.end) {
            writer.writeLine();
          }
        } else {
          writer.writeLiteral(newLine);
        }
      }
      function calculateIndent(pos, end) {
        var currentLineIndent = 0;
        for (; pos < end && ts.isWhiteSpace(currentSourceFile.text.charCodeAt(pos)); pos++) {
          if (currentSourceFile.text.charCodeAt(pos) === 9) {
            currentLineIndent += getIndentSize() - (currentLineIndent % getIndentSize());
          } else {
            currentLineIndent++;
          }
        }
        return currentLineIndent;
      }
    }
    ts.writeCommentRange = writeCommentRange;
    function modifierToFlag(token) {
      switch (token) {
        case 111:
          return 128;
        case 110:
          return 16;
        case 109:
          return 64;
        case 108:
          return 32;
        case 113:
          return 256;
        case 80:
          return 1;
        case 120:
          return 2;
        case 72:
          return 32768;
        case 75:
          return 1024;
        case 116:
          return 512;
      }
      return 0;
    }
    ts.modifierToFlag = modifierToFlag;
    function isLeftHandSideExpression(expr) {
      if (expr) {
        switch (expr.kind) {
          case 164:
          case 165:
          case 167:
          case 166:
          case 231:
          case 232:
          case 168:
          case 162:
          case 170:
          case 163:
          case 184:
          case 171:
          case 67:
          case 10:
          case 8:
          case 9:
          case 11:
          case 181:
          case 82:
          case 91:
          case 95:
          case 97:
          case 93:
            return true;
        }
      }
      return false;
    }
    ts.isLeftHandSideExpression = isLeftHandSideExpression;
    function isAssignmentOperator(token) {
      return token >= 55 && token <= 66;
    }
    ts.isAssignmentOperator = isAssignmentOperator;
    function isExpressionWithTypeArgumentsInClassExtendsClause(node) {
      return node.kind === 186 && node.parent.token === 81 && isClassLike(node.parent.parent);
    }
    ts.isExpressionWithTypeArgumentsInClassExtendsClause = isExpressionWithTypeArgumentsInClassExtendsClause;
    function isSupportedExpressionWithTypeArguments(node) {
      return isSupportedExpressionWithTypeArgumentsRest(node.expression);
    }
    ts.isSupportedExpressionWithTypeArguments = isSupportedExpressionWithTypeArguments;
    function isSupportedExpressionWithTypeArgumentsRest(node) {
      if (node.kind === 67) {
        return true;
      } else if (node.kind === 164) {
        return isSupportedExpressionWithTypeArgumentsRest(node.expression);
      } else {
        return false;
      }
    }
    function isRightSideOfQualifiedNameOrPropertyAccess(node) {
      return (node.parent.kind === 133 && node.parent.right === node) || (node.parent.kind === 164 && node.parent.name === node);
    }
    ts.isRightSideOfQualifiedNameOrPropertyAccess = isRightSideOfQualifiedNameOrPropertyAccess;
    function isEmptyObjectLiteralOrArrayLiteral(expression) {
      var kind = expression.kind;
      if (kind === 163) {
        return expression.properties.length === 0;
      }
      if (kind === 162) {
        return expression.elements.length === 0;
      }
      return false;
    }
    ts.isEmptyObjectLiteralOrArrayLiteral = isEmptyObjectLiteralOrArrayLiteral;
    function getLocalSymbolForExportDefault(symbol) {
      return symbol && symbol.valueDeclaration && (symbol.valueDeclaration.flags & 1024) ? symbol.valueDeclaration.localSymbol : undefined;
    }
    ts.getLocalSymbolForExportDefault = getLocalSymbolForExportDefault;
    function isJavaScript(fileName) {
      return ts.fileExtensionIs(fileName, ".js");
    }
    ts.isJavaScript = isJavaScript;
    function isTsx(fileName) {
      return ts.fileExtensionIs(fileName, ".tsx");
    }
    ts.isTsx = isTsx;
    function getExpandedCharCodes(input) {
      var output = [];
      var length = input.length;
      for (var i = 0; i < length; i++) {
        var charCode = input.charCodeAt(i);
        if (charCode < 0x80) {
          output.push(charCode);
        } else if (charCode < 0x800) {
          output.push((charCode >> 6) | 192);
          output.push((charCode & 63) | 128);
        } else if (charCode < 0x10000) {
          output.push((charCode >> 12) | 224);
          output.push(((charCode >> 6) & 63) | 128);
          output.push((charCode & 63) | 128);
        } else if (charCode < 0x20000) {
          output.push((charCode >> 18) | 240);
          output.push(((charCode >> 12) & 63) | 128);
          output.push(((charCode >> 6) & 63) | 128);
          output.push((charCode & 63) | 128);
        } else {
          ts.Debug.assert(false, "Unexpected code point");
        }
      }
      return output;
    }
    var base64Digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    function convertToBase64(input) {
      var result = "";
      var charCodes = getExpandedCharCodes(input);
      var i = 0;
      var length = charCodes.length;
      var byte1,
          byte2,
          byte3,
          byte4;
      while (i < length) {
        byte1 = charCodes[i] >> 2;
        byte2 = (charCodes[i] & 3) << 4 | charCodes[i + 1] >> 4;
        byte3 = (charCodes[i + 1] & 15) << 2 | charCodes[i + 2] >> 6;
        byte4 = charCodes[i + 2] & 63;
        if (i + 1 >= length) {
          byte3 = byte4 = 64;
        } else if (i + 2 >= length) {
          byte4 = 64;
        }
        result += base64Digits.charAt(byte1) + base64Digits.charAt(byte2) + base64Digits.charAt(byte3) + base64Digits.charAt(byte4);
        i += 3;
      }
      return result;
    }
    ts.convertToBase64 = convertToBase64;
    var carriageReturnLineFeed = "\r\n";
    var lineFeed = "\n";
    function getNewLineCharacter(options) {
      if (options.newLine === 0) {
        return carriageReturnLineFeed;
      } else if (options.newLine === 1) {
        return lineFeed;
      } else if (ts.sys) {
        return ts.sys.newLine;
      }
      return carriageReturnLineFeed;
    }
    ts.getNewLineCharacter = getNewLineCharacter;
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    function getDefaultLibFileName(options) {
      return options.target === 2 ? "lib.es6.d.ts" : "lib.d.ts";
    }
    ts.getDefaultLibFileName = getDefaultLibFileName;
    function textSpanEnd(span) {
      return span.start + span.length;
    }
    ts.textSpanEnd = textSpanEnd;
    function textSpanIsEmpty(span) {
      return span.length === 0;
    }
    ts.textSpanIsEmpty = textSpanIsEmpty;
    function textSpanContainsPosition(span, position) {
      return position >= span.start && position < textSpanEnd(span);
    }
    ts.textSpanContainsPosition = textSpanContainsPosition;
    function textSpanContainsTextSpan(span, other) {
      return other.start >= span.start && textSpanEnd(other) <= textSpanEnd(span);
    }
    ts.textSpanContainsTextSpan = textSpanContainsTextSpan;
    function textSpanOverlapsWith(span, other) {
      var overlapStart = Math.max(span.start, other.start);
      var overlapEnd = Math.min(textSpanEnd(span), textSpanEnd(other));
      return overlapStart < overlapEnd;
    }
    ts.textSpanOverlapsWith = textSpanOverlapsWith;
    function textSpanOverlap(span1, span2) {
      var overlapStart = Math.max(span1.start, span2.start);
      var overlapEnd = Math.min(textSpanEnd(span1), textSpanEnd(span2));
      if (overlapStart < overlapEnd) {
        return createTextSpanFromBounds(overlapStart, overlapEnd);
      }
      return undefined;
    }
    ts.textSpanOverlap = textSpanOverlap;
    function textSpanIntersectsWithTextSpan(span, other) {
      return other.start <= textSpanEnd(span) && textSpanEnd(other) >= span.start;
    }
    ts.textSpanIntersectsWithTextSpan = textSpanIntersectsWithTextSpan;
    function textSpanIntersectsWith(span, start, length) {
      var end = start + length;
      return start <= textSpanEnd(span) && end >= span.start;
    }
    ts.textSpanIntersectsWith = textSpanIntersectsWith;
    function decodedTextSpanIntersectsWith(start1, length1, start2, length2) {
      var end1 = start1 + length1;
      var end2 = start2 + length2;
      return start2 <= end1 && end2 >= start1;
    }
    ts.decodedTextSpanIntersectsWith = decodedTextSpanIntersectsWith;
    function textSpanIntersectsWithPosition(span, position) {
      return position <= textSpanEnd(span) && position >= span.start;
    }
    ts.textSpanIntersectsWithPosition = textSpanIntersectsWithPosition;
    function textSpanIntersection(span1, span2) {
      var intersectStart = Math.max(span1.start, span2.start);
      var intersectEnd = Math.min(textSpanEnd(span1), textSpanEnd(span2));
      if (intersectStart <= intersectEnd) {
        return createTextSpanFromBounds(intersectStart, intersectEnd);
      }
      return undefined;
    }
    ts.textSpanIntersection = textSpanIntersection;
    function createTextSpan(start, length) {
      if (start < 0) {
        throw new Error("start < 0");
      }
      if (length < 0) {
        throw new Error("length < 0");
      }
      return {
        start: start,
        length: length
      };
    }
    ts.createTextSpan = createTextSpan;
    function createTextSpanFromBounds(start, end) {
      return createTextSpan(start, end - start);
    }
    ts.createTextSpanFromBounds = createTextSpanFromBounds;
    function textChangeRangeNewSpan(range) {
      return createTextSpan(range.span.start, range.newLength);
    }
    ts.textChangeRangeNewSpan = textChangeRangeNewSpan;
    function textChangeRangeIsUnchanged(range) {
      return textSpanIsEmpty(range.span) && range.newLength === 0;
    }
    ts.textChangeRangeIsUnchanged = textChangeRangeIsUnchanged;
    function createTextChangeRange(span, newLength) {
      if (newLength < 0) {
        throw new Error("newLength < 0");
      }
      return {
        span: span,
        newLength: newLength
      };
    }
    ts.createTextChangeRange = createTextChangeRange;
    ts.unchangedTextChangeRange = createTextChangeRange(createTextSpan(0, 0), 0);
    function collapseTextChangeRangesAcrossMultipleVersions(changes) {
      if (changes.length === 0) {
        return ts.unchangedTextChangeRange;
      }
      if (changes.length === 1) {
        return changes[0];
      }
      var change0 = changes[0];
      var oldStartN = change0.span.start;
      var oldEndN = textSpanEnd(change0.span);
      var newEndN = oldStartN + change0.newLength;
      for (var i = 1; i < changes.length; i++) {
        var nextChange = changes[i];
        var oldStart1 = oldStartN;
        var oldEnd1 = oldEndN;
        var newEnd1 = newEndN;
        var oldStart2 = nextChange.span.start;
        var oldEnd2 = textSpanEnd(nextChange.span);
        var newEnd2 = oldStart2 + nextChange.newLength;
        oldStartN = Math.min(oldStart1, oldStart2);
        oldEndN = Math.max(oldEnd1, oldEnd1 + (oldEnd2 - newEnd1));
        newEndN = Math.max(newEnd2, newEnd2 + (newEnd1 - oldEnd2));
      }
      return createTextChangeRange(createTextSpanFromBounds(oldStartN, oldEndN), newEndN - oldStartN);
    }
    ts.collapseTextChangeRangesAcrossMultipleVersions = collapseTextChangeRangesAcrossMultipleVersions;
    function getTypeParameterOwner(d) {
      if (d && d.kind === 135) {
        for (var current = d; current; current = current.parent) {
          if (ts.isFunctionLike(current) || ts.isClassLike(current) || current.kind === 213) {
            return current;
          }
        }
      }
    }
    ts.getTypeParameterOwner = getTypeParameterOwner;
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    var nodeConstructors = new Array(270);
    ts.parseTime = 0;
    function getNodeConstructor(kind) {
      return nodeConstructors[kind] || (nodeConstructors[kind] = ts.objectAllocator.getNodeConstructor(kind));
    }
    ts.getNodeConstructor = getNodeConstructor;
    function createNode(kind) {
      return new (getNodeConstructor(kind))();
    }
    ts.createNode = createNode;
    function visitNode(cbNode, node) {
      if (node) {
        return cbNode(node);
      }
    }
    function visitNodeArray(cbNodes, nodes) {
      if (nodes) {
        return cbNodes(nodes);
      }
    }
    function visitEachNode(cbNode, nodes) {
      if (nodes) {
        for (var _i = 0; _i < nodes.length; _i++) {
          var node = nodes[_i];
          var result = cbNode(node);
          if (result) {
            return result;
          }
        }
      }
    }
    function forEachChild(node, cbNode, cbNodeArray) {
      if (!node) {
        return;
      }
      var visitNodes = cbNodeArray ? visitNodeArray : visitEachNode;
      var cbNodes = cbNodeArray || cbNode;
      switch (node.kind) {
        case 133:
          return visitNode(cbNode, node.left) || visitNode(cbNode, node.right);
        case 135:
          return visitNode(cbNode, node.name) || visitNode(cbNode, node.constraint) || visitNode(cbNode, node.expression);
        case 136:
        case 139:
        case 138:
        case 243:
        case 244:
        case 209:
        case 161:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.propertyName) || visitNode(cbNode, node.dotDotDotToken) || visitNode(cbNode, node.name) || visitNode(cbNode, node.questionToken) || visitNode(cbNode, node.type) || visitNode(cbNode, node.initializer);
        case 150:
        case 151:
        case 145:
        case 146:
        case 147:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNodes(cbNodes, node.typeParameters) || visitNodes(cbNodes, node.parameters) || visitNode(cbNode, node.type);
        case 141:
        case 140:
        case 142:
        case 143:
        case 144:
        case 171:
        case 211:
        case 172:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.asteriskToken) || visitNode(cbNode, node.name) || visitNode(cbNode, node.questionToken) || visitNodes(cbNodes, node.typeParameters) || visitNodes(cbNodes, node.parameters) || visitNode(cbNode, node.type) || visitNode(cbNode, node.equalsGreaterThanToken) || visitNode(cbNode, node.body);
        case 149:
          return visitNode(cbNode, node.typeName) || visitNodes(cbNodes, node.typeArguments);
        case 148:
          return visitNode(cbNode, node.parameterName) || visitNode(cbNode, node.type);
        case 152:
          return visitNode(cbNode, node.exprName);
        case 153:
          return visitNodes(cbNodes, node.members);
        case 154:
          return visitNode(cbNode, node.elementType);
        case 155:
          return visitNodes(cbNodes, node.elementTypes);
        case 156:
        case 157:
          return visitNodes(cbNodes, node.types);
        case 158:
          return visitNode(cbNode, node.type);
        case 159:
        case 160:
          return visitNodes(cbNodes, node.elements);
        case 162:
          return visitNodes(cbNodes, node.elements);
        case 163:
          return visitNodes(cbNodes, node.properties);
        case 164:
          return visitNode(cbNode, node.expression) || visitNode(cbNode, node.dotToken) || visitNode(cbNode, node.name);
        case 165:
          return visitNode(cbNode, node.expression) || visitNode(cbNode, node.argumentExpression);
        case 166:
        case 167:
          return visitNode(cbNode, node.expression) || visitNodes(cbNodes, node.typeArguments) || visitNodes(cbNodes, node.arguments);
        case 168:
          return visitNode(cbNode, node.tag) || visitNode(cbNode, node.template);
        case 169:
          return visitNode(cbNode, node.type) || visitNode(cbNode, node.expression);
        case 170:
          return visitNode(cbNode, node.expression);
        case 173:
          return visitNode(cbNode, node.expression);
        case 174:
          return visitNode(cbNode, node.expression);
        case 175:
          return visitNode(cbNode, node.expression);
        case 177:
          return visitNode(cbNode, node.operand);
        case 182:
          return visitNode(cbNode, node.asteriskToken) || visitNode(cbNode, node.expression);
        case 176:
          return visitNode(cbNode, node.expression);
        case 178:
          return visitNode(cbNode, node.operand);
        case 179:
          return visitNode(cbNode, node.left) || visitNode(cbNode, node.operatorToken) || visitNode(cbNode, node.right);
        case 187:
          return visitNode(cbNode, node.expression) || visitNode(cbNode, node.type);
        case 180:
          return visitNode(cbNode, node.condition) || visitNode(cbNode, node.questionToken) || visitNode(cbNode, node.whenTrue) || visitNode(cbNode, node.colonToken) || visitNode(cbNode, node.whenFalse);
        case 183:
          return visitNode(cbNode, node.expression);
        case 190:
        case 217:
          return visitNodes(cbNodes, node.statements);
        case 246:
          return visitNodes(cbNodes, node.statements) || visitNode(cbNode, node.endOfFileToken);
        case 191:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.declarationList);
        case 210:
          return visitNodes(cbNodes, node.declarations);
        case 193:
          return visitNode(cbNode, node.expression);
        case 194:
          return visitNode(cbNode, node.expression) || visitNode(cbNode, node.thenStatement) || visitNode(cbNode, node.elseStatement);
        case 195:
          return visitNode(cbNode, node.statement) || visitNode(cbNode, node.expression);
        case 196:
          return visitNode(cbNode, node.expression) || visitNode(cbNode, node.statement);
        case 197:
          return visitNode(cbNode, node.initializer) || visitNode(cbNode, node.condition) || visitNode(cbNode, node.incrementor) || visitNode(cbNode, node.statement);
        case 198:
          return visitNode(cbNode, node.initializer) || visitNode(cbNode, node.expression) || visitNode(cbNode, node.statement);
        case 199:
          return visitNode(cbNode, node.initializer) || visitNode(cbNode, node.expression) || visitNode(cbNode, node.statement);
        case 200:
        case 201:
          return visitNode(cbNode, node.label);
        case 202:
          return visitNode(cbNode, node.expression);
        case 203:
          return visitNode(cbNode, node.expression) || visitNode(cbNode, node.statement);
        case 204:
          return visitNode(cbNode, node.expression) || visitNode(cbNode, node.caseBlock);
        case 218:
          return visitNodes(cbNodes, node.clauses);
        case 239:
          return visitNode(cbNode, node.expression) || visitNodes(cbNodes, node.statements);
        case 240:
          return visitNodes(cbNodes, node.statements);
        case 205:
          return visitNode(cbNode, node.label) || visitNode(cbNode, node.statement);
        case 206:
          return visitNode(cbNode, node.expression);
        case 207:
          return visitNode(cbNode, node.tryBlock) || visitNode(cbNode, node.catchClause) || visitNode(cbNode, node.finallyBlock);
        case 242:
          return visitNode(cbNode, node.variableDeclaration) || visitNode(cbNode, node.block);
        case 137:
          return visitNode(cbNode, node.expression);
        case 212:
        case 184:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.name) || visitNodes(cbNodes, node.typeParameters) || visitNodes(cbNodes, node.heritageClauses) || visitNodes(cbNodes, node.members);
        case 213:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.name) || visitNodes(cbNodes, node.typeParameters) || visitNodes(cbNodes, node.heritageClauses) || visitNodes(cbNodes, node.members);
        case 214:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.name) || visitNodes(cbNodes, node.typeParameters) || visitNode(cbNode, node.type);
        case 215:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.name) || visitNodes(cbNodes, node.members);
        case 245:
          return visitNode(cbNode, node.name) || visitNode(cbNode, node.initializer);
        case 216:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.name) || visitNode(cbNode, node.body);
        case 219:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.name) || visitNode(cbNode, node.moduleReference);
        case 220:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.importClause) || visitNode(cbNode, node.moduleSpecifier);
        case 221:
          return visitNode(cbNode, node.name) || visitNode(cbNode, node.namedBindings);
        case 222:
          return visitNode(cbNode, node.name);
        case 223:
        case 227:
          return visitNodes(cbNodes, node.elements);
        case 226:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.exportClause) || visitNode(cbNode, node.moduleSpecifier);
        case 224:
        case 228:
          return visitNode(cbNode, node.propertyName) || visitNode(cbNode, node.name);
        case 225:
          return visitNodes(cbNodes, node.decorators) || visitNodes(cbNodes, node.modifiers) || visitNode(cbNode, node.expression);
        case 181:
          return visitNode(cbNode, node.head) || visitNodes(cbNodes, node.templateSpans);
        case 188:
          return visitNode(cbNode, node.expression) || visitNode(cbNode, node.literal);
        case 134:
          return visitNode(cbNode, node.expression);
        case 241:
          return visitNodes(cbNodes, node.types);
        case 186:
          return visitNode(cbNode, node.expression) || visitNodes(cbNodes, node.typeArguments);
        case 230:
          return visitNode(cbNode, node.expression);
        case 229:
          return visitNodes(cbNodes, node.decorators);
        case 231:
          return visitNode(cbNode, node.openingElement) || visitNodes(cbNodes, node.children) || visitNode(cbNode, node.closingElement);
        case 232:
        case 233:
          return visitNode(cbNode, node.tagName) || visitNodes(cbNodes, node.attributes);
        case 236:
          return visitNode(cbNode, node.name) || visitNode(cbNode, node.initializer);
        case 237:
          return visitNode(cbNode, node.expression);
        case 238:
          return visitNode(cbNode, node.expression);
        case 235:
          return visitNode(cbNode, node.tagName);
        case 247:
          return visitNode(cbNode, node.type);
        case 251:
          return visitNodes(cbNodes, node.types);
        case 252:
          return visitNodes(cbNodes, node.types);
        case 250:
          return visitNode(cbNode, node.elementType);
        case 254:
          return visitNode(cbNode, node.type);
        case 253:
          return visitNode(cbNode, node.type);
        case 255:
          return visitNodes(cbNodes, node.members);
        case 257:
          return visitNode(cbNode, node.name) || visitNodes(cbNodes, node.typeArguments);
        case 258:
          return visitNode(cbNode, node.type);
        case 259:
          return visitNodes(cbNodes, node.parameters) || visitNode(cbNode, node.type);
        case 260:
          return visitNode(cbNode, node.type);
        case 261:
          return visitNode(cbNode, node.type);
        case 262:
          return visitNode(cbNode, node.type);
        case 256:
          return visitNode(cbNode, node.name) || visitNode(cbNode, node.type);
        case 263:
          return visitNodes(cbNodes, node.tags);
        case 265:
          return visitNode(cbNode, node.preParameterName) || visitNode(cbNode, node.typeExpression) || visitNode(cbNode, node.postParameterName);
        case 266:
          return visitNode(cbNode, node.typeExpression);
        case 267:
          return visitNode(cbNode, node.typeExpression);
        case 268:
          return visitNodes(cbNodes, node.typeParameters);
      }
    }
    ts.forEachChild = forEachChild;
    function createSourceFile(fileName, sourceText, languageVersion, setParentNodes) {
      if (setParentNodes === void 0) {
        setParentNodes = false;
      }
      var start = new Date().getTime();
      var result = Parser.parseSourceFile(fileName, sourceText, languageVersion, undefined, setParentNodes);
      ts.parseTime += new Date().getTime() - start;
      return result;
    }
    ts.createSourceFile = createSourceFile;
    function updateSourceFile(sourceFile, newText, textChangeRange, aggressiveChecks) {
      return IncrementalParser.updateSourceFile(sourceFile, newText, textChangeRange, aggressiveChecks);
    }
    ts.updateSourceFile = updateSourceFile;
    function parseIsolatedJSDocComment(content, start, length) {
      return Parser.JSDocParser.parseIsolatedJSDocComment(content, start, length);
    }
    ts.parseIsolatedJSDocComment = parseIsolatedJSDocComment;
    function parseJSDocTypeExpressionForTests(content, start, length) {
      return Parser.JSDocParser.parseJSDocTypeExpressionForTests(content, start, length);
    }
    ts.parseJSDocTypeExpressionForTests = parseJSDocTypeExpressionForTests;
    var Parser;
    (function(Parser) {
      var scanner = ts.createScanner(2, true);
      var disallowInAndDecoratorContext = 1 | 4;
      var sourceFile;
      var parseDiagnostics;
      var syntaxCursor;
      var token;
      var sourceText;
      var nodeCount;
      var identifiers;
      var identifierCount;
      var parsingContext;
      var contextFlags;
      var parseErrorBeforeNextFinishedNode = false;
      function parseSourceFile(fileName, _sourceText, languageVersion, _syntaxCursor, setParentNodes) {
        initializeState(fileName, _sourceText, languageVersion, _syntaxCursor);
        var result = parseSourceFileWorker(fileName, languageVersion, setParentNodes);
        clearState();
        return result;
      }
      Parser.parseSourceFile = parseSourceFile;
      function initializeState(fileName, _sourceText, languageVersion, _syntaxCursor) {
        sourceText = _sourceText;
        syntaxCursor = _syntaxCursor;
        parseDiagnostics = [];
        parsingContext = 0;
        identifiers = {};
        identifierCount = 0;
        nodeCount = 0;
        contextFlags = ts.isJavaScript(fileName) ? 32 : 0;
        parseErrorBeforeNextFinishedNode = false;
        scanner.setText(sourceText);
        scanner.setOnError(scanError);
        scanner.setScriptTarget(languageVersion);
        scanner.setLanguageVariant(ts.isTsx(fileName) ? 1 : 0);
      }
      function clearState() {
        scanner.setText("");
        scanner.setOnError(undefined);
        parseDiagnostics = undefined;
        sourceFile = undefined;
        identifiers = undefined;
        syntaxCursor = undefined;
        sourceText = undefined;
      }
      function parseSourceFileWorker(fileName, languageVersion, setParentNodes) {
        sourceFile = createSourceFile(fileName, languageVersion);
        token = nextToken();
        processReferenceComments(sourceFile);
        sourceFile.statements = parseList(0, parseStatement);
        ts.Debug.assert(token === 1);
        sourceFile.endOfFileToken = parseTokenNode();
        setExternalModuleIndicator(sourceFile);
        sourceFile.nodeCount = nodeCount;
        sourceFile.identifierCount = identifierCount;
        sourceFile.identifiers = identifiers;
        sourceFile.parseDiagnostics = parseDiagnostics;
        if (setParentNodes) {
          fixupParentReferences(sourceFile);
        }
        if (ts.isJavaScript(fileName)) {
          addJSDocComments();
        }
        return sourceFile;
      }
      function addJSDocComments() {
        forEachChild(sourceFile, visit);
        return;
        function visit(node) {
          switch (node.kind) {
            case 191:
            case 211:
            case 136:
              addJSDocComment(node);
          }
          forEachChild(node, visit);
        }
      }
      function addJSDocComment(node) {
        var comments = ts.getLeadingCommentRangesOfNode(node, sourceFile);
        if (comments) {
          for (var _i = 0; _i < comments.length; _i++) {
            var comment = comments[_i];
            var jsDocComment = JSDocParser.parseJSDocComment(node, comment.pos, comment.end - comment.pos);
            if (jsDocComment) {
              node.jsDocComment = jsDocComment;
            }
          }
        }
      }
      function fixupParentReferences(sourceFile) {
        var parent = sourceFile;
        forEachChild(sourceFile, visitNode);
        return;
        function visitNode(n) {
          if (n.parent !== parent) {
            n.parent = parent;
            var saveParent = parent;
            parent = n;
            forEachChild(n, visitNode);
            parent = saveParent;
          }
        }
      }
      Parser.fixupParentReferences = fixupParentReferences;
      function createSourceFile(fileName, languageVersion) {
        var sourceFile = createNode(246, 0);
        sourceFile.pos = 0;
        sourceFile.end = sourceText.length;
        sourceFile.text = sourceText;
        sourceFile.bindDiagnostics = [];
        sourceFile.languageVersion = languageVersion;
        sourceFile.fileName = ts.normalizePath(fileName);
        sourceFile.flags = ts.fileExtensionIs(sourceFile.fileName, ".d.ts") ? 8192 : 0;
        sourceFile.languageVariant = ts.isTsx(sourceFile.fileName) ? 1 : 0;
        return sourceFile;
      }
      function setContextFlag(val, flag) {
        if (val) {
          contextFlags |= flag;
        } else {
          contextFlags &= ~flag;
        }
      }
      function setDisallowInContext(val) {
        setContextFlag(val, 1);
      }
      function setYieldContext(val) {
        setContextFlag(val, 2);
      }
      function setDecoratorContext(val) {
        setContextFlag(val, 4);
      }
      function setAwaitContext(val) {
        setContextFlag(val, 8);
      }
      function doOutsideOfContext(context, func) {
        var contextFlagsToClear = context & contextFlags;
        if (contextFlagsToClear) {
          setContextFlag(false, contextFlagsToClear);
          var result = func();
          setContextFlag(true, contextFlagsToClear);
          return result;
        }
        return func();
      }
      function doInsideOfContext(context, func) {
        var contextFlagsToSet = context & ~contextFlags;
        if (contextFlagsToSet) {
          setContextFlag(true, contextFlagsToSet);
          var result = func();
          setContextFlag(false, contextFlagsToSet);
          return result;
        }
        return func();
      }
      function allowInAnd(func) {
        return doOutsideOfContext(1, func);
      }
      function disallowInAnd(func) {
        return doInsideOfContext(1, func);
      }
      function doInYieldContext(func) {
        return doInsideOfContext(2, func);
      }
      function doOutsideOfYieldContext(func) {
        return doOutsideOfContext(2, func);
      }
      function doInDecoratorContext(func) {
        return doInsideOfContext(4, func);
      }
      function doInAwaitContext(func) {
        return doInsideOfContext(8, func);
      }
      function doOutsideOfAwaitContext(func) {
        return doOutsideOfContext(8, func);
      }
      function doInYieldAndAwaitContext(func) {
        return doInsideOfContext(2 | 8, func);
      }
      function doOutsideOfYieldAndAwaitContext(func) {
        return doOutsideOfContext(2 | 8, func);
      }
      function inContext(flags) {
        return (contextFlags & flags) !== 0;
      }
      function inYieldContext() {
        return inContext(2);
      }
      function inDisallowInContext() {
        return inContext(1);
      }
      function inDecoratorContext() {
        return inContext(4);
      }
      function inAwaitContext() {
        return inContext(8);
      }
      function parseErrorAtCurrentToken(message, arg0) {
        var start = scanner.getTokenPos();
        var length = scanner.getTextPos() - start;
        parseErrorAtPosition(start, length, message, arg0);
      }
      function parseErrorAtPosition(start, length, message, arg0) {
        var lastError = ts.lastOrUndefined(parseDiagnostics);
        if (!lastError || start !== lastError.start) {
          parseDiagnostics.push(ts.createFileDiagnostic(sourceFile, start, length, message, arg0));
        }
        parseErrorBeforeNextFinishedNode = true;
      }
      function scanError(message, length) {
        var pos = scanner.getTextPos();
        parseErrorAtPosition(pos, length || 0, message);
      }
      function getNodePos() {
        return scanner.getStartPos();
      }
      function getNodeEnd() {
        return scanner.getStartPos();
      }
      function nextToken() {
        return token = scanner.scan();
      }
      function getTokenPos(pos) {
        return ts.skipTrivia(sourceText, pos);
      }
      function reScanGreaterToken() {
        return token = scanner.reScanGreaterToken();
      }
      function reScanSlashToken() {
        return token = scanner.reScanSlashToken();
      }
      function reScanTemplateToken() {
        return token = scanner.reScanTemplateToken();
      }
      function scanJsxIdentifier() {
        return token = scanner.scanJsxIdentifier();
      }
      function scanJsxText() {
        return token = scanner.scanJsxToken();
      }
      function speculationHelper(callback, isLookAhead) {
        var saveToken = token;
        var saveParseDiagnosticsLength = parseDiagnostics.length;
        var saveParseErrorBeforeNextFinishedNode = parseErrorBeforeNextFinishedNode;
        var saveContextFlags = contextFlags;
        var result = isLookAhead ? scanner.lookAhead(callback) : scanner.tryScan(callback);
        ts.Debug.assert(saveContextFlags === contextFlags);
        if (!result || isLookAhead) {
          token = saveToken;
          parseDiagnostics.length = saveParseDiagnosticsLength;
          parseErrorBeforeNextFinishedNode = saveParseErrorBeforeNextFinishedNode;
        }
        return result;
      }
      function lookAhead(callback) {
        return speculationHelper(callback, true);
      }
      function tryParse(callback) {
        return speculationHelper(callback, false);
      }
      function isIdentifier() {
        if (token === 67) {
          return true;
        }
        if (token === 112 && inYieldContext()) {
          return false;
        }
        if (token === 117 && inAwaitContext()) {
          return false;
        }
        return token > 103;
      }
      function parseExpected(kind, diagnosticMessage, shouldAdvance) {
        if (shouldAdvance === void 0) {
          shouldAdvance = true;
        }
        if (token === kind) {
          if (shouldAdvance) {
            nextToken();
          }
          return true;
        }
        if (diagnosticMessage) {
          parseErrorAtCurrentToken(diagnosticMessage);
        } else {
          parseErrorAtCurrentToken(ts.Diagnostics._0_expected, ts.tokenToString(kind));
        }
        return false;
      }
      function parseOptional(t) {
        if (token === t) {
          nextToken();
          return true;
        }
        return false;
      }
      function parseOptionalToken(t) {
        if (token === t) {
          return parseTokenNode();
        }
        return undefined;
      }
      function parseExpectedToken(t, reportAtCurrentPosition, diagnosticMessage, arg0) {
        return parseOptionalToken(t) || createMissingNode(t, reportAtCurrentPosition, diagnosticMessage, arg0);
      }
      function parseTokenNode() {
        var node = createNode(token);
        nextToken();
        return finishNode(node);
      }
      function canParseSemicolon() {
        if (token === 23) {
          return true;
        }
        return token === 16 || token === 1 || scanner.hasPrecedingLineBreak();
      }
      function parseSemicolon() {
        if (canParseSemicolon()) {
          if (token === 23) {
            nextToken();
          }
          return true;
        } else {
          return parseExpected(23);
        }
      }
      function createNode(kind, pos) {
        nodeCount++;
        var node = new (nodeConstructors[kind] || (nodeConstructors[kind] = ts.objectAllocator.getNodeConstructor(kind)))();
        if (!(pos >= 0)) {
          pos = scanner.getStartPos();
        }
        node.pos = pos;
        node.end = pos;
        return node;
      }
      function finishNode(node, end) {
        node.end = end === undefined ? scanner.getStartPos() : end;
        if (contextFlags) {
          node.parserContextFlags = contextFlags;
        }
        if (parseErrorBeforeNextFinishedNode) {
          parseErrorBeforeNextFinishedNode = false;
          node.parserContextFlags |= 16;
        }
        return node;
      }
      function createMissingNode(kind, reportAtCurrentPosition, diagnosticMessage, arg0) {
        if (reportAtCurrentPosition) {
          parseErrorAtPosition(scanner.getStartPos(), 0, diagnosticMessage, arg0);
        } else {
          parseErrorAtCurrentToken(diagnosticMessage, arg0);
        }
        var result = createNode(kind, scanner.getStartPos());
        result.text = "";
        return finishNode(result);
      }
      function internIdentifier(text) {
        text = ts.escapeIdentifier(text);
        return ts.hasProperty(identifiers, text) ? identifiers[text] : (identifiers[text] = text);
      }
      function createIdentifier(isIdentifier, diagnosticMessage) {
        identifierCount++;
        if (isIdentifier) {
          var node = createNode(67);
          if (token !== 67) {
            node.originalKeywordKind = token;
          }
          node.text = internIdentifier(scanner.getTokenValue());
          nextToken();
          return finishNode(node);
        }
        return createMissingNode(67, false, diagnosticMessage || ts.Diagnostics.Identifier_expected);
      }
      function parseIdentifier(diagnosticMessage) {
        return createIdentifier(isIdentifier(), diagnosticMessage);
      }
      function parseIdentifierName() {
        return createIdentifier(isIdentifierOrKeyword());
      }
      function isLiteralPropertyName() {
        return isIdentifierOrKeyword() || token === 9 || token === 8;
      }
      function parsePropertyNameWorker(allowComputedPropertyNames) {
        if (token === 9 || token === 8) {
          return parseLiteralNode(true);
        }
        if (allowComputedPropertyNames && token === 19) {
          return parseComputedPropertyName();
        }
        return parseIdentifierName();
      }
      function parsePropertyName() {
        return parsePropertyNameWorker(true);
      }
      function parseSimplePropertyName() {
        return parsePropertyNameWorker(false);
      }
      function isSimplePropertyName() {
        return token === 9 || token === 8 || isIdentifierOrKeyword();
      }
      function parseComputedPropertyName() {
        var node = createNode(134);
        parseExpected(19);
        node.expression = allowInAnd(parseExpression);
        parseExpected(20);
        return finishNode(node);
      }
      function parseContextualModifier(t) {
        return token === t && tryParse(nextTokenCanFollowModifier);
      }
      function nextTokenCanFollowModifier() {
        if (token === 72) {
          return nextToken() === 79;
        }
        if (token === 80) {
          nextToken();
          if (token === 75) {
            return lookAhead(nextTokenIsClassOrFunction);
          }
          return token !== 37 && token !== 15 && canFollowModifier();
        }
        if (token === 75) {
          return nextTokenIsClassOrFunction();
        }
        nextToken();
        return canFollowModifier();
      }
      function parseAnyContextualModifier() {
        return ts.isModifier(token) && tryParse(nextTokenCanFollowModifier);
      }
      function canFollowModifier() {
        return token === 19 || token === 15 || token === 37 || isLiteralPropertyName();
      }
      function nextTokenIsClassOrFunction() {
        nextToken();
        return token === 71 || token === 85;
      }
      function isListElement(parsingContext, inErrorRecovery) {
        var node = currentNode(parsingContext);
        if (node) {
          return true;
        }
        switch (parsingContext) {
          case 0:
          case 1:
          case 3:
            return !(token === 23 && inErrorRecovery) && isStartOfStatement();
          case 2:
            return token === 69 || token === 75;
          case 4:
            return isStartOfTypeMember();
          case 5:
            return lookAhead(isClassMemberStart) || (token === 23 && !inErrorRecovery);
          case 6:
            return token === 19 || isLiteralPropertyName();
          case 12:
            return token === 19 || token === 37 || isLiteralPropertyName();
          case 9:
            return isLiteralPropertyName();
          case 7:
            if (token === 15) {
              return lookAhead(isValidHeritageClauseObjectLiteral);
            }
            if (!inErrorRecovery) {
              return isStartOfLeftHandSideExpression() && !isHeritageClauseExtendsOrImplementsKeyword();
            } else {
              return isIdentifier() && !isHeritageClauseExtendsOrImplementsKeyword();
            }
          case 8:
            return isIdentifierOrPattern();
          case 10:
            return token === 24 || token === 22 || isIdentifierOrPattern();
          case 17:
            return isIdentifier();
          case 11:
          case 15:
            return token === 24 || token === 22 || isStartOfExpression();
          case 16:
            return isStartOfParameter();
          case 18:
          case 19:
            return token === 24 || isStartOfType();
          case 20:
            return isHeritageClause();
          case 21:
            return isIdentifierOrKeyword();
          case 13:
            return isIdentifierOrKeyword() || token === 15;
          case 14:
            return true;
          case 22:
          case 23:
          case 25:
            return JSDocParser.isJSDocType();
          case 24:
            return isSimplePropertyName();
        }
        ts.Debug.fail("Non-exhaustive case in 'isListElement'.");
      }
      function isValidHeritageClauseObjectLiteral() {
        ts.Debug.assert(token === 15);
        if (nextToken() === 16) {
          var next = nextToken();
          return next === 24 || next === 15 || next === 81 || next === 104;
        }
        return true;
      }
      function nextTokenIsIdentifier() {
        nextToken();
        return isIdentifier();
      }
      function nextTokenIsIdentifierOrKeyword() {
        nextToken();
        return isIdentifierOrKeyword();
      }
      function isHeritageClauseExtendsOrImplementsKeyword() {
        if (token === 104 || token === 81) {
          return lookAhead(nextTokenIsStartOfExpression);
        }
        return false;
      }
      function nextTokenIsStartOfExpression() {
        nextToken();
        return isStartOfExpression();
      }
      function isListTerminator(kind) {
        if (token === 1) {
          return true;
        }
        switch (kind) {
          case 1:
          case 2:
          case 4:
          case 5:
          case 6:
          case 12:
          case 9:
          case 21:
            return token === 16;
          case 3:
            return token === 16 || token === 69 || token === 75;
          case 7:
            return token === 15 || token === 81 || token === 104;
          case 8:
            return isVariableDeclaratorListTerminator();
          case 17:
            return token === 27 || token === 17 || token === 15 || token === 81 || token === 104;
          case 11:
            return token === 18 || token === 23;
          case 15:
          case 19:
          case 10:
            return token === 20;
          case 16:
            return token === 18 || token === 20;
          case 18:
            return token === 27 || token === 17;
          case 20:
            return token === 15 || token === 16;
          case 13:
            return token === 27 || token === 38;
          case 14:
            return token === 25 && lookAhead(nextTokenIsSlash);
          case 22:
            return token === 18 || token === 53 || token === 16;
          case 23:
            return token === 27 || token === 16;
          case 25:
            return token === 20 || token === 16;
          case 24:
            return token === 16;
        }
      }
      function isVariableDeclaratorListTerminator() {
        if (canParseSemicolon()) {
          return true;
        }
        if (isInOrOfKeyword(token)) {
          return true;
        }
        if (token === 34) {
          return true;
        }
        return false;
      }
      function isInSomeParsingContext() {
        for (var kind = 0; kind < 26; kind++) {
          if (parsingContext & (1 << kind)) {
            if (isListElement(kind, true) || isListTerminator(kind)) {
              return true;
            }
          }
        }
        return false;
      }
      function parseList(kind, parseElement) {
        var saveParsingContext = parsingContext;
        parsingContext |= 1 << kind;
        var result = [];
        result.pos = getNodePos();
        while (!isListTerminator(kind)) {
          if (isListElement(kind, false)) {
            var element = parseListElement(kind, parseElement);
            result.push(element);
            continue;
          }
          if (abortParsingListOrMoveToNextToken(kind)) {
            break;
          }
        }
        result.end = getNodeEnd();
        parsingContext = saveParsingContext;
        return result;
      }
      function parseListElement(parsingContext, parseElement) {
        var node = currentNode(parsingContext);
        if (node) {
          return consumeNode(node);
        }
        return parseElement();
      }
      function currentNode(parsingContext) {
        if (parseErrorBeforeNextFinishedNode) {
          return undefined;
        }
        if (!syntaxCursor) {
          return undefined;
        }
        var node = syntaxCursor.currentNode(scanner.getStartPos());
        if (ts.nodeIsMissing(node)) {
          return undefined;
        }
        if (node.intersectsChange) {
          return undefined;
        }
        if (ts.containsParseError(node)) {
          return undefined;
        }
        var nodeContextFlags = node.parserContextFlags & 31;
        if (nodeContextFlags !== contextFlags) {
          return undefined;
        }
        if (!canReuseNode(node, parsingContext)) {
          return undefined;
        }
        return node;
      }
      function consumeNode(node) {
        scanner.setTextPos(node.end);
        nextToken();
        return node;
      }
      function canReuseNode(node, parsingContext) {
        switch (parsingContext) {
          case 5:
            return isReusableClassMember(node);
          case 2:
            return isReusableSwitchClause(node);
          case 0:
          case 1:
          case 3:
            return isReusableStatement(node);
          case 6:
            return isReusableEnumMember(node);
          case 4:
            return isReusableTypeMember(node);
          case 8:
            return isReusableVariableDeclaration(node);
          case 16:
            return isReusableParameter(node);
          case 20:
          case 17:
          case 19:
          case 18:
          case 11:
          case 12:
          case 7:
          case 13:
          case 14:
        }
        return false;
      }
      function isReusableClassMember(node) {
        if (node) {
          switch (node.kind) {
            case 142:
            case 147:
            case 143:
            case 144:
            case 139:
            case 189:
              return true;
            case 141:
              var methodDeclaration = node;
              var nameIsConstructor = methodDeclaration.name.kind === 67 && methodDeclaration.name.originalKeywordKind === 119;
              return !nameIsConstructor;
          }
        }
        return false;
      }
      function isReusableSwitchClause(node) {
        if (node) {
          switch (node.kind) {
            case 239:
            case 240:
              return true;
          }
        }
        return false;
      }
      function isReusableStatement(node) {
        if (node) {
          switch (node.kind) {
            case 211:
            case 191:
            case 190:
            case 194:
            case 193:
            case 206:
            case 202:
            case 204:
            case 201:
            case 200:
            case 198:
            case 199:
            case 197:
            case 196:
            case 203:
            case 192:
            case 207:
            case 205:
            case 195:
            case 208:
            case 220:
            case 219:
            case 226:
            case 225:
            case 216:
            case 212:
            case 213:
            case 215:
            case 214:
              return true;
          }
        }
        return false;
      }
      function isReusableEnumMember(node) {
        return node.kind === 245;
      }
      function isReusableTypeMember(node) {
        if (node) {
          switch (node.kind) {
            case 146:
            case 140:
            case 147:
            case 138:
            case 145:
              return true;
          }
        }
        return false;
      }
      function isReusableVariableDeclaration(node) {
        if (node.kind !== 209) {
          return false;
        }
        var variableDeclarator = node;
        return variableDeclarator.initializer === undefined;
      }
      function isReusableParameter(node) {
        if (node.kind !== 136) {
          return false;
        }
        var parameter = node;
        return parameter.initializer === undefined;
      }
      function abortParsingListOrMoveToNextToken(kind) {
        parseErrorAtCurrentToken(parsingContextErrors(kind));
        if (isInSomeParsingContext()) {
          return true;
        }
        nextToken();
        return false;
      }
      function parsingContextErrors(context) {
        switch (context) {
          case 0:
            return ts.Diagnostics.Declaration_or_statement_expected;
          case 1:
            return ts.Diagnostics.Declaration_or_statement_expected;
          case 2:
            return ts.Diagnostics.case_or_default_expected;
          case 3:
            return ts.Diagnostics.Statement_expected;
          case 4:
            return ts.Diagnostics.Property_or_signature_expected;
          case 5:
            return ts.Diagnostics.Unexpected_token_A_constructor_method_accessor_or_property_was_expected;
          case 6:
            return ts.Diagnostics.Enum_member_expected;
          case 7:
            return ts.Diagnostics.Expression_expected;
          case 8:
            return ts.Diagnostics.Variable_declaration_expected;
          case 9:
            return ts.Diagnostics.Property_destructuring_pattern_expected;
          case 10:
            return ts.Diagnostics.Array_element_destructuring_pattern_expected;
          case 11:
            return ts.Diagnostics.Argument_expression_expected;
          case 12:
            return ts.Diagnostics.Property_assignment_expected;
          case 15:
            return ts.Diagnostics.Expression_or_comma_expected;
          case 16:
            return ts.Diagnostics.Parameter_declaration_expected;
          case 17:
            return ts.Diagnostics.Type_parameter_declaration_expected;
          case 18:
            return ts.Diagnostics.Type_argument_expected;
          case 19:
            return ts.Diagnostics.Type_expected;
          case 20:
            return ts.Diagnostics.Unexpected_token_expected;
          case 21:
            return ts.Diagnostics.Identifier_expected;
          case 13:
            return ts.Diagnostics.Identifier_expected;
          case 14:
            return ts.Diagnostics.Identifier_expected;
          case 22:
            return ts.Diagnostics.Parameter_declaration_expected;
          case 23:
            return ts.Diagnostics.Type_argument_expected;
          case 25:
            return ts.Diagnostics.Type_expected;
          case 24:
            return ts.Diagnostics.Property_assignment_expected;
        }
      }
      ;
      function parseDelimitedList(kind, parseElement, considerSemicolonAsDelimeter) {
        var saveParsingContext = parsingContext;
        parsingContext |= 1 << kind;
        var result = [];
        result.pos = getNodePos();
        var commaStart = -1;
        while (true) {
          if (isListElement(kind, false)) {
            result.push(parseListElement(kind, parseElement));
            commaStart = scanner.getTokenPos();
            if (parseOptional(24)) {
              continue;
            }
            commaStart = -1;
            if (isListTerminator(kind)) {
              break;
            }
            parseExpected(24);
            if (considerSemicolonAsDelimeter && token === 23 && !scanner.hasPrecedingLineBreak()) {
              nextToken();
            }
            continue;
          }
          if (isListTerminator(kind)) {
            break;
          }
          if (abortParsingListOrMoveToNextToken(kind)) {
            break;
          }
        }
        if (commaStart >= 0) {
          result.hasTrailingComma = true;
        }
        result.end = getNodeEnd();
        parsingContext = saveParsingContext;
        return result;
      }
      function createMissingList() {
        var pos = getNodePos();
        var result = [];
        result.pos = pos;
        result.end = pos;
        return result;
      }
      function parseBracketedList(kind, parseElement, open, close) {
        if (parseExpected(open)) {
          var result = parseDelimitedList(kind, parseElement);
          parseExpected(close);
          return result;
        }
        return createMissingList();
      }
      function parseEntityName(allowReservedWords, diagnosticMessage) {
        var entity = parseIdentifier(diagnosticMessage);
        while (parseOptional(21)) {
          var node = createNode(133, entity.pos);
          node.left = entity;
          node.right = parseRightSideOfDot(allowReservedWords);
          entity = finishNode(node);
        }
        return entity;
      }
      function parseRightSideOfDot(allowIdentifierNames) {
        if (scanner.hasPrecedingLineBreak() && isIdentifierOrKeyword()) {
          var matchesPattern = lookAhead(nextTokenIsIdentifierOrKeywordOnSameLine);
          if (matchesPattern) {
            return createMissingNode(67, true, ts.Diagnostics.Identifier_expected);
          }
        }
        return allowIdentifierNames ? parseIdentifierName() : parseIdentifier();
      }
      function parseTemplateExpression() {
        var template = createNode(181);
        template.head = parseLiteralNode();
        ts.Debug.assert(template.head.kind === 12, "Template head has wrong token kind");
        var templateSpans = [];
        templateSpans.pos = getNodePos();
        do {
          templateSpans.push(parseTemplateSpan());
        } while (ts.lastOrUndefined(templateSpans).literal.kind === 13);
        templateSpans.end = getNodeEnd();
        template.templateSpans = templateSpans;
        return finishNode(template);
      }
      function parseTemplateSpan() {
        var span = createNode(188);
        span.expression = allowInAnd(parseExpression);
        var literal;
        if (token === 16) {
          reScanTemplateToken();
          literal = parseLiteralNode();
        } else {
          literal = parseExpectedToken(14, false, ts.Diagnostics._0_expected, ts.tokenToString(16));
        }
        span.literal = literal;
        return finishNode(span);
      }
      function parseLiteralNode(internName) {
        var node = createNode(token);
        var text = scanner.getTokenValue();
        node.text = internName ? internIdentifier(text) : text;
        if (scanner.hasExtendedUnicodeEscape()) {
          node.hasExtendedUnicodeEscape = true;
        }
        if (scanner.isUnterminated()) {
          node.isUnterminated = true;
        }
        var tokenPos = scanner.getTokenPos();
        nextToken();
        finishNode(node);
        if (node.kind === 8 && sourceText.charCodeAt(tokenPos) === 48 && ts.isOctalDigit(sourceText.charCodeAt(tokenPos + 1))) {
          node.flags |= 65536;
        }
        return node;
      }
      function parseTypeReferenceOrTypePredicate() {
        var typeName = parseEntityName(false, ts.Diagnostics.Type_expected);
        if (typeName.kind === 67 && token === 122 && !scanner.hasPrecedingLineBreak()) {
          nextToken();
          var node_1 = createNode(148, typeName.pos);
          node_1.parameterName = typeName;
          node_1.type = parseType();
          return finishNode(node_1);
        }
        var node = createNode(149, typeName.pos);
        node.typeName = typeName;
        if (!scanner.hasPrecedingLineBreak() && token === 25) {
          node.typeArguments = parseBracketedList(18, parseType, 25, 27);
        }
        return finishNode(node);
      }
      function parseTypeQuery() {
        var node = createNode(152);
        parseExpected(99);
        node.exprName = parseEntityName(true);
        return finishNode(node);
      }
      function parseTypeParameter() {
        var node = createNode(135);
        node.name = parseIdentifier();
        if (parseOptional(81)) {
          if (isStartOfType() || !isStartOfExpression()) {
            node.constraint = parseType();
          } else {
            node.expression = parseUnaryExpressionOrHigher();
          }
        }
        return finishNode(node);
      }
      function parseTypeParameters() {
        if (token === 25) {
          return parseBracketedList(17, parseTypeParameter, 25, 27);
        }
      }
      function parseParameterType() {
        if (parseOptional(53)) {
          return token === 9 ? parseLiteralNode(true) : parseType();
        }
        return undefined;
      }
      function isStartOfParameter() {
        return token === 22 || isIdentifierOrPattern() || ts.isModifier(token) || token === 54;
      }
      function setModifiers(node, modifiers) {
        if (modifiers) {
          node.flags |= modifiers.flags;
          node.modifiers = modifiers;
        }
      }
      function parseParameter() {
        var node = createNode(136);
        node.decorators = parseDecorators();
        setModifiers(node, parseModifiers());
        node.dotDotDotToken = parseOptionalToken(22);
        node.name = parseIdentifierOrPattern();
        if (ts.getFullWidth(node.name) === 0 && node.flags === 0 && ts.isModifier(token)) {
          nextToken();
        }
        node.questionToken = parseOptionalToken(52);
        node.type = parseParameterType();
        node.initializer = parseBindingElementInitializer(true);
        return finishNode(node);
      }
      function parseBindingElementInitializer(inParameter) {
        return inParameter ? parseParameterInitializer() : parseNonParameterInitializer();
      }
      function parseParameterInitializer() {
        return parseInitializer(true);
      }
      function fillSignature(returnToken, yieldContext, awaitContext, requireCompleteParameterList, signature) {
        var returnTokenRequired = returnToken === 34;
        signature.typeParameters = parseTypeParameters();
        signature.parameters = parseParameterList(yieldContext, awaitContext, requireCompleteParameterList);
        if (returnTokenRequired) {
          parseExpected(returnToken);
          signature.type = parseType();
        } else if (parseOptional(returnToken)) {
          signature.type = parseType();
        }
      }
      function parseParameterList(yieldContext, awaitContext, requireCompleteParameterList) {
        if (parseExpected(17)) {
          var savedYieldContext = inYieldContext();
          var savedAwaitContext = inAwaitContext();
          setYieldContext(yieldContext);
          setAwaitContext(awaitContext);
          var result = parseDelimitedList(16, parseParameter);
          setYieldContext(savedYieldContext);
          setAwaitContext(savedAwaitContext);
          if (!parseExpected(18) && requireCompleteParameterList) {
            return undefined;
          }
          return result;
        }
        return requireCompleteParameterList ? undefined : createMissingList();
      }
      function parseTypeMemberSemicolon() {
        if (parseOptional(24)) {
          return;
        }
        parseSemicolon();
      }
      function parseSignatureMember(kind) {
        var node = createNode(kind);
        if (kind === 146) {
          parseExpected(90);
        }
        fillSignature(53, false, false, false, node);
        parseTypeMemberSemicolon();
        return finishNode(node);
      }
      function isIndexSignature() {
        if (token !== 19) {
          return false;
        }
        return lookAhead(isUnambiguouslyIndexSignature);
      }
      function isUnambiguouslyIndexSignature() {
        nextToken();
        if (token === 22 || token === 20) {
          return true;
        }
        if (ts.isModifier(token)) {
          nextToken();
          if (isIdentifier()) {
            return true;
          }
        } else if (!isIdentifier()) {
          return false;
        } else {
          nextToken();
        }
        if (token === 53 || token === 24) {
          return true;
        }
        if (token !== 52) {
          return false;
        }
        nextToken();
        return token === 53 || token === 24 || token === 20;
      }
      function parseIndexSignatureDeclaration(fullStart, decorators, modifiers) {
        var node = createNode(147, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        node.parameters = parseBracketedList(16, parseParameter, 19, 20);
        node.type = parseTypeAnnotation();
        parseTypeMemberSemicolon();
        return finishNode(node);
      }
      function parsePropertyOrMethodSignature() {
        var fullStart = scanner.getStartPos();
        var name = parsePropertyName();
        var questionToken = parseOptionalToken(52);
        if (token === 17 || token === 25) {
          var method = createNode(140, fullStart);
          method.name = name;
          method.questionToken = questionToken;
          fillSignature(53, false, false, false, method);
          parseTypeMemberSemicolon();
          return finishNode(method);
        } else {
          var property = createNode(138, fullStart);
          property.name = name;
          property.questionToken = questionToken;
          property.type = parseTypeAnnotation();
          parseTypeMemberSemicolon();
          return finishNode(property);
        }
      }
      function isStartOfTypeMember() {
        switch (token) {
          case 17:
          case 25:
          case 19:
            return true;
          default:
            if (ts.isModifier(token)) {
              var result = lookAhead(isStartOfIndexSignatureDeclaration);
              if (result) {
                return result;
              }
            }
            return isLiteralPropertyName() && lookAhead(isTypeMemberWithLiteralPropertyName);
        }
      }
      function isStartOfIndexSignatureDeclaration() {
        while (ts.isModifier(token)) {
          nextToken();
        }
        return isIndexSignature();
      }
      function isTypeMemberWithLiteralPropertyName() {
        nextToken();
        return token === 17 || token === 25 || token === 52 || token === 53 || canParseSemicolon();
      }
      function parseTypeMember() {
        switch (token) {
          case 17:
          case 25:
            return parseSignatureMember(145);
          case 19:
            return isIndexSignature() ? parseIndexSignatureDeclaration(scanner.getStartPos(), undefined, undefined) : parsePropertyOrMethodSignature();
          case 90:
            if (lookAhead(isStartOfConstructSignature)) {
              return parseSignatureMember(146);
            }
          case 9:
          case 8:
            return parsePropertyOrMethodSignature();
          default:
            if (ts.isModifier(token)) {
              var result = tryParse(parseIndexSignatureWithModifiers);
              if (result) {
                return result;
              }
            }
            if (isIdentifierOrKeyword()) {
              return parsePropertyOrMethodSignature();
            }
        }
      }
      function parseIndexSignatureWithModifiers() {
        var fullStart = scanner.getStartPos();
        var decorators = parseDecorators();
        var modifiers = parseModifiers();
        return isIndexSignature() ? parseIndexSignatureDeclaration(fullStart, decorators, modifiers) : undefined;
      }
      function isStartOfConstructSignature() {
        nextToken();
        return token === 17 || token === 25;
      }
      function parseTypeLiteral() {
        var node = createNode(153);
        node.members = parseObjectTypeMembers();
        return finishNode(node);
      }
      function parseObjectTypeMembers() {
        var members;
        if (parseExpected(15)) {
          members = parseList(4, parseTypeMember);
          parseExpected(16);
        } else {
          members = createMissingList();
        }
        return members;
      }
      function parseTupleType() {
        var node = createNode(155);
        node.elementTypes = parseBracketedList(19, parseType, 19, 20);
        return finishNode(node);
      }
      function parseParenthesizedType() {
        var node = createNode(158);
        parseExpected(17);
        node.type = parseType();
        parseExpected(18);
        return finishNode(node);
      }
      function parseFunctionOrConstructorType(kind) {
        var node = createNode(kind);
        if (kind === 151) {
          parseExpected(90);
        }
        fillSignature(34, false, false, false, node);
        return finishNode(node);
      }
      function parseKeywordAndNoDot() {
        var node = parseTokenNode();
        return token === 21 ? undefined : node;
      }
      function parseNonArrayType() {
        switch (token) {
          case 115:
          case 128:
          case 126:
          case 118:
          case 129:
            var node = tryParse(parseKeywordAndNoDot);
            return node || parseTypeReferenceOrTypePredicate();
          case 101:
            return parseTokenNode();
          case 99:
            return parseTypeQuery();
          case 15:
            return parseTypeLiteral();
          case 19:
            return parseTupleType();
          case 17:
            return parseParenthesizedType();
          default:
            return parseTypeReferenceOrTypePredicate();
        }
      }
      function isStartOfType() {
        switch (token) {
          case 115:
          case 128:
          case 126:
          case 118:
          case 129:
          case 101:
          case 99:
          case 15:
          case 19:
          case 25:
          case 90:
            return true;
          case 17:
            return lookAhead(isStartOfParenthesizedOrFunctionType);
          default:
            return isIdentifier();
        }
      }
      function isStartOfParenthesizedOrFunctionType() {
        nextToken();
        return token === 18 || isStartOfParameter() || isStartOfType();
      }
      function parseArrayTypeOrHigher() {
        var type = parseNonArrayType();
        while (!scanner.hasPrecedingLineBreak() && parseOptional(19)) {
          parseExpected(20);
          var node = createNode(154, type.pos);
          node.elementType = type;
          type = finishNode(node);
        }
        return type;
      }
      function parseUnionOrIntersectionType(kind, parseConstituentType, operator) {
        var type = parseConstituentType();
        if (token === operator) {
          var types = [type];
          types.pos = type.pos;
          while (parseOptional(operator)) {
            types.push(parseConstituentType());
          }
          types.end = getNodeEnd();
          var node = createNode(kind, type.pos);
          node.types = types;
          type = finishNode(node);
        }
        return type;
      }
      function parseIntersectionTypeOrHigher() {
        return parseUnionOrIntersectionType(157, parseArrayTypeOrHigher, 45);
      }
      function parseUnionTypeOrHigher() {
        return parseUnionOrIntersectionType(156, parseIntersectionTypeOrHigher, 46);
      }
      function isStartOfFunctionType() {
        if (token === 25) {
          return true;
        }
        return token === 17 && lookAhead(isUnambiguouslyStartOfFunctionType);
      }
      function isUnambiguouslyStartOfFunctionType() {
        nextToken();
        if (token === 18 || token === 22) {
          return true;
        }
        if (isIdentifier() || ts.isModifier(token)) {
          nextToken();
          if (token === 53 || token === 24 || token === 52 || token === 55 || isIdentifier() || ts.isModifier(token)) {
            return true;
          }
          if (token === 18) {
            nextToken();
            if (token === 34) {
              return true;
            }
          }
        }
        return false;
      }
      function parseType() {
        return doOutsideOfContext(10, parseTypeWorker);
      }
      function parseTypeWorker() {
        if (isStartOfFunctionType()) {
          return parseFunctionOrConstructorType(150);
        }
        if (token === 90) {
          return parseFunctionOrConstructorType(151);
        }
        return parseUnionTypeOrHigher();
      }
      function parseTypeAnnotation() {
        return parseOptional(53) ? parseType() : undefined;
      }
      function isStartOfLeftHandSideExpression() {
        switch (token) {
          case 95:
          case 93:
          case 91:
          case 97:
          case 82:
          case 8:
          case 9:
          case 11:
          case 12:
          case 17:
          case 19:
          case 15:
          case 85:
          case 71:
          case 90:
          case 38:
          case 59:
          case 67:
            return true;
          default:
            return isIdentifier();
        }
      }
      function isStartOfExpression() {
        if (isStartOfLeftHandSideExpression()) {
          return true;
        }
        switch (token) {
          case 35:
          case 36:
          case 49:
          case 48:
          case 76:
          case 99:
          case 101:
          case 40:
          case 41:
          case 25:
          case 117:
          case 112:
            return true;
          default:
            if (isBinaryOperator()) {
              return true;
            }
            return isIdentifier();
        }
      }
      function isStartOfExpressionStatement() {
        return token !== 15 && token !== 85 && token !== 71 && token !== 54 && isStartOfExpression();
      }
      function allowInAndParseExpression() {
        return allowInAnd(parseExpression);
      }
      function parseExpression() {
        var saveDecoratorContext = inDecoratorContext();
        if (saveDecoratorContext) {
          setDecoratorContext(false);
        }
        var expr = parseAssignmentExpressionOrHigher();
        var operatorToken;
        while ((operatorToken = parseOptionalToken(24))) {
          expr = makeBinaryExpression(expr, operatorToken, parseAssignmentExpressionOrHigher());
        }
        if (saveDecoratorContext) {
          setDecoratorContext(true);
        }
        return expr;
      }
      function parseInitializer(inParameter) {
        if (token !== 55) {
          if (scanner.hasPrecedingLineBreak() || (inParameter && token === 15) || !isStartOfExpression()) {
            return undefined;
          }
        }
        parseExpected(55);
        return parseAssignmentExpressionOrHigher();
      }
      function parseAssignmentExpressionOrHigher() {
        if (isYieldExpression()) {
          return parseYieldExpression();
        }
        var arrowExpression = tryParseParenthesizedArrowFunctionExpression();
        if (arrowExpression) {
          return arrowExpression;
        }
        var expr = parseBinaryExpressionOrHigher(0);
        if (expr.kind === 67 && token === 34) {
          return parseSimpleArrowFunctionExpression(expr);
        }
        if (ts.isLeftHandSideExpression(expr) && ts.isAssignmentOperator(reScanGreaterToken())) {
          return makeBinaryExpression(expr, parseTokenNode(), parseAssignmentExpressionOrHigher());
        }
        return parseConditionalExpressionRest(expr);
      }
      function isYieldExpression() {
        if (token === 112) {
          if (inYieldContext()) {
            return true;
          }
          return lookAhead(nextTokenIsIdentifierOrKeywordOrNumberOnSameLine);
        }
        return false;
      }
      function nextTokenIsIdentifierOnSameLine() {
        nextToken();
        return !scanner.hasPrecedingLineBreak() && isIdentifier();
      }
      function parseYieldExpression() {
        var node = createNode(182);
        nextToken();
        if (!scanner.hasPrecedingLineBreak() && (token === 37 || isStartOfExpression())) {
          node.asteriskToken = parseOptionalToken(37);
          node.expression = parseAssignmentExpressionOrHigher();
          return finishNode(node);
        } else {
          return finishNode(node);
        }
      }
      function parseSimpleArrowFunctionExpression(identifier) {
        ts.Debug.assert(token === 34, "parseSimpleArrowFunctionExpression should only have been called if we had a =>");
        var node = createNode(172, identifier.pos);
        var parameter = createNode(136, identifier.pos);
        parameter.name = identifier;
        finishNode(parameter);
        node.parameters = [parameter];
        node.parameters.pos = parameter.pos;
        node.parameters.end = parameter.end;
        node.equalsGreaterThanToken = parseExpectedToken(34, false, ts.Diagnostics._0_expected, "=>");
        node.body = parseArrowFunctionExpressionBody(false);
        return finishNode(node);
      }
      function tryParseParenthesizedArrowFunctionExpression() {
        var triState = isParenthesizedArrowFunctionExpression();
        if (triState === 0) {
          return undefined;
        }
        var arrowFunction = triState === 1 ? parseParenthesizedArrowFunctionExpressionHead(true) : tryParse(parsePossibleParenthesizedArrowFunctionExpressionHead);
        if (!arrowFunction) {
          return undefined;
        }
        var isAsync = !!(arrowFunction.flags & 512);
        var lastToken = token;
        arrowFunction.equalsGreaterThanToken = parseExpectedToken(34, false, ts.Diagnostics._0_expected, "=>");
        arrowFunction.body = (lastToken === 34 || lastToken === 15) ? parseArrowFunctionExpressionBody(isAsync) : parseIdentifier();
        return finishNode(arrowFunction);
      }
      function isParenthesizedArrowFunctionExpression() {
        if (token === 17 || token === 25 || token === 116) {
          return lookAhead(isParenthesizedArrowFunctionExpressionWorker);
        }
        if (token === 34) {
          return 1;
        }
        return 0;
      }
      function isParenthesizedArrowFunctionExpressionWorker() {
        if (token === 116) {
          nextToken();
          if (scanner.hasPrecedingLineBreak()) {
            return 0;
          }
          if (token !== 17 && token !== 25) {
            return 0;
          }
        }
        var first = token;
        var second = nextToken();
        if (first === 17) {
          if (second === 18) {
            var third = nextToken();
            switch (third) {
              case 34:
              case 53:
              case 15:
                return 1;
              default:
                return 0;
            }
          }
          if (second === 19 || second === 15) {
            return 2;
          }
          if (second === 22) {
            return 1;
          }
          if (!isIdentifier()) {
            return 0;
          }
          if (nextToken() === 53) {
            return 1;
          }
          return 2;
        } else {
          ts.Debug.assert(first === 25);
          if (!isIdentifier()) {
            return 0;
          }
          if (sourceFile.languageVariant === 1) {
            var isArrowFunctionInJsx = lookAhead(function() {
              var third = nextToken();
              if (third === 81) {
                var fourth = nextToken();
                switch (fourth) {
                  case 55:
                  case 27:
                    return false;
                  default:
                    return true;
                }
              } else if (third === 24) {
                return true;
              }
              return false;
            });
            if (isArrowFunctionInJsx) {
              return 1;
            }
            return 0;
          }
          return 2;
        }
      }
      function parsePossibleParenthesizedArrowFunctionExpressionHead() {
        return parseParenthesizedArrowFunctionExpressionHead(false);
      }
      function parseParenthesizedArrowFunctionExpressionHead(allowAmbiguity) {
        var node = createNode(172);
        setModifiers(node, parseModifiersForArrowFunction());
        var isAsync = !!(node.flags & 512);
        fillSignature(53, false, isAsync, !allowAmbiguity, node);
        if (!node.parameters) {
          return undefined;
        }
        if (!allowAmbiguity && token !== 34 && token !== 15) {
          return undefined;
        }
        return node;
      }
      function parseArrowFunctionExpressionBody(isAsync) {
        if (token === 15) {
          return parseFunctionBlock(false, isAsync, false);
        }
        if (token !== 23 && token !== 85 && token !== 71 && isStartOfStatement() && !isStartOfExpressionStatement()) {
          return parseFunctionBlock(false, isAsync, true);
        }
        return isAsync ? doInAwaitContext(parseAssignmentExpressionOrHigher) : doOutsideOfAwaitContext(parseAssignmentExpressionOrHigher);
      }
      function parseConditionalExpressionRest(leftOperand) {
        var questionToken = parseOptionalToken(52);
        if (!questionToken) {
          return leftOperand;
        }
        var node = createNode(180, leftOperand.pos);
        node.condition = leftOperand;
        node.questionToken = questionToken;
        node.whenTrue = doOutsideOfContext(disallowInAndDecoratorContext, parseAssignmentExpressionOrHigher);
        node.colonToken = parseExpectedToken(53, false, ts.Diagnostics._0_expected, ts.tokenToString(53));
        node.whenFalse = parseAssignmentExpressionOrHigher();
        return finishNode(node);
      }
      function parseBinaryExpressionOrHigher(precedence) {
        var leftOperand = parseUnaryExpressionOrHigher();
        return parseBinaryExpressionRest(precedence, leftOperand);
      }
      function isInOrOfKeyword(t) {
        return t === 88 || t === 132;
      }
      function parseBinaryExpressionRest(precedence, leftOperand) {
        while (true) {
          reScanGreaterToken();
          var newPrecedence = getBinaryOperatorPrecedence();
          if (newPrecedence <= precedence) {
            break;
          }
          if (token === 88 && inDisallowInContext()) {
            break;
          }
          if (token === 114) {
            if (scanner.hasPrecedingLineBreak()) {
              break;
            } else {
              nextToken();
              leftOperand = makeAsExpression(leftOperand, parseType());
            }
          } else {
            leftOperand = makeBinaryExpression(leftOperand, parseTokenNode(), parseBinaryExpressionOrHigher(newPrecedence));
          }
        }
        return leftOperand;
      }
      function isBinaryOperator() {
        if (inDisallowInContext() && token === 88) {
          return false;
        }
        return getBinaryOperatorPrecedence() > 0;
      }
      function getBinaryOperatorPrecedence() {
        switch (token) {
          case 51:
            return 1;
          case 50:
            return 2;
          case 46:
            return 3;
          case 47:
            return 4;
          case 45:
            return 5;
          case 30:
          case 31:
          case 32:
          case 33:
            return 6;
          case 25:
          case 27:
          case 28:
          case 29:
          case 89:
          case 88:
          case 114:
            return 7;
          case 42:
          case 43:
          case 44:
            return 8;
          case 35:
          case 36:
            return 9;
          case 37:
          case 38:
          case 39:
            return 10;
        }
        return -1;
      }
      function makeBinaryExpression(left, operatorToken, right) {
        var node = createNode(179, left.pos);
        node.left = left;
        node.operatorToken = operatorToken;
        node.right = right;
        return finishNode(node);
      }
      function makeAsExpression(left, right) {
        var node = createNode(187, left.pos);
        node.expression = left;
        node.type = right;
        return finishNode(node);
      }
      function parsePrefixUnaryExpression() {
        var node = createNode(177);
        node.operator = token;
        nextToken();
        node.operand = parseUnaryExpressionOrHigher();
        return finishNode(node);
      }
      function parseDeleteExpression() {
        var node = createNode(173);
        nextToken();
        node.expression = parseUnaryExpressionOrHigher();
        return finishNode(node);
      }
      function parseTypeOfExpression() {
        var node = createNode(174);
        nextToken();
        node.expression = parseUnaryExpressionOrHigher();
        return finishNode(node);
      }
      function parseVoidExpression() {
        var node = createNode(175);
        nextToken();
        node.expression = parseUnaryExpressionOrHigher();
        return finishNode(node);
      }
      function isAwaitExpression() {
        if (token === 117) {
          if (inAwaitContext()) {
            return true;
          }
          return lookAhead(nextTokenIsIdentifierOnSameLine);
        }
        return false;
      }
      function parseAwaitExpression() {
        var node = createNode(176);
        nextToken();
        node.expression = parseUnaryExpressionOrHigher();
        return finishNode(node);
      }
      function parseUnaryExpressionOrHigher() {
        if (isAwaitExpression()) {
          return parseAwaitExpression();
        }
        switch (token) {
          case 35:
          case 36:
          case 49:
          case 48:
          case 40:
          case 41:
            return parsePrefixUnaryExpression();
          case 76:
            return parseDeleteExpression();
          case 99:
            return parseTypeOfExpression();
          case 101:
            return parseVoidExpression();
          case 25:
            if (sourceFile.languageVariant !== 1) {
              return parseTypeAssertion();
            }
            if (lookAhead(nextTokenIsIdentifierOrKeyword)) {
              return parseJsxElementOrSelfClosingElement(true);
            }
          default:
            return parsePostfixExpressionOrHigher();
        }
      }
      function parsePostfixExpressionOrHigher() {
        var expression = parseLeftHandSideExpressionOrHigher();
        ts.Debug.assert(ts.isLeftHandSideExpression(expression));
        if ((token === 40 || token === 41) && !scanner.hasPrecedingLineBreak()) {
          var node = createNode(178, expression.pos);
          node.operand = expression;
          node.operator = token;
          nextToken();
          return finishNode(node);
        }
        return expression;
      }
      function parseLeftHandSideExpressionOrHigher() {
        var expression = token === 93 ? parseSuperExpression() : parseMemberExpressionOrHigher();
        return parseCallExpressionRest(expression);
      }
      function parseMemberExpressionOrHigher() {
        var expression = parsePrimaryExpression();
        return parseMemberExpressionRest(expression);
      }
      function parseSuperExpression() {
        var expression = parseTokenNode();
        if (token === 17 || token === 21 || token === 19) {
          return expression;
        }
        var node = createNode(164, expression.pos);
        node.expression = expression;
        node.dotToken = parseExpectedToken(21, false, ts.Diagnostics.super_must_be_followed_by_an_argument_list_or_member_access);
        node.name = parseRightSideOfDot(true);
        return finishNode(node);
      }
      function parseJsxElementOrSelfClosingElement(inExpressionContext) {
        var opening = parseJsxOpeningOrSelfClosingElement(inExpressionContext);
        if (opening.kind === 233) {
          var node = createNode(231, opening.pos);
          node.openingElement = opening;
          node.children = parseJsxChildren(node.openingElement.tagName);
          node.closingElement = parseJsxClosingElement(inExpressionContext);
          return finishNode(node);
        } else {
          ts.Debug.assert(opening.kind === 232);
          return opening;
        }
      }
      function parseJsxText() {
        var node = createNode(234, scanner.getStartPos());
        token = scanner.scanJsxToken();
        return finishNode(node);
      }
      function parseJsxChild() {
        switch (token) {
          case 234:
            return parseJsxText();
          case 15:
            return parseJsxExpression(false);
          case 25:
            return parseJsxElementOrSelfClosingElement(false);
        }
        ts.Debug.fail("Unknown JSX child kind " + token);
      }
      function parseJsxChildren(openingTagName) {
        var result = [];
        result.pos = scanner.getStartPos();
        var saveParsingContext = parsingContext;
        parsingContext |= 1 << 14;
        while (true) {
          token = scanner.reScanJsxToken();
          if (token === 26) {
            break;
          } else if (token === 1) {
            parseErrorAtCurrentToken(ts.Diagnostics.Expected_corresponding_JSX_closing_tag_for_0, ts.getTextOfNodeFromSourceText(sourceText, openingTagName));
            break;
          }
          result.push(parseJsxChild());
        }
        result.end = scanner.getTokenPos();
        parsingContext = saveParsingContext;
        return result;
      }
      function parseJsxOpeningOrSelfClosingElement(inExpressionContext) {
        var fullStart = scanner.getStartPos();
        parseExpected(25);
        var tagName = parseJsxElementName();
        var attributes = parseList(13, parseJsxAttribute);
        var node;
        if (token === 27) {
          node = createNode(233, fullStart);
          scanJsxText();
        } else {
          parseExpected(38);
          if (inExpressionContext) {
            parseExpected(27);
          } else {
            parseExpected(27, undefined, false);
            scanJsxText();
          }
          node = createNode(232, fullStart);
        }
        node.tagName = tagName;
        node.attributes = attributes;
        return finishNode(node);
      }
      function parseJsxElementName() {
        scanJsxIdentifier();
        var elementName = parseIdentifierName();
        while (parseOptional(21)) {
          scanJsxIdentifier();
          var node = createNode(133, elementName.pos);
          node.left = elementName;
          node.right = parseIdentifierName();
          elementName = finishNode(node);
        }
        return elementName;
      }
      function parseJsxExpression(inExpressionContext) {
        var node = createNode(238);
        parseExpected(15);
        if (token !== 16) {
          node.expression = parseExpression();
        }
        if (inExpressionContext) {
          parseExpected(16);
        } else {
          parseExpected(16, undefined, false);
          scanJsxText();
        }
        return finishNode(node);
      }
      function parseJsxAttribute() {
        if (token === 15) {
          return parseJsxSpreadAttribute();
        }
        scanJsxIdentifier();
        var node = createNode(236);
        node.name = parseIdentifierName();
        if (parseOptional(55)) {
          switch (token) {
            case 9:
              node.initializer = parseLiteralNode();
              break;
            default:
              node.initializer = parseJsxExpression(true);
              break;
          }
        }
        return finishNode(node);
      }
      function parseJsxSpreadAttribute() {
        var node = createNode(237);
        parseExpected(15);
        parseExpected(22);
        node.expression = parseExpression();
        parseExpected(16);
        return finishNode(node);
      }
      function parseJsxClosingElement(inExpressionContext) {
        var node = createNode(235);
        parseExpected(26);
        node.tagName = parseJsxElementName();
        if (inExpressionContext) {
          parseExpected(27);
        } else {
          parseExpected(27, undefined, false);
          scanJsxText();
        }
        return finishNode(node);
      }
      function parseTypeAssertion() {
        var node = createNode(169);
        parseExpected(25);
        node.type = parseType();
        parseExpected(27);
        node.expression = parseUnaryExpressionOrHigher();
        return finishNode(node);
      }
      function parseMemberExpressionRest(expression) {
        while (true) {
          var dotToken = parseOptionalToken(21);
          if (dotToken) {
            var propertyAccess = createNode(164, expression.pos);
            propertyAccess.expression = expression;
            propertyAccess.dotToken = dotToken;
            propertyAccess.name = parseRightSideOfDot(true);
            expression = finishNode(propertyAccess);
            continue;
          }
          if (!inDecoratorContext() && parseOptional(19)) {
            var indexedAccess = createNode(165, expression.pos);
            indexedAccess.expression = expression;
            if (token !== 20) {
              indexedAccess.argumentExpression = allowInAnd(parseExpression);
              if (indexedAccess.argumentExpression.kind === 9 || indexedAccess.argumentExpression.kind === 8) {
                var literal = indexedAccess.argumentExpression;
                literal.text = internIdentifier(literal.text);
              }
            }
            parseExpected(20);
            expression = finishNode(indexedAccess);
            continue;
          }
          if (token === 11 || token === 12) {
            var tagExpression = createNode(168, expression.pos);
            tagExpression.tag = expression;
            tagExpression.template = token === 11 ? parseLiteralNode() : parseTemplateExpression();
            expression = finishNode(tagExpression);
            continue;
          }
          return expression;
        }
      }
      function parseCallExpressionRest(expression) {
        while (true) {
          expression = parseMemberExpressionRest(expression);
          if (token === 25) {
            var typeArguments = tryParse(parseTypeArgumentsInExpression);
            if (!typeArguments) {
              return expression;
            }
            var callExpr = createNode(166, expression.pos);
            callExpr.expression = expression;
            callExpr.typeArguments = typeArguments;
            callExpr.arguments = parseArgumentList();
            expression = finishNode(callExpr);
            continue;
          } else if (token === 17) {
            var callExpr = createNode(166, expression.pos);
            callExpr.expression = expression;
            callExpr.arguments = parseArgumentList();
            expression = finishNode(callExpr);
            continue;
          }
          return expression;
        }
      }
      function parseArgumentList() {
        parseExpected(17);
        var result = parseDelimitedList(11, parseArgumentExpression);
        parseExpected(18);
        return result;
      }
      function parseTypeArgumentsInExpression() {
        if (!parseOptional(25)) {
          return undefined;
        }
        var typeArguments = parseDelimitedList(18, parseType);
        if (!parseExpected(27)) {
          return undefined;
        }
        return typeArguments && canFollowTypeArgumentsInExpression() ? typeArguments : undefined;
      }
      function canFollowTypeArgumentsInExpression() {
        switch (token) {
          case 17:
          case 21:
          case 18:
          case 20:
          case 53:
          case 23:
          case 52:
          case 30:
          case 32:
          case 31:
          case 33:
          case 50:
          case 51:
          case 47:
          case 45:
          case 46:
          case 16:
          case 1:
            return true;
          case 24:
          case 15:
          default:
            return false;
        }
      }
      function parsePrimaryExpression() {
        switch (token) {
          case 8:
          case 9:
          case 11:
            return parseLiteralNode();
          case 95:
          case 93:
          case 91:
          case 97:
          case 82:
            return parseTokenNode();
          case 17:
            return parseParenthesizedExpression();
          case 19:
            return parseArrayLiteralExpression();
          case 15:
            return parseObjectLiteralExpression();
          case 116:
            if (!lookAhead(nextTokenIsFunctionKeywordOnSameLine)) {
              break;
            }
            return parseFunctionExpression();
          case 71:
            return parseClassExpression();
          case 85:
            return parseFunctionExpression();
          case 90:
            return parseNewExpression();
          case 38:
          case 59:
            if (reScanSlashToken() === 10) {
              return parseLiteralNode();
            }
            break;
          case 12:
            return parseTemplateExpression();
        }
        return parseIdentifier(ts.Diagnostics.Expression_expected);
      }
      function parseParenthesizedExpression() {
        var node = createNode(170);
        parseExpected(17);
        node.expression = allowInAnd(parseExpression);
        parseExpected(18);
        return finishNode(node);
      }
      function parseSpreadElement() {
        var node = createNode(183);
        parseExpected(22);
        node.expression = parseAssignmentExpressionOrHigher();
        return finishNode(node);
      }
      function parseArgumentOrArrayLiteralElement() {
        return token === 22 ? parseSpreadElement() : token === 24 ? createNode(185) : parseAssignmentExpressionOrHigher();
      }
      function parseArgumentExpression() {
        return doOutsideOfContext(disallowInAndDecoratorContext, parseArgumentOrArrayLiteralElement);
      }
      function parseArrayLiteralExpression() {
        var node = createNode(162);
        parseExpected(19);
        if (scanner.hasPrecedingLineBreak())
          node.flags |= 2048;
        node.elements = parseDelimitedList(15, parseArgumentOrArrayLiteralElement);
        parseExpected(20);
        return finishNode(node);
      }
      function tryParseAccessorDeclaration(fullStart, decorators, modifiers) {
        if (parseContextualModifier(121)) {
          return parseAccessorDeclaration(143, fullStart, decorators, modifiers);
        } else if (parseContextualModifier(127)) {
          return parseAccessorDeclaration(144, fullStart, decorators, modifiers);
        }
        return undefined;
      }
      function parseObjectLiteralElement() {
        var fullStart = scanner.getStartPos();
        var decorators = parseDecorators();
        var modifiers = parseModifiers();
        var accessor = tryParseAccessorDeclaration(fullStart, decorators, modifiers);
        if (accessor) {
          return accessor;
        }
        var asteriskToken = parseOptionalToken(37);
        var tokenIsIdentifier = isIdentifier();
        var nameToken = token;
        var propertyName = parsePropertyName();
        var questionToken = parseOptionalToken(52);
        if (asteriskToken || token === 17 || token === 25) {
          return parseMethodDeclaration(fullStart, decorators, modifiers, asteriskToken, propertyName, questionToken);
        }
        if ((token === 24 || token === 16) && tokenIsIdentifier) {
          var shorthandDeclaration = createNode(244, fullStart);
          shorthandDeclaration.name = propertyName;
          shorthandDeclaration.questionToken = questionToken;
          return finishNode(shorthandDeclaration);
        } else {
          var propertyAssignment = createNode(243, fullStart);
          propertyAssignment.name = propertyName;
          propertyAssignment.questionToken = questionToken;
          parseExpected(53);
          propertyAssignment.initializer = allowInAnd(parseAssignmentExpressionOrHigher);
          return finishNode(propertyAssignment);
        }
      }
      function parseObjectLiteralExpression() {
        var node = createNode(163);
        parseExpected(15);
        if (scanner.hasPrecedingLineBreak()) {
          node.flags |= 2048;
        }
        node.properties = parseDelimitedList(12, parseObjectLiteralElement, true);
        parseExpected(16);
        return finishNode(node);
      }
      function parseFunctionExpression() {
        var saveDecoratorContext = inDecoratorContext();
        if (saveDecoratorContext) {
          setDecoratorContext(false);
        }
        var node = createNode(171);
        setModifiers(node, parseModifiers());
        parseExpected(85);
        node.asteriskToken = parseOptionalToken(37);
        var isGenerator = !!node.asteriskToken;
        var isAsync = !!(node.flags & 512);
        node.name = isGenerator && isAsync ? doInYieldAndAwaitContext(parseOptionalIdentifier) : isGenerator ? doInYieldContext(parseOptionalIdentifier) : isAsync ? doInAwaitContext(parseOptionalIdentifier) : parseOptionalIdentifier();
        fillSignature(53, isGenerator, isAsync, false, node);
        node.body = parseFunctionBlock(isGenerator, isAsync, false);
        if (saveDecoratorContext) {
          setDecoratorContext(true);
        }
        return finishNode(node);
      }
      function parseOptionalIdentifier() {
        return isIdentifier() ? parseIdentifier() : undefined;
      }
      function parseNewExpression() {
        var node = createNode(167);
        parseExpected(90);
        node.expression = parseMemberExpressionOrHigher();
        node.typeArguments = tryParse(parseTypeArgumentsInExpression);
        if (node.typeArguments || token === 17) {
          node.arguments = parseArgumentList();
        }
        return finishNode(node);
      }
      function parseBlock(ignoreMissingOpenBrace, diagnosticMessage) {
        var node = createNode(190);
        if (parseExpected(15, diagnosticMessage) || ignoreMissingOpenBrace) {
          node.statements = parseList(1, parseStatement);
          parseExpected(16);
        } else {
          node.statements = createMissingList();
        }
        return finishNode(node);
      }
      function parseFunctionBlock(allowYield, allowAwait, ignoreMissingOpenBrace, diagnosticMessage) {
        var savedYieldContext = inYieldContext();
        setYieldContext(allowYield);
        var savedAwaitContext = inAwaitContext();
        setAwaitContext(allowAwait);
        var saveDecoratorContext = inDecoratorContext();
        if (saveDecoratorContext) {
          setDecoratorContext(false);
        }
        var block = parseBlock(ignoreMissingOpenBrace, diagnosticMessage);
        if (saveDecoratorContext) {
          setDecoratorContext(true);
        }
        setYieldContext(savedYieldContext);
        setAwaitContext(savedAwaitContext);
        return block;
      }
      function parseEmptyStatement() {
        var node = createNode(192);
        parseExpected(23);
        return finishNode(node);
      }
      function parseIfStatement() {
        var node = createNode(194);
        parseExpected(86);
        parseExpected(17);
        node.expression = allowInAnd(parseExpression);
        parseExpected(18);
        node.thenStatement = parseStatement();
        node.elseStatement = parseOptional(78) ? parseStatement() : undefined;
        return finishNode(node);
      }
      function parseDoStatement() {
        var node = createNode(195);
        parseExpected(77);
        node.statement = parseStatement();
        parseExpected(102);
        parseExpected(17);
        node.expression = allowInAnd(parseExpression);
        parseExpected(18);
        parseOptional(23);
        return finishNode(node);
      }
      function parseWhileStatement() {
        var node = createNode(196);
        parseExpected(102);
        parseExpected(17);
        node.expression = allowInAnd(parseExpression);
        parseExpected(18);
        node.statement = parseStatement();
        return finishNode(node);
      }
      function parseForOrForInOrForOfStatement() {
        var pos = getNodePos();
        parseExpected(84);
        parseExpected(17);
        var initializer = undefined;
        if (token !== 23) {
          if (token === 100 || token === 106 || token === 72) {
            initializer = parseVariableDeclarationList(true);
          } else {
            initializer = disallowInAnd(parseExpression);
          }
        }
        var forOrForInOrForOfStatement;
        if (parseOptional(88)) {
          var forInStatement = createNode(198, pos);
          forInStatement.initializer = initializer;
          forInStatement.expression = allowInAnd(parseExpression);
          parseExpected(18);
          forOrForInOrForOfStatement = forInStatement;
        } else if (parseOptional(132)) {
          var forOfStatement = createNode(199, pos);
          forOfStatement.initializer = initializer;
          forOfStatement.expression = allowInAnd(parseAssignmentExpressionOrHigher);
          parseExpected(18);
          forOrForInOrForOfStatement = forOfStatement;
        } else {
          var forStatement = createNode(197, pos);
          forStatement.initializer = initializer;
          parseExpected(23);
          if (token !== 23 && token !== 18) {
            forStatement.condition = allowInAnd(parseExpression);
          }
          parseExpected(23);
          if (token !== 18) {
            forStatement.incrementor = allowInAnd(parseExpression);
          }
          parseExpected(18);
          forOrForInOrForOfStatement = forStatement;
        }
        forOrForInOrForOfStatement.statement = parseStatement();
        return finishNode(forOrForInOrForOfStatement);
      }
      function parseBreakOrContinueStatement(kind) {
        var node = createNode(kind);
        parseExpected(kind === 201 ? 68 : 73);
        if (!canParseSemicolon()) {
          node.label = parseIdentifier();
        }
        parseSemicolon();
        return finishNode(node);
      }
      function parseReturnStatement() {
        var node = createNode(202);
        parseExpected(92);
        if (!canParseSemicolon()) {
          node.expression = allowInAnd(parseExpression);
        }
        parseSemicolon();
        return finishNode(node);
      }
      function parseWithStatement() {
        var node = createNode(203);
        parseExpected(103);
        parseExpected(17);
        node.expression = allowInAnd(parseExpression);
        parseExpected(18);
        node.statement = parseStatement();
        return finishNode(node);
      }
      function parseCaseClause() {
        var node = createNode(239);
        parseExpected(69);
        node.expression = allowInAnd(parseExpression);
        parseExpected(53);
        node.statements = parseList(3, parseStatement);
        return finishNode(node);
      }
      function parseDefaultClause() {
        var node = createNode(240);
        parseExpected(75);
        parseExpected(53);
        node.statements = parseList(3, parseStatement);
        return finishNode(node);
      }
      function parseCaseOrDefaultClause() {
        return token === 69 ? parseCaseClause() : parseDefaultClause();
      }
      function parseSwitchStatement() {
        var node = createNode(204);
        parseExpected(94);
        parseExpected(17);
        node.expression = allowInAnd(parseExpression);
        parseExpected(18);
        var caseBlock = createNode(218, scanner.getStartPos());
        parseExpected(15);
        caseBlock.clauses = parseList(2, parseCaseOrDefaultClause);
        parseExpected(16);
        node.caseBlock = finishNode(caseBlock);
        return finishNode(node);
      }
      function parseThrowStatement() {
        var node = createNode(206);
        parseExpected(96);
        node.expression = scanner.hasPrecedingLineBreak() ? undefined : allowInAnd(parseExpression);
        parseSemicolon();
        return finishNode(node);
      }
      function parseTryStatement() {
        var node = createNode(207);
        parseExpected(98);
        node.tryBlock = parseBlock(false);
        node.catchClause = token === 70 ? parseCatchClause() : undefined;
        if (!node.catchClause || token === 83) {
          parseExpected(83);
          node.finallyBlock = parseBlock(false);
        }
        return finishNode(node);
      }
      function parseCatchClause() {
        var result = createNode(242);
        parseExpected(70);
        if (parseExpected(17)) {
          result.variableDeclaration = parseVariableDeclaration();
        }
        parseExpected(18);
        result.block = parseBlock(false);
        return finishNode(result);
      }
      function parseDebuggerStatement() {
        var node = createNode(208);
        parseExpected(74);
        parseSemicolon();
        return finishNode(node);
      }
      function parseExpressionOrLabeledStatement() {
        var fullStart = scanner.getStartPos();
        var expression = allowInAnd(parseExpression);
        if (expression.kind === 67 && parseOptional(53)) {
          var labeledStatement = createNode(205, fullStart);
          labeledStatement.label = expression;
          labeledStatement.statement = parseStatement();
          return finishNode(labeledStatement);
        } else {
          var expressionStatement = createNode(193, fullStart);
          expressionStatement.expression = expression;
          parseSemicolon();
          return finishNode(expressionStatement);
        }
      }
      function isIdentifierOrKeyword() {
        return token >= 67;
      }
      function nextTokenIsIdentifierOrKeywordOnSameLine() {
        nextToken();
        return isIdentifierOrKeyword() && !scanner.hasPrecedingLineBreak();
      }
      function nextTokenIsFunctionKeywordOnSameLine() {
        nextToken();
        return token === 85 && !scanner.hasPrecedingLineBreak();
      }
      function nextTokenIsIdentifierOrKeywordOrNumberOnSameLine() {
        nextToken();
        return (isIdentifierOrKeyword() || token === 8) && !scanner.hasPrecedingLineBreak();
      }
      function isDeclaration() {
        while (true) {
          switch (token) {
            case 100:
            case 106:
            case 72:
            case 85:
            case 71:
            case 79:
              return true;
            case 105:
            case 130:
              return nextTokenIsIdentifierOnSameLine();
            case 123:
            case 124:
              return nextTokenIsIdentifierOrStringLiteralOnSameLine();
            case 116:
            case 120:
              nextToken();
              if (scanner.hasPrecedingLineBreak()) {
                return false;
              }
              continue;
            case 87:
              nextToken();
              return token === 9 || token === 37 || token === 15 || isIdentifierOrKeyword();
            case 80:
              nextToken();
              if (token === 55 || token === 37 || token === 15 || token === 75) {
                return true;
              }
              continue;
            case 110:
            case 108:
            case 109:
            case 111:
            case 113:
              nextToken();
              continue;
            default:
              return false;
          }
        }
      }
      function isStartOfDeclaration() {
        return lookAhead(isDeclaration);
      }
      function isStartOfStatement() {
        switch (token) {
          case 54:
          case 23:
          case 15:
          case 100:
          case 106:
          case 85:
          case 71:
          case 79:
          case 86:
          case 77:
          case 102:
          case 84:
          case 73:
          case 68:
          case 92:
          case 103:
          case 94:
          case 96:
          case 98:
          case 74:
          case 70:
          case 83:
            return true;
          case 72:
          case 80:
          case 87:
            return isStartOfDeclaration();
          case 116:
          case 120:
          case 105:
          case 123:
          case 124:
          case 130:
            return true;
          case 110:
          case 108:
          case 109:
          case 111:
            return isStartOfDeclaration() || !lookAhead(nextTokenIsIdentifierOrKeywordOnSameLine);
          default:
            return isStartOfExpression();
        }
      }
      function nextTokenIsIdentifierOrStartOfDestructuring() {
        nextToken();
        return isIdentifier() || token === 15 || token === 19;
      }
      function isLetDeclaration() {
        return lookAhead(nextTokenIsIdentifierOrStartOfDestructuring);
      }
      function parseStatement() {
        switch (token) {
          case 23:
            return parseEmptyStatement();
          case 15:
            return parseBlock(false);
          case 100:
            return parseVariableStatement(scanner.getStartPos(), undefined, undefined);
          case 106:
            if (isLetDeclaration()) {
              return parseVariableStatement(scanner.getStartPos(), undefined, undefined);
            }
            break;
          case 85:
            return parseFunctionDeclaration(scanner.getStartPos(), undefined, undefined);
          case 71:
            return parseClassDeclaration(scanner.getStartPos(), undefined, undefined);
          case 86:
            return parseIfStatement();
          case 77:
            return parseDoStatement();
          case 102:
            return parseWhileStatement();
          case 84:
            return parseForOrForInOrForOfStatement();
          case 73:
            return parseBreakOrContinueStatement(200);
          case 68:
            return parseBreakOrContinueStatement(201);
          case 92:
            return parseReturnStatement();
          case 103:
            return parseWithStatement();
          case 94:
            return parseSwitchStatement();
          case 96:
            return parseThrowStatement();
          case 98:
          case 70:
          case 83:
            return parseTryStatement();
          case 74:
            return parseDebuggerStatement();
          case 54:
            return parseDeclaration();
          case 116:
          case 105:
          case 130:
          case 123:
          case 124:
          case 120:
          case 72:
          case 79:
          case 80:
          case 87:
          case 108:
          case 109:
          case 110:
          case 113:
          case 111:
            if (isStartOfDeclaration()) {
              return parseDeclaration();
            }
            break;
        }
        return parseExpressionOrLabeledStatement();
      }
      function parseDeclaration() {
        var fullStart = getNodePos();
        var decorators = parseDecorators();
        var modifiers = parseModifiers();
        switch (token) {
          case 100:
          case 106:
          case 72:
            return parseVariableStatement(fullStart, decorators, modifiers);
          case 85:
            return parseFunctionDeclaration(fullStart, decorators, modifiers);
          case 71:
            return parseClassDeclaration(fullStart, decorators, modifiers);
          case 105:
            return parseInterfaceDeclaration(fullStart, decorators, modifiers);
          case 130:
            return parseTypeAliasDeclaration(fullStart, decorators, modifiers);
          case 79:
            return parseEnumDeclaration(fullStart, decorators, modifiers);
          case 123:
          case 124:
            return parseModuleDeclaration(fullStart, decorators, modifiers);
          case 87:
            return parseImportDeclarationOrImportEqualsDeclaration(fullStart, decorators, modifiers);
          case 80:
            nextToken();
            return token === 75 || token === 55 ? parseExportAssignment(fullStart, decorators, modifiers) : parseExportDeclaration(fullStart, decorators, modifiers);
          default:
            if (decorators || modifiers) {
              var node = createMissingNode(229, true, ts.Diagnostics.Declaration_expected);
              node.pos = fullStart;
              node.decorators = decorators;
              setModifiers(node, modifiers);
              return finishNode(node);
            }
        }
      }
      function nextTokenIsIdentifierOrStringLiteralOnSameLine() {
        nextToken();
        return !scanner.hasPrecedingLineBreak() && (isIdentifier() || token === 9);
      }
      function parseFunctionBlockOrSemicolon(isGenerator, isAsync, diagnosticMessage) {
        if (token !== 15 && canParseSemicolon()) {
          parseSemicolon();
          return;
        }
        return parseFunctionBlock(isGenerator, isAsync, false, diagnosticMessage);
      }
      function parseArrayBindingElement() {
        if (token === 24) {
          return createNode(185);
        }
        var node = createNode(161);
        node.dotDotDotToken = parseOptionalToken(22);
        node.name = parseIdentifierOrPattern();
        node.initializer = parseBindingElementInitializer(false);
        return finishNode(node);
      }
      function parseObjectBindingElement() {
        var node = createNode(161);
        var tokenIsIdentifier = isIdentifier();
        var propertyName = parsePropertyName();
        if (tokenIsIdentifier && token !== 53) {
          node.name = propertyName;
        } else {
          parseExpected(53);
          node.propertyName = propertyName;
          node.name = parseIdentifierOrPattern();
        }
        node.initializer = parseBindingElementInitializer(false);
        return finishNode(node);
      }
      function parseObjectBindingPattern() {
        var node = createNode(159);
        parseExpected(15);
        node.elements = parseDelimitedList(9, parseObjectBindingElement);
        parseExpected(16);
        return finishNode(node);
      }
      function parseArrayBindingPattern() {
        var node = createNode(160);
        parseExpected(19);
        node.elements = parseDelimitedList(10, parseArrayBindingElement);
        parseExpected(20);
        return finishNode(node);
      }
      function isIdentifierOrPattern() {
        return token === 15 || token === 19 || isIdentifier();
      }
      function parseIdentifierOrPattern() {
        if (token === 19) {
          return parseArrayBindingPattern();
        }
        if (token === 15) {
          return parseObjectBindingPattern();
        }
        return parseIdentifier();
      }
      function parseVariableDeclaration() {
        var node = createNode(209);
        node.name = parseIdentifierOrPattern();
        node.type = parseTypeAnnotation();
        if (!isInOrOfKeyword(token)) {
          node.initializer = parseInitializer(false);
        }
        return finishNode(node);
      }
      function parseVariableDeclarationList(inForStatementInitializer) {
        var node = createNode(210);
        switch (token) {
          case 100:
            break;
          case 106:
            node.flags |= 16384;
            break;
          case 72:
            node.flags |= 32768;
            break;
          default:
            ts.Debug.fail();
        }
        nextToken();
        if (token === 132 && lookAhead(canFollowContextualOfKeyword)) {
          node.declarations = createMissingList();
        } else {
          var savedDisallowIn = inDisallowInContext();
          setDisallowInContext(inForStatementInitializer);
          node.declarations = parseDelimitedList(8, parseVariableDeclaration);
          setDisallowInContext(savedDisallowIn);
        }
        return finishNode(node);
      }
      function canFollowContextualOfKeyword() {
        return nextTokenIsIdentifier() && nextToken() === 18;
      }
      function parseVariableStatement(fullStart, decorators, modifiers) {
        var node = createNode(191, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        node.declarationList = parseVariableDeclarationList(false);
        parseSemicolon();
        return finishNode(node);
      }
      function parseFunctionDeclaration(fullStart, decorators, modifiers) {
        var node = createNode(211, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        parseExpected(85);
        node.asteriskToken = parseOptionalToken(37);
        node.name = node.flags & 1024 ? parseOptionalIdentifier() : parseIdentifier();
        var isGenerator = !!node.asteriskToken;
        var isAsync = !!(node.flags & 512);
        fillSignature(53, isGenerator, isAsync, false, node);
        node.body = parseFunctionBlockOrSemicolon(isGenerator, isAsync, ts.Diagnostics.or_expected);
        return finishNode(node);
      }
      function parseConstructorDeclaration(pos, decorators, modifiers) {
        var node = createNode(142, pos);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        parseExpected(119);
        fillSignature(53, false, false, false, node);
        node.body = parseFunctionBlockOrSemicolon(false, false, ts.Diagnostics.or_expected);
        return finishNode(node);
      }
      function parseMethodDeclaration(fullStart, decorators, modifiers, asteriskToken, name, questionToken, diagnosticMessage) {
        var method = createNode(141, fullStart);
        method.decorators = decorators;
        setModifiers(method, modifiers);
        method.asteriskToken = asteriskToken;
        method.name = name;
        method.questionToken = questionToken;
        var isGenerator = !!asteriskToken;
        var isAsync = !!(method.flags & 512);
        fillSignature(53, isGenerator, isAsync, false, method);
        method.body = parseFunctionBlockOrSemicolon(isGenerator, isAsync, diagnosticMessage);
        return finishNode(method);
      }
      function parsePropertyDeclaration(fullStart, decorators, modifiers, name, questionToken) {
        var property = createNode(139, fullStart);
        property.decorators = decorators;
        setModifiers(property, modifiers);
        property.name = name;
        property.questionToken = questionToken;
        property.type = parseTypeAnnotation();
        property.initializer = modifiers && modifiers.flags & 128 ? allowInAnd(parseNonParameterInitializer) : doOutsideOfContext(2 | 1, parseNonParameterInitializer);
        parseSemicolon();
        return finishNode(property);
      }
      function parsePropertyOrMethodDeclaration(fullStart, decorators, modifiers) {
        var asteriskToken = parseOptionalToken(37);
        var name = parsePropertyName();
        var questionToken = parseOptionalToken(52);
        if (asteriskToken || token === 17 || token === 25) {
          return parseMethodDeclaration(fullStart, decorators, modifiers, asteriskToken, name, questionToken, ts.Diagnostics.or_expected);
        } else {
          return parsePropertyDeclaration(fullStart, decorators, modifiers, name, questionToken);
        }
      }
      function parseNonParameterInitializer() {
        return parseInitializer(false);
      }
      function parseAccessorDeclaration(kind, fullStart, decorators, modifiers) {
        var node = createNode(kind, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        node.name = parsePropertyName();
        fillSignature(53, false, false, false, node);
        node.body = parseFunctionBlockOrSemicolon(false, false);
        return finishNode(node);
      }
      function isClassMemberModifier(idToken) {
        switch (idToken) {
          case 110:
          case 108:
          case 109:
          case 111:
            return true;
          default:
            return false;
        }
      }
      function isClassMemberStart() {
        var idToken;
        if (token === 54) {
          return true;
        }
        while (ts.isModifier(token)) {
          idToken = token;
          if (isClassMemberModifier(idToken)) {
            return true;
          }
          nextToken();
        }
        if (token === 37) {
          return true;
        }
        if (isLiteralPropertyName()) {
          idToken = token;
          nextToken();
        }
        if (token === 19) {
          return true;
        }
        if (idToken !== undefined) {
          if (!ts.isKeyword(idToken) || idToken === 127 || idToken === 121) {
            return true;
          }
          switch (token) {
            case 17:
            case 25:
            case 53:
            case 55:
            case 52:
              return true;
            default:
              return canParseSemicolon();
          }
        }
        return false;
      }
      function parseDecorators() {
        var decorators;
        while (true) {
          var decoratorStart = getNodePos();
          if (!parseOptional(54)) {
            break;
          }
          if (!decorators) {
            decorators = [];
            decorators.pos = scanner.getStartPos();
          }
          var decorator = createNode(137, decoratorStart);
          decorator.expression = doInDecoratorContext(parseLeftHandSideExpressionOrHigher);
          decorators.push(finishNode(decorator));
        }
        if (decorators) {
          decorators.end = getNodeEnd();
        }
        return decorators;
      }
      function parseModifiers() {
        var flags = 0;
        var modifiers;
        while (true) {
          var modifierStart = scanner.getStartPos();
          var modifierKind = token;
          if (!parseAnyContextualModifier()) {
            break;
          }
          if (!modifiers) {
            modifiers = [];
            modifiers.pos = modifierStart;
          }
          flags |= ts.modifierToFlag(modifierKind);
          modifiers.push(finishNode(createNode(modifierKind, modifierStart)));
        }
        if (modifiers) {
          modifiers.flags = flags;
          modifiers.end = scanner.getStartPos();
        }
        return modifiers;
      }
      function parseModifiersForArrowFunction() {
        var flags = 0;
        var modifiers;
        if (token === 116) {
          var modifierStart = scanner.getStartPos();
          var modifierKind = token;
          nextToken();
          modifiers = [];
          modifiers.pos = modifierStart;
          flags |= ts.modifierToFlag(modifierKind);
          modifiers.push(finishNode(createNode(modifierKind, modifierStart)));
          modifiers.flags = flags;
          modifiers.end = scanner.getStartPos();
        }
        return modifiers;
      }
      function parseClassElement() {
        if (token === 23) {
          var result = createNode(189);
          nextToken();
          return finishNode(result);
        }
        var fullStart = getNodePos();
        var decorators = parseDecorators();
        var modifiers = parseModifiers();
        var accessor = tryParseAccessorDeclaration(fullStart, decorators, modifiers);
        if (accessor) {
          return accessor;
        }
        if (token === 119) {
          return parseConstructorDeclaration(fullStart, decorators, modifiers);
        }
        if (isIndexSignature()) {
          return parseIndexSignatureDeclaration(fullStart, decorators, modifiers);
        }
        if (isIdentifierOrKeyword() || token === 9 || token === 8 || token === 37 || token === 19) {
          return parsePropertyOrMethodDeclaration(fullStart, decorators, modifiers);
        }
        if (decorators || modifiers) {
          var name_7 = createMissingNode(67, true, ts.Diagnostics.Declaration_expected);
          return parsePropertyDeclaration(fullStart, decorators, modifiers, name_7, undefined);
        }
        ts.Debug.fail("Should not have attempted to parse class member declaration.");
      }
      function parseClassExpression() {
        return parseClassDeclarationOrExpression(scanner.getStartPos(), undefined, undefined, 184);
      }
      function parseClassDeclaration(fullStart, decorators, modifiers) {
        return parseClassDeclarationOrExpression(fullStart, decorators, modifiers, 212);
      }
      function parseClassDeclarationOrExpression(fullStart, decorators, modifiers, kind) {
        var node = createNode(kind, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        parseExpected(71);
        node.name = parseOptionalIdentifier();
        node.typeParameters = parseTypeParameters();
        node.heritageClauses = parseHeritageClauses(true);
        if (parseExpected(15)) {
          node.members = parseClassMembers();
          parseExpected(16);
        } else {
          node.members = createMissingList();
        }
        return finishNode(node);
      }
      function parseHeritageClauses(isClassHeritageClause) {
        if (isHeritageClause()) {
          return parseList(20, parseHeritageClause);
        }
        return undefined;
      }
      function parseHeritageClausesWorker() {
        return parseList(20, parseHeritageClause);
      }
      function parseHeritageClause() {
        if (token === 81 || token === 104) {
          var node = createNode(241);
          node.token = token;
          nextToken();
          node.types = parseDelimitedList(7, parseExpressionWithTypeArguments);
          return finishNode(node);
        }
        return undefined;
      }
      function parseExpressionWithTypeArguments() {
        var node = createNode(186);
        node.expression = parseLeftHandSideExpressionOrHigher();
        if (token === 25) {
          node.typeArguments = parseBracketedList(18, parseType, 25, 27);
        }
        return finishNode(node);
      }
      function isHeritageClause() {
        return token === 81 || token === 104;
      }
      function parseClassMembers() {
        return parseList(5, parseClassElement);
      }
      function parseInterfaceDeclaration(fullStart, decorators, modifiers) {
        var node = createNode(213, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        parseExpected(105);
        node.name = parseIdentifier();
        node.typeParameters = parseTypeParameters();
        node.heritageClauses = parseHeritageClauses(false);
        node.members = parseObjectTypeMembers();
        return finishNode(node);
      }
      function parseTypeAliasDeclaration(fullStart, decorators, modifiers) {
        var node = createNode(214, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        parseExpected(130);
        node.name = parseIdentifier();
        node.typeParameters = parseTypeParameters();
        parseExpected(55);
        node.type = parseType();
        parseSemicolon();
        return finishNode(node);
      }
      function parseEnumMember() {
        var node = createNode(245, scanner.getStartPos());
        node.name = parsePropertyName();
        node.initializer = allowInAnd(parseNonParameterInitializer);
        return finishNode(node);
      }
      function parseEnumDeclaration(fullStart, decorators, modifiers) {
        var node = createNode(215, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        parseExpected(79);
        node.name = parseIdentifier();
        if (parseExpected(15)) {
          node.members = parseDelimitedList(6, parseEnumMember);
          parseExpected(16);
        } else {
          node.members = createMissingList();
        }
        return finishNode(node);
      }
      function parseModuleBlock() {
        var node = createNode(217, scanner.getStartPos());
        if (parseExpected(15)) {
          node.statements = parseList(1, parseStatement);
          parseExpected(16);
        } else {
          node.statements = createMissingList();
        }
        return finishNode(node);
      }
      function parseModuleOrNamespaceDeclaration(fullStart, decorators, modifiers, flags) {
        var node = createNode(216, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        node.flags |= flags;
        node.name = parseIdentifier();
        node.body = parseOptional(21) ? parseModuleOrNamespaceDeclaration(getNodePos(), undefined, undefined, 1) : parseModuleBlock();
        return finishNode(node);
      }
      function parseAmbientExternalModuleDeclaration(fullStart, decorators, modifiers) {
        var node = createNode(216, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        node.name = parseLiteralNode(true);
        node.body = parseModuleBlock();
        return finishNode(node);
      }
      function parseModuleDeclaration(fullStart, decorators, modifiers) {
        var flags = modifiers ? modifiers.flags : 0;
        if (parseOptional(124)) {
          flags |= 131072;
        } else {
          parseExpected(123);
          if (token === 9) {
            return parseAmbientExternalModuleDeclaration(fullStart, decorators, modifiers);
          }
        }
        return parseModuleOrNamespaceDeclaration(fullStart, decorators, modifiers, flags);
      }
      function isExternalModuleReference() {
        return token === 125 && lookAhead(nextTokenIsOpenParen);
      }
      function nextTokenIsOpenParen() {
        return nextToken() === 17;
      }
      function nextTokenIsSlash() {
        return nextToken() === 38;
      }
      function nextTokenIsCommaOrFromKeyword() {
        nextToken();
        return token === 24 || token === 131;
      }
      function parseImportDeclarationOrImportEqualsDeclaration(fullStart, decorators, modifiers) {
        parseExpected(87);
        var afterImportPos = scanner.getStartPos();
        var identifier;
        if (isIdentifier()) {
          identifier = parseIdentifier();
          if (token !== 24 && token !== 131) {
            var importEqualsDeclaration = createNode(219, fullStart);
            importEqualsDeclaration.decorators = decorators;
            setModifiers(importEqualsDeclaration, modifiers);
            importEqualsDeclaration.name = identifier;
            parseExpected(55);
            importEqualsDeclaration.moduleReference = parseModuleReference();
            parseSemicolon();
            return finishNode(importEqualsDeclaration);
          }
        }
        var importDeclaration = createNode(220, fullStart);
        importDeclaration.decorators = decorators;
        setModifiers(importDeclaration, modifiers);
        if (identifier || token === 37 || token === 15) {
          importDeclaration.importClause = parseImportClause(identifier, afterImportPos);
          parseExpected(131);
        }
        importDeclaration.moduleSpecifier = parseModuleSpecifier();
        parseSemicolon();
        return finishNode(importDeclaration);
      }
      function parseImportClause(identifier, fullStart) {
        var importClause = createNode(221, fullStart);
        if (identifier) {
          importClause.name = identifier;
        }
        if (!importClause.name || parseOptional(24)) {
          importClause.namedBindings = token === 37 ? parseNamespaceImport() : parseNamedImportsOrExports(223);
        }
        return finishNode(importClause);
      }
      function parseModuleReference() {
        return isExternalModuleReference() ? parseExternalModuleReference() : parseEntityName(false);
      }
      function parseExternalModuleReference() {
        var node = createNode(230);
        parseExpected(125);
        parseExpected(17);
        node.expression = parseModuleSpecifier();
        parseExpected(18);
        return finishNode(node);
      }
      function parseModuleSpecifier() {
        var result = parseExpression();
        if (result.kind === 9) {
          internIdentifier(result.text);
        }
        return result;
      }
      function parseNamespaceImport() {
        var namespaceImport = createNode(222);
        parseExpected(37);
        parseExpected(114);
        namespaceImport.name = parseIdentifier();
        return finishNode(namespaceImport);
      }
      function parseNamedImportsOrExports(kind) {
        var node = createNode(kind);
        node.elements = parseBracketedList(21, kind === 223 ? parseImportSpecifier : parseExportSpecifier, 15, 16);
        return finishNode(node);
      }
      function parseExportSpecifier() {
        return parseImportOrExportSpecifier(228);
      }
      function parseImportSpecifier() {
        return parseImportOrExportSpecifier(224);
      }
      function parseImportOrExportSpecifier(kind) {
        var node = createNode(kind);
        var checkIdentifierIsKeyword = ts.isKeyword(token) && !isIdentifier();
        var checkIdentifierStart = scanner.getTokenPos();
        var checkIdentifierEnd = scanner.getTextPos();
        var identifierName = parseIdentifierName();
        if (token === 114) {
          node.propertyName = identifierName;
          parseExpected(114);
          checkIdentifierIsKeyword = ts.isKeyword(token) && !isIdentifier();
          checkIdentifierStart = scanner.getTokenPos();
          checkIdentifierEnd = scanner.getTextPos();
          node.name = parseIdentifierName();
        } else {
          node.name = identifierName;
        }
        if (kind === 224 && checkIdentifierIsKeyword) {
          parseErrorAtPosition(checkIdentifierStart, checkIdentifierEnd - checkIdentifierStart, ts.Diagnostics.Identifier_expected);
        }
        return finishNode(node);
      }
      function parseExportDeclaration(fullStart, decorators, modifiers) {
        var node = createNode(226, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        if (parseOptional(37)) {
          parseExpected(131);
          node.moduleSpecifier = parseModuleSpecifier();
        } else {
          node.exportClause = parseNamedImportsOrExports(227);
          if (token === 131 || (token === 9 && !scanner.hasPrecedingLineBreak())) {
            parseExpected(131);
            node.moduleSpecifier = parseModuleSpecifier();
          }
        }
        parseSemicolon();
        return finishNode(node);
      }
      function parseExportAssignment(fullStart, decorators, modifiers) {
        var node = createNode(225, fullStart);
        node.decorators = decorators;
        setModifiers(node, modifiers);
        if (parseOptional(55)) {
          node.isExportEquals = true;
        } else {
          parseExpected(75);
        }
        node.expression = parseAssignmentExpressionOrHigher();
        parseSemicolon();
        return finishNode(node);
      }
      function processReferenceComments(sourceFile) {
        var triviaScanner = ts.createScanner(sourceFile.languageVersion, false, 0, sourceText);
        var referencedFiles = [];
        var amdDependencies = [];
        var amdModuleName;
        while (true) {
          var kind = triviaScanner.scan();
          if (kind === 5 || kind === 4 || kind === 3) {
            continue;
          }
          if (kind !== 2) {
            break;
          }
          var range = {
            pos: triviaScanner.getTokenPos(),
            end: triviaScanner.getTextPos(),
            kind: triviaScanner.getToken()
          };
          var comment = sourceText.substring(range.pos, range.end);
          var referencePathMatchResult = ts.getFileReferenceFromReferencePath(comment, range);
          if (referencePathMatchResult) {
            var fileReference = referencePathMatchResult.fileReference;
            sourceFile.hasNoDefaultLib = referencePathMatchResult.isNoDefaultLib;
            var diagnosticMessage = referencePathMatchResult.diagnosticMessage;
            if (fileReference) {
              referencedFiles.push(fileReference);
            }
            if (diagnosticMessage) {
              parseDiagnostics.push(ts.createFileDiagnostic(sourceFile, range.pos, range.end - range.pos, diagnosticMessage));
            }
          } else {
            var amdModuleNameRegEx = /^\/\/\/\s*<amd-module\s+name\s*=\s*('|")(.+?)\1/gim;
            var amdModuleNameMatchResult = amdModuleNameRegEx.exec(comment);
            if (amdModuleNameMatchResult) {
              if (amdModuleName) {
                parseDiagnostics.push(ts.createFileDiagnostic(sourceFile, range.pos, range.end - range.pos, ts.Diagnostics.An_AMD_module_cannot_have_multiple_name_assignments));
              }
              amdModuleName = amdModuleNameMatchResult[2];
            }
            var amdDependencyRegEx = /^\/\/\/\s*<amd-dependency\s/gim;
            var pathRegex = /\spath\s*=\s*('|")(.+?)\1/gim;
            var nameRegex = /\sname\s*=\s*('|")(.+?)\1/gim;
            var amdDependencyMatchResult = amdDependencyRegEx.exec(comment);
            if (amdDependencyMatchResult) {
              var pathMatchResult = pathRegex.exec(comment);
              var nameMatchResult = nameRegex.exec(comment);
              if (pathMatchResult) {
                var amdDependency = {
                  path: pathMatchResult[2],
                  name: nameMatchResult ? nameMatchResult[2] : undefined
                };
                amdDependencies.push(amdDependency);
              }
            }
          }
        }
        sourceFile.referencedFiles = referencedFiles;
        sourceFile.amdDependencies = amdDependencies;
        sourceFile.moduleName = amdModuleName;
      }
      function setExternalModuleIndicator(sourceFile) {
        sourceFile.externalModuleIndicator = ts.forEach(sourceFile.statements, function(node) {
          return node.flags & 1 || node.kind === 219 && node.moduleReference.kind === 230 || node.kind === 220 || node.kind === 225 || node.kind === 226 ? node : undefined;
        });
      }
      var JSDocParser;
      (function(JSDocParser) {
        function isJSDocType() {
          switch (token) {
            case 37:
            case 52:
            case 17:
            case 19:
            case 48:
            case 15:
            case 85:
            case 22:
            case 90:
            case 95:
              return true;
          }
          return isIdentifierOrKeyword();
        }
        JSDocParser.isJSDocType = isJSDocType;
        function parseJSDocTypeExpressionForTests(content, start, length) {
          initializeState("file.js", content, 2, undefined);
          var jsDocTypeExpression = parseJSDocTypeExpression(start, length);
          var diagnostics = parseDiagnostics;
          clearState();
          return jsDocTypeExpression ? {
            jsDocTypeExpression: jsDocTypeExpression,
            diagnostics: diagnostics
          } : undefined;
        }
        JSDocParser.parseJSDocTypeExpressionForTests = parseJSDocTypeExpressionForTests;
        function parseJSDocTypeExpression(start, length) {
          scanner.setText(sourceText, start, length);
          token = nextToken();
          var result = createNode(247);
          parseExpected(15);
          result.type = parseJSDocTopLevelType();
          parseExpected(16);
          fixupParentReferences(result);
          return finishNode(result);
        }
        JSDocParser.parseJSDocTypeExpression = parseJSDocTypeExpression;
        function parseJSDocTopLevelType() {
          var type = parseJSDocType();
          if (token === 46) {
            var unionType = createNode(251, type.pos);
            unionType.types = parseJSDocTypeList(type);
            type = finishNode(unionType);
          }
          if (token === 55) {
            var optionalType = createNode(258, type.pos);
            nextToken();
            optionalType.type = type;
            type = finishNode(optionalType);
          }
          return type;
        }
        function parseJSDocType() {
          var type = parseBasicTypeExpression();
          while (true) {
            if (token === 19) {
              var arrayType = createNode(250, type.pos);
              arrayType.elementType = type;
              nextToken();
              parseExpected(20);
              type = finishNode(arrayType);
            } else if (token === 52) {
              var nullableType = createNode(253, type.pos);
              nullableType.type = type;
              nextToken();
              type = finishNode(nullableType);
            } else if (token === 48) {
              var nonNullableType = createNode(254, type.pos);
              nonNullableType.type = type;
              nextToken();
              type = finishNode(nonNullableType);
            } else {
              break;
            }
          }
          return type;
        }
        function parseBasicTypeExpression() {
          switch (token) {
            case 37:
              return parseJSDocAllType();
            case 52:
              return parseJSDocUnknownOrNullableType();
            case 17:
              return parseJSDocUnionType();
            case 19:
              return parseJSDocTupleType();
            case 48:
              return parseJSDocNonNullableType();
            case 15:
              return parseJSDocRecordType();
            case 85:
              return parseJSDocFunctionType();
            case 22:
              return parseJSDocVariadicType();
            case 90:
              return parseJSDocConstructorType();
            case 95:
              return parseJSDocThisType();
            case 115:
            case 128:
            case 126:
            case 118:
            case 129:
            case 101:
              return parseTokenNode();
          }
          return parseJSDocTypeReference();
        }
        function parseJSDocThisType() {
          var result = createNode(262);
          nextToken();
          parseExpected(53);
          result.type = parseJSDocType();
          return finishNode(result);
        }
        function parseJSDocConstructorType() {
          var result = createNode(261);
          nextToken();
          parseExpected(53);
          result.type = parseJSDocType();
          return finishNode(result);
        }
        function parseJSDocVariadicType() {
          var result = createNode(260);
          nextToken();
          result.type = parseJSDocType();
          return finishNode(result);
        }
        function parseJSDocFunctionType() {
          var result = createNode(259);
          nextToken();
          parseExpected(17);
          result.parameters = parseDelimitedList(22, parseJSDocParameter);
          checkForTrailingComma(result.parameters);
          parseExpected(18);
          if (token === 53) {
            nextToken();
            result.type = parseJSDocType();
          }
          return finishNode(result);
        }
        function parseJSDocParameter() {
          var parameter = createNode(136);
          parameter.type = parseJSDocType();
          return finishNode(parameter);
        }
        function parseJSDocOptionalType(type) {
          var result = createNode(258, type.pos);
          nextToken();
          result.type = type;
          return finishNode(result);
        }
        function parseJSDocTypeReference() {
          var result = createNode(257);
          result.name = parseSimplePropertyName();
          while (parseOptional(21)) {
            if (token === 25) {
              result.typeArguments = parseTypeArguments();
              break;
            } else {
              result.name = parseQualifiedName(result.name);
            }
          }
          return finishNode(result);
        }
        function parseTypeArguments() {
          nextToken();
          var typeArguments = parseDelimitedList(23, parseJSDocType);
          checkForTrailingComma(typeArguments);
          checkForEmptyTypeArgumentList(typeArguments);
          parseExpected(27);
          return typeArguments;
        }
        function checkForEmptyTypeArgumentList(typeArguments) {
          if (parseDiagnostics.length === 0 && typeArguments && typeArguments.length === 0) {
            var start = typeArguments.pos - "<".length;
            var end = ts.skipTrivia(sourceText, typeArguments.end) + ">".length;
            return parseErrorAtPosition(start, end - start, ts.Diagnostics.Type_argument_list_cannot_be_empty);
          }
        }
        function parseQualifiedName(left) {
          var result = createNode(133, left.pos);
          result.left = left;
          result.right = parseIdentifierName();
          return finishNode(result);
        }
        function parseJSDocRecordType() {
          var result = createNode(255);
          nextToken();
          result.members = parseDelimitedList(24, parseJSDocRecordMember);
          checkForTrailingComma(result.members);
          parseExpected(16);
          return finishNode(result);
        }
        function parseJSDocRecordMember() {
          var result = createNode(256);
          result.name = parseSimplePropertyName();
          if (token === 53) {
            nextToken();
            result.type = parseJSDocType();
          }
          return finishNode(result);
        }
        function parseJSDocNonNullableType() {
          var result = createNode(254);
          nextToken();
          result.type = parseJSDocType();
          return finishNode(result);
        }
        function parseJSDocTupleType() {
          var result = createNode(252);
          nextToken();
          result.types = parseDelimitedList(25, parseJSDocType);
          checkForTrailingComma(result.types);
          parseExpected(20);
          return finishNode(result);
        }
        function checkForTrailingComma(list) {
          if (parseDiagnostics.length === 0 && list.hasTrailingComma) {
            var start = list.end - ",".length;
            parseErrorAtPosition(start, ",".length, ts.Diagnostics.Trailing_comma_not_allowed);
          }
        }
        function parseJSDocUnionType() {
          var result = createNode(251);
          nextToken();
          result.types = parseJSDocTypeList(parseJSDocType());
          parseExpected(18);
          return finishNode(result);
        }
        function parseJSDocTypeList(firstType) {
          ts.Debug.assert(!!firstType);
          var types = [];
          types.pos = firstType.pos;
          types.push(firstType);
          while (parseOptional(46)) {
            types.push(parseJSDocType());
          }
          types.end = scanner.getStartPos();
          return types;
        }
        function parseJSDocAllType() {
          var result = createNode(248);
          nextToken();
          return finishNode(result);
        }
        function parseJSDocUnknownOrNullableType() {
          var pos = scanner.getStartPos();
          nextToken();
          if (token === 24 || token === 16 || token === 18 || token === 27 || token === 55 || token === 46) {
            var result = createNode(249, pos);
            return finishNode(result);
          } else {
            var result = createNode(253, pos);
            result.type = parseJSDocType();
            return finishNode(result);
          }
        }
        function parseIsolatedJSDocComment(content, start, length) {
          initializeState("file.js", content, 2, undefined);
          var jsDocComment = parseJSDocComment(undefined, start, length);
          var diagnostics = parseDiagnostics;
          clearState();
          return jsDocComment ? {
            jsDocComment: jsDocComment,
            diagnostics: diagnostics
          } : undefined;
        }
        JSDocParser.parseIsolatedJSDocComment = parseIsolatedJSDocComment;
        function parseJSDocComment(parent, start, length) {
          var comment = parseJSDocCommentWorker(start, length);
          if (comment) {
            fixupParentReferences(comment);
            comment.parent = parent;
          }
          return comment;
        }
        JSDocParser.parseJSDocComment = parseJSDocComment;
        function parseJSDocCommentWorker(start, length) {
          var content = sourceText;
          start = start || 0;
          var end = length === undefined ? content.length : start + length;
          length = end - start;
          ts.Debug.assert(start >= 0);
          ts.Debug.assert(start <= end);
          ts.Debug.assert(end <= content.length);
          var tags;
          var pos;
          if (length >= "/** */".length) {
            if (content.charCodeAt(start) === 47 && content.charCodeAt(start + 1) === 42 && content.charCodeAt(start + 2) === 42 && content.charCodeAt(start + 3) !== 42) {
              var canParseTag = true;
              var seenAsterisk = true;
              for (pos = start + "/**".length; pos < end; ) {
                var ch = content.charCodeAt(pos);
                pos++;
                if (ch === 64 && canParseTag) {
                  parseTag();
                  canParseTag = false;
                  continue;
                }
                if (ts.isLineBreak(ch)) {
                  canParseTag = true;
                  seenAsterisk = false;
                  continue;
                }
                if (ts.isWhiteSpace(ch)) {
                  continue;
                }
                if (ch === 42) {
                  if (seenAsterisk) {
                    canParseTag = false;
                  }
                  seenAsterisk = true;
                  continue;
                }
                canParseTag = false;
              }
            }
          }
          return createJSDocComment();
          function createJSDocComment() {
            if (!tags) {
              return undefined;
            }
            var result = createNode(263, start);
            result.tags = tags;
            return finishNode(result, end);
          }
          function skipWhitespace() {
            while (pos < end && ts.isWhiteSpace(content.charCodeAt(pos))) {
              pos++;
            }
          }
          function parseTag() {
            ts.Debug.assert(content.charCodeAt(pos - 1) === 64);
            var atToken = createNode(54, pos - 1);
            atToken.end = pos;
            var tagName = scanIdentifier();
            if (!tagName) {
              return;
            }
            var tag = handleTag(atToken, tagName) || handleUnknownTag(atToken, tagName);
            addTag(tag);
          }
          function handleTag(atToken, tagName) {
            if (tagName) {
              switch (tagName.text) {
                case "param":
                  return handleParamTag(atToken, tagName);
                case "return":
                case "returns":
                  return handleReturnTag(atToken, tagName);
                case "template":
                  return handleTemplateTag(atToken, tagName);
                case "type":
                  return handleTypeTag(atToken, tagName);
              }
            }
            return undefined;
          }
          function handleUnknownTag(atToken, tagName) {
            var result = createNode(264, atToken.pos);
            result.atToken = atToken;
            result.tagName = tagName;
            return finishNode(result, pos);
          }
          function addTag(tag) {
            if (tag) {
              if (!tags) {
                tags = [];
                tags.pos = tag.pos;
              }
              tags.push(tag);
              tags.end = tag.end;
            }
          }
          function tryParseTypeExpression() {
            skipWhitespace();
            if (content.charCodeAt(pos) !== 123) {
              return undefined;
            }
            var typeExpression = parseJSDocTypeExpression(pos, end - pos);
            pos = typeExpression.end;
            return typeExpression;
          }
          function handleParamTag(atToken, tagName) {
            var typeExpression = tryParseTypeExpression();
            skipWhitespace();
            var name;
            var isBracketed;
            if (content.charCodeAt(pos) === 91) {
              pos++;
              skipWhitespace();
              name = scanIdentifier();
              isBracketed = true;
            } else {
              name = scanIdentifier();
            }
            if (!name) {
              parseErrorAtPosition(pos, 0, ts.Diagnostics.Identifier_expected);
            }
            var preName,
                postName;
            if (typeExpression) {
              postName = name;
            } else {
              preName = name;
            }
            if (!typeExpression) {
              typeExpression = tryParseTypeExpression();
            }
            var result = createNode(265, atToken.pos);
            result.atToken = atToken;
            result.tagName = tagName;
            result.preParameterName = preName;
            result.typeExpression = typeExpression;
            result.postParameterName = postName;
            result.isBracketed = isBracketed;
            return finishNode(result, pos);
          }
          function handleReturnTag(atToken, tagName) {
            if (ts.forEach(tags, function(t) {
              return t.kind === 266;
            })) {
              parseErrorAtPosition(tagName.pos, pos - tagName.pos, ts.Diagnostics._0_tag_already_specified, tagName.text);
            }
            var result = createNode(266, atToken.pos);
            result.atToken = atToken;
            result.tagName = tagName;
            result.typeExpression = tryParseTypeExpression();
            return finishNode(result, pos);
          }
          function handleTypeTag(atToken, tagName) {
            if (ts.forEach(tags, function(t) {
              return t.kind === 267;
            })) {
              parseErrorAtPosition(tagName.pos, pos - tagName.pos, ts.Diagnostics._0_tag_already_specified, tagName.text);
            }
            var result = createNode(267, atToken.pos);
            result.atToken = atToken;
            result.tagName = tagName;
            result.typeExpression = tryParseTypeExpression();
            return finishNode(result, pos);
          }
          function handleTemplateTag(atToken, tagName) {
            if (ts.forEach(tags, function(t) {
              return t.kind === 268;
            })) {
              parseErrorAtPosition(tagName.pos, pos - tagName.pos, ts.Diagnostics._0_tag_already_specified, tagName.text);
            }
            var typeParameters = [];
            typeParameters.pos = pos;
            while (true) {
              skipWhitespace();
              var startPos = pos;
              var name_8 = scanIdentifier();
              if (!name_8) {
                parseErrorAtPosition(startPos, 0, ts.Diagnostics.Identifier_expected);
                return undefined;
              }
              var typeParameter = createNode(135, name_8.pos);
              typeParameter.name = name_8;
              finishNode(typeParameter, pos);
              typeParameters.push(typeParameter);
              skipWhitespace();
              if (content.charCodeAt(pos) !== 44) {
                break;
              }
              pos++;
            }
            typeParameters.end = pos;
            var result = createNode(268, atToken.pos);
            result.atToken = atToken;
            result.tagName = tagName;
            result.typeParameters = typeParameters;
            return finishNode(result, pos);
          }
          function scanIdentifier() {
            var startPos = pos;
            for (; pos < end; pos++) {
              var ch = content.charCodeAt(pos);
              if (pos === startPos && ts.isIdentifierStart(ch, 2)) {
                continue;
              } else if (pos > startPos && ts.isIdentifierPart(ch, 2)) {
                continue;
              }
              break;
            }
            if (startPos === pos) {
              return undefined;
            }
            var result = createNode(67, startPos);
            result.text = content.substring(startPos, pos);
            return finishNode(result, pos);
          }
        }
        JSDocParser.parseJSDocCommentWorker = parseJSDocCommentWorker;
      })(JSDocParser = Parser.JSDocParser || (Parser.JSDocParser = {}));
    })(Parser || (Parser = {}));
    var IncrementalParser;
    (function(IncrementalParser) {
      function updateSourceFile(sourceFile, newText, textChangeRange, aggressiveChecks) {
        aggressiveChecks = aggressiveChecks || ts.Debug.shouldAssert(2);
        checkChangeRange(sourceFile, newText, textChangeRange, aggressiveChecks);
        if (ts.textChangeRangeIsUnchanged(textChangeRange)) {
          return sourceFile;
        }
        if (sourceFile.statements.length === 0) {
          return Parser.parseSourceFile(sourceFile.fileName, newText, sourceFile.languageVersion, undefined, true);
        }
        var incrementalSourceFile = sourceFile;
        ts.Debug.assert(!incrementalSourceFile.hasBeenIncrementallyParsed);
        incrementalSourceFile.hasBeenIncrementallyParsed = true;
        var oldText = sourceFile.text;
        var syntaxCursor = createSyntaxCursor(sourceFile);
        var changeRange = extendToAffectedRange(sourceFile, textChangeRange);
        checkChangeRange(sourceFile, newText, changeRange, aggressiveChecks);
        ts.Debug.assert(changeRange.span.start <= textChangeRange.span.start);
        ts.Debug.assert(ts.textSpanEnd(changeRange.span) === ts.textSpanEnd(textChangeRange.span));
        ts.Debug.assert(ts.textSpanEnd(ts.textChangeRangeNewSpan(changeRange)) === ts.textSpanEnd(ts.textChangeRangeNewSpan(textChangeRange)));
        var delta = ts.textChangeRangeNewSpan(changeRange).length - changeRange.span.length;
        updateTokenPositionsAndMarkElements(incrementalSourceFile, changeRange.span.start, ts.textSpanEnd(changeRange.span), ts.textSpanEnd(ts.textChangeRangeNewSpan(changeRange)), delta, oldText, newText, aggressiveChecks);
        var result = Parser.parseSourceFile(sourceFile.fileName, newText, sourceFile.languageVersion, syntaxCursor, true);
        return result;
      }
      IncrementalParser.updateSourceFile = updateSourceFile;
      function moveElementEntirelyPastChangeRange(element, isArray, delta, oldText, newText, aggressiveChecks) {
        if (isArray) {
          visitArray(element);
        } else {
          visitNode(element);
        }
        return;
        function visitNode(node) {
          var text = "";
          if (aggressiveChecks && shouldCheckNode(node)) {
            text = oldText.substring(node.pos, node.end);
          }
          if (node._children) {
            node._children = undefined;
          }
          if (node.jsDocComment) {
            node.jsDocComment = undefined;
          }
          node.pos += delta;
          node.end += delta;
          if (aggressiveChecks && shouldCheckNode(node)) {
            ts.Debug.assert(text === newText.substring(node.pos, node.end));
          }
          forEachChild(node, visitNode, visitArray);
          checkNodePositions(node, aggressiveChecks);
        }
        function visitArray(array) {
          array._children = undefined;
          array.pos += delta;
          array.end += delta;
          for (var _i = 0; _i < array.length; _i++) {
            var node = array[_i];
            visitNode(node);
          }
        }
      }
      function shouldCheckNode(node) {
        switch (node.kind) {
          case 9:
          case 8:
          case 67:
            return true;
        }
        return false;
      }
      function adjustIntersectingElement(element, changeStart, changeRangeOldEnd, changeRangeNewEnd, delta) {
        ts.Debug.assert(element.end >= changeStart, "Adjusting an element that was entirely before the change range");
        ts.Debug.assert(element.pos <= changeRangeOldEnd, "Adjusting an element that was entirely after the change range");
        ts.Debug.assert(element.pos <= element.end);
        element.pos = Math.min(element.pos, changeRangeNewEnd);
        if (element.end >= changeRangeOldEnd) {
          element.end += delta;
        } else {
          element.end = Math.min(element.end, changeRangeNewEnd);
        }
        ts.Debug.assert(element.pos <= element.end);
        if (element.parent) {
          ts.Debug.assert(element.pos >= element.parent.pos);
          ts.Debug.assert(element.end <= element.parent.end);
        }
      }
      function checkNodePositions(node, aggressiveChecks) {
        if (aggressiveChecks) {
          var pos = node.pos;
          forEachChild(node, function(child) {
            ts.Debug.assert(child.pos >= pos);
            pos = child.end;
          });
          ts.Debug.assert(pos <= node.end);
        }
      }
      function updateTokenPositionsAndMarkElements(sourceFile, changeStart, changeRangeOldEnd, changeRangeNewEnd, delta, oldText, newText, aggressiveChecks) {
        visitNode(sourceFile);
        return;
        function visitNode(child) {
          ts.Debug.assert(child.pos <= child.end);
          if (child.pos > changeRangeOldEnd) {
            moveElementEntirelyPastChangeRange(child, false, delta, oldText, newText, aggressiveChecks);
            return;
          }
          var fullEnd = child.end;
          if (fullEnd >= changeStart) {
            child.intersectsChange = true;
            child._children = undefined;
            adjustIntersectingElement(child, changeStart, changeRangeOldEnd, changeRangeNewEnd, delta);
            forEachChild(child, visitNode, visitArray);
            checkNodePositions(child, aggressiveChecks);
            return;
          }
          ts.Debug.assert(fullEnd < changeStart);
        }
        function visitArray(array) {
          ts.Debug.assert(array.pos <= array.end);
          if (array.pos > changeRangeOldEnd) {
            moveElementEntirelyPastChangeRange(array, true, delta, oldText, newText, aggressiveChecks);
            return;
          }
          var fullEnd = array.end;
          if (fullEnd >= changeStart) {
            array.intersectsChange = true;
            array._children = undefined;
            adjustIntersectingElement(array, changeStart, changeRangeOldEnd, changeRangeNewEnd, delta);
            for (var _i = 0; _i < array.length; _i++) {
              var node = array[_i];
              visitNode(node);
            }
            return;
          }
          ts.Debug.assert(fullEnd < changeStart);
        }
      }
      function extendToAffectedRange(sourceFile, changeRange) {
        var maxLookahead = 1;
        var start = changeRange.span.start;
        for (var i = 0; start > 0 && i <= maxLookahead; i++) {
          var nearestNode = findNearestNodeStartingBeforeOrAtPosition(sourceFile, start);
          ts.Debug.assert(nearestNode.pos <= start);
          var position = nearestNode.pos;
          start = Math.max(0, position - 1);
        }
        var finalSpan = ts.createTextSpanFromBounds(start, ts.textSpanEnd(changeRange.span));
        var finalLength = changeRange.newLength + (changeRange.span.start - start);
        return ts.createTextChangeRange(finalSpan, finalLength);
      }
      function findNearestNodeStartingBeforeOrAtPosition(sourceFile, position) {
        var bestResult = sourceFile;
        var lastNodeEntirelyBeforePosition;
        forEachChild(sourceFile, visit);
        if (lastNodeEntirelyBeforePosition) {
          var lastChildOfLastEntireNodeBeforePosition = getLastChild(lastNodeEntirelyBeforePosition);
          if (lastChildOfLastEntireNodeBeforePosition.pos > bestResult.pos) {
            bestResult = lastChildOfLastEntireNodeBeforePosition;
          }
        }
        return bestResult;
        function getLastChild(node) {
          while (true) {
            var lastChild = getLastChildWorker(node);
            if (lastChild) {
              node = lastChild;
            } else {
              return node;
            }
          }
        }
        function getLastChildWorker(node) {
          var last = undefined;
          forEachChild(node, function(child) {
            if (ts.nodeIsPresent(child)) {
              last = child;
            }
          });
          return last;
        }
        function visit(child) {
          if (ts.nodeIsMissing(child)) {
            return;
          }
          if (child.pos <= position) {
            if (child.pos >= bestResult.pos) {
              bestResult = child;
            }
            if (position < child.end) {
              forEachChild(child, visit);
              return true;
            } else {
              ts.Debug.assert(child.end <= position);
              lastNodeEntirelyBeforePosition = child;
            }
          } else {
            ts.Debug.assert(child.pos > position);
            return true;
          }
        }
      }
      function checkChangeRange(sourceFile, newText, textChangeRange, aggressiveChecks) {
        var oldText = sourceFile.text;
        if (textChangeRange) {
          ts.Debug.assert((oldText.length - textChangeRange.span.length + textChangeRange.newLength) === newText.length);
          if (aggressiveChecks || ts.Debug.shouldAssert(3)) {
            var oldTextPrefix = oldText.substr(0, textChangeRange.span.start);
            var newTextPrefix = newText.substr(0, textChangeRange.span.start);
            ts.Debug.assert(oldTextPrefix === newTextPrefix);
            var oldTextSuffix = oldText.substring(ts.textSpanEnd(textChangeRange.span), oldText.length);
            var newTextSuffix = newText.substring(ts.textSpanEnd(ts.textChangeRangeNewSpan(textChangeRange)), newText.length);
            ts.Debug.assert(oldTextSuffix === newTextSuffix);
          }
        }
      }
      function createSyntaxCursor(sourceFile) {
        var currentArray = sourceFile.statements;
        var currentArrayIndex = 0;
        ts.Debug.assert(currentArrayIndex < currentArray.length);
        var current = currentArray[currentArrayIndex];
        var lastQueriedPosition = -1;
        return {currentNode: function(position) {
            if (position !== lastQueriedPosition) {
              if (current && current.end === position && currentArrayIndex < (currentArray.length - 1)) {
                currentArrayIndex++;
                current = currentArray[currentArrayIndex];
              }
              if (!current || current.pos !== position) {
                findHighestListElementThatStartsAtPosition(position);
              }
            }
            lastQueriedPosition = position;
            ts.Debug.assert(!current || current.pos === position);
            return current;
          }};
        function findHighestListElementThatStartsAtPosition(position) {
          currentArray = undefined;
          currentArrayIndex = -1;
          current = undefined;
          forEachChild(sourceFile, visitNode, visitArray);
          return;
          function visitNode(node) {
            if (position >= node.pos && position < node.end) {
              forEachChild(node, visitNode, visitArray);
              return true;
            }
            return false;
          }
          function visitArray(array) {
            if (position >= array.pos && position < array.end) {
              for (var i = 0,
                  n = array.length; i < n; i++) {
                var child = array[i];
                if (child) {
                  if (child.pos === position) {
                    currentArray = array;
                    currentArrayIndex = i;
                    current = child;
                    return true;
                  } else {
                    if (child.pos < position && position < child.end) {
                      forEachChild(child, visitNode, visitArray);
                      return true;
                    }
                  }
                }
              }
            }
            return false;
          }
        }
      }
    })(IncrementalParser || (IncrementalParser = {}));
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    var nextSymbolId = 1;
    var nextNodeId = 1;
    var nextMergeId = 1;
    function getNodeId(node) {
      if (!node.id)
        node.id = nextNodeId++;
      return node.id;
    }
    ts.getNodeId = getNodeId;
    ts.checkTime = 0;
    function getSymbolId(symbol) {
      if (!symbol.id) {
        symbol.id = nextSymbolId++;
      }
      return symbol.id;
    }
    ts.getSymbolId = getSymbolId;
    function createTypeChecker(host, produceDiagnostics) {
      var cancellationToken;
      var Symbol = ts.objectAllocator.getSymbolConstructor();
      var Type = ts.objectAllocator.getTypeConstructor();
      var Signature = ts.objectAllocator.getSignatureConstructor();
      var typeCount = 0;
      var emptyArray = [];
      var emptySymbols = {};
      var compilerOptions = host.getCompilerOptions();
      var languageVersion = compilerOptions.target || 0;
      var emitResolver = createResolver();
      var undefinedSymbol = createSymbol(4 | 67108864, "undefined");
      var argumentsSymbol = createSymbol(4 | 67108864, "arguments");
      var checker = {
        getNodeCount: function() {
          return ts.sum(host.getSourceFiles(), "nodeCount");
        },
        getIdentifierCount: function() {
          return ts.sum(host.getSourceFiles(), "identifierCount");
        },
        getSymbolCount: function() {
          return ts.sum(host.getSourceFiles(), "symbolCount");
        },
        getTypeCount: function() {
          return typeCount;
        },
        isUndefinedSymbol: function(symbol) {
          return symbol === undefinedSymbol;
        },
        isArgumentsSymbol: function(symbol) {
          return symbol === argumentsSymbol;
        },
        getDiagnostics: getDiagnostics,
        getGlobalDiagnostics: getGlobalDiagnostics,
        getTypeOfSymbolAtLocation: getNarrowedTypeOfSymbol,
        getDeclaredTypeOfSymbol: getDeclaredTypeOfSymbol,
        getPropertiesOfType: getPropertiesOfType,
        getPropertyOfType: getPropertyOfType,
        getSignaturesOfType: getSignaturesOfType,
        getIndexTypeOfType: getIndexTypeOfType,
        getBaseTypes: getBaseTypes,
        getReturnTypeOfSignature: getReturnTypeOfSignature,
        getSymbolsInScope: getSymbolsInScope,
        getSymbolAtLocation: getSymbolAtLocation,
        getShorthandAssignmentValueSymbol: getShorthandAssignmentValueSymbol,
        getTypeAtLocation: getTypeOfNode,
        typeToString: typeToString,
        getSymbolDisplayBuilder: getSymbolDisplayBuilder,
        symbolToString: symbolToString,
        getAugmentedPropertiesOfType: getAugmentedPropertiesOfType,
        getRootSymbols: getRootSymbols,
        getContextualType: getContextualType,
        getFullyQualifiedName: getFullyQualifiedName,
        getResolvedSignature: getResolvedSignature,
        getConstantValue: getConstantValue,
        isValidPropertyAccess: isValidPropertyAccess,
        getSignatureFromDeclaration: getSignatureFromDeclaration,
        isImplementationOfOverload: isImplementationOfOverload,
        getAliasedSymbol: resolveAlias,
        getEmitResolver: getEmitResolver,
        getExportsOfModule: getExportsOfModuleAsArray,
        getJsxElementAttributesType: getJsxElementAttributesType,
        getJsxIntrinsicTagNames: getJsxIntrinsicTagNames,
        isOptionalParameter: isOptionalParameter
      };
      var unknownSymbol = createSymbol(4 | 67108864, "unknown");
      var resolvingSymbol = createSymbol(67108864, "__resolving__");
      var anyType = createIntrinsicType(1, "any");
      var stringType = createIntrinsicType(2, "string");
      var numberType = createIntrinsicType(4, "number");
      var booleanType = createIntrinsicType(8, "boolean");
      var esSymbolType = createIntrinsicType(16777216, "symbol");
      var voidType = createIntrinsicType(16, "void");
      var undefinedType = createIntrinsicType(32 | 2097152, "undefined");
      var nullType = createIntrinsicType(64 | 2097152, "null");
      var unknownType = createIntrinsicType(1, "unknown");
      var circularType = createIntrinsicType(1, "__circular__");
      var emptyObjectType = createAnonymousType(undefined, emptySymbols, emptyArray, emptyArray, undefined, undefined);
      var emptyGenericType = createAnonymousType(undefined, emptySymbols, emptyArray, emptyArray, undefined, undefined);
      emptyGenericType.instantiations = {};
      var anyFunctionType = createAnonymousType(undefined, emptySymbols, emptyArray, emptyArray, undefined, undefined);
      anyFunctionType.flags |= 8388608;
      var noConstraintType = createAnonymousType(undefined, emptySymbols, emptyArray, emptyArray, undefined, undefined);
      var anySignature = createSignature(undefined, undefined, emptyArray, anyType, undefined, 0, false, false);
      var unknownSignature = createSignature(undefined, undefined, emptyArray, unknownType, undefined, 0, false, false);
      var globals = {};
      var globalESSymbolConstructorSymbol;
      var getGlobalPromiseConstructorSymbol;
      var globalObjectType;
      var globalFunctionType;
      var globalArrayType;
      var globalStringType;
      var globalNumberType;
      var globalBooleanType;
      var globalRegExpType;
      var globalTemplateStringsArrayType;
      var globalESSymbolType;
      var jsxElementType;
      var jsxIntrinsicElementsType;
      var globalIterableType;
      var globalIteratorType;
      var globalIterableIteratorType;
      var anyArrayType;
      var getGlobalClassDecoratorType;
      var getGlobalParameterDecoratorType;
      var getGlobalPropertyDecoratorType;
      var getGlobalMethodDecoratorType;
      var getGlobalTypedPropertyDescriptorType;
      var getGlobalPromiseType;
      var tryGetGlobalPromiseType;
      var getGlobalPromiseLikeType;
      var getInstantiatedGlobalPromiseLikeType;
      var getGlobalPromiseConstructorLikeType;
      var getGlobalThenableType;
      var tupleTypes = {};
      var unionTypes = {};
      var intersectionTypes = {};
      var stringLiteralTypes = {};
      var emitExtends = false;
      var emitDecorate = false;
      var emitParam = false;
      var emitAwaiter = false;
      var emitGenerator = false;
      var resolutionTargets = [];
      var resolutionResults = [];
      var resolutionPropertyNames = [];
      var mergedSymbols = [];
      var symbolLinks = [];
      var nodeLinks = [];
      var potentialThisCollisions = [];
      var awaitedTypeStack = [];
      var diagnostics = ts.createDiagnosticCollection();
      var primitiveTypeInfo = {
        "string": {
          type: stringType,
          flags: 258
        },
        "number": {
          type: numberType,
          flags: 132
        },
        "boolean": {
          type: booleanType,
          flags: 8
        },
        "symbol": {
          type: esSymbolType,
          flags: 16777216
        }
      };
      var JsxNames = {
        JSX: "JSX",
        IntrinsicElements: "IntrinsicElements",
        ElementClass: "ElementClass",
        ElementAttributesPropertyNameContainer: "ElementAttributesProperty",
        Element: "Element"
      };
      var subtypeRelation = {};
      var assignableRelation = {};
      var identityRelation = {};
      var _displayBuilder;
      initializeTypeChecker();
      return checker;
      function getEmitResolver(sourceFile, cancellationToken) {
        getDiagnostics(sourceFile, cancellationToken);
        return emitResolver;
      }
      function error(location, message, arg0, arg1, arg2) {
        var diagnostic = location ? ts.createDiagnosticForNode(location, message, arg0, arg1, arg2) : ts.createCompilerDiagnostic(message, arg0, arg1, arg2);
        diagnostics.add(diagnostic);
      }
      function createSymbol(flags, name) {
        return new Symbol(flags, name);
      }
      function getExcludedSymbolFlags(flags) {
        var result = 0;
        if (flags & 2)
          result |= 107455;
        if (flags & 1)
          result |= 107454;
        if (flags & 4)
          result |= 107455;
        if (flags & 8)
          result |= 107455;
        if (flags & 16)
          result |= 106927;
        if (flags & 32)
          result |= 899519;
        if (flags & 64)
          result |= 792960;
        if (flags & 256)
          result |= 899327;
        if (flags & 128)
          result |= 899967;
        if (flags & 512)
          result |= 106639;
        if (flags & 8192)
          result |= 99263;
        if (flags & 32768)
          result |= 41919;
        if (flags & 65536)
          result |= 74687;
        if (flags & 262144)
          result |= 530912;
        if (flags & 524288)
          result |= 793056;
        if (flags & 8388608)
          result |= 8388608;
        return result;
      }
      function recordMergedSymbol(target, source) {
        if (!source.mergeId)
          source.mergeId = nextMergeId++;
        mergedSymbols[source.mergeId] = target;
      }
      function cloneSymbol(symbol) {
        var result = createSymbol(symbol.flags | 33554432, symbol.name);
        result.declarations = symbol.declarations.slice(0);
        result.parent = symbol.parent;
        if (symbol.valueDeclaration)
          result.valueDeclaration = symbol.valueDeclaration;
        if (symbol.constEnumOnlyModule)
          result.constEnumOnlyModule = true;
        if (symbol.members)
          result.members = cloneSymbolTable(symbol.members);
        if (symbol.exports)
          result.exports = cloneSymbolTable(symbol.exports);
        recordMergedSymbol(result, symbol);
        return result;
      }
      function mergeSymbol(target, source) {
        if (!(target.flags & getExcludedSymbolFlags(source.flags))) {
          if (source.flags & 512 && target.flags & 512 && target.constEnumOnlyModule && !source.constEnumOnlyModule) {
            target.constEnumOnlyModule = false;
          }
          target.flags |= source.flags;
          if (!target.valueDeclaration && source.valueDeclaration)
            target.valueDeclaration = source.valueDeclaration;
          ts.forEach(source.declarations, function(node) {
            target.declarations.push(node);
          });
          if (source.members) {
            if (!target.members)
              target.members = {};
            mergeSymbolTable(target.members, source.members);
          }
          if (source.exports) {
            if (!target.exports)
              target.exports = {};
            mergeSymbolTable(target.exports, source.exports);
          }
          recordMergedSymbol(target, source);
        } else {
          var message = target.flags & 2 || source.flags & 2 ? ts.Diagnostics.Cannot_redeclare_block_scoped_variable_0 : ts.Diagnostics.Duplicate_identifier_0;
          ts.forEach(source.declarations, function(node) {
            error(node.name ? node.name : node, message, symbolToString(source));
          });
          ts.forEach(target.declarations, function(node) {
            error(node.name ? node.name : node, message, symbolToString(source));
          });
        }
      }
      function cloneSymbolTable(symbolTable) {
        var result = {};
        for (var id in symbolTable) {
          if (ts.hasProperty(symbolTable, id)) {
            result[id] = symbolTable[id];
          }
        }
        return result;
      }
      function mergeSymbolTable(target, source) {
        for (var id in source) {
          if (ts.hasProperty(source, id)) {
            if (!ts.hasProperty(target, id)) {
              target[id] = source[id];
            } else {
              var symbol = target[id];
              if (!(symbol.flags & 33554432)) {
                target[id] = symbol = cloneSymbol(symbol);
              }
              mergeSymbol(symbol, source[id]);
            }
          }
        }
      }
      function getSymbolLinks(symbol) {
        if (symbol.flags & 67108864)
          return symbol;
        var id = getSymbolId(symbol);
        return symbolLinks[id] || (symbolLinks[id] = {});
      }
      function getNodeLinks(node) {
        var nodeId = getNodeId(node);
        return nodeLinks[nodeId] || (nodeLinks[nodeId] = {});
      }
      function getSourceFile(node) {
        return ts.getAncestor(node, 246);
      }
      function isGlobalSourceFile(node) {
        return node.kind === 246 && !ts.isExternalModule(node);
      }
      function getSymbol(symbols, name, meaning) {
        if (meaning && ts.hasProperty(symbols, name)) {
          var symbol = symbols[name];
          ts.Debug.assert((symbol.flags & 16777216) === 0, "Should never get an instantiated symbol here.");
          if (symbol.flags & meaning) {
            return symbol;
          }
          if (symbol.flags & 8388608) {
            var target = resolveAlias(symbol);
            if (target === unknownSymbol || target.flags & meaning) {
              return symbol;
            }
          }
        }
      }
      function isDefinedBefore(node1, node2) {
        var file1 = ts.getSourceFileOfNode(node1);
        var file2 = ts.getSourceFileOfNode(node2);
        if (file1 === file2) {
          return node1.pos <= node2.pos;
        }
        if (!compilerOptions.outFile && !compilerOptions.out) {
          return true;
        }
        var sourceFiles = host.getSourceFiles();
        return sourceFiles.indexOf(file1) <= sourceFiles.indexOf(file2);
      }
      function resolveName(location, name, meaning, nameNotFoundMessage, nameArg) {
        var result;
        var lastLocation;
        var propertyWithInvalidInitializer;
        var errorLocation = location;
        var grandparent;
        loop: while (location) {
          if (location.locals && !isGlobalSourceFile(location)) {
            if (result = getSymbol(location.locals, name, meaning)) {
              if (!(meaning & 793056) || !(result.flags & (793056 & ~262144)) || !ts.isFunctionLike(location) || lastLocation === location.body) {
                break loop;
              }
              result = undefined;
            }
          }
          switch (location.kind) {
            case 246:
              if (!ts.isExternalModule(location))
                break;
            case 216:
              var moduleExports = getSymbolOfNode(location).exports;
              if (location.kind === 246 || (location.kind === 216 && location.name.kind === 9)) {
                if (ts.hasProperty(moduleExports, name) && moduleExports[name].flags === 8388608 && ts.getDeclarationOfKind(moduleExports[name], 228)) {
                  break;
                }
                result = moduleExports["default"];
                var localSymbol = ts.getLocalSymbolForExportDefault(result);
                if (result && localSymbol && (result.flags & meaning) && localSymbol.name === name) {
                  break loop;
                }
                result = undefined;
              }
              if (result = getSymbol(moduleExports, name, meaning & 8914931)) {
                break loop;
              }
              break;
            case 215:
              if (result = getSymbol(getSymbolOfNode(location).exports, name, meaning & 8)) {
                break loop;
              }
              break;
            case 139:
            case 138:
              if (ts.isClassLike(location.parent) && !(location.flags & 128)) {
                var ctor = findConstructorDeclaration(location.parent);
                if (ctor && ctor.locals) {
                  if (getSymbol(ctor.locals, name, meaning & 107455)) {
                    propertyWithInvalidInitializer = location;
                  }
                }
              }
              break;
            case 212:
            case 184:
            case 213:
              if (result = getSymbol(getSymbolOfNode(location).members, name, meaning & 793056)) {
                if (lastLocation && lastLocation.flags & 128) {
                  error(errorLocation, ts.Diagnostics.Static_members_cannot_reference_class_type_parameters);
                  return undefined;
                }
                break loop;
              }
              if (location.kind === 184 && meaning & 32) {
                var className = location.name;
                if (className && name === className.text) {
                  result = location.symbol;
                  break loop;
                }
              }
              break;
            case 134:
              grandparent = location.parent.parent;
              if (ts.isClassLike(grandparent) || grandparent.kind === 213) {
                if (result = getSymbol(getSymbolOfNode(grandparent).members, name, meaning & 793056)) {
                  error(errorLocation, ts.Diagnostics.A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type);
                  return undefined;
                }
              }
              break;
            case 141:
            case 140:
            case 142:
            case 143:
            case 144:
            case 211:
            case 172:
              if (meaning & 3 && name === "arguments") {
                result = argumentsSymbol;
                break loop;
              }
              break;
            case 171:
              if (meaning & 3 && name === "arguments") {
                result = argumentsSymbol;
                break loop;
              }
              if (meaning & 16) {
                var functionName = location.name;
                if (functionName && name === functionName.text) {
                  result = location.symbol;
                  break loop;
                }
              }
              break;
            case 137:
              if (location.parent && location.parent.kind === 136) {
                location = location.parent;
              }
              if (location.parent && ts.isClassElement(location.parent)) {
                location = location.parent;
              }
              break;
          }
          lastLocation = location;
          location = location.parent;
        }
        if (!result) {
          result = getSymbol(globals, name, meaning);
        }
        if (!result) {
          if (nameNotFoundMessage) {
            error(errorLocation, nameNotFoundMessage, typeof nameArg === "string" ? nameArg : ts.declarationNameToString(nameArg));
          }
          return undefined;
        }
        if (nameNotFoundMessage) {
          if (propertyWithInvalidInitializer) {
            var propertyName = propertyWithInvalidInitializer.name;
            error(errorLocation, ts.Diagnostics.Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor, ts.declarationNameToString(propertyName), typeof nameArg === "string" ? nameArg : ts.declarationNameToString(nameArg));
            return undefined;
          }
          if (meaning & 2 && result.flags & 2) {
            checkResolvedBlockScopedVariable(result, errorLocation);
          }
        }
        return result;
      }
      function checkResolvedBlockScopedVariable(result, errorLocation) {
        ts.Debug.assert((result.flags & 2) !== 0);
        var declaration = ts.forEach(result.declarations, function(d) {
          return ts.isBlockOrCatchScoped(d) ? d : undefined;
        });
        ts.Debug.assert(declaration !== undefined, "Block-scoped variable declaration is undefined");
        var isUsedBeforeDeclaration = !isDefinedBefore(declaration, errorLocation);
        if (!isUsedBeforeDeclaration) {
          var variableDeclaration = ts.getAncestor(declaration, 209);
          var container = ts.getEnclosingBlockScopeContainer(variableDeclaration);
          if (variableDeclaration.parent.parent.kind === 191 || variableDeclaration.parent.parent.kind === 197) {
            isUsedBeforeDeclaration = isSameScopeDescendentOf(errorLocation, variableDeclaration, container);
          } else if (variableDeclaration.parent.parent.kind === 199 || variableDeclaration.parent.parent.kind === 198) {
            var expression = variableDeclaration.parent.parent.expression;
            isUsedBeforeDeclaration = isSameScopeDescendentOf(errorLocation, expression, container);
          }
        }
        if (isUsedBeforeDeclaration) {
          error(errorLocation, ts.Diagnostics.Block_scoped_variable_0_used_before_its_declaration, ts.declarationNameToString(declaration.name));
        }
      }
      function isSameScopeDescendentOf(initial, parent, stopAt) {
        if (!parent) {
          return false;
        }
        for (var current = initial; current && current !== stopAt && !ts.isFunctionLike(current); current = current.parent) {
          if (current === parent) {
            return true;
          }
        }
        return false;
      }
      function getAnyImportSyntax(node) {
        if (ts.isAliasSymbolDeclaration(node)) {
          if (node.kind === 219) {
            return node;
          }
          while (node && node.kind !== 220) {
            node = node.parent;
          }
          return node;
        }
      }
      function getDeclarationOfAliasSymbol(symbol) {
        return ts.forEach(symbol.declarations, function(d) {
          return ts.isAliasSymbolDeclaration(d) ? d : undefined;
        });
      }
      function getTargetOfImportEqualsDeclaration(node) {
        if (node.moduleReference.kind === 230) {
          return resolveExternalModuleSymbol(resolveExternalModuleName(node, ts.getExternalModuleImportEqualsDeclarationExpression(node)));
        }
        return getSymbolOfPartOfRightHandSideOfImportEquals(node.moduleReference, node);
      }
      function getTargetOfImportClause(node) {
        var moduleSymbol = resolveExternalModuleName(node, node.parent.moduleSpecifier);
        if (moduleSymbol) {
          var exportDefaultSymbol = resolveSymbol(moduleSymbol.exports["default"]);
          if (!exportDefaultSymbol) {
            error(node.name, ts.Diagnostics.Module_0_has_no_default_export, symbolToString(moduleSymbol));
          }
          return exportDefaultSymbol;
        }
      }
      function getTargetOfNamespaceImport(node) {
        var moduleSpecifier = node.parent.parent.moduleSpecifier;
        return resolveESModuleSymbol(resolveExternalModuleName(node, moduleSpecifier), moduleSpecifier);
      }
      function getMemberOfModuleVariable(moduleSymbol, name) {
        if (moduleSymbol.flags & 3) {
          var typeAnnotation = moduleSymbol.valueDeclaration.type;
          if (typeAnnotation) {
            return getPropertyOfType(getTypeFromTypeNode(typeAnnotation), name);
          }
        }
      }
      function combineValueAndTypeSymbols(valueSymbol, typeSymbol) {
        if (valueSymbol.flags & (793056 | 1536)) {
          return valueSymbol;
        }
        var result = createSymbol(valueSymbol.flags | typeSymbol.flags, valueSymbol.name);
        result.declarations = ts.concatenate(valueSymbol.declarations, typeSymbol.declarations);
        result.parent = valueSymbol.parent || typeSymbol.parent;
        if (valueSymbol.valueDeclaration)
          result.valueDeclaration = valueSymbol.valueDeclaration;
        if (typeSymbol.members)
          result.members = typeSymbol.members;
        if (valueSymbol.exports)
          result.exports = valueSymbol.exports;
        return result;
      }
      function getExportOfModule(symbol, name) {
        if (symbol.flags & 1536) {
          var exports = getExportsOfSymbol(symbol);
          if (ts.hasProperty(exports, name)) {
            return resolveSymbol(exports[name]);
          }
        }
      }
      function getPropertyOfVariable(symbol, name) {
        if (symbol.flags & 3) {
          var typeAnnotation = symbol.valueDeclaration.type;
          if (typeAnnotation) {
            return resolveSymbol(getPropertyOfType(getTypeFromTypeNode(typeAnnotation), name));
          }
        }
      }
      function getExternalModuleMember(node, specifier) {
        var moduleSymbol = resolveExternalModuleName(node, node.moduleSpecifier);
        var targetSymbol = resolveESModuleSymbol(moduleSymbol, node.moduleSpecifier);
        if (targetSymbol) {
          var name_9 = specifier.propertyName || specifier.name;
          if (name_9.text) {
            var symbolFromModule = getExportOfModule(targetSymbol, name_9.text);
            var symbolFromVariable = getPropertyOfVariable(targetSymbol, name_9.text);
            var symbol = symbolFromModule && symbolFromVariable ? combineValueAndTypeSymbols(symbolFromVariable, symbolFromModule) : symbolFromModule || symbolFromVariable;
            if (!symbol) {
              error(name_9, ts.Diagnostics.Module_0_has_no_exported_member_1, getFullyQualifiedName(moduleSymbol), ts.declarationNameToString(name_9));
            }
            return symbol;
          }
        }
      }
      function getTargetOfImportSpecifier(node) {
        return getExternalModuleMember(node.parent.parent.parent, node);
      }
      function getTargetOfExportSpecifier(node) {
        return node.parent.parent.moduleSpecifier ? getExternalModuleMember(node.parent.parent, node) : resolveEntityName(node.propertyName || node.name, 107455 | 793056 | 1536);
      }
      function getTargetOfExportAssignment(node) {
        return resolveEntityName(node.expression, 107455 | 793056 | 1536);
      }
      function getTargetOfAliasDeclaration(node) {
        switch (node.kind) {
          case 219:
            return getTargetOfImportEqualsDeclaration(node);
          case 221:
            return getTargetOfImportClause(node);
          case 222:
            return getTargetOfNamespaceImport(node);
          case 224:
            return getTargetOfImportSpecifier(node);
          case 228:
            return getTargetOfExportSpecifier(node);
          case 225:
            return getTargetOfExportAssignment(node);
        }
      }
      function resolveSymbol(symbol) {
        return symbol && symbol.flags & 8388608 && !(symbol.flags & (107455 | 793056 | 1536)) ? resolveAlias(symbol) : symbol;
      }
      function resolveAlias(symbol) {
        ts.Debug.assert((symbol.flags & 8388608) !== 0, "Should only get Alias here.");
        var links = getSymbolLinks(symbol);
        if (!links.target) {
          links.target = resolvingSymbol;
          var node = getDeclarationOfAliasSymbol(symbol);
          var target = getTargetOfAliasDeclaration(node);
          if (links.target === resolvingSymbol) {
            links.target = target || unknownSymbol;
          } else {
            error(node, ts.Diagnostics.Circular_definition_of_import_alias_0, symbolToString(symbol));
          }
        } else if (links.target === resolvingSymbol) {
          links.target = unknownSymbol;
        }
        return links.target;
      }
      function markExportAsReferenced(node) {
        var symbol = getSymbolOfNode(node);
        var target = resolveAlias(symbol);
        if (target) {
          var markAlias = (target === unknownSymbol && compilerOptions.isolatedModules) || (target !== unknownSymbol && (target.flags & 107455) && !isConstEnumOrConstEnumOnlyModule(target));
          if (markAlias) {
            markAliasSymbolAsReferenced(symbol);
          }
        }
      }
      function markAliasSymbolAsReferenced(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.referenced) {
          links.referenced = true;
          var node = getDeclarationOfAliasSymbol(symbol);
          if (node.kind === 225) {
            checkExpressionCached(node.expression);
          } else if (node.kind === 228) {
            checkExpressionCached(node.propertyName || node.name);
          } else if (ts.isInternalModuleImportEqualsDeclaration(node)) {
            checkExpressionCached(node.moduleReference);
          }
        }
      }
      function getSymbolOfPartOfRightHandSideOfImportEquals(entityName, importDeclaration) {
        if (!importDeclaration) {
          importDeclaration = ts.getAncestor(entityName, 219);
          ts.Debug.assert(importDeclaration !== undefined);
        }
        if (entityName.kind === 67 && ts.isRightSideOfQualifiedNameOrPropertyAccess(entityName)) {
          entityName = entityName.parent;
        }
        if (entityName.kind === 67 || entityName.parent.kind === 133) {
          return resolveEntityName(entityName, 1536);
        } else {
          ts.Debug.assert(entityName.parent.kind === 219);
          return resolveEntityName(entityName, 107455 | 793056 | 1536);
        }
      }
      function getFullyQualifiedName(symbol) {
        return symbol.parent ? getFullyQualifiedName(symbol.parent) + "." + symbolToString(symbol) : symbolToString(symbol);
      }
      function resolveEntityName(name, meaning, ignoreErrors) {
        if (ts.nodeIsMissing(name)) {
          return undefined;
        }
        var symbol;
        if (name.kind === 67) {
          var message = meaning === 1536 ? ts.Diagnostics.Cannot_find_namespace_0 : ts.Diagnostics.Cannot_find_name_0;
          symbol = resolveName(name, name.text, meaning, ignoreErrors ? undefined : message, name);
          if (!symbol) {
            return undefined;
          }
        } else if (name.kind === 133 || name.kind === 164) {
          var left = name.kind === 133 ? name.left : name.expression;
          var right = name.kind === 133 ? name.right : name.name;
          var namespace = resolveEntityName(left, 1536, ignoreErrors);
          if (!namespace || namespace === unknownSymbol || ts.nodeIsMissing(right)) {
            return undefined;
          }
          symbol = getSymbol(getExportsOfSymbol(namespace), right.text, meaning);
          if (!symbol) {
            if (!ignoreErrors) {
              error(right, ts.Diagnostics.Module_0_has_no_exported_member_1, getFullyQualifiedName(namespace), ts.declarationNameToString(right));
            }
            return undefined;
          }
        } else {
          ts.Debug.fail("Unknown entity name kind.");
        }
        ts.Debug.assert((symbol.flags & 16777216) === 0, "Should never get an instantiated symbol here.");
        return symbol.flags & meaning ? symbol : resolveAlias(symbol);
      }
      function isExternalModuleNameRelative(moduleName) {
        return moduleName.substr(0, 2) === "./" || moduleName.substr(0, 3) === "../" || moduleName.substr(0, 2) === ".\\" || moduleName.substr(0, 3) === "..\\";
      }
      function resolveExternalModuleName(location, moduleReferenceExpression) {
        if (moduleReferenceExpression.kind !== 9) {
          return;
        }
        var moduleReferenceLiteral = moduleReferenceExpression;
        var searchPath = ts.getDirectoryPath(getSourceFile(location).fileName);
        var moduleName = ts.escapeIdentifier(moduleReferenceLiteral.text);
        if (!moduleName) {
          return;
        }
        var isRelative = isExternalModuleNameRelative(moduleName);
        if (!isRelative) {
          var symbol = getSymbol(globals, "\"" + moduleName + "\"", 512);
          if (symbol) {
            return symbol;
          }
        }
        var resolvedModule = ts.getResolvedModule(getSourceFile(location), moduleReferenceLiteral.text);
        var sourceFile = resolvedModule && host.getSourceFile(resolvedModule.resolvedFileName);
        if (sourceFile) {
          if (sourceFile.symbol) {
            return sourceFile.symbol;
          }
          error(moduleReferenceLiteral, ts.Diagnostics.File_0_is_not_a_module, sourceFile.fileName);
          return;
        }
        error(moduleReferenceLiteral, ts.Diagnostics.Cannot_find_module_0, moduleName);
      }
      function resolveExternalModuleSymbol(moduleSymbol) {
        return moduleSymbol && resolveSymbol(moduleSymbol.exports["export="]) || moduleSymbol;
      }
      function resolveESModuleSymbol(moduleSymbol, moduleReferenceExpression) {
        var symbol = resolveExternalModuleSymbol(moduleSymbol);
        if (symbol && !(symbol.flags & (1536 | 3))) {
          error(moduleReferenceExpression, ts.Diagnostics.Module_0_resolves_to_a_non_module_entity_and_cannot_be_imported_using_this_construct, symbolToString(moduleSymbol));
          symbol = undefined;
        }
        return symbol;
      }
      function getExportAssignmentSymbol(moduleSymbol) {
        return moduleSymbol.exports["export="];
      }
      function getExportsOfModuleAsArray(moduleSymbol) {
        return symbolsToArray(getExportsOfModule(moduleSymbol));
      }
      function getExportsOfSymbol(symbol) {
        return symbol.flags & 1536 ? getExportsOfModule(symbol) : symbol.exports || emptySymbols;
      }
      function getExportsOfModule(moduleSymbol) {
        var links = getSymbolLinks(moduleSymbol);
        return links.resolvedExports || (links.resolvedExports = getExportsForModule(moduleSymbol));
      }
      function extendExportSymbols(target, source) {
        for (var id in source) {
          if (id !== "default" && !ts.hasProperty(target, id)) {
            target[id] = source[id];
          }
        }
      }
      function getExportsForModule(moduleSymbol) {
        var result;
        var visitedSymbols = [];
        visit(moduleSymbol);
        return result || moduleSymbol.exports;
        function visit(symbol) {
          if (symbol && symbol.flags & 1952 && !ts.contains(visitedSymbols, symbol)) {
            visitedSymbols.push(symbol);
            if (symbol !== moduleSymbol) {
              if (!result) {
                result = cloneSymbolTable(moduleSymbol.exports);
              }
              extendExportSymbols(result, symbol.exports);
            }
            var exportStars = symbol.exports["__export"];
            if (exportStars) {
              for (var _i = 0,
                  _a = exportStars.declarations; _i < _a.length; _i++) {
                var node = _a[_i];
                visit(resolveExternalModuleName(node, node.moduleSpecifier));
              }
            }
          }
        }
      }
      function getMergedSymbol(symbol) {
        var merged;
        return symbol && symbol.mergeId && (merged = mergedSymbols[symbol.mergeId]) ? merged : symbol;
      }
      function getSymbolOfNode(node) {
        return getMergedSymbol(node.symbol);
      }
      function getParentOfSymbol(symbol) {
        return getMergedSymbol(symbol.parent);
      }
      function getExportSymbolOfValueSymbolIfExported(symbol) {
        return symbol && (symbol.flags & 1048576) !== 0 ? getMergedSymbol(symbol.exportSymbol) : symbol;
      }
      function symbolIsValue(symbol) {
        if (symbol.flags & 16777216) {
          return symbolIsValue(getSymbolLinks(symbol).target);
        }
        if (symbol.flags & 107455) {
          return true;
        }
        if (symbol.flags & 8388608) {
          return (resolveAlias(symbol).flags & 107455) !== 0;
        }
        return false;
      }
      function findConstructorDeclaration(node) {
        var members = node.members;
        for (var _i = 0; _i < members.length; _i++) {
          var member = members[_i];
          if (member.kind === 142 && ts.nodeIsPresent(member.body)) {
            return member;
          }
        }
      }
      function createType(flags) {
        var result = new Type(checker, flags);
        result.id = typeCount++;
        return result;
      }
      function createIntrinsicType(kind, intrinsicName) {
        var type = createType(kind);
        type.intrinsicName = intrinsicName;
        return type;
      }
      function createObjectType(kind, symbol) {
        var type = createType(kind);
        type.symbol = symbol;
        return type;
      }
      function isReservedMemberName(name) {
        return name.charCodeAt(0) === 95 && name.charCodeAt(1) === 95 && name.charCodeAt(2) !== 95 && name.charCodeAt(2) !== 64;
      }
      function getNamedMembers(members) {
        var result;
        for (var id in members) {
          if (ts.hasProperty(members, id)) {
            if (!isReservedMemberName(id)) {
              if (!result)
                result = [];
              var symbol = members[id];
              if (symbolIsValue(symbol)) {
                result.push(symbol);
              }
            }
          }
        }
        return result || emptyArray;
      }
      function setObjectTypeMembers(type, members, callSignatures, constructSignatures, stringIndexType, numberIndexType) {
        type.members = members;
        type.properties = getNamedMembers(members);
        type.callSignatures = callSignatures;
        type.constructSignatures = constructSignatures;
        if (stringIndexType)
          type.stringIndexType = stringIndexType;
        if (numberIndexType)
          type.numberIndexType = numberIndexType;
        return type;
      }
      function createAnonymousType(symbol, members, callSignatures, constructSignatures, stringIndexType, numberIndexType) {
        return setObjectTypeMembers(createObjectType(65536, symbol), members, callSignatures, constructSignatures, stringIndexType, numberIndexType);
      }
      function forEachSymbolTableInScope(enclosingDeclaration, callback) {
        var result;
        for (var location_1 = enclosingDeclaration; location_1; location_1 = location_1.parent) {
          if (location_1.locals && !isGlobalSourceFile(location_1)) {
            if (result = callback(location_1.locals)) {
              return result;
            }
          }
          switch (location_1.kind) {
            case 246:
              if (!ts.isExternalModule(location_1)) {
                break;
              }
            case 216:
              if (result = callback(getSymbolOfNode(location_1).exports)) {
                return result;
              }
              break;
            case 212:
            case 213:
              if (result = callback(getSymbolOfNode(location_1).members)) {
                return result;
              }
              break;
          }
        }
        return callback(globals);
      }
      function getQualifiedLeftMeaning(rightMeaning) {
        return rightMeaning === 107455 ? 107455 : 1536;
      }
      function getAccessibleSymbolChain(symbol, enclosingDeclaration, meaning, useOnlyExternalAliasing) {
        function getAccessibleSymbolChainFromSymbolTable(symbols) {
          function canQualifySymbol(symbolFromSymbolTable, meaning) {
            if (!needsQualification(symbolFromSymbolTable, enclosingDeclaration, meaning)) {
              return true;
            }
            var accessibleParent = getAccessibleSymbolChain(symbolFromSymbolTable.parent, enclosingDeclaration, getQualifiedLeftMeaning(meaning), useOnlyExternalAliasing);
            return !!accessibleParent;
          }
          function isAccessible(symbolFromSymbolTable, resolvedAliasSymbol) {
            if (symbol === (resolvedAliasSymbol || symbolFromSymbolTable)) {
              return !ts.forEach(symbolFromSymbolTable.declarations, hasExternalModuleSymbol) && canQualifySymbol(symbolFromSymbolTable, meaning);
            }
          }
          if (isAccessible(ts.lookUp(symbols, symbol.name))) {
            return [symbol];
          }
          return ts.forEachValue(symbols, function(symbolFromSymbolTable) {
            if (symbolFromSymbolTable.flags & 8388608 && symbolFromSymbolTable.name !== "export=" && !ts.getDeclarationOfKind(symbolFromSymbolTable, 228)) {
              if (!useOnlyExternalAliasing || ts.forEach(symbolFromSymbolTable.declarations, ts.isExternalModuleImportEqualsDeclaration)) {
                var resolvedImportedSymbol = resolveAlias(symbolFromSymbolTable);
                if (isAccessible(symbolFromSymbolTable, resolveAlias(symbolFromSymbolTable))) {
                  return [symbolFromSymbolTable];
                }
                var accessibleSymbolsFromExports = resolvedImportedSymbol.exports ? getAccessibleSymbolChainFromSymbolTable(resolvedImportedSymbol.exports) : undefined;
                if (accessibleSymbolsFromExports && canQualifySymbol(symbolFromSymbolTable, getQualifiedLeftMeaning(meaning))) {
                  return [symbolFromSymbolTable].concat(accessibleSymbolsFromExports);
                }
              }
            }
          });
        }
        if (symbol) {
          return forEachSymbolTableInScope(enclosingDeclaration, getAccessibleSymbolChainFromSymbolTable);
        }
      }
      function needsQualification(symbol, enclosingDeclaration, meaning) {
        var qualify = false;
        forEachSymbolTableInScope(enclosingDeclaration, function(symbolTable) {
          if (!ts.hasProperty(symbolTable, symbol.name)) {
            return false;
          }
          var symbolFromSymbolTable = symbolTable[symbol.name];
          if (symbolFromSymbolTable === symbol) {
            return true;
          }
          symbolFromSymbolTable = (symbolFromSymbolTable.flags & 8388608 && !ts.getDeclarationOfKind(symbolFromSymbolTable, 228)) ? resolveAlias(symbolFromSymbolTable) : symbolFromSymbolTable;
          if (symbolFromSymbolTable.flags & meaning) {
            qualify = true;
            return true;
          }
          return false;
        });
        return qualify;
      }
      function isSymbolAccessible(symbol, enclosingDeclaration, meaning) {
        if (symbol && enclosingDeclaration && !(symbol.flags & 262144)) {
          var initialSymbol = symbol;
          var meaningToLook = meaning;
          while (symbol) {
            var accessibleSymbolChain = getAccessibleSymbolChain(symbol, enclosingDeclaration, meaningToLook, false);
            if (accessibleSymbolChain) {
              var hasAccessibleDeclarations = hasVisibleDeclarations(accessibleSymbolChain[0]);
              if (!hasAccessibleDeclarations) {
                return {
                  accessibility: 1,
                  errorSymbolName: symbolToString(initialSymbol, enclosingDeclaration, meaning),
                  errorModuleName: symbol !== initialSymbol ? symbolToString(symbol, enclosingDeclaration, 1536) : undefined
                };
              }
              return hasAccessibleDeclarations;
            }
            meaningToLook = getQualifiedLeftMeaning(meaning);
            symbol = getParentOfSymbol(symbol);
          }
          var symbolExternalModule = ts.forEach(initialSymbol.declarations, getExternalModuleContainer);
          if (symbolExternalModule) {
            var enclosingExternalModule = getExternalModuleContainer(enclosingDeclaration);
            if (symbolExternalModule !== enclosingExternalModule) {
              return {
                accessibility: 2,
                errorSymbolName: symbolToString(initialSymbol, enclosingDeclaration, meaning),
                errorModuleName: symbolToString(symbolExternalModule)
              };
            }
          }
          return {
            accessibility: 1,
            errorSymbolName: symbolToString(initialSymbol, enclosingDeclaration, meaning)
          };
        }
        return {accessibility: 0};
        function getExternalModuleContainer(declaration) {
          for (; declaration; declaration = declaration.parent) {
            if (hasExternalModuleSymbol(declaration)) {
              return getSymbolOfNode(declaration);
            }
          }
        }
      }
      function hasExternalModuleSymbol(declaration) {
        return (declaration.kind === 216 && declaration.name.kind === 9) || (declaration.kind === 246 && ts.isExternalModule(declaration));
      }
      function hasVisibleDeclarations(symbol) {
        var aliasesToMakeVisible;
        if (ts.forEach(symbol.declarations, function(declaration) {
          return !getIsDeclarationVisible(declaration);
        })) {
          return undefined;
        }
        return {
          accessibility: 0,
          aliasesToMakeVisible: aliasesToMakeVisible
        };
        function getIsDeclarationVisible(declaration) {
          if (!isDeclarationVisible(declaration)) {
            var anyImportSyntax = getAnyImportSyntax(declaration);
            if (anyImportSyntax && !(anyImportSyntax.flags & 1) && isDeclarationVisible(anyImportSyntax.parent)) {
              getNodeLinks(declaration).isVisible = true;
              if (aliasesToMakeVisible) {
                if (!ts.contains(aliasesToMakeVisible, anyImportSyntax)) {
                  aliasesToMakeVisible.push(anyImportSyntax);
                }
              } else {
                aliasesToMakeVisible = [anyImportSyntax];
              }
              return true;
            }
            return false;
          }
          return true;
        }
      }
      function isEntityNameVisible(entityName, enclosingDeclaration) {
        var meaning;
        if (entityName.parent.kind === 152) {
          meaning = 107455 | 1048576;
        } else if (entityName.kind === 133 || entityName.kind === 164 || entityName.parent.kind === 219) {
          meaning = 1536;
        } else {
          meaning = 793056;
        }
        var firstIdentifier = getFirstIdentifier(entityName);
        var symbol = resolveName(enclosingDeclaration, firstIdentifier.text, meaning, undefined, undefined);
        return (symbol && hasVisibleDeclarations(symbol)) || {
          accessibility: 1,
          errorSymbolName: ts.getTextOfNode(firstIdentifier),
          errorNode: firstIdentifier
        };
      }
      function writeKeyword(writer, kind) {
        writer.writeKeyword(ts.tokenToString(kind));
      }
      function writePunctuation(writer, kind) {
        writer.writePunctuation(ts.tokenToString(kind));
      }
      function writeSpace(writer) {
        writer.writeSpace(" ");
      }
      function symbolToString(symbol, enclosingDeclaration, meaning) {
        var writer = ts.getSingleLineStringWriter();
        getSymbolDisplayBuilder().buildSymbolDisplay(symbol, writer, enclosingDeclaration, meaning);
        var result = writer.string();
        ts.releaseStringWriter(writer);
        return result;
      }
      function signatureToString(signature, enclosingDeclaration, flags) {
        var writer = ts.getSingleLineStringWriter();
        getSymbolDisplayBuilder().buildSignatureDisplay(signature, writer, enclosingDeclaration, flags);
        var result = writer.string();
        ts.releaseStringWriter(writer);
        return result;
      }
      function typeToString(type, enclosingDeclaration, flags) {
        var writer = ts.getSingleLineStringWriter();
        getSymbolDisplayBuilder().buildTypeDisplay(type, writer, enclosingDeclaration, flags);
        var result = writer.string();
        ts.releaseStringWriter(writer);
        var maxLength = compilerOptions.noErrorTruncation || flags & 4 ? undefined : 100;
        if (maxLength && result.length >= maxLength) {
          result = result.substr(0, maxLength - "...".length) + "...";
        }
        return result;
      }
      function getTypeAliasForTypeLiteral(type) {
        if (type.symbol && type.symbol.flags & 2048) {
          var node = type.symbol.declarations[0].parent;
          while (node.kind === 158) {
            node = node.parent;
          }
          if (node.kind === 214) {
            return getSymbolOfNode(node);
          }
        }
        return undefined;
      }
      function getSymbolDisplayBuilder() {
        function getNameOfSymbol(symbol) {
          if (symbol.declarations && symbol.declarations.length) {
            var declaration = symbol.declarations[0];
            if (declaration.name) {
              return ts.declarationNameToString(declaration.name);
            }
            switch (declaration.kind) {
              case 184:
                return "(Anonymous class)";
              case 171:
              case 172:
                return "(Anonymous function)";
            }
          }
          return symbol.name;
        }
        function appendSymbolNameOnly(symbol, writer) {
          writer.writeSymbol(getNameOfSymbol(symbol), symbol);
        }
        function buildSymbolDisplay(symbol, writer, enclosingDeclaration, meaning, flags, typeFlags) {
          var parentSymbol;
          function appendParentTypeArgumentsAndSymbolName(symbol) {
            if (parentSymbol) {
              if (flags & 1) {
                if (symbol.flags & 16777216) {
                  buildDisplayForTypeArgumentsAndDelimiters(getTypeParametersOfClassOrInterface(parentSymbol), symbol.mapper, writer, enclosingDeclaration);
                } else {
                  buildTypeParameterDisplayFromSymbol(parentSymbol, writer, enclosingDeclaration);
                }
              }
              writePunctuation(writer, 21);
            }
            parentSymbol = symbol;
            appendSymbolNameOnly(symbol, writer);
          }
          writer.trackSymbol(symbol, enclosingDeclaration, meaning);
          function walkSymbol(symbol, meaning) {
            if (symbol) {
              var accessibleSymbolChain = getAccessibleSymbolChain(symbol, enclosingDeclaration, meaning, !!(flags & 2));
              if (!accessibleSymbolChain || needsQualification(accessibleSymbolChain[0], enclosingDeclaration, accessibleSymbolChain.length === 1 ? meaning : getQualifiedLeftMeaning(meaning))) {
                walkSymbol(getParentOfSymbol(accessibleSymbolChain ? accessibleSymbolChain[0] : symbol), getQualifiedLeftMeaning(meaning));
              }
              if (accessibleSymbolChain) {
                for (var _i = 0; _i < accessibleSymbolChain.length; _i++) {
                  var accessibleSymbol = accessibleSymbolChain[_i];
                  appendParentTypeArgumentsAndSymbolName(accessibleSymbol);
                }
              } else {
                if (!parentSymbol && ts.forEach(symbol.declarations, hasExternalModuleSymbol)) {
                  return;
                }
                if (symbol.flags & 2048 || symbol.flags & 4096) {
                  return;
                }
                appendParentTypeArgumentsAndSymbolName(symbol);
              }
            }
          }
          var isTypeParameter = symbol.flags & 262144;
          var typeFormatFlag = 128 & typeFlags;
          if (!isTypeParameter && (enclosingDeclaration || typeFormatFlag)) {
            walkSymbol(symbol, meaning);
            return;
          }
          return appendParentTypeArgumentsAndSymbolName(symbol);
        }
        function buildTypeDisplay(type, writer, enclosingDeclaration, globalFlags, symbolStack) {
          var globalFlagsToPass = globalFlags & 16;
          return writeType(type, globalFlags);
          function writeType(type, flags) {
            if (type.flags & 16777343) {
              writer.writeKeyword(!(globalFlags & 16) && isTypeAny(type) ? "any" : type.intrinsicName);
            } else if (type.flags & 4096) {
              writeTypeReference(type, flags);
            } else if (type.flags & (1024 | 2048 | 128 | 512)) {
              buildSymbolDisplay(type.symbol, writer, enclosingDeclaration, 793056, 0, flags);
            } else if (type.flags & 8192) {
              writeTupleType(type);
            } else if (type.flags & 49152) {
              writeUnionOrIntersectionType(type, flags);
            } else if (type.flags & 65536) {
              writeAnonymousType(type, flags);
            } else if (type.flags & 256) {
              writer.writeStringLiteral(type.text);
            } else {
              writePunctuation(writer, 15);
              writeSpace(writer);
              writePunctuation(writer, 22);
              writeSpace(writer);
              writePunctuation(writer, 16);
            }
          }
          function writeTypeList(types, delimiter) {
            for (var i = 0; i < types.length; i++) {
              if (i > 0) {
                if (delimiter !== 24) {
                  writeSpace(writer);
                }
                writePunctuation(writer, delimiter);
                writeSpace(writer);
              }
              writeType(types[i], delimiter === 24 ? 0 : 64);
            }
          }
          function writeSymbolTypeReference(symbol, typeArguments, pos, end) {
            if (!isReservedMemberName(symbol.name)) {
              buildSymbolDisplay(symbol, writer, enclosingDeclaration, 793056);
            }
            if (pos < end) {
              writePunctuation(writer, 25);
              writeType(typeArguments[pos++], 0);
              while (pos < end) {
                writePunctuation(writer, 24);
                writeSpace(writer);
                writeType(typeArguments[pos++], 0);
              }
              writePunctuation(writer, 27);
            }
          }
          function writeTypeReference(type, flags) {
            var typeArguments = type.typeArguments;
            if (type.target === globalArrayType && !(flags & 1)) {
              writeType(typeArguments[0], 64);
              writePunctuation(writer, 19);
              writePunctuation(writer, 20);
            } else {
              var outerTypeParameters = type.target.outerTypeParameters;
              var i = 0;
              if (outerTypeParameters) {
                var length_1 = outerTypeParameters.length;
                while (i < length_1) {
                  var start = i;
                  var parent_3 = getParentSymbolOfTypeParameter(outerTypeParameters[i]);
                  do {
                    i++;
                  } while (i < length_1 && getParentSymbolOfTypeParameter(outerTypeParameters[i]) === parent_3);
                  if (!ts.rangeEquals(outerTypeParameters, typeArguments, start, i)) {
                    writeSymbolTypeReference(parent_3, typeArguments, start, i);
                    writePunctuation(writer, 21);
                  }
                }
              }
              writeSymbolTypeReference(type.symbol, typeArguments, i, typeArguments.length);
            }
          }
          function writeTupleType(type) {
            writePunctuation(writer, 19);
            writeTypeList(type.elementTypes, 24);
            writePunctuation(writer, 20);
          }
          function writeUnionOrIntersectionType(type, flags) {
            if (flags & 64) {
              writePunctuation(writer, 17);
            }
            writeTypeList(type.types, type.flags & 16384 ? 46 : 45);
            if (flags & 64) {
              writePunctuation(writer, 18);
            }
          }
          function writeAnonymousType(type, flags) {
            var symbol = type.symbol;
            if (symbol) {
              if (symbol.flags & (32 | 384 | 512)) {
                writeTypeofSymbol(type, flags);
              } else if (shouldWriteTypeOfFunctionSymbol()) {
                writeTypeofSymbol(type, flags);
              } else if (ts.contains(symbolStack, symbol)) {
                var typeAlias = getTypeAliasForTypeLiteral(type);
                if (typeAlias) {
                  buildSymbolDisplay(typeAlias, writer, enclosingDeclaration, 793056, 0, flags);
                } else {
                  writeKeyword(writer, 115);
                }
              } else {
                if (!symbolStack) {
                  symbolStack = [];
                }
                symbolStack.push(symbol);
                writeLiteralType(type, flags);
                symbolStack.pop();
              }
            } else {
              writeLiteralType(type, flags);
            }
            function shouldWriteTypeOfFunctionSymbol() {
              var isStaticMethodSymbol = !!(symbol.flags & 8192 && ts.forEach(symbol.declarations, function(declaration) {
                return declaration.flags & 128;
              }));
              var isNonLocalFunctionSymbol = !!(symbol.flags & 16) && (symbol.parent || ts.forEach(symbol.declarations, function(declaration) {
                return declaration.parent.kind === 246 || declaration.parent.kind === 217;
              }));
              if (isStaticMethodSymbol || isNonLocalFunctionSymbol) {
                return !!(flags & 2) || (ts.contains(symbolStack, symbol));
              }
            }
          }
          function writeTypeofSymbol(type, typeFormatFlags) {
            writeKeyword(writer, 99);
            writeSpace(writer);
            buildSymbolDisplay(type.symbol, writer, enclosingDeclaration, 107455, 0, typeFormatFlags);
          }
          function getIndexerParameterName(type, indexKind, fallbackName) {
            var declaration = getIndexDeclarationOfSymbol(type.symbol, indexKind);
            if (!declaration) {
              return fallbackName;
            }
            ts.Debug.assert(declaration.parameters.length !== 0);
            return ts.declarationNameToString(declaration.parameters[0].name);
          }
          function writeLiteralType(type, flags) {
            var resolved = resolveStructuredTypeMembers(type);
            if (!resolved.properties.length && !resolved.stringIndexType && !resolved.numberIndexType) {
              if (!resolved.callSignatures.length && !resolved.constructSignatures.length) {
                writePunctuation(writer, 15);
                writePunctuation(writer, 16);
                return;
              }
              if (resolved.callSignatures.length === 1 && !resolved.constructSignatures.length) {
                if (flags & 64) {
                  writePunctuation(writer, 17);
                }
                buildSignatureDisplay(resolved.callSignatures[0], writer, enclosingDeclaration, globalFlagsToPass | 8, symbolStack);
                if (flags & 64) {
                  writePunctuation(writer, 18);
                }
                return;
              }
              if (resolved.constructSignatures.length === 1 && !resolved.callSignatures.length) {
                if (flags & 64) {
                  writePunctuation(writer, 17);
                }
                writeKeyword(writer, 90);
                writeSpace(writer);
                buildSignatureDisplay(resolved.constructSignatures[0], writer, enclosingDeclaration, globalFlagsToPass | 8, symbolStack);
                if (flags & 64) {
                  writePunctuation(writer, 18);
                }
                return;
              }
            }
            writePunctuation(writer, 15);
            writer.writeLine();
            writer.increaseIndent();
            for (var _i = 0,
                _a = resolved.callSignatures; _i < _a.length; _i++) {
              var signature = _a[_i];
              buildSignatureDisplay(signature, writer, enclosingDeclaration, globalFlagsToPass, symbolStack);
              writePunctuation(writer, 23);
              writer.writeLine();
            }
            for (var _b = 0,
                _c = resolved.constructSignatures; _b < _c.length; _b++) {
              var signature = _c[_b];
              writeKeyword(writer, 90);
              writeSpace(writer);
              buildSignatureDisplay(signature, writer, enclosingDeclaration, globalFlagsToPass, symbolStack);
              writePunctuation(writer, 23);
              writer.writeLine();
            }
            if (resolved.stringIndexType) {
              writePunctuation(writer, 19);
              writer.writeParameter(getIndexerParameterName(resolved, 0, "x"));
              writePunctuation(writer, 53);
              writeSpace(writer);
              writeKeyword(writer, 128);
              writePunctuation(writer, 20);
              writePunctuation(writer, 53);
              writeSpace(writer);
              writeType(resolved.stringIndexType, 0);
              writePunctuation(writer, 23);
              writer.writeLine();
            }
            if (resolved.numberIndexType) {
              writePunctuation(writer, 19);
              writer.writeParameter(getIndexerParameterName(resolved, 1, "x"));
              writePunctuation(writer, 53);
              writeSpace(writer);
              writeKeyword(writer, 126);
              writePunctuation(writer, 20);
              writePunctuation(writer, 53);
              writeSpace(writer);
              writeType(resolved.numberIndexType, 0);
              writePunctuation(writer, 23);
              writer.writeLine();
            }
            for (var _d = 0,
                _e = resolved.properties; _d < _e.length; _d++) {
              var p = _e[_d];
              var t = getTypeOfSymbol(p);
              if (p.flags & (16 | 8192) && !getPropertiesOfObjectType(t).length) {
                var signatures = getSignaturesOfType(t, 0);
                for (var _f = 0; _f < signatures.length; _f++) {
                  var signature = signatures[_f];
                  buildSymbolDisplay(p, writer);
                  if (p.flags & 536870912) {
                    writePunctuation(writer, 52);
                  }
                  buildSignatureDisplay(signature, writer, enclosingDeclaration, globalFlagsToPass, symbolStack);
                  writePunctuation(writer, 23);
                  writer.writeLine();
                }
              } else {
                buildSymbolDisplay(p, writer);
                if (p.flags & 536870912) {
                  writePunctuation(writer, 52);
                }
                writePunctuation(writer, 53);
                writeSpace(writer);
                writeType(t, 0);
                writePunctuation(writer, 23);
                writer.writeLine();
              }
            }
            writer.decreaseIndent();
            writePunctuation(writer, 16);
          }
        }
        function buildTypeParameterDisplayFromSymbol(symbol, writer, enclosingDeclaraiton, flags) {
          var targetSymbol = getTargetSymbol(symbol);
          if (targetSymbol.flags & 32 || targetSymbol.flags & 64 || targetSymbol.flags & 524288) {
            buildDisplayForTypeParametersAndDelimiters(getLocalTypeParametersOfClassOrInterfaceOrTypeAlias(symbol), writer, enclosingDeclaraiton, flags);
          }
        }
        function buildTypeParameterDisplay(tp, writer, enclosingDeclaration, flags, symbolStack) {
          appendSymbolNameOnly(tp.symbol, writer);
          var constraint = getConstraintOfTypeParameter(tp);
          if (constraint) {
            writeSpace(writer);
            writeKeyword(writer, 81);
            writeSpace(writer);
            buildTypeDisplay(constraint, writer, enclosingDeclaration, flags, symbolStack);
          }
        }
        function buildParameterDisplay(p, writer, enclosingDeclaration, flags, symbolStack) {
          var parameterNode = p.valueDeclaration;
          if (ts.isRestParameter(parameterNode)) {
            writePunctuation(writer, 22);
          }
          appendSymbolNameOnly(p, writer);
          if (isOptionalParameter(parameterNode)) {
            writePunctuation(writer, 52);
          }
          writePunctuation(writer, 53);
          writeSpace(writer);
          buildTypeDisplay(getTypeOfSymbol(p), writer, enclosingDeclaration, flags, symbolStack);
        }
        function buildDisplayForTypeParametersAndDelimiters(typeParameters, writer, enclosingDeclaration, flags, symbolStack) {
          if (typeParameters && typeParameters.length) {
            writePunctuation(writer, 25);
            for (var i = 0; i < typeParameters.length; i++) {
              if (i > 0) {
                writePunctuation(writer, 24);
                writeSpace(writer);
              }
              buildTypeParameterDisplay(typeParameters[i], writer, enclosingDeclaration, flags, symbolStack);
            }
            writePunctuation(writer, 27);
          }
        }
        function buildDisplayForTypeArgumentsAndDelimiters(typeParameters, mapper, writer, enclosingDeclaration, flags, symbolStack) {
          if (typeParameters && typeParameters.length) {
            writePunctuation(writer, 25);
            for (var i = 0; i < typeParameters.length; i++) {
              if (i > 0) {
                writePunctuation(writer, 24);
                writeSpace(writer);
              }
              buildTypeDisplay(mapper(typeParameters[i]), writer, enclosingDeclaration, 0);
            }
            writePunctuation(writer, 27);
          }
        }
        function buildDisplayForParametersAndDelimiters(parameters, writer, enclosingDeclaration, flags, symbolStack) {
          writePunctuation(writer, 17);
          for (var i = 0; i < parameters.length; i++) {
            if (i > 0) {
              writePunctuation(writer, 24);
              writeSpace(writer);
            }
            buildParameterDisplay(parameters[i], writer, enclosingDeclaration, flags, symbolStack);
          }
          writePunctuation(writer, 18);
        }
        function buildReturnTypeDisplay(signature, writer, enclosingDeclaration, flags, symbolStack) {
          if (flags & 8) {
            writeSpace(writer);
            writePunctuation(writer, 34);
          } else {
            writePunctuation(writer, 53);
          }
          writeSpace(writer);
          var returnType;
          if (signature.typePredicate) {
            writer.writeParameter(signature.typePredicate.parameterName);
            writeSpace(writer);
            writeKeyword(writer, 122);
            writeSpace(writer);
            returnType = signature.typePredicate.type;
          } else {
            returnType = getReturnTypeOfSignature(signature);
          }
          buildTypeDisplay(returnType, writer, enclosingDeclaration, flags, symbolStack);
        }
        function buildSignatureDisplay(signature, writer, enclosingDeclaration, flags, symbolStack) {
          if (signature.target && (flags & 32)) {
            buildDisplayForTypeArgumentsAndDelimiters(signature.target.typeParameters, signature.mapper, writer, enclosingDeclaration);
          } else {
            buildDisplayForTypeParametersAndDelimiters(signature.typeParameters, writer, enclosingDeclaration, flags, symbolStack);
          }
          buildDisplayForParametersAndDelimiters(signature.parameters, writer, enclosingDeclaration, flags, symbolStack);
          buildReturnTypeDisplay(signature, writer, enclosingDeclaration, flags, symbolStack);
        }
        return _displayBuilder || (_displayBuilder = {
          buildSymbolDisplay: buildSymbolDisplay,
          buildTypeDisplay: buildTypeDisplay,
          buildTypeParameterDisplay: buildTypeParameterDisplay,
          buildParameterDisplay: buildParameterDisplay,
          buildDisplayForParametersAndDelimiters: buildDisplayForParametersAndDelimiters,
          buildDisplayForTypeParametersAndDelimiters: buildDisplayForTypeParametersAndDelimiters,
          buildTypeParameterDisplayFromSymbol: buildTypeParameterDisplayFromSymbol,
          buildSignatureDisplay: buildSignatureDisplay,
          buildReturnTypeDisplay: buildReturnTypeDisplay
        });
      }
      function isDeclarationVisible(node) {
        function getContainingExternalModule(node) {
          for (; node; node = node.parent) {
            if (node.kind === 216) {
              if (node.name.kind === 9) {
                return node;
              }
            } else if (node.kind === 246) {
              return ts.isExternalModule(node) ? node : undefined;
            }
          }
          ts.Debug.fail("getContainingModule cant reach here");
        }
        function isUsedInExportAssignment(node) {
          var externalModule = getContainingExternalModule(node);
          var exportAssignmentSymbol;
          var resolvedExportSymbol;
          if (externalModule) {
            var externalModuleSymbol = getSymbolOfNode(externalModule);
            exportAssignmentSymbol = getExportAssignmentSymbol(externalModuleSymbol);
            var symbolOfNode = getSymbolOfNode(node);
            if (isSymbolUsedInExportAssignment(symbolOfNode)) {
              return true;
            }
            if (symbolOfNode.flags & 8388608) {
              return isSymbolUsedInExportAssignment(resolveAlias(symbolOfNode));
            }
          }
          function isSymbolUsedInExportAssignment(symbol) {
            if (exportAssignmentSymbol === symbol) {
              return true;
            }
            if (exportAssignmentSymbol && !!(exportAssignmentSymbol.flags & 8388608)) {
              resolvedExportSymbol = resolvedExportSymbol || resolveAlias(exportAssignmentSymbol);
              if (resolvedExportSymbol === symbol) {
                return true;
              }
              return ts.forEach(resolvedExportSymbol.declarations, function(current) {
                while (current) {
                  if (current === node) {
                    return true;
                  }
                  current = current.parent;
                }
              });
            }
          }
        }
        function determineIfDeclarationIsVisible() {
          switch (node.kind) {
            case 161:
              return isDeclarationVisible(node.parent.parent);
            case 209:
              if (ts.isBindingPattern(node.name) && !node.name.elements.length) {
                return false;
              }
            case 216:
            case 212:
            case 213:
            case 214:
            case 211:
            case 215:
            case 219:
              var parent_4 = getDeclarationContainer(node);
              if (!(ts.getCombinedNodeFlags(node) & 1) && !(node.kind !== 219 && parent_4.kind !== 246 && ts.isInAmbientContext(parent_4))) {
                return isGlobalSourceFile(parent_4);
              }
              return isDeclarationVisible(parent_4);
            case 139:
            case 138:
            case 143:
            case 144:
            case 141:
            case 140:
              if (node.flags & (32 | 64)) {
                return false;
              }
            case 142:
            case 146:
            case 145:
            case 147:
            case 136:
            case 217:
            case 150:
            case 151:
            case 153:
            case 149:
            case 154:
            case 155:
            case 156:
            case 157:
            case 158:
              return isDeclarationVisible(node.parent);
            case 221:
            case 222:
            case 224:
              return false;
            case 135:
            case 246:
              return true;
            case 225:
              return false;
            default:
              ts.Debug.fail("isDeclarationVisible unknown: SyntaxKind: " + node.kind);
          }
        }
        if (node) {
          var links = getNodeLinks(node);
          if (links.isVisible === undefined) {
            links.isVisible = !!determineIfDeclarationIsVisible();
          }
          return links.isVisible;
        }
      }
      function collectLinkedAliases(node) {
        var exportSymbol;
        if (node.parent && node.parent.kind === 225) {
          exportSymbol = resolveName(node.parent, node.text, 107455 | 793056 | 1536 | 8388608, ts.Diagnostics.Cannot_find_name_0, node);
        } else if (node.parent.kind === 228) {
          var exportSpecifier = node.parent;
          exportSymbol = exportSpecifier.parent.parent.moduleSpecifier ? getExternalModuleMember(exportSpecifier.parent.parent, exportSpecifier) : resolveEntityName(exportSpecifier.propertyName || exportSpecifier.name, 107455 | 793056 | 1536 | 8388608);
        }
        var result = [];
        if (exportSymbol) {
          buildVisibleNodeList(exportSymbol.declarations);
        }
        return result;
        function buildVisibleNodeList(declarations) {
          ts.forEach(declarations, function(declaration) {
            getNodeLinks(declaration).isVisible = true;
            var resultNode = getAnyImportSyntax(declaration) || declaration;
            if (!ts.contains(result, resultNode)) {
              result.push(resultNode);
            }
            if (ts.isInternalModuleImportEqualsDeclaration(declaration)) {
              var internalModuleReference = declaration.moduleReference;
              var firstIdentifier = getFirstIdentifier(internalModuleReference);
              var importSymbol = resolveName(declaration, firstIdentifier.text, 107455 | 793056 | 1536, ts.Diagnostics.Cannot_find_name_0, firstIdentifier);
              buildVisibleNodeList(importSymbol.declarations);
            }
          });
        }
      }
      function pushTypeResolution(target, propertyName) {
        var resolutionCycleStartIndex = findResolutionCycleStartIndex(target, propertyName);
        if (resolutionCycleStartIndex >= 0) {
          var length_2 = resolutionTargets.length;
          for (var i = resolutionCycleStartIndex; i < length_2; i++) {
            resolutionResults[i] = false;
          }
          return false;
        }
        resolutionTargets.push(target);
        resolutionResults.push(true);
        resolutionPropertyNames.push(propertyName);
        return true;
      }
      function findResolutionCycleStartIndex(target, propertyName) {
        for (var i = resolutionTargets.length - 1; i >= 0; i--) {
          if (hasType(resolutionTargets[i], resolutionPropertyNames[i])) {
            return -1;
          }
          if (resolutionTargets[i] === target && resolutionPropertyNames[i] === propertyName) {
            return i;
          }
        }
        return -1;
      }
      function hasType(target, propertyName) {
        if (propertyName === 0) {
          return getSymbolLinks(target).type;
        }
        if (propertyName === 2) {
          return getSymbolLinks(target).declaredType;
        }
        if (propertyName === 1) {
          ts.Debug.assert(!!(target.flags & 1024));
          return target.resolvedBaseConstructorType;
        }
        if (propertyName === 3) {
          return target.resolvedReturnType;
        }
        ts.Debug.fail("Unhandled TypeSystemPropertyName " + propertyName);
      }
      function popTypeResolution() {
        resolutionTargets.pop();
        resolutionPropertyNames.pop();
        return resolutionResults.pop();
      }
      function getDeclarationContainer(node) {
        node = ts.getRootDeclaration(node);
        return node.kind === 209 ? node.parent.parent.parent : node.parent;
      }
      function getTypeOfPrototypeProperty(prototype) {
        var classType = getDeclaredTypeOfSymbol(prototype.parent);
        return classType.typeParameters ? createTypeReference(classType, ts.map(classType.typeParameters, function(_) {
          return anyType;
        })) : classType;
      }
      function getTypeOfPropertyOfType(type, name) {
        var prop = getPropertyOfType(type, name);
        return prop ? getTypeOfSymbol(prop) : undefined;
      }
      function isTypeAny(type) {
        return type && (type.flags & 1) !== 0;
      }
      function getTypeForBindingElement(declaration) {
        var pattern = declaration.parent;
        var parentType = getTypeForVariableLikeDeclaration(pattern.parent);
        if (parentType === unknownType) {
          return unknownType;
        }
        if (!parentType || isTypeAny(parentType)) {
          if (declaration.initializer) {
            return checkExpressionCached(declaration.initializer);
          }
          return parentType;
        }
        var type;
        if (pattern.kind === 159) {
          var name_10 = declaration.propertyName || declaration.name;
          type = getTypeOfPropertyOfType(parentType, name_10.text) || isNumericLiteralName(name_10.text) && getIndexTypeOfType(parentType, 1) || getIndexTypeOfType(parentType, 0);
          if (!type) {
            error(name_10, ts.Diagnostics.Type_0_has_no_property_1_and_no_string_index_signature, typeToString(parentType), ts.declarationNameToString(name_10));
            return unknownType;
          }
        } else {
          var elementType = checkIteratedTypeOrElementType(parentType, pattern, false);
          if (!declaration.dotDotDotToken) {
            var propName = "" + ts.indexOf(pattern.elements, declaration);
            type = isTupleLikeType(parentType) ? getTypeOfPropertyOfType(parentType, propName) : elementType;
            if (!type) {
              if (isTupleType(parentType)) {
                error(declaration, ts.Diagnostics.Tuple_type_0_with_length_1_cannot_be_assigned_to_tuple_with_length_2, typeToString(parentType), parentType.elementTypes.length, pattern.elements.length);
              } else {
                error(declaration, ts.Diagnostics.Type_0_has_no_property_1, typeToString(parentType), propName);
              }
              return unknownType;
            }
          } else {
            type = createArrayType(elementType);
          }
        }
        return type;
      }
      function getTypeForVariableLikeDeclaration(declaration) {
        if (declaration.parent.parent.kind === 198) {
          return anyType;
        }
        if (declaration.parent.parent.kind === 199) {
          return checkRightHandSideOfForOf(declaration.parent.parent.expression) || anyType;
        }
        if (ts.isBindingPattern(declaration.parent)) {
          return getTypeForBindingElement(declaration);
        }
        if (declaration.type) {
          return getTypeFromTypeNode(declaration.type);
        }
        if (declaration.kind === 136) {
          var func = declaration.parent;
          if (func.kind === 144 && !ts.hasDynamicName(func)) {
            var getter = ts.getDeclarationOfKind(declaration.parent.symbol, 143);
            if (getter) {
              return getReturnTypeOfSignature(getSignatureFromDeclaration(getter));
            }
          }
          var type = getContextuallyTypedParameterType(declaration);
          if (type) {
            return type;
          }
        }
        if (declaration.initializer) {
          return checkExpressionCached(declaration.initializer);
        }
        if (declaration.kind === 244) {
          return checkIdentifier(declaration.name);
        }
        if (ts.isBindingPattern(declaration.name)) {
          return getTypeFromBindingPattern(declaration.name);
        }
        return undefined;
      }
      function getTypeFromBindingElement(element) {
        if (element.initializer) {
          return getWidenedType(checkExpressionCached(element.initializer));
        }
        if (ts.isBindingPattern(element.name)) {
          return getTypeFromBindingPattern(element.name);
        }
        return anyType;
      }
      function getTypeFromObjectBindingPattern(pattern) {
        var members = {};
        ts.forEach(pattern.elements, function(e) {
          var flags = 4 | 67108864 | (e.initializer ? 536870912 : 0);
          var name = e.propertyName || e.name;
          var symbol = createSymbol(flags, name.text);
          symbol.type = getTypeFromBindingElement(e);
          members[symbol.name] = symbol;
        });
        return createAnonymousType(undefined, members, emptyArray, emptyArray, undefined, undefined);
      }
      function getTypeFromArrayBindingPattern(pattern) {
        var hasSpreadElement = false;
        var elementTypes = [];
        ts.forEach(pattern.elements, function(e) {
          elementTypes.push(e.kind === 185 || e.dotDotDotToken ? anyType : getTypeFromBindingElement(e));
          if (e.dotDotDotToken) {
            hasSpreadElement = true;
          }
        });
        if (!elementTypes.length) {
          return languageVersion >= 2 ? createIterableType(anyType) : anyArrayType;
        } else if (hasSpreadElement) {
          var unionOfElements = getUnionType(elementTypes);
          return languageVersion >= 2 ? createIterableType(unionOfElements) : createArrayType(unionOfElements);
        }
        return createTupleType(elementTypes);
      }
      function getTypeFromBindingPattern(pattern) {
        return pattern.kind === 159 ? getTypeFromObjectBindingPattern(pattern) : getTypeFromArrayBindingPattern(pattern);
      }
      function getWidenedTypeForVariableLikeDeclaration(declaration, reportErrors) {
        var type = getTypeForVariableLikeDeclaration(declaration);
        if (type) {
          if (reportErrors) {
            reportErrorsFromWidening(declaration, type);
          }
          return declaration.kind !== 243 ? getWidenedType(type) : type;
        }
        type = declaration.dotDotDotToken ? anyArrayType : anyType;
        if (reportErrors && compilerOptions.noImplicitAny) {
          var root = ts.getRootDeclaration(declaration);
          if (!isPrivateWithinAmbient(root) && !(root.kind === 136 && isPrivateWithinAmbient(root.parent))) {
            reportImplicitAnyError(declaration, type);
          }
        }
        return type;
      }
      function getTypeOfVariableOrParameterOrProperty(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.type) {
          if (symbol.flags & 134217728) {
            return links.type = getTypeOfPrototypeProperty(symbol);
          }
          var declaration = symbol.valueDeclaration;
          if (declaration.parent.kind === 242) {
            return links.type = anyType;
          }
          if (declaration.kind === 225) {
            return links.type = checkExpression(declaration.expression);
          }
          if (!pushTypeResolution(symbol, 0)) {
            return unknownType;
          }
          var type = getWidenedTypeForVariableLikeDeclaration(declaration, true);
          if (!popTypeResolution()) {
            if (symbol.valueDeclaration.type) {
              type = unknownType;
              error(symbol.valueDeclaration, ts.Diagnostics._0_is_referenced_directly_or_indirectly_in_its_own_type_annotation, symbolToString(symbol));
            } else {
              type = anyType;
              if (compilerOptions.noImplicitAny) {
                error(symbol.valueDeclaration, ts.Diagnostics._0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or_indirectly_in_its_own_initializer, symbolToString(symbol));
              }
            }
          }
          links.type = type;
        }
        return links.type;
      }
      function getAnnotatedAccessorType(accessor) {
        if (accessor) {
          if (accessor.kind === 143) {
            return accessor.type && getTypeFromTypeNode(accessor.type);
          } else {
            var setterTypeAnnotation = ts.getSetAccessorTypeAnnotationNode(accessor);
            return setterTypeAnnotation && getTypeFromTypeNode(setterTypeAnnotation);
          }
        }
        return undefined;
      }
      function getTypeOfAccessors(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.type) {
          if (!pushTypeResolution(symbol, 0)) {
            return unknownType;
          }
          var getter = ts.getDeclarationOfKind(symbol, 143);
          var setter = ts.getDeclarationOfKind(symbol, 144);
          var type;
          var getterReturnType = getAnnotatedAccessorType(getter);
          if (getterReturnType) {
            type = getterReturnType;
          } else {
            var setterParameterType = getAnnotatedAccessorType(setter);
            if (setterParameterType) {
              type = setterParameterType;
            } else {
              if (getter && getter.body) {
                type = getReturnTypeFromBody(getter);
              } else {
                if (compilerOptions.noImplicitAny) {
                  error(setter, ts.Diagnostics.Property_0_implicitly_has_type_any_because_its_set_accessor_lacks_a_type_annotation, symbolToString(symbol));
                }
                type = anyType;
              }
            }
          }
          if (!popTypeResolution()) {
            type = anyType;
            if (compilerOptions.noImplicitAny) {
              var getter_1 = ts.getDeclarationOfKind(symbol, 143);
              error(getter_1, ts.Diagnostics._0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions, symbolToString(symbol));
            }
          }
          links.type = type;
        }
        return links.type;
      }
      function getTypeOfFuncClassEnumModule(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.type) {
          links.type = createObjectType(65536, symbol);
        }
        return links.type;
      }
      function getTypeOfEnumMember(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.type) {
          links.type = getDeclaredTypeOfEnum(getParentOfSymbol(symbol));
        }
        return links.type;
      }
      function getTypeOfAlias(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.type) {
          var targetSymbol = resolveAlias(symbol);
          links.type = targetSymbol.flags & 107455 ? getTypeOfSymbol(targetSymbol) : unknownType;
        }
        return links.type;
      }
      function getTypeOfInstantiatedSymbol(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.type) {
          links.type = instantiateType(getTypeOfSymbol(links.target), links.mapper);
        }
        return links.type;
      }
      function getTypeOfSymbol(symbol) {
        if (symbol.flags & 16777216) {
          return getTypeOfInstantiatedSymbol(symbol);
        }
        if (symbol.flags & (3 | 4)) {
          return getTypeOfVariableOrParameterOrProperty(symbol);
        }
        if (symbol.flags & (16 | 8192 | 32 | 384 | 512)) {
          return getTypeOfFuncClassEnumModule(symbol);
        }
        if (symbol.flags & 8) {
          return getTypeOfEnumMember(symbol);
        }
        if (symbol.flags & 98304) {
          return getTypeOfAccessors(symbol);
        }
        if (symbol.flags & 8388608) {
          return getTypeOfAlias(symbol);
        }
        return unknownType;
      }
      function getTargetType(type) {
        return type.flags & 4096 ? type.target : type;
      }
      function hasBaseType(type, checkBase) {
        return check(type);
        function check(type) {
          var target = getTargetType(type);
          return target === checkBase || ts.forEach(getBaseTypes(target), check);
        }
      }
      function appendTypeParameters(typeParameters, declarations) {
        for (var _i = 0; _i < declarations.length; _i++) {
          var declaration = declarations[_i];
          var tp = getDeclaredTypeOfTypeParameter(getSymbolOfNode(declaration));
          if (!typeParameters) {
            typeParameters = [tp];
          } else if (!ts.contains(typeParameters, tp)) {
            typeParameters.push(tp);
          }
        }
        return typeParameters;
      }
      function appendOuterTypeParameters(typeParameters, node) {
        while (true) {
          node = node.parent;
          if (!node) {
            return typeParameters;
          }
          if (node.kind === 212 || node.kind === 184 || node.kind === 211 || node.kind === 171 || node.kind === 141 || node.kind === 172) {
            var declarations = node.typeParameters;
            if (declarations) {
              return appendTypeParameters(appendOuterTypeParameters(typeParameters, node), declarations);
            }
          }
        }
      }
      function getOuterTypeParametersOfClassOrInterface(symbol) {
        var declaration = symbol.flags & 32 ? symbol.valueDeclaration : ts.getDeclarationOfKind(symbol, 213);
        return appendOuterTypeParameters(undefined, declaration);
      }
      function getLocalTypeParametersOfClassOrInterfaceOrTypeAlias(symbol) {
        var result;
        for (var _i = 0,
            _a = symbol.declarations; _i < _a.length; _i++) {
          var node = _a[_i];
          if (node.kind === 213 || node.kind === 212 || node.kind === 184 || node.kind === 214) {
            var declaration = node;
            if (declaration.typeParameters) {
              result = appendTypeParameters(result, declaration.typeParameters);
            }
          }
        }
        return result;
      }
      function getTypeParametersOfClassOrInterface(symbol) {
        return ts.concatenate(getOuterTypeParametersOfClassOrInterface(symbol), getLocalTypeParametersOfClassOrInterfaceOrTypeAlias(symbol));
      }
      function isConstructorType(type) {
        return type.flags & 80896 && getSignaturesOfType(type, 1).length > 0;
      }
      function getBaseTypeNodeOfClass(type) {
        return ts.getClassExtendsHeritageClauseElement(type.symbol.valueDeclaration);
      }
      function getConstructorsForTypeArguments(type, typeArgumentNodes) {
        var typeArgCount = typeArgumentNodes ? typeArgumentNodes.length : 0;
        return ts.filter(getSignaturesOfType(type, 1), function(sig) {
          return (sig.typeParameters ? sig.typeParameters.length : 0) === typeArgCount;
        });
      }
      function getInstantiatedConstructorsForTypeArguments(type, typeArgumentNodes) {
        var signatures = getConstructorsForTypeArguments(type, typeArgumentNodes);
        if (typeArgumentNodes) {
          var typeArguments = ts.map(typeArgumentNodes, getTypeFromTypeNode);
          signatures = ts.map(signatures, function(sig) {
            return getSignatureInstantiation(sig, typeArguments);
          });
        }
        return signatures;
      }
      function getBaseConstructorTypeOfClass(type) {
        if (!type.resolvedBaseConstructorType) {
          var baseTypeNode = getBaseTypeNodeOfClass(type);
          if (!baseTypeNode) {
            return type.resolvedBaseConstructorType = undefinedType;
          }
          if (!pushTypeResolution(type, 1)) {
            return unknownType;
          }
          var baseConstructorType = checkExpression(baseTypeNode.expression);
          if (baseConstructorType.flags & 80896) {
            resolveStructuredTypeMembers(baseConstructorType);
          }
          if (!popTypeResolution()) {
            error(type.symbol.valueDeclaration, ts.Diagnostics._0_is_referenced_directly_or_indirectly_in_its_own_base_expression, symbolToString(type.symbol));
            return type.resolvedBaseConstructorType = unknownType;
          }
          if (baseConstructorType !== unknownType && baseConstructorType !== nullType && !isConstructorType(baseConstructorType)) {
            error(baseTypeNode.expression, ts.Diagnostics.Type_0_is_not_a_constructor_function_type, typeToString(baseConstructorType));
            return type.resolvedBaseConstructorType = unknownType;
          }
          type.resolvedBaseConstructorType = baseConstructorType;
        }
        return type.resolvedBaseConstructorType;
      }
      function getBaseTypes(type) {
        if (!type.resolvedBaseTypes) {
          if (type.symbol.flags & 32) {
            resolveBaseTypesOfClass(type);
          } else if (type.symbol.flags & 64) {
            resolveBaseTypesOfInterface(type);
          } else {
            ts.Debug.fail("type must be class or interface");
          }
        }
        return type.resolvedBaseTypes;
      }
      function resolveBaseTypesOfClass(type) {
        type.resolvedBaseTypes = emptyArray;
        var baseContructorType = getBaseConstructorTypeOfClass(type);
        if (!(baseContructorType.flags & 80896)) {
          return;
        }
        var baseTypeNode = getBaseTypeNodeOfClass(type);
        var baseType;
        if (baseContructorType.symbol && baseContructorType.symbol.flags & 32) {
          baseType = getTypeFromClassOrInterfaceReference(baseTypeNode, baseContructorType.symbol);
        } else {
          var constructors = getInstantiatedConstructorsForTypeArguments(baseContructorType, baseTypeNode.typeArguments);
          if (!constructors.length) {
            error(baseTypeNode.expression, ts.Diagnostics.No_base_constructor_has_the_specified_number_of_type_arguments);
            return;
          }
          baseType = getReturnTypeOfSignature(constructors[0]);
        }
        if (baseType === unknownType) {
          return;
        }
        if (!(getTargetType(baseType).flags & (1024 | 2048))) {
          error(baseTypeNode.expression, ts.Diagnostics.Base_constructor_return_type_0_is_not_a_class_or_interface_type, typeToString(baseType));
          return;
        }
        if (type === baseType || hasBaseType(baseType, type)) {
          error(type.symbol.valueDeclaration, ts.Diagnostics.Type_0_recursively_references_itself_as_a_base_type, typeToString(type, undefined, 1));
          return;
        }
        type.resolvedBaseTypes = [baseType];
      }
      function resolveBaseTypesOfInterface(type) {
        type.resolvedBaseTypes = [];
        for (var _i = 0,
            _a = type.symbol.declarations; _i < _a.length; _i++) {
          var declaration = _a[_i];
          if (declaration.kind === 213 && ts.getInterfaceBaseTypeNodes(declaration)) {
            for (var _b = 0,
                _c = ts.getInterfaceBaseTypeNodes(declaration); _b < _c.length; _b++) {
              var node = _c[_b];
              var baseType = getTypeFromTypeNode(node);
              if (baseType !== unknownType) {
                if (getTargetType(baseType).flags & (1024 | 2048)) {
                  if (type !== baseType && !hasBaseType(baseType, type)) {
                    type.resolvedBaseTypes.push(baseType);
                  } else {
                    error(declaration, ts.Diagnostics.Type_0_recursively_references_itself_as_a_base_type, typeToString(type, undefined, 1));
                  }
                } else {
                  error(node, ts.Diagnostics.An_interface_may_only_extend_a_class_or_another_interface);
                }
              }
            }
          }
        }
      }
      function getDeclaredTypeOfClassOrInterface(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.declaredType) {
          var kind = symbol.flags & 32 ? 1024 : 2048;
          var type = links.declaredType = createObjectType(kind, symbol);
          var outerTypeParameters = getOuterTypeParametersOfClassOrInterface(symbol);
          var localTypeParameters = getLocalTypeParametersOfClassOrInterfaceOrTypeAlias(symbol);
          if (outerTypeParameters || localTypeParameters) {
            type.flags |= 4096;
            type.typeParameters = ts.concatenate(outerTypeParameters, localTypeParameters);
            type.outerTypeParameters = outerTypeParameters;
            type.localTypeParameters = localTypeParameters;
            type.instantiations = {};
            type.instantiations[getTypeListId(type.typeParameters)] = type;
            type.target = type;
            type.typeArguments = type.typeParameters;
          }
        }
        return links.declaredType;
      }
      function getDeclaredTypeOfTypeAlias(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.declaredType) {
          if (!pushTypeResolution(symbol, 2)) {
            return unknownType;
          }
          var declaration = ts.getDeclarationOfKind(symbol, 214);
          var type = getTypeFromTypeNode(declaration.type);
          if (popTypeResolution()) {
            links.typeParameters = getLocalTypeParametersOfClassOrInterfaceOrTypeAlias(symbol);
            if (links.typeParameters) {
              links.instantiations = {};
              links.instantiations[getTypeListId(links.typeParameters)] = type;
            }
          } else {
            type = unknownType;
            error(declaration.name, ts.Diagnostics.Type_alias_0_circularly_references_itself, symbolToString(symbol));
          }
          links.declaredType = type;
        }
        return links.declaredType;
      }
      function getDeclaredTypeOfEnum(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.declaredType) {
          var type = createType(128);
          type.symbol = symbol;
          links.declaredType = type;
        }
        return links.declaredType;
      }
      function getDeclaredTypeOfTypeParameter(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.declaredType) {
          var type = createType(512);
          type.symbol = symbol;
          if (!ts.getDeclarationOfKind(symbol, 135).constraint) {
            type.constraint = noConstraintType;
          }
          links.declaredType = type;
        }
        return links.declaredType;
      }
      function getDeclaredTypeOfAlias(symbol) {
        var links = getSymbolLinks(symbol);
        if (!links.declaredType) {
          links.declaredType = getDeclaredTypeOfSymbol(resolveAlias(symbol));
        }
        return links.declaredType;
      }
      function getDeclaredTypeOfSymbol(symbol) {
        ts.Debug.assert((symbol.flags & 16777216) === 0);
        if (symbol.flags & (32 | 64)) {
          return getDeclaredTypeOfClassOrInterface(symbol);
        }
        if (symbol.flags & 524288) {
          return getDeclaredTypeOfTypeAlias(symbol);
        }
        if (symbol.flags & 384) {
          return getDeclaredTypeOfEnum(symbol);
        }
        if (symbol.flags & 262144) {
          return getDeclaredTypeOfTypeParameter(symbol);
        }
        if (symbol.flags & 8388608) {
          return getDeclaredTypeOfAlias(symbol);
        }
        return unknownType;
      }
      function createSymbolTable(symbols) {
        var result = {};
        for (var _i = 0; _i < symbols.length; _i++) {
          var symbol = symbols[_i];
          result[symbol.name] = symbol;
        }
        return result;
      }
      function createInstantiatedSymbolTable(symbols, mapper) {
        var result = {};
        for (var _i = 0; _i < symbols.length; _i++) {
          var symbol = symbols[_i];
          result[symbol.name] = instantiateSymbol(symbol, mapper);
        }
        return result;
      }
      function addInheritedMembers(symbols, baseSymbols) {
        for (var _i = 0; _i < baseSymbols.length; _i++) {
          var s = baseSymbols[_i];
          if (!ts.hasProperty(symbols, s.name)) {
            symbols[s.name] = s;
          }
        }
      }
      function addInheritedSignatures(signatures, baseSignatures) {
        if (baseSignatures) {
          for (var _i = 0; _i < baseSignatures.length; _i++) {
            var signature = baseSignatures[_i];
            signatures.push(signature);
          }
        }
      }
      function resolveDeclaredMembers(type) {
        if (!type.declaredProperties) {
          var symbol = type.symbol;
          type.declaredProperties = getNamedMembers(symbol.members);
          type.declaredCallSignatures = getSignaturesOfSymbol(symbol.members["__call"]);
          type.declaredConstructSignatures = getSignaturesOfSymbol(symbol.members["__new"]);
          type.declaredStringIndexType = getIndexTypeOfSymbol(symbol, 0);
          type.declaredNumberIndexType = getIndexTypeOfSymbol(symbol, 1);
        }
        return type;
      }
      function resolveClassOrInterfaceMembers(type) {
        var target = resolveDeclaredMembers(type);
        var members = target.symbol.members;
        var callSignatures = target.declaredCallSignatures;
        var constructSignatures = target.declaredConstructSignatures;
        var stringIndexType = target.declaredStringIndexType;
        var numberIndexType = target.declaredNumberIndexType;
        var baseTypes = getBaseTypes(target);
        if (baseTypes.length) {
          members = createSymbolTable(target.declaredProperties);
          for (var _i = 0; _i < baseTypes.length; _i++) {
            var baseType = baseTypes[_i];
            addInheritedMembers(members, getPropertiesOfObjectType(baseType));
            callSignatures = ts.concatenate(callSignatures, getSignaturesOfType(baseType, 0));
            constructSignatures = ts.concatenate(constructSignatures, getSignaturesOfType(baseType, 1));
            stringIndexType = stringIndexType || getIndexTypeOfType(baseType, 0);
            numberIndexType = numberIndexType || getIndexTypeOfType(baseType, 1);
          }
        }
        setObjectTypeMembers(type, members, callSignatures, constructSignatures, stringIndexType, numberIndexType);
      }
      function resolveTypeReferenceMembers(type) {
        var target = resolveDeclaredMembers(type.target);
        var mapper = createTypeMapper(target.typeParameters, type.typeArguments);
        var members = createInstantiatedSymbolTable(target.declaredProperties, mapper);
        var callSignatures = instantiateList(target.declaredCallSignatures, mapper, instantiateSignature);
        var constructSignatures = instantiateList(target.declaredConstructSignatures, mapper, instantiateSignature);
        var stringIndexType = target.declaredStringIndexType ? instantiateType(target.declaredStringIndexType, mapper) : undefined;
        var numberIndexType = target.declaredNumberIndexType ? instantiateType(target.declaredNumberIndexType, mapper) : undefined;
        ts.forEach(getBaseTypes(target), function(baseType) {
          var instantiatedBaseType = instantiateType(baseType, mapper);
          addInheritedMembers(members, getPropertiesOfObjectType(instantiatedBaseType));
          callSignatures = ts.concatenate(callSignatures, getSignaturesOfType(instantiatedBaseType, 0));
          constructSignatures = ts.concatenate(constructSignatures, getSignaturesOfType(instantiatedBaseType, 1));
          stringIndexType = stringIndexType || getIndexTypeOfType(instantiatedBaseType, 0);
          numberIndexType = numberIndexType || getIndexTypeOfType(instantiatedBaseType, 1);
        });
        setObjectTypeMembers(type, members, callSignatures, constructSignatures, stringIndexType, numberIndexType);
      }
      function createSignature(declaration, typeParameters, parameters, resolvedReturnType, typePredicate, minArgumentCount, hasRestParameter, hasStringLiterals) {
        var sig = new Signature(checker);
        sig.declaration = declaration;
        sig.typeParameters = typeParameters;
        sig.parameters = parameters;
        sig.resolvedReturnType = resolvedReturnType;
        sig.typePredicate = typePredicate;
        sig.minArgumentCount = minArgumentCount;
        sig.hasRestParameter = hasRestParameter;
        sig.hasStringLiterals = hasStringLiterals;
        return sig;
      }
      function cloneSignature(sig) {
        return createSignature(sig.declaration, sig.typeParameters, sig.parameters, sig.resolvedReturnType, sig.typePredicate, sig.minArgumentCount, sig.hasRestParameter, sig.hasStringLiterals);
      }
      function getDefaultConstructSignatures(classType) {
        if (!getBaseTypes(classType).length) {
          return [createSignature(undefined, classType.localTypeParameters, emptyArray, classType, undefined, 0, false, false)];
        }
        var baseConstructorType = getBaseConstructorTypeOfClass(classType);
        var baseSignatures = getSignaturesOfType(baseConstructorType, 1);
        var baseTypeNode = getBaseTypeNodeOfClass(classType);
        var typeArguments = ts.map(baseTypeNode.typeArguments, getTypeFromTypeNode);
        var typeArgCount = typeArguments ? typeArguments.length : 0;
        var result = [];
        for (var _i = 0; _i < baseSignatures.length; _i++) {
          var baseSig = baseSignatures[_i];
          var typeParamCount = baseSig.typeParameters ? baseSig.typeParameters.length : 0;
          if (typeParamCount === typeArgCount) {
            var sig = typeParamCount ? getSignatureInstantiation(baseSig, typeArguments) : cloneSignature(baseSig);
            sig.typeParameters = classType.localTypeParameters;
            sig.resolvedReturnType = classType;
            result.push(sig);
          }
        }
        return result;
      }
      function createTupleTypeMemberSymbols(memberTypes) {
        var members = {};
        for (var i = 0; i < memberTypes.length; i++) {
          var symbol = createSymbol(4 | 67108864, "" + i);
          symbol.type = memberTypes[i];
          members[i] = symbol;
        }
        return members;
      }
      function resolveTupleTypeMembers(type) {
        var arrayType = resolveStructuredTypeMembers(createArrayType(getUnionType(type.elementTypes, true)));
        var members = createTupleTypeMemberSymbols(type.elementTypes);
        addInheritedMembers(members, arrayType.properties);
        setObjectTypeMembers(type, members, arrayType.callSignatures, arrayType.constructSignatures, arrayType.stringIndexType, arrayType.numberIndexType);
      }
      function findMatchingSignature(signatureList, signature, partialMatch, ignoreReturnTypes) {
        for (var _i = 0; _i < signatureList.length; _i++) {
          var s = signatureList[_i];
          if (compareSignatures(s, signature, partialMatch, ignoreReturnTypes, compareTypes)) {
            return s;
          }
        }
      }
      function findMatchingSignatures(signatureLists, signature, listIndex) {
        if (signature.typeParameters) {
          if (listIndex > 0) {
            return undefined;
          }
          for (var i = 1; i < signatureLists.length; i++) {
            if (!findMatchingSignature(signatureLists[i], signature, false, false)) {
              return undefined;
            }
          }
          return [signature];
        }
        var result = undefined;
        for (var i = 0; i < signatureLists.length; i++) {
          var match = i === listIndex ? signature : findMatchingSignature(signatureLists[i], signature, true, true);
          if (!match) {
            return undefined;
          }
          if (!ts.contains(result, match)) {
            (result || (result = [])).push(match);
          }
        }
        return result;
      }
      function getUnionSignatures(types, kind) {
        var signatureLists = ts.map(types, function(t) {
          return getSignaturesOfType(t, kind);
        });
        var result = undefined;
        for (var i = 0; i < signatureLists.length; i++) {
          for (var _i = 0,
              _a = signatureLists[i]; _i < _a.length; _i++) {
            var signature = _a[_i];
            if (!result || !findMatchingSignature(result, signature, false, true)) {
              var unionSignatures = findMatchingSignatures(signatureLists, signature, i);
              if (unionSignatures) {
                var s = signature;
                if (unionSignatures.length > 1) {
                  s = cloneSignature(signature);
                  s.resolvedReturnType = undefined;
                  s.unionSignatures = unionSignatures;
                }
                (result || (result = [])).push(s);
              }
            }
          }
        }
        return result || emptyArray;
      }
      function getUnionIndexType(types, kind) {
        var indexTypes = [];
        for (var _i = 0; _i < types.length; _i++) {
          var type = types[_i];
          var indexType = getIndexTypeOfType(type, kind);
          if (!indexType) {
            return undefined;
          }
          indexTypes.push(indexType);
        }
        return getUnionType(indexTypes);
      }
      function resolveUnionTypeMembers(type) {
        var callSignatures = getUnionSignatures(type.types, 0);
        var constructSignatures = getUnionSignatures(type.types, 1);
        var stringIndexType = getUnionIndexType(type.types, 0);
        var numberIndexType = getUnionIndexType(type.types, 1);
        setObjectTypeMembers(type, emptySymbols, callSignatures, constructSignatures, stringIndexType, numberIndexType);
      }
      function intersectTypes(type1, type2) {
        return !type1 ? type2 : !type2 ? type1 : getIntersectionType([type1, type2]);
      }
      function resolveIntersectionTypeMembers(type) {
        var callSignatures = emptyArray;
        var constructSignatures = emptyArray;
        var stringIndexType = undefined;
        var numberIndexType = undefined;
        for (var _i = 0,
            _a = type.types; _i < _a.length; _i++) {
          var t = _a[_i];
          callSignatures = ts.concatenate(callSignatures, getSignaturesOfType(t, 0));
          constructSignatures = ts.concatenate(constructSignatures, getSignaturesOfType(t, 1));
          stringIndexType = intersectTypes(stringIndexType, getIndexTypeOfType(t, 0));
          numberIndexType = intersectTypes(numberIndexType, getIndexTypeOfType(t, 1));
        }
        setObjectTypeMembers(type, emptySymbols, callSignatures, constructSignatures, stringIndexType, numberIndexType);
      }
      function resolveAnonymousTypeMembers(type) {
        var symbol = type.symbol;
        var members;
        var callSignatures;
        var constructSignatures;
        var stringIndexType;
        var numberIndexType;
        if (symbol.flags & 2048) {
          members = symbol.members;
          callSignatures = getSignaturesOfSymbol(members["__call"]);
          constructSignatures = getSignaturesOfSymbol(members["__new"]);
          stringIndexType = getIndexTypeOfSymbol(symbol, 0);
          numberIndexType = getIndexTypeOfSymbol(symbol, 1);
        } else {
          members = emptySymbols;
          callSignatures = emptyArray;
          constructSignatures = emptyArray;
          if (symbol.flags & 1952) {
            members = getExportsOfSymbol(symbol);
          }
          if (symbol.flags & (16 | 8192)) {
            callSignatures = getSignaturesOfSymbol(symbol);
          }
          if (symbol.flags & 32) {
            var classType = getDeclaredTypeOfClassOrInterface(symbol);
            constructSignatures = getSignaturesOfSymbol(symbol.members["__constructor"]);
            if (!constructSignatures.length) {
              constructSignatures = getDefaultConstructSignatures(classType);
            }
            var baseConstructorType = getBaseConstructorTypeOfClass(classType);
            if (baseConstructorType.flags & 80896) {
              members = createSymbolTable(getNamedMembers(members));
              addInheritedMembers(members, getPropertiesOfObjectType(baseConstructorType));
            }
          }
          stringIndexType = undefined;
          numberIndexType = (symbol.flags & 384) ? stringType : undefined;
        }
        setObjectTypeMembers(type, members, callSignatures, constructSignatures, stringIndexType, numberIndexType);
      }
      function resolveStructuredTypeMembers(type) {
        if (!type.members) {
          if (type.flags & (1024 | 2048)) {
            resolveClassOrInterfaceMembers(type);
          } else if (type.flags & 65536) {
            resolveAnonymousTypeMembers(type);
          } else if (type.flags & 8192) {
            resolveTupleTypeMembers(type);
          } else if (type.flags & 16384) {
            resolveUnionTypeMembers(type);
          } else if (type.flags & 32768) {
            resolveIntersectionTypeMembers(type);
          } else {
            resolveTypeReferenceMembers(type);
          }
        }
        return type;
      }
      function getPropertiesOfObjectType(type) {
        if (type.flags & 80896) {
          return resolveStructuredTypeMembers(type).properties;
        }
        return emptyArray;
      }
      function getPropertyOfObjectType(type, name) {
        if (type.flags & 80896) {
          var resolved = resolveStructuredTypeMembers(type);
          if (ts.hasProperty(resolved.members, name)) {
            var symbol = resolved.members[name];
            if (symbolIsValue(symbol)) {
              return symbol;
            }
          }
        }
      }
      function getPropertiesOfUnionOrIntersectionType(type) {
        for (var _i = 0,
            _a = type.types; _i < _a.length; _i++) {
          var current = _a[_i];
          for (var _b = 0,
              _c = getPropertiesOfType(current); _b < _c.length; _b++) {
            var prop = _c[_b];
            getPropertyOfUnionOrIntersectionType(type, prop.name);
          }
          if (type.flags & 16384) {
            break;
          }
        }
        return type.resolvedProperties ? symbolsToArray(type.resolvedProperties) : emptyArray;
      }
      function getPropertiesOfType(type) {
        type = getApparentType(type);
        return type.flags & 49152 ? getPropertiesOfUnionOrIntersectionType(type) : getPropertiesOfObjectType(type);
      }
      function getApparentType(type) {
        if (type.flags & 512) {
          do {
            type = getConstraintOfTypeParameter(type);
          } while (type && type.flags & 512);
          if (!type) {
            type = emptyObjectType;
          }
        }
        if (type.flags & 258) {
          type = globalStringType;
        } else if (type.flags & 132) {
          type = globalNumberType;
        } else if (type.flags & 8) {
          type = globalBooleanType;
        } else if (type.flags & 16777216) {
          type = globalESSymbolType;
        }
        return type;
      }
      function createUnionOrIntersectionProperty(containingType, name) {
        var types = containingType.types;
        var props;
        for (var _i = 0; _i < types.length; _i++) {
          var current = types[_i];
          var type = getApparentType(current);
          if (type !== unknownType) {
            var prop = getPropertyOfType(type, name);
            if (prop && !(getDeclarationFlagsFromSymbol(prop) & (32 | 64))) {
              if (!props) {
                props = [prop];
              } else if (!ts.contains(props, prop)) {
                props.push(prop);
              }
            } else if (containingType.flags & 16384) {
              return undefined;
            }
          }
        }
        if (!props) {
          return undefined;
        }
        if (props.length === 1) {
          return props[0];
        }
        var propTypes = [];
        var declarations = [];
        for (var _a = 0; _a < props.length; _a++) {
          var prop = props[_a];
          if (prop.declarations) {
            ts.addRange(declarations, prop.declarations);
          }
          propTypes.push(getTypeOfSymbol(prop));
        }
        var result = createSymbol(4 | 67108864 | 268435456, name);
        result.containingType = containingType;
        result.declarations = declarations;
        result.type = containingType.flags & 16384 ? getUnionType(propTypes) : getIntersectionType(propTypes);
        return result;
      }
      function getPropertyOfUnionOrIntersectionType(type, name) {
        var properties = type.resolvedProperties || (type.resolvedProperties = {});
        if (ts.hasProperty(properties, name)) {
          return properties[name];
        }
        var property = createUnionOrIntersectionProperty(type, name);
        if (property) {
          properties[name] = property;
        }
        return property;
      }
      function getPropertyOfType(type, name) {
        type = getApparentType(type);
        if (type.flags & 80896) {
          var resolved = resolveStructuredTypeMembers(type);
          if (ts.hasProperty(resolved.members, name)) {
            var symbol = resolved.members[name];
            if (symbolIsValue(symbol)) {
              return symbol;
            }
          }
          if (resolved === anyFunctionType || resolved.callSignatures.length || resolved.constructSignatures.length) {
            var symbol = getPropertyOfObjectType(globalFunctionType, name);
            if (symbol) {
              return symbol;
            }
          }
          return getPropertyOfObjectType(globalObjectType, name);
        }
        if (type.flags & 49152) {
          return getPropertyOfUnionOrIntersectionType(type, name);
        }
        return undefined;
      }
      function getSignaturesOfStructuredType(type, kind) {
        if (type.flags & 130048) {
          var resolved = resolveStructuredTypeMembers(type);
          return kind === 0 ? resolved.callSignatures : resolved.constructSignatures;
        }
        return emptyArray;
      }
      function getSignaturesOfType(type, kind) {
        return getSignaturesOfStructuredType(getApparentType(type), kind);
      }
      function typeHasConstructSignatures(type) {
        var apparentType = getApparentType(type);
        if (apparentType.flags & (80896 | 16384)) {
          var resolved = resolveStructuredTypeMembers(type);
          return resolved.constructSignatures.length > 0;
        }
        return false;
      }
      function typeHasCallOrConstructSignatures(type) {
        var apparentType = getApparentType(type);
        if (apparentType.flags & 130048) {
          var resolved = resolveStructuredTypeMembers(type);
          return resolved.callSignatures.length > 0 || resolved.constructSignatures.length > 0;
        }
        return false;
      }
      function getIndexTypeOfStructuredType(type, kind) {
        if (type.flags & 130048) {
          var resolved = resolveStructuredTypeMembers(type);
          return kind === 0 ? resolved.stringIndexType : resolved.numberIndexType;
        }
      }
      function getIndexTypeOfType(type, kind) {
        return getIndexTypeOfStructuredType(getApparentType(type), kind);
      }
      function getTypeParametersFromDeclaration(typeParameterDeclarations) {
        var result = [];
        ts.forEach(typeParameterDeclarations, function(node) {
          var tp = getDeclaredTypeOfTypeParameter(node.symbol);
          if (!ts.contains(result, tp)) {
            result.push(tp);
          }
        });
        return result;
      }
      function symbolsToArray(symbols) {
        var result = [];
        for (var id in symbols) {
          if (!isReservedMemberName(id)) {
            result.push(symbols[id]);
          }
        }
        return result;
      }
      function isOptionalParameter(node) {
        if (ts.hasQuestionToken(node)) {
          return true;
        }
        if (node.initializer) {
          var signatureDeclaration = node.parent;
          var signature = getSignatureFromDeclaration(signatureDeclaration);
          var parameterIndex = signatureDeclaration.parameters.indexOf(node);
          ts.Debug.assert(parameterIndex >= 0);
          return parameterIndex >= signature.minArgumentCount;
        }
        return false;
      }
      function getSignatureFromDeclaration(declaration) {
        var links = getNodeLinks(declaration);
        if (!links.resolvedSignature) {
          var classType = declaration.kind === 142 ? getDeclaredTypeOfClassOrInterface(declaration.parent.symbol) : undefined;
          var typeParameters = classType ? classType.localTypeParameters : declaration.typeParameters ? getTypeParametersFromDeclaration(declaration.typeParameters) : undefined;
          var parameters = [];
          var hasStringLiterals = false;
          var minArgumentCount = -1;
          for (var i = 0,
              n = declaration.parameters.length; i < n; i++) {
            var param = declaration.parameters[i];
            parameters.push(param.symbol);
            if (param.type && param.type.kind === 9) {
              hasStringLiterals = true;
            }
            if (param.initializer || param.questionToken || param.dotDotDotToken) {
              if (minArgumentCount < 0) {
                minArgumentCount = i;
              }
            } else {
              minArgumentCount = -1;
            }
          }
          if (minArgumentCount < 0) {
            minArgumentCount = declaration.parameters.length;
          }
          var returnType;
          var typePredicate;
          if (classType) {
            returnType = classType;
          } else if (declaration.type) {
            returnType = getTypeFromTypeNode(declaration.type);
            if (declaration.type.kind === 148) {
              var typePredicateNode = declaration.type;
              typePredicate = {
                parameterName: typePredicateNode.parameterName ? typePredicateNode.parameterName.text : undefined,
                parameterIndex: typePredicateNode.parameterName ? getTypePredicateParameterIndex(declaration.parameters, typePredicateNode.parameterName) : undefined,
                type: getTypeFromTypeNode(typePredicateNode.type)
              };
            }
          } else {
            if (declaration.kind === 143 && !ts.hasDynamicName(declaration)) {
              var setter = ts.getDeclarationOfKind(declaration.symbol, 144);
              returnType = getAnnotatedAccessorType(setter);
            }
            if (!returnType && ts.nodeIsMissing(declaration.body)) {
              returnType = anyType;
            }
          }
          links.resolvedSignature = createSignature(declaration, typeParameters, parameters, returnType, typePredicate, minArgumentCount, ts.hasRestParameter(declaration), hasStringLiterals);
        }
        return links.resolvedSignature;
      }
      function getSignaturesOfSymbol(symbol) {
        if (!symbol)
          return emptyArray;
        var result = [];
        for (var i = 0,
            len = symbol.declarations.length; i < len; i++) {
          var node = symbol.declarations[i];
          switch (node.kind) {
            case 150:
            case 151:
            case 211:
            case 141:
            case 140:
            case 142:
            case 145:
            case 146:
            case 147:
            case 143:
            case 144:
            case 171:
            case 172:
              if (i > 0 && node.body) {
                var previous = symbol.declarations[i - 1];
                if (node.parent === previous.parent && node.kind === previous.kind && node.pos === previous.end) {
                  break;
                }
              }
              result.push(getSignatureFromDeclaration(node));
          }
        }
        return result;
      }
      function getReturnTypeOfSignature(signature) {
        if (!signature.resolvedReturnType) {
          if (!pushTypeResolution(signature, 3)) {
            return unknownType;
          }
          var type;
          if (signature.target) {
            type = instantiateType(getReturnTypeOfSignature(signature.target), signature.mapper);
          } else if (signature.unionSignatures) {
            type = getUnionType(ts.map(signature.unionSignatures, getReturnTypeOfSignature));
          } else {
            type = getReturnTypeFromBody(signature.declaration);
          }
          if (!popTypeResolution()) {
            type = anyType;
            if (compilerOptions.noImplicitAny) {
              var declaration = signature.declaration;
              if (declaration.name) {
                error(declaration.name, ts.Diagnostics._0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions, ts.declarationNameToString(declaration.name));
              } else {
                error(declaration, ts.Diagnostics.Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions);
              }
            }
          }
          signature.resolvedReturnType = type;
        }
        return signature.resolvedReturnType;
      }
      function getRestTypeOfSignature(signature) {
        if (signature.hasRestParameter) {
          var type = getTypeOfSymbol(ts.lastOrUndefined(signature.parameters));
          if (type.flags & 4096 && type.target === globalArrayType) {
            return type.typeArguments[0];
          }
        }
        return anyType;
      }
      function getSignatureInstantiation(signature, typeArguments) {
        return instantiateSignature(signature, createTypeMapper(signature.typeParameters, typeArguments), true);
      }
      function getErasedSignature(signature) {
        if (!signature.typeParameters)
          return signature;
        if (!signature.erasedSignatureCache) {
          if (signature.target) {
            signature.erasedSignatureCache = instantiateSignature(getErasedSignature(signature.target), signature.mapper);
          } else {
            signature.erasedSignatureCache = instantiateSignature(signature, createTypeEraser(signature.typeParameters), true);
          }
        }
        return signature.erasedSignatureCache;
      }
      function getOrCreateTypeFromSignature(signature) {
        if (!signature.isolatedSignatureType) {
          var isConstructor = signature.declaration.kind === 142 || signature.declaration.kind === 146;
          var type = createObjectType(65536 | 262144);
          type.members = emptySymbols;
          type.properties = emptyArray;
          type.callSignatures = !isConstructor ? [signature] : emptyArray;
          type.constructSignatures = isConstructor ? [signature] : emptyArray;
          signature.isolatedSignatureType = type;
        }
        return signature.isolatedSignatureType;
      }
      function getIndexSymbol(symbol) {
        return symbol.members["__index"];
      }
      function getIndexDeclarationOfSymbol(symbol, kind) {
        var syntaxKind = kind === 1 ? 126 : 128;
        var indexSymbol = getIndexSymbol(symbol);
        if (indexSymbol) {
          for (var _i = 0,
              _a = indexSymbol.declarations; _i < _a.length; _i++) {
            var decl = _a[_i];
            var node = decl;
            if (node.parameters.length === 1) {
              var parameter = node.parameters[0];
              if (parameter && parameter.type && parameter.type.kind === syntaxKind) {
                return node;
              }
            }
          }
        }
        return undefined;
      }
      function getIndexTypeOfSymbol(symbol, kind) {
        var declaration = getIndexDeclarationOfSymbol(symbol, kind);
        return declaration ? declaration.type ? getTypeFromTypeNode(declaration.type) : anyType : undefined;
      }
      function getConstraintOfTypeParameter(type) {
        if (!type.constraint) {
          if (type.target) {
            var targetConstraint = getConstraintOfTypeParameter(type.target);
            type.constraint = targetConstraint ? instantiateType(targetConstraint, type.mapper) : noConstraintType;
          } else {
            type.constraint = getTypeFromTypeNode(ts.getDeclarationOfKind(type.symbol, 135).constraint);
          }
        }
        return type.constraint === noConstraintType ? undefined : type.constraint;
      }
      function getParentSymbolOfTypeParameter(typeParameter) {
        return getSymbolOfNode(ts.getDeclarationOfKind(typeParameter.symbol, 135).parent);
      }
      function getTypeListId(types) {
        switch (types.length) {
          case 1:
            return "" + types[0].id;
          case 2:
            return types[0].id + "," + types[1].id;
          default:
            var result = "";
            for (var i = 0; i < types.length; i++) {
              if (i > 0) {
                result += ",";
              }
              result += types[i].id;
            }
            return result;
        }
      }
      function getPropagatingFlagsOfTypes(types) {
        var result = 0;
        for (var _i = 0; _i < types.length; _i++) {
          var type = types[_i];
          result |= type.flags;
        }
        return result & 14680064;
      }
      function createTypeReference(target, typeArguments) {
        var id = getTypeListId(typeArguments);
        var type = target.instantiations[id];
        if (!type) {
          var flags = 4096 | getPropagatingFlagsOfTypes(typeArguments);
          type = target.instantiations[id] = createObjectType(flags, target.symbol);
          type.target = target;
          type.typeArguments = typeArguments;
        }
        return type;
      }
      function isTypeParameterReferenceIllegalInConstraint(typeReferenceNode, typeParameterSymbol) {
        var links = getNodeLinks(typeReferenceNode);
        if (links.isIllegalTypeReferenceInConstraint !== undefined) {
          return links.isIllegalTypeReferenceInConstraint;
        }
        var currentNode = typeReferenceNode;
        while (!ts.forEach(typeParameterSymbol.declarations, function(d) {
          return d.parent === currentNode.parent;
        })) {
          currentNode = currentNode.parent;
        }
        links.isIllegalTypeReferenceInConstraint = currentNode.kind === 135;
        return links.isIllegalTypeReferenceInConstraint;
      }
      function checkTypeParameterHasIllegalReferencesInConstraint(typeParameter) {
        var typeParameterSymbol;
        function check(n) {
          if (n.kind === 149 && n.typeName.kind === 67) {
            var links = getNodeLinks(n);
            if (links.isIllegalTypeReferenceInConstraint === undefined) {
              var symbol = resolveName(typeParameter, n.typeName.text, 793056, undefined, undefined);
              if (symbol && (symbol.flags & 262144)) {
                links.isIllegalTypeReferenceInConstraint = ts.forEach(symbol.declarations, function(d) {
                  return d.parent === typeParameter.parent;
                });
              }
            }
            if (links.isIllegalTypeReferenceInConstraint) {
              error(typeParameter, ts.Diagnostics.Constraint_of_a_type_parameter_cannot_reference_any_type_parameter_from_the_same_type_parameter_list);
            }
          }
          ts.forEachChild(n, check);
        }
        if (typeParameter.constraint) {
          typeParameterSymbol = getSymbolOfNode(typeParameter);
          check(typeParameter.constraint);
        }
      }
      function getTypeFromClassOrInterfaceReference(node, symbol) {
        var type = getDeclaredTypeOfSymbol(symbol);
        var typeParameters = type.localTypeParameters;
        if (typeParameters) {
          if (!node.typeArguments || node.typeArguments.length !== typeParameters.length) {
            error(node, ts.Diagnostics.Generic_type_0_requires_1_type_argument_s, typeToString(type, undefined, 1), typeParameters.length);
            return unknownType;
          }
          return createTypeReference(type, ts.concatenate(type.outerTypeParameters, ts.map(node.typeArguments, getTypeFromTypeNode)));
        }
        if (node.typeArguments) {
          error(node, ts.Diagnostics.Type_0_is_not_generic, typeToString(type));
          return unknownType;
        }
        return type;
      }
      function getTypeFromTypeAliasReference(node, symbol) {
        var type = getDeclaredTypeOfSymbol(symbol);
        var links = getSymbolLinks(symbol);
        var typeParameters = links.typeParameters;
        if (typeParameters) {
          if (!node.typeArguments || node.typeArguments.length !== typeParameters.length) {
            error(node, ts.Diagnostics.Generic_type_0_requires_1_type_argument_s, symbolToString(symbol), typeParameters.length);
            return unknownType;
          }
          var typeArguments = ts.map(node.typeArguments, getTypeFromTypeNode);
          var id = getTypeListId(typeArguments);
          return links.instantiations[id] || (links.instantiations[id] = instantiateType(type, createTypeMapper(typeParameters, typeArguments)));
        }
        if (node.typeArguments) {
          error(node, ts.Diagnostics.Type_0_is_not_generic, symbolToString(symbol));
          return unknownType;
        }
        return type;
      }
      function getTypeFromNonGenericTypeReference(node, symbol) {
        if (symbol.flags & 262144 && isTypeParameterReferenceIllegalInConstraint(node, symbol)) {
          return unknownType;
        }
        if (node.typeArguments) {
          error(node, ts.Diagnostics.Type_0_is_not_generic, symbolToString(symbol));
          return unknownType;
        }
        return getDeclaredTypeOfSymbol(symbol);
      }
      function getTypeFromTypeReference(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedType) {
          var typeNameOrExpression = node.kind === 149 ? node.typeName : ts.isSupportedExpressionWithTypeArguments(node) ? node.expression : undefined;
          var symbol = typeNameOrExpression && resolveEntityName(typeNameOrExpression, 793056) || unknownSymbol;
          var type = symbol === unknownSymbol ? unknownType : symbol.flags & (32 | 64) ? getTypeFromClassOrInterfaceReference(node, symbol) : symbol.flags & 524288 ? getTypeFromTypeAliasReference(node, symbol) : getTypeFromNonGenericTypeReference(node, symbol);
          links.resolvedSymbol = symbol;
          links.resolvedType = type;
        }
        return links.resolvedType;
      }
      function getTypeFromTypeQueryNode(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedType) {
          links.resolvedType = getWidenedType(checkExpression(node.exprName));
        }
        return links.resolvedType;
      }
      function getTypeOfGlobalSymbol(symbol, arity) {
        function getTypeDeclaration(symbol) {
          var declarations = symbol.declarations;
          for (var _i = 0; _i < declarations.length; _i++) {
            var declaration = declarations[_i];
            switch (declaration.kind) {
              case 212:
              case 213:
              case 215:
                return declaration;
            }
          }
        }
        if (!symbol) {
          return arity ? emptyGenericType : emptyObjectType;
        }
        var type = getDeclaredTypeOfSymbol(symbol);
        if (!(type.flags & 80896)) {
          error(getTypeDeclaration(symbol), ts.Diagnostics.Global_type_0_must_be_a_class_or_interface_type, symbol.name);
          return arity ? emptyGenericType : emptyObjectType;
        }
        if ((type.typeParameters ? type.typeParameters.length : 0) !== arity) {
          error(getTypeDeclaration(symbol), ts.Diagnostics.Global_type_0_must_have_1_type_parameter_s, symbol.name, arity);
          return arity ? emptyGenericType : emptyObjectType;
        }
        return type;
      }
      function getGlobalValueSymbol(name) {
        return getGlobalSymbol(name, 107455, ts.Diagnostics.Cannot_find_global_value_0);
      }
      function getGlobalTypeSymbol(name) {
        return getGlobalSymbol(name, 793056, ts.Diagnostics.Cannot_find_global_type_0);
      }
      function getGlobalSymbol(name, meaning, diagnostic) {
        return resolveName(undefined, name, meaning, diagnostic, name);
      }
      function getGlobalType(name, arity) {
        if (arity === void 0) {
          arity = 0;
        }
        return getTypeOfGlobalSymbol(getGlobalTypeSymbol(name), arity);
      }
      function tryGetGlobalType(name, arity) {
        if (arity === void 0) {
          arity = 0;
        }
        return getTypeOfGlobalSymbol(getGlobalSymbol(name, 793056, undefined), arity);
      }
      function getExportedTypeFromNamespace(namespace, name) {
        var namespaceSymbol = getGlobalSymbol(namespace, 1536, undefined);
        var typeSymbol = namespaceSymbol && getSymbol(namespaceSymbol.exports, name, 793056);
        return typeSymbol && getDeclaredTypeOfSymbol(typeSymbol);
      }
      function getGlobalESSymbolConstructorSymbol() {
        return globalESSymbolConstructorSymbol || (globalESSymbolConstructorSymbol = getGlobalValueSymbol("Symbol"));
      }
      function createTypedPropertyDescriptorType(propertyType) {
        var globalTypedPropertyDescriptorType = getGlobalTypedPropertyDescriptorType();
        return globalTypedPropertyDescriptorType !== emptyGenericType ? createTypeReference(globalTypedPropertyDescriptorType, [propertyType]) : emptyObjectType;
      }
      function createTypeFromGenericGlobalType(genericGlobalType, elementType) {
        return genericGlobalType !== emptyGenericType ? createTypeReference(genericGlobalType, [elementType]) : emptyObjectType;
      }
      function createIterableType(elementType) {
        return createTypeFromGenericGlobalType(globalIterableType, elementType);
      }
      function createIterableIteratorType(elementType) {
        return createTypeFromGenericGlobalType(globalIterableIteratorType, elementType);
      }
      function createArrayType(elementType) {
        return createTypeFromGenericGlobalType(globalArrayType, elementType);
      }
      function getTypeFromArrayTypeNode(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedType) {
          links.resolvedType = createArrayType(getTypeFromTypeNode(node.elementType));
        }
        return links.resolvedType;
      }
      function createTupleType(elementTypes) {
        var id = getTypeListId(elementTypes);
        var type = tupleTypes[id];
        if (!type) {
          type = tupleTypes[id] = createObjectType(8192 | getPropagatingFlagsOfTypes(elementTypes));
          type.elementTypes = elementTypes;
        }
        return type;
      }
      function getTypeFromTupleTypeNode(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedType) {
          links.resolvedType = createTupleType(ts.map(node.elementTypes, getTypeFromTypeNode));
        }
        return links.resolvedType;
      }
      function addTypeToSet(typeSet, type, typeSetKind) {
        if (type.flags & typeSetKind) {
          addTypesToSet(typeSet, type.types, typeSetKind);
        } else if (!ts.contains(typeSet, type)) {
          typeSet.push(type);
        }
      }
      function addTypesToSet(typeSet, types, typeSetKind) {
        for (var _i = 0; _i < types.length; _i++) {
          var type = types[_i];
          addTypeToSet(typeSet, type, typeSetKind);
        }
      }
      function isSubtypeOfAny(candidate, types) {
        for (var i = 0,
            len = types.length; i < len; i++) {
          if (candidate !== types[i] && isTypeSubtypeOf(candidate, types[i])) {
            return true;
          }
        }
        return false;
      }
      function removeSubtypes(types) {
        var i = types.length;
        while (i > 0) {
          i--;
          if (isSubtypeOfAny(types[i], types)) {
            types.splice(i, 1);
          }
        }
      }
      function containsTypeAny(types) {
        for (var _i = 0; _i < types.length; _i++) {
          var type = types[_i];
          if (isTypeAny(type)) {
            return true;
          }
        }
        return false;
      }
      function removeAllButLast(types, typeToRemove) {
        var i = types.length;
        while (i > 0 && types.length > 1) {
          i--;
          if (types[i] === typeToRemove) {
            types.splice(i, 1);
          }
        }
      }
      function getUnionType(types, noSubtypeReduction) {
        if (types.length === 0) {
          return emptyObjectType;
        }
        var typeSet = [];
        addTypesToSet(typeSet, types, 16384);
        if (containsTypeAny(typeSet)) {
          return anyType;
        }
        if (noSubtypeReduction) {
          removeAllButLast(typeSet, undefinedType);
          removeAllButLast(typeSet, nullType);
        } else {
          removeSubtypes(typeSet);
        }
        if (typeSet.length === 1) {
          return typeSet[0];
        }
        var id = getTypeListId(typeSet);
        var type = unionTypes[id];
        if (!type) {
          type = unionTypes[id] = createObjectType(16384 | getPropagatingFlagsOfTypes(typeSet));
          type.types = typeSet;
        }
        return type;
      }
      function getTypeFromUnionTypeNode(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedType) {
          links.resolvedType = getUnionType(ts.map(node.types, getTypeFromTypeNode), true);
        }
        return links.resolvedType;
      }
      function getIntersectionType(types) {
        if (types.length === 0) {
          return emptyObjectType;
        }
        var typeSet = [];
        addTypesToSet(typeSet, types, 32768);
        if (containsTypeAny(typeSet)) {
          return anyType;
        }
        if (typeSet.length === 1) {
          return typeSet[0];
        }
        var id = getTypeListId(typeSet);
        var type = intersectionTypes[id];
        if (!type) {
          type = intersectionTypes[id] = createObjectType(32768 | getPropagatingFlagsOfTypes(typeSet));
          type.types = typeSet;
        }
        return type;
      }
      function getTypeFromIntersectionTypeNode(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedType) {
          links.resolvedType = getIntersectionType(ts.map(node.types, getTypeFromTypeNode));
        }
        return links.resolvedType;
      }
      function getTypeFromTypeLiteralOrFunctionOrConstructorTypeNode(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedType) {
          links.resolvedType = createObjectType(65536, node.symbol);
        }
        return links.resolvedType;
      }
      function getStringLiteralType(node) {
        if (ts.hasProperty(stringLiteralTypes, node.text)) {
          return stringLiteralTypes[node.text];
        }
        var type = stringLiteralTypes[node.text] = createType(256);
        type.text = ts.getTextOfNode(node);
        return type;
      }
      function getTypeFromStringLiteral(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedType) {
          links.resolvedType = getStringLiteralType(node);
        }
        return links.resolvedType;
      }
      function getTypeFromTypeNode(node) {
        switch (node.kind) {
          case 115:
            return anyType;
          case 128:
            return stringType;
          case 126:
            return numberType;
          case 118:
            return booleanType;
          case 129:
            return esSymbolType;
          case 101:
            return voidType;
          case 9:
            return getTypeFromStringLiteral(node);
          case 149:
            return getTypeFromTypeReference(node);
          case 148:
            return booleanType;
          case 186:
            return getTypeFromTypeReference(node);
          case 152:
            return getTypeFromTypeQueryNode(node);
          case 154:
            return getTypeFromArrayTypeNode(node);
          case 155:
            return getTypeFromTupleTypeNode(node);
          case 156:
            return getTypeFromUnionTypeNode(node);
          case 157:
            return getTypeFromIntersectionTypeNode(node);
          case 158:
            return getTypeFromTypeNode(node.type);
          case 150:
          case 151:
          case 153:
            return getTypeFromTypeLiteralOrFunctionOrConstructorTypeNode(node);
          case 67:
          case 133:
            var symbol = getSymbolAtLocation(node);
            return symbol && getDeclaredTypeOfSymbol(symbol);
          default:
            return unknownType;
        }
      }
      function instantiateList(items, mapper, instantiator) {
        if (items && items.length) {
          var result = [];
          for (var _i = 0; _i < items.length; _i++) {
            var v = items[_i];
            result.push(instantiator(v, mapper));
          }
          return result;
        }
        return items;
      }
      function createUnaryTypeMapper(source, target) {
        return function(t) {
          return t === source ? target : t;
        };
      }
      function createBinaryTypeMapper(source1, target1, source2, target2) {
        return function(t) {
          return t === source1 ? target1 : t === source2 ? target2 : t;
        };
      }
      function createTypeMapper(sources, targets) {
        switch (sources.length) {
          case 1:
            return createUnaryTypeMapper(sources[0], targets[0]);
          case 2:
            return createBinaryTypeMapper(sources[0], targets[0], sources[1], targets[1]);
        }
        return function(t) {
          for (var i = 0; i < sources.length; i++) {
            if (t === sources[i]) {
              return targets[i];
            }
          }
          return t;
        };
      }
      function createUnaryTypeEraser(source) {
        return function(t) {
          return t === source ? anyType : t;
        };
      }
      function createBinaryTypeEraser(source1, source2) {
        return function(t) {
          return t === source1 || t === source2 ? anyType : t;
        };
      }
      function createTypeEraser(sources) {
        switch (sources.length) {
          case 1:
            return createUnaryTypeEraser(sources[0]);
          case 2:
            return createBinaryTypeEraser(sources[0], sources[1]);
        }
        return function(t) {
          for (var _i = 0; _i < sources.length; _i++) {
            var source = sources[_i];
            if (t === source) {
              return anyType;
            }
          }
          return t;
        };
      }
      function createInferenceMapper(context) {
        var mapper = function(t) {
          for (var i = 0; i < context.typeParameters.length; i++) {
            if (t === context.typeParameters[i]) {
              context.inferences[i].isFixed = true;
              return getInferredType(context, i);
            }
          }
          return t;
        };
        mapper.context = context;
        return mapper;
      }
      function identityMapper(type) {
        return type;
      }
      function combineTypeMappers(mapper1, mapper2) {
        return function(t) {
          return instantiateType(mapper1(t), mapper2);
        };
      }
      function instantiateTypeParameter(typeParameter, mapper) {
        var result = createType(512);
        result.symbol = typeParameter.symbol;
        if (typeParameter.constraint) {
          result.constraint = instantiateType(typeParameter.constraint, mapper);
        } else {
          result.target = typeParameter;
          result.mapper = mapper;
        }
        return result;
      }
      function instantiateSignature(signature, mapper, eraseTypeParameters) {
        var freshTypeParameters;
        var freshTypePredicate;
        if (signature.typeParameters && !eraseTypeParameters) {
          freshTypeParameters = instantiateList(signature.typeParameters, mapper, instantiateTypeParameter);
          mapper = combineTypeMappers(createTypeMapper(signature.typeParameters, freshTypeParameters), mapper);
        }
        if (signature.typePredicate) {
          freshTypePredicate = {
            parameterName: signature.typePredicate.parameterName,
            parameterIndex: signature.typePredicate.parameterIndex,
            type: instantiateType(signature.typePredicate.type, mapper)
          };
        }
        var result = createSignature(signature.declaration, freshTypeParameters, instantiateList(signature.parameters, mapper, instantiateSymbol), signature.resolvedReturnType ? instantiateType(signature.resolvedReturnType, mapper) : undefined, freshTypePredicate, signature.minArgumentCount, signature.hasRestParameter, signature.hasStringLiterals);
        result.target = signature;
        result.mapper = mapper;
        return result;
      }
      function instantiateSymbol(symbol, mapper) {
        if (symbol.flags & 16777216) {
          var links = getSymbolLinks(symbol);
          symbol = links.target;
          mapper = combineTypeMappers(links.mapper, mapper);
        }
        var result = createSymbol(16777216 | 67108864 | symbol.flags, symbol.name);
        result.declarations = symbol.declarations;
        result.parent = symbol.parent;
        result.target = symbol;
        result.mapper = mapper;
        if (symbol.valueDeclaration) {
          result.valueDeclaration = symbol.valueDeclaration;
        }
        return result;
      }
      function instantiateAnonymousType(type, mapper) {
        if (mapper.instantiations) {
          var cachedType = mapper.instantiations[type.id];
          if (cachedType) {
            return cachedType;
          }
        } else {
          mapper.instantiations = [];
        }
        var result = createObjectType(65536 | 131072, type.symbol);
        result.properties = instantiateList(getPropertiesOfObjectType(type), mapper, instantiateSymbol);
        result.members = createSymbolTable(result.properties);
        result.callSignatures = instantiateList(getSignaturesOfType(type, 0), mapper, instantiateSignature);
        result.constructSignatures = instantiateList(getSignaturesOfType(type, 1), mapper, instantiateSignature);
        var stringIndexType = getIndexTypeOfType(type, 0);
        var numberIndexType = getIndexTypeOfType(type, 1);
        if (stringIndexType)
          result.stringIndexType = instantiateType(stringIndexType, mapper);
        if (numberIndexType)
          result.numberIndexType = instantiateType(numberIndexType, mapper);
        mapper.instantiations[type.id] = result;
        return result;
      }
      function instantiateType(type, mapper) {
        if (mapper !== identityMapper) {
          if (type.flags & 512) {
            return mapper(type);
          }
          if (type.flags & 65536) {
            return type.symbol && type.symbol.flags & (16 | 8192 | 32 | 2048 | 4096) ? instantiateAnonymousType(type, mapper) : type;
          }
          if (type.flags & 4096) {
            return createTypeReference(type.target, instantiateList(type.typeArguments, mapper, instantiateType));
          }
          if (type.flags & 8192) {
            return createTupleType(instantiateList(type.elementTypes, mapper, instantiateType));
          }
          if (type.flags & 16384) {
            return getUnionType(instantiateList(type.types, mapper, instantiateType), true);
          }
          if (type.flags & 32768) {
            return getIntersectionType(instantiateList(type.types, mapper, instantiateType));
          }
        }
        return type;
      }
      function isContextSensitive(node) {
        ts.Debug.assert(node.kind !== 141 || ts.isObjectLiteralMethod(node));
        switch (node.kind) {
          case 171:
          case 172:
            return isContextSensitiveFunctionLikeDeclaration(node);
          case 163:
            return ts.forEach(node.properties, isContextSensitive);
          case 162:
            return ts.forEach(node.elements, isContextSensitive);
          case 180:
            return isContextSensitive(node.whenTrue) || isContextSensitive(node.whenFalse);
          case 179:
            return node.operatorToken.kind === 51 && (isContextSensitive(node.left) || isContextSensitive(node.right));
          case 243:
            return isContextSensitive(node.initializer);
          case 141:
          case 140:
            return isContextSensitiveFunctionLikeDeclaration(node);
          case 170:
            return isContextSensitive(node.expression);
        }
        return false;
      }
      function isContextSensitiveFunctionLikeDeclaration(node) {
        return !node.typeParameters && node.parameters.length && !ts.forEach(node.parameters, function(p) {
          return p.type;
        });
      }
      function getTypeWithoutSignatures(type) {
        if (type.flags & 80896) {
          var resolved = resolveStructuredTypeMembers(type);
          if (resolved.constructSignatures.length) {
            var result = createObjectType(65536, type.symbol);
            result.members = resolved.members;
            result.properties = resolved.properties;
            result.callSignatures = emptyArray;
            result.constructSignatures = emptyArray;
            type = result;
          }
        }
        return type;
      }
      function isTypeIdenticalTo(source, target) {
        return checkTypeRelatedTo(source, target, identityRelation, undefined);
      }
      function compareTypes(source, target) {
        return checkTypeRelatedTo(source, target, identityRelation, undefined) ? -1 : 0;
      }
      function isTypeSubtypeOf(source, target) {
        return checkTypeSubtypeOf(source, target, undefined);
      }
      function isTypeAssignableTo(source, target) {
        return checkTypeAssignableTo(source, target, undefined);
      }
      function checkTypeSubtypeOf(source, target, errorNode, headMessage, containingMessageChain) {
        return checkTypeRelatedTo(source, target, subtypeRelation, errorNode, headMessage, containingMessageChain);
      }
      function checkTypeAssignableTo(source, target, errorNode, headMessage, containingMessageChain) {
        return checkTypeRelatedTo(source, target, assignableRelation, errorNode, headMessage, containingMessageChain);
      }
      function isSignatureAssignableTo(source, target) {
        var sourceType = getOrCreateTypeFromSignature(source);
        var targetType = getOrCreateTypeFromSignature(target);
        return checkTypeRelatedTo(sourceType, targetType, assignableRelation, undefined);
      }
      function checkTypeRelatedTo(source, target, relation, errorNode, headMessage, containingMessageChain) {
        var errorInfo;
        var sourceStack;
        var targetStack;
        var maybeStack;
        var expandingFlags;
        var depth = 0;
        var overflow = false;
        var elaborateErrors = false;
        ts.Debug.assert(relation !== identityRelation || !errorNode, "no error reporting in identity checking");
        var result = isRelatedTo(source, target, errorNode !== undefined, headMessage);
        if (overflow) {
          error(errorNode, ts.Diagnostics.Excessive_stack_depth_comparing_types_0_and_1, typeToString(source), typeToString(target));
        } else if (errorInfo) {
          if (errorInfo.next === undefined) {
            errorInfo = undefined;
            elaborateErrors = true;
            isRelatedTo(source, target, errorNode !== undefined, headMessage);
          }
          if (containingMessageChain) {
            errorInfo = ts.concatenateDiagnosticMessageChains(containingMessageChain, errorInfo);
          }
          diagnostics.add(ts.createDiagnosticForNodeFromMessageChain(errorNode, errorInfo));
        }
        return result !== 0;
        function reportError(message, arg0, arg1, arg2) {
          errorInfo = ts.chainDiagnosticMessages(errorInfo, message, arg0, arg1, arg2);
        }
        function reportRelationError(message, source, target) {
          var sourceType = typeToString(source);
          var targetType = typeToString(target);
          if (sourceType === targetType) {
            sourceType = typeToString(source, undefined, 128);
            targetType = typeToString(target, undefined, 128);
          }
          reportError(message || ts.Diagnostics.Type_0_is_not_assignable_to_type_1, sourceType, targetType);
        }
        function isRelatedTo(source, target, reportErrors, headMessage) {
          var result;
          if (source === target)
            return -1;
          if (relation === identityRelation) {
            return isIdenticalTo(source, target);
          }
          if (isTypeAny(target))
            return -1;
          if (source === undefinedType)
            return -1;
          if (source === nullType && target !== undefinedType)
            return -1;
          if (source.flags & 128 && target === numberType)
            return -1;
          if (source.flags & 256 && target === stringType)
            return -1;
          if (relation === assignableRelation) {
            if (isTypeAny(source))
              return -1;
            if (source === numberType && target.flags & 128)
              return -1;
          }
          if (source.flags & 1048576) {
            if (hasExcessProperties(source, target, reportErrors)) {
              if (reportErrors) {
                reportRelationError(headMessage, source, target);
              }
              return 0;
            }
            source = getRegularTypeOfObjectLiteral(source);
          }
          var saveErrorInfo = errorInfo;
          if (source.flags & 16384) {
            if (result = eachTypeRelatedToType(source, target, reportErrors)) {
              return result;
            }
          } else if (target.flags & 32768) {
            if (result = typeRelatedToEachType(source, target, reportErrors)) {
              return result;
            }
          } else {
            if (source.flags & 32768) {
              if (result = someTypeRelatedToType(source, target, reportErrors && !(target.flags & 16384))) {
                return result;
              }
            }
            if (target.flags & 16384) {
              if (result = typeRelatedToSomeType(source, target, reportErrors)) {
                return result;
              }
            }
          }
          if (source.flags & 512) {
            var constraint = getConstraintOfTypeParameter(source);
            if (!constraint || constraint.flags & 1) {
              constraint = emptyObjectType;
            }
            var reportConstraintErrors = reportErrors && constraint !== emptyObjectType;
            if (result = isRelatedTo(constraint, target, reportConstraintErrors)) {
              errorInfo = saveErrorInfo;
              return result;
            }
          } else {
            if (source.flags & 4096 && target.flags & 4096 && source.target === target.target) {
              if (result = typesRelatedTo(source.typeArguments, target.typeArguments, reportErrors)) {
                return result;
              }
            }
            var apparentType = getApparentType(source);
            if (apparentType.flags & (80896 | 32768) && target.flags & 80896) {
              var reportStructuralErrors = reportErrors && errorInfo === saveErrorInfo;
              if (result = objectTypeRelatedTo(apparentType, target, reportStructuralErrors)) {
                errorInfo = saveErrorInfo;
                return result;
              }
            }
          }
          if (reportErrors) {
            reportRelationError(headMessage, source, target);
          }
          return 0;
        }
        function isIdenticalTo(source, target) {
          var result;
          if (source.flags & 80896 && target.flags & 80896) {
            if (source.flags & 4096 && target.flags & 4096 && source.target === target.target) {
              if (result = typesRelatedTo(source.typeArguments, target.typeArguments, false)) {
                return result;
              }
            }
            return objectTypeRelatedTo(source, target, false);
          }
          if (source.flags & 512 && target.flags & 512) {
            return typeParameterIdenticalTo(source, target);
          }
          if (source.flags & 16384 && target.flags & 16384 || source.flags & 32768 && target.flags & 32768) {
            if (result = eachTypeRelatedToSomeType(source, target)) {
              if (result &= eachTypeRelatedToSomeType(target, source)) {
                return result;
              }
            }
          }
          return 0;
        }
        function isKnownProperty(type, name) {
          if (type.flags & 80896) {
            var resolved = resolveStructuredTypeMembers(type);
            if (relation === assignableRelation && (type === globalObjectType || resolved.properties.length === 0) || resolved.stringIndexType || resolved.numberIndexType || getPropertyOfType(type, name)) {
              return true;
            }
            return false;
          }
          if (type.flags & 49152) {
            for (var _i = 0,
                _a = type.types; _i < _a.length; _i++) {
              var t = _a[_i];
              if (isKnownProperty(t, name)) {
                return true;
              }
            }
            return false;
          }
          return true;
        }
        function hasExcessProperties(source, target, reportErrors) {
          for (var _i = 0,
              _a = getPropertiesOfObjectType(source); _i < _a.length; _i++) {
            var prop = _a[_i];
            if (!isKnownProperty(target, prop.name)) {
              if (reportErrors) {
                errorNode = prop.valueDeclaration;
                reportError(ts.Diagnostics.Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1, symbolToString(prop), typeToString(target));
              }
              return true;
            }
          }
        }
        function eachTypeRelatedToSomeType(source, target) {
          var result = -1;
          var sourceTypes = source.types;
          for (var _i = 0; _i < sourceTypes.length; _i++) {
            var sourceType = sourceTypes[_i];
            var related = typeRelatedToSomeType(sourceType, target, false);
            if (!related) {
              return 0;
            }
            result &= related;
          }
          return result;
        }
        function typeRelatedToSomeType(source, target, reportErrors) {
          var targetTypes = target.types;
          for (var i = 0,
              len = targetTypes.length; i < len; i++) {
            var related = isRelatedTo(source, targetTypes[i], reportErrors && i === len - 1);
            if (related) {
              return related;
            }
          }
          return 0;
        }
        function typeRelatedToEachType(source, target, reportErrors) {
          var result = -1;
          var targetTypes = target.types;
          for (var _i = 0; _i < targetTypes.length; _i++) {
            var targetType = targetTypes[_i];
            var related = isRelatedTo(source, targetType, reportErrors);
            if (!related) {
              return 0;
            }
            result &= related;
          }
          return result;
        }
        function someTypeRelatedToType(source, target, reportErrors) {
          var sourceTypes = source.types;
          for (var i = 0,
              len = sourceTypes.length; i < len; i++) {
            var related = isRelatedTo(sourceTypes[i], target, reportErrors && i === len - 1);
            if (related) {
              return related;
            }
          }
          return 0;
        }
        function eachTypeRelatedToType(source, target, reportErrors) {
          var result = -1;
          var sourceTypes = source.types;
          for (var _i = 0; _i < sourceTypes.length; _i++) {
            var sourceType = sourceTypes[_i];
            var related = isRelatedTo(sourceType, target, reportErrors);
            if (!related) {
              return 0;
            }
            result &= related;
          }
          return result;
        }
        function typesRelatedTo(sources, targets, reportErrors) {
          var result = -1;
          for (var i = 0,
              len = sources.length; i < len; i++) {
            var related = isRelatedTo(sources[i], targets[i], reportErrors);
            if (!related) {
              return 0;
            }
            result &= related;
          }
          return result;
        }
        function typeParameterIdenticalTo(source, target) {
          if (source.symbol.name !== target.symbol.name) {
            return 0;
          }
          if (source.constraint === target.constraint) {
            return -1;
          }
          if (source.constraint === noConstraintType || target.constraint === noConstraintType) {
            return 0;
          }
          return isIdenticalTo(source.constraint, target.constraint);
        }
        function objectTypeRelatedTo(source, target, reportErrors) {
          if (overflow) {
            return 0;
          }
          var id = relation !== identityRelation || source.id < target.id ? source.id + "," + target.id : target.id + "," + source.id;
          var related = relation[id];
          if (related !== undefined) {
            if (!elaborateErrors || (related === 3)) {
              return related === 1 ? -1 : 0;
            }
          }
          if (depth > 0) {
            for (var i = 0; i < depth; i++) {
              if (maybeStack[i][id]) {
                return 1;
              }
            }
            if (depth === 100) {
              overflow = true;
              return 0;
            }
          } else {
            sourceStack = [];
            targetStack = [];
            maybeStack = [];
            expandingFlags = 0;
          }
          sourceStack[depth] = source;
          targetStack[depth] = target;
          maybeStack[depth] = {};
          maybeStack[depth][id] = 1;
          depth++;
          var saveExpandingFlags = expandingFlags;
          if (!(expandingFlags & 1) && isDeeplyNestedGeneric(source, sourceStack, depth))
            expandingFlags |= 1;
          if (!(expandingFlags & 2) && isDeeplyNestedGeneric(target, targetStack, depth))
            expandingFlags |= 2;
          var result;
          if (expandingFlags === 3) {
            result = 1;
          } else {
            result = propertiesRelatedTo(source, target, reportErrors);
            if (result) {
              result &= signaturesRelatedTo(source, target, 0, reportErrors);
              if (result) {
                result &= signaturesRelatedTo(source, target, 1, reportErrors);
                if (result) {
                  result &= stringIndexTypesRelatedTo(source, target, reportErrors);
                  if (result) {
                    result &= numberIndexTypesRelatedTo(source, target, reportErrors);
                  }
                }
              }
            }
          }
          expandingFlags = saveExpandingFlags;
          depth--;
          if (result) {
            var maybeCache = maybeStack[depth];
            var destinationCache = (result === -1 || depth === 0) ? relation : maybeStack[depth - 1];
            ts.copyMap(maybeCache, destinationCache);
          } else {
            relation[id] = reportErrors ? 3 : 2;
          }
          return result;
        }
        function propertiesRelatedTo(source, target, reportErrors) {
          if (relation === identityRelation) {
            return propertiesIdenticalTo(source, target);
          }
          var result = -1;
          var properties = getPropertiesOfObjectType(target);
          var requireOptionalProperties = relation === subtypeRelation && !(source.flags & 524288);
          for (var _i = 0; _i < properties.length; _i++) {
            var targetProp = properties[_i];
            var sourceProp = getPropertyOfType(source, targetProp.name);
            if (sourceProp !== targetProp) {
              if (!sourceProp) {
                if (!(targetProp.flags & 536870912) || requireOptionalProperties) {
                  if (reportErrors) {
                    reportError(ts.Diagnostics.Property_0_is_missing_in_type_1, symbolToString(targetProp), typeToString(source));
                  }
                  return 0;
                }
              } else if (!(targetProp.flags & 134217728)) {
                var sourcePropFlags = getDeclarationFlagsFromSymbol(sourceProp);
                var targetPropFlags = getDeclarationFlagsFromSymbol(targetProp);
                if (sourcePropFlags & 32 || targetPropFlags & 32) {
                  if (sourceProp.valueDeclaration !== targetProp.valueDeclaration) {
                    if (reportErrors) {
                      if (sourcePropFlags & 32 && targetPropFlags & 32) {
                        reportError(ts.Diagnostics.Types_have_separate_declarations_of_a_private_property_0, symbolToString(targetProp));
                      } else {
                        reportError(ts.Diagnostics.Property_0_is_private_in_type_1_but_not_in_type_2, symbolToString(targetProp), typeToString(sourcePropFlags & 32 ? source : target), typeToString(sourcePropFlags & 32 ? target : source));
                      }
                    }
                    return 0;
                  }
                } else if (targetPropFlags & 64) {
                  var sourceDeclaredInClass = sourceProp.parent && sourceProp.parent.flags & 32;
                  var sourceClass = sourceDeclaredInClass ? getDeclaredTypeOfSymbol(sourceProp.parent) : undefined;
                  var targetClass = getDeclaredTypeOfSymbol(targetProp.parent);
                  if (!sourceClass || !hasBaseType(sourceClass, targetClass)) {
                    if (reportErrors) {
                      reportError(ts.Diagnostics.Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2, symbolToString(targetProp), typeToString(sourceClass || source), typeToString(targetClass));
                    }
                    return 0;
                  }
                } else if (sourcePropFlags & 64) {
                  if (reportErrors) {
                    reportError(ts.Diagnostics.Property_0_is_protected_in_type_1_but_public_in_type_2, symbolToString(targetProp), typeToString(source), typeToString(target));
                  }
                  return 0;
                }
                var related = isRelatedTo(getTypeOfSymbol(sourceProp), getTypeOfSymbol(targetProp), reportErrors);
                if (!related) {
                  if (reportErrors) {
                    reportError(ts.Diagnostics.Types_of_property_0_are_incompatible, symbolToString(targetProp));
                  }
                  return 0;
                }
                result &= related;
                if (sourceProp.flags & 536870912 && !(targetProp.flags & 536870912)) {
                  if (reportErrors) {
                    reportError(ts.Diagnostics.Property_0_is_optional_in_type_1_but_required_in_type_2, symbolToString(targetProp), typeToString(source), typeToString(target));
                  }
                  return 0;
                }
              }
            }
          }
          return result;
        }
        function propertiesIdenticalTo(source, target) {
          if (!(source.flags & 80896 && target.flags & 80896)) {
            return 0;
          }
          var sourceProperties = getPropertiesOfObjectType(source);
          var targetProperties = getPropertiesOfObjectType(target);
          if (sourceProperties.length !== targetProperties.length) {
            return 0;
          }
          var result = -1;
          for (var _i = 0; _i < sourceProperties.length; _i++) {
            var sourceProp = sourceProperties[_i];
            var targetProp = getPropertyOfObjectType(target, sourceProp.name);
            if (!targetProp) {
              return 0;
            }
            var related = compareProperties(sourceProp, targetProp, isRelatedTo);
            if (!related) {
              return 0;
            }
            result &= related;
          }
          return result;
        }
        function signaturesRelatedTo(source, target, kind, reportErrors) {
          if (relation === identityRelation) {
            return signaturesIdenticalTo(source, target, kind);
          }
          if (target === anyFunctionType || source === anyFunctionType) {
            return -1;
          }
          var sourceSignatures = getSignaturesOfType(source, kind);
          var targetSignatures = getSignaturesOfType(target, kind);
          var result = -1;
          var saveErrorInfo = errorInfo;
          if (kind === 1) {
            var sourceSig = sourceSignatures[0];
            var targetSig = targetSignatures[0];
            result &= abstractSignatureRelatedTo(source, sourceSig, target, targetSig);
            if (result !== -1) {
              return result;
            }
          }
          outer: for (var _i = 0; _i < targetSignatures.length; _i++) {
            var t = targetSignatures[_i];
            if (!t.hasStringLiterals || target.flags & 262144) {
              var localErrors = reportErrors;
              var checkedAbstractAssignability = false;
              for (var _a = 0; _a < sourceSignatures.length; _a++) {
                var s = sourceSignatures[_a];
                if (!s.hasStringLiterals || source.flags & 262144) {
                  var related = signatureRelatedTo(s, t, localErrors);
                  if (related) {
                    result &= related;
                    errorInfo = saveErrorInfo;
                    continue outer;
                  }
                  localErrors = false;
                }
              }
              return 0;
            }
          }
          return result;
          function abstractSignatureRelatedTo(source, sourceSig, target, targetSig) {
            if (sourceSig && targetSig) {
              var sourceDecl = source.symbol && ts.getDeclarationOfKind(source.symbol, 212);
              var targetDecl = target.symbol && ts.getDeclarationOfKind(target.symbol, 212);
              if (!sourceDecl) {
                return -1;
              }
              var sourceErasedSignature = getErasedSignature(sourceSig);
              var targetErasedSignature = getErasedSignature(targetSig);
              var sourceReturnType = sourceErasedSignature && getReturnTypeOfSignature(sourceErasedSignature);
              var targetReturnType = targetErasedSignature && getReturnTypeOfSignature(targetErasedSignature);
              var sourceReturnDecl = sourceReturnType && sourceReturnType.symbol && ts.getDeclarationOfKind(sourceReturnType.symbol, 212);
              var targetReturnDecl = targetReturnType && targetReturnType.symbol && ts.getDeclarationOfKind(targetReturnType.symbol, 212);
              var sourceIsAbstract = sourceReturnDecl && sourceReturnDecl.flags & 256;
              var targetIsAbstract = targetReturnDecl && targetReturnDecl.flags & 256;
              if (sourceIsAbstract && !(targetIsAbstract && targetDecl)) {
                if (reportErrors) {
                  reportError(ts.Diagnostics.Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type);
                }
                return 0;
              }
            }
            return -1;
          }
        }
        function signatureRelatedTo(source, target, reportErrors) {
          if (source === target) {
            return -1;
          }
          if (!target.hasRestParameter && source.minArgumentCount > target.parameters.length) {
            return 0;
          }
          var sourceMax = source.parameters.length;
          var targetMax = target.parameters.length;
          var checkCount;
          if (source.hasRestParameter && target.hasRestParameter) {
            checkCount = sourceMax > targetMax ? sourceMax : targetMax;
            sourceMax--;
            targetMax--;
          } else if (source.hasRestParameter) {
            sourceMax--;
            checkCount = targetMax;
          } else if (target.hasRestParameter) {
            targetMax--;
            checkCount = sourceMax;
          } else {
            checkCount = sourceMax < targetMax ? sourceMax : targetMax;
          }
          source = getErasedSignature(source);
          target = getErasedSignature(target);
          var result = -1;
          for (var i = 0; i < checkCount; i++) {
            var s = i < sourceMax ? getTypeOfSymbol(source.parameters[i]) : getRestTypeOfSignature(source);
            var t = i < targetMax ? getTypeOfSymbol(target.parameters[i]) : getRestTypeOfSignature(target);
            var saveErrorInfo = errorInfo;
            var related = isRelatedTo(s, t, reportErrors);
            if (!related) {
              related = isRelatedTo(t, s, false);
              if (!related) {
                if (reportErrors) {
                  reportError(ts.Diagnostics.Types_of_parameters_0_and_1_are_incompatible, source.parameters[i < sourceMax ? i : sourceMax].name, target.parameters[i < targetMax ? i : targetMax].name);
                }
                return 0;
              }
              errorInfo = saveErrorInfo;
            }
            result &= related;
          }
          if (source.typePredicate && target.typePredicate) {
            var hasDifferentParameterIndex = source.typePredicate.parameterIndex !== target.typePredicate.parameterIndex;
            var hasDifferentTypes;
            if (hasDifferentParameterIndex || (hasDifferentTypes = !isTypeIdenticalTo(source.typePredicate.type, target.typePredicate.type))) {
              if (reportErrors) {
                var sourceParamText = source.typePredicate.parameterName;
                var targetParamText = target.typePredicate.parameterName;
                var sourceTypeText = typeToString(source.typePredicate.type);
                var targetTypeText = typeToString(target.typePredicate.type);
                if (hasDifferentParameterIndex) {
                  reportError(ts.Diagnostics.Parameter_0_is_not_in_the_same_position_as_parameter_1, sourceParamText, targetParamText);
                } else if (hasDifferentTypes) {
                  reportError(ts.Diagnostics.Type_0_is_not_assignable_to_type_1, sourceTypeText, targetTypeText);
                }
                reportError(ts.Diagnostics.Type_predicate_0_is_not_assignable_to_1, sourceParamText + " is " + sourceTypeText, targetParamText + " is " + targetTypeText);
              }
              return 0;
            }
          } else if (!source.typePredicate && target.typePredicate) {
            if (reportErrors) {
              reportError(ts.Diagnostics.Signature_0_must_have_a_type_predicate, signatureToString(source));
            }
            return 0;
          }
          var targetReturnType = getReturnTypeOfSignature(target);
          if (targetReturnType === voidType)
            return result;
          var sourceReturnType = getReturnTypeOfSignature(source);
          return result & isRelatedTo(sourceReturnType, targetReturnType, reportErrors);
        }
        function signaturesIdenticalTo(source, target, kind) {
          var sourceSignatures = getSignaturesOfType(source, kind);
          var targetSignatures = getSignaturesOfType(target, kind);
          if (sourceSignatures.length !== targetSignatures.length) {
            return 0;
          }
          var result = -1;
          for (var i = 0,
              len = sourceSignatures.length; i < len; ++i) {
            var related = compareSignatures(sourceSignatures[i], targetSignatures[i], false, false, isRelatedTo);
            if (!related) {
              return 0;
            }
            result &= related;
          }
          return result;
        }
        function stringIndexTypesRelatedTo(source, target, reportErrors) {
          if (relation === identityRelation) {
            return indexTypesIdenticalTo(0, source, target);
          }
          var targetType = getIndexTypeOfType(target, 0);
          if (targetType && !(targetType.flags & 1)) {
            var sourceType = getIndexTypeOfType(source, 0);
            if (!sourceType) {
              if (reportErrors) {
                reportError(ts.Diagnostics.Index_signature_is_missing_in_type_0, typeToString(source));
              }
              return 0;
            }
            var related = isRelatedTo(sourceType, targetType, reportErrors);
            if (!related) {
              if (reportErrors) {
                reportError(ts.Diagnostics.Index_signatures_are_incompatible);
              }
              return 0;
            }
            return related;
          }
          return -1;
        }
        function numberIndexTypesRelatedTo(source, target, reportErrors) {
          if (relation === identityRelation) {
            return indexTypesIdenticalTo(1, source, target);
          }
          var targetType = getIndexTypeOfType(target, 1);
          if (targetType && !(targetType.flags & 1)) {
            var sourceStringType = getIndexTypeOfType(source, 0);
            var sourceNumberType = getIndexTypeOfType(source, 1);
            if (!(sourceStringType || sourceNumberType)) {
              if (reportErrors) {
                reportError(ts.Diagnostics.Index_signature_is_missing_in_type_0, typeToString(source));
              }
              return 0;
            }
            var related;
            if (sourceStringType && sourceNumberType) {
              related = isRelatedTo(sourceStringType, targetType, false) || isRelatedTo(sourceNumberType, targetType, reportErrors);
            } else {
              related = isRelatedTo(sourceStringType || sourceNumberType, targetType, reportErrors);
            }
            if (!related) {
              if (reportErrors) {
                reportError(ts.Diagnostics.Index_signatures_are_incompatible);
              }
              return 0;
            }
            return related;
          }
          return -1;
        }
        function indexTypesIdenticalTo(indexKind, source, target) {
          var targetType = getIndexTypeOfType(target, indexKind);
          var sourceType = getIndexTypeOfType(source, indexKind);
          if (!sourceType && !targetType) {
            return -1;
          }
          if (sourceType && targetType) {
            return isRelatedTo(sourceType, targetType);
          }
          return 0;
        }
      }
      function isDeeplyNestedGeneric(type, stack, depth) {
        if (type.flags & (4096 | 131072) && depth >= 5) {
          var symbol = type.symbol;
          var count = 0;
          for (var i = 0; i < depth; i++) {
            var t = stack[i];
            if (t.flags & (4096 | 131072) && t.symbol === symbol) {
              count++;
              if (count >= 5)
                return true;
            }
          }
        }
        return false;
      }
      function isPropertyIdenticalTo(sourceProp, targetProp) {
        return compareProperties(sourceProp, targetProp, compareTypes) !== 0;
      }
      function compareProperties(sourceProp, targetProp, compareTypes) {
        if (sourceProp === targetProp) {
          return -1;
        }
        var sourcePropAccessibility = getDeclarationFlagsFromSymbol(sourceProp) & (32 | 64);
        var targetPropAccessibility = getDeclarationFlagsFromSymbol(targetProp) & (32 | 64);
        if (sourcePropAccessibility !== targetPropAccessibility) {
          return 0;
        }
        if (sourcePropAccessibility) {
          if (getTargetSymbol(sourceProp) !== getTargetSymbol(targetProp)) {
            return 0;
          }
        } else {
          if ((sourceProp.flags & 536870912) !== (targetProp.flags & 536870912)) {
            return 0;
          }
        }
        return compareTypes(getTypeOfSymbol(sourceProp), getTypeOfSymbol(targetProp));
      }
      function compareSignatures(source, target, partialMatch, ignoreReturnTypes, compareTypes) {
        if (source === target) {
          return -1;
        }
        if (source.parameters.length !== target.parameters.length || source.minArgumentCount !== target.minArgumentCount || source.hasRestParameter !== target.hasRestParameter) {
          if (!partialMatch || source.parameters.length < target.parameters.length && !source.hasRestParameter || source.minArgumentCount > target.minArgumentCount) {
            return 0;
          }
        }
        var result = -1;
        if (source.typeParameters && target.typeParameters) {
          if (source.typeParameters.length !== target.typeParameters.length) {
            return 0;
          }
          for (var i = 0,
              len = source.typeParameters.length; i < len; ++i) {
            var related = compareTypes(source.typeParameters[i], target.typeParameters[i]);
            if (!related) {
              return 0;
            }
            result &= related;
          }
        } else if (source.typeParameters || target.typeParameters) {
          return 0;
        }
        source = getErasedSignature(source);
        target = getErasedSignature(target);
        var sourceLen = source.parameters.length;
        var targetLen = target.parameters.length;
        for (var i = 0; i < targetLen; i++) {
          var s = source.hasRestParameter && i === sourceLen - 1 ? getRestTypeOfSignature(source) : getTypeOfSymbol(source.parameters[i]);
          var t = target.hasRestParameter && i === targetLen - 1 ? getRestTypeOfSignature(target) : getTypeOfSymbol(target.parameters[i]);
          var related = compareTypes(s, t);
          if (!related) {
            return 0;
          }
          result &= related;
        }
        if (!ignoreReturnTypes) {
          result &= compareTypes(getReturnTypeOfSignature(source), getReturnTypeOfSignature(target));
        }
        return result;
      }
      function isSupertypeOfEach(candidate, types) {
        for (var _i = 0; _i < types.length; _i++) {
          var type = types[_i];
          if (candidate !== type && !isTypeSubtypeOf(type, candidate))
            return false;
        }
        return true;
      }
      function getCommonSupertype(types) {
        return ts.forEach(types, function(t) {
          return isSupertypeOfEach(t, types) ? t : undefined;
        });
      }
      function reportNoCommonSupertypeError(types, errorLocation, errorMessageChainHead) {
        var bestSupertype;
        var bestSupertypeDownfallType;
        var bestSupertypeScore = 0;
        for (var i = 0; i < types.length; i++) {
          var score = 0;
          var downfallType = undefined;
          for (var j = 0; j < types.length; j++) {
            if (isTypeSubtypeOf(types[j], types[i])) {
              score++;
            } else if (!downfallType) {
              downfallType = types[j];
            }
          }
          ts.Debug.assert(!!downfallType, "If there is no common supertype, each type should have a downfallType");
          if (score > bestSupertypeScore) {
            bestSupertype = types[i];
            bestSupertypeDownfallType = downfallType;
            bestSupertypeScore = score;
          }
          if (bestSupertypeScore === types.length - 1) {
            break;
          }
        }
        checkTypeSubtypeOf(bestSupertypeDownfallType, bestSupertype, errorLocation, ts.Diagnostics.Type_argument_candidate_1_is_not_a_valid_type_argument_because_it_is_not_a_supertype_of_candidate_0, errorMessageChainHead);
      }
      function isArrayType(type) {
        return type.flags & 4096 && type.target === globalArrayType;
      }
      function isArrayLikeType(type) {
        return !(type.flags & (32 | 64)) && isTypeAssignableTo(type, anyArrayType);
      }
      function isTupleLikeType(type) {
        return !!getPropertyOfType(type, "0");
      }
      function isTupleType(type) {
        return !!(type.flags & 8192);
      }
      function getRegularTypeOfObjectLiteral(type) {
        if (type.flags & 1048576) {
          var regularType = type.regularType;
          if (!regularType) {
            regularType = createType(type.flags & ~1048576);
            regularType.symbol = type.symbol;
            regularType.members = type.members;
            regularType.properties = type.properties;
            regularType.callSignatures = type.callSignatures;
            regularType.constructSignatures = type.constructSignatures;
            regularType.stringIndexType = type.stringIndexType;
            regularType.numberIndexType = type.numberIndexType;
          }
          return regularType;
        }
        return type;
      }
      function getWidenedTypeOfObjectLiteral(type) {
        var properties = getPropertiesOfObjectType(type);
        var members = {};
        ts.forEach(properties, function(p) {
          var propType = getTypeOfSymbol(p);
          var widenedType = getWidenedType(propType);
          if (propType !== widenedType) {
            var symbol = createSymbol(p.flags | 67108864, p.name);
            symbol.declarations = p.declarations;
            symbol.parent = p.parent;
            symbol.type = widenedType;
            symbol.target = p;
            if (p.valueDeclaration)
              symbol.valueDeclaration = p.valueDeclaration;
            p = symbol;
          }
          members[p.name] = p;
        });
        var stringIndexType = getIndexTypeOfType(type, 0);
        var numberIndexType = getIndexTypeOfType(type, 1);
        if (stringIndexType)
          stringIndexType = getWidenedType(stringIndexType);
        if (numberIndexType)
          numberIndexType = getWidenedType(numberIndexType);
        return createAnonymousType(type.symbol, members, emptyArray, emptyArray, stringIndexType, numberIndexType);
      }
      function getWidenedType(type) {
        if (type.flags & 6291456) {
          if (type.flags & (32 | 64)) {
            return anyType;
          }
          if (type.flags & 524288) {
            return getWidenedTypeOfObjectLiteral(type);
          }
          if (type.flags & 16384) {
            return getUnionType(ts.map(type.types, getWidenedType), true);
          }
          if (isArrayType(type)) {
            return createArrayType(getWidenedType(type.typeArguments[0]));
          }
          if (isTupleType(type)) {
            return createTupleType(ts.map(type.elementTypes, getWidenedType));
          }
        }
        return type;
      }
      function reportWideningErrorsInType(type) {
        var errorReported = false;
        if (type.flags & 16384) {
          for (var _i = 0,
              _a = type.types; _i < _a.length; _i++) {
            var t = _a[_i];
            if (reportWideningErrorsInType(t)) {
              errorReported = true;
            }
          }
        }
        if (isArrayType(type)) {
          return reportWideningErrorsInType(type.typeArguments[0]);
        }
        if (isTupleType(type)) {
          for (var _b = 0,
              _c = type.elementTypes; _b < _c.length; _b++) {
            var t = _c[_b];
            if (reportWideningErrorsInType(t)) {
              errorReported = true;
            }
          }
        }
        if (type.flags & 524288) {
          for (var _d = 0,
              _e = getPropertiesOfObjectType(type); _d < _e.length; _d++) {
            var p = _e[_d];
            var t = getTypeOfSymbol(p);
            if (t.flags & 2097152) {
              if (!reportWideningErrorsInType(t)) {
                error(p.valueDeclaration, ts.Diagnostics.Object_literal_s_property_0_implicitly_has_an_1_type, p.name, typeToString(getWidenedType(t)));
              }
              errorReported = true;
            }
          }
        }
        return errorReported;
      }
      function reportImplicitAnyError(declaration, type) {
        var typeAsString = typeToString(getWidenedType(type));
        var diagnostic;
        switch (declaration.kind) {
          case 139:
          case 138:
            diagnostic = ts.Diagnostics.Member_0_implicitly_has_an_1_type;
            break;
          case 136:
            diagnostic = declaration.dotDotDotToken ? ts.Diagnostics.Rest_parameter_0_implicitly_has_an_any_type : ts.Diagnostics.Parameter_0_implicitly_has_an_1_type;
            break;
          case 211:
          case 141:
          case 140:
          case 143:
          case 144:
          case 171:
          case 172:
            if (!declaration.name) {
              error(declaration, ts.Diagnostics.Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type, typeAsString);
              return;
            }
            diagnostic = ts.Diagnostics._0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type;
            break;
          default:
            diagnostic = ts.Diagnostics.Variable_0_implicitly_has_an_1_type;
        }
        error(declaration, diagnostic, ts.declarationNameToString(declaration.name), typeAsString);
      }
      function reportErrorsFromWidening(declaration, type) {
        if (produceDiagnostics && compilerOptions.noImplicitAny && type.flags & 2097152) {
          if (!reportWideningErrorsInType(type)) {
            reportImplicitAnyError(declaration, type);
          }
        }
      }
      function forEachMatchingParameterType(source, target, callback) {
        var sourceMax = source.parameters.length;
        var targetMax = target.parameters.length;
        var count;
        if (source.hasRestParameter && target.hasRestParameter) {
          count = sourceMax > targetMax ? sourceMax : targetMax;
          sourceMax--;
          targetMax--;
        } else if (source.hasRestParameter) {
          sourceMax--;
          count = targetMax;
        } else if (target.hasRestParameter) {
          targetMax--;
          count = sourceMax;
        } else {
          count = sourceMax < targetMax ? sourceMax : targetMax;
        }
        for (var i = 0; i < count; i++) {
          var s = i < sourceMax ? getTypeOfSymbol(source.parameters[i]) : getRestTypeOfSignature(source);
          var t = i < targetMax ? getTypeOfSymbol(target.parameters[i]) : getRestTypeOfSignature(target);
          callback(s, t);
        }
      }
      function createInferenceContext(typeParameters, inferUnionTypes) {
        var inferences = [];
        for (var _i = 0; _i < typeParameters.length; _i++) {
          var unused = typeParameters[_i];
          inferences.push({
            primary: undefined,
            secondary: undefined,
            isFixed: false
          });
        }
        return {
          typeParameters: typeParameters,
          inferUnionTypes: inferUnionTypes,
          inferences: inferences,
          inferredTypes: new Array(typeParameters.length)
        };
      }
      function inferTypes(context, source, target) {
        var sourceStack;
        var targetStack;
        var depth = 0;
        var inferiority = 0;
        inferFromTypes(source, target);
        function isInProcess(source, target) {
          for (var i = 0; i < depth; i++) {
            if (source === sourceStack[i] && target === targetStack[i]) {
              return true;
            }
          }
          return false;
        }
        function inferFromTypes(source, target) {
          if (target.flags & 512) {
            if (source.flags & 8388608) {
              return;
            }
            var typeParameters = context.typeParameters;
            for (var i = 0; i < typeParameters.length; i++) {
              if (target === typeParameters[i]) {
                var inferences = context.inferences[i];
                if (!inferences.isFixed) {
                  var candidates = inferiority ? inferences.secondary || (inferences.secondary = []) : inferences.primary || (inferences.primary = []);
                  if (!ts.contains(candidates, source)) {
                    candidates.push(source);
                  }
                }
                return;
              }
            }
          } else if (source.flags & 4096 && target.flags & 4096 && source.target === target.target) {
            var sourceTypes = source.typeArguments;
            var targetTypes = target.typeArguments;
            for (var i = 0; i < sourceTypes.length; i++) {
              inferFromTypes(sourceTypes[i], targetTypes[i]);
            }
          } else if (source.flags & 8192 && target.flags & 8192 && source.elementTypes.length === target.elementTypes.length) {
            var sourceTypes = source.elementTypes;
            var targetTypes = target.elementTypes;
            for (var i = 0; i < sourceTypes.length; i++) {
              inferFromTypes(sourceTypes[i], targetTypes[i]);
            }
          } else if (target.flags & 49152) {
            var targetTypes = target.types;
            var typeParameterCount = 0;
            var typeParameter;
            for (var _i = 0; _i < targetTypes.length; _i++) {
              var t = targetTypes[_i];
              if (t.flags & 512 && ts.contains(context.typeParameters, t)) {
                typeParameter = t;
                typeParameterCount++;
              } else {
                inferFromTypes(source, t);
              }
            }
            if (target.flags & 16384 && typeParameterCount === 1) {
              inferiority++;
              inferFromTypes(source, typeParameter);
              inferiority--;
            }
          } else if (source.flags & 49152) {
            var sourceTypes = source.types;
            for (var _a = 0; _a < sourceTypes.length; _a++) {
              var sourceType = sourceTypes[_a];
              inferFromTypes(sourceType, target);
            }
          } else {
            source = getApparentType(source);
            if (source.flags & 80896 && (target.flags & (4096 | 8192) || (target.flags & 65536) && target.symbol && target.symbol.flags & (8192 | 2048 | 32))) {
              if (isInProcess(source, target)) {
                return;
              }
              if (isDeeplyNestedGeneric(source, sourceStack, depth) && isDeeplyNestedGeneric(target, targetStack, depth)) {
                return;
              }
              if (depth === 0) {
                sourceStack = [];
                targetStack = [];
              }
              sourceStack[depth] = source;
              targetStack[depth] = target;
              depth++;
              inferFromProperties(source, target);
              inferFromSignatures(source, target, 0);
              inferFromSignatures(source, target, 1);
              inferFromIndexTypes(source, target, 0, 0);
              inferFromIndexTypes(source, target, 1, 1);
              inferFromIndexTypes(source, target, 0, 1);
              depth--;
            }
          }
        }
        function inferFromProperties(source, target) {
          var properties = getPropertiesOfObjectType(target);
          for (var _i = 0; _i < properties.length; _i++) {
            var targetProp = properties[_i];
            var sourceProp = getPropertyOfObjectType(source, targetProp.name);
            if (sourceProp) {
              inferFromTypes(getTypeOfSymbol(sourceProp), getTypeOfSymbol(targetProp));
            }
          }
        }
        function inferFromSignatures(source, target, kind) {
          var sourceSignatures = getSignaturesOfType(source, kind);
          var targetSignatures = getSignaturesOfType(target, kind);
          var sourceLen = sourceSignatures.length;
          var targetLen = targetSignatures.length;
          var len = sourceLen < targetLen ? sourceLen : targetLen;
          for (var i = 0; i < len; i++) {
            inferFromSignature(getErasedSignature(sourceSignatures[sourceLen - len + i]), getErasedSignature(targetSignatures[targetLen - len + i]));
          }
        }
        function inferFromSignature(source, target) {
          forEachMatchingParameterType(source, target, inferFromTypes);
          if (source.typePredicate && target.typePredicate) {
            if (target.typePredicate.parameterIndex === source.typePredicate.parameterIndex) {
              inferFromTypes(source.typePredicate.type, target.typePredicate.type);
            }
          } else {
            inferFromTypes(getReturnTypeOfSignature(source), getReturnTypeOfSignature(target));
          }
        }
        function inferFromIndexTypes(source, target, sourceKind, targetKind) {
          var targetIndexType = getIndexTypeOfType(target, targetKind);
          if (targetIndexType) {
            var sourceIndexType = getIndexTypeOfType(source, sourceKind);
            if (sourceIndexType) {
              inferFromTypes(sourceIndexType, targetIndexType);
            }
          }
        }
      }
      function getInferenceCandidates(context, index) {
        var inferences = context.inferences[index];
        return inferences.primary || inferences.secondary || emptyArray;
      }
      function getInferredType(context, index) {
        var inferredType = context.inferredTypes[index];
        var inferenceSucceeded;
        if (!inferredType) {
          var inferences = getInferenceCandidates(context, index);
          if (inferences.length) {
            var unionOrSuperType = context.inferUnionTypes ? getUnionType(inferences) : getCommonSupertype(inferences);
            inferredType = unionOrSuperType ? getWidenedType(unionOrSuperType) : unknownType;
            inferenceSucceeded = !!unionOrSuperType;
          } else {
            inferredType = emptyObjectType;
            inferenceSucceeded = true;
          }
          if (inferenceSucceeded) {
            var constraint = getConstraintOfTypeParameter(context.typeParameters[index]);
            inferredType = constraint && !isTypeAssignableTo(inferredType, constraint) ? constraint : inferredType;
          } else if (context.failedTypeParameterIndex === undefined || context.failedTypeParameterIndex > index) {
            context.failedTypeParameterIndex = index;
          }
          context.inferredTypes[index] = inferredType;
        }
        return inferredType;
      }
      function getInferredTypes(context) {
        for (var i = 0; i < context.inferredTypes.length; i++) {
          getInferredType(context, i);
        }
        return context.inferredTypes;
      }
      function hasAncestor(node, kind) {
        return ts.getAncestor(node, kind) !== undefined;
      }
      function getResolvedSymbol(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedSymbol) {
          links.resolvedSymbol = (!ts.nodeIsMissing(node) && resolveName(node, node.text, 107455 | 1048576, ts.Diagnostics.Cannot_find_name_0, node)) || unknownSymbol;
        }
        return links.resolvedSymbol;
      }
      function isInTypeQuery(node) {
        while (node) {
          switch (node.kind) {
            case 152:
              return true;
            case 67:
            case 133:
              node = node.parent;
              continue;
            default:
              return false;
          }
        }
        ts.Debug.fail("should not get here");
      }
      function removeTypesFromUnionType(type, typeKind, isOfTypeKind, allowEmptyUnionResult) {
        if (type.flags & 16384) {
          var types = type.types;
          if (ts.forEach(types, function(t) {
            return !!(t.flags & typeKind) === isOfTypeKind;
          })) {
            var narrowedType = getUnionType(ts.filter(types, function(t) {
              return !(t.flags & typeKind) === isOfTypeKind;
            }));
            if (allowEmptyUnionResult || narrowedType !== emptyObjectType) {
              return narrowedType;
            }
          }
        } else if (allowEmptyUnionResult && !!(type.flags & typeKind) === isOfTypeKind) {
          return getUnionType(emptyArray);
        }
        return type;
      }
      function hasInitializer(node) {
        return !!(node.initializer || ts.isBindingPattern(node.parent) && hasInitializer(node.parent.parent));
      }
      function isVariableAssignedWithin(symbol, node) {
        var links = getNodeLinks(node);
        if (links.assignmentChecks) {
          var cachedResult = links.assignmentChecks[symbol.id];
          if (cachedResult !== undefined) {
            return cachedResult;
          }
        } else {
          links.assignmentChecks = {};
        }
        return links.assignmentChecks[symbol.id] = isAssignedIn(node);
        function isAssignedInBinaryExpression(node) {
          if (node.operatorToken.kind >= 55 && node.operatorToken.kind <= 66) {
            var n = node.left;
            while (n.kind === 170) {
              n = n.expression;
            }
            if (n.kind === 67 && getResolvedSymbol(n) === symbol) {
              return true;
            }
          }
          return ts.forEachChild(node, isAssignedIn);
        }
        function isAssignedInVariableDeclaration(node) {
          if (!ts.isBindingPattern(node.name) && getSymbolOfNode(node) === symbol && hasInitializer(node)) {
            return true;
          }
          return ts.forEachChild(node, isAssignedIn);
        }
        function isAssignedIn(node) {
          switch (node.kind) {
            case 179:
              return isAssignedInBinaryExpression(node);
            case 209:
            case 161:
              return isAssignedInVariableDeclaration(node);
            case 159:
            case 160:
            case 162:
            case 163:
            case 164:
            case 165:
            case 166:
            case 167:
            case 169:
            case 187:
            case 170:
            case 177:
            case 173:
            case 176:
            case 174:
            case 175:
            case 178:
            case 182:
            case 180:
            case 183:
            case 190:
            case 191:
            case 193:
            case 194:
            case 195:
            case 196:
            case 197:
            case 198:
            case 199:
            case 202:
            case 203:
            case 204:
            case 239:
            case 240:
            case 205:
            case 206:
            case 207:
            case 242:
            case 231:
            case 232:
            case 236:
            case 237:
            case 233:
            case 238:
              return ts.forEachChild(node, isAssignedIn);
          }
          return false;
        }
      }
      function getNarrowedTypeOfSymbol(symbol, node) {
        var type = getTypeOfSymbol(symbol);
        if (node && symbol.flags & 3) {
          if (isTypeAny(type) || type.flags & (80896 | 16384 | 512)) {
            loop: while (node.parent) {
              var child = node;
              node = node.parent;
              var narrowedType = type;
              switch (node.kind) {
                case 194:
                  if (child !== node.expression) {
                    narrowedType = narrowType(type, node.expression, child === node.thenStatement);
                  }
                  break;
                case 180:
                  if (child !== node.condition) {
                    narrowedType = narrowType(type, node.condition, child === node.whenTrue);
                  }
                  break;
                case 179:
                  if (child === node.right) {
                    if (node.operatorToken.kind === 50) {
                      narrowedType = narrowType(type, node.left, true);
                    } else if (node.operatorToken.kind === 51) {
                      narrowedType = narrowType(type, node.left, false);
                    }
                  }
                  break;
                case 246:
                case 216:
                case 211:
                case 141:
                case 140:
                case 143:
                case 144:
                case 142:
                  break loop;
              }
              if (narrowedType !== type) {
                if (isVariableAssignedWithin(symbol, node)) {
                  break;
                }
                type = narrowedType;
              }
            }
          }
        }
        return type;
        function narrowTypeByEquality(type, expr, assumeTrue) {
          if (expr.left.kind !== 174 || expr.right.kind !== 9) {
            return type;
          }
          var left = expr.left;
          var right = expr.right;
          if (left.expression.kind !== 67 || getResolvedSymbol(left.expression) !== symbol) {
            return type;
          }
          var typeInfo = primitiveTypeInfo[right.text];
          if (expr.operatorToken.kind === 33) {
            assumeTrue = !assumeTrue;
          }
          if (assumeTrue) {
            if (!typeInfo) {
              return removeTypesFromUnionType(type, 258 | 132 | 8 | 16777216, true, false);
            }
            if (isTypeSubtypeOf(typeInfo.type, type)) {
              return typeInfo.type;
            }
            return removeTypesFromUnionType(type, typeInfo.flags, false, false);
          } else {
            if (typeInfo) {
              return removeTypesFromUnionType(type, typeInfo.flags, true, false);
            }
            return type;
          }
        }
        function narrowTypeByAnd(type, expr, assumeTrue) {
          if (assumeTrue) {
            return narrowType(narrowType(type, expr.left, true), expr.right, true);
          } else {
            return getUnionType([narrowType(type, expr.left, false), narrowType(narrowType(type, expr.left, true), expr.right, false)]);
          }
        }
        function narrowTypeByOr(type, expr, assumeTrue) {
          if (assumeTrue) {
            return getUnionType([narrowType(type, expr.left, true), narrowType(narrowType(type, expr.left, false), expr.right, true)]);
          } else {
            return narrowType(narrowType(type, expr.left, false), expr.right, false);
          }
        }
        function narrowTypeByInstanceof(type, expr, assumeTrue) {
          if (isTypeAny(type) || !assumeTrue || expr.left.kind !== 67 || getResolvedSymbol(expr.left) !== symbol) {
            return type;
          }
          var rightType = checkExpression(expr.right);
          if (!isTypeSubtypeOf(rightType, globalFunctionType)) {
            return type;
          }
          var targetType;
          var prototypeProperty = getPropertyOfType(rightType, "prototype");
          if (prototypeProperty) {
            var prototypePropertyType = getTypeOfSymbol(prototypeProperty);
            if (!isTypeAny(prototypePropertyType)) {
              targetType = prototypePropertyType;
            }
          }
          if (!targetType) {
            var constructSignatures;
            if (rightType.flags & 2048) {
              constructSignatures = resolveDeclaredMembers(rightType).declaredConstructSignatures;
            } else if (rightType.flags & 65536) {
              constructSignatures = getSignaturesOfType(rightType, 1);
            }
            if (constructSignatures && constructSignatures.length) {
              targetType = getUnionType(ts.map(constructSignatures, function(signature) {
                return getReturnTypeOfSignature(getErasedSignature(signature));
              }));
            }
          }
          if (targetType) {
            return getNarrowedType(type, targetType);
          }
          return type;
        }
        function getNarrowedType(originalType, narrowedTypeCandidate) {
          if (originalType.flags & 16384) {
            var assignableConstituents = ts.filter(originalType.types, function(t) {
              return isTypeAssignableTo(t, narrowedTypeCandidate);
            });
            if (assignableConstituents.length) {
              return getUnionType(assignableConstituents);
            }
          }
          if (isTypeAssignableTo(narrowedTypeCandidate, originalType)) {
            return narrowedTypeCandidate;
          }
          return originalType;
        }
        function narrowTypeByTypePredicate(type, expr, assumeTrue) {
          if (type.flags & 1) {
            return type;
          }
          var signature = getResolvedSignature(expr);
          if (signature.typePredicate && expr.arguments[signature.typePredicate.parameterIndex] && getSymbolAtLocation(expr.arguments[signature.typePredicate.parameterIndex]) === symbol) {
            if (!assumeTrue) {
              if (type.flags & 16384) {
                return getUnionType(ts.filter(type.types, function(t) {
                  return !isTypeSubtypeOf(t, signature.typePredicate.type);
                }));
              }
              return type;
            }
            return getNarrowedType(type, signature.typePredicate.type);
          }
          return type;
        }
        function narrowType(type, expr, assumeTrue) {
          switch (expr.kind) {
            case 166:
              return narrowTypeByTypePredicate(type, expr, assumeTrue);
            case 170:
              return narrowType(type, expr.expression, assumeTrue);
            case 179:
              var operator = expr.operatorToken.kind;
              if (operator === 32 || operator === 33) {
                return narrowTypeByEquality(type, expr, assumeTrue);
              } else if (operator === 50) {
                return narrowTypeByAnd(type, expr, assumeTrue);
              } else if (operator === 51) {
                return narrowTypeByOr(type, expr, assumeTrue);
              } else if (operator === 89) {
                return narrowTypeByInstanceof(type, expr, assumeTrue);
              }
              break;
            case 177:
              if (expr.operator === 48) {
                return narrowType(type, expr.operand, !assumeTrue);
              }
              break;
          }
          return type;
        }
      }
      function checkIdentifier(node) {
        var symbol = getResolvedSymbol(node);
        if (symbol === argumentsSymbol) {
          var container = ts.getContainingFunction(node);
          if (container.kind === 172) {
            if (languageVersion < 2) {
              error(node, ts.Diagnostics.The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression);
            }
          }
          if (node.parserContextFlags & 8) {
            getNodeLinks(container).flags |= 4096;
            getNodeLinks(node).flags |= 2048;
          }
        }
        if (symbol.flags & 8388608 && !isInTypeQuery(node) && !isConstEnumOrConstEnumOnlyModule(resolveAlias(symbol))) {
          markAliasSymbolAsReferenced(symbol);
        }
        checkCollisionWithCapturedSuperVariable(node, node);
        checkCollisionWithCapturedThisVariable(node, node);
        checkBlockScopedBindingCapturedInLoop(node, symbol);
        return getNarrowedTypeOfSymbol(getExportSymbolOfValueSymbolIfExported(symbol), node);
      }
      function isInsideFunction(node, threshold) {
        var current = node;
        while (current && current !== threshold) {
          if (ts.isFunctionLike(current)) {
            return true;
          }
          current = current.parent;
        }
        return false;
      }
      function checkBlockScopedBindingCapturedInLoop(node, symbol) {
        if (languageVersion >= 2 || (symbol.flags & 2) === 0 || symbol.valueDeclaration.parent.kind === 242) {
          return;
        }
        var container = symbol.valueDeclaration;
        while (container.kind !== 210) {
          container = container.parent;
        }
        container = container.parent;
        if (container.kind === 191) {
          container = container.parent;
        }
        var inFunction = isInsideFunction(node.parent, container);
        var current = container;
        while (current && !ts.nodeStartsNewLexicalEnvironment(current)) {
          if (isIterationStatement(current, false)) {
            if (inFunction) {
              grammarErrorOnFirstToken(current, ts.Diagnostics.Loop_contains_block_scoped_variable_0_referenced_by_a_function_in_the_loop_This_is_only_supported_in_ECMAScript_6_or_higher, ts.declarationNameToString(node));
            }
            getNodeLinks(symbol.valueDeclaration).flags |= 16384;
            break;
          }
          current = current.parent;
        }
      }
      function captureLexicalThis(node, container) {
        getNodeLinks(node).flags |= 2;
        if (container.kind === 139 || container.kind === 142) {
          var classNode = container.parent;
          getNodeLinks(classNode).flags |= 4;
        } else {
          getNodeLinks(container).flags |= 4;
        }
      }
      function checkThisExpression(node) {
        var container = ts.getThisContainer(node, true);
        var needToCaptureLexicalThis = false;
        if (container.kind === 172) {
          container = ts.getThisContainer(container, false);
          needToCaptureLexicalThis = (languageVersion < 2);
        }
        switch (container.kind) {
          case 216:
            error(node, ts.Diagnostics.this_cannot_be_referenced_in_a_module_or_namespace_body);
            break;
          case 215:
            error(node, ts.Diagnostics.this_cannot_be_referenced_in_current_location);
            break;
          case 142:
            if (isInConstructorArgumentInitializer(node, container)) {
              error(node, ts.Diagnostics.this_cannot_be_referenced_in_constructor_arguments);
            }
            break;
          case 139:
          case 138:
            if (container.flags & 128) {
              error(node, ts.Diagnostics.this_cannot_be_referenced_in_a_static_property_initializer);
            }
            break;
          case 134:
            error(node, ts.Diagnostics.this_cannot_be_referenced_in_a_computed_property_name);
            break;
        }
        if (needToCaptureLexicalThis) {
          captureLexicalThis(node, container);
        }
        if (ts.isClassLike(container.parent)) {
          var symbol = getSymbolOfNode(container.parent);
          return container.flags & 128 ? getTypeOfSymbol(symbol) : getDeclaredTypeOfSymbol(symbol);
        }
        return anyType;
      }
      function isInConstructorArgumentInitializer(node, constructorDecl) {
        for (var n = node; n && n !== constructorDecl; n = n.parent) {
          if (n.kind === 136) {
            return true;
          }
        }
        return false;
      }
      function checkSuperExpression(node) {
        var isCallExpression = node.parent.kind === 166 && node.parent.expression === node;
        var classDeclaration = ts.getContainingClass(node);
        var classType = classDeclaration && getDeclaredTypeOfSymbol(getSymbolOfNode(classDeclaration));
        var baseClassType = classType && getBaseTypes(classType)[0];
        var container = ts.getSuperContainer(node, true);
        var needToCaptureLexicalThis = false;
        if (!isCallExpression) {
          while (container && container.kind === 172) {
            container = ts.getSuperContainer(container, true);
            needToCaptureLexicalThis = languageVersion < 2;
          }
        }
        var canUseSuperExpression = isLegalUsageOfSuperExpression(container);
        var nodeCheckFlag = 0;
        if (canUseSuperExpression) {
          if ((container.flags & 128) || isCallExpression) {
            nodeCheckFlag = 512;
          } else {
            nodeCheckFlag = 256;
          }
          getNodeLinks(node).flags |= nodeCheckFlag;
          if (needToCaptureLexicalThis) {
            captureLexicalThis(node.parent, container);
          }
        }
        if (!baseClassType) {
          if (!classDeclaration || !ts.getClassExtendsHeritageClauseElement(classDeclaration)) {
            error(node, ts.Diagnostics.super_can_only_be_referenced_in_a_derived_class);
          }
          return unknownType;
        }
        if (!canUseSuperExpression) {
          if (container && container.kind === 134) {
            error(node, ts.Diagnostics.super_cannot_be_referenced_in_a_computed_property_name);
          } else if (isCallExpression) {
            error(node, ts.Diagnostics.Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors);
          } else {
            error(node, ts.Diagnostics.super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class);
          }
          return unknownType;
        }
        if (container.kind === 142 && isInConstructorArgumentInitializer(node, container)) {
          error(node, ts.Diagnostics.super_cannot_be_referenced_in_constructor_arguments);
          return unknownType;
        }
        return nodeCheckFlag === 512 ? getBaseConstructorTypeOfClass(classType) : baseClassType;
        function isLegalUsageOfSuperExpression(container) {
          if (!container) {
            return false;
          }
          if (isCallExpression) {
            return container.kind === 142;
          } else {
            if (container && ts.isClassLike(container.parent)) {
              if (container.flags & 128) {
                return container.kind === 141 || container.kind === 140 || container.kind === 143 || container.kind === 144;
              } else {
                return container.kind === 141 || container.kind === 140 || container.kind === 143 || container.kind === 144 || container.kind === 139 || container.kind === 138 || container.kind === 142;
              }
            }
          }
          return false;
        }
      }
      function getContextuallyTypedParameterType(parameter) {
        if (isFunctionExpressionOrArrowFunction(parameter.parent)) {
          var func = parameter.parent;
          if (isContextSensitive(func)) {
            var contextualSignature = getContextualSignature(func);
            if (contextualSignature) {
              var funcHasRestParameters = ts.hasRestParameter(func);
              var len = func.parameters.length - (funcHasRestParameters ? 1 : 0);
              var indexOfParameter = ts.indexOf(func.parameters, parameter);
              if (indexOfParameter < len) {
                return getTypeAtPosition(contextualSignature, indexOfParameter);
              }
              if (indexOfParameter === (func.parameters.length - 1) && funcHasRestParameters && contextualSignature.hasRestParameter && func.parameters.length >= contextualSignature.parameters.length) {
                return getTypeOfSymbol(ts.lastOrUndefined(contextualSignature.parameters));
              }
            }
          }
        }
        return undefined;
      }
      function getContextualTypeForInitializerExpression(node) {
        var declaration = node.parent;
        if (node === declaration.initializer) {
          if (declaration.type) {
            return getTypeFromTypeNode(declaration.type);
          }
          if (declaration.kind === 136) {
            var type = getContextuallyTypedParameterType(declaration);
            if (type) {
              return type;
            }
          }
          if (ts.isBindingPattern(declaration.name)) {
            return getTypeFromBindingPattern(declaration.name);
          }
        }
        return undefined;
      }
      function getContextualTypeForReturnExpression(node) {
        var func = ts.getContainingFunction(node);
        if (func && !func.asteriskToken) {
          return getContextualReturnType(func);
        }
        return undefined;
      }
      function getContextualTypeForYieldOperand(node) {
        var func = ts.getContainingFunction(node);
        if (func) {
          var contextualReturnType = getContextualReturnType(func);
          if (contextualReturnType) {
            return node.asteriskToken ? contextualReturnType : getElementTypeOfIterableIterator(contextualReturnType);
          }
        }
        return undefined;
      }
      function isInParameterInitializerBeforeContainingFunction(node) {
        while (node.parent && !ts.isFunctionLike(node.parent)) {
          if (node.parent.kind === 136 && node.parent.initializer === node) {
            return true;
          }
          node = node.parent;
        }
        return false;
      }
      function getContextualReturnType(functionDecl) {
        if (functionDecl.type || functionDecl.kind === 142 || functionDecl.kind === 143 && ts.getSetAccessorTypeAnnotationNode(ts.getDeclarationOfKind(functionDecl.symbol, 144))) {
          return getReturnTypeOfSignature(getSignatureFromDeclaration(functionDecl));
        }
        var signature = getContextualSignatureForFunctionLikeDeclaration(functionDecl);
        if (signature) {
          return getReturnTypeOfSignature(signature);
        }
        return undefined;
      }
      function getContextualTypeForArgument(callTarget, arg) {
        var args = getEffectiveCallArguments(callTarget);
        var argIndex = ts.indexOf(args, arg);
        if (argIndex >= 0) {
          var signature = getResolvedSignature(callTarget);
          return getTypeAtPosition(signature, argIndex);
        }
        return undefined;
      }
      function getContextualTypeForSubstitutionExpression(template, substitutionExpression) {
        if (template.parent.kind === 168) {
          return getContextualTypeForArgument(template.parent, substitutionExpression);
        }
        return undefined;
      }
      function getContextualTypeForBinaryOperand(node) {
        var binaryExpression = node.parent;
        var operator = binaryExpression.operatorToken.kind;
        if (operator >= 55 && operator <= 66) {
          if (node === binaryExpression.right) {
            return checkExpression(binaryExpression.left);
          }
        } else if (operator === 51) {
          var type = getContextualType(binaryExpression);
          if (!type && node === binaryExpression.right) {
            type = checkExpression(binaryExpression.left);
          }
          return type;
        }
        return undefined;
      }
      function applyToContextualType(type, mapper) {
        if (!(type.flags & 16384)) {
          return mapper(type);
        }
        var types = type.types;
        var mappedType;
        var mappedTypes;
        for (var _i = 0; _i < types.length; _i++) {
          var current = types[_i];
          var t = mapper(current);
          if (t) {
            if (!mappedType) {
              mappedType = t;
            } else if (!mappedTypes) {
              mappedTypes = [mappedType, t];
            } else {
              mappedTypes.push(t);
            }
          }
        }
        return mappedTypes ? getUnionType(mappedTypes) : mappedType;
      }
      function getTypeOfPropertyOfContextualType(type, name) {
        return applyToContextualType(type, function(t) {
          var prop = t.flags & 130048 ? getPropertyOfType(t, name) : undefined;
          return prop ? getTypeOfSymbol(prop) : undefined;
        });
      }
      function getIndexTypeOfContextualType(type, kind) {
        return applyToContextualType(type, function(t) {
          return getIndexTypeOfStructuredType(t, kind);
        });
      }
      function contextualTypeIsTupleLikeType(type) {
        return !!(type.flags & 16384 ? ts.forEach(type.types, isTupleLikeType) : isTupleLikeType(type));
      }
      function contextualTypeHasIndexSignature(type, kind) {
        return !!(type.flags & 16384 ? ts.forEach(type.types, function(t) {
          return getIndexTypeOfStructuredType(t, kind);
        }) : getIndexTypeOfStructuredType(type, kind));
      }
      function getContextualTypeForObjectLiteralMethod(node) {
        ts.Debug.assert(ts.isObjectLiteralMethod(node));
        if (isInsideWithStatementBody(node)) {
          return undefined;
        }
        return getContextualTypeForObjectLiteralElement(node);
      }
      function getContextualTypeForObjectLiteralElement(element) {
        var objectLiteral = element.parent;
        var type = getContextualType(objectLiteral);
        if (type) {
          if (!ts.hasDynamicName(element)) {
            var symbolName = getSymbolOfNode(element).name;
            var propertyType = getTypeOfPropertyOfContextualType(type, symbolName);
            if (propertyType) {
              return propertyType;
            }
          }
          return isNumericName(element.name) && getIndexTypeOfContextualType(type, 1) || getIndexTypeOfContextualType(type, 0);
        }
        return undefined;
      }
      function getContextualTypeForElementExpression(node) {
        var arrayLiteral = node.parent;
        var type = getContextualType(arrayLiteral);
        if (type) {
          var index = ts.indexOf(arrayLiteral.elements, node);
          return getTypeOfPropertyOfContextualType(type, "" + index) || getIndexTypeOfContextualType(type, 1) || (languageVersion >= 2 ? getElementTypeOfIterable(type, undefined) : undefined);
        }
        return undefined;
      }
      function getContextualTypeForConditionalOperand(node) {
        var conditional = node.parent;
        return node === conditional.whenTrue || node === conditional.whenFalse ? getContextualType(conditional) : undefined;
      }
      function getContextualTypeForJsxExpression(expr) {
        if (expr.parent.kind === 236) {
          var attrib = expr.parent;
          var attrsType = getJsxElementAttributesType(attrib.parent);
          if (!attrsType || isTypeAny(attrsType)) {
            return undefined;
          } else {
            return getTypeOfPropertyOfType(attrsType, attrib.name.text);
          }
        }
        if (expr.kind === 237) {
          return getJsxElementAttributesType(expr.parent);
        }
        return undefined;
      }
      function getContextualType(node) {
        var type = getContextualTypeWorker(node);
        return type && getApparentType(type);
      }
      function getContextualTypeWorker(node) {
        if (isInsideWithStatementBody(node)) {
          return undefined;
        }
        if (node.contextualType) {
          return node.contextualType;
        }
        var parent = node.parent;
        switch (parent.kind) {
          case 209:
          case 136:
          case 139:
          case 138:
          case 161:
            return getContextualTypeForInitializerExpression(node);
          case 172:
          case 202:
            return getContextualTypeForReturnExpression(node);
          case 182:
            return getContextualTypeForYieldOperand(parent);
          case 166:
          case 167:
            return getContextualTypeForArgument(parent, node);
          case 169:
          case 187:
            return getTypeFromTypeNode(parent.type);
          case 179:
            return getContextualTypeForBinaryOperand(node);
          case 243:
            return getContextualTypeForObjectLiteralElement(parent);
          case 162:
            return getContextualTypeForElementExpression(node);
          case 180:
            return getContextualTypeForConditionalOperand(node);
          case 188:
            ts.Debug.assert(parent.parent.kind === 181);
            return getContextualTypeForSubstitutionExpression(parent.parent, node);
          case 170:
            return getContextualType(parent);
          case 238:
          case 237:
            return getContextualTypeForJsxExpression(parent);
        }
        return undefined;
      }
      function getNonGenericSignature(type) {
        var signatures = getSignaturesOfStructuredType(type, 0);
        if (signatures.length === 1) {
          var signature = signatures[0];
          if (!signature.typeParameters) {
            return signature;
          }
        }
      }
      function isFunctionExpressionOrArrowFunction(node) {
        return node.kind === 171 || node.kind === 172;
      }
      function getContextualSignatureForFunctionLikeDeclaration(node) {
        return isFunctionExpressionOrArrowFunction(node) || ts.isObjectLiteralMethod(node) ? getContextualSignature(node) : undefined;
      }
      function getContextualSignature(node) {
        ts.Debug.assert(node.kind !== 141 || ts.isObjectLiteralMethod(node));
        var type = ts.isObjectLiteralMethod(node) ? getContextualTypeForObjectLiteralMethod(node) : getContextualType(node);
        if (!type) {
          return undefined;
        }
        if (!(type.flags & 16384)) {
          return getNonGenericSignature(type);
        }
        var signatureList;
        var types = type.types;
        for (var _i = 0; _i < types.length; _i++) {
          var current = types[_i];
          var signature = getNonGenericSignature(current);
          if (signature) {
            if (!signatureList) {
              signatureList = [signature];
            } else if (!compareSignatures(signatureList[0], signature, false, true, compareTypes)) {
              return undefined;
            } else {
              signatureList.push(signature);
            }
          }
        }
        var result;
        if (signatureList) {
          result = cloneSignature(signatureList[0]);
          result.resolvedReturnType = undefined;
          result.unionSignatures = signatureList;
        }
        return result;
      }
      function isInferentialContext(mapper) {
        return mapper && mapper.context;
      }
      function isAssignmentTarget(node) {
        var parent = node.parent;
        if (parent.kind === 179 && parent.operatorToken.kind === 55 && parent.left === node) {
          return true;
        }
        if (parent.kind === 243) {
          return isAssignmentTarget(parent.parent);
        }
        if (parent.kind === 162) {
          return isAssignmentTarget(parent);
        }
        return false;
      }
      function checkSpreadElementExpression(node, contextualMapper) {
        var arrayOrIterableType = checkExpressionCached(node.expression, contextualMapper);
        return checkIteratedTypeOrElementType(arrayOrIterableType, node.expression, false);
      }
      function checkArrayLiteral(node, contextualMapper) {
        var elements = node.elements;
        if (!elements.length) {
          return createArrayType(undefinedType);
        }
        var hasSpreadElement = false;
        var elementTypes = [];
        var inDestructuringPattern = isAssignmentTarget(node);
        for (var _i = 0; _i < elements.length; _i++) {
          var e = elements[_i];
          if (inDestructuringPattern && e.kind === 183) {
            var restArrayType = checkExpression(e.expression, contextualMapper);
            var restElementType = getIndexTypeOfType(restArrayType, 1) || (languageVersion >= 2 ? getElementTypeOfIterable(restArrayType, undefined) : undefined);
            if (restElementType) {
              elementTypes.push(restElementType);
            }
          } else {
            var type = checkExpression(e, contextualMapper);
            elementTypes.push(type);
          }
          hasSpreadElement = hasSpreadElement || e.kind === 183;
        }
        if (!hasSpreadElement) {
          var contextualType = getContextualType(node);
          if (contextualType && contextualTypeIsTupleLikeType(contextualType) || inDestructuringPattern) {
            return createTupleType(elementTypes);
          }
        }
        return createArrayType(getUnionType(elementTypes));
      }
      function isNumericName(name) {
        return name.kind === 134 ? isNumericComputedName(name) : isNumericLiteralName(name.text);
      }
      function isNumericComputedName(name) {
        return isTypeAnyOrAllConstituentTypesHaveKind(checkComputedPropertyName(name), 132);
      }
      function isTypeAnyOrAllConstituentTypesHaveKind(type, kind) {
        return isTypeAny(type) || allConstituentTypesHaveKind(type, kind);
      }
      function isNumericLiteralName(name) {
        return (+name).toString() === name;
      }
      function checkComputedPropertyName(node) {
        var links = getNodeLinks(node.expression);
        if (!links.resolvedType) {
          links.resolvedType = checkExpression(node.expression);
          if (!isTypeAnyOrAllConstituentTypesHaveKind(links.resolvedType, 132 | 258 | 16777216)) {
            error(node, ts.Diagnostics.A_computed_property_name_must_be_of_type_string_number_symbol_or_any);
          } else {
            checkThatExpressionIsProperSymbolReference(node.expression, links.resolvedType, true);
          }
        }
        return links.resolvedType;
      }
      function checkObjectLiteral(node, contextualMapper) {
        checkGrammarObjectLiteralExpression(node);
        var propertiesTable = {};
        var propertiesArray = [];
        var contextualType = getContextualType(node);
        var typeFlags = 0;
        for (var _i = 0,
            _a = node.properties; _i < _a.length; _i++) {
          var memberDecl = _a[_i];
          var member = memberDecl.symbol;
          if (memberDecl.kind === 243 || memberDecl.kind === 244 || ts.isObjectLiteralMethod(memberDecl)) {
            var type = void 0;
            if (memberDecl.kind === 243) {
              type = checkPropertyAssignment(memberDecl, contextualMapper);
            } else if (memberDecl.kind === 141) {
              type = checkObjectLiteralMethod(memberDecl, contextualMapper);
            } else {
              ts.Debug.assert(memberDecl.kind === 244);
              type = checkExpression(memberDecl.name, contextualMapper);
            }
            typeFlags |= type.flags;
            var prop = createSymbol(4 | 67108864 | member.flags, member.name);
            prop.declarations = member.declarations;
            prop.parent = member.parent;
            if (member.valueDeclaration) {
              prop.valueDeclaration = member.valueDeclaration;
            }
            prop.type = type;
            prop.target = member;
            member = prop;
          } else {
            ts.Debug.assert(memberDecl.kind === 143 || memberDecl.kind === 144);
            checkAccessorDeclaration(memberDecl);
          }
          if (!ts.hasDynamicName(memberDecl)) {
            propertiesTable[member.name] = member;
          }
          propertiesArray.push(member);
        }
        var stringIndexType = getIndexType(0);
        var numberIndexType = getIndexType(1);
        var result = createAnonymousType(node.symbol, propertiesTable, emptyArray, emptyArray, stringIndexType, numberIndexType);
        var freshObjectLiteralFlag = compilerOptions.suppressExcessPropertyErrors ? 0 : 1048576;
        result.flags |= 524288 | 4194304 | freshObjectLiteralFlag | (typeFlags & 14680064);
        return result;
        function getIndexType(kind) {
          if (contextualType && contextualTypeHasIndexSignature(contextualType, kind)) {
            var propTypes = [];
            for (var i = 0; i < propertiesArray.length; i++) {
              var propertyDecl = node.properties[i];
              if (kind === 0 || isNumericName(propertyDecl.name)) {
                var type = getTypeOfSymbol(propertiesArray[i]);
                if (!ts.contains(propTypes, type)) {
                  propTypes.push(type);
                }
              }
            }
            var result_1 = propTypes.length ? getUnionType(propTypes) : undefinedType;
            typeFlags |= result_1.flags;
            return result_1;
          }
          return undefined;
        }
      }
      function checkJsxSelfClosingElement(node) {
        checkJsxOpeningLikeElement(node);
        return jsxElementType || anyType;
      }
      function tagNamesAreEquivalent(lhs, rhs) {
        if (lhs.kind !== rhs.kind) {
          return false;
        }
        if (lhs.kind === 67) {
          return lhs.text === rhs.text;
        }
        return lhs.right.text === rhs.right.text && tagNamesAreEquivalent(lhs.left, rhs.left);
      }
      function checkJsxElement(node) {
        checkJsxOpeningLikeElement(node.openingElement);
        if (!tagNamesAreEquivalent(node.openingElement.tagName, node.closingElement.tagName)) {
          error(node.closingElement, ts.Diagnostics.Expected_corresponding_JSX_closing_tag_for_0, ts.getTextOfNode(node.openingElement.tagName));
        } else {
          getJsxElementTagSymbol(node.closingElement);
        }
        for (var _i = 0,
            _a = node.children; _i < _a.length; _i++) {
          var child = _a[_i];
          switch (child.kind) {
            case 238:
              checkJsxExpression(child);
              break;
            case 231:
              checkJsxElement(child);
              break;
            case 232:
              checkJsxSelfClosingElement(child);
              break;
            default:
              ts.Debug.assert(child.kind === 234);
          }
        }
        return jsxElementType || anyType;
      }
      function isUnhyphenatedJsxName(name) {
        return name.indexOf("-") < 0;
      }
      function isJsxIntrinsicIdentifier(tagName) {
        if (tagName.kind === 133) {
          return false;
        } else {
          return ts.isIntrinsicJsxName(tagName.text);
        }
      }
      function checkJsxAttribute(node, elementAttributesType, nameTable) {
        var correspondingPropType = undefined;
        if (elementAttributesType === emptyObjectType && isUnhyphenatedJsxName(node.name.text)) {
          error(node.parent, ts.Diagnostics.JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property, getJsxElementPropertiesName());
        } else if (elementAttributesType && !isTypeAny(elementAttributesType)) {
          var correspondingPropSymbol = getPropertyOfType(elementAttributesType, node.name.text);
          correspondingPropType = correspondingPropSymbol && getTypeOfSymbol(correspondingPropSymbol);
          if (isUnhyphenatedJsxName(node.name.text)) {
            var indexerType = getIndexTypeOfType(elementAttributesType, 0);
            if (indexerType) {
              correspondingPropType = indexerType;
            } else {
              if (!correspondingPropType) {
                error(node.name, ts.Diagnostics.Property_0_does_not_exist_on_type_1, node.name.text, typeToString(elementAttributesType));
                return unknownType;
              }
            }
          }
        }
        var exprType;
        if (node.initializer) {
          exprType = checkExpression(node.initializer);
        } else {
          exprType = booleanType;
        }
        if (correspondingPropType) {
          checkTypeAssignableTo(exprType, correspondingPropType, node);
        }
        nameTable[node.name.text] = true;
        return exprType;
      }
      function checkJsxSpreadAttribute(node, elementAttributesType, nameTable) {
        var type = checkExpression(node.expression);
        var props = getPropertiesOfType(type);
        for (var _i = 0; _i < props.length; _i++) {
          var prop = props[_i];
          if (!nameTable[prop.name]) {
            var targetPropSym = getPropertyOfType(elementAttributesType, prop.name);
            if (targetPropSym) {
              var msg = ts.chainDiagnosticMessages(undefined, ts.Diagnostics.Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property, prop.name);
              checkTypeAssignableTo(getTypeOfSymbol(prop), getTypeOfSymbol(targetPropSym), node, undefined, msg);
            }
            nameTable[prop.name] = true;
          }
        }
        return type;
      }
      function getJsxIntrinsicElementsType() {
        if (!jsxIntrinsicElementsType) {
          jsxIntrinsicElementsType = getExportedTypeFromNamespace(JsxNames.JSX, JsxNames.IntrinsicElements) || unknownType;
        }
        return jsxIntrinsicElementsType;
      }
      function getJsxElementTagSymbol(node) {
        var flags = 8;
        var links = getNodeLinks(node);
        if (!links.resolvedSymbol) {
          if (isJsxIntrinsicIdentifier(node.tagName)) {
            links.resolvedSymbol = lookupIntrinsicTag(node);
          } else {
            links.resolvedSymbol = lookupClassTag(node);
          }
        }
        return links.resolvedSymbol;
        function lookupIntrinsicTag(node) {
          var intrinsicElementsType = getJsxIntrinsicElementsType();
          if (intrinsicElementsType !== unknownType) {
            var intrinsicProp = getPropertyOfType(intrinsicElementsType, node.tagName.text);
            if (intrinsicProp) {
              links.jsxFlags |= 1;
              return intrinsicProp;
            }
            var indexSignatureType = getIndexTypeOfType(intrinsicElementsType, 0);
            if (indexSignatureType) {
              links.jsxFlags |= 2;
              return intrinsicElementsType.symbol;
            }
            error(node, ts.Diagnostics.Property_0_does_not_exist_on_type_1, node.tagName.text, "JSX." + JsxNames.IntrinsicElements);
            return unknownSymbol;
          } else {
            if (compilerOptions.noImplicitAny) {
              error(node, ts.Diagnostics.JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists, JsxNames.IntrinsicElements);
            }
          }
        }
        function lookupClassTag(node) {
          var valueSymbol = resolveJsxTagName(node);
          if (valueSymbol && valueSymbol !== unknownSymbol) {
            links.jsxFlags |= 4;
            getSymbolLinks(valueSymbol).referenced = true;
          }
          return valueSymbol || unknownSymbol;
        }
        function resolveJsxTagName(node) {
          if (node.tagName.kind === 67) {
            var tag = node.tagName;
            var sym = getResolvedSymbol(tag);
            return sym.exportSymbol || sym;
          } else {
            return checkQualifiedName(node.tagName).symbol;
          }
        }
      }
      function getJsxElementInstanceType(node) {
        ts.Debug.assert(!!(getNodeLinks(node).jsxFlags & 4), "Should not call getJsxElementInstanceType on non-class Element");
        var classSymbol = getJsxElementTagSymbol(node);
        if (classSymbol === unknownSymbol) {
          return anyType;
        }
        var valueType = getTypeOfSymbol(classSymbol);
        if (isTypeAny(valueType)) {
          return anyType;
        }
        var signatures = getSignaturesOfType(valueType, 1);
        if (signatures.length === 0) {
          signatures = getSignaturesOfType(valueType, 0);
          if (signatures.length === 0) {
            error(node.tagName, ts.Diagnostics.JSX_element_type_0_does_not_have_any_construct_or_call_signatures, ts.getTextOfNode(node.tagName));
            return unknownType;
          }
        }
        var returnType = getUnionType(signatures.map(getReturnTypeOfSignature));
        var elemClassType = getJsxGlobalElementClassType();
        if (elemClassType) {
          checkTypeRelatedTo(returnType, elemClassType, assignableRelation, node, ts.Diagnostics.JSX_element_type_0_is_not_a_constructor_function_for_JSX_elements);
        }
        return returnType;
      }
      function getJsxElementPropertiesName() {
        var jsxNamespace = getGlobalSymbol(JsxNames.JSX, 1536, undefined);
        var attribsPropTypeSym = jsxNamespace && getSymbol(jsxNamespace.exports, JsxNames.ElementAttributesPropertyNameContainer, 793056);
        var attribPropType = attribsPropTypeSym && getDeclaredTypeOfSymbol(attribsPropTypeSym);
        var attribProperties = attribPropType && getPropertiesOfType(attribPropType);
        if (attribProperties) {
          if (attribProperties.length === 0) {
            return "";
          } else if (attribProperties.length === 1) {
            return attribProperties[0].name;
          } else {
            error(attribsPropTypeSym.declarations[0], ts.Diagnostics.The_global_type_JSX_0_may_not_have_more_than_one_property, JsxNames.ElementAttributesPropertyNameContainer);
            return undefined;
          }
        } else {
          return undefined;
        }
      }
      function getJsxElementAttributesType(node) {
        var links = getNodeLinks(node);
        if (!links.resolvedJsxType) {
          var sym = getJsxElementTagSymbol(node);
          if (links.jsxFlags & 4) {
            var elemInstanceType = getJsxElementInstanceType(node);
            if (isTypeAny(elemInstanceType)) {
              return links.resolvedJsxType = elemInstanceType;
            }
            var propsName = getJsxElementPropertiesName();
            if (propsName === undefined) {
              return links.resolvedJsxType = anyType;
            } else if (propsName === "") {
              return links.resolvedJsxType = elemInstanceType;
            } else {
              var attributesType = getTypeOfPropertyOfType(elemInstanceType, propsName);
              if (!attributesType) {
                return links.resolvedJsxType = emptyObjectType;
              } else if (isTypeAny(attributesType) || (attributesType === unknownType)) {
                return links.resolvedJsxType = attributesType;
              } else if (!(attributesType.flags & 80896)) {
                error(node.tagName, ts.Diagnostics.JSX_element_attributes_type_0_must_be_an_object_type, typeToString(attributesType));
                return links.resolvedJsxType = anyType;
              } else {
                return links.resolvedJsxType = attributesType;
              }
            }
          } else if (links.jsxFlags & 1) {
            return links.resolvedJsxType = getTypeOfSymbol(sym);
          } else if (links.jsxFlags & 2) {
            return links.resolvedJsxType = getIndexTypeOfSymbol(sym, 0);
          } else {
            return links.resolvedJsxType = anyType;
          }
        }
        return links.resolvedJsxType;
      }
      function getJsxAttributePropertySymbol(attrib) {
        var attributesType = getJsxElementAttributesType(attrib.parent);
        var prop = getPropertyOfType(attributesType, attrib.name.text);
        return prop || unknownSymbol;
      }
      var jsxElementClassType = undefined;
      function getJsxGlobalElementClassType() {
        if (!jsxElementClassType) {
          jsxElementClassType = getExportedTypeFromNamespace(JsxNames.JSX, JsxNames.ElementClass);
        }
        return jsxElementClassType;
      }
      function getJsxIntrinsicTagNames() {
        var intrinsics = getJsxIntrinsicElementsType();
        return intrinsics ? getPropertiesOfType(intrinsics) : emptyArray;
      }
      function checkJsxPreconditions(errorNode) {
        if ((compilerOptions.jsx || 0) === 0) {
          error(errorNode, ts.Diagnostics.Cannot_use_JSX_unless_the_jsx_flag_is_provided);
        }
        if (jsxElementType === undefined) {
          if (compilerOptions.noImplicitAny) {
            error(errorNode, ts.Diagnostics.JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist);
          }
        }
      }
      function checkJsxOpeningLikeElement(node) {
        checkGrammarJsxElement(node);
        checkJsxPreconditions(node);
        if (compilerOptions.jsx === 2) {
          var reactSym = resolveName(node.tagName, "React", 107455, ts.Diagnostics.Cannot_find_name_0, "React");
          if (reactSym) {
            getSymbolLinks(reactSym).referenced = true;
          }
        }
        var targetAttributesType = getJsxElementAttributesType(node);
        var nameTable = {};
        var sawSpreadedAny = false;
        for (var i = node.attributes.length - 1; i >= 0; i--) {
          if (node.attributes[i].kind === 236) {
            checkJsxAttribute((node.attributes[i]), targetAttributesType, nameTable);
          } else {
            ts.Debug.assert(node.attributes[i].kind === 237);
            var spreadType = checkJsxSpreadAttribute((node.attributes[i]), targetAttributesType, nameTable);
            if (isTypeAny(spreadType)) {
              sawSpreadedAny = true;
            }
          }
        }
        if (targetAttributesType && !sawSpreadedAny) {
          var targetProperties = getPropertiesOfType(targetAttributesType);
          for (var i = 0; i < targetProperties.length; i++) {
            if (!(targetProperties[i].flags & 536870912) && nameTable[targetProperties[i].name] === undefined) {
              error(node, ts.Diagnostics.Property_0_is_missing_in_type_1, targetProperties[i].name, typeToString(targetAttributesType));
            }
          }
        }
      }
      function checkJsxExpression(node) {
        if (node.expression) {
          return checkExpression(node.expression);
        } else {
          return unknownType;
        }
      }
      function getDeclarationKindFromSymbol(s) {
        return s.valueDeclaration ? s.valueDeclaration.kind : 139;
      }
      function getDeclarationFlagsFromSymbol(s) {
        return s.valueDeclaration ? ts.getCombinedNodeFlags(s.valueDeclaration) : s.flags & 134217728 ? 16 | 128 : 0;
      }
      function checkClassPropertyAccess(node, left, type, prop) {
        var flags = getDeclarationFlagsFromSymbol(prop);
        var declaringClass = getDeclaredTypeOfSymbol(prop.parent);
        if (left.kind === 93) {
          var errorNode = node.kind === 164 ? node.name : node.right;
          if (getDeclarationKindFromSymbol(prop) !== 141) {
            error(errorNode, ts.Diagnostics.Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword);
            return false;
          }
          if (flags & 256) {
            error(errorNode, ts.Diagnostics.Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression, symbolToString(prop), typeToString(declaringClass));
            return false;
          }
        }
        if (!(flags & (32 | 64))) {
          return true;
        }
        var enclosingClassDeclaration = ts.getContainingClass(node);
        var enclosingClass = enclosingClassDeclaration ? getDeclaredTypeOfSymbol(getSymbolOfNode(enclosingClassDeclaration)) : undefined;
        if (flags & 32) {
          if (declaringClass !== enclosingClass) {
            error(node, ts.Diagnostics.Property_0_is_private_and_only_accessible_within_class_1, symbolToString(prop), typeToString(declaringClass));
            return false;
          }
          return true;
        }
        if (left.kind === 93) {
          return true;
        }
        if (!enclosingClass || !hasBaseType(enclosingClass, declaringClass)) {
          error(node, ts.Diagnostics.Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses, symbolToString(prop), typeToString(declaringClass));
          return false;
        }
        if (flags & 128) {
          return true;
        }
        if (!(getTargetType(type).flags & (1024 | 2048) && hasBaseType(type, enclosingClass))) {
          error(node, ts.Diagnostics.Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1, symbolToString(prop), typeToString(enclosingClass));
          return false;
        }
        return true;
      }
      function checkPropertyAccessExpression(node) {
        return checkPropertyAccessExpressionOrQualifiedName(node, node.expression, node.name);
      }
      function checkQualifiedName(node) {
        return checkPropertyAccessExpressionOrQualifiedName(node, node.left, node.right);
      }
      function checkPropertyAccessExpressionOrQualifiedName(node, left, right) {
        var type = checkExpression(left);
        if (isTypeAny(type)) {
          return type;
        }
        var apparentType = getApparentType(getWidenedType(type));
        if (apparentType === unknownType) {
          return unknownType;
        }
        var prop = getPropertyOfType(apparentType, right.text);
        if (!prop) {
          if (right.text) {
            error(right, ts.Diagnostics.Property_0_does_not_exist_on_type_1, ts.declarationNameToString(right), typeToString(type));
          }
          return unknownType;
        }
        getNodeLinks(node).resolvedSymbol = prop;
        if (prop.parent && prop.parent.flags & 32) {
          checkClassPropertyAccess(node, left, type, prop);
        }
        return getTypeOfSymbol(prop);
      }
      function isValidPropertyAccess(node, propertyName) {
        var left = node.kind === 164 ? node.expression : node.left;
        var type = checkExpression(left);
        if (type !== unknownType && !isTypeAny(type)) {
          var prop = getPropertyOfType(getWidenedType(type), propertyName);
          if (prop && prop.parent && prop.parent.flags & 32) {
            return checkClassPropertyAccess(node, left, type, prop);
          }
        }
        return true;
      }
      function checkIndexedAccess(node) {
        if (!node.argumentExpression) {
          var sourceFile = getSourceFile(node);
          if (node.parent.kind === 167 && node.parent.expression === node) {
            var start = ts.skipTrivia(sourceFile.text, node.expression.end);
            var end = node.end;
            grammarErrorAtPos(sourceFile, start, end - start, ts.Diagnostics.new_T_cannot_be_used_to_create_an_array_Use_new_Array_T_instead);
          } else {
            var start = node.end - "]".length;
            var end = node.end;
            grammarErrorAtPos(sourceFile, start, end - start, ts.Diagnostics.Expression_expected);
          }
        }
        var objectType = getApparentType(checkExpression(node.expression));
        var indexType = node.argumentExpression ? checkExpression(node.argumentExpression) : unknownType;
        if (objectType === unknownType) {
          return unknownType;
        }
        var isConstEnum = isConstEnumObjectType(objectType);
        if (isConstEnum && (!node.argumentExpression || node.argumentExpression.kind !== 9)) {
          error(node.argumentExpression, ts.Diagnostics.A_const_enum_member_can_only_be_accessed_using_a_string_literal);
          return unknownType;
        }
        if (node.argumentExpression) {
          var name_11 = getPropertyNameForIndexedAccess(node.argumentExpression, indexType);
          if (name_11 !== undefined) {
            var prop = getPropertyOfType(objectType, name_11);
            if (prop) {
              getNodeLinks(node).resolvedSymbol = prop;
              return getTypeOfSymbol(prop);
            } else if (isConstEnum) {
              error(node.argumentExpression, ts.Diagnostics.Property_0_does_not_exist_on_const_enum_1, name_11, symbolToString(objectType.symbol));
              return unknownType;
            }
          }
        }
        if (isTypeAnyOrAllConstituentTypesHaveKind(indexType, 258 | 132 | 16777216)) {
          if (isTypeAnyOrAllConstituentTypesHaveKind(indexType, 132)) {
            var numberIndexType = getIndexTypeOfType(objectType, 1);
            if (numberIndexType) {
              return numberIndexType;
            }
          }
          var stringIndexType = getIndexTypeOfType(objectType, 0);
          if (stringIndexType) {
            return stringIndexType;
          }
          if (compilerOptions.noImplicitAny && !compilerOptions.suppressImplicitAnyIndexErrors && !isTypeAny(objectType)) {
            error(node, ts.Diagnostics.Index_signature_of_object_type_implicitly_has_an_any_type);
          }
          return anyType;
        }
        error(node, ts.Diagnostics.An_index_expression_argument_must_be_of_type_string_number_symbol_or_any);
        return unknownType;
      }
      function getPropertyNameForIndexedAccess(indexArgumentExpression, indexArgumentType) {
        if (indexArgumentExpression.kind === 9 || indexArgumentExpression.kind === 8) {
          return indexArgumentExpression.text;
        }
        if (checkThatExpressionIsProperSymbolReference(indexArgumentExpression, indexArgumentType, false)) {
          var rightHandSideName = indexArgumentExpression.name.text;
          return ts.getPropertyNameForKnownSymbolName(rightHandSideName);
        }
        return undefined;
      }
      function checkThatExpressionIsProperSymbolReference(expression, expressionType, reportError) {
        if (expressionType === unknownType) {
          return false;
        }
        if (!ts.isWellKnownSymbolSyntactically(expression)) {
          return false;
        }
        if ((expressionType.flags & 16777216) === 0) {
          if (reportError) {
            error(expression, ts.Diagnostics.A_computed_property_name_of_the_form_0_must_be_of_type_symbol, ts.getTextOfNode(expression));
          }
          return false;
        }
        var leftHandSide = expression.expression;
        var leftHandSideSymbol = getResolvedSymbol(leftHandSide);
        if (!leftHandSideSymbol) {
          return false;
        }
        var globalESSymbol = getGlobalESSymbolConstructorSymbol();
        if (!globalESSymbol) {
          return false;
        }
        if (leftHandSideSymbol !== globalESSymbol) {
          if (reportError) {
            error(leftHandSide, ts.Diagnostics.Symbol_reference_does_not_refer_to_the_global_Symbol_constructor_object);
          }
          return false;
        }
        return true;
      }
      function resolveUntypedCall(node) {
        if (node.kind === 168) {
          checkExpression(node.template);
        } else if (node.kind !== 137) {
          ts.forEach(node.arguments, function(argument) {
            checkExpression(argument);
          });
        }
        return anySignature;
      }
      function resolveErrorCall(node) {
        resolveUntypedCall(node);
        return unknownSignature;
      }
      function reorderCandidates(signatures, result) {
        var lastParent;
        var lastSymbol;
        var cutoffIndex = 0;
        var index;
        var specializedIndex = -1;
        var spliceIndex;
        ts.Debug.assert(!result.length);
        for (var _i = 0; _i < signatures.length; _i++) {
          var signature = signatures[_i];
          var symbol = signature.declaration && getSymbolOfNode(signature.declaration);
          var parent_5 = signature.declaration && signature.declaration.parent;
          if (!lastSymbol || symbol === lastSymbol) {
            if (lastParent && parent_5 === lastParent) {
              index++;
            } else {
              lastParent = parent_5;
              index = cutoffIndex;
            }
          } else {
            index = cutoffIndex = result.length;
            lastParent = parent_5;
          }
          lastSymbol = symbol;
          if (signature.hasStringLiterals) {
            specializedIndex++;
            spliceIndex = specializedIndex;
            cutoffIndex++;
          } else {
            spliceIndex = index;
          }
          result.splice(spliceIndex, 0, signature);
        }
      }
      function getSpreadArgumentIndex(args) {
        for (var i = 0; i < args.length; i++) {
          var arg = args[i];
          if (arg && arg.kind === 183) {
            return i;
          }
        }
        return -1;
      }
      function hasCorrectArity(node, args, signature) {
        var adjustedArgCount;
        var typeArguments;
        var callIsIncomplete;
        var isDecorator;
        var spreadArgIndex = -1;
        if (node.kind === 168) {
          var tagExpression = node;
          adjustedArgCount = args.length;
          typeArguments = undefined;
          if (tagExpression.template.kind === 181) {
            var templateExpression = tagExpression.template;
            var lastSpan = ts.lastOrUndefined(templateExpression.templateSpans);
            ts.Debug.assert(lastSpan !== undefined);
            callIsIncomplete = ts.nodeIsMissing(lastSpan.literal) || !!lastSpan.literal.isUnterminated;
          } else {
            var templateLiteral = tagExpression.template;
            ts.Debug.assert(templateLiteral.kind === 11);
            callIsIncomplete = !!templateLiteral.isUnterminated;
          }
        } else if (node.kind === 137) {
          isDecorator = true;
          typeArguments = undefined;
          adjustedArgCount = getEffectiveArgumentCount(node, undefined, signature);
        } else {
          var callExpression = node;
          if (!callExpression.arguments) {
            ts.Debug.assert(callExpression.kind === 167);
            return signature.minArgumentCount === 0;
          }
          adjustedArgCount = callExpression.arguments.hasTrailingComma ? args.length + 1 : args.length;
          callIsIncomplete = callExpression.arguments.end === callExpression.end;
          typeArguments = callExpression.typeArguments;
          spreadArgIndex = getSpreadArgumentIndex(args);
        }
        var hasRightNumberOfTypeArgs = !typeArguments || (signature.typeParameters && typeArguments.length === signature.typeParameters.length);
        if (!hasRightNumberOfTypeArgs) {
          return false;
        }
        if (spreadArgIndex >= 0) {
          return signature.hasRestParameter && spreadArgIndex >= signature.parameters.length - 1;
        }
        if (!signature.hasRestParameter && adjustedArgCount > signature.parameters.length) {
          return false;
        }
        var hasEnoughArguments = adjustedArgCount >= signature.minArgumentCount;
        return callIsIncomplete || hasEnoughArguments;
      }
      function getSingleCallSignature(type) {
        if (type.flags & 80896) {
          var resolved = resolveStructuredTypeMembers(type);
          if (resolved.callSignatures.length === 1 && resolved.constructSignatures.length === 0 && resolved.properties.length === 0 && !resolved.stringIndexType && !resolved.numberIndexType) {
            return resolved.callSignatures[0];
          }
        }
        return undefined;
      }
      function instantiateSignatureInContextOf(signature, contextualSignature, contextualMapper) {
        var context = createInferenceContext(signature.typeParameters, true);
        forEachMatchingParameterType(contextualSignature, signature, function(source, target) {
          inferTypes(context, instantiateType(source, contextualMapper), target);
        });
        return getSignatureInstantiation(signature, getInferredTypes(context));
      }
      function inferTypeArguments(node, signature, args, excludeArgument, context) {
        var typeParameters = signature.typeParameters;
        var inferenceMapper = createInferenceMapper(context);
        for (var i = 0; i < typeParameters.length; i++) {
          if (!context.inferences[i].isFixed) {
            context.inferredTypes[i] = undefined;
          }
        }
        if (context.failedTypeParameterIndex !== undefined && !context.inferences[context.failedTypeParameterIndex].isFixed) {
          context.failedTypeParameterIndex = undefined;
        }
        var argCount = getEffectiveArgumentCount(node, args, signature);
        for (var i = 0; i < argCount; i++) {
          var arg = getEffectiveArgument(node, args, i);
          if (arg === undefined || arg.kind !== 185) {
            var paramType = getTypeAtPosition(signature, i);
            var argType = getEffectiveArgumentType(node, i, arg);
            if (argType === undefined) {
              var mapper = excludeArgument && excludeArgument[i] !== undefined ? identityMapper : inferenceMapper;
              argType = checkExpressionWithContextualType(arg, paramType, mapper);
            }
            inferTypes(context, argType, paramType);
          }
        }
        if (excludeArgument) {
          for (var i = 0; i < argCount; i++) {
            if (excludeArgument[i] === false) {
              var arg = args[i];
              var paramType = getTypeAtPosition(signature, i);
              inferTypes(context, checkExpressionWithContextualType(arg, paramType, inferenceMapper), paramType);
            }
          }
        }
        getInferredTypes(context);
      }
      function checkTypeArguments(signature, typeArguments, typeArgumentResultTypes, reportErrors, headMessage) {
        var typeParameters = signature.typeParameters;
        var typeArgumentsAreAssignable = true;
        for (var i = 0; i < typeParameters.length; i++) {
          var typeArgNode = typeArguments[i];
          var typeArgument = getTypeFromTypeNode(typeArgNode);
          typeArgumentResultTypes[i] = typeArgument;
          if (typeArgumentsAreAssignable) {
            var constraint = getConstraintOfTypeParameter(typeParameters[i]);
            if (constraint) {
              var errorInfo = void 0;
              var typeArgumentHeadMessage = ts.Diagnostics.Type_0_does_not_satisfy_the_constraint_1;
              if (reportErrors && headMessage) {
                errorInfo = ts.chainDiagnosticMessages(errorInfo, typeArgumentHeadMessage);
                typeArgumentHeadMessage = headMessage;
              }
              typeArgumentsAreAssignable = checkTypeAssignableTo(typeArgument, constraint, reportErrors ? typeArgNode : undefined, typeArgumentHeadMessage, errorInfo);
            }
          }
        }
        return typeArgumentsAreAssignable;
      }
      function checkApplicableSignature(node, args, signature, relation, excludeArgument, reportErrors) {
        var argCount = getEffectiveArgumentCount(node, args, signature);
        for (var i = 0; i < argCount; i++) {
          var arg = getEffectiveArgument(node, args, i);
          if (arg === undefined || arg.kind !== 185) {
            var paramType = getTypeAtPosition(signature, i);
            var argType = getEffectiveArgumentType(node, i, arg);
            if (argType === undefined) {
              argType = arg.kind === 9 && !reportErrors ? getStringLiteralType(arg) : checkExpressionWithContextualType(arg, paramType, excludeArgument && excludeArgument[i] ? identityMapper : undefined);
            }
            var errorNode = reportErrors ? getEffectiveArgumentErrorNode(node, i, arg) : undefined;
            var headMessage = ts.Diagnostics.Argument_of_type_0_is_not_assignable_to_parameter_of_type_1;
            if (!checkTypeRelatedTo(argType, paramType, relation, errorNode, headMessage)) {
              return false;
            }
          }
        }
        return true;
      }
      function getEffectiveCallArguments(node) {
        var args;
        if (node.kind === 168) {
          var template = node.template;
          args = [undefined];
          if (template.kind === 181) {
            ts.forEach(template.templateSpans, function(span) {
              args.push(span.expression);
            });
          }
        } else if (node.kind === 137) {
          return undefined;
        } else {
          args = node.arguments || emptyArray;
        }
        return args;
      }
      function getEffectiveArgumentCount(node, args, signature) {
        if (node.kind === 137) {
          switch (node.parent.kind) {
            case 212:
            case 184:
              return 1;
            case 139:
              return 2;
            case 141:
            case 143:
            case 144:
              return signature.parameters.length >= 3 ? 3 : 2;
            case 136:
              return 3;
          }
        } else {
          return args.length;
        }
      }
      function getEffectiveDecoratorFirstArgumentType(node) {
        switch (node.kind) {
          case 212:
          case 184:
            var classSymbol = getSymbolOfNode(node);
            return getTypeOfSymbol(classSymbol);
          case 136:
            node = node.parent;
            if (node.kind === 142) {
              var classSymbol_1 = getSymbolOfNode(node);
              return getTypeOfSymbol(classSymbol_1);
            }
          case 139:
          case 141:
          case 143:
          case 144:
            return getParentTypeOfClassElement(node);
          default:
            ts.Debug.fail("Unsupported decorator target.");
            return unknownType;
        }
      }
      function getEffectiveDecoratorSecondArgumentType(node) {
        switch (node.kind) {
          case 212:
            ts.Debug.fail("Class decorators should not have a second synthetic argument.");
            return unknownType;
          case 136:
            node = node.parent;
            if (node.kind === 142) {
              return anyType;
            }
          case 139:
          case 141:
          case 143:
          case 144:
            var element = node;
            switch (element.name.kind) {
              case 67:
              case 8:
              case 9:
                return getStringLiteralType(element.name);
              case 134:
                var nameType = checkComputedPropertyName(element.name);
                if (allConstituentTypesHaveKind(nameType, 16777216)) {
                  return nameType;
                } else {
                  return stringType;
                }
              default:
                ts.Debug.fail("Unsupported property name.");
                return unknownType;
            }
          default:
            ts.Debug.fail("Unsupported decorator target.");
            return unknownType;
        }
      }
      function getEffectiveDecoratorThirdArgumentType(node) {
        switch (node.kind) {
          case 212:
            ts.Debug.fail("Class decorators should not have a third synthetic argument.");
            return unknownType;
          case 136:
            return numberType;
          case 139:
            ts.Debug.fail("Property decorators should not have a third synthetic argument.");
            return unknownType;
          case 141:
          case 143:
          case 144:
            var propertyType = getTypeOfNode(node);
            return createTypedPropertyDescriptorType(propertyType);
          default:
            ts.Debug.fail("Unsupported decorator target.");
            return unknownType;
        }
      }
      function getEffectiveDecoratorArgumentType(node, argIndex) {
        if (argIndex === 0) {
          return getEffectiveDecoratorFirstArgumentType(node.parent);
        } else if (argIndex === 1) {
          return getEffectiveDecoratorSecondArgumentType(node.parent);
        } else if (argIndex === 2) {
          return getEffectiveDecoratorThirdArgumentType(node.parent);
        }
        ts.Debug.fail("Decorators should not have a fourth synthetic argument.");
        return unknownType;
      }
      function getEffectiveArgumentType(node, argIndex, arg) {
        if (node.kind === 137) {
          return getEffectiveDecoratorArgumentType(node, argIndex);
        } else if (argIndex === 0 && node.kind === 168) {
          return globalTemplateStringsArrayType;
        }
        return undefined;
      }
      function getEffectiveArgument(node, args, argIndex) {
        if (node.kind === 137 || (argIndex === 0 && node.kind === 168)) {
          return undefined;
        }
        return args[argIndex];
      }
      function getEffectiveArgumentErrorNode(node, argIndex, arg) {
        if (node.kind === 137) {
          return node.expression;
        } else if (argIndex === 0 && node.kind === 168) {
          return node.template;
        } else {
          return arg;
        }
      }
      function resolveCall(node, signatures, candidatesOutArray, headMessage) {
        var isTaggedTemplate = node.kind === 168;
        var isDecorator = node.kind === 137;
        var typeArguments;
        if (!isTaggedTemplate && !isDecorator) {
          typeArguments = node.typeArguments;
          if (node.expression.kind !== 93) {
            ts.forEach(typeArguments, checkSourceElement);
          }
        }
        var candidates = candidatesOutArray || [];
        reorderCandidates(signatures, candidates);
        if (!candidates.length) {
          reportError(ts.Diagnostics.Supplied_parameters_do_not_match_any_signature_of_call_target);
          return resolveErrorCall(node);
        }
        var args = getEffectiveCallArguments(node);
        var excludeArgument;
        if (!isDecorator) {
          for (var i = isTaggedTemplate ? 1 : 0; i < args.length; i++) {
            if (isContextSensitive(args[i])) {
              if (!excludeArgument) {
                excludeArgument = new Array(args.length);
              }
              excludeArgument[i] = true;
            }
          }
        }
        var candidateForArgumentError;
        var candidateForTypeArgumentError;
        var resultOfFailedInference;
        var result;
        if (candidates.length > 1) {
          result = chooseOverload(candidates, subtypeRelation);
        }
        if (!result) {
          candidateForArgumentError = undefined;
          candidateForTypeArgumentError = undefined;
          resultOfFailedInference = undefined;
          result = chooseOverload(candidates, assignableRelation);
        }
        if (result) {
          return result;
        }
        if (candidateForArgumentError) {
          checkApplicableSignature(node, args, candidateForArgumentError, assignableRelation, undefined, true);
        } else if (candidateForTypeArgumentError) {
          if (!isTaggedTemplate && !isDecorator && typeArguments) {
            checkTypeArguments(candidateForTypeArgumentError, node.typeArguments, [], true, headMessage);
          } else {
            ts.Debug.assert(resultOfFailedInference.failedTypeParameterIndex >= 0);
            var failedTypeParameter = candidateForTypeArgumentError.typeParameters[resultOfFailedInference.failedTypeParameterIndex];
            var inferenceCandidates = getInferenceCandidates(resultOfFailedInference, resultOfFailedInference.failedTypeParameterIndex);
            var diagnosticChainHead = ts.chainDiagnosticMessages(undefined, ts.Diagnostics.The_type_argument_for_type_parameter_0_cannot_be_inferred_from_the_usage_Consider_specifying_the_type_arguments_explicitly, typeToString(failedTypeParameter));
            if (headMessage) {
              diagnosticChainHead = ts.chainDiagnosticMessages(diagnosticChainHead, headMessage);
            }
            reportNoCommonSupertypeError(inferenceCandidates, node.expression || node.tag, diagnosticChainHead);
          }
        } else {
          reportError(ts.Diagnostics.Supplied_parameters_do_not_match_any_signature_of_call_target);
        }
        if (!produceDiagnostics) {
          for (var _i = 0; _i < candidates.length; _i++) {
            var candidate = candidates[_i];
            if (hasCorrectArity(node, args, candidate)) {
              if (candidate.typeParameters && typeArguments) {
                candidate = getSignatureInstantiation(candidate, ts.map(typeArguments, getTypeFromTypeNode));
              }
              return candidate;
            }
          }
        }
        return resolveErrorCall(node);
        function reportError(message, arg0, arg1, arg2) {
          var errorInfo;
          errorInfo = ts.chainDiagnosticMessages(errorInfo, message, arg0, arg1, arg2);
          if (headMessage) {
            errorInfo = ts.chainDiagnosticMessages(errorInfo, headMessage);
          }
          diagnostics.add(ts.createDiagnosticForNodeFromMessageChain(node, errorInfo));
        }
        function chooseOverload(candidates, relation) {
          for (var _i = 0; _i < candidates.length; _i++) {
            var originalCandidate = candidates[_i];
            if (!hasCorrectArity(node, args, originalCandidate)) {
              continue;
            }
            var candidate = void 0;
            var typeArgumentsAreValid = void 0;
            var inferenceContext = originalCandidate.typeParameters ? createInferenceContext(originalCandidate.typeParameters, false) : undefined;
            while (true) {
              candidate = originalCandidate;
              if (candidate.typeParameters) {
                var typeArgumentTypes = void 0;
                if (typeArguments) {
                  typeArgumentTypes = new Array(candidate.typeParameters.length);
                  typeArgumentsAreValid = checkTypeArguments(candidate, typeArguments, typeArgumentTypes, false);
                } else {
                  inferTypeArguments(node, candidate, args, excludeArgument, inferenceContext);
                  typeArgumentsAreValid = inferenceContext.failedTypeParameterIndex === undefined;
                  typeArgumentTypes = inferenceContext.inferredTypes;
                }
                if (!typeArgumentsAreValid) {
                  break;
                }
                candidate = getSignatureInstantiation(candidate, typeArgumentTypes);
              }
              if (!checkApplicableSignature(node, args, candidate, relation, excludeArgument, false)) {
                break;
              }
              var index = excludeArgument ? ts.indexOf(excludeArgument, true) : -1;
              if (index < 0) {
                return candidate;
              }
              excludeArgument[index] = false;
            }
            if (originalCandidate.typeParameters) {
              var instantiatedCandidate = candidate;
              if (typeArgumentsAreValid) {
                candidateForArgumentError = instantiatedCandidate;
              } else {
                candidateForTypeArgumentError = originalCandidate;
                if (!typeArguments) {
                  resultOfFailedInference = inferenceContext;
                }
              }
            } else {
              ts.Debug.assert(originalCandidate === candidate);
              candidateForArgumentError = originalCandidate;
            }
          }
          return undefined;
        }
      }
      function resolveCallExpression(node, candidatesOutArray) {
        if (node.expression.kind === 93) {
          var superType = checkSuperExpression(node.expression);
          if (superType !== unknownType) {
            var baseTypeNode = ts.getClassExtendsHeritageClauseElement(ts.getContainingClass(node));
            var baseConstructors = getInstantiatedConstructorsForTypeArguments(superType, baseTypeNode.typeArguments);
            return resolveCall(node, baseConstructors, candidatesOutArray);
          }
          return resolveUntypedCall(node);
        }
        var funcType = checkExpression(node.expression);
        var apparentType = getApparentType(funcType);
        if (apparentType === unknownType) {
          return resolveErrorCall(node);
        }
        var callSignatures = getSignaturesOfType(apparentType, 0);
        var constructSignatures = getSignaturesOfType(apparentType, 1);
        if (isTypeAny(funcType) || (!callSignatures.length && !constructSignatures.length && !(funcType.flags & 16384) && isTypeAssignableTo(funcType, globalFunctionType))) {
          if (funcType !== unknownType && node.typeArguments) {
            error(node, ts.Diagnostics.Untyped_function_calls_may_not_accept_type_arguments);
          }
          return resolveUntypedCall(node);
        }
        if (!callSignatures.length) {
          if (constructSignatures.length) {
            error(node, ts.Diagnostics.Value_of_type_0_is_not_callable_Did_you_mean_to_include_new, typeToString(funcType));
          } else {
            error(node, ts.Diagnostics.Cannot_invoke_an_expression_whose_type_lacks_a_call_signature);
          }
          return resolveErrorCall(node);
        }
        return resolveCall(node, callSignatures, candidatesOutArray);
      }
      function resolveNewExpression(node, candidatesOutArray) {
        if (node.arguments && languageVersion < 1) {
          var spreadIndex = getSpreadArgumentIndex(node.arguments);
          if (spreadIndex >= 0) {
            error(node.arguments[spreadIndex], ts.Diagnostics.Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher);
          }
        }
        var expressionType = checkExpression(node.expression);
        expressionType = getApparentType(expressionType);
        if (expressionType === unknownType) {
          return resolveErrorCall(node);
        }
        var valueDecl = expressionType.symbol && ts.getDeclarationOfKind(expressionType.symbol, 212);
        if (valueDecl && valueDecl.flags & 256) {
          error(node, ts.Diagnostics.Cannot_create_an_instance_of_the_abstract_class_0, ts.declarationNameToString(valueDecl.name));
          return resolveErrorCall(node);
        }
        if (isTypeAny(expressionType)) {
          if (node.typeArguments) {
            error(node, ts.Diagnostics.Untyped_function_calls_may_not_accept_type_arguments);
          }
          return resolveUntypedCall(node);
        }
        var constructSignatures = getSignaturesOfType(expressionType, 1);
        if (constructSignatures.length) {
          return resolveCall(node, constructSignatures, candidatesOutArray);
        }
        var callSignatures = getSignaturesOfType(expressionType, 0);
        if (callSignatures.length) {
          var signature = resolveCall(node, callSignatures, candidatesOutArray);
          if (getReturnTypeOfSignature(signature) !== voidType) {
            error(node, ts.Diagnostics.Only_a_void_function_can_be_called_with_the_new_keyword);
          }
          return signature;
        }
        error(node, ts.Diagnostics.Cannot_use_new_with_an_expression_whose_type_lacks_a_call_or_construct_signature);
        return resolveErrorCall(node);
      }
      function resolveTaggedTemplateExpression(node, candidatesOutArray) {
        var tagType = checkExpression(node.tag);
        var apparentType = getApparentType(tagType);
        if (apparentType === unknownType) {
          return resolveErrorCall(node);
        }
        var callSignatures = getSignaturesOfType(apparentType, 0);
        if (isTypeAny(tagType) || (!callSignatures.length && !(tagType.flags & 16384) && isTypeAssignableTo(tagType, globalFunctionType))) {
          return resolveUntypedCall(node);
        }
        if (!callSignatures.length) {
          error(node, ts.Diagnostics.Cannot_invoke_an_expression_whose_type_lacks_a_call_signature);
          return resolveErrorCall(node);
        }
        return resolveCall(node, callSignatures, candidatesOutArray);
      }
      function getDiagnosticHeadMessageForDecoratorResolution(node) {
        switch (node.parent.kind) {
          case 212:
          case 184:
            return ts.Diagnostics.Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression;
          case 136:
            return ts.Diagnostics.Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression;
          case 139:
            return ts.Diagnostics.Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression;
          case 141:
          case 143:
          case 144:
            return ts.Diagnostics.Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression;
        }
      }
      function resolveDecorator(node, candidatesOutArray) {
        var funcType = checkExpression(node.expression);
        var apparentType = getApparentType(funcType);
        if (apparentType === unknownType) {
          return resolveErrorCall(node);
        }
        var callSignatures = getSignaturesOfType(apparentType, 0);
        if (funcType === anyType || (!callSignatures.length && !(funcType.flags & 16384) && isTypeAssignableTo(funcType, globalFunctionType))) {
          return resolveUntypedCall(node);
        }
        var headMessage = getDiagnosticHeadMessageForDecoratorResolution(node);
        if (!callSignatures.length) {
          var errorInfo;
          errorInfo = ts.chainDiagnosticMessages(errorInfo, ts.Diagnostics.Cannot_invoke_an_expression_whose_type_lacks_a_call_signature);
          errorInfo = ts.chainDiagnosticMessages(errorInfo, headMessage);
          diagnostics.add(ts.createDiagnosticForNodeFromMessageChain(node, errorInfo));
          return resolveErrorCall(node);
        }
        return resolveCall(node, callSignatures, candidatesOutArray, headMessage);
      }
      function getResolvedSignature(node, candidatesOutArray) {
        var links = getNodeLinks(node);
        if (!links.resolvedSignature || candidatesOutArray) {
          links.resolvedSignature = anySignature;
          if (node.kind === 166) {
            links.resolvedSignature = resolveCallExpression(node, candidatesOutArray);
          } else if (node.kind === 167) {
            links.resolvedSignature = resolveNewExpression(node, candidatesOutArray);
          } else if (node.kind === 168) {
            links.resolvedSignature = resolveTaggedTemplateExpression(node, candidatesOutArray);
          } else if (node.kind === 137) {
            links.resolvedSignature = resolveDecorator(node, candidatesOutArray);
          } else {
            ts.Debug.fail("Branch in 'getResolvedSignature' should be unreachable.");
          }
        }
        return links.resolvedSignature;
      }
      function checkCallExpression(node) {
        checkGrammarTypeArguments(node, node.typeArguments) || checkGrammarArguments(node, node.arguments);
        var signature = getResolvedSignature(node);
        if (node.expression.kind === 93) {
          return voidType;
        }
        if (node.kind === 167) {
          var declaration = signature.declaration;
          if (declaration && declaration.kind !== 142 && declaration.kind !== 146 && declaration.kind !== 151) {
            if (compilerOptions.noImplicitAny) {
              error(node, ts.Diagnostics.new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type);
            }
            return anyType;
          }
        }
        return getReturnTypeOfSignature(signature);
      }
      function checkTaggedTemplateExpression(node) {
        return getReturnTypeOfSignature(getResolvedSignature(node));
      }
      function checkAssertion(node) {
        var exprType = getRegularTypeOfObjectLiteral(checkExpression(node.expression));
        var targetType = getTypeFromTypeNode(node.type);
        if (produceDiagnostics && targetType !== unknownType) {
          var widenedType = getWidenedType(exprType);
          if (!(isTypeAssignableTo(targetType, widenedType))) {
            checkTypeAssignableTo(exprType, targetType, node, ts.Diagnostics.Neither_type_0_nor_type_1_is_assignable_to_the_other);
          }
        }
        return targetType;
      }
      function getTypeAtPosition(signature, pos) {
        return signature.hasRestParameter ? pos < signature.parameters.length - 1 ? getTypeOfSymbol(signature.parameters[pos]) : getRestTypeOfSignature(signature) : pos < signature.parameters.length ? getTypeOfSymbol(signature.parameters[pos]) : anyType;
      }
      function assignContextualParameterTypes(signature, context, mapper) {
        var len = signature.parameters.length - (signature.hasRestParameter ? 1 : 0);
        for (var i = 0; i < len; i++) {
          var parameter = signature.parameters[i];
          var contextualParameterType = getTypeAtPosition(context, i);
          assignTypeToParameterAndFixTypeParameters(parameter, contextualParameterType, mapper);
        }
        if (signature.hasRestParameter && context.hasRestParameter && signature.parameters.length >= context.parameters.length) {
          var parameter = ts.lastOrUndefined(signature.parameters);
          var contextualParameterType = getTypeOfSymbol(ts.lastOrUndefined(context.parameters));
          assignTypeToParameterAndFixTypeParameters(parameter, contextualParameterType, mapper);
        }
      }
      function assignTypeToParameterAndFixTypeParameters(parameter, contextualType, mapper) {
        var links = getSymbolLinks(parameter);
        if (!links.type) {
          links.type = instantiateType(contextualType, mapper);
        } else if (isInferentialContext(mapper)) {
          inferTypes(mapper.context, links.type, instantiateType(contextualType, mapper));
        }
      }
      function createPromiseType(promisedType) {
        var globalPromiseType = getGlobalPromiseType();
        if (globalPromiseType !== emptyGenericType) {
          promisedType = getAwaitedType(promisedType);
          return createTypeReference(globalPromiseType, [promisedType]);
        }
        return emptyObjectType;
      }
      function getReturnTypeFromBody(func, contextualMapper) {
        var contextualSignature = getContextualSignatureForFunctionLikeDeclaration(func);
        if (!func.body) {
          return unknownType;
        }
        var isAsync = ts.isAsyncFunctionLike(func);
        var type;
        if (func.body.kind !== 190) {
          type = checkExpressionCached(func.body, contextualMapper);
          if (isAsync) {
            type = checkAwaitedType(type, func, ts.Diagnostics.Return_expression_in_async_function_does_not_have_a_valid_callable_then_member);
          }
        } else {
          var types;
          var funcIsGenerator = !!func.asteriskToken;
          if (funcIsGenerator) {
            types = checkAndAggregateYieldOperandTypes(func.body, contextualMapper);
            if (types.length === 0) {
              var iterableIteratorAny = createIterableIteratorType(anyType);
              if (compilerOptions.noImplicitAny) {
                error(func.asteriskToken, ts.Diagnostics.Generator_implicitly_has_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_return_type, typeToString(iterableIteratorAny));
              }
              return iterableIteratorAny;
            }
          } else {
            types = checkAndAggregateReturnExpressionTypes(func.body, contextualMapper, isAsync);
            if (types.length === 0) {
              if (isAsync) {
                var promiseType = createPromiseType(voidType);
                if (promiseType === emptyObjectType) {
                  error(func, ts.Diagnostics.An_async_function_or_method_must_have_a_valid_awaitable_return_type);
                  return unknownType;
                }
                return promiseType;
              } else {
                return voidType;
              }
            }
          }
          type = contextualSignature ? getUnionType(types) : getCommonSupertype(types);
          if (!type) {
            if (funcIsGenerator) {
              error(func, ts.Diagnostics.No_best_common_type_exists_among_yield_expressions);
              return createIterableIteratorType(unknownType);
            } else {
              error(func, ts.Diagnostics.No_best_common_type_exists_among_return_expressions);
              return unknownType;
            }
          }
          if (funcIsGenerator) {
            type = createIterableIteratorType(type);
          }
        }
        if (!contextualSignature) {
          reportErrorsFromWidening(func, type);
        }
        var widenedType = getWidenedType(type);
        if (isAsync) {
          var promiseType = createPromiseType(widenedType);
          if (promiseType === emptyObjectType) {
            error(func, ts.Diagnostics.An_async_function_or_method_must_have_a_valid_awaitable_return_type);
            return unknownType;
          }
          return promiseType;
        } else {
          return widenedType;
        }
      }
      function checkAndAggregateYieldOperandTypes(body, contextualMapper) {
        var aggregatedTypes = [];
        ts.forEachYieldExpression(body, function(yieldExpression) {
          var expr = yieldExpression.expression;
          if (expr) {
            var type = checkExpressionCached(expr, contextualMapper);
            if (yieldExpression.asteriskToken) {
              type = checkElementTypeOfIterable(type, yieldExpression.expression);
            }
            if (!ts.contains(aggregatedTypes, type)) {
              aggregatedTypes.push(type);
            }
          }
        });
        return aggregatedTypes;
      }
      function checkAndAggregateReturnExpressionTypes(body, contextualMapper, isAsync) {
        var aggregatedTypes = [];
        ts.forEachReturnStatement(body, function(returnStatement) {
          var expr = returnStatement.expression;
          if (expr) {
            var type = checkExpressionCached(expr, contextualMapper);
            if (isAsync) {
              type = checkAwaitedType(type, body.parent, ts.Diagnostics.Return_expression_in_async_function_does_not_have_a_valid_callable_then_member);
            }
            if (!ts.contains(aggregatedTypes, type)) {
              aggregatedTypes.push(type);
            }
          }
        });
        return aggregatedTypes;
      }
      function bodyContainsAReturnStatement(funcBody) {
        return ts.forEachReturnStatement(funcBody, function(returnStatement) {
          return true;
        });
      }
      function bodyContainsSingleThrowStatement(body) {
        return (body.statements.length === 1) && (body.statements[0].kind === 206);
      }
      function checkIfNonVoidFunctionHasReturnExpressionsOrSingleThrowStatment(func, returnType) {
        if (!produceDiagnostics) {
          return;
        }
        if (returnType === voidType || isTypeAny(returnType)) {
          return;
        }
        if (ts.nodeIsMissing(func.body) || func.body.kind !== 190) {
          return;
        }
        var bodyBlock = func.body;
        if (bodyContainsAReturnStatement(bodyBlock)) {
          return;
        }
        if (bodyContainsSingleThrowStatement(bodyBlock)) {
          return;
        }
        error(func.type, ts.Diagnostics.A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value_or_consist_of_a_single_throw_statement);
      }
      function checkFunctionExpressionOrObjectLiteralMethod(node, contextualMapper) {
        ts.Debug.assert(node.kind !== 141 || ts.isObjectLiteralMethod(node));
        var hasGrammarError = checkGrammarFunctionLikeDeclaration(node);
        if (!hasGrammarError && node.kind === 171) {
          checkGrammarForGenerator(node);
        }
        if (contextualMapper === identityMapper && isContextSensitive(node)) {
          return anyFunctionType;
        }
        var isAsync = ts.isAsyncFunctionLike(node);
        if (isAsync) {
          emitAwaiter = true;
        }
        var links = getNodeLinks(node);
        var type = getTypeOfSymbol(node.symbol);
        var contextSensitive = isContextSensitive(node);
        var mightFixTypeParameters = contextSensitive && isInferentialContext(contextualMapper);
        if (mightFixTypeParameters || !(links.flags & 1024)) {
          var contextualSignature = getContextualSignature(node);
          var contextChecked = !!(links.flags & 1024);
          if (mightFixTypeParameters || !contextChecked) {
            links.flags |= 1024;
            if (contextualSignature) {
              var signature = getSignaturesOfType(type, 0)[0];
              if (contextSensitive) {
                assignContextualParameterTypes(signature, contextualSignature, contextualMapper || identityMapper);
              }
              if (mightFixTypeParameters || !node.type && !signature.resolvedReturnType) {
                var returnType = getReturnTypeFromBody(node, contextualMapper);
                if (!signature.resolvedReturnType) {
                  signature.resolvedReturnType = returnType;
                }
              }
            }
            if (!contextChecked) {
              checkSignatureDeclaration(node);
            }
          }
        }
        if (produceDiagnostics && node.kind !== 141 && node.kind !== 140) {
          checkCollisionWithCapturedSuperVariable(node, node.name);
          checkCollisionWithCapturedThisVariable(node, node.name);
        }
        return type;
      }
      function checkFunctionExpressionOrObjectLiteralMethodBody(node) {
        ts.Debug.assert(node.kind !== 141 || ts.isObjectLiteralMethod(node));
        var isAsync = ts.isAsyncFunctionLike(node);
        if (isAsync) {
          emitAwaiter = true;
        }
        var returnType = node.type && getTypeFromTypeNode(node.type);
        var promisedType;
        if (returnType && isAsync) {
          promisedType = checkAsyncFunctionReturnType(node);
        }
        if (returnType && !node.asteriskToken) {
          checkIfNonVoidFunctionHasReturnExpressionsOrSingleThrowStatment(node, isAsync ? promisedType : returnType);
        }
        if (node.body) {
          if (!node.type) {
            getReturnTypeOfSignature(getSignatureFromDeclaration(node));
          }
          if (node.body.kind === 190) {
            checkSourceElement(node.body);
          } else {
            var exprType = checkExpression(node.body);
            if (returnType) {
              if (isAsync) {
                var awaitedType = checkAwaitedType(exprType, node.body, ts.Diagnostics.Expression_body_for_async_arrow_function_does_not_have_a_valid_callable_then_member);
                checkTypeAssignableTo(awaitedType, promisedType, node.body);
              } else {
                checkTypeAssignableTo(exprType, returnType, node.body);
              }
            }
            checkFunctionAndClassExpressionBodies(node.body);
          }
        }
      }
      function checkArithmeticOperandType(operand, type, diagnostic) {
        if (!isTypeAnyOrAllConstituentTypesHaveKind(type, 132)) {
          error(operand, diagnostic);
          return false;
        }
        return true;
      }
      function checkReferenceExpression(n, invalidReferenceMessage, constantVariableMessage) {
        function findSymbol(n) {
          var symbol = getNodeLinks(n).resolvedSymbol;
          return symbol && getExportSymbolOfValueSymbolIfExported(symbol);
        }
        function isReferenceOrErrorExpression(n) {
          switch (n.kind) {
            case 67:
              {
                var symbol = findSymbol(n);
                return !symbol || symbol === unknownSymbol || symbol === argumentsSymbol || (symbol.flags & 3) !== 0;
              }
            case 164:
              {
                var symbol = findSymbol(n);
                return !symbol || symbol === unknownSymbol || (symbol.flags & ~8) !== 0;
              }
            case 165:
              return true;
            case 170:
              return isReferenceOrErrorExpression(n.expression);
            default:
              return false;
          }
        }
        function isConstVariableReference(n) {
          switch (n.kind) {
            case 67:
            case 164:
              {
                var symbol = findSymbol(n);
                return symbol && (symbol.flags & 3) !== 0 && (getDeclarationFlagsFromSymbol(symbol) & 32768) !== 0;
              }
            case 165:
              {
                var index = n.argumentExpression;
                var symbol = findSymbol(n.expression);
                if (symbol && index && index.kind === 9) {
                  var name_12 = index.text;
                  var prop = getPropertyOfType(getTypeOfSymbol(symbol), name_12);
                  return prop && (prop.flags & 3) !== 0 && (getDeclarationFlagsFromSymbol(prop) & 32768) !== 0;
                }
                return false;
              }
            case 170:
              return isConstVariableReference(n.expression);
            default:
              return false;
          }
        }
        if (!isReferenceOrErrorExpression(n)) {
          error(n, invalidReferenceMessage);
          return false;
        }
        if (isConstVariableReference(n)) {
          error(n, constantVariableMessage);
          return false;
        }
        return true;
      }
      function checkDeleteExpression(node) {
        checkExpression(node.expression);
        return booleanType;
      }
      function checkTypeOfExpression(node) {
        checkExpression(node.expression);
        return stringType;
      }
      function checkVoidExpression(node) {
        checkExpression(node.expression);
        return undefinedType;
      }
      function checkAwaitExpression(node) {
        if (produceDiagnostics) {
          if (!(node.parserContextFlags & 8)) {
            grammarErrorOnFirstToken(node, ts.Diagnostics.await_expression_is_only_allowed_within_an_async_function);
          }
          if (isInParameterInitializerBeforeContainingFunction(node)) {
            error(node, ts.Diagnostics.await_expressions_cannot_be_used_in_a_parameter_initializer);
          }
        }
        var operandType = checkExpression(node.expression);
        return checkAwaitedType(operandType, node);
      }
      function checkPrefixUnaryExpression(node) {
        var operandType = checkExpression(node.operand);
        switch (node.operator) {
          case 35:
          case 36:
          case 49:
            if (someConstituentTypeHasKind(operandType, 16777216)) {
              error(node.operand, ts.Diagnostics.The_0_operator_cannot_be_applied_to_type_symbol, ts.tokenToString(node.operator));
            }
            return numberType;
          case 48:
            return booleanType;
          case 40:
          case 41:
            var ok = checkArithmeticOperandType(node.operand, operandType, ts.Diagnostics.An_arithmetic_operand_must_be_of_type_any_number_or_an_enum_type);
            if (ok) {
              checkReferenceExpression(node.operand, ts.Diagnostics.The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_property_or_indexer, ts.Diagnostics.The_operand_of_an_increment_or_decrement_operator_cannot_be_a_constant);
            }
            return numberType;
        }
        return unknownType;
      }
      function checkPostfixUnaryExpression(node) {
        var operandType = checkExpression(node.operand);
        var ok = checkArithmeticOperandType(node.operand, operandType, ts.Diagnostics.An_arithmetic_operand_must_be_of_type_any_number_or_an_enum_type);
        if (ok) {
          checkReferenceExpression(node.operand, ts.Diagnostics.The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_property_or_indexer, ts.Diagnostics.The_operand_of_an_increment_or_decrement_operator_cannot_be_a_constant);
        }
        return numberType;
      }
      function someConstituentTypeHasKind(type, kind) {
        if (type.flags & kind) {
          return true;
        }
        if (type.flags & 49152) {
          var types = type.types;
          for (var _i = 0; _i < types.length; _i++) {
            var current = types[_i];
            if (current.flags & kind) {
              return true;
            }
          }
          return false;
        }
        return false;
      }
      function allConstituentTypesHaveKind(type, kind) {
        if (type.flags & kind) {
          return true;
        }
        if (type.flags & 49152) {
          var types = type.types;
          for (var _i = 0; _i < types.length; _i++) {
            var current = types[_i];
            if (!(current.flags & kind)) {
              return false;
            }
          }
          return true;
        }
        return false;
      }
      function isConstEnumObjectType(type) {
        return type.flags & (80896 | 65536) && type.symbol && isConstEnumSymbol(type.symbol);
      }
      function isConstEnumSymbol(symbol) {
        return (symbol.flags & 128) !== 0;
      }
      function checkInstanceOfExpression(node, leftType, rightType) {
        if (allConstituentTypesHaveKind(leftType, 16777726)) {
          error(node.left, ts.Diagnostics.The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter);
        }
        if (!(isTypeAny(rightType) || isTypeSubtypeOf(rightType, globalFunctionType))) {
          error(node.right, ts.Diagnostics.The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type);
        }
        return booleanType;
      }
      function checkInExpression(node, leftType, rightType) {
        if (!isTypeAnyOrAllConstituentTypesHaveKind(leftType, 258 | 132 | 16777216)) {
          error(node.left, ts.Diagnostics.The_left_hand_side_of_an_in_expression_must_be_of_type_any_string_number_or_symbol);
        }
        if (!isTypeAnyOrAllConstituentTypesHaveKind(rightType, 80896 | 512)) {
          error(node.right, ts.Diagnostics.The_right_hand_side_of_an_in_expression_must_be_of_type_any_an_object_type_or_a_type_parameter);
        }
        return booleanType;
      }
      function checkObjectLiteralAssignment(node, sourceType, contextualMapper) {
        var properties = node.properties;
        for (var _i = 0; _i < properties.length; _i++) {
          var p = properties[_i];
          if (p.kind === 243 || p.kind === 244) {
            var name_13 = p.name;
            var type = isTypeAny(sourceType) ? sourceType : getTypeOfPropertyOfType(sourceType, name_13.text) || isNumericLiteralName(name_13.text) && getIndexTypeOfType(sourceType, 1) || getIndexTypeOfType(sourceType, 0);
            if (type) {
              checkDestructuringAssignment(p.initializer || name_13, type);
            } else {
              error(name_13, ts.Diagnostics.Type_0_has_no_property_1_and_no_string_index_signature, typeToString(sourceType), ts.declarationNameToString(name_13));
            }
          } else {
            error(p, ts.Diagnostics.Property_assignment_expected);
          }
        }
        return sourceType;
      }
      function checkArrayLiteralAssignment(node, sourceType, contextualMapper) {
        var elementType = checkIteratedTypeOrElementType(sourceType, node, false) || unknownType;
        var elements = node.elements;
        for (var i = 0; i < elements.length; i++) {
          var e = elements[i];
          if (e.kind !== 185) {
            if (e.kind !== 183) {
              var propName = "" + i;
              var type = isTypeAny(sourceType) ? sourceType : isTupleLikeType(sourceType) ? getTypeOfPropertyOfType(sourceType, propName) : elementType;
              if (type) {
                checkDestructuringAssignment(e, type, contextualMapper);
              } else {
                if (isTupleType(sourceType)) {
                  error(e, ts.Diagnostics.Tuple_type_0_with_length_1_cannot_be_assigned_to_tuple_with_length_2, typeToString(sourceType), sourceType.elementTypes.length, elements.length);
                } else {
                  error(e, ts.Diagnostics.Type_0_has_no_property_1, typeToString(sourceType), propName);
                }
              }
            } else {
              if (i < elements.length - 1) {
                error(e, ts.Diagnostics.A_rest_element_must_be_last_in_an_array_destructuring_pattern);
              } else {
                var restExpression = e.expression;
                if (restExpression.kind === 179 && restExpression.operatorToken.kind === 55) {
                  error(restExpression.operatorToken, ts.Diagnostics.A_rest_element_cannot_have_an_initializer);
                } else {
                  checkDestructuringAssignment(restExpression, createArrayType(elementType), contextualMapper);
                }
              }
            }
          }
        }
        return sourceType;
      }
      function checkDestructuringAssignment(target, sourceType, contextualMapper) {
        if (target.kind === 179 && target.operatorToken.kind === 55) {
          checkBinaryExpression(target, contextualMapper);
          target = target.left;
        }
        if (target.kind === 163) {
          return checkObjectLiteralAssignment(target, sourceType, contextualMapper);
        }
        if (target.kind === 162) {
          return checkArrayLiteralAssignment(target, sourceType, contextualMapper);
        }
        return checkReferenceAssignment(target, sourceType, contextualMapper);
      }
      function checkReferenceAssignment(target, sourceType, contextualMapper) {
        var targetType = checkExpression(target, contextualMapper);
        if (checkReferenceExpression(target, ts.Diagnostics.Invalid_left_hand_side_of_assignment_expression, ts.Diagnostics.Left_hand_side_of_assignment_expression_cannot_be_a_constant)) {
          checkTypeAssignableTo(sourceType, targetType, target, undefined);
        }
        return sourceType;
      }
      function checkBinaryExpression(node, contextualMapper) {
        var operator = node.operatorToken.kind;
        if (operator === 55 && (node.left.kind === 163 || node.left.kind === 162)) {
          return checkDestructuringAssignment(node.left, checkExpression(node.right, contextualMapper), contextualMapper);
        }
        var leftType = checkExpression(node.left, contextualMapper);
        var rightType = checkExpression(node.right, contextualMapper);
        switch (operator) {
          case 37:
          case 58:
          case 38:
          case 59:
          case 39:
          case 60:
          case 36:
          case 57:
          case 42:
          case 61:
          case 43:
          case 62:
          case 44:
          case 63:
          case 46:
          case 65:
          case 47:
          case 66:
          case 45:
          case 64:
            if (leftType.flags & (32 | 64))
              leftType = rightType;
            if (rightType.flags & (32 | 64))
              rightType = leftType;
            var suggestedOperator;
            if ((leftType.flags & 8) && (rightType.flags & 8) && (suggestedOperator = getSuggestedBooleanOperator(node.operatorToken.kind)) !== undefined) {
              error(node, ts.Diagnostics.The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead, ts.tokenToString(node.operatorToken.kind), ts.tokenToString(suggestedOperator));
            } else {
              var leftOk = checkArithmeticOperandType(node.left, leftType, ts.Diagnostics.The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type);
              var rightOk = checkArithmeticOperandType(node.right, rightType, ts.Diagnostics.The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_or_an_enum_type);
              if (leftOk && rightOk) {
                checkAssignmentOperator(numberType);
              }
            }
            return numberType;
          case 35:
          case 56:
            if (leftType.flags & (32 | 64))
              leftType = rightType;
            if (rightType.flags & (32 | 64))
              rightType = leftType;
            var resultType;
            if (allConstituentTypesHaveKind(leftType, 132) && allConstituentTypesHaveKind(rightType, 132)) {
              resultType = numberType;
            } else {
              if (allConstituentTypesHaveKind(leftType, 258) || allConstituentTypesHaveKind(rightType, 258)) {
                resultType = stringType;
              } else if (isTypeAny(leftType) || isTypeAny(rightType)) {
                resultType = leftType === unknownType || rightType === unknownType ? unknownType : anyType;
              }
              if (resultType && !checkForDisallowedESSymbolOperand(operator)) {
                return resultType;
              }
            }
            if (!resultType) {
              reportOperatorError();
              return anyType;
            }
            if (operator === 56) {
              checkAssignmentOperator(resultType);
            }
            return resultType;
          case 25:
          case 27:
          case 28:
          case 29:
            if (!checkForDisallowedESSymbolOperand(operator)) {
              return booleanType;
            }
          case 30:
          case 31:
          case 32:
          case 33:
            if (!isTypeAssignableTo(leftType, rightType) && !isTypeAssignableTo(rightType, leftType)) {
              reportOperatorError();
            }
            return booleanType;
          case 89:
            return checkInstanceOfExpression(node, leftType, rightType);
          case 88:
            return checkInExpression(node, leftType, rightType);
          case 50:
            return rightType;
          case 51:
            return getUnionType([leftType, rightType]);
          case 55:
            checkAssignmentOperator(rightType);
            return getRegularTypeOfObjectLiteral(rightType);
          case 24:
            return rightType;
        }
        function checkForDisallowedESSymbolOperand(operator) {
          var offendingSymbolOperand = someConstituentTypeHasKind(leftType, 16777216) ? node.left : someConstituentTypeHasKind(rightType, 16777216) ? node.right : undefined;
          if (offendingSymbolOperand) {
            error(offendingSymbolOperand, ts.Diagnostics.The_0_operator_cannot_be_applied_to_type_symbol, ts.tokenToString(operator));
            return false;
          }
          return true;
        }
        function getSuggestedBooleanOperator(operator) {
          switch (operator) {
            case 46:
            case 65:
              return 51;
            case 47:
            case 66:
              return 33;
            case 45:
            case 64:
              return 50;
            default:
              return undefined;
          }
        }
        function checkAssignmentOperator(valueType) {
          if (produceDiagnostics && operator >= 55 && operator <= 66) {
            var ok = checkReferenceExpression(node.left, ts.Diagnostics.Invalid_left_hand_side_of_assignment_expression, ts.Diagnostics.Left_hand_side_of_assignment_expression_cannot_be_a_constant);
            if (ok) {
              checkTypeAssignableTo(valueType, leftType, node.left, undefined);
            }
          }
        }
        function reportOperatorError() {
          error(node, ts.Diagnostics.Operator_0_cannot_be_applied_to_types_1_and_2, ts.tokenToString(node.operatorToken.kind), typeToString(leftType), typeToString(rightType));
        }
      }
      function isYieldExpressionInClass(node) {
        var current = node;
        var parent = node.parent;
        while (parent) {
          if (ts.isFunctionLike(parent) && current === parent.body) {
            return false;
          } else if (ts.isClassLike(current)) {
            return true;
          }
          current = parent;
          parent = parent.parent;
        }
        return false;
      }
      function checkYieldExpression(node) {
        if (produceDiagnostics) {
          if (!(node.parserContextFlags & 2) || isYieldExpressionInClass(node)) {
            grammarErrorOnFirstToken(node, ts.Diagnostics.A_yield_expression_is_only_allowed_in_a_generator_body);
          }
          if (isInParameterInitializerBeforeContainingFunction(node)) {
            error(node, ts.Diagnostics.yield_expressions_cannot_be_used_in_a_parameter_initializer);
          }
        }
        if (node.expression) {
          var func = ts.getContainingFunction(node);
          if (func && func.asteriskToken) {
            var expressionType = checkExpressionCached(node.expression, undefined);
            var expressionElementType;
            var nodeIsYieldStar = !!node.asteriskToken;
            if (nodeIsYieldStar) {
              expressionElementType = checkElementTypeOfIterable(expressionType, node.expression);
            }
            if (func.type) {
              var signatureElementType = getElementTypeOfIterableIterator(getTypeFromTypeNode(func.type)) || anyType;
              if (nodeIsYieldStar) {
                checkTypeAssignableTo(expressionElementType, signatureElementType, node.expression, undefined);
              } else {
                checkTypeAssignableTo(expressionType, signatureElementType, node.expression, undefined);
              }
            }
          }
        }
        return anyType;
      }
      function checkConditionalExpression(node, contextualMapper) {
        checkExpression(node.condition);
        var type1 = checkExpression(node.whenTrue, contextualMapper);
        var type2 = checkExpression(node.whenFalse, contextualMapper);
        return getUnionType([type1, type2]);
      }
      function checkTemplateExpression(node) {
        ts.forEach(node.templateSpans, function(templateSpan) {
          checkExpression(templateSpan.expression);
        });
        return stringType;
      }
      function checkExpressionWithContextualType(node, contextualType, contextualMapper) {
        var saveContextualType = node.contextualType;
        node.contextualType = contextualType;
        var result = checkExpression(node, contextualMapper);
        node.contextualType = saveContextualType;
        return result;
      }
      function checkExpressionCached(node, contextualMapper) {
        var links = getNodeLinks(node);
        if (!links.resolvedType) {
          links.resolvedType = checkExpression(node, contextualMapper);
        }
        return links.resolvedType;
      }
      function checkPropertyAssignment(node, contextualMapper) {
        if (node.name.kind === 134) {
          checkComputedPropertyName(node.name);
        }
        return checkExpression(node.initializer, contextualMapper);
      }
      function checkObjectLiteralMethod(node, contextualMapper) {
        checkGrammarMethod(node);
        if (node.name.kind === 134) {
          checkComputedPropertyName(node.name);
        }
        var uninstantiatedType = checkFunctionExpressionOrObjectLiteralMethod(node, contextualMapper);
        return instantiateTypeWithSingleGenericCallSignature(node, uninstantiatedType, contextualMapper);
      }
      function instantiateTypeWithSingleGenericCallSignature(node, type, contextualMapper) {
        if (isInferentialContext(contextualMapper)) {
          var signature = getSingleCallSignature(type);
          if (signature && signature.typeParameters) {
            var contextualType = getContextualType(node);
            if (contextualType) {
              var contextualSignature = getSingleCallSignature(contextualType);
              if (contextualSignature && !contextualSignature.typeParameters) {
                return getOrCreateTypeFromSignature(instantiateSignatureInContextOf(signature, contextualSignature, contextualMapper));
              }
            }
          }
        }
        return type;
      }
      function checkExpression(node, contextualMapper) {
        var type;
        if (node.kind === 133) {
          type = checkQualifiedName(node);
        } else {
          var uninstantiatedType = checkExpressionWorker(node, contextualMapper);
          type = instantiateTypeWithSingleGenericCallSignature(node, uninstantiatedType, contextualMapper);
        }
        if (isConstEnumObjectType(type)) {
          var ok = (node.parent.kind === 164 && node.parent.expression === node) || (node.parent.kind === 165 && node.parent.expression === node) || ((node.kind === 67 || node.kind === 133) && isInRightSideOfImportOrExportAssignment(node));
          if (!ok) {
            error(node, ts.Diagnostics.const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment);
          }
        }
        return type;
      }
      function checkNumericLiteral(node) {
        checkGrammarNumericLiteral(node);
        return numberType;
      }
      function checkExpressionWorker(node, contextualMapper) {
        switch (node.kind) {
          case 67:
            return checkIdentifier(node);
          case 95:
            return checkThisExpression(node);
          case 93:
            return checkSuperExpression(node);
          case 91:
            return nullType;
          case 97:
          case 82:
            return booleanType;
          case 8:
            return checkNumericLiteral(node);
          case 181:
            return checkTemplateExpression(node);
          case 9:
          case 11:
            return stringType;
          case 10:
            return globalRegExpType;
          case 162:
            return checkArrayLiteral(node, contextualMapper);
          case 163:
            return checkObjectLiteral(node, contextualMapper);
          case 164:
            return checkPropertyAccessExpression(node);
          case 165:
            return checkIndexedAccess(node);
          case 166:
          case 167:
            return checkCallExpression(node);
          case 168:
            return checkTaggedTemplateExpression(node);
          case 170:
            return checkExpression(node.expression, contextualMapper);
          case 184:
            return checkClassExpression(node);
          case 171:
          case 172:
            return checkFunctionExpressionOrObjectLiteralMethod(node, contextualMapper);
          case 174:
            return checkTypeOfExpression(node);
          case 169:
          case 187:
            return checkAssertion(node);
          case 173:
            return checkDeleteExpression(node);
          case 175:
            return checkVoidExpression(node);
          case 176:
            return checkAwaitExpression(node);
          case 177:
            return checkPrefixUnaryExpression(node);
          case 178:
            return checkPostfixUnaryExpression(node);
          case 179:
            return checkBinaryExpression(node, contextualMapper);
          case 180:
            return checkConditionalExpression(node, contextualMapper);
          case 183:
            return checkSpreadElementExpression(node, contextualMapper);
          case 185:
            return undefinedType;
          case 182:
            return checkYieldExpression(node);
          case 238:
            return checkJsxExpression(node);
          case 231:
            return checkJsxElement(node);
          case 232:
            return checkJsxSelfClosingElement(node);
          case 233:
            ts.Debug.fail("Shouldn't ever directly check a JsxOpeningElement");
        }
        return unknownType;
      }
      function checkTypeParameter(node) {
        if (node.expression) {
          grammarErrorOnFirstToken(node.expression, ts.Diagnostics.Type_expected);
        }
        checkSourceElement(node.constraint);
        if (produceDiagnostics) {
          checkTypeParameterHasIllegalReferencesInConstraint(node);
          checkTypeNameIsReserved(node.name, ts.Diagnostics.Type_parameter_name_cannot_be_0);
        }
      }
      function checkParameter(node) {
        checkGrammarDecorators(node) || checkGrammarModifiers(node);
        checkVariableLikeDeclaration(node);
        var func = ts.getContainingFunction(node);
        if (node.flags & 112) {
          func = ts.getContainingFunction(node);
          if (!(func.kind === 142 && ts.nodeIsPresent(func.body))) {
            error(node, ts.Diagnostics.A_parameter_property_is_only_allowed_in_a_constructor_implementation);
          }
        }
        if (node.questionToken && ts.isBindingPattern(node.name) && func.body) {
          error(node, ts.Diagnostics.A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature);
        }
        if (node.dotDotDotToken && !ts.isBindingPattern(node.name) && !isArrayType(getTypeOfSymbol(node.symbol))) {
          error(node, ts.Diagnostics.A_rest_parameter_must_be_of_an_array_type);
        }
      }
      function isSyntacticallyValidGenerator(node) {
        if (!node.asteriskToken || !node.body) {
          return false;
        }
        return node.kind === 141 || node.kind === 211 || node.kind === 171;
      }
      function getTypePredicateParameterIndex(parameterList, parameter) {
        if (parameterList) {
          for (var i = 0; i < parameterList.length; i++) {
            var param = parameterList[i];
            if (param.name.kind === 67 && param.name.text === parameter.text) {
              return i;
            }
          }
        }
        return -1;
      }
      function isInLegalTypePredicatePosition(node) {
        switch (node.parent.kind) {
          case 172:
          case 145:
          case 211:
          case 171:
          case 150:
          case 141:
          case 140:
            return node === node.parent.type;
        }
        return false;
      }
      function checkSignatureDeclaration(node) {
        if (node.kind === 147) {
          checkGrammarIndexSignature(node);
        } else if (node.kind === 150 || node.kind === 211 || node.kind === 151 || node.kind === 145 || node.kind === 142 || node.kind === 146) {
          checkGrammarFunctionLikeDeclaration(node);
        }
        checkTypeParameters(node.typeParameters);
        ts.forEach(node.parameters, checkParameter);
        if (node.type) {
          if (node.type.kind === 148) {
            var typePredicate = getSignatureFromDeclaration(node).typePredicate;
            var typePredicateNode = node.type;
            if (isInLegalTypePredicatePosition(typePredicateNode)) {
              if (typePredicate.parameterIndex >= 0) {
                if (node.parameters[typePredicate.parameterIndex].dotDotDotToken) {
                  error(typePredicateNode.parameterName, ts.Diagnostics.A_type_predicate_cannot_reference_a_rest_parameter);
                } else {
                  checkTypeAssignableTo(typePredicate.type, getTypeOfNode(node.parameters[typePredicate.parameterIndex]), typePredicateNode.type);
                }
              } else if (typePredicateNode.parameterName) {
                var hasReportedError = false;
                for (var _i = 0,
                    _a = node.parameters; _i < _a.length; _i++) {
                  var param = _a[_i];
                  if (hasReportedError) {
                    break;
                  }
                  if (param.name.kind === 159 || param.name.kind === 160) {
                    (function checkBindingPattern(pattern) {
                      for (var _i = 0,
                          _a = pattern.elements; _i < _a.length; _i++) {
                        var element = _a[_i];
                        if (element.name.kind === 67 && element.name.text === typePredicate.parameterName) {
                          error(typePredicateNode.parameterName, ts.Diagnostics.A_type_predicate_cannot_reference_element_0_in_a_binding_pattern, typePredicate.parameterName);
                          hasReportedError = true;
                          break;
                        } else if (element.name.kind === 160 || element.name.kind === 159) {
                          checkBindingPattern(element.name);
                        }
                      }
                    })(param.name);
                  }
                }
                if (!hasReportedError) {
                  error(typePredicateNode.parameterName, ts.Diagnostics.Cannot_find_parameter_0, typePredicate.parameterName);
                }
              }
            } else {
              error(typePredicateNode, ts.Diagnostics.A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods);
            }
          } else {
            checkSourceElement(node.type);
          }
        }
        if (produceDiagnostics) {
          checkCollisionWithArgumentsInGeneratedCode(node);
          if (compilerOptions.noImplicitAny && !node.type) {
            switch (node.kind) {
              case 146:
                error(node, ts.Diagnostics.Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type);
                break;
              case 145:
                error(node, ts.Diagnostics.Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type);
                break;
            }
          }
          if (node.type) {
            if (languageVersion >= 2 && isSyntacticallyValidGenerator(node)) {
              var returnType = getTypeFromTypeNode(node.type);
              if (returnType === voidType) {
                error(node.type, ts.Diagnostics.A_generator_cannot_have_a_void_type_annotation);
              } else {
                var generatorElementType = getElementTypeOfIterableIterator(returnType) || anyType;
                var iterableIteratorInstantiation = createIterableIteratorType(generatorElementType);
                checkTypeAssignableTo(iterableIteratorInstantiation, returnType, node.type);
              }
            }
          }
        }
        checkSpecializedSignatureDeclaration(node);
      }
      function checkTypeForDuplicateIndexSignatures(node) {
        if (node.kind === 213) {
          var nodeSymbol = getSymbolOfNode(node);
          if (nodeSymbol.declarations.length > 0 && nodeSymbol.declarations[0] !== node) {
            return;
          }
        }
        var indexSymbol = getIndexSymbol(getSymbolOfNode(node));
        if (indexSymbol) {
          var seenNumericIndexer = false;
          var seenStringIndexer = false;
          for (var _i = 0,
              _a = indexSymbol.declarations; _i < _a.length; _i++) {
            var decl = _a[_i];
            var declaration = decl;
            if (declaration.parameters.length === 1 && declaration.parameters[0].type) {
              switch (declaration.parameters[0].type.kind) {
                case 128:
                  if (!seenStringIndexer) {
                    seenStringIndexer = true;
                  } else {
                    error(declaration, ts.Diagnostics.Duplicate_string_index_signature);
                  }
                  break;
                case 126:
                  if (!seenNumericIndexer) {
                    seenNumericIndexer = true;
                  } else {
                    error(declaration, ts.Diagnostics.Duplicate_number_index_signature);
                  }
                  break;
              }
            }
          }
        }
      }
      function checkPropertyDeclaration(node) {
        checkGrammarDecorators(node) || checkGrammarModifiers(node) || checkGrammarProperty(node) || checkGrammarComputedPropertyName(node.name);
        checkVariableLikeDeclaration(node);
      }
      function checkMethodDeclaration(node) {
        checkGrammarMethod(node) || checkGrammarComputedPropertyName(node.name);
        checkFunctionLikeDeclaration(node);
        if (node.flags & 256 && node.body) {
          error(node, ts.Diagnostics.Method_0_cannot_have_an_implementation_because_it_is_marked_abstract, ts.declarationNameToString(node.name));
        }
      }
      function checkConstructorDeclaration(node) {
        checkSignatureDeclaration(node);
        checkGrammarConstructorTypeParameters(node) || checkGrammarConstructorTypeAnnotation(node);
        checkSourceElement(node.body);
        var symbol = getSymbolOfNode(node);
        var firstDeclaration = ts.getDeclarationOfKind(symbol, node.kind);
        if (node === firstDeclaration) {
          checkFunctionOrConstructorSymbol(symbol);
        }
        if (ts.nodeIsMissing(node.body)) {
          return;
        }
        if (!produceDiagnostics) {
          return;
        }
        function isSuperCallExpression(n) {
          return n.kind === 166 && n.expression.kind === 93;
        }
        function containsSuperCallAsComputedPropertyName(n) {
          return n.name && containsSuperCall(n.name);
        }
        function containsSuperCall(n) {
          if (isSuperCallExpression(n)) {
            return true;
          } else if (ts.isFunctionLike(n)) {
            return false;
          } else if (ts.isClassLike(n)) {
            return ts.forEach(n.members, containsSuperCallAsComputedPropertyName);
          }
          return ts.forEachChild(n, containsSuperCall);
        }
        function markThisReferencesAsErrors(n) {
          if (n.kind === 95) {
            error(n, ts.Diagnostics.this_cannot_be_referenced_in_current_location);
          } else if (n.kind !== 171 && n.kind !== 211) {
            ts.forEachChild(n, markThisReferencesAsErrors);
          }
        }
        function isInstancePropertyWithInitializer(n) {
          return n.kind === 139 && !(n.flags & 128) && !!n.initializer;
        }
        var containingClassDecl = node.parent;
        if (ts.getClassExtendsHeritageClauseElement(containingClassDecl)) {
          var containingClassSymbol = getSymbolOfNode(containingClassDecl);
          var containingClassInstanceType = getDeclaredTypeOfSymbol(containingClassSymbol);
          var baseConstructorType = getBaseConstructorTypeOfClass(containingClassInstanceType);
          if (containsSuperCall(node.body)) {
            if (baseConstructorType === nullType) {
              error(node, ts.Diagnostics.A_constructor_cannot_contain_a_super_call_when_its_class_extends_null);
            }
            var superCallShouldBeFirst = ts.forEach(node.parent.members, isInstancePropertyWithInitializer) || ts.forEach(node.parameters, function(p) {
              return p.flags & (16 | 32 | 64);
            });
            if (superCallShouldBeFirst) {
              var statements = node.body.statements;
              var superCallStatement;
              for (var _i = 0; _i < statements.length; _i++) {
                var statement = statements[_i];
                if (statement.kind === 193 && isSuperCallExpression(statement.expression)) {
                  superCallStatement = statement;
                  break;
                }
                if (!ts.isPrologueDirective(statement)) {
                  break;
                }
              }
              if (!superCallStatement) {
                error(node, ts.Diagnostics.A_super_call_must_be_the_first_statement_in_the_constructor_when_a_class_contains_initialized_properties_or_has_parameter_properties);
              } else {
                markThisReferencesAsErrors(superCallStatement.expression);
              }
            }
          } else if (baseConstructorType !== nullType) {
            error(node, ts.Diagnostics.Constructors_for_derived_classes_must_contain_a_super_call);
          }
        }
      }
      function checkAccessorDeclaration(node) {
        if (produceDiagnostics) {
          checkGrammarFunctionLikeDeclaration(node) || checkGrammarAccessor(node) || checkGrammarComputedPropertyName(node.name);
          if (node.kind === 143) {
            if (!ts.isInAmbientContext(node) && ts.nodeIsPresent(node.body) && !(bodyContainsAReturnStatement(node.body) || bodyContainsSingleThrowStatement(node.body))) {
              error(node.name, ts.Diagnostics.A_get_accessor_must_return_a_value_or_consist_of_a_single_throw_statement);
            }
          }
          if (!ts.hasDynamicName(node)) {
            var otherKind = node.kind === 143 ? 144 : 143;
            var otherAccessor = ts.getDeclarationOfKind(node.symbol, otherKind);
            if (otherAccessor) {
              if (((node.flags & 112) !== (otherAccessor.flags & 112))) {
                error(node.name, ts.Diagnostics.Getter_and_setter_accessors_do_not_agree_in_visibility);
              }
              var currentAccessorType = getAnnotatedAccessorType(node);
              var otherAccessorType = getAnnotatedAccessorType(otherAccessor);
              if (currentAccessorType && otherAccessorType) {
                if (!isTypeIdenticalTo(currentAccessorType, otherAccessorType)) {
                  error(node, ts.Diagnostics.get_and_set_accessor_must_have_the_same_type);
                }
              }
            }
          }
          getTypeOfAccessors(getSymbolOfNode(node));
        }
        checkFunctionLikeDeclaration(node);
      }
      function checkMissingDeclaration(node) {
        checkDecorators(node);
      }
      function checkTypeArgumentConstraints(typeParameters, typeArguments) {
        var result = true;
        for (var i = 0; i < typeParameters.length; i++) {
          var constraint = getConstraintOfTypeParameter(typeParameters[i]);
          if (constraint) {
            var typeArgument = typeArguments[i];
            result = result && checkTypeAssignableTo(getTypeFromTypeNode(typeArgument), constraint, typeArgument, ts.Diagnostics.Type_0_does_not_satisfy_the_constraint_1);
          }
        }
        return result;
      }
      function checkTypeReferenceNode(node) {
        checkGrammarTypeArguments(node, node.typeArguments);
        var type = getTypeFromTypeReference(node);
        if (type !== unknownType && node.typeArguments) {
          ts.forEach(node.typeArguments, checkSourceElement);
          if (produceDiagnostics) {
            var symbol = getNodeLinks(node).resolvedSymbol;
            var typeParameters = symbol.flags & 524288 ? getSymbolLinks(symbol).typeParameters : type.target.localTypeParameters;
            checkTypeArgumentConstraints(typeParameters, node.typeArguments);
          }
        }
      }
      function checkTypeQuery(node) {
        getTypeFromTypeQueryNode(node);
      }
      function checkTypeLiteral(node) {
        ts.forEach(node.members, checkSourceElement);
        if (produceDiagnostics) {
          var type = getTypeFromTypeLiteralOrFunctionOrConstructorTypeNode(node);
          checkIndexConstraints(type);
          checkTypeForDuplicateIndexSignatures(node);
        }
      }
      function checkArrayType(node) {
        checkSourceElement(node.elementType);
      }
      function checkTupleType(node) {
        var hasErrorFromDisallowedTrailingComma = checkGrammarForDisallowedTrailingComma(node.elementTypes);
        if (!hasErrorFromDisallowedTrailingComma && node.elementTypes.length === 0) {
          grammarErrorOnNode(node, ts.Diagnostics.A_tuple_type_element_list_cannot_be_empty);
        }
        ts.forEach(node.elementTypes, checkSourceElement);
      }
      function checkUnionOrIntersectionType(node) {
        ts.forEach(node.types, checkSourceElement);
      }
      function isPrivateWithinAmbient(node) {
        return (node.flags & 32) && ts.isInAmbientContext(node);
      }
      function checkSpecializedSignatureDeclaration(signatureDeclarationNode) {
        if (!produceDiagnostics) {
          return;
        }
        var signature = getSignatureFromDeclaration(signatureDeclarationNode);
        if (!signature.hasStringLiterals) {
          return;
        }
        if (ts.nodeIsPresent(signatureDeclarationNode.body)) {
          error(signatureDeclarationNode, ts.Diagnostics.A_signature_with_an_implementation_cannot_use_a_string_literal_type);
          return;
        }
        var signaturesToCheck;
        if (!signatureDeclarationNode.name && signatureDeclarationNode.parent && signatureDeclarationNode.parent.kind === 213) {
          ts.Debug.assert(signatureDeclarationNode.kind === 145 || signatureDeclarationNode.kind === 146);
          var signatureKind = signatureDeclarationNode.kind === 145 ? 0 : 1;
          var containingSymbol = getSymbolOfNode(signatureDeclarationNode.parent);
          var containingType = getDeclaredTypeOfSymbol(containingSymbol);
          signaturesToCheck = getSignaturesOfType(containingType, signatureKind);
        } else {
          signaturesToCheck = getSignaturesOfSymbol(getSymbolOfNode(signatureDeclarationNode));
        }
        for (var _i = 0; _i < signaturesToCheck.length; _i++) {
          var otherSignature = signaturesToCheck[_i];
          if (!otherSignature.hasStringLiterals && isSignatureAssignableTo(signature, otherSignature)) {
            return;
          }
        }
        error(signatureDeclarationNode, ts.Diagnostics.Specialized_overload_signature_is_not_assignable_to_any_non_specialized_signature);
      }
      function getEffectiveDeclarationFlags(n, flagsToCheck) {
        var flags = ts.getCombinedNodeFlags(n);
        if (n.parent.kind !== 213 && ts.isInAmbientContext(n)) {
          if (!(flags & 2)) {
            flags |= 1;
          }
          flags |= 2;
        }
        return flags & flagsToCheck;
      }
      function checkFunctionOrConstructorSymbol(symbol) {
        if (!produceDiagnostics) {
          return;
        }
        function getCanonicalOverload(overloads, implementation) {
          var implementationSharesContainerWithFirstOverload = implementation !== undefined && implementation.parent === overloads[0].parent;
          return implementationSharesContainerWithFirstOverload ? implementation : overloads[0];
        }
        function checkFlagAgreementBetweenOverloads(overloads, implementation, flagsToCheck, someOverloadFlags, allOverloadFlags) {
          var someButNotAllOverloadFlags = someOverloadFlags ^ allOverloadFlags;
          if (someButNotAllOverloadFlags !== 0) {
            var canonicalFlags = getEffectiveDeclarationFlags(getCanonicalOverload(overloads, implementation), flagsToCheck);
            ts.forEach(overloads, function(o) {
              var deviation = getEffectiveDeclarationFlags(o, flagsToCheck) ^ canonicalFlags;
              if (deviation & 1) {
                error(o.name, ts.Diagnostics.Overload_signatures_must_all_be_exported_or_not_exported);
              } else if (deviation & 2) {
                error(o.name, ts.Diagnostics.Overload_signatures_must_all_be_ambient_or_non_ambient);
              } else if (deviation & (32 | 64)) {
                error(o.name, ts.Diagnostics.Overload_signatures_must_all_be_public_private_or_protected);
              } else if (deviation & 256) {
                error(o.name, ts.Diagnostics.Overload_signatures_must_all_be_abstract_or_not_abstract);
              }
            });
          }
        }
        function checkQuestionTokenAgreementBetweenOverloads(overloads, implementation, someHaveQuestionToken, allHaveQuestionToken) {
          if (someHaveQuestionToken !== allHaveQuestionToken) {
            var canonicalHasQuestionToken = ts.hasQuestionToken(getCanonicalOverload(overloads, implementation));
            ts.forEach(overloads, function(o) {
              var deviation = ts.hasQuestionToken(o) !== canonicalHasQuestionToken;
              if (deviation) {
                error(o.name, ts.Diagnostics.Overload_signatures_must_all_be_optional_or_required);
              }
            });
          }
        }
        var flagsToCheck = 1 | 2 | 32 | 64 | 256;
        var someNodeFlags = 0;
        var allNodeFlags = flagsToCheck;
        var someHaveQuestionToken = false;
        var allHaveQuestionToken = true;
        var hasOverloads = false;
        var bodyDeclaration;
        var lastSeenNonAmbientDeclaration;
        var previousDeclaration;
        var declarations = symbol.declarations;
        var isConstructor = (symbol.flags & 16384) !== 0;
        function reportImplementationExpectedError(node) {
          if (node.name && ts.nodeIsMissing(node.name)) {
            return;
          }
          var seen = false;
          var subsequentNode = ts.forEachChild(node.parent, function(c) {
            if (seen) {
              return c;
            } else {
              seen = c === node;
            }
          });
          if (subsequentNode) {
            if (subsequentNode.kind === node.kind) {
              var errorNode_1 = subsequentNode.name || subsequentNode;
              if (node.name && subsequentNode.name && node.name.text === subsequentNode.name.text) {
                ts.Debug.assert(node.kind === 141 || node.kind === 140);
                ts.Debug.assert((node.flags & 128) !== (subsequentNode.flags & 128));
                var diagnostic = node.flags & 128 ? ts.Diagnostics.Function_overload_must_be_static : ts.Diagnostics.Function_overload_must_not_be_static;
                error(errorNode_1, diagnostic);
                return;
              } else if (ts.nodeIsPresent(subsequentNode.body)) {
                error(errorNode_1, ts.Diagnostics.Function_implementation_name_must_be_0, ts.declarationNameToString(node.name));
                return;
              }
            }
          }
          var errorNode = node.name || node;
          if (isConstructor) {
            error(errorNode, ts.Diagnostics.Constructor_implementation_is_missing);
          } else {
            if (node.flags & 256) {
              error(errorNode, ts.Diagnostics.All_declarations_of_an_abstract_method_must_be_consecutive);
            } else {
              error(errorNode, ts.Diagnostics.Function_implementation_is_missing_or_not_immediately_following_the_declaration);
            }
          }
        }
        var isExportSymbolInsideModule = symbol.parent && symbol.parent.flags & 1536;
        var duplicateFunctionDeclaration = false;
        var multipleConstructorImplementation = false;
        for (var _i = 0; _i < declarations.length; _i++) {
          var current = declarations[_i];
          var node = current;
          var inAmbientContext = ts.isInAmbientContext(node);
          var inAmbientContextOrInterface = node.parent.kind === 213 || node.parent.kind === 153 || inAmbientContext;
          if (inAmbientContextOrInterface) {
            previousDeclaration = undefined;
          }
          if (node.kind === 211 || node.kind === 141 || node.kind === 140 || node.kind === 142) {
            var currentNodeFlags = getEffectiveDeclarationFlags(node, flagsToCheck);
            someNodeFlags |= currentNodeFlags;
            allNodeFlags &= currentNodeFlags;
            someHaveQuestionToken = someHaveQuestionToken || ts.hasQuestionToken(node);
            allHaveQuestionToken = allHaveQuestionToken && ts.hasQuestionToken(node);
            if (ts.nodeIsPresent(node.body) && bodyDeclaration) {
              if (isConstructor) {
                multipleConstructorImplementation = true;
              } else {
                duplicateFunctionDeclaration = true;
              }
            } else if (!isExportSymbolInsideModule && previousDeclaration && previousDeclaration.parent === node.parent && previousDeclaration.end !== node.pos) {
              reportImplementationExpectedError(previousDeclaration);
            }
            if (ts.nodeIsPresent(node.body)) {
              if (!bodyDeclaration) {
                bodyDeclaration = node;
              }
            } else {
              hasOverloads = true;
            }
            previousDeclaration = node;
            if (!inAmbientContextOrInterface) {
              lastSeenNonAmbientDeclaration = node;
            }
          }
        }
        if (multipleConstructorImplementation) {
          ts.forEach(declarations, function(declaration) {
            error(declaration, ts.Diagnostics.Multiple_constructor_implementations_are_not_allowed);
          });
        }
        if (duplicateFunctionDeclaration) {
          ts.forEach(declarations, function(declaration) {
            error(declaration.name, ts.Diagnostics.Duplicate_function_implementation);
          });
        }
        if (!isExportSymbolInsideModule && lastSeenNonAmbientDeclaration && !lastSeenNonAmbientDeclaration.body && !(lastSeenNonAmbientDeclaration.flags & 256)) {
          reportImplementationExpectedError(lastSeenNonAmbientDeclaration);
        }
        if (hasOverloads) {
          checkFlagAgreementBetweenOverloads(declarations, bodyDeclaration, flagsToCheck, someNodeFlags, allNodeFlags);
          checkQuestionTokenAgreementBetweenOverloads(declarations, bodyDeclaration, someHaveQuestionToken, allHaveQuestionToken);
          if (bodyDeclaration) {
            var signatures = getSignaturesOfSymbol(symbol);
            var bodySignature = getSignatureFromDeclaration(bodyDeclaration);
            if (!bodySignature.hasStringLiterals) {
              for (var _a = 0; _a < signatures.length; _a++) {
                var signature = signatures[_a];
                if (!signature.hasStringLiterals && !isSignatureAssignableTo(bodySignature, signature)) {
                  error(signature.declaration, ts.Diagnostics.Overload_signature_is_not_compatible_with_function_implementation);
                  break;
                }
              }
            }
          }
        }
      }
      function checkExportsOnMergedDeclarations(node) {
        if (!produceDiagnostics) {
          return;
        }
        var symbol = node.localSymbol;
        if (!symbol) {
          symbol = getSymbolOfNode(node);
          if (!(symbol.flags & 7340032)) {
            return;
          }
        }
        if (ts.getDeclarationOfKind(symbol, node.kind) !== node) {
          return;
        }
        var exportedDeclarationSpaces = 0;
        var nonExportedDeclarationSpaces = 0;
        var defaultExportedDeclarationSpaces = 0;
        for (var _i = 0,
            _a = symbol.declarations; _i < _a.length; _i++) {
          var d = _a[_i];
          var declarationSpaces = getDeclarationSpaces(d);
          var effectiveDeclarationFlags = getEffectiveDeclarationFlags(d, 1 | 1024);
          if (effectiveDeclarationFlags & 1) {
            if (effectiveDeclarationFlags & 1024) {
              defaultExportedDeclarationSpaces |= declarationSpaces;
            } else {
              exportedDeclarationSpaces |= declarationSpaces;
            }
          } else {
            nonExportedDeclarationSpaces |= declarationSpaces;
          }
        }
        var nonDefaultExportedDeclarationSpaces = exportedDeclarationSpaces | nonExportedDeclarationSpaces;
        var commonDeclarationSpacesForExportsAndLocals = exportedDeclarationSpaces & nonExportedDeclarationSpaces;
        var commonDeclarationSpacesForDefaultAndNonDefault = defaultExportedDeclarationSpaces & nonDefaultExportedDeclarationSpaces;
        if (commonDeclarationSpacesForExportsAndLocals || commonDeclarationSpacesForDefaultAndNonDefault) {
          for (var _b = 0,
              _c = symbol.declarations; _b < _c.length; _b++) {
            var d = _c[_b];
            var declarationSpaces = getDeclarationSpaces(d);
            if (declarationSpaces & commonDeclarationSpacesForDefaultAndNonDefault) {
              error(d.name, ts.Diagnostics.Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead, ts.declarationNameToString(d.name));
            } else if (declarationSpaces & commonDeclarationSpacesForExportsAndLocals) {
              error(d.name, ts.Diagnostics.Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local, ts.declarationNameToString(d.name));
            }
          }
        }
        function getDeclarationSpaces(d) {
          switch (d.kind) {
            case 213:
              return 2097152;
            case 216:
              return d.name.kind === 9 || ts.getModuleInstanceState(d) !== 0 ? 4194304 | 1048576 : 4194304;
            case 212:
            case 215:
              return 2097152 | 1048576;
            case 219:
              var result = 0;
              var target = resolveAlias(getSymbolOfNode(d));
              ts.forEach(target.declarations, function(d) {
                result |= getDeclarationSpaces(d);
              });
              return result;
            default:
              return 1048576;
          }
        }
      }
      function checkNonThenableType(type, location, message) {
        if (!(type.flags & 1) && isTypeAssignableTo(type, getGlobalThenableType())) {
          if (location) {
            if (!message) {
              message = ts.Diagnostics.Operand_for_await_does_not_have_a_valid_callable_then_member;
            }
            error(location, message);
          }
          return unknownType;
        }
        return type;
      }
      function getPromisedType(promise) {
        if (promise.flags & 1) {
          return undefined;
        }
        if ((promise.flags & 4096) && promise.target === tryGetGlobalPromiseType()) {
          return promise.typeArguments[0];
        }
        var globalPromiseLikeType = getInstantiatedGlobalPromiseLikeType();
        if (globalPromiseLikeType === emptyObjectType || !isTypeAssignableTo(promise, globalPromiseLikeType)) {
          return undefined;
        }
        var thenFunction = getTypeOfPropertyOfType(promise, "then");
        if (thenFunction && (thenFunction.flags & 1)) {
          return undefined;
        }
        var thenSignatures = thenFunction ? getSignaturesOfType(thenFunction, 0) : emptyArray;
        if (thenSignatures.length === 0) {
          return undefined;
        }
        var onfulfilledParameterType = getUnionType(ts.map(thenSignatures, getTypeOfFirstParameterOfSignature));
        if (onfulfilledParameterType.flags & 1) {
          return undefined;
        }
        var onfulfilledParameterSignatures = getSignaturesOfType(onfulfilledParameterType, 0);
        if (onfulfilledParameterSignatures.length === 0) {
          return undefined;
        }
        var valueParameterType = getUnionType(ts.map(onfulfilledParameterSignatures, getTypeOfFirstParameterOfSignature));
        return valueParameterType;
      }
      function getTypeOfFirstParameterOfSignature(signature) {
        return getTypeAtPosition(signature, 0);
      }
      function getAwaitedType(type) {
        return checkAwaitedType(type, undefined, undefined);
      }
      function checkAwaitedType(type, location, message) {
        return checkAwaitedTypeWorker(type);
        function checkAwaitedTypeWorker(type) {
          if (type.flags & 16384) {
            var types = [];
            for (var _i = 0,
                _a = type.types; _i < _a.length; _i++) {
              var constituentType = _a[_i];
              types.push(checkAwaitedTypeWorker(constituentType));
            }
            return getUnionType(types);
          } else {
            var promisedType = getPromisedType(type);
            if (promisedType === undefined) {
              return checkNonThenableType(type, location, message);
            } else {
              if (type.id === promisedType.id || awaitedTypeStack.indexOf(promisedType.id) >= 0) {
                if (location) {
                  error(location, ts.Diagnostics._0_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method, symbolToString(type.symbol));
                }
                return unknownType;
              }
              awaitedTypeStack.push(type.id);
              var awaitedType = checkAwaitedTypeWorker(promisedType);
              awaitedTypeStack.pop();
              return awaitedType;
            }
          }
        }
      }
      function checkAsyncFunctionReturnType(node) {
        var globalPromiseConstructorLikeType = getGlobalPromiseConstructorLikeType();
        if (globalPromiseConstructorLikeType === emptyObjectType) {
          return unknownType;
        }
        var promiseType = getTypeFromTypeNode(node.type);
        if (promiseType === unknownType && compilerOptions.isolatedModules) {
          return unknownType;
        }
        var promiseConstructor = getMergedSymbol(promiseType.symbol);
        if (!promiseConstructor || !symbolIsValue(promiseConstructor)) {
          error(node, ts.Diagnostics.Type_0_is_not_a_valid_async_function_return_type, typeToString(promiseType));
          return unknownType;
        }
        var promiseConstructorType = getTypeOfSymbol(promiseConstructor);
        if (!checkTypeAssignableTo(promiseConstructorType, globalPromiseConstructorLikeType, node, ts.Diagnostics.Type_0_is_not_a_valid_async_function_return_type)) {
          return unknownType;
        }
        var promiseName = ts.getEntityNameFromTypeNode(node.type);
        var root = getFirstIdentifier(promiseName);
        var rootSymbol = getSymbol(node.locals, root.text, 107455);
        if (rootSymbol) {
          error(rootSymbol.valueDeclaration, ts.Diagnostics.Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions, root.text, getFullyQualifiedName(promiseConstructor));
          return unknownType;
        }
        return checkAwaitedType(promiseType, node, ts.Diagnostics.An_async_function_or_method_must_have_a_valid_awaitable_return_type);
      }
      function checkDecorator(node) {
        var signature = getResolvedSignature(node);
        var returnType = getReturnTypeOfSignature(signature);
        if (returnType.flags & 1) {
          return;
        }
        var expectedReturnType;
        var headMessage = getDiagnosticHeadMessageForDecoratorResolution(node);
        var errorInfo;
        switch (node.parent.kind) {
          case 212:
            var classSymbol = getSymbolOfNode(node.parent);
            var classConstructorType = getTypeOfSymbol(classSymbol);
            expectedReturnType = getUnionType([classConstructorType, voidType]);
            break;
          case 136:
            expectedReturnType = voidType;
            errorInfo = ts.chainDiagnosticMessages(errorInfo, ts.Diagnostics.The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any);
            break;
          case 139:
            expectedReturnType = voidType;
            errorInfo = ts.chainDiagnosticMessages(errorInfo, ts.Diagnostics.The_return_type_of_a_property_decorator_function_must_be_either_void_or_any);
            break;
          case 141:
          case 143:
          case 144:
            var methodType = getTypeOfNode(node.parent);
            var descriptorType = createTypedPropertyDescriptorType(methodType);
            expectedReturnType = getUnionType([descriptorType, voidType]);
            break;
        }
        checkTypeAssignableTo(returnType, expectedReturnType, node, headMessage, errorInfo);
      }
      function checkTypeNodeAsExpression(node) {
        if (node && node.kind === 149) {
          var root = getFirstIdentifier(node.typeName);
          var meaning = root.parent.kind === 149 ? 793056 : 1536;
          var rootSymbol = resolveName(root, root.text, meaning | 8388608, undefined, undefined);
          if (rootSymbol && rootSymbol.flags & 8388608) {
            var aliasTarget = resolveAlias(rootSymbol);
            if (aliasTarget.flags & 107455 && !isConstEnumOrConstEnumOnlyModule(resolveAlias(rootSymbol))) {
              markAliasSymbolAsReferenced(rootSymbol);
            }
          }
        }
      }
      function checkTypeAnnotationAsExpression(node) {
        switch (node.kind) {
          case 139:
            checkTypeNodeAsExpression(node.type);
            break;
          case 136:
            checkTypeNodeAsExpression(node.type);
            break;
          case 141:
            checkTypeNodeAsExpression(node.type);
            break;
          case 143:
            checkTypeNodeAsExpression(node.type);
            break;
          case 144:
            checkTypeNodeAsExpression(ts.getSetAccessorTypeAnnotationNode(node));
            break;
        }
      }
      function checkParameterTypeAnnotationsAsExpressions(node) {
        for (var _i = 0,
            _a = node.parameters; _i < _a.length; _i++) {
          var parameter = _a[_i];
          checkTypeAnnotationAsExpression(parameter);
        }
      }
      function checkDecorators(node) {
        if (!node.decorators) {
          return;
        }
        if (!ts.nodeCanBeDecorated(node)) {
          return;
        }
        if (!compilerOptions.experimentalDecorators) {
          error(node, ts.Diagnostics.Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Specify_experimentalDecorators_to_remove_this_warning);
        }
        if (compilerOptions.emitDecoratorMetadata) {
          switch (node.kind) {
            case 212:
              var constructor = ts.getFirstConstructorWithBody(node);
              if (constructor) {
                checkParameterTypeAnnotationsAsExpressions(constructor);
              }
              break;
            case 141:
              checkParameterTypeAnnotationsAsExpressions(node);
            case 144:
            case 143:
            case 139:
            case 136:
              checkTypeAnnotationAsExpression(node);
              break;
          }
        }
        emitDecorate = true;
        if (node.kind === 136) {
          emitParam = true;
        }
        ts.forEach(node.decorators, checkDecorator);
      }
      function checkFunctionDeclaration(node) {
        if (produceDiagnostics) {
          checkFunctionLikeDeclaration(node) || checkGrammarForGenerator(node);
          checkCollisionWithCapturedSuperVariable(node, node.name);
          checkCollisionWithCapturedThisVariable(node, node.name);
          checkCollisionWithRequireExportsInGeneratedCode(node, node.name);
        }
      }
      function checkFunctionLikeDeclaration(node) {
        checkDecorators(node);
        checkSignatureDeclaration(node);
        var isAsync = ts.isAsyncFunctionLike(node);
        if (isAsync) {
          if (!compilerOptions.experimentalAsyncFunctions) {
            error(node, ts.Diagnostics.Experimental_support_for_async_functions_is_a_feature_that_is_subject_to_change_in_a_future_release_Specify_experimentalAsyncFunctions_to_remove_this_warning);
          }
          emitAwaiter = true;
        }
        if (node.name && node.name.kind === 134) {
          checkComputedPropertyName(node.name);
        }
        if (!ts.hasDynamicName(node)) {
          var symbol = getSymbolOfNode(node);
          var localSymbol = node.localSymbol || symbol;
          var firstDeclaration = ts.getDeclarationOfKind(localSymbol, node.kind);
          if (node === firstDeclaration) {
            checkFunctionOrConstructorSymbol(localSymbol);
          }
          if (symbol.parent) {
            if (ts.getDeclarationOfKind(symbol, node.kind) === node) {
              checkFunctionOrConstructorSymbol(symbol);
            }
          }
        }
        checkSourceElement(node.body);
        if (node.type && !isAccessor(node.kind) && !node.asteriskToken) {
          var returnType = getTypeFromTypeNode(node.type);
          var promisedType;
          if (isAsync) {
            promisedType = checkAsyncFunctionReturnType(node);
          }
          checkIfNonVoidFunctionHasReturnExpressionsOrSingleThrowStatment(node, isAsync ? promisedType : returnType);
        }
        if (produceDiagnostics && !node.type) {
          if (compilerOptions.noImplicitAny && ts.nodeIsMissing(node.body) && !isPrivateWithinAmbient(node)) {
            reportImplicitAnyError(node, anyType);
          }
          if (node.asteriskToken && ts.nodeIsPresent(node.body)) {
            getReturnTypeOfSignature(getSignatureFromDeclaration(node));
          }
        }
      }
      function checkBlock(node) {
        if (node.kind === 190) {
          checkGrammarStatementInAmbientContext(node);
        }
        ts.forEach(node.statements, checkSourceElement);
        if (ts.isFunctionBlock(node) || node.kind === 217) {
          checkFunctionAndClassExpressionBodies(node);
        }
      }
      function checkCollisionWithArgumentsInGeneratedCode(node) {
        if (!ts.hasRestParameter(node) || ts.isInAmbientContext(node) || ts.nodeIsMissing(node.body)) {
          return;
        }
        ts.forEach(node.parameters, function(p) {
          if (p.name && !ts.isBindingPattern(p.name) && p.name.text === argumentsSymbol.name) {
            error(p, ts.Diagnostics.Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters);
          }
        });
      }
      function needCollisionCheckForIdentifier(node, identifier, name) {
        if (!(identifier && identifier.text === name)) {
          return false;
        }
        if (node.kind === 139 || node.kind === 138 || node.kind === 141 || node.kind === 140 || node.kind === 143 || node.kind === 144) {
          return false;
        }
        if (ts.isInAmbientContext(node)) {
          return false;
        }
        var root = ts.getRootDeclaration(node);
        if (root.kind === 136 && ts.nodeIsMissing(root.parent.body)) {
          return false;
        }
        return true;
      }
      function checkCollisionWithCapturedThisVariable(node, name) {
        if (needCollisionCheckForIdentifier(node, name, "_this")) {
          potentialThisCollisions.push(node);
        }
      }
      function checkIfThisIsCapturedInEnclosingScope(node) {
        var current = node;
        while (current) {
          if (getNodeCheckFlags(current) & 4) {
            var isDeclaration_1 = node.kind !== 67;
            if (isDeclaration_1) {
              error(node.name, ts.Diagnostics.Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference);
            } else {
              error(node, ts.Diagnostics.Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference);
            }
            return;
          }
          current = current.parent;
        }
      }
      function checkCollisionWithCapturedSuperVariable(node, name) {
        if (!needCollisionCheckForIdentifier(node, name, "_super")) {
          return;
        }
        var enclosingClass = ts.getContainingClass(node);
        if (!enclosingClass || ts.isInAmbientContext(enclosingClass)) {
          return;
        }
        if (ts.getClassExtendsHeritageClauseElement(enclosingClass)) {
          var isDeclaration_2 = node.kind !== 67;
          if (isDeclaration_2) {
            error(node, ts.Diagnostics.Duplicate_identifier_super_Compiler_uses_super_to_capture_base_class_reference);
          } else {
            error(node, ts.Diagnostics.Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference);
          }
        }
      }
      function checkCollisionWithRequireExportsInGeneratedCode(node, name) {
        if (!needCollisionCheckForIdentifier(node, name, "require") && !needCollisionCheckForIdentifier(node, name, "exports")) {
          return;
        }
        if (node.kind === 216 && ts.getModuleInstanceState(node) !== 1) {
          return;
        }
        var parent = getDeclarationContainer(node);
        if (parent.kind === 246 && ts.isExternalModule(parent)) {
          error(name, ts.Diagnostics.Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module, ts.declarationNameToString(name), ts.declarationNameToString(name));
        }
      }
      function checkVarDeclaredNamesNotShadowed(node) {
        if ((ts.getCombinedNodeFlags(node) & 49152) !== 0 || ts.isParameterDeclaration(node)) {
          return;
        }
        if (node.kind === 209 && !node.initializer) {
          return;
        }
        var symbol = getSymbolOfNode(node);
        if (symbol.flags & 1) {
          var localDeclarationSymbol = resolveName(node, node.name.text, 3, undefined, undefined);
          if (localDeclarationSymbol && localDeclarationSymbol !== symbol && localDeclarationSymbol.flags & 2) {
            if (getDeclarationFlagsFromSymbol(localDeclarationSymbol) & 49152) {
              var varDeclList = ts.getAncestor(localDeclarationSymbol.valueDeclaration, 210);
              var container = varDeclList.parent.kind === 191 && varDeclList.parent.parent ? varDeclList.parent.parent : undefined;
              var namesShareScope = container && (container.kind === 190 && ts.isFunctionLike(container.parent) || container.kind === 217 || container.kind === 216 || container.kind === 246);
              if (!namesShareScope) {
                var name_14 = symbolToString(localDeclarationSymbol);
                error(node, ts.Diagnostics.Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1, name_14, name_14);
              }
            }
          }
        }
      }
      function checkParameterInitializer(node) {
        if (ts.getRootDeclaration(node).kind !== 136) {
          return;
        }
        var func = ts.getContainingFunction(node);
        visit(node.initializer);
        function visit(n) {
          if (n.kind === 67) {
            var referencedSymbol = getNodeLinks(n).resolvedSymbol;
            if (referencedSymbol && referencedSymbol !== unknownSymbol && getSymbol(func.locals, referencedSymbol.name, 107455) === referencedSymbol) {
              if (referencedSymbol.valueDeclaration.kind === 136) {
                if (referencedSymbol.valueDeclaration === node) {
                  error(n, ts.Diagnostics.Parameter_0_cannot_be_referenced_in_its_initializer, ts.declarationNameToString(node.name));
                  return;
                }
                if (referencedSymbol.valueDeclaration.pos < node.pos) {
                  return;
                }
              }
              error(n, ts.Diagnostics.Initializer_of_parameter_0_cannot_reference_identifier_1_declared_after_it, ts.declarationNameToString(node.name), ts.declarationNameToString(n));
            }
          } else {
            ts.forEachChild(n, visit);
          }
        }
      }
      function checkVariableLikeDeclaration(node) {
        checkDecorators(node);
        checkSourceElement(node.type);
        if (node.name.kind === 134) {
          checkComputedPropertyName(node.name);
          if (node.initializer) {
            checkExpressionCached(node.initializer);
          }
        }
        if (ts.isBindingPattern(node.name)) {
          ts.forEach(node.name.elements, checkSourceElement);
        }
        if (node.initializer && ts.getRootDeclaration(node).kind === 136 && ts.nodeIsMissing(ts.getContainingFunction(node).body)) {
          error(node, ts.Diagnostics.A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation);
          return;
        }
        if (ts.isBindingPattern(node.name)) {
          if (node.initializer) {
            checkTypeAssignableTo(checkExpressionCached(node.initializer), getWidenedTypeForVariableLikeDeclaration(node), node, undefined);
            checkParameterInitializer(node);
          }
          return;
        }
        var symbol = getSymbolOfNode(node);
        var type = getTypeOfVariableOrParameterOrProperty(symbol);
        if (node === symbol.valueDeclaration) {
          if (node.initializer) {
            checkTypeAssignableTo(checkExpressionCached(node.initializer), type, node, undefined);
            checkParameterInitializer(node);
          }
        } else {
          var declarationType = getWidenedTypeForVariableLikeDeclaration(node);
          if (type !== unknownType && declarationType !== unknownType && !isTypeIdenticalTo(type, declarationType)) {
            error(node.name, ts.Diagnostics.Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2, ts.declarationNameToString(node.name), typeToString(type), typeToString(declarationType));
          }
          if (node.initializer) {
            checkTypeAssignableTo(checkExpressionCached(node.initializer), declarationType, node, undefined);
          }
        }
        if (node.kind !== 139 && node.kind !== 138) {
          checkExportsOnMergedDeclarations(node);
          if (node.kind === 209 || node.kind === 161) {
            checkVarDeclaredNamesNotShadowed(node);
          }
          checkCollisionWithCapturedSuperVariable(node, node.name);
          checkCollisionWithCapturedThisVariable(node, node.name);
          checkCollisionWithRequireExportsInGeneratedCode(node, node.name);
        }
      }
      function checkVariableDeclaration(node) {
        checkGrammarVariableDeclaration(node);
        return checkVariableLikeDeclaration(node);
      }
      function checkBindingElement(node) {
        checkGrammarBindingElement(node);
        return checkVariableLikeDeclaration(node);
      }
      function checkVariableStatement(node) {
        checkGrammarDecorators(node) || checkGrammarModifiers(node) || checkGrammarVariableDeclarationList(node.declarationList) || checkGrammarForDisallowedLetOrConstStatement(node);
        ts.forEach(node.declarationList.declarations, checkSourceElement);
      }
      function checkGrammarDisallowedModifiersOnObjectLiteralExpressionMethod(node) {
        if (node.modifiers && node.parent.kind === 163) {
          if (ts.isAsyncFunctionLike(node)) {
            if (node.modifiers.length > 1) {
              return grammarErrorOnFirstToken(node, ts.Diagnostics.Modifiers_cannot_appear_here);
            }
          } else {
            return grammarErrorOnFirstToken(node, ts.Diagnostics.Modifiers_cannot_appear_here);
          }
        }
      }
      function checkExpressionStatement(node) {
        checkGrammarStatementInAmbientContext(node);
        checkExpression(node.expression);
      }
      function checkIfStatement(node) {
        checkGrammarStatementInAmbientContext(node);
        checkExpression(node.expression);
        checkSourceElement(node.thenStatement);
        checkSourceElement(node.elseStatement);
      }
      function checkDoStatement(node) {
        checkGrammarStatementInAmbientContext(node);
        checkSourceElement(node.statement);
        checkExpression(node.expression);
      }
      function checkWhileStatement(node) {
        checkGrammarStatementInAmbientContext(node);
        checkExpression(node.expression);
        checkSourceElement(node.statement);
      }
      function checkForStatement(node) {
        if (!checkGrammarStatementInAmbientContext(node)) {
          if (node.initializer && node.initializer.kind === 210) {
            checkGrammarVariableDeclarationList(node.initializer);
          }
        }
        if (node.initializer) {
          if (node.initializer.kind === 210) {
            ts.forEach(node.initializer.declarations, checkVariableDeclaration);
          } else {
            checkExpression(node.initializer);
          }
        }
        if (node.condition)
          checkExpression(node.condition);
        if (node.incrementor)
          checkExpression(node.incrementor);
        checkSourceElement(node.statement);
      }
      function checkForOfStatement(node) {
        checkGrammarForInOrForOfStatement(node);
        if (node.initializer.kind === 210) {
          checkForInOrForOfVariableDeclaration(node);
        } else {
          var varExpr = node.initializer;
          var iteratedType = checkRightHandSideOfForOf(node.expression);
          if (varExpr.kind === 162 || varExpr.kind === 163) {
            checkDestructuringAssignment(varExpr, iteratedType || unknownType);
          } else {
            var leftType = checkExpression(varExpr);
            checkReferenceExpression(varExpr, ts.Diagnostics.Invalid_left_hand_side_in_for_of_statement, ts.Diagnostics.The_left_hand_side_of_a_for_of_statement_cannot_be_a_previously_defined_constant);
            if (iteratedType) {
              checkTypeAssignableTo(iteratedType, leftType, varExpr, undefined);
            }
          }
        }
        checkSourceElement(node.statement);
      }
      function checkForInStatement(node) {
        checkGrammarForInOrForOfStatement(node);
        if (node.initializer.kind === 210) {
          var variable = node.initializer.declarations[0];
          if (variable && ts.isBindingPattern(variable.name)) {
            error(variable.name, ts.Diagnostics.The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern);
          }
          checkForInOrForOfVariableDeclaration(node);
        } else {
          var varExpr = node.initializer;
          var leftType = checkExpression(varExpr);
          if (varExpr.kind === 162 || varExpr.kind === 163) {
            error(varExpr, ts.Diagnostics.The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern);
          } else if (!isTypeAnyOrAllConstituentTypesHaveKind(leftType, 258)) {
            error(varExpr, ts.Diagnostics.The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any);
          } else {
            checkReferenceExpression(varExpr, ts.Diagnostics.Invalid_left_hand_side_in_for_in_statement, ts.Diagnostics.The_left_hand_side_of_a_for_in_statement_cannot_be_a_previously_defined_constant);
          }
        }
        var rightType = checkExpression(node.expression);
        if (!isTypeAnyOrAllConstituentTypesHaveKind(rightType, 80896 | 512)) {
          error(node.expression, ts.Diagnostics.The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter);
        }
        checkSourceElement(node.statement);
      }
      function checkForInOrForOfVariableDeclaration(iterationStatement) {
        var variableDeclarationList = iterationStatement.initializer;
        if (variableDeclarationList.declarations.length >= 1) {
          var decl = variableDeclarationList.declarations[0];
          checkVariableDeclaration(decl);
        }
      }
      function checkRightHandSideOfForOf(rhsExpression) {
        var expressionType = getTypeOfExpression(rhsExpression);
        return checkIteratedTypeOrElementType(expressionType, rhsExpression, true);
      }
      function checkIteratedTypeOrElementType(inputType, errorNode, allowStringInput) {
        if (isTypeAny(inputType)) {
          return inputType;
        }
        if (languageVersion >= 2) {
          return checkElementTypeOfIterable(inputType, errorNode);
        }
        if (allowStringInput) {
          return checkElementTypeOfArrayOrString(inputType, errorNode);
        }
        if (isArrayLikeType(inputType)) {
          var indexType = getIndexTypeOfType(inputType, 1);
          if (indexType) {
            return indexType;
          }
        }
        error(errorNode, ts.Diagnostics.Type_0_is_not_an_array_type, typeToString(inputType));
        return unknownType;
      }
      function checkElementTypeOfIterable(iterable, errorNode) {
        var elementType = getElementTypeOfIterable(iterable, errorNode);
        if (errorNode && elementType) {
          checkTypeAssignableTo(iterable, createIterableType(elementType), errorNode);
        }
        return elementType || anyType;
      }
      function getElementTypeOfIterable(type, errorNode) {
        if (isTypeAny(type)) {
          return undefined;
        }
        var typeAsIterable = type;
        if (!typeAsIterable.iterableElementType) {
          if ((type.flags & 4096) && type.target === globalIterableType) {
            typeAsIterable.iterableElementType = type.typeArguments[0];
          } else {
            var iteratorFunction = getTypeOfPropertyOfType(type, ts.getPropertyNameForKnownSymbolName("iterator"));
            if (isTypeAny(iteratorFunction)) {
              return undefined;
            }
            var iteratorFunctionSignatures = iteratorFunction ? getSignaturesOfType(iteratorFunction, 0) : emptyArray;
            if (iteratorFunctionSignatures.length === 0) {
              if (errorNode) {
                error(errorNode, ts.Diagnostics.Type_must_have_a_Symbol_iterator_method_that_returns_an_iterator);
              }
              return undefined;
            }
            typeAsIterable.iterableElementType = getElementTypeOfIterator(getUnionType(ts.map(iteratorFunctionSignatures, getReturnTypeOfSignature)), errorNode);
          }
        }
        return typeAsIterable.iterableElementType;
      }
      function getElementTypeOfIterator(type, errorNode) {
        if (isTypeAny(type)) {
          return undefined;
        }
        var typeAsIterator = type;
        if (!typeAsIterator.iteratorElementType) {
          if ((type.flags & 4096) && type.target === globalIteratorType) {
            typeAsIterator.iteratorElementType = type.typeArguments[0];
          } else {
            var iteratorNextFunction = getTypeOfPropertyOfType(type, "next");
            if (isTypeAny(iteratorNextFunction)) {
              return undefined;
            }
            var iteratorNextFunctionSignatures = iteratorNextFunction ? getSignaturesOfType(iteratorNextFunction, 0) : emptyArray;
            if (iteratorNextFunctionSignatures.length === 0) {
              if (errorNode) {
                error(errorNode, ts.Diagnostics.An_iterator_must_have_a_next_method);
              }
              return undefined;
            }
            var iteratorNextResult = getUnionType(ts.map(iteratorNextFunctionSignatures, getReturnTypeOfSignature));
            if (isTypeAny(iteratorNextResult)) {
              return undefined;
            }
            var iteratorNextValue = getTypeOfPropertyOfType(iteratorNextResult, "value");
            if (!iteratorNextValue) {
              if (errorNode) {
                error(errorNode, ts.Diagnostics.The_type_returned_by_the_next_method_of_an_iterator_must_have_a_value_property);
              }
              return undefined;
            }
            typeAsIterator.iteratorElementType = iteratorNextValue;
          }
        }
        return typeAsIterator.iteratorElementType;
      }
      function getElementTypeOfIterableIterator(type) {
        if (isTypeAny(type)) {
          return undefined;
        }
        if ((type.flags & 4096) && type.target === globalIterableIteratorType) {
          return type.typeArguments[0];
        }
        return getElementTypeOfIterable(type, undefined) || getElementTypeOfIterator(type, undefined);
      }
      function checkElementTypeOfArrayOrString(arrayOrStringType, errorNode) {
        ts.Debug.assert(languageVersion < 2);
        var arrayType = removeTypesFromUnionType(arrayOrStringType, 258, true, true);
        var hasStringConstituent = arrayOrStringType !== arrayType;
        var reportedError = false;
        if (hasStringConstituent) {
          if (languageVersion < 1) {
            error(errorNode, ts.Diagnostics.Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher);
            reportedError = true;
          }
          if (arrayType === emptyObjectType) {
            return stringType;
          }
        }
        if (!isArrayLikeType(arrayType)) {
          if (!reportedError) {
            var diagnostic = hasStringConstituent ? ts.Diagnostics.Type_0_is_not_an_array_type : ts.Diagnostics.Type_0_is_not_an_array_type_or_a_string_type;
            error(errorNode, diagnostic, typeToString(arrayType));
          }
          return hasStringConstituent ? stringType : unknownType;
        }
        var arrayElementType = getIndexTypeOfType(arrayType, 1) || unknownType;
        if (hasStringConstituent) {
          if (arrayElementType.flags & 258) {
            return stringType;
          }
          return getUnionType([arrayElementType, stringType]);
        }
        return arrayElementType;
      }
      function checkBreakOrContinueStatement(node) {
        checkGrammarStatementInAmbientContext(node) || checkGrammarBreakOrContinueStatement(node);
      }
      function isGetAccessorWithAnnotatatedSetAccessor(node) {
        return !!(node.kind === 143 && ts.getSetAccessorTypeAnnotationNode(ts.getDeclarationOfKind(node.symbol, 144)));
      }
      function checkReturnStatement(node) {
        if (!checkGrammarStatementInAmbientContext(node)) {
          var functionBlock = ts.getContainingFunction(node);
          if (!functionBlock) {
            grammarErrorOnFirstToken(node, ts.Diagnostics.A_return_statement_can_only_be_used_within_a_function_body);
          }
        }
        if (node.expression) {
          var func = ts.getContainingFunction(node);
          if (func) {
            var signature = getSignatureFromDeclaration(func);
            var returnType = getReturnTypeOfSignature(signature);
            var exprType = checkExpressionCached(node.expression);
            if (func.asteriskToken) {
              return;
            }
            if (func.kind === 144) {
              error(node.expression, ts.Diagnostics.Setters_cannot_return_a_value);
            } else if (func.kind === 142) {
              if (!isTypeAssignableTo(exprType, returnType)) {
                error(node.expression, ts.Diagnostics.Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class);
              }
            } else if (func.type || isGetAccessorWithAnnotatatedSetAccessor(func) || signature.typePredicate) {
              if (ts.isAsyncFunctionLike(func)) {
                var promisedType = getPromisedType(returnType);
                var awaitedType = checkAwaitedType(exprType, node.expression, ts.Diagnostics.Return_expression_in_async_function_does_not_have_a_valid_callable_then_member);
                checkTypeAssignableTo(awaitedType, promisedType, node.expression);
              } else {
                checkTypeAssignableTo(exprType, returnType, node.expression);
              }
            }
          }
        }
      }
      function checkWithStatement(node) {
        if (!checkGrammarStatementInAmbientContext(node)) {
          if (node.parserContextFlags & 8) {
            grammarErrorOnFirstToken(node, ts.Diagnostics.with_statements_are_not_allowed_in_an_async_function_block);
          }
        }
        checkExpression(node.expression);
        error(node.expression, ts.Diagnostics.All_symbols_within_a_with_block_will_be_resolved_to_any);
      }
      function checkSwitchStatement(node) {
        checkGrammarStatementInAmbientContext(node);
        var firstDefaultClause;
        var hasDuplicateDefaultClause = false;
        var expressionType = checkExpression(node.expression);
        ts.forEach(node.caseBlock.clauses, function(clause) {
          if (clause.kind === 240 && !hasDuplicateDefaultClause) {
            if (firstDefaultClause === undefined) {
              firstDefaultClause = clause;
            } else {
              var sourceFile = ts.getSourceFileOfNode(node);
              var start = ts.skipTrivia(sourceFile.text, clause.pos);
              var end = clause.statements.length > 0 ? clause.statements[0].pos : clause.end;
              grammarErrorAtPos(sourceFile, start, end - start, ts.Diagnostics.A_default_clause_cannot_appear_more_than_once_in_a_switch_statement);
              hasDuplicateDefaultClause = true;
            }
          }
          if (produceDiagnostics && clause.kind === 239) {
            var caseClause = clause;
            var caseType = checkExpression(caseClause.expression);
            if (!isTypeAssignableTo(expressionType, caseType)) {
              checkTypeAssignableTo(caseType, expressionType, caseClause.expression, undefined);
            }
          }
          ts.forEach(clause.statements, checkSourceElement);
        });
      }
      function checkLabeledStatement(node) {
        if (!checkGrammarStatementInAmbientContext(node)) {
          var current = node.parent;
          while (current) {
            if (ts.isFunctionLike(current)) {
              break;
            }
            if (current.kind === 205 && current.label.text === node.label.text) {
              var sourceFile = ts.getSourceFileOfNode(node);
              grammarErrorOnNode(node.label, ts.Diagnostics.Duplicate_label_0, ts.getTextOfNodeFromSourceText(sourceFile.text, node.label));
              break;
            }
            current = current.parent;
          }
        }
        checkSourceElement(node.statement);
      }
      function checkThrowStatement(node) {
        if (!checkGrammarStatementInAmbientContext(node)) {
          if (node.expression === undefined) {
            grammarErrorAfterFirstToken(node, ts.Diagnostics.Line_break_not_permitted_here);
          }
        }
        if (node.expression) {
          checkExpression(node.expression);
        }
      }
      function checkTryStatement(node) {
        checkGrammarStatementInAmbientContext(node);
        checkBlock(node.tryBlock);
        var catchClause = node.catchClause;
        if (catchClause) {
          if (catchClause.variableDeclaration) {
            if (catchClause.variableDeclaration.name.kind !== 67) {
              grammarErrorOnFirstToken(catchClause.variableDeclaration.name, ts.Diagnostics.Catch_clause_variable_name_must_be_an_identifier);
            } else if (catchClause.variableDeclaration.type) {
              grammarErrorOnFirstToken(catchClause.variableDeclaration.type, ts.Diagnostics.Catch_clause_variable_cannot_have_a_type_annotation);
            } else if (catchClause.variableDeclaration.initializer) {
              grammarErrorOnFirstToken(catchClause.variableDeclaration.initializer, ts.Diagnostics.Catch_clause_variable_cannot_have_an_initializer);
            } else {
              var identifierName = catchClause.variableDeclaration.name.text;
              var locals = catchClause.block.locals;
              if (locals && ts.hasProperty(locals, identifierName)) {
                var localSymbol = locals[identifierName];
                if (localSymbol && (localSymbol.flags & 2) !== 0) {
                  grammarErrorOnNode(localSymbol.valueDeclaration, ts.Diagnostics.Cannot_redeclare_identifier_0_in_catch_clause, identifierName);
                }
              }
            }
          }
          checkBlock(catchClause.block);
        }
        if (node.finallyBlock) {
          checkBlock(node.finallyBlock);
        }
      }
      function checkIndexConstraints(type) {
        var declaredNumberIndexer = getIndexDeclarationOfSymbol(type.symbol, 1);
        var declaredStringIndexer = getIndexDeclarationOfSymbol(type.symbol, 0);
        var stringIndexType = getIndexTypeOfType(type, 0);
        var numberIndexType = getIndexTypeOfType(type, 1);
        if (stringIndexType || numberIndexType) {
          ts.forEach(getPropertiesOfObjectType(type), function(prop) {
            var propType = getTypeOfSymbol(prop);
            checkIndexConstraintForProperty(prop, propType, type, declaredStringIndexer, stringIndexType, 0);
            checkIndexConstraintForProperty(prop, propType, type, declaredNumberIndexer, numberIndexType, 1);
          });
          if (type.flags & 1024 && ts.isClassLike(type.symbol.valueDeclaration)) {
            var classDeclaration = type.symbol.valueDeclaration;
            for (var _i = 0,
                _a = classDeclaration.members; _i < _a.length; _i++) {
              var member = _a[_i];
              if (!(member.flags & 128) && ts.hasDynamicName(member)) {
                var propType = getTypeOfSymbol(member.symbol);
                checkIndexConstraintForProperty(member.symbol, propType, type, declaredStringIndexer, stringIndexType, 0);
                checkIndexConstraintForProperty(member.symbol, propType, type, declaredNumberIndexer, numberIndexType, 1);
              }
            }
          }
        }
        var errorNode;
        if (stringIndexType && numberIndexType) {
          errorNode = declaredNumberIndexer || declaredStringIndexer;
          if (!errorNode && (type.flags & 2048)) {
            var someBaseTypeHasBothIndexers = ts.forEach(getBaseTypes(type), function(base) {
              return getIndexTypeOfType(base, 0) && getIndexTypeOfType(base, 1);
            });
            errorNode = someBaseTypeHasBothIndexers ? undefined : type.symbol.declarations[0];
          }
        }
        if (errorNode && !isTypeAssignableTo(numberIndexType, stringIndexType)) {
          error(errorNode, ts.Diagnostics.Numeric_index_type_0_is_not_assignable_to_string_index_type_1, typeToString(numberIndexType), typeToString(stringIndexType));
        }
        function checkIndexConstraintForProperty(prop, propertyType, containingType, indexDeclaration, indexType, indexKind) {
          if (!indexType) {
            return;
          }
          if (indexKind === 1 && !isNumericName(prop.valueDeclaration.name)) {
            return;
          }
          var errorNode;
          if (prop.valueDeclaration.name.kind === 134 || prop.parent === containingType.symbol) {
            errorNode = prop.valueDeclaration;
          } else if (indexDeclaration) {
            errorNode = indexDeclaration;
          } else if (containingType.flags & 2048) {
            var someBaseClassHasBothPropertyAndIndexer = ts.forEach(getBaseTypes(containingType), function(base) {
              return getPropertyOfObjectType(base, prop.name) && getIndexTypeOfType(base, indexKind);
            });
            errorNode = someBaseClassHasBothPropertyAndIndexer ? undefined : containingType.symbol.declarations[0];
          }
          if (errorNode && !isTypeAssignableTo(propertyType, indexType)) {
            var errorMessage = indexKind === 0 ? ts.Diagnostics.Property_0_of_type_1_is_not_assignable_to_string_index_type_2 : ts.Diagnostics.Property_0_of_type_1_is_not_assignable_to_numeric_index_type_2;
            error(errorNode, errorMessage, symbolToString(prop), typeToString(propertyType), typeToString(indexType));
          }
        }
      }
      function checkTypeNameIsReserved(name, message) {
        switch (name.text) {
          case "any":
          case "number":
          case "boolean":
          case "string":
          case "symbol":
          case "void":
            error(name, message, name.text);
        }
      }
      function checkTypeParameters(typeParameterDeclarations) {
        if (typeParameterDeclarations) {
          for (var i = 0,
              n = typeParameterDeclarations.length; i < n; i++) {
            var node = typeParameterDeclarations[i];
            checkTypeParameter(node);
            if (produceDiagnostics) {
              for (var j = 0; j < i; j++) {
                if (typeParameterDeclarations[j].symbol === node.symbol) {
                  error(node.name, ts.Diagnostics.Duplicate_identifier_0, ts.declarationNameToString(node.name));
                }
              }
            }
          }
        }
      }
      function checkClassExpression(node) {
        checkClassLikeDeclaration(node);
        return getTypeOfSymbol(getSymbolOfNode(node));
      }
      function checkClassDeclaration(node) {
        if (!node.name && !(node.flags & 1024)) {
          grammarErrorOnFirstToken(node, ts.Diagnostics.A_class_declaration_without_the_default_modifier_must_have_a_name);
        }
        checkClassLikeDeclaration(node);
        if (getSymbolOfNode(node).flags & 64 && !ts.isInAmbientContext(node)) {
          error(node, ts.Diagnostics.Only_an_ambient_class_can_be_merged_with_an_interface);
        }
        ts.forEach(node.members, checkSourceElement);
      }
      function checkClassLikeDeclaration(node) {
        checkGrammarClassDeclarationHeritageClauses(node);
        checkDecorators(node);
        if (node.name) {
          checkTypeNameIsReserved(node.name, ts.Diagnostics.Class_name_cannot_be_0);
          checkCollisionWithCapturedThisVariable(node, node.name);
          checkCollisionWithRequireExportsInGeneratedCode(node, node.name);
        }
        checkTypeParameters(node.typeParameters);
        checkExportsOnMergedDeclarations(node);
        var symbol = getSymbolOfNode(node);
        var type = getDeclaredTypeOfSymbol(symbol);
        var staticType = getTypeOfSymbol(symbol);
        var baseTypeNode = ts.getClassExtendsHeritageClauseElement(node);
        if (baseTypeNode) {
          emitExtends = emitExtends || !ts.isInAmbientContext(node);
          var baseTypes = getBaseTypes(type);
          if (baseTypes.length && produceDiagnostics) {
            var baseType = baseTypes[0];
            var staticBaseType = getBaseConstructorTypeOfClass(type);
            checkSourceElement(baseTypeNode.expression);
            if (baseTypeNode.typeArguments) {
              ts.forEach(baseTypeNode.typeArguments, checkSourceElement);
              for (var _i = 0,
                  _a = getConstructorsForTypeArguments(staticBaseType, baseTypeNode.typeArguments); _i < _a.length; _i++) {
                var constructor = _a[_i];
                if (!checkTypeArgumentConstraints(constructor.typeParameters, baseTypeNode.typeArguments)) {
                  break;
                }
              }
            }
            checkTypeAssignableTo(type, baseType, node.name || node, ts.Diagnostics.Class_0_incorrectly_extends_base_class_1);
            checkTypeAssignableTo(staticType, getTypeWithoutSignatures(staticBaseType), node.name || node, ts.Diagnostics.Class_static_side_0_incorrectly_extends_base_class_static_side_1);
            if (!(staticBaseType.symbol && staticBaseType.symbol.flags & 32)) {
              var constructors = getInstantiatedConstructorsForTypeArguments(staticBaseType, baseTypeNode.typeArguments);
              if (ts.forEach(constructors, function(sig) {
                return getReturnTypeOfSignature(sig) !== baseType;
              })) {
                error(baseTypeNode.expression, ts.Diagnostics.Base_constructors_must_all_have_the_same_return_type);
              }
            }
            checkKindsOfPropertyMemberOverrides(type, baseType);
          }
        }
        var implementedTypeNodes = ts.getClassImplementsHeritageClauseElements(node);
        if (implementedTypeNodes) {
          ts.forEach(implementedTypeNodes, function(typeRefNode) {
            if (!ts.isSupportedExpressionWithTypeArguments(typeRefNode)) {
              error(typeRefNode.expression, ts.Diagnostics.A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments);
            }
            checkTypeReferenceNode(typeRefNode);
            if (produceDiagnostics) {
              var t = getTypeFromTypeNode(typeRefNode);
              if (t !== unknownType) {
                var declaredType = (t.flags & 4096) ? t.target : t;
                if (declaredType.flags & (1024 | 2048)) {
                  checkTypeAssignableTo(type, t, node.name || node, ts.Diagnostics.Class_0_incorrectly_implements_interface_1);
                } else {
                  error(typeRefNode, ts.Diagnostics.A_class_may_only_implement_another_class_or_interface);
                }
              }
            }
          });
        }
        if (produceDiagnostics) {
          checkIndexConstraints(type);
          checkTypeForDuplicateIndexSignatures(node);
        }
      }
      function getTargetSymbol(s) {
        return s.flags & 16777216 ? getSymbolLinks(s).target : s;
      }
      function checkKindsOfPropertyMemberOverrides(type, baseType) {
        var baseProperties = getPropertiesOfObjectType(baseType);
        for (var _i = 0; _i < baseProperties.length; _i++) {
          var baseProperty = baseProperties[_i];
          var base = getTargetSymbol(baseProperty);
          if (base.flags & 134217728) {
            continue;
          }
          var derived = getTargetSymbol(getPropertyOfObjectType(type, base.name));
          var baseDeclarationFlags = getDeclarationFlagsFromSymbol(base);
          ts.Debug.assert(!!derived, "derived should point to something, even if it is the base class' declaration.");
          if (derived) {
            if (derived === base) {
              var derivedClassDecl = ts.getDeclarationOfKind(type.symbol, 212);
              if (baseDeclarationFlags & 256 && (!derivedClassDecl || !(derivedClassDecl.flags & 256))) {
                error(derivedClassDecl, ts.Diagnostics.Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2, typeToString(type), symbolToString(baseProperty), typeToString(baseType));
              }
            } else {
              var derivedDeclarationFlags = getDeclarationFlagsFromSymbol(derived);
              if ((baseDeclarationFlags & 32) || (derivedDeclarationFlags & 32)) {
                continue;
              }
              if ((baseDeclarationFlags & 128) !== (derivedDeclarationFlags & 128)) {
                continue;
              }
              if ((base.flags & derived.flags & 8192) || ((base.flags & 98308) && (derived.flags & 98308))) {
                continue;
              }
              var errorMessage = void 0;
              if (base.flags & 8192) {
                if (derived.flags & 98304) {
                  errorMessage = ts.Diagnostics.Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor;
                } else {
                  ts.Debug.assert((derived.flags & 4) !== 0);
                  errorMessage = ts.Diagnostics.Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_property;
                }
              } else if (base.flags & 4) {
                ts.Debug.assert((derived.flags & 8192) !== 0);
                errorMessage = ts.Diagnostics.Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function;
              } else {
                ts.Debug.assert((base.flags & 98304) !== 0);
                ts.Debug.assert((derived.flags & 8192) !== 0);
                errorMessage = ts.Diagnostics.Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function;
              }
              error(derived.valueDeclaration.name, errorMessage, typeToString(baseType), symbolToString(base), typeToString(type));
            }
          }
        }
      }
      function isAccessor(kind) {
        return kind === 143 || kind === 144;
      }
      function areTypeParametersIdentical(list1, list2) {
        if (!list1 && !list2) {
          return true;
        }
        if (!list1 || !list2 || list1.length !== list2.length) {
          return false;
        }
        for (var i = 0,
            len = list1.length; i < len; i++) {
          var tp1 = list1[i];
          var tp2 = list2[i];
          if (tp1.name.text !== tp2.name.text) {
            return false;
          }
          if (!tp1.constraint && !tp2.constraint) {
            continue;
          }
          if (!tp1.constraint || !tp2.constraint) {
            return false;
          }
          if (!isTypeIdenticalTo(getTypeFromTypeNode(tp1.constraint), getTypeFromTypeNode(tp2.constraint))) {
            return false;
          }
        }
        return true;
      }
      function checkInheritedPropertiesAreIdentical(type, typeNode) {
        var baseTypes = getBaseTypes(type);
        if (baseTypes.length < 2) {
          return true;
        }
        var seen = {};
        ts.forEach(resolveDeclaredMembers(type).declaredProperties, function(p) {
          seen[p.name] = {
            prop: p,
            containingType: type
          };
        });
        var ok = true;
        for (var _i = 0; _i < baseTypes.length; _i++) {
          var base = baseTypes[_i];
          var properties = getPropertiesOfObjectType(base);
          for (var _a = 0; _a < properties.length; _a++) {
            var prop = properties[_a];
            if (!ts.hasProperty(seen, prop.name)) {
              seen[prop.name] = {
                prop: prop,
                containingType: base
              };
            } else {
              var existing = seen[prop.name];
              var isInheritedProperty = existing.containingType !== type;
              if (isInheritedProperty && !isPropertyIdenticalTo(existing.prop, prop)) {
                ok = false;
                var typeName1 = typeToString(existing.containingType);
                var typeName2 = typeToString(base);
                var errorInfo = ts.chainDiagnosticMessages(undefined, ts.Diagnostics.Named_property_0_of_types_1_and_2_are_not_identical, symbolToString(prop), typeName1, typeName2);
                errorInfo = ts.chainDiagnosticMessages(errorInfo, ts.Diagnostics.Interface_0_cannot_simultaneously_extend_types_1_and_2, typeToString(type), typeName1, typeName2);
                diagnostics.add(ts.createDiagnosticForNodeFromMessageChain(typeNode, errorInfo));
              }
            }
          }
        }
        return ok;
      }
      function checkInterfaceDeclaration(node) {
        checkGrammarDecorators(node) || checkGrammarModifiers(node) || checkGrammarInterfaceDeclaration(node);
        checkTypeParameters(node.typeParameters);
        if (produceDiagnostics) {
          checkTypeNameIsReserved(node.name, ts.Diagnostics.Interface_name_cannot_be_0);
          checkExportsOnMergedDeclarations(node);
          var symbol = getSymbolOfNode(node);
          var firstInterfaceDecl = ts.getDeclarationOfKind(symbol, 213);
          if (symbol.declarations.length > 1) {
            if (node !== firstInterfaceDecl && !areTypeParametersIdentical(firstInterfaceDecl.typeParameters, node.typeParameters)) {
              error(node.name, ts.Diagnostics.All_declarations_of_an_interface_must_have_identical_type_parameters);
            }
          }
          if (node === firstInterfaceDecl) {
            var type = getDeclaredTypeOfSymbol(symbol);
            if (checkInheritedPropertiesAreIdentical(type, node.name)) {
              ts.forEach(getBaseTypes(type), function(baseType) {
                checkTypeAssignableTo(type, baseType, node.name, ts.Diagnostics.Interface_0_incorrectly_extends_interface_1);
              });
              checkIndexConstraints(type);
            }
          }
          if (symbol && symbol.declarations) {
            for (var _i = 0,
                _a = symbol.declarations; _i < _a.length; _i++) {
              var declaration = _a[_i];
              if (declaration.kind === 212 && !ts.isInAmbientContext(declaration)) {
                error(node, ts.Diagnostics.Only_an_ambient_class_can_be_merged_with_an_interface);
                break;
              }
            }
          }
        }
        ts.forEach(ts.getInterfaceBaseTypeNodes(node), function(heritageElement) {
          if (!ts.isSupportedExpressionWithTypeArguments(heritageElement)) {
            error(heritageElement.expression, ts.Diagnostics.An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments);
          }
          checkTypeReferenceNode(heritageElement);
        });
        ts.forEach(node.members, checkSourceElement);
        if (produceDiagnostics) {
          checkTypeForDuplicateIndexSignatures(node);
        }
      }
      function checkTypeAliasDeclaration(node) {
        checkGrammarDecorators(node) || checkGrammarModifiers(node);
        checkTypeNameIsReserved(node.name, ts.Diagnostics.Type_alias_name_cannot_be_0);
        checkSourceElement(node.type);
      }
      function computeEnumMemberValues(node) {
        var nodeLinks = getNodeLinks(node);
        if (!(nodeLinks.flags & 8192)) {
          var enumSymbol = getSymbolOfNode(node);
          var enumType = getDeclaredTypeOfSymbol(enumSymbol);
          var autoValue = 0;
          var ambient = ts.isInAmbientContext(node);
          var enumIsConst = ts.isConst(node);
          ts.forEach(node.members, function(member) {
            if (member.name.kind !== 134 && isNumericLiteralName(member.name.text)) {
              error(member.name, ts.Diagnostics.An_enum_member_cannot_have_a_numeric_name);
            }
            var initializer = member.initializer;
            if (initializer) {
              autoValue = computeConstantValueForEnumMemberInitializer(initializer, enumType, enumIsConst, ambient);
            } else if (ambient && !enumIsConst) {
              autoValue = undefined;
            }
            if (autoValue !== undefined) {
              getNodeLinks(member).enumMemberValue = autoValue++;
            }
          });
          nodeLinks.flags |= 8192;
        }
        function computeConstantValueForEnumMemberInitializer(initializer, enumType, enumIsConst, ambient) {
          var reportError = true;
          var value = evalConstant(initializer);
          if (reportError) {
            if (value === undefined) {
              if (enumIsConst) {
                error(initializer, ts.Diagnostics.In_const_enum_declarations_member_initializer_must_be_constant_expression);
              } else if (!ambient) {
                checkTypeAssignableTo(checkExpression(initializer), enumType, initializer, undefined);
              }
            } else if (enumIsConst) {
              if (isNaN(value)) {
                error(initializer, ts.Diagnostics.const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN);
              } else if (!isFinite(value)) {
                error(initializer, ts.Diagnostics.const_enum_member_initializer_was_evaluated_to_a_non_finite_value);
              }
            }
          }
          return value;
          function evalConstant(e) {
            switch (e.kind) {
              case 177:
                var value_1 = evalConstant(e.operand);
                if (value_1 === undefined) {
                  return undefined;
                }
                switch (e.operator) {
                  case 35:
                    return value_1;
                  case 36:
                    return -value_1;
                  case 49:
                    return ~value_1;
                }
                return undefined;
              case 179:
                var left = evalConstant(e.left);
                if (left === undefined) {
                  return undefined;
                }
                var right = evalConstant(e.right);
                if (right === undefined) {
                  return undefined;
                }
                switch (e.operatorToken.kind) {
                  case 46:
                    return left | right;
                  case 45:
                    return left & right;
                  case 43:
                    return left >> right;
                  case 44:
                    return left >>> right;
                  case 42:
                    return left << right;
                  case 47:
                    return left ^ right;
                  case 37:
                    return left * right;
                  case 38:
                    return left / right;
                  case 35:
                    return left + right;
                  case 36:
                    return left - right;
                  case 39:
                    return left % right;
                }
                return undefined;
              case 8:
                return +e.text;
              case 170:
                return evalConstant(e.expression);
              case 67:
              case 165:
              case 164:
                var member = initializer.parent;
                var currentType = getTypeOfSymbol(getSymbolOfNode(member.parent));
                var enumType_1;
                var propertyName;
                if (e.kind === 67) {
                  enumType_1 = currentType;
                  propertyName = e.text;
                } else {
                  var expression;
                  if (e.kind === 165) {
                    if (e.argumentExpression === undefined || e.argumentExpression.kind !== 9) {
                      return undefined;
                    }
                    expression = e.expression;
                    propertyName = e.argumentExpression.text;
                  } else {
                    expression = e.expression;
                    propertyName = e.name.text;
                  }
                  var current = expression;
                  while (current) {
                    if (current.kind === 67) {
                      break;
                    } else if (current.kind === 164) {
                      current = current.expression;
                    } else {
                      return undefined;
                    }
                  }
                  enumType_1 = checkExpression(expression);
                  if (!(enumType_1.symbol && (enumType_1.symbol.flags & 384))) {
                    return undefined;
                  }
                }
                if (propertyName === undefined) {
                  return undefined;
                }
                var property = getPropertyOfObjectType(enumType_1, propertyName);
                if (!property || !(property.flags & 8)) {
                  return undefined;
                }
                var propertyDecl = property.valueDeclaration;
                if (member === propertyDecl) {
                  return undefined;
                }
                if (!isDefinedBefore(propertyDecl, member)) {
                  reportError = false;
                  error(e, ts.Diagnostics.A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums);
                  return undefined;
                }
                return getNodeLinks(propertyDecl).enumMemberValue;
            }
          }
        }
      }
      function checkEnumDeclaration(node) {
        if (!produceDiagnostics) {
          return;
        }
        checkGrammarDecorators(node) || checkGrammarModifiers(node) || checkGrammarEnumDeclaration(node);
        checkTypeNameIsReserved(node.name, ts.Diagnostics.Enum_name_cannot_be_0);
        checkCollisionWithCapturedThisVariable(node, node.name);
        checkCollisionWithRequireExportsInGeneratedCode(node, node.name);
        checkExportsOnMergedDeclarations(node);
        computeEnumMemberValues(node);
        var enumIsConst = ts.isConst(node);
        if (compilerOptions.isolatedModules && enumIsConst && ts.isInAmbientContext(node)) {
          error(node.name, ts.Diagnostics.Ambient_const_enums_are_not_allowed_when_the_isolatedModules_flag_is_provided);
        }
        var enumSymbol = getSymbolOfNode(node);
        var firstDeclaration = ts.getDeclarationOfKind(enumSymbol, node.kind);
        if (node === firstDeclaration) {
          if (enumSymbol.declarations.length > 1) {
            ts.forEach(enumSymbol.declarations, function(decl) {
              if (ts.isConstEnumDeclaration(decl) !== enumIsConst) {
                error(decl.name, ts.Diagnostics.Enum_declarations_must_all_be_const_or_non_const);
              }
            });
          }
          var seenEnumMissingInitialInitializer = false;
          ts.forEach(enumSymbol.declarations, function(declaration) {
            if (declaration.kind !== 215) {
              return false;
            }
            var enumDeclaration = declaration;
            if (!enumDeclaration.members.length) {
              return false;
            }
            var firstEnumMember = enumDeclaration.members[0];
            if (!firstEnumMember.initializer) {
              if (seenEnumMissingInitialInitializer) {
                error(firstEnumMember.name, ts.Diagnostics.In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element);
              } else {
                seenEnumMissingInitialInitializer = true;
              }
            }
          });
        }
      }
      function getFirstNonAmbientClassOrFunctionDeclaration(symbol) {
        var declarations = symbol.declarations;
        for (var _i = 0; _i < declarations.length; _i++) {
          var declaration = declarations[_i];
          if ((declaration.kind === 212 || (declaration.kind === 211 && ts.nodeIsPresent(declaration.body))) && !ts.isInAmbientContext(declaration)) {
            return declaration;
          }
        }
        return undefined;
      }
      function inSameLexicalScope(node1, node2) {
        var container1 = ts.getEnclosingBlockScopeContainer(node1);
        var container2 = ts.getEnclosingBlockScopeContainer(node2);
        if (isGlobalSourceFile(container1)) {
          return isGlobalSourceFile(container2);
        } else if (isGlobalSourceFile(container2)) {
          return false;
        } else {
          return container1 === container2;
        }
      }
      function checkModuleDeclaration(node) {
        if (produceDiagnostics) {
          var isAmbientExternalModule = node.name.kind === 9;
          var contextErrorMessage = isAmbientExternalModule ? ts.Diagnostics.An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file : ts.Diagnostics.A_namespace_declaration_is_only_allowed_in_a_namespace_or_module;
          if (checkGrammarModuleElementContext(node, contextErrorMessage)) {
            return;
          }
          if (!checkGrammarDecorators(node) && !checkGrammarModifiers(node)) {
            if (!ts.isInAmbientContext(node) && node.name.kind === 9) {
              grammarErrorOnNode(node.name, ts.Diagnostics.Only_ambient_modules_can_use_quoted_names);
            }
          }
          checkCollisionWithCapturedThisVariable(node, node.name);
          checkCollisionWithRequireExportsInGeneratedCode(node, node.name);
          checkExportsOnMergedDeclarations(node);
          var symbol = getSymbolOfNode(node);
          if (symbol.flags & 512 && symbol.declarations.length > 1 && !ts.isInAmbientContext(node) && ts.isInstantiatedModule(node, compilerOptions.preserveConstEnums || compilerOptions.isolatedModules)) {
            var firstNonAmbientClassOrFunc = getFirstNonAmbientClassOrFunctionDeclaration(symbol);
            if (firstNonAmbientClassOrFunc) {
              if (ts.getSourceFileOfNode(node) !== ts.getSourceFileOfNode(firstNonAmbientClassOrFunc)) {
                error(node.name, ts.Diagnostics.A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged);
              } else if (node.pos < firstNonAmbientClassOrFunc.pos) {
                error(node.name, ts.Diagnostics.A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged);
              }
            }
            var mergedClass = ts.getDeclarationOfKind(symbol, 212);
            if (mergedClass && inSameLexicalScope(node, mergedClass)) {
              getNodeLinks(node).flags |= 32768;
            }
          }
          if (isAmbientExternalModule) {
            if (!isGlobalSourceFile(node.parent)) {
              error(node.name, ts.Diagnostics.Ambient_modules_cannot_be_nested_in_other_modules);
            }
            if (isExternalModuleNameRelative(node.name.text)) {
              error(node.name, ts.Diagnostics.Ambient_module_declaration_cannot_specify_relative_module_name);
            }
          }
        }
        checkSourceElement(node.body);
      }
      function getFirstIdentifier(node) {
        while (true) {
          if (node.kind === 133) {
            node = node.left;
          } else if (node.kind === 164) {
            node = node.expression;
          } else {
            break;
          }
        }
        ts.Debug.assert(node.kind === 67);
        return node;
      }
      function checkExternalImportOrExportDeclaration(node) {
        var moduleName = ts.getExternalModuleName(node);
        if (!ts.nodeIsMissing(moduleName) && moduleName.kind !== 9) {
          error(moduleName, ts.Diagnostics.String_literal_expected);
          return false;
        }
        var inAmbientExternalModule = node.parent.kind === 217 && node.parent.parent.name.kind === 9;
        if (node.parent.kind !== 246 && !inAmbientExternalModule) {
          error(moduleName, node.kind === 226 ? ts.Diagnostics.Export_declarations_are_not_permitted_in_a_namespace : ts.Diagnostics.Import_declarations_in_a_namespace_cannot_reference_a_module);
          return false;
        }
        if (inAmbientExternalModule && isExternalModuleNameRelative(moduleName.text)) {
          error(node, ts.Diagnostics.Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name);
          return false;
        }
        return true;
      }
      function checkAliasSymbol(node) {
        var symbol = getSymbolOfNode(node);
        var target = resolveAlias(symbol);
        if (target !== unknownSymbol) {
          var excludedMeanings = (symbol.flags & 107455 ? 107455 : 0) | (symbol.flags & 793056 ? 793056 : 0) | (symbol.flags & 1536 ? 1536 : 0);
          if (target.flags & excludedMeanings) {
            var message = node.kind === 228 ? ts.Diagnostics.Export_declaration_conflicts_with_exported_declaration_of_0 : ts.Diagnostics.Import_declaration_conflicts_with_local_declaration_of_0;
            error(node, message, symbolToString(symbol));
          }
        }
      }
      function checkImportBinding(node) {
        checkCollisionWithCapturedThisVariable(node, node.name);
        checkCollisionWithRequireExportsInGeneratedCode(node, node.name);
        checkAliasSymbol(node);
      }
      function checkImportDeclaration(node) {
        if (checkGrammarModuleElementContext(node, ts.Diagnostics.An_import_declaration_can_only_be_used_in_a_namespace_or_module)) {
          return;
        }
        if (!checkGrammarDecorators(node) && !checkGrammarModifiers(node) && (node.flags & 2035)) {
          grammarErrorOnFirstToken(node, ts.Diagnostics.An_import_declaration_cannot_have_modifiers);
        }
        if (checkExternalImportOrExportDeclaration(node)) {
          var importClause = node.importClause;
          if (importClause) {
            if (importClause.name) {
              checkImportBinding(importClause);
            }
            if (importClause.namedBindings) {
              if (importClause.namedBindings.kind === 222) {
                checkImportBinding(importClause.namedBindings);
              } else {
                ts.forEach(importClause.namedBindings.elements, checkImportBinding);
              }
            }
          }
        }
      }
      function checkImportEqualsDeclaration(node) {
        if (checkGrammarModuleElementContext(node, ts.Diagnostics.An_import_declaration_can_only_be_used_in_a_namespace_or_module)) {
          return;
        }
        checkGrammarDecorators(node) || checkGrammarModifiers(node);
        if (ts.isInternalModuleImportEqualsDeclaration(node) || checkExternalImportOrExportDeclaration(node)) {
          checkImportBinding(node);
          if (node.flags & 1) {
            markExportAsReferenced(node);
          }
          if (ts.isInternalModuleImportEqualsDeclaration(node)) {
            var target = resolveAlias(getSymbolOfNode(node));
            if (target !== unknownSymbol) {
              if (target.flags & 107455) {
                var moduleName = getFirstIdentifier(node.moduleReference);
                if (!(resolveEntityName(moduleName, 107455 | 1536).flags & 1536)) {
                  error(moduleName, ts.Diagnostics.Module_0_is_hidden_by_a_local_declaration_with_the_same_name, ts.declarationNameToString(moduleName));
                }
              }
              if (target.flags & 793056) {
                checkTypeNameIsReserved(node.name, ts.Diagnostics.Import_name_cannot_be_0);
              }
            }
          } else {
            if (languageVersion >= 2 && !ts.isInAmbientContext(node)) {
              grammarErrorOnNode(node, ts.Diagnostics.Import_assignment_cannot_be_used_when_targeting_ECMAScript_6_or_higher_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_or_import_d_from_mod_instead);
            }
          }
        }
      }
      function checkExportDeclaration(node) {
        if (checkGrammarModuleElementContext(node, ts.Diagnostics.An_export_declaration_can_only_be_used_in_a_module)) {
          return;
        }
        if (!checkGrammarDecorators(node) && !checkGrammarModifiers(node) && (node.flags & 2035)) {
          grammarErrorOnFirstToken(node, ts.Diagnostics.An_export_declaration_cannot_have_modifiers);
        }
        if (!node.moduleSpecifier || checkExternalImportOrExportDeclaration(node)) {
          if (node.exportClause) {
            ts.forEach(node.exportClause.elements, checkExportSpecifier);
            var inAmbientExternalModule = node.parent.kind === 217 && node.parent.parent.name.kind === 9;
            if (node.parent.kind !== 246 && !inAmbientExternalModule) {
              error(node, ts.Diagnostics.Export_declarations_are_not_permitted_in_a_namespace);
            }
          } else {
            var moduleSymbol = resolveExternalModuleName(node, node.moduleSpecifier);
            if (moduleSymbol && moduleSymbol.exports["export="]) {
              error(node.moduleSpecifier, ts.Diagnostics.Module_0_uses_export_and_cannot_be_used_with_export_Asterisk, symbolToString(moduleSymbol));
            }
          }
        }
      }
      function checkGrammarModuleElementContext(node, errorMessage) {
        if (node.parent.kind !== 246 && node.parent.kind !== 217 && node.parent.kind !== 216) {
          return grammarErrorOnFirstToken(node, errorMessage);
        }
      }
      function checkExportSpecifier(node) {
        checkAliasSymbol(node);
        if (!node.parent.parent.moduleSpecifier) {
          markExportAsReferenced(node);
        }
      }
      function checkExportAssignment(node) {
        if (checkGrammarModuleElementContext(node, ts.Diagnostics.An_export_assignment_can_only_be_used_in_a_module)) {
          return;
        }
        var container = node.parent.kind === 246 ? node.parent : node.parent.parent;
        if (container.kind === 216 && container.name.kind === 67) {
          error(node, ts.Diagnostics.An_export_assignment_cannot_be_used_in_a_namespace);
          return;
        }
        if (!checkGrammarDecorators(node) && !checkGrammarModifiers(node) && (node.flags & 2035)) {
          grammarErrorOnFirstToken(node, ts.Diagnostics.An_export_assignment_cannot_have_modifiers);
        }
        if (node.expression.kind === 67) {
          markExportAsReferenced(node);
        } else {
          checkExpressionCached(node.expression);
        }
        checkExternalModuleExports(container);
        if (node.isExportEquals && !ts.isInAmbientContext(node)) {
          if (languageVersion >= 2) {
            grammarErrorOnNode(node, ts.Diagnostics.Export_assignment_cannot_be_used_when_targeting_ECMAScript_6_or_higher_Consider_using_export_default_instead);
          } else if (compilerOptions.module === 4) {
            grammarErrorOnNode(node, ts.Diagnostics.Export_assignment_is_not_supported_when_module_flag_is_system);
          }
        }
      }
      function getModuleStatements(node) {
        if (node.kind === 246) {
          return node.statements;
        }
        if (node.kind === 216 && node.body.kind === 217) {
          return node.body.statements;
        }
        return emptyArray;
      }
      function hasExportedMembers(moduleSymbol) {
        for (var id in moduleSymbol.exports) {
          if (id !== "export=") {
            return true;
          }
        }
        return false;
      }
      function checkExternalModuleExports(node) {
        var moduleSymbol = getSymbolOfNode(node);
        var links = getSymbolLinks(moduleSymbol);
        if (!links.exportsChecked) {
          var exportEqualsSymbol = moduleSymbol.exports["export="];
          if (exportEqualsSymbol && hasExportedMembers(moduleSymbol)) {
            var declaration = getDeclarationOfAliasSymbol(exportEqualsSymbol) || exportEqualsSymbol.valueDeclaration;
            error(declaration, ts.Diagnostics.An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements);
          }
          links.exportsChecked = true;
        }
      }
      function checkTypePredicate(node) {
        if (!isInLegalTypePredicatePosition(node)) {
          error(node, ts.Diagnostics.A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods);
        }
      }
      function checkSourceElement(node) {
        if (!node) {
          return;
        }
        var kind = node.kind;
        if (cancellationToken) {
          switch (kind) {
            case 216:
            case 212:
            case 213:
            case 211:
              cancellationToken.throwIfCancellationRequested();
          }
        }
        switch (kind) {
          case 135:
            return checkTypeParameter(node);
          case 136:
            return checkParameter(node);
          case 139:
          case 138:
            return checkPropertyDeclaration(node);
          case 150:
          case 151:
          case 145:
          case 146:
            return checkSignatureDeclaration(node);
          case 147:
            return checkSignatureDeclaration(node);
          case 141:
          case 140:
            return checkMethodDeclaration(node);
          case 142:
            return checkConstructorDeclaration(node);
          case 143:
          case 144:
            return checkAccessorDeclaration(node);
          case 149:
            return checkTypeReferenceNode(node);
          case 148:
            return checkTypePredicate(node);
          case 152:
            return checkTypeQuery(node);
          case 153:
            return checkTypeLiteral(node);
          case 154:
            return checkArrayType(node);
          case 155:
            return checkTupleType(node);
          case 156:
          case 157:
            return checkUnionOrIntersectionType(node);
          case 158:
            return checkSourceElement(node.type);
          case 211:
            return checkFunctionDeclaration(node);
          case 190:
          case 217:
            return checkBlock(node);
          case 191:
            return checkVariableStatement(node);
          case 193:
            return checkExpressionStatement(node);
          case 194:
            return checkIfStatement(node);
          case 195:
            return checkDoStatement(node);
          case 196:
            return checkWhileStatement(node);
          case 197:
            return checkForStatement(node);
          case 198:
            return checkForInStatement(node);
          case 199:
            return checkForOfStatement(node);
          case 200:
          case 201:
            return checkBreakOrContinueStatement(node);
          case 202:
            return checkReturnStatement(node);
          case 203:
            return checkWithStatement(node);
          case 204:
            return checkSwitchStatement(node);
          case 205:
            return checkLabeledStatement(node);
          case 206:
            return checkThrowStatement(node);
          case 207:
            return checkTryStatement(node);
          case 209:
            return checkVariableDeclaration(node);
          case 161:
            return checkBindingElement(node);
          case 212:
            return checkClassDeclaration(node);
          case 213:
            return checkInterfaceDeclaration(node);
          case 214:
            return checkTypeAliasDeclaration(node);
          case 215:
            return checkEnumDeclaration(node);
          case 216:
            return checkModuleDeclaration(node);
          case 220:
            return checkImportDeclaration(node);
          case 219:
            return checkImportEqualsDeclaration(node);
          case 226:
            return checkExportDeclaration(node);
          case 225:
            return checkExportAssignment(node);
          case 192:
            checkGrammarStatementInAmbientContext(node);
            return;
          case 208:
            checkGrammarStatementInAmbientContext(node);
            return;
          case 229:
            return checkMissingDeclaration(node);
        }
      }
      function checkFunctionAndClassExpressionBodies(node) {
        switch (node.kind) {
          case 171:
          case 172:
            ts.forEach(node.parameters, checkFunctionAndClassExpressionBodies);
            checkFunctionExpressionOrObjectLiteralMethodBody(node);
            break;
          case 184:
            ts.forEach(node.members, checkSourceElement);
            break;
          case 141:
          case 140:
            ts.forEach(node.decorators, checkFunctionAndClassExpressionBodies);
            ts.forEach(node.parameters, checkFunctionAndClassExpressionBodies);
            if (ts.isObjectLiteralMethod(node)) {
              checkFunctionExpressionOrObjectLiteralMethodBody(node);
            }
            break;
          case 142:
          case 143:
          case 144:
          case 211:
            ts.forEach(node.parameters, checkFunctionAndClassExpressionBodies);
            break;
          case 203:
            checkFunctionAndClassExpressionBodies(node.expression);
            break;
          case 137:
          case 136:
          case 139:
          case 138:
          case 159:
          case 160:
          case 161:
          case 162:
          case 163:
          case 243:
          case 164:
          case 165:
          case 166:
          case 167:
          case 168:
          case 181:
          case 188:
          case 169:
          case 187:
          case 170:
          case 174:
          case 175:
          case 176:
          case 173:
          case 177:
          case 178:
          case 179:
          case 180:
          case 183:
          case 182:
          case 190:
          case 217:
          case 191:
          case 193:
          case 194:
          case 195:
          case 196:
          case 197:
          case 198:
          case 199:
          case 200:
          case 201:
          case 202:
          case 204:
          case 218:
          case 239:
          case 240:
          case 205:
          case 206:
          case 207:
          case 242:
          case 209:
          case 210:
          case 212:
          case 241:
          case 186:
          case 215:
          case 245:
          case 225:
          case 246:
          case 238:
          case 231:
          case 232:
          case 236:
          case 237:
          case 233:
            ts.forEachChild(node, checkFunctionAndClassExpressionBodies);
            break;
        }
      }
      function checkSourceFile(node) {
        var start = new Date().getTime();
        checkSourceFileWorker(node);
        ts.checkTime += new Date().getTime() - start;
      }
      function checkSourceFileWorker(node) {
        var links = getNodeLinks(node);
        if (!(links.flags & 1)) {
          if (node.isDefaultLib && compilerOptions.skipDefaultLibCheck) {
            return;
          }
          checkGrammarSourceFile(node);
          emitExtends = false;
          emitDecorate = false;
          emitParam = false;
          potentialThisCollisions.length = 0;
          ts.forEach(node.statements, checkSourceElement);
          checkFunctionAndClassExpressionBodies(node);
          if (ts.isExternalModule(node)) {
            checkExternalModuleExports(node);
          }
          if (potentialThisCollisions.length) {
            ts.forEach(potentialThisCollisions, checkIfThisIsCapturedInEnclosingScope);
            potentialThisCollisions.length = 0;
          }
          if (emitExtends) {
            links.flags |= 8;
          }
          if (emitDecorate) {
            links.flags |= 16;
          }
          if (emitParam) {
            links.flags |= 32;
          }
          if (emitAwaiter) {
            links.flags |= 64;
          }
          if (emitGenerator || (emitAwaiter && languageVersion < 2)) {
            links.flags |= 128;
          }
          links.flags |= 1;
        }
      }
      function getDiagnostics(sourceFile, ct) {
        try {
          cancellationToken = ct;
          return getDiagnosticsWorker(sourceFile);
        } finally {
          cancellationToken = undefined;
        }
      }
      function getDiagnosticsWorker(sourceFile) {
        throwIfNonDiagnosticsProducing();
        if (sourceFile) {
          checkSourceFile(sourceFile);
          return diagnostics.getDiagnostics(sourceFile.fileName);
        }
        ts.forEach(host.getSourceFiles(), checkSourceFile);
        return diagnostics.getDiagnostics();
      }
      function getGlobalDiagnostics() {
        throwIfNonDiagnosticsProducing();
        return diagnostics.getGlobalDiagnostics();
      }
      function throwIfNonDiagnosticsProducing() {
        if (!produceDiagnostics) {
          throw new Error("Trying to get diagnostics from a type checker that does not produce them.");
        }
      }
      function isInsideWithStatementBody(node) {
        if (node) {
          while (node.parent) {
            if (node.parent.kind === 203 && node.parent.statement === node) {
              return true;
            }
            node = node.parent;
          }
        }
        return false;
      }
      function getSymbolsInScope(location, meaning) {
        var symbols = {};
        var memberFlags = 0;
        if (isInsideWithStatementBody(location)) {
          return [];
        }
        populateSymbols();
        return symbolsToArray(symbols);
        function populateSymbols() {
          while (location) {
            if (location.locals && !isGlobalSourceFile(location)) {
              copySymbols(location.locals, meaning);
            }
            switch (location.kind) {
              case 246:
                if (!ts.isExternalModule(location)) {
                  break;
                }
              case 216:
                copySymbols(getSymbolOfNode(location).exports, meaning & 8914931);
                break;
              case 215:
                copySymbols(getSymbolOfNode(location).exports, meaning & 8);
                break;
              case 184:
                var className = location.name;
                if (className) {
                  copySymbol(location.symbol, meaning);
                }
              case 212:
              case 213:
                if (!(memberFlags & 128)) {
                  copySymbols(getSymbolOfNode(location).members, meaning & 793056);
                }
                break;
              case 171:
                var funcName = location.name;
                if (funcName) {
                  copySymbol(location.symbol, meaning);
                }
                break;
            }
            if (ts.introducesArgumentsExoticObject(location)) {
              copySymbol(argumentsSymbol, meaning);
            }
            memberFlags = location.flags;
            location = location.parent;
          }
          copySymbols(globals, meaning);
        }
        function copySymbol(symbol, meaning) {
          if (symbol.flags & meaning) {
            var id = symbol.name;
            if (!ts.hasProperty(symbols, id)) {
              symbols[id] = symbol;
            }
          }
        }
        function copySymbols(source, meaning) {
          if (meaning) {
            for (var id in source) {
              var symbol = source[id];
              copySymbol(symbol, meaning);
            }
          }
        }
      }
      function isTypeDeclarationName(name) {
        return name.kind === 67 && isTypeDeclaration(name.parent) && name.parent.name === name;
      }
      function isTypeDeclaration(node) {
        switch (node.kind) {
          case 135:
          case 212:
          case 213:
          case 214:
          case 215:
            return true;
        }
      }
      function isTypeReferenceIdentifier(entityName) {
        var node = entityName;
        while (node.parent && node.parent.kind === 133) {
          node = node.parent;
        }
        return node.parent && node.parent.kind === 149;
      }
      function isHeritageClauseElementIdentifier(entityName) {
        var node = entityName;
        while (node.parent && node.parent.kind === 164) {
          node = node.parent;
        }
        return node.parent && node.parent.kind === 186;
      }
      function getLeftSideOfImportEqualsOrExportAssignment(nodeOnRightSide) {
        while (nodeOnRightSide.parent.kind === 133) {
          nodeOnRightSide = nodeOnRightSide.parent;
        }
        if (nodeOnRightSide.parent.kind === 219) {
          return nodeOnRightSide.parent.moduleReference === nodeOnRightSide && nodeOnRightSide.parent;
        }
        if (nodeOnRightSide.parent.kind === 225) {
          return nodeOnRightSide.parent.expression === nodeOnRightSide && nodeOnRightSide.parent;
        }
        return undefined;
      }
      function isInRightSideOfImportOrExportAssignment(node) {
        return getLeftSideOfImportEqualsOrExportAssignment(node) !== undefined;
      }
      function getSymbolOfEntityNameOrPropertyAccessExpression(entityName) {
        if (ts.isDeclarationName(entityName)) {
          return getSymbolOfNode(entityName.parent);
        }
        if (entityName.parent.kind === 225) {
          return resolveEntityName(entityName, 107455 | 793056 | 1536 | 8388608);
        }
        if (entityName.kind !== 164) {
          if (isInRightSideOfImportOrExportAssignment(entityName)) {
            return getSymbolOfPartOfRightHandSideOfImportEquals(entityName);
          }
        }
        if (ts.isRightSideOfQualifiedNameOrPropertyAccess(entityName)) {
          entityName = entityName.parent;
        }
        if (isHeritageClauseElementIdentifier(entityName)) {
          var meaning = entityName.parent.kind === 186 ? 793056 : 1536;
          meaning |= 8388608;
          return resolveEntityName(entityName, meaning);
        } else if ((entityName.parent.kind === 233) || (entityName.parent.kind === 232) || (entityName.parent.kind === 235)) {
          return getJsxElementTagSymbol(entityName.parent);
        } else if (ts.isExpression(entityName)) {
          if (ts.nodeIsMissing(entityName)) {
            return undefined;
          }
          if (entityName.kind === 67) {
            var meaning = 107455 | 8388608;
            return resolveEntityName(entityName, meaning);
          } else if (entityName.kind === 164) {
            var symbol = getNodeLinks(entityName).resolvedSymbol;
            if (!symbol) {
              checkPropertyAccessExpression(entityName);
            }
            return getNodeLinks(entityName).resolvedSymbol;
          } else if (entityName.kind === 133) {
            var symbol = getNodeLinks(entityName).resolvedSymbol;
            if (!symbol) {
              checkQualifiedName(entityName);
            }
            return getNodeLinks(entityName).resolvedSymbol;
          }
        } else if (isTypeReferenceIdentifier(entityName)) {
          var meaning = entityName.parent.kind === 149 ? 793056 : 1536;
          meaning |= 8388608;
          return resolveEntityName(entityName, meaning);
        } else if (entityName.parent.kind === 236) {
          return getJsxAttributePropertySymbol(entityName.parent);
        }
        if (entityName.parent.kind === 148) {
          return resolveEntityName(entityName, 1);
        }
        return undefined;
      }
      function getSymbolAtLocation(node) {
        if (isInsideWithStatementBody(node)) {
          return undefined;
        }
        if (ts.isDeclarationName(node)) {
          return getSymbolOfNode(node.parent);
        }
        if (node.kind === 67) {
          if (isInRightSideOfImportOrExportAssignment(node)) {
            return node.parent.kind === 225 ? getSymbolOfEntityNameOrPropertyAccessExpression(node) : getSymbolOfPartOfRightHandSideOfImportEquals(node);
          } else if (node.parent.kind === 161 && node.parent.parent.kind === 159 && node === node.parent.propertyName) {
            var typeOfPattern = getTypeOfNode(node.parent.parent);
            var propertyDeclaration = typeOfPattern && getPropertyOfType(typeOfPattern, node.text);
            if (propertyDeclaration) {
              return propertyDeclaration;
            }
          }
        }
        switch (node.kind) {
          case 67:
          case 164:
          case 133:
            return getSymbolOfEntityNameOrPropertyAccessExpression(node);
          case 95:
          case 93:
            var type = checkExpression(node);
            return type.symbol;
          case 119:
            var constructorDeclaration = node.parent;
            if (constructorDeclaration && constructorDeclaration.kind === 142) {
              return constructorDeclaration.parent.symbol;
            }
            return undefined;
          case 9:
            if ((ts.isExternalModuleImportEqualsDeclaration(node.parent.parent) && ts.getExternalModuleImportEqualsDeclarationExpression(node.parent.parent) === node) || ((node.parent.kind === 220 || node.parent.kind === 226) && node.parent.moduleSpecifier === node)) {
              return resolveExternalModuleName(node, node);
            }
          case 8:
            if (node.parent.kind === 165 && node.parent.argumentExpression === node) {
              var objectType = checkExpression(node.parent.expression);
              if (objectType === unknownType)
                return undefined;
              var apparentType = getApparentType(objectType);
              if (apparentType === unknownType)
                return undefined;
              return getPropertyOfType(apparentType, node.text);
            }
            break;
        }
        return undefined;
      }
      function getShorthandAssignmentValueSymbol(location) {
        if (location && location.kind === 244) {
          return resolveEntityName(location.name, 107455);
        }
        return undefined;
      }
      function getTypeOfNode(node) {
        if (isInsideWithStatementBody(node)) {
          return unknownType;
        }
        if (ts.isTypeNode(node)) {
          return getTypeFromTypeNode(node);
        }
        if (ts.isExpression(node)) {
          return getTypeOfExpression(node);
        }
        if (ts.isExpressionWithTypeArgumentsInClassExtendsClause(node)) {
          return getBaseTypes(getDeclaredTypeOfSymbol(getSymbolOfNode(node.parent.parent)))[0];
        }
        if (isTypeDeclaration(node)) {
          var symbol = getSymbolOfNode(node);
          return getDeclaredTypeOfSymbol(symbol);
        }
        if (isTypeDeclarationName(node)) {
          var symbol = getSymbolAtLocation(node);
          return symbol && getDeclaredTypeOfSymbol(symbol);
        }
        if (ts.isDeclaration(node)) {
          var symbol = getSymbolOfNode(node);
          return getTypeOfSymbol(symbol);
        }
        if (ts.isDeclarationName(node)) {
          var symbol = getSymbolAtLocation(node);
          return symbol && getTypeOfSymbol(symbol);
        }
        if (ts.isBindingPattern(node)) {
          return getTypeForVariableLikeDeclaration(node.parent);
        }
        if (isInRightSideOfImportOrExportAssignment(node)) {
          var symbol = getSymbolAtLocation(node);
          var declaredType = symbol && getDeclaredTypeOfSymbol(symbol);
          return declaredType !== unknownType ? declaredType : getTypeOfSymbol(symbol);
        }
        return unknownType;
      }
      function getTypeOfExpression(expr) {
        if (ts.isRightSideOfQualifiedNameOrPropertyAccess(expr)) {
          expr = expr.parent;
        }
        return checkExpression(expr);
      }
      function getParentTypeOfClassElement(node) {
        var classSymbol = getSymbolOfNode(node.parent);
        return node.flags & 128 ? getTypeOfSymbol(classSymbol) : getDeclaredTypeOfSymbol(classSymbol);
      }
      function getAugmentedPropertiesOfType(type) {
        type = getApparentType(type);
        var propsByName = createSymbolTable(getPropertiesOfType(type));
        if (getSignaturesOfType(type, 0).length || getSignaturesOfType(type, 1).length) {
          ts.forEach(getPropertiesOfType(globalFunctionType), function(p) {
            if (!ts.hasProperty(propsByName, p.name)) {
              propsByName[p.name] = p;
            }
          });
        }
        return getNamedMembers(propsByName);
      }
      function getRootSymbols(symbol) {
        if (symbol.flags & 268435456) {
          var symbols = [];
          var name_15 = symbol.name;
          ts.forEach(getSymbolLinks(symbol).containingType.types, function(t) {
            var symbol = getPropertyOfType(t, name_15);
            if (symbol) {
              symbols.push(symbol);
            }
          });
          return symbols;
        } else if (symbol.flags & 67108864) {
          var target = getSymbolLinks(symbol).target;
          if (target) {
            return [target];
          }
        }
        return [symbol];
      }
      function getReferencedExportContainer(node) {
        var symbol = getReferencedValueSymbol(node);
        if (symbol) {
          if (symbol.flags & 1048576) {
            var exportSymbol = getMergedSymbol(symbol.exportSymbol);
            if (exportSymbol.flags & 944) {
              return undefined;
            }
            symbol = exportSymbol;
          }
          var parentSymbol = getParentOfSymbol(symbol);
          if (parentSymbol) {
            if (parentSymbol.flags & 512 && parentSymbol.valueDeclaration.kind === 246) {
              return parentSymbol.valueDeclaration;
            }
            for (var n = node.parent; n; n = n.parent) {
              if ((n.kind === 216 || n.kind === 215) && getSymbolOfNode(n) === parentSymbol) {
                return n;
              }
            }
          }
        }
      }
      function getReferencedImportDeclaration(node) {
        var symbol = getReferencedValueSymbol(node);
        return symbol && symbol.flags & 8388608 ? getDeclarationOfAliasSymbol(symbol) : undefined;
      }
      function isStatementWithLocals(node) {
        switch (node.kind) {
          case 190:
          case 218:
          case 197:
          case 198:
          case 199:
            return true;
        }
        return false;
      }
      function isNestedRedeclarationSymbol(symbol) {
        if (symbol.flags & 418) {
          var links = getSymbolLinks(symbol);
          if (links.isNestedRedeclaration === undefined) {
            var container = ts.getEnclosingBlockScopeContainer(symbol.valueDeclaration);
            links.isNestedRedeclaration = isStatementWithLocals(container) && !!resolveName(container.parent, symbol.name, 107455, undefined, undefined);
          }
          return links.isNestedRedeclaration;
        }
        return false;
      }
      function getReferencedNestedRedeclaration(node) {
        var symbol = getReferencedValueSymbol(node);
        return symbol && isNestedRedeclarationSymbol(symbol) ? symbol.valueDeclaration : undefined;
      }
      function isNestedRedeclaration(node) {
        return isNestedRedeclarationSymbol(getSymbolOfNode(node));
      }
      function isValueAliasDeclaration(node) {
        switch (node.kind) {
          case 219:
          case 221:
          case 222:
          case 224:
          case 228:
            return isAliasResolvedToValue(getSymbolOfNode(node));
          case 226:
            var exportClause = node.exportClause;
            return exportClause && ts.forEach(exportClause.elements, isValueAliasDeclaration);
          case 225:
            return node.expression && node.expression.kind === 67 ? isAliasResolvedToValue(getSymbolOfNode(node)) : true;
        }
        return false;
      }
      function isTopLevelValueImportEqualsWithEntityName(node) {
        if (node.parent.kind !== 246 || !ts.isInternalModuleImportEqualsDeclaration(node)) {
          return false;
        }
        var isValue = isAliasResolvedToValue(getSymbolOfNode(node));
        return isValue && node.moduleReference && !ts.nodeIsMissing(node.moduleReference);
      }
      function isAliasResolvedToValue(symbol) {
        var target = resolveAlias(symbol);
        if (target === unknownSymbol && compilerOptions.isolatedModules) {
          return true;
        }
        return target !== unknownSymbol && target && target.flags & 107455 && (compilerOptions.preserveConstEnums || !isConstEnumOrConstEnumOnlyModule(target));
      }
      function isConstEnumOrConstEnumOnlyModule(s) {
        return isConstEnumSymbol(s) || s.constEnumOnlyModule;
      }
      function isReferencedAliasDeclaration(node, checkChildren) {
        if (ts.isAliasSymbolDeclaration(node)) {
          var symbol = getSymbolOfNode(node);
          if (getSymbolLinks(symbol).referenced) {
            return true;
          }
        }
        if (checkChildren) {
          return ts.forEachChild(node, function(node) {
            return isReferencedAliasDeclaration(node, checkChildren);
          });
        }
        return false;
      }
      function isImplementationOfOverload(node) {
        if (ts.nodeIsPresent(node.body)) {
          var symbol = getSymbolOfNode(node);
          var signaturesOfSymbol = getSignaturesOfSymbol(symbol);
          return signaturesOfSymbol.length > 1 || (signaturesOfSymbol.length === 1 && signaturesOfSymbol[0].declaration !== node);
        }
        return false;
      }
      function getNodeCheckFlags(node) {
        return getNodeLinks(node).flags;
      }
      function getEnumMemberValue(node) {
        computeEnumMemberValues(node.parent);
        return getNodeLinks(node).enumMemberValue;
      }
      function getConstantValue(node) {
        if (node.kind === 245) {
          return getEnumMemberValue(node);
        }
        var symbol = getNodeLinks(node).resolvedSymbol;
        if (symbol && (symbol.flags & 8)) {
          if (ts.isConstEnumDeclaration(symbol.valueDeclaration.parent)) {
            return getEnumMemberValue(symbol.valueDeclaration);
          }
        }
        return undefined;
      }
      function isFunctionType(type) {
        return type.flags & 80896 && getSignaturesOfType(type, 0).length > 0;
      }
      function getTypeReferenceSerializationKind(typeName) {
        var valueSymbol = resolveEntityName(typeName, 107455, true);
        var constructorType = valueSymbol ? getTypeOfSymbol(valueSymbol) : undefined;
        if (constructorType && isConstructorType(constructorType)) {
          return ts.TypeReferenceSerializationKind.TypeWithConstructSignatureAndValue;
        }
        var typeSymbol = resolveEntityName(typeName, 793056, true);
        if (!typeSymbol) {
          return ts.TypeReferenceSerializationKind.ObjectType;
        }
        var type = getDeclaredTypeOfSymbol(typeSymbol);
        if (type === unknownType) {
          return ts.TypeReferenceSerializationKind.Unknown;
        } else if (type.flags & 1) {
          return ts.TypeReferenceSerializationKind.ObjectType;
        } else if (allConstituentTypesHaveKind(type, 16)) {
          return ts.TypeReferenceSerializationKind.VoidType;
        } else if (allConstituentTypesHaveKind(type, 8)) {
          return ts.TypeReferenceSerializationKind.BooleanType;
        } else if (allConstituentTypesHaveKind(type, 132)) {
          return ts.TypeReferenceSerializationKind.NumberLikeType;
        } else if (allConstituentTypesHaveKind(type, 258)) {
          return ts.TypeReferenceSerializationKind.StringLikeType;
        } else if (allConstituentTypesHaveKind(type, 8192)) {
          return ts.TypeReferenceSerializationKind.ArrayLikeType;
        } else if (allConstituentTypesHaveKind(type, 16777216)) {
          return ts.TypeReferenceSerializationKind.ESSymbolType;
        } else if (isFunctionType(type)) {
          return ts.TypeReferenceSerializationKind.TypeWithCallSignature;
        } else if (isArrayType(type)) {
          return ts.TypeReferenceSerializationKind.ArrayLikeType;
        } else {
          return ts.TypeReferenceSerializationKind.ObjectType;
        }
      }
      function writeTypeOfDeclaration(declaration, enclosingDeclaration, flags, writer) {
        var symbol = getSymbolOfNode(declaration);
        var type = symbol && !(symbol.flags & (2048 | 131072)) ? getTypeOfSymbol(symbol) : unknownType;
        getSymbolDisplayBuilder().buildTypeDisplay(type, writer, enclosingDeclaration, flags);
      }
      function writeReturnTypeOfSignatureDeclaration(signatureDeclaration, enclosingDeclaration, flags, writer) {
        var signature = getSignatureFromDeclaration(signatureDeclaration);
        getSymbolDisplayBuilder().buildTypeDisplay(getReturnTypeOfSignature(signature), writer, enclosingDeclaration, flags);
      }
      function writeTypeOfExpression(expr, enclosingDeclaration, flags, writer) {
        var type = getTypeOfExpression(expr);
        getSymbolDisplayBuilder().buildTypeDisplay(type, writer, enclosingDeclaration, flags);
      }
      function hasGlobalName(name) {
        return ts.hasProperty(globals, name);
      }
      function getReferencedValueSymbol(reference) {
        return getNodeLinks(reference).resolvedSymbol || resolveName(reference, reference.text, 107455 | 1048576 | 8388608, undefined, undefined);
      }
      function getReferencedValueDeclaration(reference) {
        ts.Debug.assert(!ts.nodeIsSynthesized(reference));
        var symbol = getReferencedValueSymbol(reference);
        return symbol && getExportSymbolOfValueSymbolIfExported(symbol).valueDeclaration;
      }
      function getBlockScopedVariableId(n) {
        ts.Debug.assert(!ts.nodeIsSynthesized(n));
        var isVariableDeclarationOrBindingElement = n.parent.kind === 161 || (n.parent.kind === 209 && n.parent.name === n);
        var symbol = (isVariableDeclarationOrBindingElement ? getSymbolOfNode(n.parent) : undefined) || getNodeLinks(n).resolvedSymbol || resolveName(n, n.text, 107455 | 8388608, undefined, undefined);
        var isLetOrConst = symbol && (symbol.flags & 2) && symbol.valueDeclaration.parent.kind !== 242;
        if (isLetOrConst) {
          getSymbolLinks(symbol);
          return symbol.id;
        }
        return undefined;
      }
      function instantiateSingleCallFunctionType(functionType, typeArguments) {
        if (functionType === unknownType) {
          return unknownType;
        }
        var signature = getSingleCallSignature(functionType);
        if (!signature) {
          return unknownType;
        }
        var instantiatedSignature = getSignatureInstantiation(signature, typeArguments);
        return getOrCreateTypeFromSignature(instantiatedSignature);
      }
      function createResolver() {
        return {
          getReferencedExportContainer: getReferencedExportContainer,
          getReferencedImportDeclaration: getReferencedImportDeclaration,
          getReferencedNestedRedeclaration: getReferencedNestedRedeclaration,
          isNestedRedeclaration: isNestedRedeclaration,
          isValueAliasDeclaration: isValueAliasDeclaration,
          hasGlobalName: hasGlobalName,
          isReferencedAliasDeclaration: isReferencedAliasDeclaration,
          getNodeCheckFlags: getNodeCheckFlags,
          isTopLevelValueImportEqualsWithEntityName: isTopLevelValueImportEqualsWithEntityName,
          isDeclarationVisible: isDeclarationVisible,
          isImplementationOfOverload: isImplementationOfOverload,
          writeTypeOfDeclaration: writeTypeOfDeclaration,
          writeReturnTypeOfSignatureDeclaration: writeReturnTypeOfSignatureDeclaration,
          writeTypeOfExpression: writeTypeOfExpression,
          isSymbolAccessible: isSymbolAccessible,
          isEntityNameVisible: isEntityNameVisible,
          getConstantValue: getConstantValue,
          collectLinkedAliases: collectLinkedAliases,
          getBlockScopedVariableId: getBlockScopedVariableId,
          getReferencedValueDeclaration: getReferencedValueDeclaration,
          getTypeReferenceSerializationKind: getTypeReferenceSerializationKind,
          isOptionalParameter: isOptionalParameter
        };
      }
      function initializeTypeChecker() {
        ts.forEach(host.getSourceFiles(), function(file) {
          ts.bindSourceFile(file);
        });
        ts.forEach(host.getSourceFiles(), function(file) {
          if (!ts.isExternalModule(file)) {
            mergeSymbolTable(globals, file.locals);
          }
        });
        getSymbolLinks(undefinedSymbol).type = undefinedType;
        getSymbolLinks(argumentsSymbol).type = getGlobalType("IArguments");
        getSymbolLinks(unknownSymbol).type = unknownType;
        globals[undefinedSymbol.name] = undefinedSymbol;
        globalArrayType = getGlobalType("Array", 1);
        globalObjectType = getGlobalType("Object");
        globalFunctionType = getGlobalType("Function");
        globalStringType = getGlobalType("String");
        globalNumberType = getGlobalType("Number");
        globalBooleanType = getGlobalType("Boolean");
        globalRegExpType = getGlobalType("RegExp");
        jsxElementType = getExportedTypeFromNamespace("JSX", JsxNames.Element);
        getGlobalClassDecoratorType = ts.memoize(function() {
          return getGlobalType("ClassDecorator");
        });
        getGlobalPropertyDecoratorType = ts.memoize(function() {
          return getGlobalType("PropertyDecorator");
        });
        getGlobalMethodDecoratorType = ts.memoize(function() {
          return getGlobalType("MethodDecorator");
        });
        getGlobalParameterDecoratorType = ts.memoize(function() {
          return getGlobalType("ParameterDecorator");
        });
        getGlobalTypedPropertyDescriptorType = ts.memoize(function() {
          return getGlobalType("TypedPropertyDescriptor", 1);
        });
        getGlobalPromiseType = ts.memoize(function() {
          return getGlobalType("Promise", 1);
        });
        tryGetGlobalPromiseType = ts.memoize(function() {
          return getGlobalSymbol("Promise", 793056, undefined) && getGlobalPromiseType();
        });
        getGlobalPromiseLikeType = ts.memoize(function() {
          return getGlobalType("PromiseLike", 1);
        });
        getInstantiatedGlobalPromiseLikeType = ts.memoize(createInstantiatedPromiseLikeType);
        getGlobalPromiseConstructorSymbol = ts.memoize(function() {
          return getGlobalValueSymbol("Promise");
        });
        getGlobalPromiseConstructorLikeType = ts.memoize(function() {
          return getGlobalType("PromiseConstructorLike");
        });
        getGlobalThenableType = ts.memoize(createThenableType);
        if (languageVersion >= 2) {
          globalTemplateStringsArrayType = getGlobalType("TemplateStringsArray");
          globalESSymbolType = getGlobalType("Symbol");
          globalESSymbolConstructorSymbol = getGlobalValueSymbol("Symbol");
          globalIterableType = getGlobalType("Iterable", 1);
          globalIteratorType = getGlobalType("Iterator", 1);
          globalIterableIteratorType = getGlobalType("IterableIterator", 1);
        } else {
          globalTemplateStringsArrayType = unknownType;
          globalESSymbolType = createAnonymousType(undefined, emptySymbols, emptyArray, emptyArray, undefined, undefined);
          globalESSymbolConstructorSymbol = undefined;
          globalIterableType = emptyGenericType;
          globalIteratorType = emptyGenericType;
          globalIterableIteratorType = emptyGenericType;
        }
        anyArrayType = createArrayType(anyType);
      }
      function createInstantiatedPromiseLikeType() {
        var promiseLikeType = getGlobalPromiseLikeType();
        if (promiseLikeType !== emptyGenericType) {
          return createTypeReference(promiseLikeType, [anyType]);
        }
        return emptyObjectType;
      }
      function createThenableType() {
        var thenPropertySymbol = createSymbol(67108864 | 4, "then");
        getSymbolLinks(thenPropertySymbol).type = globalFunctionType;
        var thenableType = createObjectType(65536);
        thenableType.properties = [thenPropertySymbol];
        thenableType.members = createSymbolTable(thenableType.properties);
        thenableType.callSignatures = [];
        thenableType.constructSignatures = [];
        return thenableType;
      }
      function checkGrammarDecorators(node) {
        if (!node.decorators) {
          return false;
        }
        if (!ts.nodeCanBeDecorated(node)) {
          return grammarErrorOnFirstToken(node, ts.Diagnostics.Decorators_are_not_valid_here);
        } else if (languageVersion < 1) {
          return grammarErrorOnFirstToken(node, ts.Diagnostics.Decorators_are_only_available_when_targeting_ECMAScript_5_and_higher);
        } else if (node.kind === 143 || node.kind === 144) {
          var accessors = ts.getAllAccessorDeclarations(node.parent.members, node);
          if (accessors.firstAccessor.decorators && node === accessors.secondAccessor) {
            return grammarErrorOnFirstToken(node, ts.Diagnostics.Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name);
          }
        }
        return false;
      }
      function checkGrammarModifiers(node) {
        switch (node.kind) {
          case 143:
          case 144:
          case 142:
          case 139:
          case 138:
          case 141:
          case 140:
          case 147:
          case 216:
          case 220:
          case 219:
          case 226:
          case 225:
          case 136:
            break;
          case 211:
            if (node.modifiers && (node.modifiers.length > 1 || node.modifiers[0].kind !== 116) && node.parent.kind !== 217 && node.parent.kind !== 246) {
              return grammarErrorOnFirstToken(node, ts.Diagnostics.Modifiers_cannot_appear_here);
            }
            break;
          case 212:
          case 213:
          case 191:
          case 214:
            if (node.modifiers && node.parent.kind !== 217 && node.parent.kind !== 246) {
              return grammarErrorOnFirstToken(node, ts.Diagnostics.Modifiers_cannot_appear_here);
            }
            break;
          case 215:
            if (node.modifiers && (node.modifiers.length > 1 || node.modifiers[0].kind !== 72) && node.parent.kind !== 217 && node.parent.kind !== 246) {
              return grammarErrorOnFirstToken(node, ts.Diagnostics.Modifiers_cannot_appear_here);
            }
            break;
          default:
            return false;
        }
        if (!node.modifiers) {
          return;
        }
        var lastStatic,
            lastPrivate,
            lastProtected,
            lastDeclare,
            lastAsync;
        var flags = 0;
        for (var _i = 0,
            _a = node.modifiers; _i < _a.length; _i++) {
          var modifier = _a[_i];
          switch (modifier.kind) {
            case 110:
            case 109:
            case 108:
              var text = void 0;
              if (modifier.kind === 110) {
                text = "public";
              } else if (modifier.kind === 109) {
                text = "protected";
                lastProtected = modifier;
              } else {
                text = "private";
                lastPrivate = modifier;
              }
              if (flags & 112) {
                return grammarErrorOnNode(modifier, ts.Diagnostics.Accessibility_modifier_already_seen);
              } else if (flags & 128) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_must_precede_1_modifier, text, "static");
              } else if (flags & 512) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_must_precede_1_modifier, text, "async");
              } else if (node.parent.kind === 217 || node.parent.kind === 246) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_appear_on_a_module_element, text);
              } else if (flags & 256) {
                if (modifier.kind === 108) {
                  return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_be_used_with_1_modifier, text, "abstract");
                } else {
                  return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_must_precede_1_modifier, text, "abstract");
                }
              }
              flags |= ts.modifierToFlag(modifier.kind);
              break;
            case 111:
              if (flags & 128) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_already_seen, "static");
              } else if (flags & 512) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_must_precede_1_modifier, "static", "async");
              } else if (node.parent.kind === 217 || node.parent.kind === 246) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_appear_on_a_module_element, "static");
              } else if (node.kind === 136) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_appear_on_a_parameter, "static");
              } else if (flags & 256) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_be_used_with_1_modifier, "static", "abstract");
              }
              flags |= 128;
              lastStatic = modifier;
              break;
            case 80:
              if (flags & 1) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_already_seen, "export");
              } else if (flags & 2) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_must_precede_1_modifier, "export", "declare");
              } else if (flags & 256) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_must_precede_1_modifier, "export", "abstract");
              } else if (flags & 512) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_must_precede_1_modifier, "export", "async");
              } else if (node.parent.kind === 212) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_appear_on_a_class_element, "export");
              } else if (node.kind === 136) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_appear_on_a_parameter, "export");
              }
              flags |= 1;
              break;
            case 120:
              if (flags & 2) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_already_seen, "declare");
              } else if (flags & 512) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_be_used_in_an_ambient_context, "async");
              } else if (node.parent.kind === 212) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_appear_on_a_class_element, "declare");
              } else if (node.kind === 136) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_appear_on_a_parameter, "declare");
              } else if (ts.isInAmbientContext(node.parent) && node.parent.kind === 217) {
                return grammarErrorOnNode(modifier, ts.Diagnostics.A_declare_modifier_cannot_be_used_in_an_already_ambient_context);
              }
              flags |= 2;
              lastDeclare = modifier;
              break;
            case 113:
              if (flags & 256) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_already_seen, "abstract");
              }
              if (node.kind !== 212) {
                if (node.kind !== 141) {
                  return grammarErrorOnNode(modifier, ts.Diagnostics.abstract_modifier_can_only_appear_on_a_class_or_method_declaration);
                }
                if (!(node.parent.kind === 212 && node.parent.flags & 256)) {
                  return grammarErrorOnNode(modifier, ts.Diagnostics.Abstract_methods_can_only_appear_within_an_abstract_class);
                }
                if (flags & 128) {
                  return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_be_used_with_1_modifier, "static", "abstract");
                }
                if (flags & 32) {
                  return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_be_used_with_1_modifier, "private", "abstract");
                }
              }
              flags |= 256;
              break;
            case 116:
              if (flags & 512) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_already_seen, "async");
              } else if (flags & 2 || ts.isInAmbientContext(node.parent)) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_be_used_in_an_ambient_context, "async");
              } else if (node.kind === 136) {
                return grammarErrorOnNode(modifier, ts.Diagnostics._0_modifier_cannot_appear_on_a_parameter, "async");
              }
              flags |= 512;
              lastAsync = modifier;
              break;
          }
        }
        if (node.kind === 142) {
          if (flags & 128) {
            return grammarErrorOnNode(lastStatic, ts.Diagnostics._0_modifier_cannot_appear_on_a_constructor_declaration, "static");
          }
          if (flags & 256) {
            return grammarErrorOnNode(lastStatic, ts.Diagnostics._0_modifier_cannot_appear_on_a_constructor_declaration, "abstract");
          } else if (flags & 64) {
            return grammarErrorOnNode(lastProtected, ts.Diagnostics._0_modifier_cannot_appear_on_a_constructor_declaration, "protected");
          } else if (flags & 32) {
            return grammarErrorOnNode(lastPrivate, ts.Diagnostics._0_modifier_cannot_appear_on_a_constructor_declaration, "private");
          } else if (flags & 512) {
            return grammarErrorOnNode(lastAsync, ts.Diagnostics._0_modifier_cannot_appear_on_a_constructor_declaration, "async");
          }
          return;
        } else if ((node.kind === 220 || node.kind === 219) && flags & 2) {
          return grammarErrorOnNode(lastDeclare, ts.Diagnostics.A_0_modifier_cannot_be_used_with_an_import_declaration, "declare");
        } else if (node.kind === 136 && (flags & 112) && ts.isBindingPattern(node.name)) {
          return grammarErrorOnNode(node, ts.Diagnostics.A_parameter_property_may_not_be_a_binding_pattern);
        }
        if (flags & 512) {
          return checkGrammarAsyncModifier(node, lastAsync);
        }
      }
      function checkGrammarAsyncModifier(node, asyncModifier) {
        if (languageVersion < 2) {
          return grammarErrorOnNode(asyncModifier, ts.Diagnostics.Async_functions_are_only_available_when_targeting_ECMAScript_6_and_higher);
        }
        switch (node.kind) {
          case 141:
          case 211:
          case 171:
          case 172:
            if (!node.asteriskToken) {
              return false;
            }
            break;
        }
        return grammarErrorOnNode(asyncModifier, ts.Diagnostics._0_modifier_cannot_be_used_here, "async");
      }
      function checkGrammarForDisallowedTrailingComma(list) {
        if (list && list.hasTrailingComma) {
          var start = list.end - ",".length;
          var end = list.end;
          var sourceFile = ts.getSourceFileOfNode(list[0]);
          return grammarErrorAtPos(sourceFile, start, end - start, ts.Diagnostics.Trailing_comma_not_allowed);
        }
      }
      function checkGrammarTypeParameterList(node, typeParameters, file) {
        if (checkGrammarForDisallowedTrailingComma(typeParameters)) {
          return true;
        }
        if (typeParameters && typeParameters.length === 0) {
          var start = typeParameters.pos - "<".length;
          var end = ts.skipTrivia(file.text, typeParameters.end) + ">".length;
          return grammarErrorAtPos(file, start, end - start, ts.Diagnostics.Type_parameter_list_cannot_be_empty);
        }
      }
      function checkGrammarParameterList(parameters) {
        if (checkGrammarForDisallowedTrailingComma(parameters)) {
          return true;
        }
        var seenOptionalParameter = false;
        var parameterCount = parameters.length;
        for (var i = 0; i < parameterCount; i++) {
          var parameter = parameters[i];
          if (parameter.dotDotDotToken) {
            if (i !== (parameterCount - 1)) {
              return grammarErrorOnNode(parameter.dotDotDotToken, ts.Diagnostics.A_rest_parameter_must_be_last_in_a_parameter_list);
            }
            if (ts.isBindingPattern(parameter.name)) {
              return grammarErrorOnNode(parameter.name, ts.Diagnostics.A_rest_element_cannot_contain_a_binding_pattern);
            }
            if (parameter.questionToken) {
              return grammarErrorOnNode(parameter.questionToken, ts.Diagnostics.A_rest_parameter_cannot_be_optional);
            }
            if (parameter.initializer) {
              return grammarErrorOnNode(parameter.name, ts.Diagnostics.A_rest_parameter_cannot_have_an_initializer);
            }
          } else if (parameter.questionToken) {
            seenOptionalParameter = true;
            if (parameter.initializer) {
              return grammarErrorOnNode(parameter.name, ts.Diagnostics.Parameter_cannot_have_question_mark_and_initializer);
            }
          } else if (seenOptionalParameter && !parameter.initializer) {
            return grammarErrorOnNode(parameter.name, ts.Diagnostics.A_required_parameter_cannot_follow_an_optional_parameter);
          }
        }
      }
      function checkGrammarFunctionLikeDeclaration(node) {
        var file = ts.getSourceFileOfNode(node);
        return checkGrammarDecorators(node) || checkGrammarModifiers(node) || checkGrammarTypeParameterList(node, node.typeParameters, file) || checkGrammarParameterList(node.parameters) || checkGrammarArrowFunction(node, file);
      }
      function checkGrammarArrowFunction(node, file) {
        if (node.kind === 172) {
          var arrowFunction = node;
          var startLine = ts.getLineAndCharacterOfPosition(file, arrowFunction.equalsGreaterThanToken.pos).line;
          var endLine = ts.getLineAndCharacterOfPosition(file, arrowFunction.equalsGreaterThanToken.end).line;
          if (startLine !== endLine) {
            return grammarErrorOnNode(arrowFunction.equalsGreaterThanToken, ts.Diagnostics.Line_terminator_not_permitted_before_arrow);
          }
        }
        return false;
      }
      function checkGrammarIndexSignatureParameters(node) {
        var parameter = node.parameters[0];
        if (node.parameters.length !== 1) {
          if (parameter) {
            return grammarErrorOnNode(parameter.name, ts.Diagnostics.An_index_signature_must_have_exactly_one_parameter);
          } else {
            return grammarErrorOnNode(node, ts.Diagnostics.An_index_signature_must_have_exactly_one_parameter);
          }
        }
        if (parameter.dotDotDotToken) {
          return grammarErrorOnNode(parameter.dotDotDotToken, ts.Diagnostics.An_index_signature_cannot_have_a_rest_parameter);
        }
        if (parameter.flags & 2035) {
          return grammarErrorOnNode(parameter.name, ts.Diagnostics.An_index_signature_parameter_cannot_have_an_accessibility_modifier);
        }
        if (parameter.questionToken) {
          return grammarErrorOnNode(parameter.questionToken, ts.Diagnostics.An_index_signature_parameter_cannot_have_a_question_mark);
        }
        if (parameter.initializer) {
          return grammarErrorOnNode(parameter.name, ts.Diagnostics.An_index_signature_parameter_cannot_have_an_initializer);
        }
        if (!parameter.type) {
          return grammarErrorOnNode(parameter.name, ts.Diagnostics.An_index_signature_parameter_must_have_a_type_annotation);
        }
        if (parameter.type.kind !== 128 && parameter.type.kind !== 126) {
          return grammarErrorOnNode(parameter.name, ts.Diagnostics.An_index_signature_parameter_type_must_be_string_or_number);
        }
        if (!node.type) {
          return grammarErrorOnNode(node, ts.Diagnostics.An_index_signature_must_have_a_type_annotation);
        }
      }
      function checkGrammarForIndexSignatureModifier(node) {
        if (node.flags & 2035) {
          grammarErrorOnFirstToken(node, ts.Diagnostics.Modifiers_not_permitted_on_index_signature_members);
        }
      }
      function checkGrammarIndexSignature(node) {
        return checkGrammarDecorators(node) || checkGrammarModifiers(node) || checkGrammarIndexSignatureParameters(node) || checkGrammarForIndexSignatureModifier(node);
      }
      function checkGrammarForAtLeastOneTypeArgument(node, typeArguments) {
        if (typeArguments && typeArguments.length === 0) {
          var sourceFile = ts.getSourceFileOfNode(node);
          var start = typeArguments.pos - "<".length;
          var end = ts.skipTrivia(sourceFile.text, typeArguments.end) + ">".length;
          return grammarErrorAtPos(sourceFile, start, end - start, ts.Diagnostics.Type_argument_list_cannot_be_empty);
        }
      }
      function checkGrammarTypeArguments(node, typeArguments) {
        return checkGrammarForDisallowedTrailingComma(typeArguments) || checkGrammarForAtLeastOneTypeArgument(node, typeArguments);
      }
      function checkGrammarForOmittedArgument(node, args) {
        if (args) {
          var sourceFile = ts.getSourceFileOfNode(node);
          for (var _i = 0; _i < args.length; _i++) {
            var arg = args[_i];
            if (arg.kind === 185) {
              return grammarErrorAtPos(sourceFile, arg.pos, 0, ts.Diagnostics.Argument_expression_expected);
            }
          }
        }
      }
      function checkGrammarArguments(node, args) {
        return checkGrammarForDisallowedTrailingComma(args) || checkGrammarForOmittedArgument(node, args);
      }
      function checkGrammarHeritageClause(node) {
        var types = node.types;
        if (checkGrammarForDisallowedTrailingComma(types)) {
          return true;
        }
        if (types && types.length === 0) {
          var listType = ts.tokenToString(node.token);
          var sourceFile = ts.getSourceFileOfNode(node);
          return grammarErrorAtPos(sourceFile, types.pos, 0, ts.Diagnostics._0_list_cannot_be_empty, listType);
        }
      }
      function checkGrammarClassDeclarationHeritageClauses(node) {
        var seenExtendsClause = false;
        var seenImplementsClause = false;
        if (!checkGrammarDecorators(node) && !checkGrammarModifiers(node) && node.heritageClauses) {
          for (var _i = 0,
              _a = node.heritageClauses; _i < _a.length; _i++) {
            var heritageClause = _a[_i];
            if (heritageClause.token === 81) {
              if (seenExtendsClause) {
                return grammarErrorOnFirstToken(heritageClause, ts.Diagnostics.extends_clause_already_seen);
              }
              if (seenImplementsClause) {
                return grammarErrorOnFirstToken(heritageClause, ts.Diagnostics.extends_clause_must_precede_implements_clause);
              }
              if (heritageClause.types.length > 1) {
                return grammarErrorOnFirstToken(heritageClause.types[1], ts.Diagnostics.Classes_can_only_extend_a_single_class);
              }
              seenExtendsClause = true;
            } else {
              ts.Debug.assert(heritageClause.token === 104);
              if (seenImplementsClause) {
                return grammarErrorOnFirstToken(heritageClause, ts.Diagnostics.implements_clause_already_seen);
              }
              seenImplementsClause = true;
            }
            checkGrammarHeritageClause(heritageClause);
          }
        }
      }
      function checkGrammarInterfaceDeclaration(node) {
        var seenExtendsClause = false;
        if (node.heritageClauses) {
          for (var _i = 0,
              _a = node.heritageClauses; _i < _a.length; _i++) {
            var heritageClause = _a[_i];
            if (heritageClause.token === 81) {
              if (seenExtendsClause) {
                return grammarErrorOnFirstToken(heritageClause, ts.Diagnostics.extends_clause_already_seen);
              }
              seenExtendsClause = true;
            } else {
              ts.Debug.assert(heritageClause.token === 104);
              return grammarErrorOnFirstToken(heritageClause, ts.Diagnostics.Interface_declaration_cannot_have_implements_clause);
            }
            checkGrammarHeritageClause(heritageClause);
          }
        }
        return false;
      }
      function checkGrammarComputedPropertyName(node) {
        if (node.kind !== 134) {
          return false;
        }
        var computedPropertyName = node;
        if (computedPropertyName.expression.kind === 179 && computedPropertyName.expression.operatorToken.kind === 24) {
          return grammarErrorOnNode(computedPropertyName.expression, ts.Diagnostics.A_comma_expression_is_not_allowed_in_a_computed_property_name);
        }
      }
      function checkGrammarForGenerator(node) {
        if (node.asteriskToken) {
          ts.Debug.assert(node.kind === 211 || node.kind === 171 || node.kind === 141);
          if (ts.isInAmbientContext(node)) {
            return grammarErrorOnNode(node.asteriskToken, ts.Diagnostics.Generators_are_not_allowed_in_an_ambient_context);
          }
          if (!node.body) {
            return grammarErrorOnNode(node.asteriskToken, ts.Diagnostics.An_overload_signature_cannot_be_declared_as_a_generator);
          }
          if (languageVersion < 2) {
            return grammarErrorOnNode(node.asteriskToken, ts.Diagnostics.Generators_are_only_available_when_targeting_ECMAScript_6_or_higher);
          }
        }
      }
      function checkGrammarForInvalidQuestionMark(node, questionToken, message) {
        if (questionToken) {
          return grammarErrorOnNode(questionToken, message);
        }
      }
      function checkGrammarObjectLiteralExpression(node) {
        var seen = {};
        var Property = 1;
        var GetAccessor = 2;
        var SetAccesor = 4;
        var GetOrSetAccessor = GetAccessor | SetAccesor;
        for (var _i = 0,
            _a = node.properties; _i < _a.length; _i++) {
          var prop = _a[_i];
          var name_16 = prop.name;
          if (prop.kind === 185 || name_16.kind === 134) {
            checkGrammarComputedPropertyName(name_16);
            continue;
          }
          var currentKind = void 0;
          if (prop.kind === 243 || prop.kind === 244) {
            checkGrammarForInvalidQuestionMark(prop, prop.questionToken, ts.Diagnostics.An_object_member_cannot_be_declared_optional);
            if (name_16.kind === 8) {
              checkGrammarNumericLiteral(name_16);
            }
            currentKind = Property;
          } else if (prop.kind === 141) {
            currentKind = Property;
          } else if (prop.kind === 143) {
            currentKind = GetAccessor;
          } else if (prop.kind === 144) {
            currentKind = SetAccesor;
          } else {
            ts.Debug.fail("Unexpected syntax kind:" + prop.kind);
          }
          if (!ts.hasProperty(seen, name_16.text)) {
            seen[name_16.text] = currentKind;
          } else {
            var existingKind = seen[name_16.text];
            if (currentKind === Property && existingKind === Property) {
              continue;
            } else if ((currentKind & GetOrSetAccessor) && (existingKind & GetOrSetAccessor)) {
              if (existingKind !== GetOrSetAccessor && currentKind !== existingKind) {
                seen[name_16.text] = currentKind | existingKind;
              } else {
                return grammarErrorOnNode(name_16, ts.Diagnostics.An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name);
              }
            } else {
              return grammarErrorOnNode(name_16, ts.Diagnostics.An_object_literal_cannot_have_property_and_accessor_with_the_same_name);
            }
          }
        }
      }
      function checkGrammarJsxElement(node) {
        var seen = {};
        for (var _i = 0,
            _a = node.attributes; _i < _a.length; _i++) {
          var attr = _a[_i];
          if (attr.kind === 237) {
            continue;
          }
          var jsxAttr = attr;
          var name_17 = jsxAttr.name;
          if (!ts.hasProperty(seen, name_17.text)) {
            seen[name_17.text] = true;
          } else {
            return grammarErrorOnNode(name_17, ts.Diagnostics.JSX_elements_cannot_have_multiple_attributes_with_the_same_name);
          }
          var initializer = jsxAttr.initializer;
          if (initializer && initializer.kind === 238 && !initializer.expression) {
            return grammarErrorOnNode(jsxAttr.initializer, ts.Diagnostics.JSX_attributes_must_only_be_assigned_a_non_empty_expression);
          }
        }
      }
      function checkGrammarForInOrForOfStatement(forInOrOfStatement) {
        if (checkGrammarStatementInAmbientContext(forInOrOfStatement)) {
          return true;
        }
        if (forInOrOfStatement.initializer.kind === 210) {
          var variableList = forInOrOfStatement.initializer;
          if (!checkGrammarVariableDeclarationList(variableList)) {
            if (variableList.declarations.length > 1) {
              var diagnostic = forInOrOfStatement.kind === 198 ? ts.Diagnostics.Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement : ts.Diagnostics.Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement;
              return grammarErrorOnFirstToken(variableList.declarations[1], diagnostic);
            }
            var firstDeclaration = variableList.declarations[0];
            if (firstDeclaration.initializer) {
              var diagnostic = forInOrOfStatement.kind === 198 ? ts.Diagnostics.The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer : ts.Diagnostics.The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer;
              return grammarErrorOnNode(firstDeclaration.name, diagnostic);
            }
            if (firstDeclaration.type) {
              var diagnostic = forInOrOfStatement.kind === 198 ? ts.Diagnostics.The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation : ts.Diagnostics.The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation;
              return grammarErrorOnNode(firstDeclaration, diagnostic);
            }
          }
        }
        return false;
      }
      function checkGrammarAccessor(accessor) {
        var kind = accessor.kind;
        if (languageVersion < 1) {
          return grammarErrorOnNode(accessor.name, ts.Diagnostics.Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher);
        } else if (ts.isInAmbientContext(accessor)) {
          return grammarErrorOnNode(accessor.name, ts.Diagnostics.An_accessor_cannot_be_declared_in_an_ambient_context);
        } else if (accessor.body === undefined) {
          return grammarErrorAtPos(ts.getSourceFileOfNode(accessor), accessor.end - 1, ";".length, ts.Diagnostics._0_expected, "{");
        } else if (accessor.typeParameters) {
          return grammarErrorOnNode(accessor.name, ts.Diagnostics.An_accessor_cannot_have_type_parameters);
        } else if (kind === 143 && accessor.parameters.length) {
          return grammarErrorOnNode(accessor.name, ts.Diagnostics.A_get_accessor_cannot_have_parameters);
        } else if (kind === 144) {
          if (accessor.type) {
            return grammarErrorOnNode(accessor.name, ts.Diagnostics.A_set_accessor_cannot_have_a_return_type_annotation);
          } else if (accessor.parameters.length !== 1) {
            return grammarErrorOnNode(accessor.name, ts.Diagnostics.A_set_accessor_must_have_exactly_one_parameter);
          } else {
            var parameter = accessor.parameters[0];
            if (parameter.dotDotDotToken) {
              return grammarErrorOnNode(parameter.dotDotDotToken, ts.Diagnostics.A_set_accessor_cannot_have_rest_parameter);
            } else if (parameter.flags & 2035) {
              return grammarErrorOnNode(accessor.name, ts.Diagnostics.A_parameter_property_is_only_allowed_in_a_constructor_implementation);
            } else if (parameter.questionToken) {
              return grammarErrorOnNode(parameter.questionToken, ts.Diagnostics.A_set_accessor_cannot_have_an_optional_parameter);
            } else if (parameter.initializer) {
              return grammarErrorOnNode(accessor.name, ts.Diagnostics.A_set_accessor_parameter_cannot_have_an_initializer);
            }
          }
        }
      }
      function checkGrammarForNonSymbolComputedProperty(node, message) {
        if (node.kind === 134 && !ts.isWellKnownSymbolSyntactically(node.expression)) {
          return grammarErrorOnNode(node, message);
        }
      }
      function checkGrammarMethod(node) {
        if (checkGrammarDisallowedModifiersOnObjectLiteralExpressionMethod(node) || checkGrammarFunctionLikeDeclaration(node) || checkGrammarForGenerator(node)) {
          return true;
        }
        if (node.parent.kind === 163) {
          if (checkGrammarForInvalidQuestionMark(node, node.questionToken, ts.Diagnostics.A_class_member_cannot_be_declared_optional)) {
            return true;
          } else if (node.body === undefined) {
            return grammarErrorAtPos(getSourceFile(node), node.end - 1, ";".length, ts.Diagnostics._0_expected, "{");
          }
        }
        if (ts.isClassLike(node.parent)) {
          if (checkGrammarForInvalidQuestionMark(node, node.questionToken, ts.Diagnostics.A_class_member_cannot_be_declared_optional)) {
            return true;
          }
          if (ts.isInAmbientContext(node)) {
            return checkGrammarForNonSymbolComputedProperty(node.name, ts.Diagnostics.A_computed_property_name_in_an_ambient_context_must_directly_refer_to_a_built_in_symbol);
          } else if (!node.body) {
            return checkGrammarForNonSymbolComputedProperty(node.name, ts.Diagnostics.A_computed_property_name_in_a_method_overload_must_directly_refer_to_a_built_in_symbol);
          }
        } else if (node.parent.kind === 213) {
          return checkGrammarForNonSymbolComputedProperty(node.name, ts.Diagnostics.A_computed_property_name_in_an_interface_must_directly_refer_to_a_built_in_symbol);
        } else if (node.parent.kind === 153) {
          return checkGrammarForNonSymbolComputedProperty(node.name, ts.Diagnostics.A_computed_property_name_in_a_type_literal_must_directly_refer_to_a_built_in_symbol);
        }
      }
      function isIterationStatement(node, lookInLabeledStatements) {
        switch (node.kind) {
          case 197:
          case 198:
          case 199:
          case 195:
          case 196:
            return true;
          case 205:
            return lookInLabeledStatements && isIterationStatement(node.statement, lookInLabeledStatements);
        }
        return false;
      }
      function checkGrammarBreakOrContinueStatement(node) {
        var current = node;
        while (current) {
          if (ts.isFunctionLike(current)) {
            return grammarErrorOnNode(node, ts.Diagnostics.Jump_target_cannot_cross_function_boundary);
          }
          switch (current.kind) {
            case 205:
              if (node.label && current.label.text === node.label.text) {
                var isMisplacedContinueLabel = node.kind === 200 && !isIterationStatement(current.statement, true);
                if (isMisplacedContinueLabel) {
                  return grammarErrorOnNode(node, ts.Diagnostics.A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement);
                }
                return false;
              }
              break;
            case 204:
              if (node.kind === 201 && !node.label) {
                return false;
              }
              break;
            default:
              if (isIterationStatement(current, false) && !node.label) {
                return false;
              }
              break;
          }
          current = current.parent;
        }
        if (node.label) {
          var message = node.kind === 201 ? ts.Diagnostics.A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement : ts.Diagnostics.A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement;
          return grammarErrorOnNode(node, message);
        } else {
          var message = node.kind === 201 ? ts.Diagnostics.A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement : ts.Diagnostics.A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement;
          return grammarErrorOnNode(node, message);
        }
      }
      function checkGrammarBindingElement(node) {
        if (node.dotDotDotToken) {
          var elements = node.parent.elements;
          if (node !== ts.lastOrUndefined(elements)) {
            return grammarErrorOnNode(node, ts.Diagnostics.A_rest_element_must_be_last_in_an_array_destructuring_pattern);
          }
          if (node.name.kind === 160 || node.name.kind === 159) {
            return grammarErrorOnNode(node.name, ts.Diagnostics.A_rest_element_cannot_contain_a_binding_pattern);
          }
          if (node.initializer) {
            return grammarErrorAtPos(ts.getSourceFileOfNode(node), node.initializer.pos - 1, 1, ts.Diagnostics.A_rest_element_cannot_have_an_initializer);
          }
        }
      }
      function checkGrammarVariableDeclaration(node) {
        if (node.parent.parent.kind !== 198 && node.parent.parent.kind !== 199) {
          if (ts.isInAmbientContext(node)) {
            if (node.initializer) {
              var equalsTokenLength = "=".length;
              return grammarErrorAtPos(ts.getSourceFileOfNode(node), node.initializer.pos - equalsTokenLength, equalsTokenLength, ts.Diagnostics.Initializers_are_not_allowed_in_ambient_contexts);
            }
          } else if (!node.initializer) {
            if (ts.isBindingPattern(node.name) && !ts.isBindingPattern(node.parent)) {
              return grammarErrorOnNode(node, ts.Diagnostics.A_destructuring_declaration_must_have_an_initializer);
            }
            if (ts.isConst(node)) {
              return grammarErrorOnNode(node, ts.Diagnostics.const_declarations_must_be_initialized);
            }
          }
        }
        var checkLetConstNames = languageVersion >= 2 && (ts.isLet(node) || ts.isConst(node));
        return checkLetConstNames && checkGrammarNameInLetOrConstDeclarations(node.name);
      }
      function checkGrammarNameInLetOrConstDeclarations(name) {
        if (name.kind === 67) {
          if (name.text === "let") {
            return grammarErrorOnNode(name, ts.Diagnostics.let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations);
          }
        } else {
          var elements = name.elements;
          for (var _i = 0; _i < elements.length; _i++) {
            var element = elements[_i];
            if (element.kind !== 185) {
              checkGrammarNameInLetOrConstDeclarations(element.name);
            }
          }
        }
      }
      function checkGrammarVariableDeclarationList(declarationList) {
        var declarations = declarationList.declarations;
        if (checkGrammarForDisallowedTrailingComma(declarationList.declarations)) {
          return true;
        }
        if (!declarationList.declarations.length) {
          return grammarErrorAtPos(ts.getSourceFileOfNode(declarationList), declarations.pos, declarations.end - declarations.pos, ts.Diagnostics.Variable_declaration_list_cannot_be_empty);
        }
      }
      function allowLetAndConstDeclarations(parent) {
        switch (parent.kind) {
          case 194:
          case 195:
          case 196:
          case 203:
          case 197:
          case 198:
          case 199:
            return false;
          case 205:
            return allowLetAndConstDeclarations(parent.parent);
        }
        return true;
      }
      function checkGrammarForDisallowedLetOrConstStatement(node) {
        if (!allowLetAndConstDeclarations(node.parent)) {
          if (ts.isLet(node.declarationList)) {
            return grammarErrorOnNode(node, ts.Diagnostics.let_declarations_can_only_be_declared_inside_a_block);
          } else if (ts.isConst(node.declarationList)) {
            return grammarErrorOnNode(node, ts.Diagnostics.const_declarations_can_only_be_declared_inside_a_block);
          }
        }
      }
      function isIntegerLiteral(expression) {
        if (expression.kind === 177) {
          var unaryExpression = expression;
          if (unaryExpression.operator === 35 || unaryExpression.operator === 36) {
            expression = unaryExpression.operand;
          }
        }
        if (expression.kind === 8) {
          return /^[0-9]+([eE]\+?[0-9]+)?$/.test(expression.text);
        }
        return false;
      }
      function checkGrammarEnumDeclaration(enumDecl) {
        var enumIsConst = (enumDecl.flags & 32768) !== 0;
        var hasError = false;
        if (!enumIsConst) {
          var inConstantEnumMemberSection = true;
          var inAmbientContext = ts.isInAmbientContext(enumDecl);
          for (var _i = 0,
              _a = enumDecl.members; _i < _a.length; _i++) {
            var node = _a[_i];
            if (node.name.kind === 134) {
              hasError = grammarErrorOnNode(node.name, ts.Diagnostics.Computed_property_names_are_not_allowed_in_enums);
            } else if (inAmbientContext) {
              if (node.initializer && !isIntegerLiteral(node.initializer)) {
                hasError = grammarErrorOnNode(node.name, ts.Diagnostics.Ambient_enum_elements_can_only_have_integer_literal_initializers) || hasError;
              }
            } else if (node.initializer) {
              inConstantEnumMemberSection = isIntegerLiteral(node.initializer);
            } else if (!inConstantEnumMemberSection) {
              hasError = grammarErrorOnNode(node.name, ts.Diagnostics.Enum_member_must_have_initializer) || hasError;
            }
          }
        }
        return hasError;
      }
      function hasParseDiagnostics(sourceFile) {
        return sourceFile.parseDiagnostics.length > 0;
      }
      function grammarErrorOnFirstToken(node, message, arg0, arg1, arg2) {
        var sourceFile = ts.getSourceFileOfNode(node);
        if (!hasParseDiagnostics(sourceFile)) {
          var span = ts.getSpanOfTokenAtPosition(sourceFile, node.pos);
          diagnostics.add(ts.createFileDiagnostic(sourceFile, span.start, span.length, message, arg0, arg1, arg2));
          return true;
        }
      }
      function grammarErrorAtPos(sourceFile, start, length, message, arg0, arg1, arg2) {
        if (!hasParseDiagnostics(sourceFile)) {
          diagnostics.add(ts.createFileDiagnostic(sourceFile, start, length, message, arg0, arg1, arg2));
          return true;
        }
      }
      function grammarErrorOnNode(node, message, arg0, arg1, arg2) {
        var sourceFile = ts.getSourceFileOfNode(node);
        if (!hasParseDiagnostics(sourceFile)) {
          diagnostics.add(ts.createDiagnosticForNode(node, message, arg0, arg1, arg2));
          return true;
        }
      }
      function isEvalOrArgumentsIdentifier(node) {
        return node.kind === 67 && (node.text === "eval" || node.text === "arguments");
      }
      function checkGrammarConstructorTypeParameters(node) {
        if (node.typeParameters) {
          return grammarErrorAtPos(ts.getSourceFileOfNode(node), node.typeParameters.pos, node.typeParameters.end - node.typeParameters.pos, ts.Diagnostics.Type_parameters_cannot_appear_on_a_constructor_declaration);
        }
      }
      function checkGrammarConstructorTypeAnnotation(node) {
        if (node.type) {
          return grammarErrorOnNode(node.type, ts.Diagnostics.Type_annotation_cannot_appear_on_a_constructor_declaration);
        }
      }
      function checkGrammarProperty(node) {
        if (ts.isClassLike(node.parent)) {
          if (checkGrammarForInvalidQuestionMark(node, node.questionToken, ts.Diagnostics.A_class_member_cannot_be_declared_optional) || checkGrammarForNonSymbolComputedProperty(node.name, ts.Diagnostics.A_computed_property_name_in_a_class_property_declaration_must_directly_refer_to_a_built_in_symbol)) {
            return true;
          }
        } else if (node.parent.kind === 213) {
          if (checkGrammarForNonSymbolComputedProperty(node.name, ts.Diagnostics.A_computed_property_name_in_an_interface_must_directly_refer_to_a_built_in_symbol)) {
            return true;
          }
        } else if (node.parent.kind === 153) {
          if (checkGrammarForNonSymbolComputedProperty(node.name, ts.Diagnostics.A_computed_property_name_in_a_type_literal_must_directly_refer_to_a_built_in_symbol)) {
            return true;
          }
        }
        if (ts.isInAmbientContext(node) && node.initializer) {
          return grammarErrorOnFirstToken(node.initializer, ts.Diagnostics.Initializers_are_not_allowed_in_ambient_contexts);
        }
      }
      function checkGrammarTopLevelElementForRequiredDeclareModifier(node) {
        if (node.kind === 213 || node.kind === 220 || node.kind === 219 || node.kind === 226 || node.kind === 225 || (node.flags & 2) || (node.flags & (1 | 1024))) {
          return false;
        }
        return grammarErrorOnFirstToken(node, ts.Diagnostics.A_declare_modifier_is_required_for_a_top_level_declaration_in_a_d_ts_file);
      }
      function checkGrammarTopLevelElementsForRequiredDeclareModifier(file) {
        for (var _i = 0,
            _a = file.statements; _i < _a.length; _i++) {
          var decl = _a[_i];
          if (ts.isDeclaration(decl) || decl.kind === 191) {
            if (checkGrammarTopLevelElementForRequiredDeclareModifier(decl)) {
              return true;
            }
          }
        }
      }
      function checkGrammarSourceFile(node) {
        return ts.isInAmbientContext(node) && checkGrammarTopLevelElementsForRequiredDeclareModifier(node);
      }
      function checkGrammarStatementInAmbientContext(node) {
        if (ts.isInAmbientContext(node)) {
          if (isAccessor(node.parent.kind)) {
            return getNodeLinks(node).hasReportedStatementInAmbientContext = true;
          }
          var links = getNodeLinks(node);
          if (!links.hasReportedStatementInAmbientContext && ts.isFunctionLike(node.parent)) {
            return getNodeLinks(node).hasReportedStatementInAmbientContext = grammarErrorOnFirstToken(node, ts.Diagnostics.An_implementation_cannot_be_declared_in_ambient_contexts);
          }
          if (node.parent.kind === 190 || node.parent.kind === 217 || node.parent.kind === 246) {
            var links_1 = getNodeLinks(node.parent);
            if (!links_1.hasReportedStatementInAmbientContext) {
              return links_1.hasReportedStatementInAmbientContext = grammarErrorOnFirstToken(node, ts.Diagnostics.Statements_are_not_allowed_in_ambient_contexts);
            }
          } else {}
        }
      }
      function checkGrammarNumericLiteral(node) {
        if (node.flags & 65536 && languageVersion >= 1) {
          return grammarErrorOnNode(node, ts.Diagnostics.Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher);
        }
      }
      function grammarErrorAfterFirstToken(node, message, arg0, arg1, arg2) {
        var sourceFile = ts.getSourceFileOfNode(node);
        if (!hasParseDiagnostics(sourceFile)) {
          var span = ts.getSpanOfTokenAtPosition(sourceFile, node.pos);
          diagnostics.add(ts.createFileDiagnostic(sourceFile, ts.textSpanEnd(span), 0, message, arg0, arg1, arg2));
          return true;
        }
      }
    }
    ts.createTypeChecker = createTypeChecker;
  })(ts || (ts = {}));
  var ts;
  (function(ts) {
    function getDeclarationDiagnostics(host, resolver, targetSourceFile) {
      var diagnostics = [];
      var jsFilePath = ts.getOwnEmitOutputFilePath(targetSourceFile, host, ".js");
      emitDeclarations(host, resolver, diagnostics, jsFilePath, targetSourceFile);
      return diagnostics;
    }
    ts.getDeclarationDiagnostics = getDeclarationDiagnostics;
    function emitDeclarations(host, resolver, diagnostics, jsFilePath, root) {
      var newLine = host.getNewLine();
      var compilerOptions = host.getCompilerOptions();
      var write;
      var writeLine;
      var increaseIndent;
      var decreaseIndent;
      var writeTextOfNode;
      var writer = createAndSetNewTextWriterWithSymbolWriter();
      var enclosingDeclaration;
      var currentSourceFile;
      var reportedDeclarationError = false;
      var emitJsDocComments = compilerOptions.removeComments ? function(declaration) {} : writeJsDocComments;
      var emit = compilerOptions.stripInternal ? stripInternal : emitNode;
      var moduleElementDeclarationEmitInfo = [];
      var asynchronousSubModuleDeclarationEmitInfo;
      var referencePathsOutput = "";
      if (root) {
        if (!compilerOptions.noResolve) {
          var addedGlobalFileReference = false;
          ts.forEach(root.referencedFiles, function(fileReference) {
            var referencedFile = ts.tryResolveScriptReference(host, root, fileReference);
            if (referencedFile && ((referencedFile.flags & 8192) || ts.shouldEmitToOwnFile(referencedFile, compilerOptions) || !addedGlobalFileReference)) {
              writeReferencePath(referencedFile);
              if (!ts.isExternalModuleOrDeclarationFile(referencedFile)) {
                addedGlobalFileReference = true;
              }
            }
          });
        }
        emitSourceFile(root);
        if (moduleElementDeclarationEmitInfo.length) {
          var oldWriter = writer;
          ts.forEach(moduleElementDeclarationEmitInfo, function(aliasEmitInfo) {
            if (aliasEmitInfo.isVisible) {
              ts.Debug.assert(aliasEmitInfo.node.kind === 220);
              createAndSetNewTextWriterWithSymbolWriter();
              ts.Debug.assert(aliasEmitInfo.indent === 0);
              writeImportDeclaration(aliasEmitInfo.node);
              aliasEmitInfo.asynchronousOutput = writer.getText();
            }
          });
          setWriter(oldWriter);
        }
      } else {
        var emittedReferencedFiles = [];
        ts.forEach(host.getSourceFiles(), function(sourceFile) {
          if (!ts.isExternalModuleOrDeclarationFile(sourceFile)) {
            if (!compilerOptions.noResolve) {
              ts.forEach(sourceFile.referencedFiles, function(fileReference) {
                var referencedFile = ts.tryResolveScriptReference(host, sourceFile, fileReference);
                if (referencedFile && (ts.isExternalModuleOrDeclarationFile(referencedFile) && !ts.contains(emittedReferencedFiles, referencedFile))) {
                  writeReferencePath(referencedFile);
                  emittedReferencedFiles.push(referencedFile);
                }
              });
            }
            emitSourceFile(sourceFile);
          }
        });
      }
      return {
        reportedDeclarationError: reportedDeclarationError,
        moduleElementDeclarationEmitInfo: moduleElementDeclarationEmitInfo,
        synchronousDeclarationOutput: writer.getText(),
        referencePathsOutput: referencePathsOutput
      };
      function hasInternalAnnotation(range) {
        var text = currentSourceFile.text;
        var comment = text.substring(range.pos, range.end);
        return comment.indexOf("@internal") >= 0;
      }
      function stripInternal(node) {
        if (node) {
          var leadingCommentRanges = ts.getLeadingCommentRanges(currentSourceFile.text, node.pos);
          if (ts.forEach(leadingCommentRanges, hasInternalAnnotation)) {
            return;
          }
          emitNode(node);
        }
      }
      function createAndSetNewTextWriterWithSymbolWriter() {
        var writer = ts.createTextWriter(newLine);
        writer.trackSymbol = trackSymbol;
        writer.writeKeyword = writer.write;
        writer.writeOperator = writer.write;
        writer.writePunctuation = writer.write;
        writer.writeSpace = writer.write;
        writer.writeStringLiteral = writer.writeLiteral;
        writer.writeParameter = writer.write;
        writer.writeSymbol = writer.write;
        setWriter(writer);
        return writer;
      }
      function setWriter(newWriter) {
        writer = newWriter;
        write = newWriter.write;
        writeTextOfNode = newWriter.writeTextOfNode;
        writeLine = newWriter.writeLine;
        increaseIndent = newWriter.increaseIndent;
        decreaseIndent = newWriter.decreaseIndent;
      }
      function writeAsynchronousModuleElements(nodes) {
        var oldWriter = writer;
        ts.forEach(nodes, function(declaration) {
          var nodeToCheck;
          if (declaration.kind === 209) {
            nodeToCheck = declaration.parent.parent;
          } else if (declaration.kind === 223 || declaration.kind === 224 || declaration.kind === 221) {
            ts.Debug.fail("We should be getting ImportDeclaration instead to write");
          } else {
            nodeToCheck = declaration;
          }
          var moduleElementEmitInfo = ts.forEach(moduleElementDeclarationEmitInfo, function(declEmitInfo) {
            return declEmitInfo.node === nodeToCheck ? declEmitInfo : undefined;
          });
          if (!moduleElementEmitInfo && asynchronousSubModuleDeclarationEmitInfo) {
            moduleElementEmitInfo = ts.forEach(asynchronousSubModuleDeclarationEmitInfo, function(declEmitInfo) {
              return declEmitInfo.node === nodeToCheck ? declEmitInfo : undefined;
            });
          }
          if (moduleElementEmitInfo) {
            if (moduleElementEmitInfo.node.kind === 220) {
              moduleElementEmitInfo.isVisible = true;
            } else {
              createAndSetNewTextWriterWithSymbolWriter();
              for (var declarationIndent = moduleElementEmitInfo.indent; declarationIndent; declarationIndent--) {
                increaseIndent();
              }
              if (nodeToCheck.kind === 216) {
                ts.Debug.assert(asynchronousSubModuleDeclarationEmitInfo === undefined);
                asynchronousSubModuleDeclarationEmitInfo = [];
              }
              writeModuleElement(nodeToCheck);
              if (nodeToCheck.kind === 216) {
                moduleElementEmitInfo.subModuleElementDeclarationEmitInfo = asynchronousSubModuleDeclarationEmitInfo;
                asynchronousSubModuleDeclarationEmitInfo = undefined;
              }
              moduleElementEmitInfo.asynchronousOutput = writer.getText();
            }
          }
        });
        setWriter(oldWriter);
      }
      function handleSymbolAccessibilityError(symbolAccesibilityResult) {
        if (symbolAccesibilityResult.accessibility === 0) {
          if (symbolAccesibilityResult && symbolAccesibilityResult.aliasesToMakeVisible) {
            writeAsynchronousModuleElements(symbolAccesibilityResult.aliasesToMakeVisible);
          }
        } else {
          reportedDeclarationError = true;
          var errorInfo = writer.getSymbolAccessibilityDiagnostic(symbolAccesibilityResult);
          if (errorInfo) {
            if (errorInfo.typeName) {
              diagnostics.push(ts.createDiagnosticForNode(symbolAccesibilityResult.errorNode || errorInfo.errorNode, errorInfo.diagnosticMessage, ts.getSourceTextOfNodeFromSourceFile(currentSourceFile, errorInfo.typeName), symbolAccesibilityResult.errorSymbolName, symbolAccesibilityResult.errorModuleName));
            } else {
              diagnostics.push(ts.createDiagnosticForNode(symbolAccesibilityResult.errorNode || errorInfo.errorNode, errorInfo.diagnosticMessage, symbolAccesibilityResult.errorSymbolName, symbolAccesibilityResult.errorModuleName));
            }
          }
        }
      }
      function trackSymbol(symbol, enclosingDeclaration, meaning) {
        handleSymbolAccessibilityError(resolver.isSymbolAccessible(symbol, enclosingDeclaration, meaning));
      }
      function writeTypeOfDeclaration(declaration, type, getSymbolAccessibilityDiagnostic) {
        writer.getSymbolAccessibilityDiagnostic = getSymbolAccessibilityDiagnostic;
        write(": ");
        if (type) {
          emitType(type);
        } else {
          resolver.writeTypeOfDeclaration(declaration, enclosingDeclaration, 2, writer);
        }
      }
      function writeReturnTypeAtSignature(signature, getSymbolAccessibilityDiagnostic) {
        writer.getSymbolAccessibilityDiagnostic = getSymbolAccessibilityDiagnostic;
        write(": ");
        if (signature.type) {
          emitType(signature.type);
        } else {
          resolver.writeReturnTypeOfSignatureDeclaration(signature, enclosingDeclaration, 2, writer);
        }
      }
      function emitLines(nodes) {
        for (var _i = 0; _i < nodes.length; _i++) {
          var node = nodes[_i];
          emit(node);
        }
      }
      function emitSeparatedList(nodes, separator, eachNodeEmitFn, canEmitFn) {
        var currentWriterPos = writer.getTextPos();
        for (var _i = 0; _i < nodes.length; _i++) {
          var node = nodes[_i];
          if (!canEmitFn || canEmitFn(node)) {
            if (currentWriterPos !== writer.getTextPos()) {
              write(separator);
            }
            currentWriterPos = writer.getTextPos();
            eachNodeEmitFn(node);
          }
        }
      }
      function emitCommaList(nodes, eachNodeEmitFn, canEmitFn) {
        emitSeparatedList(nodes, ", ", eachNodeEmitFn, canEmitFn);
      }
      function writeJsDocComments(declaration) {
        if (declaration) {
          var jsDocComments = ts.getJsDocComments(declaration, currentSourceFile);
          ts.emitNewLineBeforeLeadingComments(currentSourceFile, writer, declaration, jsDocComments);
          ts.emitComments(currentSourceFile, writer, jsDocComments, true, newLine, ts.writeCommentRange);
        }
      }
      function emitTypeWithNewGetSymbolAccessibilityDiagnostic(type, getSymbolAccessibilityDiagnostic) {
        writer.getSymbolAccessibilityDiagnostic = getSymbolAccessibilityDiagnostic;
        emitType(type);
      }
      function emitTyp