/* */ 
"format cjs";
var ts = require('typescript');
var logger_1 = require('./logger');
var utils_1 = require('./utils');
var logger = new logger_1.default({ debug: false });
exports.__HTML_MODULE__ = "__html_module__";
;
var CompilerHost = (function () {
    function CompilerHost(options) {
        this._options = options || {};
        this._options.module = this.getEnum(this._options.module, ts.ModuleKind, 4);
        this._options.target = this.getEnum(this._options.target, ts.ScriptTarget, 1);
        this._options.jsx = this.getEnum(this._options.jsx, ts.JsxEmit, 0);
        this._options.allowNonTsExtensions = (this._options.allowNonTsExtensions !== false);
        this._options.skipDefaultLibCheck = (this._options.skipDefaultLibCheck !== false);
        this._options.noResolve = true;
        this._files = {};
        this._fileResMaps = {};
        this.addFile(exports.__HTML_MODULE__, "var __html__: string = ''; export default __html__;");
    }
    CompilerHost.prototype.getEnum = function (enumValue, enumType, defaultValue) {
        if (enumValue == undefined)
            return defaultValue;
        for (var enumProp in enumType) {
            if (enumProp.toLowerCase() === enumValue.toString().toLowerCase()) {
                if (typeof enumType[enumProp] === "string")
                    return enumType[enumType[enumProp]];
                else
                    return enumType[enumProp];
            }
        }
        throw new Error("Unrecognised value [" + enumValue + "]");
    };
    Object.defineProperty(CompilerHost.prototype, "options", {
        get: function () {
            return this._options;
        },
        enumerable: true,
        configurable: true
    });
    CompilerHost.prototype.getSourceFile = function (fileName) {
        return this._files[fileName];
    };
    CompilerHost.prototype.fileExists = function (fileName) {
        return !!this._files[fileName];
    };
    CompilerHost.prototype.readFile = function (fileName) {
        throw new Error("Not implemented");
    };
    CompilerHost.prototype.writeFile = function (name, text, writeByteOrderMark) {
        throw new Error("Not implemented");
    };
    CompilerHost.prototype.getDefaultLibFileName = function () {
        return "typescript/lib/lib.es6.d.ts";
    };
    CompilerHost.prototype.useCaseSensitiveFileNames = function () {
        return false;
    };
    CompilerHost.prototype.getCanonicalFileName = function (fileName) {
        return fileName;
    };
    CompilerHost.prototype.getCurrentDirectory = function () {
        return "";
    };
    CompilerHost.prototype.getNewLine = function () {
        return "\n";
    };
    CompilerHost.prototype.addFile = function (filename, text, isDefaultLib) {
        if (isDefaultLib === void 0) { isDefaultLib = false; }
        this._files[filename] = ts.createSourceFile(filename, text, this._options.target);
        this._files[filename].isDefaultLib = isDefaultLib;
        logger.debug("added " + filename);
        return this._files[filename];
    };
    CompilerHost.prototype.addResolutionMap = function (filename, map) {
        this._fileResMaps[filename] = map;
    };
    CompilerHost.prototype.resolveModuleNames = function (moduleNames, containingFile) {
        var _this = this;
        return moduleNames.map(function (modName) {
            var mappings = _this._fileResMaps[containingFile];
            if (utils_1.isHtml(modName)) {
                return { resolvedFileName: exports.__HTML_MODULE__ };
            }
            else if (mappings) {
                var resolvedFileName = mappings[modName];
                var isExternalLibraryImport = utils_1.isTypescriptDeclaration(resolvedFileName);
                return { resolvedFileName: resolvedFileName, isExternalLibraryImport: isExternalLibraryImport };
            }
            else {
                return ts.resolveModuleName(modName, containingFile, _this._options, _this).resolvedModule;
            }
        });
    };
    return CompilerHost;
})();
exports.CompilerHost = CompilerHost;
//# sourceMappingURL=data:application/json;base64,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