/* */ 
var ts = require('typescript');
var logger_1 = require('./logger');
var factory_1 = require('./factory');
var format_errors_1 = require('./format-errors');
var utils_1 = require('./utils');
var logger = new logger_1.default({ debug: false });
var factory = factory_1.createFactory(System.typescriptOptions, _resolve, _fetch);
var typeCheckErrored = false;
function translate(load) {
    var _this = this;
    logger.debug("systemjs translating " + load.address);
    return factory.then(function (_a) {
        var transpiler = _a.transpiler, typeChecker = _a.typeChecker, host = _a.host;
        var result = transpiler.transpile(load.address, load.source);
        format_errors_1.formatErrors(result.errors, logger);
        if (result.failure)
            throw new Error("TypeScript transpilation failed");
        if (host.options.typeCheck && utils_1.isTypescript(load.address)) {
            typeChecker.check(load.address, load.source)
                .catch(function (err) { return logger.error(err.message); })
                .then(function (diags) {
                format_errors_1.formatErrors(diags, logger);
                if (diags.some(function (diag) { return diag.category === ts.DiagnosticCategory.Error; }))
                    typeCheckErrored = true;
            });
        }
        if (_this.loader && (host.options.module === 4))
            load.source = wrapSource(result.js, load);
        else
            load.source = result.js;
        if (result.sourceMap)
            load.metadata.sourceMap = JSON.parse(result.sourceMap);
        if (host.options.module === 4)
            load.metadata.format = 'register';
        else if (host.options.module === 5)
            load.metadata.format = 'esm';
        return load;
    });
}
exports.translate = translate;
function wrapSource(source, load) {
    return '(function(__moduleName){' + source + '\n})("' + load.name + '");\n//# sourceURL=' + load.address + '!transpiled';
}
function bundle() {
    if (typeCheckErrored && System.typescriptOptions.typeCheck === "strict") {
        typeCheckErrored = false;
        throw new Error("TypeScript found type errors");
    }
    return [];
}
exports.bundle = bundle;
function _resolve(dep, parent) {
    return System.normalize(dep, parent)
        .then(function (normalized) {
        normalized = utils_1.stripDoubleExtension(normalized);
        logger.debug("resolved " + normalized + " (" + parent + " -> " + dep + ")");
        return normalized;
    });
}
function _fetch(address) {
    return System.fetch({ address: address, name: address, metadata: {} })
        .then(function (text) {
        logger.debug("fetched " + address);
        return text;
    });
}
//# sourceMappingURL=data:application/json;base64,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