/* */ 
function isAbsolute(filename) {
    return (filename[0] == '/');
}
exports.isAbsolute = isAbsolute;
function isRelative(filename) {
    return (filename[0] == '.');
}
exports.isRelative = isRelative;
function isAmbientImport(filename) {
    return (isAmbient(filename) && !isTypescriptDeclaration(filename));
}
exports.isAmbientImport = isAmbientImport;
function isAmbientReference(filename) {
    return (isAmbient(filename) && isTypescriptDeclaration(filename));
}
exports.isAmbientReference = isAmbientReference;
function isAmbient(filename) {
    return (!isRelative(filename) && !isAbsolute(filename));
}
exports.isAmbient = isAmbient;
var typescriptRegex = /\.tsx?$/i;
function isTypescript(filename) {
    return typescriptRegex.test(filename);
}
exports.isTypescript = isTypescript;
var javascriptRegex = /\.js$/i;
function isJavaScript(filename) {
    return javascriptRegex.test(filename);
}
exports.isJavaScript = isJavaScript;
var mapRegex = /\.map$/i;
function isSourceMap(filename) {
    return mapRegex.test(filename);
}
exports.isSourceMap = isSourceMap;
var declarationRegex = /\.d\.tsx?$/i;
function isTypescriptDeclaration(filename) {
    return declarationRegex.test(filename);
}
exports.isTypescriptDeclaration = isTypescriptDeclaration;
var htmlRegex = /\.html$/i;
function isHtml(filename) {
    return htmlRegex.test(filename);
}
exports.isHtml = isHtml;
function tsToJs(tsFile) {
    return tsFile.replace(typescriptRegex, '.js');
}
exports.tsToJs = tsToJs;
function tsToJsMap(tsFile) {
    return tsFile.replace(typescriptRegex, '.js.map');
}
exports.tsToJsMap = tsToJsMap;
function jsToDts(jsFile) {
    return jsFile.replace(javascriptRegex, '.d.ts');
}
exports.jsToDts = jsToDts;
function stripDoubleExtension(normalized) {
    var parts = normalized.split('.');
    if (parts.length > 1) {
        var extensions = ["js", "jsx", "ts", "tsx", "json"];
        if (extensions.indexOf(parts[parts.length - 2]) >= 0) {
            return parts.slice(0, -1).join('.');
        }
    }
    return normalized;
}
exports.stripDoubleExtension = stripDoubleExtension;
//# sourceMappingURL=data:application/json;base64,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