/* */ 
var canReorder = require('./reorderable').canReorder;
var extractProperties = require('./extractor');
function mergeMediaQueries(tokens) {
  var candidates = {};
  var reduced = [];
  for (var i = tokens.length - 1; i >= 0; i--) {
    var token = tokens[i];
    if (token[0] != 'block')
      continue;
    var candidate = candidates[token[1][0]];
    if (!candidate) {
      candidate = [];
      candidates[token[1][0]] = candidate;
    }
    candidate.push(i);
  }
  for (var name in candidates) {
    var positions = candidates[name];
    positionLoop: for (var j = positions.length - 1; j > 0; j--) {
      var positionOne = positions[j];
      var tokenOne = tokens[positionOne];
      var positionTwo = positions[j - 1];
      var tokenTwo = tokens[positionTwo];
      directionLoop: for (var direction = 1; direction >= -1; direction -= 2) {
        var topToBottom = direction == 1;
        var from = topToBottom ? positionOne + 1 : positionTwo - 1;
        var to = topToBottom ? positionTwo : positionOne;
        var delta = topToBottom ? 1 : -1;
        var source = topToBottom ? tokenOne : tokenTwo;
        var target = topToBottom ? tokenTwo : tokenOne;
        var movedProperties = extractProperties(source);
        while (from != to) {
          var traversedProperties = extractProperties(tokens[from]);
          from += delta;
          if (!canReorder(movedProperties, traversedProperties))
            continue directionLoop;
        }
        target[2] = topToBottom ? source[2].concat(target[2]) : target[2].concat(source[2]);
        source[2] = [];
        reduced.push(target);
        continue positionLoop;
      }
    }
  }
  return reduced;
}
module.exports = mergeMediaQueries;
