var ts = require('typescript');
var logger_1 = require('./logger');
var utils_1 = require('./utils');
var logger = new logger_1.default({ debug: false });
exports.__HTML_MODULE__ = "__html_module__";
;
var CompilerHost = (function () {
    function CompilerHost(options) {
        this._options = options || {};
        this._options.module = this.getEnum(this._options.module, ts.ModuleKind, 4);
        this._options.target = this.getEnum(this._options.target, ts.ScriptTarget, 1);
        this._options.jsx = this.getEnum(this._options.jsx, ts.JsxEmit, 0);
        this._options.allowNonTsExtensions = (this._options.allowNonTsExtensions !== false);
        this._options.skipDefaultLibCheck = (this._options.skipDefaultLibCheck !== false);
        this._options.noResolve = true;
        this._options.moduleResolution = 1;
        this._files = {};
        this._fileResMaps = {};
        this.addFile(exports.__HTML_MODULE__, "var __html__: string = ''; export default __html__;");
    }
    CompilerHost.prototype.getEnum = function (enumValue, enumType, defaultValue) {
        if (enumValue == undefined)
            return defaultValue;
        for (var enumProp in enumType) {
            if (enumProp.toLowerCase() === enumValue.toString().toLowerCase()) {
                if (typeof enumType[enumProp] === "string")
                    return enumType[enumType[enumProp]];
                else
                    return enumType[enumProp];
            }
        }
        throw new Error("Unrecognised value [" + enumValue + "]");
    };
    Object.defineProperty(CompilerHost.prototype, "options", {
        get: function () {
            return this._options;
        },
        enumerable: true,
        configurable: true
    });
    CompilerHost.prototype.getSourceFile = function (fileName) {
        fileName = this.getCanonicalFileName(fileName);
        return this._files[fileName];
    };
    CompilerHost.prototype.fileExists = function (fileName) {
        return !!this.getSourceFile(fileName);
    };
    CompilerHost.prototype.readFile = function (fileName) {
        throw new Error("Not implemented");
    };
    CompilerHost.prototype.writeFile = function (name, text, writeByteOrderMark) {
        throw new Error("Not implemented");
    };
    CompilerHost.prototype.getDefaultLibFileName = function () {
        return "typescript/lib/lib.es6.d.ts";
    };
    CompilerHost.prototype.useCaseSensitiveFileNames = function () {
        return false;
    };
    CompilerHost.prototype.getCanonicalFileName = function (fileName) {
        return ts.normalizePath(fileName);
    };
    CompilerHost.prototype.getCurrentDirectory = function () {
        return "";
    };
    CompilerHost.prototype.getNewLine = function () {
        return "\n";
    };
    CompilerHost.prototype.addFile = function (fileName, text, isDefaultLib) {
        if (isDefaultLib === void 0) { isDefaultLib = false; }
        fileName = this.getCanonicalFileName(fileName);
        this._files[fileName] = ts.createSourceFile(fileName, text, this._options.target);
        this._files[fileName].isDefaultLib = isDefaultLib;
        logger.debug("added " + fileName);
        return this._files[fileName];
    };
    CompilerHost.prototype.addResolutionMap = function (fileName, map) {
        fileName = this.getCanonicalFileName(fileName);
        this._fileResMaps[fileName] = map;
    };
    CompilerHost.prototype.resolveModuleNames = function (moduleNames, containingFile) {
        var _this = this;
        return moduleNames.map(function (modName) {
            var mappings = _this._fileResMaps[containingFile];
            if (utils_1.isHtml(modName)) {
                return { resolvedFileName: exports.__HTML_MODULE__ };
            }
            else if (mappings) {
                var resolvedFileName = mappings[modName];
                var isExternalLibraryImport = utils_1.isTypescriptDeclaration(resolvedFileName);
                return { resolvedFileName: resolvedFileName, isExternalLibraryImport: isExternalLibraryImport };
            }
            else {
                return ts.resolveModuleName(modName, containingFile, _this._options, _this).resolvedModule;
            }
        });
    };
    return CompilerHost;
})();
exports.CompilerHost = CompilerHost;
//# sourceMappingURL=data:application/json;base64,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