var ts = require('typescript');
var logger_1 = require('./logger');
var factory_1 = require('./factory');
var format_errors_1 = require('./format-errors');
var utils_1 = require('./utils');
var logger = new logger_1.default({ debug: false });
var factory = factory_1.createFactory(System.typescriptOptions, _resolve, _fetch);
var typeCheckErrored = false;
function translate(load) {
    var _this = this;
    logger.debug("systemjs translating " + load.address);
    return factory.then(function (_a) {
        var transpiler = _a.transpiler, typeChecker = _a.typeChecker, host = _a.host;
        var result = transpiler.transpile(load.address, load.source);
        format_errors_1.formatErrors(result.errors, logger);
        if (result.failure)
            throw new Error("TypeScript transpilation failed");
        if (host.options.typeCheck && utils_1.isTypescript(load.address)) {
            typeChecker.check(load.address, load.source)
                .catch(function (err) { return logger.error(err.message); })
                .then(function (diags) {
                format_errors_1.formatErrors(diags, logger);
                if (diags.some(function (diag) { return diag.category === ts.DiagnosticCategory.Error; }))
                    typeCheckErrored = true;
            });
        }
        if (_this.loader && (host.options.module === 4))
            load.source = wrapSource(result.js, load);
        else
            load.source = result.js;
        if (result.sourceMap)
            load.metadata.sourceMap = JSON.parse(result.sourceMap);
        if (host.options.module === 4)
            load.metadata.format = 'register';
        else if (host.options.module === 5)
            load.metadata.format = 'esm';
        return load.source;
    });
}
exports.translate = translate;
function wrapSource(source, load) {
    return '(function(__moduleName){' + source + '\n})("' + load.name + '");\n//# sourceURL=' + load.address + '!transpiled';
}
function bundle() {
    if (typeCheckErrored && System.typescriptOptions.typeCheck === "strict") {
        typeCheckErrored = false;
        throw new Error("TypeScript found type errors");
    }
    return [];
}
exports.bundle = bundle;
function _resolve(dep, parent) {
    return System.normalize(dep, parent)
        .then(function (normalized) {
        normalized = utils_1.stripDoubleExtension(normalized);
        logger.debug("resolved " + normalized + " (" + parent + " -> " + dep + ")");
        return normalized;
    });
}
function _fetch(address) {
    return System.fetch({ address: address, name: address, metadata: {} })
        .then(function (text) {
        logger.debug("fetched " + address);
        return text;
    });
}
//# sourceMappingURL=data:application/json;base64,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