/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Map;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class SetWindowSize
extends WebDriverHandler
implements JsonParametersAware {
    private Dimension size;

    public SetWindowSize(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        int height;
        int width;
        try {
            width = ((Number)allParameters.get("width")).intValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) window width value passed: " + allParameters.get("width"), ex);
        }
        try {
            height = ((Number)allParameters.get("height")).intValue();
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Illegal (non-numeric) window height value passed: " + allParameters.get("height"), ex);
        }
        this.size = new Dimension(width, height);
    }

    @Override
    public ResultType call() throws Exception {
        this.getDriver().manage().window().setSize(this.size);
        return ResultType.SUCCESS;
    }

    public String toString() {
        return "[set window size]";
    }
}

