/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.bridge.ReadableMap;

class SpringAnimation
extends AnimationDriver {
    private static final double MAX_DELTA_TIME_SEC = 0.064;
    private static final double SOLVER_TIMESTEP_SEC = 0.001;
    private long mLastTime;
    private boolean mSpringStarted;
    private double mSpringFriction;
    private double mSpringTension;
    private boolean mOvershootClampingEnabled;
    private final PhysicsState mCurrentState = new PhysicsState();
    private final PhysicsState mPreviousState = new PhysicsState();
    private final PhysicsState mTempState = new PhysicsState();
    private double mStartValue;
    private double mEndValue;
    private double mRestSpeedThreshold;
    private double mDisplacementFromRestThreshold;
    private double mTimeAccumulator = 0.0;

    SpringAnimation(ReadableMap config) {
        this.mSpringFriction = config.getDouble("friction");
        this.mSpringTension = config.getDouble("tension");
        this.mCurrentState.velocity = config.getDouble("initialVelocity");
        this.mEndValue = config.getDouble("toValue");
        this.mRestSpeedThreshold = config.getDouble("restSpeedThreshold");
        this.mDisplacementFromRestThreshold = config.getDouble("restDisplacementThreshold");
        this.mOvershootClampingEnabled = config.getBoolean("overshootClamping");
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        long frameTimeMillis = frameTimeNanos / 1000000L;
        if (!this.mSpringStarted) {
            this.mStartValue = this.mCurrentState.position = this.mAnimatedValue.mValue;
            this.mLastTime = frameTimeMillis;
            this.mSpringStarted = true;
        }
        this.advance((double)(frameTimeMillis - this.mLastTime) / 1000.0);
        this.mLastTime = frameTimeMillis;
        this.mAnimatedValue.mValue = this.mCurrentState.position;
        this.mHasFinished = this.isAtRest();
    }

    private double getDisplacementDistanceForState(PhysicsState state) {
        return Math.abs(this.mEndValue - state.position);
    }

    private boolean isAtRest() {
        return Math.abs(this.mCurrentState.velocity) <= this.mRestSpeedThreshold && (this.getDisplacementDistanceForState(this.mCurrentState) <= this.mDisplacementFromRestThreshold || this.mSpringTension == 0.0);
    }

    private boolean isOvershooting() {
        return this.mSpringTension > 0.0 && (this.mStartValue < this.mEndValue && this.mCurrentState.position > this.mEndValue || this.mStartValue > this.mEndValue && this.mCurrentState.position < this.mEndValue);
    }

    private void interpolate(double alpha) {
        this.mCurrentState.position = this.mCurrentState.position * alpha + this.mPreviousState.position * (1.0 - alpha);
        this.mCurrentState.velocity = this.mCurrentState.velocity * alpha + this.mPreviousState.velocity * (1.0 - alpha);
    }

    private void advance(double realDeltaTime) {
        if (this.isAtRest()) {
            return;
        }
        double adjustedDeltaTime = realDeltaTime;
        if (realDeltaTime > 0.064) {
            adjustedDeltaTime = 0.064;
        }
        this.mTimeAccumulator += adjustedDeltaTime;
        double tension = this.mSpringTension;
        double friction = this.mSpringFriction;
        double position = this.mCurrentState.position;
        double velocity = this.mCurrentState.velocity;
        double tempPosition = this.mTempState.position;
        double tempVelocity = this.mTempState.velocity;
        while (this.mTimeAccumulator >= 0.001) {
            this.mTimeAccumulator -= 0.001;
            if (this.mTimeAccumulator < 0.001) {
                this.mPreviousState.position = position;
                this.mPreviousState.velocity = velocity;
            }
            double aVelocity = velocity;
            double aAcceleration = tension * (this.mEndValue - tempPosition) - friction * velocity;
            tempPosition = position + aVelocity * 0.001 * 0.5;
            double bVelocity = tempVelocity = velocity + aAcceleration * 0.001 * 0.5;
            double bAcceleration = tension * (this.mEndValue - tempPosition) - friction * tempVelocity;
            tempPosition = position + bVelocity * 0.001 * 0.5;
            double cVelocity = tempVelocity = velocity + bAcceleration * 0.001 * 0.5;
            double cAcceleration = tension * (this.mEndValue - tempPosition) - friction * tempVelocity;
            tempPosition = position + cVelocity * 0.001;
            double dVelocity = tempVelocity = velocity + cAcceleration * 0.001;
            double dAcceleration = tension * (this.mEndValue - tempPosition) - friction * tempVelocity;
            double dxdt = 0.16666666666666666 * (aVelocity + 2.0 * (bVelocity + cVelocity) + dVelocity);
            double dvdt = 0.16666666666666666 * (aAcceleration + 2.0 * (bAcceleration + cAcceleration) + dAcceleration);
            position += dxdt * 0.001;
            velocity += dvdt * 0.001;
        }
        this.mTempState.position = tempPosition;
        this.mTempState.velocity = tempVelocity;
        this.mCurrentState.position = position;
        this.mCurrentState.velocity = velocity;
        if (this.mTimeAccumulator > 0.0) {
            this.interpolate(this.mTimeAccumulator / 0.001);
        }
        if (this.isAtRest() || this.mOvershootClampingEnabled && this.isOvershooting()) {
            if (tension > 0.0) {
                this.mStartValue = this.mEndValue;
                this.mCurrentState.position = this.mEndValue;
            } else {
                this.mStartValue = this.mEndValue = this.mCurrentState.position;
            }
            this.mCurrentState.velocity = 0.0;
        }
    }

    private static class PhysicsState {
        double position;
        double velocity;

        private PhysicsState() {
        }
    }
}

