/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.content.Context;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.flat.DraweeRequestHelper;
import com.facebook.react.flat.FlatNativeViewHierarchyManager;
import com.facebook.react.flat.FlatRootShadowNode;
import com.facebook.react.flat.FlatShadowNode;
import com.facebook.react.flat.FlatUIViewOperationQueue;
import com.facebook.react.flat.MoveProxy;
import com.facebook.react.flat.NativeViewWrapper;
import com.facebook.react.flat.RCTImageView;
import com.facebook.react.flat.RCTImageViewManager;
import com.facebook.react.flat.StateBuilder;
import com.facebook.react.flat.TypefaceCache;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.yoga.YogaDirection;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class FlatUIImplementation
extends UIImplementation {
    private final MoveProxy mMoveProxy = new MoveProxy();
    private final ReactApplicationContext mReactContext;
    @Nullable
    private RCTImageViewManager mRCTImageViewManager;
    private final StateBuilder mStateBuilder;

    public static FlatUIImplementation createInstance(ReactApplicationContext reactContext, List<ViewManager> viewManagers, EventDispatcher eventDispatcher) {
        Object callerContext;
        RCTImageViewManager rctImageViewManager = FlatUIImplementation.findRCTImageManager(viewManagers);
        if (rctImageViewManager != null && (callerContext = rctImageViewManager.getCallerContext()) != null) {
            RCTImageView.setCallerContext(callerContext);
        }
        DraweeRequestHelper.setResources(reactContext.getResources());
        TypefaceCache.setAssetManager(reactContext.getAssets());
        ViewManagerRegistry viewManagerRegistry = new ViewManagerRegistry(viewManagers);
        FlatNativeViewHierarchyManager nativeViewHierarchyManager = new FlatNativeViewHierarchyManager(viewManagerRegistry);
        FlatUIViewOperationQueue operationsQueue = new FlatUIViewOperationQueue(reactContext, nativeViewHierarchyManager);
        return new FlatUIImplementation(reactContext, rctImageViewManager, viewManagerRegistry, operationsQueue, eventDispatcher);
    }

    private FlatUIImplementation(ReactApplicationContext reactContext, @Nullable RCTImageViewManager rctImageViewManager, ViewManagerRegistry viewManagers, FlatUIViewOperationQueue operationsQueue, EventDispatcher eventDispatcher) {
        super(reactContext, viewManagers, operationsQueue, eventDispatcher);
        this.mReactContext = reactContext;
        this.mRCTImageViewManager = rctImageViewManager;
        this.mStateBuilder = new StateBuilder(operationsQueue);
    }

    @Override
    protected ReactShadowNode createRootShadowNode() {
        if (this.mRCTImageViewManager != null) {
            DraweeRequestHelper.setDraweeControllerBuilder(this.mRCTImageViewManager.getDraweeControllerBuilder());
            this.mRCTImageViewManager = null;
        }
        FlatRootShadowNode node = new FlatRootShadowNode();
        I18nUtil sharedI18nUtilInstance = I18nUtil.getInstance();
        if (sharedI18nUtilInstance.isRTL((Context)this.mReactContext)) {
            node.setLayoutDirection(YogaDirection.RTL);
        }
        return node;
    }

    @Override
    protected ReactShadowNode createShadowNode(String className) {
        ReactShadowNode cssNode = super.createShadowNode(className);
        if (cssNode instanceof FlatShadowNode || cssNode.isVirtual()) {
            return cssNode;
        }
        ViewManager viewManager = this.resolveViewManager(className);
        return new NativeViewWrapper(viewManager);
    }

    @Override
    protected void handleCreateView(ReactShadowNode cssNode, int rootViewTag, @Nullable ReactStylesDiffMap styles) {
        if (cssNode instanceof FlatShadowNode) {
            FlatShadowNode node = (FlatShadowNode)cssNode;
            if (styles != null) {
                node.handleUpdateProperties(styles);
            }
            if (node.mountsToView()) {
                this.mStateBuilder.enqueueCreateOrUpdateView(node, styles);
            }
        } else {
            super.handleCreateView(cssNode, rootViewTag, styles);
        }
    }

    @Override
    protected void handleUpdateView(ReactShadowNode cssNode, String className, ReactStylesDiffMap styles) {
        if (cssNode instanceof FlatShadowNode) {
            FlatShadowNode node = (FlatShadowNode)cssNode;
            node.handleUpdateProperties(styles);
            if (node.mountsToView()) {
                this.mStateBuilder.enqueueCreateOrUpdateView(node, styles);
            }
        } else {
            super.handleUpdateView(cssNode, className, styles);
        }
    }

    @Override
    public void manageChildren(int viewTag, @Nullable ReadableArray moveFrom, @Nullable ReadableArray moveTo, @Nullable ReadableArray addChildTags, @Nullable ReadableArray addAtIndices, @Nullable ReadableArray removeFrom) {
        ReactShadowNode parentNode = this.resolveShadowNode(viewTag);
        this.removeChildren(parentNode, moveFrom, moveTo, removeFrom);
        this.addChildren(parentNode, addChildTags, addAtIndices);
    }

    @Override
    public void setChildren(int viewTag, ReadableArray children) {
        ReactShadowNode parentNode = this.resolveShadowNode(viewTag);
        for (int i = 0; i < children.size(); ++i) {
            ReactShadowNode addToChild = this.resolveShadowNode(children.getInt(i));
            FlatUIImplementation.addChildAt(parentNode, addToChild, i, i - 1);
        }
    }

    @Override
    public void measure(int reactTag, Callback callback) {
        this.measureHelper(reactTag, false, callback);
    }

    private void measureHelper(int reactTag, boolean relativeToWindow, Callback callback) {
        float yInParent;
        FlatShadowNode node = (FlatShadowNode)this.resolveShadowNode(reactTag);
        if (node.mountsToView()) {
            this.mStateBuilder.ensureBackingViewIsCreated(node);
            if (relativeToWindow) {
                super.measureInWindow(reactTag, callback);
            } else {
                super.measure(reactTag, callback);
            }
            return;
        }
        while (node != null && node.isVirtual()) {
            node = (FlatShadowNode)node.getParent();
        }
        if (node == null) {
            return;
        }
        float width = node.getLayoutWidth();
        float height = node.getLayoutHeight();
        boolean nodeMountsToView = node.mountsToView();
        float xInParent = nodeMountsToView ? node.getLayoutX() : 0.0f;
        float f = yInParent = nodeMountsToView ? node.getLayoutY() : 0.0f;
        while (!node.mountsToView()) {
            if (!node.isVirtual()) {
                xInParent += node.getLayoutX();
                yInParent += node.getLayoutY();
            }
            node = (FlatShadowNode)Assertions.assumeNotNull((Object)((FlatShadowNode)node.getParent()));
        }
        float parentWidth = node.getLayoutWidth();
        float parentHeight = node.getLayoutHeight();
        FlatUIViewOperationQueue operationsQueue = this.mStateBuilder.getOperationsQueue();
        operationsQueue.enqueueMeasureVirtualView(node.getReactTag(), xInParent / parentWidth, yInParent / parentHeight, width / parentWidth, height / parentHeight, relativeToWindow, callback);
    }

    private void ensureMountsToViewAndBackingViewIsCreated(int reactTag) {
        FlatShadowNode node = (FlatShadowNode)this.resolveShadowNode(reactTag);
        if (node.isBackingViewCreated()) {
            return;
        }
        node.forceMountToView();
        this.mStateBuilder.ensureBackingViewIsCreated(node);
    }

    @Override
    public void findSubviewIn(int reactTag, float targetX, float targetY, Callback callback) {
        this.ensureMountsToViewAndBackingViewIsCreated(reactTag);
        super.findSubviewIn(reactTag, targetX, targetY, callback);
    }

    @Override
    public void measureInWindow(int reactTag, Callback callback) {
        this.measureHelper(reactTag, true, callback);
    }

    @Override
    public void addAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.ensureMountsToViewAndBackingViewIsCreated(reactTag);
        super.addAnimation(reactTag, animationID, onSuccess);
    }

    @Override
    public void dispatchViewManagerCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        this.ensureMountsToViewAndBackingViewIsCreated(reactTag);
        this.mStateBuilder.enqueueViewManagerCommand(reactTag, commandId, commandArgs);
    }

    @Override
    public void showPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.ensureMountsToViewAndBackingViewIsCreated(reactTag);
        super.showPopupMenu(reactTag, items, error, success);
    }

    @Override
    public void sendAccessibilityEvent(int reactTag, int eventType) {
        this.ensureMountsToViewAndBackingViewIsCreated(reactTag);
        super.sendAccessibilityEvent(reactTag, eventType);
    }

    private void removeChildren(ReactShadowNode parentNode, @Nullable ReadableArray moveFrom, @Nullable ReadableArray moveTo, @Nullable ReadableArray removeFrom) {
        int removeFromChildIndex;
        int removeFromIndex;
        int prevIndex = Integer.MAX_VALUE;
        this.mMoveProxy.setup(moveFrom, moveTo);
        int moveFromIndex = this.mMoveProxy.size() - 1;
        int moveFromChildIndex = moveFromIndex == -1 ? -1 : this.mMoveProxy.getMoveFrom(moveFromIndex);
        int numToRemove = removeFrom == null ? 0 : removeFrom.size();
        int[] indicesToRemove = new int[numToRemove];
        if (numToRemove > 0) {
            Assertions.assertNotNull((Object)removeFrom);
            for (int i = 0; i < numToRemove; ++i) {
                int indexToRemove;
                indicesToRemove[i] = indexToRemove = removeFrom.getInt(i);
            }
        }
        Arrays.sort(indicesToRemove);
        if (removeFrom == null) {
            removeFromIndex = -1;
            removeFromChildIndex = -1;
        } else {
            removeFromIndex = indicesToRemove.length - 1;
            removeFromChildIndex = indicesToRemove[removeFromIndex];
        }
        while (true) {
            if (moveFromChildIndex > removeFromChildIndex) {
                this.moveChild(FlatUIImplementation.removeChildAt(parentNode, moveFromChildIndex, prevIndex), moveFromIndex);
                prevIndex = moveFromChildIndex;
                moveFromChildIndex = --moveFromIndex == -1 ? -1 : this.mMoveProxy.getMoveFrom(moveFromIndex);
                continue;
            }
            if (removeFromChildIndex <= moveFromChildIndex) break;
            this.removeChild(FlatUIImplementation.removeChildAt(parentNode, removeFromChildIndex, prevIndex), parentNode);
            prevIndex = removeFromChildIndex;
            removeFromChildIndex = --removeFromIndex == -1 ? -1 : indicesToRemove[removeFromIndex];
        }
    }

    private void removeChild(ReactShadowNode child, ReactShadowNode parentNode) {
        this.dropNativeViews(child, parentNode);
        this.removeShadowNode(child);
    }

    private void dropNativeViews(ReactShadowNode child, ReactShadowNode parentNode) {
        FlatShadowNode node;
        if (child instanceof FlatShadowNode && (node = (FlatShadowNode)child).mountsToView() && node.isBackingViewCreated()) {
            int tag = -1;
            for (ReactShadowNode tmpNode = parentNode; tmpNode != null; tmpNode = tmpNode.getParent()) {
                FlatShadowNode flatTmpNode;
                if (!(tmpNode instanceof FlatShadowNode) || !(flatTmpNode = (FlatShadowNode)tmpNode).mountsToView() || !flatTmpNode.isBackingViewCreated() || flatTmpNode.getParent() == null) continue;
                tag = flatTmpNode.getReactTag();
                break;
            }
            this.mStateBuilder.dropView(node, tag);
            return;
        }
        int childCount = child.getChildCount();
        for (int i = 0; i != childCount; ++i) {
            this.dropNativeViews(child.getChildAt(i), child);
        }
    }

    private void moveChild(ReactShadowNode child, int moveFromIndex) {
        this.mMoveProxy.setChildMoveFrom(moveFromIndex, child);
    }

    private void addChildren(ReactShadowNode parentNode, @Nullable ReadableArray addChildTags, @Nullable ReadableArray addAtIndices) {
        int addToChildIndex;
        int addToIndex;
        int numNodesToAdd;
        int moveToChildIndex;
        int moveToIndex;
        int prevIndex = -1;
        if (this.mMoveProxy.size() == 0) {
            moveToIndex = Integer.MAX_VALUE;
            moveToChildIndex = Integer.MAX_VALUE;
        } else {
            moveToIndex = 0;
            moveToChildIndex = this.mMoveProxy.getMoveTo(0);
        }
        if (addAtIndices == null) {
            numNodesToAdd = 0;
            addToIndex = Integer.MAX_VALUE;
            addToChildIndex = Integer.MAX_VALUE;
        } else {
            numNodesToAdd = addAtIndices.size();
            addToIndex = 0;
            addToChildIndex = addAtIndices.getInt(0);
        }
        while (true) {
            if (addToChildIndex < moveToChildIndex) {
                ReactShadowNode addToChild = this.resolveShadowNode(addChildTags.getInt(addToIndex));
                FlatUIImplementation.addChildAt(parentNode, addToChild, addToChildIndex, prevIndex);
                prevIndex = addToChildIndex;
                if (++addToIndex == numNodesToAdd) {
                    addToChildIndex = Integer.MAX_VALUE;
                    continue;
                }
                addToChildIndex = addAtIndices.getInt(addToIndex);
                continue;
            }
            if (moveToChildIndex >= addToChildIndex) break;
            ReactShadowNode moveToChild = this.mMoveProxy.getChildMoveTo(moveToIndex);
            FlatUIImplementation.addChildAt(parentNode, moveToChild, moveToChildIndex, prevIndex);
            prevIndex = moveToChildIndex;
            if (++moveToIndex == this.mMoveProxy.size()) {
                moveToChildIndex = Integer.MAX_VALUE;
                continue;
            }
            moveToChildIndex = this.mMoveProxy.getMoveTo(moveToIndex);
        }
    }

    private static ReactShadowNode removeChildAt(ReactShadowNode parentNode, int index, int prevIndex) {
        if (index >= prevIndex) {
            throw new RuntimeException("Invariant failure, needs sorting! " + index + " >= " + prevIndex);
        }
        return parentNode.removeChildAt(index);
    }

    private static void addChildAt(ReactShadowNode parentNode, ReactShadowNode childNode, int index, int prevIndex) {
        if (index <= prevIndex) {
            throw new RuntimeException("Invariant failure, needs sorting! " + index + " <= " + prevIndex);
        }
        parentNode.addChildAt(childNode, index);
    }

    @Override
    protected void updateViewHierarchy() {
        super.updateViewHierarchy();
        this.mStateBuilder.afterUpdateViewHierarchy(this.mEventDispatcher);
    }

    @Override
    protected void applyUpdatesRecursive(ReactShadowNode cssNode, float absoluteX, float absoluteY) {
        this.mStateBuilder.applyUpdates((FlatRootShadowNode)cssNode);
    }

    @Override
    public void removeRootView(int rootViewTag) {
        this.mStateBuilder.removeRootView(rootViewTag);
    }

    @Override
    public void setJSResponder(int possiblyVirtualReactTag, boolean blockNativeResponder) {
        ReactShadowNode node = this.resolveShadowNode(possiblyVirtualReactTag);
        while (node.isVirtual()) {
            node = node.getParent();
        }
        int tag = node.getReactTag();
        while (node instanceof FlatShadowNode && !((FlatShadowNode)node).mountsToView()) {
            node = node.getParent();
        }
        FlatUIViewOperationQueue operationsQueue = this.mStateBuilder.getOperationsQueue();
        operationsQueue.enqueueSetJSResponder(node == null ? tag : node.getReactTag(), possiblyVirtualReactTag, blockNativeResponder);
    }

    @Nullable
    private static RCTImageViewManager findRCTImageManager(List<ViewManager> viewManagers) {
        int size = viewManagers.size();
        for (int i = 0; i != size; ++i) {
            if (!(viewManagers.get(i) instanceof RCTImageViewManager)) continue;
            return (RCTImageViewManager)viewManagers.get(i);
        }
        return null;
    }
}

