/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.yoga;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.yoga.YogaUnit;

@DoNotStrip
public class YogaValue {
    static final YogaValue UNDEFINED = new YogaValue(Float.NaN, YogaUnit.UNDEFINED);
    static final YogaValue ZERO = new YogaValue(0.0f, YogaUnit.PIXEL);
    public final float value;
    public final YogaUnit unit;

    public YogaValue(float value, YogaUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @DoNotStrip
    YogaValue(float value, int unit) {
        this(value, YogaUnit.fromInt(unit));
    }

    public boolean equals(Object other) {
        if (other instanceof YogaValue) {
            YogaValue otherValue = (YogaValue)other;
            return this.value == otherValue.value && this.unit == otherValue.unit;
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value) + this.unit.intValue();
    }
}

