/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.internal.zzaaa;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaaf;
import com.google.android.gms.internal.zzaag;
import com.google.android.gms.internal.zzaai;
import com.google.android.gms.internal.zzaak;
import com.google.android.gms.internal.zzaav;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzabc;
import com.google.android.gms.internal.zzabd;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzabi;
import com.google.android.gms.internal.zzabq;
import com.google.android.gms.internal.zzabt;
import com.google.android.gms.internal.zzabx;
import com.google.android.gms.internal.zzaby;
import com.google.android.gms.internal.zzacf;
import com.google.android.gms.internal.zzbai;
import com.google.android.gms.internal.zzbaj;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzaat
extends GoogleApiClient
implements zzabc.zza {
    private final Lock zzaAG;
    private boolean zzazr;
    private final zzm zzaBJ;
    private zzabc zzaBK = null;
    private final int zzazl;
    private final Context mContext;
    private final Looper zzrs;
    final Queue<zzaad.zza<?, ?>> zzaAU = new LinkedList();
    private volatile boolean zzaBL;
    private long zzaBM = 120000L;
    private long zzaBN = 5000L;
    private final zza zzaBO;
    private final GoogleApiAvailability zzazn;
    zzaaz zzaBP;
    final Map<Api.zzc<?>, Api.zze> zzaBQ;
    Set<Scope> zzaBR = new HashSet<Scope>();
    final zzg zzaAL;
    final Map<Api<?>, Boolean> zzaAO;
    final Api.zza<? extends zzbai, zzbaj> zzazo;
    private final zzabi zzaBS = new zzabi();
    private final ArrayList<zzaag> zzaBT;
    private Integer zzaBU = null;
    Set<zzabx> zzaBV = null;
    final zzaby zzaBW;
    private final zzm.zza zzaBX = new zzm.zza(){

        @Override
        public boolean isConnected() {
            return zzaat.this.isConnected();
        }

        @Override
        public Bundle zzuB() {
            return null;
        }
    };

    public zzaat(Context context, Lock lock, Looper looper, zzg zzg2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzbai, zzbaj> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzaag> arrayList, boolean bl) {
        this.mContext = context;
        this.zzaAG = lock;
        this.zzazr = bl;
        this.zzaBJ = new zzm(looper, this.zzaBX);
        this.zzrs = looper;
        this.zzaBO = new zza(looper);
        this.zzazn = googleApiAvailability;
        this.zzazl = n;
        if (this.zzazl >= 0) {
            this.zzaBU = n2;
        }
        this.zzaAO = map;
        this.zzaBQ = map2;
        this.zzaBT = arrayList;
        this.zzaBW = new zzaby(this.zzaBQ);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzaBJ.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzaBJ.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzaAL = zzg2;
        this.zzazo = zza2;
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzaad.zza<R, A>> T zza(@NonNull T t) {
        zzac.zzb((t.zzvg() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.getApi() != null ? t.getApi().getName() : "the API";
        zzac.zzb((boolean)this.zzaBQ.containsKey(t.zzvg()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzaAG.lock();
        try {
            if (this.zzaBK == null) {
                this.zzaAU.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzaBK.zza(t);
            return (T)string2;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T zzb(@NonNull T t) {
        zzac.zzb((t.zzvg() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.getApi() != null ? t.getApi().getName() : "the API";
        zzac.zzb((boolean)this.zzaBQ.containsKey(t.zzvg()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzaAG.lock();
        try {
            if (this.zzaBK == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.isResuming()) {
                this.zzaAU.add(t);
                while (!this.zzaAU.isEmpty()) {
                    object = this.zzaAU.remove();
                    this.zzaBW.zzb((zzaaf<? extends Result>)object);
                    ((zzaad.zza)object).zzB(Status.zzazz);
                }
                object = t;
                return (T)object;
            }
            object = this.zzaBK.zzb(t);
            return (T)object;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public <L> zzabh<L> zzr(@NonNull L l) {
        this.zzaAG.lock();
        try {
            zzabh<L> zzabh2 = this.zzaBS.zzb(l, this.zzrs);
            return zzabh2;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzaBQ.get(zzc2);
        zzac.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    <C extends Api.zze> C zzc(Api.zzc<?> zzc2) {
        Api.zze zze2 = this.zzaBQ.get(zzc2);
        zzac.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public boolean zza(@NonNull Api<?> api) {
        return this.zzaBQ.containsKey(api.zzvg());
    }

    @Override
    public boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!this.isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzaBQ.get(api.zzvg());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.zzaAG.lock();
        try {
            if (!this.isConnected() && !this.isResuming()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.zzaBQ.containsKey(api.zzvg())) {
                ConnectionResult connectionResult = this.zzaBK.getConnectionResult(api);
                if (connectionResult == null) {
                    if (this.isResuming()) {
                        ConnectionResult connectionResult2 = ConnectionResult.zzayj;
                        return connectionResult2;
                    }
                    Log.w((String)"GoogleApiClientImpl", (String)this.zzwr());
                    Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                    ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                    return connectionResult3;
                }
                ConnectionResult connectionResult4 = connectionResult;
                return connectionResult4;
            }
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public void connect() {
        this.zzaAG.lock();
        try {
            if (this.zzazl >= 0) {
                zzac.zza((this.zzaBU != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzaBU == null) {
                this.zzaBU = zzaat.zza(this.zzaBQ.values(), false);
            } else if (this.zzaBU == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.zzaBU);
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public void connect(int n) {
        this.zzaAG.lock();
        try {
            zzac.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzcD(n);
            this.zzwm();
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        zzac.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzaAG.lock();
        try {
            if (this.zzazl >= 0) {
                zzac.zza((this.zzaBU != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzaBU == null) {
                this.zzaBU = zzaat.zza(this.zzaBQ.values(), false);
            } else if (this.zzaBU == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzcD(this.zzaBU);
            this.zzaBJ.zzxY();
            ConnectionResult connectionResult = this.zzaBK.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzac.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzac.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzaAG.lock();
        try {
            if (this.zzaBU == null) {
                this.zzaBU = zzaat.zza(this.zzaBQ.values(), false);
            } else if (this.zzaBU == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzcD(this.zzaBU);
            this.zzaBJ.zzxY();
            ConnectionResult connectionResult = this.zzaBK.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.zzaAG.lock();
        try {
            this.zzaBW.release();
            if (this.zzaBK != null) {
                this.zzaBK.disconnect();
            }
            this.zzaBS.release();
            for (zzaad.zza zza2 : this.zzaAU) {
                zza2.zza(null);
                zza2.cancel();
            }
            this.zzaAU.clear();
            if (this.zzaBK == null) {
                return;
            }
            this.zzwp();
            this.zzaBJ.zzxX();
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzac.zza((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzac.zza((this.zzaBU != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        final zzabt zzabt2 = new zzabt(this);
        if (this.zzaBQ.containsKey(zzacf.zzaid)) {
            this.zza(this, zzabt2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle bundle) {
                    zzaat.this.zza((GoogleApiClient)atomicReference.get(), zzabt2, true);
                }

                @Override
                public void onConnectionSuspended(int n) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(this){

                @Override
                public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
                    zzabt2.zzb(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzacf.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzaBO).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzabt2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzabt zzabt2, final boolean bl) {
        zzacf.zzaGM.zzg(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzp(@NonNull Status status) {
                zzn.zzas(zzaat.this.mContext).zzrD();
                if (status.isSuccess() && zzaat.this.isConnected()) {
                    zzaat.this.reconnect();
                }
                zzabt2.zzb(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        this.zzb(new zzabd((Activity)fragmentActivity));
    }

    private void zzb(@NonNull zzabd zzabd2) {
        if (this.zzazl < 0) {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
        zzaaa.zza(zzabd2).zzcA(this.zzazl);
    }

    @Override
    public boolean isConnected() {
        return this.zzaBK != null && this.zzaBK.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.zzaBK != null && this.zzaBK.isConnecting();
    }

    boolean isResuming() {
        return this.zzaBL;
    }

    private void zzcD(int n) {
        if (this.zzaBU == null) {
            this.zzaBU = n;
        } else if (this.zzaBU != n) {
            String string2 = String.valueOf(zzaat.zzcE(n));
            String string3 = String.valueOf(zzaat.zzcE(this.zzaBU));
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzaBK != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzaBQ.values()) {
            if (zze2.zzrd()) {
                bl = true;
            }
            if (!zze2.zzrr()) continue;
            bl2 = true;
        }
        switch (this.zzaBU) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.zzaBK = this.zzazr ? new zzaak(this.mContext, this.zzaAG, this.zzrs, this.zzazn, this.zzaBQ, this.zzaAL, this.zzaAO, this.zzazo, this.zzaBT, this, true) : zzaai.zza(this.mContext, this, this.zzaAG, this.zzrs, this.zzazn, this.zzaBQ, this.zzaAL, this.zzaAO, this.zzazo, this.zzaBT);
                return;
            }
        }
        this.zzaBK = this.zzazr && !bl2 ? new zzaak(this.mContext, this.zzaAG, this.zzrs, this.zzazn, this.zzaBQ, this.zzaAL, this.zzaAO, this.zzazo, this.zzaBT, this, false) : new zzaav(this.mContext, this, this.zzaAG, this.zzrs, this.zzazn, this.zzaBQ, this.zzaAL, this.zzaAO, this.zzazo, this.zzaBT, this);
    }

    private void zzwm() {
        this.zzaBJ.zzxY();
        this.zzaBK.connect();
    }

    private void resume() {
        this.zzaAG.lock();
        try {
            if (this.isResuming()) {
                this.zzwm();
            }
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    private void zzwn() {
        this.zzaAG.lock();
        try {
            boolean bl = this.zzwp();
            if (bl) {
                this.zzwm();
            }
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    void zzwo() {
        if (this.isResuming()) {
            return;
        }
        this.zzaBL = true;
        if (this.zzaBP == null) {
            this.zzaBP = this.zzazn.zza(this.mContext.getApplicationContext(), new zzb(this));
        }
        this.zzaBO.sendMessageDelayed(this.zzaBO.obtainMessage(1), this.zzaBM);
        this.zzaBO.sendMessageDelayed(this.zzaBO.obtainMessage(2), this.zzaBN);
    }

    boolean zzwp() {
        if (!this.isResuming()) {
            return false;
        }
        this.zzaBL = false;
        this.zzaBO.removeMessages(2);
        this.zzaBO.removeMessages(1);
        if (this.zzaBP != null) {
            this.zzaBP.unregister();
            this.zzaBP = null;
        }
        return true;
    }

    @Override
    public void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzaBJ.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzaBJ.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzaBJ.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzaBJ.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzaBJ.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzaBJ.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public void zzo(Bundle bundle) {
        while (!this.zzaAU.isEmpty()) {
            this.zzb(this.zzaAU.remove());
        }
        this.zzaBJ.zzq(bundle);
    }

    @Override
    public void zzc(ConnectionResult connectionResult) {
        if (!this.zzazn.zzd(this.mContext, connectionResult.getErrorCode())) {
            this.zzwp();
        }
        if (!this.isResuming()) {
            this.zzaBJ.zzn(connectionResult);
            this.zzaBJ.zzxX();
        }
    }

    @Override
    public void zzc(int n, boolean bl) {
        if (n == 1 && !bl) {
            this.zzwo();
        }
        this.zzaBW.zzxd();
        this.zzaBJ.zzcV(n);
        this.zzaBJ.zzxX();
        if (n == 2) {
            this.zzwm();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzrs;
    }

    @Override
    public boolean zza(zzabq zzabq2) {
        return this.zzaBK != null && this.zzaBK.zza(zzabq2);
    }

    @Override
    public void zzvn() {
        if (this.zzaBK != null) {
            this.zzaBK.zzvn();
        }
    }

    @Override
    public void zza(zzabx zzabx2) {
        this.zzaAG.lock();
        try {
            if (this.zzaBV == null) {
                this.zzaBV = new HashSet<zzabx>();
            }
            this.zzaBV.add(zzabx2);
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public void zzb(zzabx zzabx2) {
        this.zzaAG.lock();
        try {
            if (this.zzaBV == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzaBV.remove(zzabx2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzwq()) {
                this.zzaBK.zzvM();
            }
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    boolean zzwq() {
        this.zzaAG.lock();
        try {
            if (this.zzaBV == null) {
                return false;
            }
            boolean bl = !this.zzaBV.isEmpty();
            return bl;
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    String zzwr() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzaBL);
        printWriter.append(" mWorkQueue.size()=").print(this.zzaAU.size());
        this.zzaBW.dump(printWriter);
        if (this.zzaBK != null) {
            this.zzaBK.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public int getSessionId() {
        return System.identityHashCode(this);
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzrd()) {
                bl2 = true;
            }
            if (!zze2.zzrr()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zzcE(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zzaat.this.zzwn();
                    break;
                }
                case 2: {
                    zzaat.this.resume();
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiClientImpl", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }

    static class zzb
    extends zzaaz.zza {
        private WeakReference<zzaat> zzaCc;

        zzb(zzaat zzaat2) {
            this.zzaCc = new WeakReference<zzaat>(zzaat2);
        }

        @Override
        public void zzvE() {
            zzaat zzaat2 = (zzaat)this.zzaCc.get();
            if (zzaat2 == null) {
                return;
            }
            zzaat2.resume();
        }
    }
}

