/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaag;
import com.google.android.gms.internal.zzaah;
import com.google.android.gms.internal.zzaaq;
import com.google.android.gms.internal.zzaar;
import com.google.android.gms.internal.zzaas;
import com.google.android.gms.internal.zzaat;
import com.google.android.gms.internal.zzaau;
import com.google.android.gms.internal.zzabc;
import com.google.android.gms.internal.zzabq;
import com.google.android.gms.internal.zzbai;
import com.google.android.gms.internal.zzbaj;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzaav
implements zzaah,
zzabc {
    private final Lock zzaAG;
    private final Condition zzaCd;
    private final Context mContext;
    private final zze zzaAQ;
    private final zzb zzaCe;
    final Map<Api.zzc<?>, Api.zze> zzaBQ;
    final Map<Api.zzc<?>, ConnectionResult> zzaCf = new HashMap();
    final zzg zzaAL;
    final Map<Api<?>, Boolean> zzaAO;
    final Api.zza<? extends zzbai, zzbaj> zzazo;
    private volatile zzaau zzaCg;
    private ConnectionResult zzaCh = null;
    int zzaCi;
    final zzaat zzaAw;
    final zzabc.zza zzaCj;

    public zzaav(Context context, zzaat zzaat2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzbai, zzbaj> zza2, ArrayList<zzaag> arrayList, zzabc.zza zza3) {
        this.mContext = context;
        this.zzaAG = lock;
        this.zzaAQ = zze2;
        this.zzaBQ = map;
        this.zzaAL = zzg2;
        this.zzaAO = map2;
        this.zzazo = zza2;
        this.zzaAw = zzaat2;
        this.zzaCj = zza3;
        for (zzaag zzaag2 : arrayList) {
            zzaag2.zza(this);
        }
        this.zzaCe = new zzb(looper);
        this.zzaCd = lock.newCondition();
        this.zzaCg = new zzaas(this);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzaad.zza<R, A>> T zza(@NonNull T t) {
        t.zzvI();
        return this.zzaCg.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T zzb(@NonNull T t) {
        t.zzvI();
        return this.zzaCg.zzb(t);
    }

    @Override
    public void connect() {
        this.zzaCg.connect();
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzaCd.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzayj;
        }
        if (this.zzaCh != null) {
            return this.zzaCh;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzaCd.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzayj;
        }
        if (this.zzaCh != null) {
            return this.zzaCh;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        boolean bl = this.zzaCg.disconnect();
        if (bl) {
            this.zzaCf.clear();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzvg();
        if (this.zzaBQ.containsKey(zzc2)) {
            if (this.zzaBQ.get(zzc2).isConnected()) {
                return ConnectionResult.zzayj;
            }
            if (this.zzaCf.containsKey(zzc2)) {
                return this.zzaCf.get(zzc2);
            }
        }
        return null;
    }

    void zzws() {
        this.zzaAG.lock();
        try {
            this.zzaCg = new zzaar(this, this.zzaAL, this.zzaAO, this.zzaAQ, this.zzazo, this.zzaAG, this.mContext);
            this.zzaCg.begin();
            this.zzaCd.signalAll();
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    void zzwt() {
        this.zzaAG.lock();
        try {
            this.zzaAw.zzwp();
            this.zzaCg = new zzaaq(this);
            this.zzaCg.begin();
            this.zzaCd.signalAll();
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    void zzh(ConnectionResult connectionResult) {
        this.zzaAG.lock();
        try {
            this.zzaCh = connectionResult;
            this.zzaCg = new zzaas(this);
            this.zzaCg.begin();
            this.zzaCd.signalAll();
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    void zzwu() {
        for (Api.zze zze2 : this.zzaBQ.values()) {
            zze2.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzaCg instanceof zzaaq;
    }

    @Override
    public boolean isConnecting() {
        return this.zzaCg instanceof zzaar;
    }

    @Override
    public boolean zza(zzabq zzabq2) {
        return false;
    }

    @Override
    public void zzvn() {
    }

    @Override
    public void zzvM() {
        if (this.isConnected()) {
            ((zzaaq)this.zzaCg).zzwd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzaAG.lock();
        try {
            this.zzaCg.zza(connectionResult, api, bl);
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public void onConnected(@Nullable Bundle bundle) {
        this.zzaAG.lock();
        try {
            this.zzaCg.onConnected(bundle);
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zzaAG.lock();
        try {
            this.zzaCg.onConnectionSuspended(n);
        }
        finally {
            this.zzaAG.unlock();
        }
    }

    void zza(zza zza2) {
        Message message = this.zzaCe.obtainMessage(1, zza2);
        this.zzaCe.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.zzaCe.obtainMessage(2, runtimeException);
        this.zzaCe.sendMessage(message);
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzaCg);
        for (Api<?> api : this.zzaAO.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            Api.zze zze2 = this.zzaBQ.get(api.zzvg());
            zze2.dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static abstract class zza {
        private final zzaau zzaCk;

        protected zza(zzaau zzaau2) {
            this.zzaCk = zzaau2;
        }

        public final void zzc(zzaav zzaav2) {
            zzaav2.zzaAG.lock();
            try {
                if (zzaav2.zzaCg != this.zzaCk) {
                    return;
                }
                this.zzwe();
            }
            finally {
                zzaav2.zzaAG.unlock();
            }
        }

        protected abstract void zzwe();
    }

    final class zzb
    extends Handler {
        zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zza zza2 = (zza)message.obj;
                    zza2.zzc(zzaav.this);
                    break;
                }
                case 2: {
                    throw (RuntimeException)message.obj;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GACStateManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }
}

