/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import android.os.TransactionTooLargeException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaaf;
import com.google.android.gms.internal.zzaal;
import com.google.android.gms.internal.zzaax;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzabm;
import com.google.android.gms.internal.zzabn;
import com.google.android.gms.internal.zzabs;
import com.google.android.gms.internal.zzabv;
import com.google.android.gms.internal.zzabz;
import com.google.android.gms.tasks.TaskCompletionSource;

public abstract class zzzx {
    public final int zzakD;

    public zzzx(int n) {
        this.zzakD = n;
    }

    public abstract void zza(zzaax.zza<?> var1) throws DeadObjectException;

    public abstract void zzz(@NonNull Status var1);

    public abstract void zza(@NonNull zzaal var1, boolean var2);

    private static Status zza(RemoteException remoteException) {
        StringBuilder stringBuilder = new StringBuilder();
        if (zzt.zzzh() && remoteException instanceof TransactionTooLargeException) {
            stringBuilder.append("TransactionTooLargeException: ");
        }
        stringBuilder.append(remoteException.getLocalizedMessage());
        return new Status(8, stringBuilder.toString());
    }

    public static final class zzd<TResult>
    extends zzzx {
        private final zzabv<Api.zzb, TResult> zzazI;
        private final TaskCompletionSource<TResult> zzazE;
        private final zzabs zzazJ;

        public zzd(int n, zzabv<Api.zzb, TResult> zzabv2, TaskCompletionSource<TResult> taskCompletionSource, zzabs zzabs2) {
            super(n);
            this.zzazE = taskCompletionSource;
            this.zzazI = zzabv2;
            this.zzazJ = zzabs2;
        }

        @Override
        public void zza(zzaax.zza<?> zza2) throws DeadObjectException {
            try {
                this.zzazI.zza(zza2.zzvU(), this.zzazE);
            }
            catch (DeadObjectException deadObjectException) {
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.zzz(zzzx.zza(remoteException));
            }
        }

        @Override
        public void zzz(@NonNull Status status) {
            this.zzazE.trySetException(this.zzazJ.zzA(status));
        }

        @Override
        public void zza(@NonNull zzaal zzaal2, boolean bl) {
            zzaal2.zza(this.zzazE, bl);
        }
    }

    public static final class zze
    extends zza {
        public final zzabh.zzb<?> zzazK;

        public zze(zzabh.zzb<?> zzb2, TaskCompletionSource<Void> taskCompletionSource) {
            super(4, taskCompletionSource);
            this.zzazK = zzb2;
        }

        @Override
        public void zzb(zzaax.zza<?> zza2) throws RemoteException {
            zzabn zzabn2 = zza2.zzwI().remove(this.zzazK);
            if (zzabn2 != null) {
                zzabn2.zzazG.zzwX();
            } else {
                Log.wtf((String)"UnregisterListenerTask", (String)"Received call to unregister a listener without a matching registration call.", (Throwable)new Exception());
                this.zzazE.trySetException((Exception)new com.google.android.gms.common.api.zza(Status.zzazz));
            }
        }
    }

    public static final class zzc
    extends zza {
        public final zzabm<Api.zzb, ?> zzazG;
        public final zzabz<Api.zzb, ?> zzazH;

        public zzc(zzabn zzabn2, TaskCompletionSource<Void> taskCompletionSource) {
            super(3, taskCompletionSource);
            this.zzazG = zzabn2.zzazG;
            this.zzazH = zzabn2.zzazH;
        }

        @Override
        public void zzb(zzaax.zza<?> zza2) throws RemoteException {
            if (this.zzazG.zzwW() != null) {
                zza2.zzwI().put(this.zzazG.zzwW(), new zzabn(this.zzazG, this.zzazH));
            }
        }
    }

    private static abstract class zza
    extends zzzx {
        protected final TaskCompletionSource<Void> zzazE;

        public zza(int n, TaskCompletionSource<Void> taskCompletionSource) {
            super(n);
            this.zzazE = taskCompletionSource;
        }

        @Override
        public void zzz(@NonNull Status status) {
            this.zzazE.trySetException((Exception)new com.google.android.gms.common.api.zza(status));
        }

        @Override
        public void zza(@NonNull zzaal zzaal2, boolean bl) {
        }

        @Override
        public final void zza(zzaax.zza<?> zza2) throws DeadObjectException {
            try {
                this.zzb(zza2);
            }
            catch (DeadObjectException deadObjectException) {
                this.zzz(zzzx.zza((RemoteException)((Object)deadObjectException)));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.zzz(zzzx.zza(remoteException));
            }
        }

        protected abstract void zzb(zzaax.zza<?> var1) throws RemoteException;
    }

    public static class zzb<A extends zzaad.zza<? extends Result, Api.zzb>>
    extends zzzx {
        protected final A zzazF;

        public zzb(int n, A a) {
            super(n);
            this.zzazF = a;
        }

        @Override
        public void zza(zzaax.zza<?> zza2) throws DeadObjectException {
            ((zzaad.zza)((Object)this.zzazF)).zzb((Api.zze)zza2.zzvU());
        }

        @Override
        public void zzz(@NonNull Status status) {
            ((zzaad.zza)this.zzazF).zzB(status);
        }

        @Override
        public void zza(@NonNull zzaal zzaal2, boolean bl) {
            zzaal2.zza((zzaaf<? extends Result>)this.zzazF, bl);
        }
    }
}

