/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.android.gms.common.stats.zza;
import com.google.firebase.iid.zzd;
import com.google.firebase.iid.zzf;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public final class zzh
implements ServiceConnection {
    private final Context zzqD;
    private final Intent zzckp;
    private final ScheduledExecutorService zzckq;
    private final Queue<zzd> zzckr = new LinkedList<zzd>();
    private zzf zzcks;
    private boolean zzckt = false;

    public zzh(Context context, String string) {
        this(context, string, new ScheduledThreadPoolExecutor(0));
    }

    @VisibleForTesting
    private zzh(Context context, String string, ScheduledExecutorService scheduledExecutorService) {
        this.zzqD = context.getApplicationContext();
        this.zzckp = new Intent(string).setPackage(this.zzqD.getPackageName());
        this.zzckq = scheduledExecutorService;
    }

    public final synchronized void zza(Intent intent, BroadcastReceiver.PendingResult pendingResult) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"new intent queued in the bind-strategy delivery");
        }
        this.zzckr.add(new zzd(intent, pendingResult, this.zzckq));
        this.zzJO();
    }

    private final synchronized void zzJO() {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            Log.d((String)"EnhancedIntentService", (String)"flush queue called");
        }
        while (!this.zzckr.isEmpty()) {
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                Log.d((String)"EnhancedIntentService", (String)"found intent to be delivered");
            }
            if (this.zzcks != null && this.zzcks.isBinderAlive()) {
                if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                    Log.d((String)"EnhancedIntentService", (String)"binder is alive, sending the intent.");
                }
                zzd zzd2 = this.zzckr.poll();
                this.zzcks.zza(zzd2);
                continue;
            }
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                boolean bl = !this.zzckt;
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(39).append("binder is dead. start connection? ").append(bl).toString());
            }
            if (!this.zzckt) {
                this.zzckt = true;
                try {
                    if (zza.zzrU().zza(this.zzqD, this.zzckp, (ServiceConnection)this, 65)) {
                        return;
                    }
                    Log.e((String)"EnhancedIntentService", (String)"binding to the service failed");
                }
                catch (SecurityException securityException) {
                    Log.e((String)"EnhancedIntentService", (String)"Exception while binding the service", (Throwable)securityException);
                }
                while (!this.zzckr.isEmpty()) {
                    this.zzckr.poll().finish();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzh zzh2 = this;
        synchronized (zzh2) {
            this.zzckt = false;
            this.zzcks = (zzf)iBinder;
            if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
                String string = String.valueOf(componentName);
                Log.d((String)"EnhancedIntentService", (String)new StringBuilder(20 + String.valueOf(string).length()).append("onServiceConnected: ").append(string).toString());
            }
            this.zzJO();
            return;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"EnhancedIntentService", (int)3)) {
            String string = String.valueOf(componentName);
            Log.d((String)"EnhancedIntentService", (String)new StringBuilder(23 + String.valueOf(string).length()).append("onServiceDisconnected: ").append(string).toString());
        }
        this.zzJO();
    }
}

