/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.gcm.zza;
import com.google.android.gms.gcm.zzc;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.zze;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GoogleCloudMessaging {
    public static int zzbfL = 5000000;
    private static int zzbfM = 6500000;
    private static int zzbfN = 7000000;
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    @Deprecated
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    @Deprecated
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_EVENT = "send_event";
    @Deprecated
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    public static final String INSTANCE_ID_SCOPE = "GCM";
    private static GoogleCloudMessaging zzbfO;
    private Context zzqD;
    private PendingIntent zzbfP;
    private Map<String, Handler> zzbfQ;
    private static final AtomicInteger zzbfR;
    private final BlockingQueue<Intent> zzbfS = new LinkedBlockingQueue<Intent>();
    private Messenger zzbfT;

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (zzbfO == null) {
            zzbfO = new GoogleCloudMessaging();
            new GoogleCloudMessaging().zzqD = context.getApplicationContext();
        }
        return zzbfO;
    }

    public GoogleCloudMessaging() {
        this.zzbfQ = Collections.synchronizedMap(new HashMap());
        this.zzbfT = new Messenger((Handler)new zzc(this, Looper.getMainLooper()));
    }

    public void close() {
        zzbfO = null;
        zza.zzbfw = null;
        this.zzvD();
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String string, String string2, Bundle bundle) throws IOException {
        this.send(string, string2, -1L, bundle);
    }

    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public void send(String string, String string2, long l, Bundle bundle) throws IOException {
        Bundle bundle2 = bundle;
        String string3 = string2;
        String string4 = string;
        GoogleCloudMessaging googleCloudMessaging = this;
        if (string4 == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        String string5 = zze.zzbd((Context)googleCloudMessaging.zzqD);
        if (string5 == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        if (bundle2 != null) {
            intent.putExtras(bundle2);
        }
        googleCloudMessaging.zzf(intent);
        intent.setPackage(string5);
        intent.putExtra("google.to", string4);
        intent.putExtra("google.message_id", string3);
        intent.putExtra("google.ttl", Long.toString(l));
        intent.putExtra("google.delay", Integer.toString(-1));
        String string6 = string4;
        GoogleCloudMessaging googleCloudMessaging2 = googleCloudMessaging;
        int n = string6.indexOf(64);
        String string7 = n > 0 ? string6.substring(0, n) : string6;
        InstanceID.getInstance((Context)googleCloudMessaging2.zzqD);
        intent.putExtra("google.from", InstanceID.zzvM().zzf("", string7, INSTANCE_ID_SCOPE));
        if (string5.contains(".gsf")) {
            Bundle bundle3 = new Bundle();
            for (String string8 : bundle2.keySet()) {
                Object object = bundle2.get(string8);
                if (!(object instanceof String)) continue;
                String string9 = String.valueOf(string8);
                bundle3.putString(string9.length() != 0 ? "gcm.".concat(string9) : new String("gcm."), (String)object);
            }
            bundle3.putString("google.to", string4);
            bundle3.putString("google.message_id", string3);
            InstanceID.getInstance((Context)googleCloudMessaging.zzqD).zzc(INSTANCE_ID_SCOPE, "upstream", bundle3);
            return;
        }
        googleCloudMessaging.zzqD.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private final boolean zze(Intent intent) {
        Handler handler;
        String string = intent.getStringExtra("In-Reply-To");
        if (string == null && intent.hasExtra("error")) {
            string = intent.getStringExtra("google.message_id");
        }
        if (string != null && (handler = this.zzbfQ.remove(string)) != null) {
            Message message = Message.obtain();
            Message.obtain().obj = intent;
            return handler.sendMessage(message);
        }
        return false;
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        InstanceID.getInstance((Context)this.zzqD).deleteInstanceID();
    }

    @Deprecated
    @RequiresPermission(value="com.google.android.c2dm.permission.RECEIVE")
    public synchronized String register(String ... stringArray) throws IOException {
        return this.zza(zze.zzbc((Context)this.zzqD), stringArray);
    }

    @Deprecated
    private final synchronized String zza(boolean bl, String ... stringArray) throws IOException {
        String string = zze.zzbd((Context)this.zzqD);
        if (string == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string2 = GoogleCloudMessaging.zzc(stringArray);
        Bundle bundle = new Bundle();
        if (string.contains(".gsf")) {
            bundle.putString("legacy.sender", string2);
            return InstanceID.getInstance((Context)this.zzqD).getToken(string2, INSTANCE_ID_SCOPE, bundle);
        }
        bundle.putString("sender", string2);
        String string3 = "registration_id";
        Intent intent = this.zza(bundle, bl);
        if (intent == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string4 = intent.getStringExtra(string3);
        if (string4 != null) {
            return string4;
        }
        String string5 = intent.getStringExtra("error");
        if (string5 != null) {
            throw new IOException(string5);
        }
        throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
    }

    @Deprecated
    private final Intent zza(Bundle bundle, boolean bl) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        if (GoogleCloudMessaging.zzaZ(this.zzqD) < 0) {
            throw new IOException("Google Play Services missing");
        }
        Intent intent = new Intent(bl ? "com.google.iid.TOKEN_REQUEST" : "com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(zze.zzbd((Context)this.zzqD));
        this.zzf(intent);
        String string = String.valueOf("google.rpc");
        String string2 = String.valueOf(String.valueOf(zzbfR.getAndIncrement()));
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        intent.putExtra("google.message_id", string3);
        intent.putExtras(bundle);
        intent.putExtra("google.messenger", (Parcelable)this.zzbfT);
        if (bl) {
            this.zzqD.sendBroadcast(intent);
        } else {
            this.zzqD.startService(intent);
        }
        try {
            return this.zzbfS.poll(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private static String zzc(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',').append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string)) {
            return null;
        }
        String string2 = intent.getStringExtra("message_type");
        if (string2 != null) {
            return string2;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    private final synchronized void zzf(Intent intent) {
        if (this.zzbfP == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzbfP = PendingIntent.getBroadcast((Context)this.zzqD, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzbfP);
    }

    private final synchronized void zzvD() {
        if (this.zzbfP != null) {
            this.zzbfP.cancel();
            this.zzbfP = null;
        }
    }

    public static int zzaZ(Context context) {
        String string = zze.zzbd((Context)context);
        if (string != null) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string, 0);
                if (packageInfo != null) {
                    return packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return -1;
    }

    static /* synthetic */ BlockingQueue zza(GoogleCloudMessaging googleCloudMessaging) {
        return googleCloudMessaging.zzbfS;
    }

    static /* synthetic */ boolean zza(GoogleCloudMessaging googleCloudMessaging, Intent intent) {
        return googleCloudMessaging.zze(intent);
    }

    static /* synthetic */ Context zzb(GoogleCloudMessaging googleCloudMessaging) {
        return googleCloudMessaging.zzqD;
    }

    static {
        zzbfR = new AtomicInteger(1);
    }
}

