/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;
import com.google.android.gms.gcm.zzh;

public class PeriodicTask
extends Task {
    protected long mIntervalInSeconds = -1L;
    protected long mFlexInSeconds = -1L;
    public static final Parcelable.Creator<PeriodicTask> CREATOR = new zzh();

    private PeriodicTask(Builder builder) {
        super(builder);
        this.mIntervalInSeconds = builder.zzbfZ;
        this.mFlexInSeconds = Math.min(builder.zzbga, this.mIntervalInSeconds);
    }

    @Deprecated
    private PeriodicTask(Parcel parcel) {
        super(parcel);
        this.mIntervalInSeconds = parcel.readLong();
        this.mFlexInSeconds = Math.min(parcel.readLong(), this.mIntervalInSeconds);
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("period", this.mIntervalInSeconds);
        bundle.putLong("period_flex", this.mFlexInSeconds);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        super.writeToParcel(parcel, n);
        parcel.writeLong(this.mIntervalInSeconds);
        parcel.writeLong(this.mFlexInSeconds);
    }

    public long getPeriod() {
        return this.mIntervalInSeconds;
    }

    public long getFlex() {
        return this.mFlexInSeconds;
    }

    public String toString() {
        String string = String.valueOf(super.toString());
        long l = this.getPeriod();
        long l2 = this.getFlex();
        return new StringBuilder(54 + String.valueOf(string).length()).append(string).append(" period=").append(l).append(" flex=").append(l2).toString();
    }

    /* synthetic */ PeriodicTask(Parcel parcel, zzh zzh2) {
        this(parcel);
    }

    /* synthetic */ PeriodicTask(Builder builder, zzh zzh2) {
        this(builder);
    }

    public static class Builder
    extends Task.Builder {
        private long zzbfZ = -1L;
        private long zzbga = -1L;

        public Builder() {
            this.isPersisted = true;
        }

        public Builder setPeriod(long l) {
            this.zzbfZ = l;
            return this;
        }

        public Builder setFlex(long l) {
            this.zzbga = l;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> clazz) {
            this.gcmTaskService = clazz.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int n) {
            this.requiredNetworkState = n;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean bl) {
            this.requiresCharging = bl;
            return this;
        }

        @Override
        public Builder setTag(String string) {
            this.tag = string;
            return this;
        }

        @Override
        public Builder setPersisted(boolean bl) {
            this.isPersisted = bl;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean bl) {
            this.updateCurrent = bl;
            return this;
        }

        @Override
        public Builder setExtras(Bundle bundle) {
            this.extras = bundle;
            return this;
        }

        @Override
        public PeriodicTask build() {
            this.checkConditions();
            return new PeriodicTask(this, null);
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzbfZ == -1L) {
                throw new IllegalArgumentException("Must call setPeriod(long) to establish an execution interval for this periodic task.");
            }
            if (this.zzbfZ <= 0L) {
                long l = this.zzbfZ;
                throw new IllegalArgumentException(new StringBuilder(66).append("Period set cannot be less than or equal to 0: ").append(l).toString());
            }
            if (this.zzbga == -1L) {
                this.zzbga = (long)((float)this.zzbfZ * 0.1f);
                return;
            }
            if (this.zzbga > this.zzbfZ) {
                this.zzbga = this.zzbfZ;
            }
        }
    }
}

