/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbfi;
import com.google.android.gms.internal.zzbfk;

public final class zzbfg
extends Drawable
implements Drawable.Callback {
    private int zzaGo = 0;
    private long zzagZ;
    private int mFrom;
    private int zzaGp;
    private int zzaGq = 255;
    private int zzaGr;
    private int zzaGs = 0;
    private boolean zzaGj = true;
    private boolean zzaGt;
    private zzbfk zzaGu;
    private Drawable zzaGv;
    private Drawable zzaGw;
    private boolean zzaGx;
    private boolean zzaGy;
    private boolean zzaGz;
    private int zzaGA;

    public zzbfg(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbfi.zzqX();
        }
        this.zzaGv = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzaGu.zzaGD |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbfi.zzqX();
        }
        this.zzaGw = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzaGu.zzaGD |= drawable3.getChangingConfigurations();
    }

    zzbfg(zzbfk zzbfk2) {
        this.zzaGu = new zzbfk(zzbfk2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzaGu.mChangingConfigurations | this.zzaGu.zzaGD;
    }

    public final void setAlpha(int n) {
        if (this.zzaGs == this.zzaGq) {
            this.zzaGs = n;
        }
        this.zzaGq = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzaGv.setColorFilter(colorFilter);
        this.zzaGw.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzaGv.getIntrinsicWidth(), this.zzaGw.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzaGv.getIntrinsicHeight(), this.zzaGw.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzaGv.setBounds(rect);
        this.zzaGw.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzaGu.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzaGu;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzaGz) {
            this.zzaGA = Drawable.resolveOpacity((int)this.zzaGv.getOpacity(), (int)this.zzaGw.getOpacity());
            this.zzaGz = true;
        }
        return this.zzaGA;
    }

    private final boolean canConstantState() {
        if (!this.zzaGx) {
            this.zzaGy = this.zzaGv.getConstantState() != null && this.zzaGw.getConstantState() != null;
            this.zzaGx = true;
        }
        return this.zzaGy;
    }

    public final Drawable mutate() {
        if (!this.zzaGt && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzaGv.mutate();
            this.zzaGw.mutate();
            this.zzaGt = true;
        }
        return this;
    }

    public final Drawable zzqW() {
        return this.zzaGw;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzaGp = this.zzaGq;
        this.zzaGs = 0;
        this.zzaGr = 250;
        this.zzaGo = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzaGo) {
            case 1: {
                this.zzagZ = SystemClock.uptimeMillis();
                bl = false;
                this.zzaGo = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzagZ < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzagZ) / (float)this.zzaGr;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzaGo = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.zzaGs = (int)(0.0f + (float)this.zzaGp * f2);
            }
        }
        int n = this.zzaGs;
        boolean bl2 = this.zzaGj;
        Drawable drawable2 = this.zzaGv;
        Drawable drawable3 = this.zzaGw;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzaGq) {
                drawable3.setAlpha(this.zzaGq);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzaGq - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzaGq);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzaGq);
        }
        this.invalidateSelf();
    }
}

