/*
 * Decompiled with CFR 0.152.
 */
package com.pushbots.push;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.util.Log;
import com.pushbots.push.DefaultPushHandler;
import com.pushbots.push.GCMBroadcastReceiver;
import com.pushbots.push.Pushbots;

public class GCMIntentService
extends IntentService {
    private static final String GCM_RECEIVE = "com.google.android.c2dm.intent.RECEIVE";
    private static final String GCM_TYPE = "gcm";
    private Handler mHandler;

    public GCMIntentService() {
        super("GcmIntentService");
        this.setIntentRedelivery(true);
    }

    private static boolean isGcmMessage(Intent intent) {
        if (GCM_RECEIVE.equals(intent.getAction())) {
            String messageType = intent.getStringExtra("message_type");
            return messageType == null || GCM_TYPE.equals(messageType);
        }
        return false;
    }

    protected void onHandleIntent(Intent intent) {
        if (GCMIntentService.isGcmMessage(intent)) {
            Log.i((String)"PB3", (String)"Received a Notification.");
            SharedPreferences sharedPref = this.getSharedPreferences("com.pushbots", 0);
            String handler = sharedPref.getString("custom_handler", null);
            Log.i((String)"PB3", (String)("customHandler:" + handler));
            Intent localIntent = new Intent("com.pushbots.MSG_RECEIVE");
            localIntent.putExtra("com.pushbots.MSG_RECEIVE", intent.getExtras());
            if (handler != null) {
                try {
                    localIntent.setClass((Context)this, Class.forName(handler));
                }
                catch (ClassNotFoundException e) {
                    Log.e((String)"PB3", (String)("Custom Handler function " + handler + "doesn't exist"));
                    e.printStackTrace();
                }
            } else {
                localIntent.setClass((Context)this, DefaultPushHandler.class);
            }
            this.sendBroadcast(localIntent);
            try {
                Pushbots.sharedInstance();
                Pushbots.NotificationBuilder().generateNotification((Context)this, intent, this.mHandler);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        GCMBroadcastReceiver.completeWakefulIntent((Intent)intent);
    }
}

