/*
 * Decompiled with CFR 0.152.
 */
package com.pushbots.push;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.iid.InstanceID;
import com.pushbots.push.utils.Log;
import java.io.IOException;

public class GCMRegistrar {
    private Context appContext;
    private RegisteredHandler registeredHandler;
    private static int GCM_RETRY_COUNT = 5;

    public void registerForPush(Context context, String googleProjectNumber, RegisteredHandler callback) {
        this.appContext = context;
        this.registeredHandler = callback;
        try {
            if (this.checkPlayServices()) {
                this.registerInBackground(googleProjectNumber);
            } else {
                Log.e("No valid Google Play services APK found.");
                this.registeredHandler.complete(null);
            }
        }
        catch (Throwable t) {
            Log.e("Could not register with GCM due to an error with the AndroidManifest.xml file or with 'Google Play services'." + t);
            this.registeredHandler.complete(null);
        }
    }

    private boolean isGooglePlayStoreInstalled() {
        try {
            PackageManager pm = this.appContext.getPackageManager();
            PackageInfo info = pm.getPackageInfo("com.android.vending", 1);
            String label = (String)info.applicationInfo.loadLabel(pm);
            return label != null && !label.equals("Market");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean checkPlayServices() {
        GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
        int resultCode = googleAPI.isGooglePlayServicesAvailable(this.appContext);
        if (resultCode != 0) {
            if (googleAPI.isUserResolvableError(resultCode) && this.isGooglePlayStoreInstalled()) {
                Log.i("Google Play services Recoverable Error: " + resultCode);
            } else {
                Log.w("Google Play services error: This device is not supported. Code:" + resultCode);
            }
            return false;
        }
        return true;
    }

    private void registerInBackground(final String googleProjectNumber) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean firedComplete = false;
                for (int currentRetry = 0; currentRetry < GCM_RETRY_COUNT; ++currentRetry) {
                    try {
                        InstanceID instanceID = InstanceID.getInstance((Context)GCMRegistrar.this.appContext);
                        String registrationId = instanceID.getToken(googleProjectNumber, "GCM", null);
                        GCMRegistrar.this.registeredHandler.complete(registrationId);
                        break;
                    }
                    catch (IOException e) {
                        if (!"SERVICE_NOT_AVAILABLE".equals(e.getMessage())) {
                            Log.e("Error Getting Google Registration ID" + e);
                            if (firedComplete) break;
                            GCMRegistrar.this.registeredHandler.complete(null);
                            break;
                        }
                        if (currentRetry >= GCM_RETRY_COUNT - 1) {
                            Log.e("GCM_RETRY_COUNT of " + GCM_RETRY_COUNT + " exceed! Could not get a Google Registration Id" + e);
                            continue;
                        }
                        Log.i("Google Play services returned SERVICE_NOT_AVAILABLE error. Current retry count: " + currentRetry + e);
                        if (currentRetry == 2) {
                            GCMRegistrar.this.registeredHandler.complete(null);
                            firedComplete = true;
                        }
                        try {
                            Thread.sleep(10000 * (currentRetry + 1));
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    catch (Throwable t) {
                        Log.e("Error Getting Google Registration ID" + t);
                        GCMRegistrar.this.registeredHandler.complete(null);
                        break;
                    }
                }
            }
        }).start();
    }

    static interface RegisteredHandler {
        public void complete(String var1);
    }
}

