/*
 * Decompiled with CFR 0.152.
 */
package com.pushbots.push;

import android.util.Log;
import com.pushbots.push.Pushbots;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Scanner;
import org.json.JSONObject;

class PBClient {
    private static final String BASE_URL = "https://api.pushbots.com/";
    private static final int TIMEOUT = 100000;

    PBClient() {
    }

    static void putAsync(final String appId, final String url, final JSONObject jsonBody, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PBClient.executeRequest(url, appId, "PUT", jsonBody, responseHandler);
            }
        }).start();
    }

    static void postAsync(final String appId, final String url, final JSONObject jsonBody, final ResponseHandler responseHandler) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PBClient.executeRequest(url, appId, "POST", jsonBody, responseHandler);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeRequest(String url, String appId, String verb, JSONObject jsonBody, ResponseHandler responseHandler) {
        HttpURLConnection con = null;
        int statusCode = -1;
        String json = null;
        Log.d((String)"PB3", (String)("APPID:" + appId));
        try {
            Scanner scanner;
            InputStream inputStream;
            con = (HttpURLConnection)new URL(BASE_URL + url).openConnection();
            con.setReadTimeout(100000);
            con.setConnectTimeout(100000);
            con.setUseCaches(false);
            if (jsonBody != null) {
                con.setDoInput(true);
            }
            if (appId != null) {
                con.setRequestProperty("X-PUSHBOTS-APPID", appId);
            }
            if (verb != null) {
                con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                con.setRequestMethod(verb);
                con.setDoOutput(true);
            }
            if (jsonBody != null) {
                String params = jsonBody.toString();
                Log.i((String)"PB3", (String)(verb + " " + url));
                Log.i((String)"PB3", (String)("Params: " + params));
                byte[] sendBytes = params.getBytes("UTF-8");
                con.setFixedLengthStreamingMode(sendBytes.length);
                OutputStream outputStream = con.getOutputStream();
                outputStream.write(sendBytes);
            }
            statusCode = con.getResponseCode();
            Log.i((String)"PB3", (String)("Response status code: " + statusCode));
            if (statusCode == 200 || statusCode == 201) {
                inputStream = con.getInputStream();
                scanner = new Scanner(inputStream, "UTF-8");
                json = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                scanner.close();
                if (jsonBody.has("subscribed")) {
                    Pushbots.setNotificationEnabled(jsonBody.getBoolean("subscribed"));
                }
                if (responseHandler != null) {
                    responseHandler.onSuccess(json);
                }
            } else {
                inputStream = con.getErrorStream();
                if (inputStream == null) {
                    inputStream = con.getInputStream();
                }
                if (inputStream != null) {
                    scanner = new Scanner(inputStream, "UTF-8");
                    json = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
                    scanner.close();
                    Log.i((String)"PB3", (String)("Response: " + json));
                } else {
                    Log.w((String)"PB3", (String)"No response body!");
                }
                if (responseHandler != null) {
                    responseHandler.onFailure(statusCode, json, null);
                }
            }
        }
        catch (Throwable t) {
            if (t instanceof ConnectException || t instanceof UnknownHostException) {
                Log.i((String)"PB3", (String)("Device is offline, Please check internet connection. Throwable: " + t.getClass().getName()));
            } else {
                Log.w((String)"PB3", (String)(verb + " Error from network. " + t));
            }
            if (responseHandler != null) {
                responseHandler.onFailure(statusCode, null, t);
            }
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    static class ResponseHandler {
        ResponseHandler() {
        }

        void onSuccess(String response) {
        }

        void onFailure(int statusCode, String response, Throwable throwable) {
        }
    }
}

