/*
 * Decompiled with CFR 0.152.
 */
package com.pushbots.push;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import com.pushbots.push.NotificationBuildListener;
import com.pushbots.push.utils.Log;
import com.pushbots.push.utils.utils;
import java.math.BigInteger;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PBNotificationIntent {
    public static ArrayList<String> notificationsArray;
    private NotificationCompat.Builder builder;
    private static Context context;
    private NotificationBuildListener mNotificationBuildListener;

    public void buildNotification(Context ctx, Bundle data, String appName, String Text) {
        if (null != data.getString("inboxStyle")) {
            if (notificationsArray == null) {
                notificationsArray = new ArrayList();
            }
            notificationsArray.add(Text);
        } else {
            notificationsArray = null;
        }
        context = ctx;
        this.createNotification(data, Text);
    }

    private int generateSmallIconId(Bundle data) {
        String smallIcon = null != data.getString("sIco") ? data.getString("sIco") : data.getString("customIcon");
        int smallIconId = utils.getResourceIcon(smallIcon, context);
        if (0 != smallIconId) {
            return smallIconId;
        }
        smallIconId = context.getResources().getIdentifier("ic_stat_pushbots_sicon", "drawable", context.getPackageName());
        if (0 != smallIconId) {
            return smallIconId;
        }
        smallIconId = context.getResources().getIdentifier("white_notification_icon", "drawable", context.getPackageName());
        if (0 != smallIconId) {
            return smallIconId;
        }
        return 17301598;
    }

    private Bitmap generateLargeIconId(Bundle data) {
        int i;
        Bitmap largeIconBitmap;
        String largeIcon;
        if (Build.VERSION.SDK_INT < 16) {
            return null;
        }
        String string = largeIcon = null != data.getString("lIco") ? data.getString("lIco") : data.getString("largeIcon");
        if (null == largeIcon) {
            largeIcon = "ic_pushbots_licon";
        }
        if (null != (largeIconBitmap = utils.getORdownloadIcon(largeIcon, context, i = Build.VERSION.SDK_INT >= 11 ? (int)context.getResources().getDimension(17104902) : 64))) {
            return largeIconBitmap;
        }
        return null;
    }

    private Notification checkBigPictureStyle(Bundle data, String Text) {
        String imageUri;
        if (Build.VERSION.SDK_INT < 16) {
            return null;
        }
        if (null != data.getString("BigPictureStyle")) {
            imageUri = data.getString("imgUrl");
        } else if (null != data.getString("bigPicture")) {
            imageUri = data.getString("bigPicture");
        } else {
            return null;
        }
        Log.i("Set Big Picture");
        NotificationCompat.BigPictureStyle notiStyle = new NotificationCompat.BigPictureStyle();
        Bitmap loadedImage = utils.getORdownloadIcon(imageUri, context, -1);
        if (loadedImage != null) {
            if (null != data.getString("customNotificationTitle")) {
                notiStyle.setBigContentTitle((CharSequence)data.getString("customNotificationTitle"));
                this.builder.setContentTitle((CharSequence)data.getString("customNotificationTitle"));
            } else if (null != data.getString("nTitle")) {
                notiStyle.setBigContentTitle((CharSequence)data.getString("nTitle"));
                this.builder.setContentTitle((CharSequence)data.getString("nTitle"));
            }
            if (null != data.getString("summaryText")) {
                notiStyle.setSummaryText((CharSequence)data.getString("summaryText"));
            } else if (null != data.getString("nSumm")) {
                notiStyle.setSummaryText((CharSequence)data.getString("nSumm"));
            } else {
                notiStyle.setSummaryText((CharSequence)Text);
            }
            notiStyle.bigPicture(loadedImage);
            this.builder.setContentText((CharSequence)Text).setStyle((NotificationCompat.Style)notiStyle);
        }
        Notification notification = this.builder.build();
        return notification;
    }

    private Notification checkBigTextStyle(Bundle data, String Text) {
        if (Build.VERSION.SDK_INT < 16) {
            return null;
        }
        NotificationCompat.BigTextStyle notiStyle = new NotificationCompat.BigTextStyle();
        if (null != data.getString("bigText")) {
            if (null != data.getString("keepText")) {
                notiStyle.bigText((CharSequence)(Text + "\n\n" + data.getString("bigText")));
                Log.i(Text + "\n\n" + data.getString("bigText"));
            } else {
                notiStyle.bigText((CharSequence)data.getString("bigText"));
            }
            if (null != data.getString("customNotificationTitle")) {
                notiStyle.setBigContentTitle((CharSequence)data.getString("customNotificationTitle"));
                this.builder.setContentTitle((CharSequence)data.getString("customNotificationTitle"));
            } else if (null != data.getString("nTitle")) {
                notiStyle.setBigContentTitle((CharSequence)data.getString("nTitle"));
                this.builder.setContentTitle((CharSequence)data.getString("nTitle"));
            }
            if (null != data.getString("summaryText")) {
                notiStyle.setSummaryText((CharSequence)data.getString("summaryText"));
            } else if (null != data.getString("nSumm")) {
                notiStyle.setSummaryText((CharSequence)data.getString("nSumm"));
            } else {
                notiStyle.setSummaryText((CharSequence)Text);
            }
        } else {
            return null;
        }
        this.builder.setContentText((CharSequence)Text).setStyle((NotificationCompat.Style)notiStyle);
        Notification notification = this.builder.build();
        return notification;
    }

    private void addActionButtons(Bundle data) {
        if (Build.VERSION.SDK_INT < 16) {
            return;
        }
        if (data.containsKey("actionBtns")) {
            String buttons = data.getString("actionBtns");
            try {
                JSONArray buttonsArray = new JSONArray(buttons);
                for (int i = 0; i < buttonsArray.length(); ++i) {
                    Intent Btnintent;
                    JSONObject button = buttonsArray.optJSONObject(i);
                    if (button.getString("action").startsWith("http://") || button.getString("action").startsWith("https://")) {
                        Btnintent = new Intent("android.intent.action.VIEW", Uri.parse((String)button.getString("action")));
                        Btnintent.setFlags(0x10008000);
                    } else {
                        Btnintent = new Intent(context, Class.forName(button.getString("action")));
                        Btnintent.setAction("" + i);
                        Btnintent.putExtras(data);
                    }
                    PendingIntent pendingOneIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)Btnintent, (int)0x8000000);
                    int customId = utils.getResourceIcon(button.getString("icon"), context);
                    this.builder.addAction(customId, (CharSequence)button.getString("title"), pendingOneIntent);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void createNotification(Bundle data, String Text) {
        String packageName = context.getPackageName();
        Intent resultIntent = new Intent(context.getPackageManager().getLaunchIntentForPackage(packageName));
        resultIntent.setFlags(0x10008000);
        PendingIntent resultPendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)resultIntent, (int)0x8000000);
        int icon = this.generateSmallIconId(data);
        Bitmap loadedLargeImage = this.generateLargeIconId(data);
        this.builder = new NotificationCompat.Builder(context).setContentTitle(PBNotificationIntent.getApplicationName()).setSmallIcon(icon).setWhen(System.currentTimeMillis()).setContentIntent(resultPendingIntent);
        if (loadedLargeImage != null) {
            Log.d("Settings large Icon to" + loadedLargeImage);
            this.builder.setLargeIcon(loadedLargeImage);
        }
        this.builder.setContentIntent(resultPendingIntent);
        try {
            BigInteger accentColor = new BigInteger(data.getString("accColor"), 16);
            if (accentColor != null) {
                this.builder.setColor(accentColor.intValue());
            }
        }
        catch (Throwable accentColor) {
            // empty catch block
        }
        this.addActionButtons(data);
        Notification bigPictureNoti = this.checkBigPictureStyle(data, Text);
        if (null != bigPictureNoti) {
            this.mNotificationBuildListener.onNotificationReady(bigPictureNoti);
            return;
        }
        Notification bigTextNoti = this.checkBigTextStyle(data, Text);
        if (null != bigTextNoti) {
            this.mNotificationBuildListener.onNotificationReady(bigTextNoti);
            return;
        }
        if (null != data.getString("customNotificationTitle")) {
            this.builder.setContentTitle((CharSequence)data.getString("customNotificationTitle"));
        } else if (null != data.getString("nTitle")) {
            this.builder.setContentTitle((CharSequence)data.getString("nTitle"));
        }
        if (null != data.getString("inboxStyle")) {
            String new_notifications = "new notifications.";
            if (null != data.getString("summaryText")) {
                new_notifications = data.getString("summaryText");
            } else if (null != data.getString("nLocale")) {
                new_notifications = data.getString("nLocale");
            }
            NotificationManagerCompat.from((Context)context).cancelAll();
            this.builder.setNumber(notificationsArray.size());
            if (notificationsArray.size() > 1) {
                NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
                int l = notificationsArray.size();
                int max = 7;
                int startfrom = 0;
                if (l - max > 0) {
                    startfrom = l - max;
                }
                for (int i = startfrom; i < l; ++i) {
                    inboxStyle.addLine((CharSequence)notificationsArray.get(i));
                }
                inboxStyle.setSummaryText((CharSequence)(notificationsArray.size() + " " + new_notifications));
                this.builder.setStyle((NotificationCompat.Style)inboxStyle);
            } else {
                this.builder.setContentText((CharSequence)notificationsArray.get(0));
            }
        } else {
            this.builder.setContentText((CharSequence)Text);
        }
        Notification summaryNotification = this.builder.build();
        this.mNotificationBuildListener.onNotificationReady(summaryNotification);
    }

    public static CharSequence getApplicationName() {
        CharSequence appLabel;
        try {
            int labelResId = PBNotificationIntent.context.getApplicationInfo().labelRes;
            appLabel = context.getString(labelResId);
        }
        catch (Resources.NotFoundException e) {
            try {
                PackageManager packageManager = context.getPackageManager();
                ApplicationInfo contextInfo = context.getApplicationInfo();
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(contextInfo.packageName, 0);
                appLabel = packageManager.getApplicationLabel(applicationInfo);
            }
            catch (PackageManager.NameNotFoundException e1) {
                appLabel = "Unknown";
            }
        }
        return appLabel;
    }

    public void setNotificationBuildListener(NotificationBuildListener notificationBuildListener) {
        this.mNotificationBuildListener = notificationBuildListener;
    }
}

