/*
 * Decompiled with CFR 0.152.
 */
package com.pushbots.push.utils;

import android.R;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.pushbots.push.utils.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;

public class utils {
    public static void checkNotNull(Object paramObject, String paramString) {
        if (paramObject == null) {
            throw new IllegalArgumentException(String.format("Please set the %1$s constant and recompile the app.", paramString));
        }
    }

    public static Bitmap getORdownloadIcon(String paramString, Context paramContext, int paramInt) {
        if (paramString == null) {
            return null;
        }
        Bitmap downloadedBitmap = null;
        if (paramString.startsWith("http://") || paramString.startsWith("https://")) {
            downloadedBitmap = utils.downloadBitmap(paramString, paramContext, paramInt);
        }
        if (null != downloadedBitmap) {
            return downloadedBitmap;
        }
        return utils.getIconFromAssetsOrDrawable(paramString, paramContext);
    }

    private static Bitmap getIconFromAssetsOrDrawable(String bitmapStr, Context paramContext) {
        try {
            Bitmap bitmap = null;
            try {
                bitmap = BitmapFactory.decodeStream((InputStream)paramContext.getAssets().open(bitmapStr));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bitmap != null) {
                return bitmap;
            }
            List<String> image_extensions = Arrays.asList(".png", ".jpg", ".gif");
            for (String extension : image_extensions) {
                try {
                    bitmap = BitmapFactory.decodeStream((InputStream)paramContext.getAssets().open(bitmapStr + extension));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (bitmap == null) continue;
                return bitmap;
            }
            int bitmapId = utils.getResourceIcon(bitmapStr, paramContext);
            if (bitmapId != 0) {
                return BitmapFactory.decodeResource((Resources)paramContext.getResources(), (int)bitmapId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static int getResourceIcon(String iconName, Context ctx) {
        if (iconName == null || iconName.matches("^[0-9]")) {
            return 0;
        }
        Log.d("TEST1: iconName" + iconName);
        int notificationIcon = ctx.getResources().getIdentifier(iconName, "drawable", ctx.getPackageName());
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        try {
            return R.drawable.class.getField(iconName).getInt(null);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap downloadBitmap(String paramString, Context paramContext, int paramInt) {
        if (null != paramString) {
            InputStream localInputStream = null;
            try {
                int i;
                URL localURL = new URL(paramString);
                URLConnection localURLConnection = localURL.openConnection();
                localURLConnection.connect();
                localInputStream = localURLConnection.getInputStream();
                ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
                byte[] paramArrayOfByte = new byte[1024];
                while ((i = localInputStream.read(paramArrayOfByte)) != -1) {
                    localByteArrayOutputStream.write(paramArrayOfByte, 0, i);
                }
                localInputStream.close();
                localByteArrayOutputStream.close();
                paramArrayOfByte = localByteArrayOutputStream.toByteArray();
                BitmapFactory.Options localOptions = new BitmapFactory.Options();
                localOptions.inJustDecodeBounds = true;
                BitmapFactory.decodeByteArray((byte[])paramArrayOfByte, (int)0, (int)paramArrayOfByte.length, (BitmapFactory.Options)localOptions);
                int j = Math.max(localOptions.outWidth, localOptions.outHeight);
                float f = 1.0f;
                if (-1 != paramInt) {
                    f = (float)j / ((float)paramInt * paramContext.getResources().getDisplayMetrics().density);
                }
                localOptions.inJustDecodeBounds = false;
                localOptions.inSampleSize = Math.round(f);
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])paramArrayOfByte, (int)0, (int)paramArrayOfByte.length, (BitmapFactory.Options)localOptions);
                return bitmap;
            }
            catch (Throwable throwable) {
            }
            finally {
                if (null != localInputStream) {
                    try {
                        localInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                System.gc();
            }
        }
        return null;
    }
}

