/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamite;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.zze;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamite.zza;
import com.google.android.gms.dynamite.zzb;
import dalvik.system.PathClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public final class DynamiteModule {
    private static Boolean zzaRO;
    private static com.google.android.gms.dynamite.zza zzaRP;
    private static com.google.android.gms.dynamite.zzb zzaRQ;
    private static final HashMap<String, byte[]> zzaRR;
    private static String zzaRS;
    private static final zzb.zza zzaRT;
    public static final zzb zzaRU;
    public static final zzb zzaRV;
    public static final zzb zzaRW;
    public static final zzb zzaRX;
    public static final zzb zzaRY;
    private final Context zzaRZ;

    public static DynamiteModule zza(Context context, zzb zzb2, String string2) throws zza {
        zzb.zzb zzb3 = zzb2.zza(context, string2, zzaRT);
        int n = zzb3.zzaSb;
        final int n2 = zzb3.zzaSc;
        Log.i((String)"DynamiteModule", (String)new StringBuilder(68 + String.valueOf(string2).length() + String.valueOf(string2).length()).append("Considering local module ").append(string2).append(":").append(n).append(" and remote module ").append(string2).append(":").append(n2).toString());
        if (zzb3.zzaSd == 0 || zzb3.zzaSd == -1 && zzb3.zzaSb == 0 || zzb3.zzaSd == 1 && zzb3.zzaSc == 0) {
            n = zzb3.zzaSb;
            n2 = zzb3.zzaSc;
            throw new zza(new StringBuilder(91).append("No acceptable module found. Local version is ").append(n).append(" and remote version is ").append(n2).append(".").toString());
        }
        if (zzb3.zzaSd == -1) {
            return DynamiteModule.zzK(context, string2);
        }
        if (zzb3.zzaSd == 1) {
            try {
                return DynamiteModule.zza(context, string2, zzb3.zzaSc);
            }
            catch (zza zza2) {
                String string3 = String.valueOf(zza2.getMessage());
                Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load remote module: ".concat(string3) : new String("Failed to load remote module: ")));
                if (zzb3.zzaSb != 0) {
                    n2 = zzb3.zzaSb;
                    zzb.zza zza3 = new zzb.zza(){

                        @Override
                        public int zzb(Context context, String string2, boolean bl) {
                            return 0;
                        }

                        @Override
                        public int zzI(Context context, String string2) {
                            return n2;
                        }
                    };
                    zzb3 = zzb2.zza(context, string2, zza3);
                    if (zzb3.zzaSd == -1) {
                        return DynamiteModule.zzK(context, string2);
                    }
                }
                throw new zza("Remote load failed. No local fallback found.", zza2);
            }
        }
        n = zzb3.zzaSd;
        throw new zza(new StringBuilder(47).append("VersionPolicy returned invalid code:").append(n).toString());
    }

    public static int zzI(Context context, String string2) {
        try {
            Object object = String.valueOf("com.google.android.gms.dynamite.descriptors.");
            Object object2 = String.valueOf("ModuleDescriptor");
            Class<?> clazz = context.getApplicationContext().getClassLoader().loadClass(new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string2).length() + String.valueOf(object2).length()).append((String)object).append(string2).append(".").append((String)object2).toString());
            object = clazz.getDeclaredField("MODULE_ID");
            object2 = clazz.getDeclaredField("MODULE_VERSION");
            if (!((Field)object).get(null).equals(string2)) {
                String string3 = String.valueOf(((Field)object).get(null));
                Log.e((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Module descriptor id '").append(string3).append("' didn't match expected id '").append(string2).append("'").toString());
                return 0;
            }
            return ((Field)object2).getInt(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"DynamiteModule", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Local module descriptor class for ").append(string2).append(" not found.").toString());
        }
        catch (Exception exception) {
            String string4 = String.valueOf(exception.getMessage());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load module descriptor class: ".concat(string4) : new String("Failed to load module descriptor class: ")));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int zzb(Context context, String string2, boolean bl) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            Boolean bl2 = zzaRO;
            if (bl2 == null) {
                try {
                    ClassLoader classLoader = context.getApplicationContext().getClassLoader();
                    Class<?> clazz2 = classLoader.loadClass(DynamiteLoaderClassLoader.class.getName());
                    Field field = clazz2.getDeclaredField("sClassLoader");
                    Class<?> clazz3 = clazz2;
                    synchronized (clazz3) {
                        ClassLoader classLoader2 = (ClassLoader)field.get(null);
                        if (classLoader2 != null) {
                            if (classLoader2 == ClassLoader.getSystemClassLoader()) {
                                bl2 = Boolean.FALSE;
                            } else {
                                try {
                                    DynamiteModule.zza(classLoader2);
                                }
                                catch (zza zza2) {}
                                bl2 = Boolean.TRUE;
                            }
                        } else if ("com.google.android.gms".equals(context.getApplicationContext().getPackageName())) {
                            field.set(null, ClassLoader.getSystemClassLoader());
                            bl2 = Boolean.FALSE;
                        } else {
                            try {
                                int n = DynamiteModule.zzd(context, string2, bl);
                                if (zzaRS == null || zzaRS.isEmpty()) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 1, 2, 4, 20, 6, 22, 7, 15] lbl31 : MonitorExitStatement: MONITOREXIT : var8_11
                                    // ** MonitorExit[var4_3] (shouldn't be in output)
                                    return n;
                                }
                                classLoader2 = DynamiteModule.zzBT();
                                DynamiteModule.zza(classLoader2);
                                field.set(null, classLoader2);
                                zzaRO = Boolean.TRUE;
                                // MONITOREXIT @DISABLED, blocks:[0, 16, 1, 2, 4, 20, 6, 22, 7] lbl38 : MonitorExitStatement: MONITOREXIT : var8_11
                                // ** MonitorExit[var4_3] (shouldn't be in output)
                                return n;
                            }
                            catch (zza zza3) {
                                field.set(null, ClassLoader.getSystemClassLoader());
                                bl2 = Boolean.FALSE;
                            }
                        }
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    String string3 = String.valueOf(reflectiveOperationException);
                    Log.w((String)"DynamiteModule", (String)new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to load module via V2: ").append(string3).toString());
                    bl2 = Boolean.FALSE;
                }
                zzaRO = bl2;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl2.booleanValue()) {
                try {
                    return DynamiteModule.zzd(context, string2, bl);
                }
                catch (zza zza4) {
                    String string4 = String.valueOf(zza4.getMessage());
                    Log.w((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to retrieve remote module version: ".concat(string4) : new String("Failed to retrieve remote module version: ")));
                    return 0;
                }
            }
            return DynamiteModule.zzc(context, string2, bl);
        }
    }

    private static int zzc(Context context, String string2, boolean bl) {
        com.google.android.gms.dynamite.zza zza2 = DynamiteModule.zzbm(context);
        if (zza2 == null) {
            return 0;
        }
        try {
            return zza2.zza(zzd.zzA(context), string2, bl);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(remoteException.getMessage());
            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to retrieve remote module version: ".concat(string3) : new String("Failed to retrieve remote module version: ")));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int zzd(Context context, String string2, boolean bl) throws zza {
        try (Cursor cursor = null;){
            cursor = DynamiteModule.zze(context, string2, bl);
            if (cursor == null || !cursor.moveToFirst()) {
                Log.w((String)"DynamiteModule", (String)"Failed to retrieve remote module version.");
                throw new zza("Failed to connect to dynamite module ContentResolver.");
            }
            int n = cursor.getInt(0);
            if (n <= 0) return n;
            Class<DynamiteModule> clazz = DynamiteModule.class;
            synchronized (DynamiteModule.class) {
                byte[] byArray = Base64.decode((String)cursor.getString(3), (int)0);
                zzaRR.put(new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(":").append(n).toString(), byArray);
                zzaRS = cursor.getString(2);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return n;
            }
        }
    }

    public static int zzJ(Context context, String string2) {
        return DynamiteModule.zzb(context, string2, false);
    }

    public static Cursor zze(Context context, String string2, boolean bl) {
        String string3 = bl ? "api_force_staging" : "api";
        String string4 = String.valueOf("content://com.google.android.gms.chimera/");
        Uri uri = Uri.parse((String)new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string4).append(string3).append("/").append(string2).toString());
        return context.getContentResolver().query(uri, null, null, null, null);
    }

    private static DynamiteModule zzK(Context context, String string2) {
        String string3 = String.valueOf(string2);
        Log.i((String)"DynamiteModule", (String)(string3.length() != 0 ? "Selected local version of ".concat(string3) : new String("Selected local version of ")));
        return new DynamiteModule(context.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zza(Context context, String string2, int n) throws zza {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            Boolean bl = zzaRO;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl == null) {
                throw new zza("Failed to determine which loading route to use.");
            }
            if (bl.booleanValue()) {
                return DynamiteModule.zzc(context, string2, n);
            }
            return DynamiteModule.zzb(context, string2, n);
        }
    }

    private static DynamiteModule zzb(Context context, String string2, int n) throws zza {
        IObjectWrapper iObjectWrapper;
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        com.google.android.gms.dynamite.zza zza2 = DynamiteModule.zzbm(context);
        if (zza2 == null) {
            throw new zza("Failed to create IDynamiteLoader.");
        }
        try {
            iObjectWrapper = zza2.zza(zzd.zzA(context), string2, n);
        }
        catch (RemoteException remoteException) {
            throw new zza("Failed to load remote module.", remoteException);
        }
        if (zzd.zzF(iObjectWrapper) == null) {
            throw new zza("Failed to load remote module.");
        }
        return new DynamiteModule((Context)zzd.zzF(iObjectWrapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static com.google.android.gms.dynamite.zza zzbm(Context context) {
        Class<DynamiteModule> clazz = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            if (zzaRP != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return zzaRP;
            }
            if (zze.zzuY().isGooglePlayServicesAvailable(context) != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            try {
                Context context2 = context.createPackageContext("com.google.android.gms", 3);
                ClassLoader classLoader = context2.getClassLoader();
                Class<?> clazz2 = classLoader.loadClass("com.google.android.gms.chimera.container.DynamiteLoaderImpl");
                IBinder iBinder = (IBinder)clazz2.newInstance();
                com.google.android.gms.dynamite.zza zza2 = zza.zza.zzce(iBinder);
                if (zza2 != null) {
                    zzaRP = zza2;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return zza2;
                }
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"DynamiteModule", (String)(string2.length() != 0 ? "Failed to load IDynamiteLoader from GmsCore: ".concat(string2) : new String("Failed to load IDynamiteLoader from GmsCore: ")));
            }
            return null;
        }
    }

    public Context zzBS() {
        return this.zzaRZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DynamiteModule zzc(Context context, String string2, int n) throws zza {
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        Context context2 = DynamiteModule.class;
        synchronized (DynamiteModule.class) {
            byte[] byArray = zzaRR.get(new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(":").append(n).toString());
            com.google.android.gms.dynamite.zzb zzb2 = zzaRQ;
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (byArray == null) {
                throw new zza("Module implementation could not be found.");
            }
            if (zzb2 == null) {
                throw new zza("DynamiteLoaderV2 was not cached.");
            }
            context2 = context.getApplicationContext();
            Context context3 = DynamiteModule.zza(context2, string2, byArray, zzb2);
            if (context3 == null) {
                throw new zza("Failed to get module context");
            }
            return new DynamiteModule(context3);
        }
    }

    private static Context zza(Context context, String string2, byte[] byArray, com.google.android.gms.dynamite.zzb zzb2) {
        try {
            IObjectWrapper iObjectWrapper = zzb2.zza(zzd.zzA(context), string2, byArray);
            return (Context)zzd.zzF(iObjectWrapper);
        }
        catch (Exception exception) {
            String string3 = String.valueOf(exception.toString());
            Log.e((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load DynamiteLoader: ".concat(string3) : new String("Failed to load DynamiteLoader: ")));
            return null;
        }
    }

    private static ClassLoader zzBT() {
        return new PathClassLoader(zzaRS, ClassLoader.getSystemClassLoader()){

            protected Class<?> loadClass(String string2, boolean bl) throws ClassNotFoundException {
                if (!string2.startsWith("java.") && !string2.startsWith("android.")) {
                    try {
                        return this.findClass(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                return super.loadClass(string2, bl);
            }
        };
    }

    private static void zza(ClassLoader classLoader) throws zza {
        try {
            zzaRQ = zzb.zza.zzcf((IBinder)classLoader.loadClass("com.google.android.gms.dynamiteloader.DynamiteLoaderV2").getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new zza("Failed to instantiate dynamite loader", reflectiveOperationException);
        }
    }

    public IBinder zzdT(String string2) throws zza {
        try {
            Class<?> clazz = this.zzaRZ.getClassLoader().loadClass(string2);
            return (IBinder)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            String string3 = String.valueOf(string2);
            throw new zza(string3.length() != 0 ? "Failed to instantiate module class: ".concat(string3) : new String("Failed to instantiate module class: "), reflectiveOperationException);
        }
    }

    private DynamiteModule(Context context) {
        this.zzaRZ = zzac.zzw(context);
    }

    static {
        zzaRR = new HashMap();
        zzaRT = new zzb.zza(){

            @Override
            public int zzb(Context context, String string2, boolean bl) throws zza {
                return DynamiteModule.zzb(context, string2, bl);
            }

            @Override
            public int zzI(Context context, String string2) {
                return DynamiteModule.zzI(context, string2);
            }
        };
        zzaRU = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaSc = zza2.zzb(context, string2, true);
                if (zzb2.zzaSc != 0) {
                    zzb2.zzaSd = 1;
                } else {
                    zzb2.zzaSb = zza2.zzI(context, string2);
                    if (zzb2.zzaSb != 0) {
                        zzb2.zzaSd = -1;
                    }
                }
                return zzb2;
            }
        };
        zzaRV = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaSb = zza2.zzI(context, string2);
                if (zzb2.zzaSb != 0) {
                    zzb2.zzaSd = -1;
                } else {
                    zzb2.zzaSc = zza2.zzb(context, string2, true);
                    if (zzb2.zzaSc != 0) {
                        zzb2.zzaSd = 1;
                    }
                }
                return zzb2;
            }
        };
        zzaRW = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaSb = zza2.zzI(context, string2);
                zzb2.zzaSc = zza2.zzb(context, string2, true);
                zzb2.zzaSd = zzb2.zzaSb == 0 && zzb2.zzaSc == 0 ? 0 : (zzb2.zzaSb >= zzb2.zzaSc ? -1 : 1);
                return zzb2;
            }
        };
        zzaRX = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaSb = zza2.zzI(context, string2);
                zzb2.zzaSc = zza2.zzb(context, string2, true);
                zzb2.zzaSd = zzb2.zzaSb == 0 && zzb2.zzaSc == 0 ? 0 : (zzb2.zzaSc >= zzb2.zzaSb ? 1 : -1);
                return zzb2;
            }
        };
        zzaRY = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.zzaSb = zza2.zzI(context, string2);
                zzb2.zzaSc = zzb2.zzaSb != 0 ? zza2.zzb(context, string2, false) : zza2.zzb(context, string2, true);
                zzb2.zzaSd = zzb2.zzaSb == 0 && zzb2.zzaSc == 0 ? 0 : (zzb2.zzaSc >= zzb2.zzaSb ? 1 : -1);
                return zzb2;
            }
        };
    }

    @DynamiteApi
    public static class DynamiteLoaderClassLoader {
        public static ClassLoader sClassLoader;
    }

    public static class zza
    extends Exception {
        private zza(String string2) {
            super(string2);
        }

        private zza(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }

    public static interface com.google.android.gms.dynamite.DynamiteModule$zzb {
        public zzb zza(Context var1, String var2, zza var3) throws com.google.android.gms.dynamite.DynamiteModule$zza;

        public static class zzb {
            public int zzaSb = 0;
            public int zzaSc = 0;
            public int zzaSd = 0;
        }

        public static interface zza {
            public int zzb(Context var1, String var2, boolean var3) throws com.google.android.gms.dynamite.DynamiteModule$zza;

            public int zzI(Context var1, String var2);
        }
    }
}

