/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.internal.zzabe;
import com.google.android.gms.internal.zzabf;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzabg
extends Fragment
implements zzabf {
    private static WeakHashMap<Activity, WeakReference<zzabg>> zzaCS = new WeakHashMap();
    private Map<String, zzabe> zzaCT = new ArrayMap();
    private int zzJO = 0;
    private Bundle zzaCU;

    public static zzabg zzt(Activity activity) {
        zzabg zzabg2;
        WeakReference<zzabg> weakReference = zzaCS.get(activity);
        if (weakReference != null && (zzabg2 = (zzabg)weakReference.get()) != null) {
            return zzabg2;
        }
        try {
            zzabg2 = (zzabg)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzabg2 == null || zzabg2.isRemoving()) {
            zzabg2 = new zzabg();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzabg2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zzaCS.put(activity, new WeakReference<zzabg>(zzabg2));
        return zzabg2;
    }

    @Override
    public <T extends zzabe> T zza(String string2, Class<T> clazz) {
        return (T)((zzabe)clazz.cast(this.zzaCT.get(string2)));
    }

    @Override
    public void zza(String string2, @NonNull zzabe zzabe2) {
        if (this.zzaCT.containsKey(string2)) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
        }
        this.zzaCT.put(string2, zzabe2);
        this.zzb(string2, zzabe2);
    }

    private void zzb(final String string2, final @NonNull zzabe zzabe2) {
        if (this.zzJO > 0) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (zzabg.this.zzJO >= 1) {
                        zzabe2.onCreate(zzabg.this.zzaCU != null ? zzabg.this.zzaCU.getBundle(string2) : null);
                    }
                    if (zzabg.this.zzJO >= 2) {
                        zzabe2.onStart();
                    }
                    if (zzabg.this.zzJO >= 3) {
                        zzabe2.onStop();
                    }
                    if (zzabg.this.zzJO >= 4) {
                        zzabe2.onDestroy();
                    }
                }
            });
        }
    }

    @Override
    public Activity zzwV() {
        return this.getActivity();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzJO = 1;
        this.zzaCU = bundle;
        for (Map.Entry<String, zzabe> entry : this.zzaCT.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public void onStart() {
        super.onStart();
        this.zzJO = 2;
        for (zzabe zzabe2 : this.zzaCT.values()) {
            zzabe2.onStart();
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        for (zzabe zzabe2 : this.zzaCT.values()) {
            zzabe2.onActivityResult(n, n2, intent);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, zzabe> entry : this.zzaCT.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public void onStop() {
        super.onStop();
        this.zzJO = 3;
        for (zzabe zzabe2 : this.zzaCT.values()) {
            zzabe2.onStop();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.zzJO = 4;
        for (zzabe zzabe2 : this.zzaCT.values()) {
            zzabe2.onDestroy();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        for (zzabe zzabe2 : this.zzaCT.values()) {
            zzabe2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }
}

