/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import com.facebook.binaryresource.BinaryResource;
import com.facebook.cache.common.CacheErrorLogger;
import com.facebook.cache.disk.DefaultDiskStorage;
import com.facebook.cache.disk.DiskStorage;
import com.facebook.common.file.FileTree;
import com.facebook.common.file.FileUtils;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nullable;

public class DynamicDefaultDiskStorage
implements DiskStorage {
    private static final Class<?> TAG = DynamicDefaultDiskStorage.class;
    private final int mVersion;
    private final Supplier<File> mBaseDirectoryPathSupplier;
    private final String mBaseDirectoryName;
    private final CacheErrorLogger mCacheErrorLogger;
    @VisibleForTesting
    volatile State mCurrentState;

    public DynamicDefaultDiskStorage(int version, Supplier<File> baseDirectoryPathSupplier, String baseDirectoryName, CacheErrorLogger cacheErrorLogger) {
        this.mVersion = version;
        this.mCacheErrorLogger = cacheErrorLogger;
        this.mBaseDirectoryPathSupplier = baseDirectoryPathSupplier;
        this.mBaseDirectoryName = baseDirectoryName;
        this.mCurrentState = new State(null, null);
    }

    @Override
    public boolean isEnabled() {
        try {
            return this.get().isEnabled();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public BinaryResource getResource(String resourceId, Object debugInfo) throws IOException {
        return this.get().getResource(resourceId, debugInfo);
    }

    @Override
    public boolean contains(String resourceId, Object debugInfo) throws IOException {
        return this.get().contains(resourceId, debugInfo);
    }

    @Override
    public boolean touch(String resourceId, Object debugInfo) throws IOException {
        return this.get().touch(resourceId, debugInfo);
    }

    @Override
    public void purgeUnexpectedResources() {
        try {
            this.get().purgeUnexpectedResources();
        }
        catch (IOException ioe) {
            FLog.e(TAG, (String)"purgeUnexpectedResources", (Throwable)ioe);
        }
    }

    @Override
    public DiskStorage.Inserter insert(String resourceId, Object debugInfo) throws IOException {
        return this.get().insert(resourceId, debugInfo);
    }

    @Override
    public Collection<DiskStorage.Entry> getEntries() throws IOException {
        return this.get().getEntries();
    }

    @Override
    public long remove(DiskStorage.Entry entry) throws IOException {
        return this.get().remove(entry);
    }

    @Override
    public long remove(String resourceId) throws IOException {
        return this.get().remove(resourceId);
    }

    @Override
    public void clearAll() throws IOException {
        this.get().clearAll();
    }

    @Override
    public DiskStorage.DiskDumpInfo getDumpInfo() throws IOException {
        return this.get().getDumpInfo();
    }

    @VisibleForTesting
    synchronized DiskStorage get() throws IOException {
        if (this.shouldCreateNewStorage()) {
            this.deleteOldStorageIfNecessary();
            this.createStorage();
        }
        return (DiskStorage)Preconditions.checkNotNull((Object)this.mCurrentState.delegate);
    }

    private boolean shouldCreateNewStorage() {
        State currentState = this.mCurrentState;
        return currentState.delegate == null || currentState.rootDirectory == null || !currentState.rootDirectory.exists();
    }

    @VisibleForTesting
    void deleteOldStorageIfNecessary() {
        if (this.mCurrentState.delegate != null && this.mCurrentState.rootDirectory != null) {
            FileTree.deleteRecursively((File)this.mCurrentState.rootDirectory);
        }
    }

    private void createStorage() throws IOException {
        File rootDirectory = new File((File)this.mBaseDirectoryPathSupplier.get(), this.mBaseDirectoryName);
        this.createRootDirectoryIfNecessary(rootDirectory);
        DefaultDiskStorage storage = new DefaultDiskStorage(rootDirectory, this.mVersion, this.mCacheErrorLogger);
        this.mCurrentState = new State(rootDirectory, storage);
    }

    @VisibleForTesting
    void createRootDirectoryIfNecessary(File rootDirectory) throws IOException {
        try {
            FileUtils.mkdirs((File)rootDirectory);
        }
        catch (FileUtils.CreateDirectoryException cde) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.WRITE_CREATE_DIR, TAG, "createRootDirectoryIfNecessary", cde);
            throw cde;
        }
        FLog.d(TAG, (String)"Created cache directory %s", (Object)rootDirectory.getAbsolutePath());
    }

    @VisibleForTesting
    static class State {
        @Nullable
        public final DiskStorage delegate;
        @Nullable
        public final File rootDirectory;

        @VisibleForTesting
        State(@Nullable File rootDirectory, @Nullable DiskStorage delegate) {
            this.delegate = delegate;
            this.rootDirectory = rootDirectory;
        }
    }
}

