import { NativeModules, NativeAppEventEmitter, NetInfo, Platform } from 'react-native';
import invariant from 'invariant';

const RNPushbotsModule = NativeModules.Pushbots;

const _notifHandlers = new Map();

function handleConnectionStateChange(isConnected) {
	if (!isConnected) return;
	NetInfo.isConnected.removeEventListener('connectionChange', handleConnectionStateChange);
}

NetInfo.isConnected.fetch().then(isConnected => {
	NetInfo.isConnected.addEventListener('connectionChange', handleConnectionStateChange);
}).catch((...args) => console.warn("Error: ", args));
	

export default class Pushbots {
	static addEventListener(type: any, handler: Function) {
		// Listen to events of notification received, opened, device registered and IDSAvailable.
		invariant(
			type === 'received' || type === 'opened' || type === 'registered' || type === 'ids',
			'Pushbots only supports `received`, `opened`, `registered`, and `ids` events'
		);

		var listener;
		console.log("Lisntener", type);
		
		if (type === 'received') {
			console.log("TYPE", type);
			
			listener = NativeAppEventEmitter.addListener(
				'Pushbots__RemoteNotificationReceived',
				(notification) => {
					console.log("notification from emitter:", notification);
					handler(notification);
				}
			);
		}
		
		_notifHandlers.set(type, listener);
	}
	
   static removeEventListener(type: any, handler: Function) {
       invariant(
           type === 'received' || type === 'opened' || type === 'registered' || type === 'ids',
           'Pushbots only supports `received`, `opened`, `registered`, and `ids` events'
       );
       var listener = _notifHandlers.get(type);
       if (!listener) {
           return;
       }
       listener.remove();
       _notifHandlers.delete(type);
   }
	
	
	static init (appID, prompt,senderId,debug) {
		if (Platform.OS === 'ios') {
			RNPushbotsModule.initWithAppId(appID)
		} else {
			RNPushbotsModule.initialize(appID,senderId, !!debug)
		}
	}

	static registerForRemoteNotifications () {	  
		RNPushbotsModule.registerForRemoteNotifications()
	}

	static setAlias (alias) {
		RNPushbotsModule.setAlias(alias)
	}

	static removeAlias(){
		RNPushbotsModule.removeAlias()
	}

	static setTag(tag){
		RNPushbotsModule.setTag(tag)
	}

	static removeTag(tag){
		RNPushbotsModule.removeTag(tag)
	}

	static toggleNotifications(value){
		RNPushbotsModule.toggleNotifications(value)
	}

	static incrementBadgeCountBy(count){
		if (Platform.OS === 'ios') {
			RNPushbotsModule.incrementBadgeCountBy(count)
		}

	}

	static decrementBadgeCountBy(count){
		if (Platform.OS === 'ios') {
			RNPushbotsModule.decrementBadgeCountBy(count)
		}

	}

	static clearBadgeCount(count){
		if (Platform.OS === 'ios') {
			RNPushbotsModule.clearBadgeCount()
		}
	}
}