/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.common.util.zzy;
import com.google.android.gms.gcm.PendingCallback;
import com.google.android.gms.gcm.TaskParams;
import com.google.android.gms.gcm.zzb;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class GcmTaskService
extends Service {
    public static final String SERVICE_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    public static final String SERVICE_ACTION_EXECUTE_TASK = "com.google.android.gms.gcm.ACTION_TASK_READY";
    public static final String SERVICE_ACTION_INITIALIZE = "com.google.android.gms.gcm.SERVICE_ACTION_INITIALIZE";
    private final Object lock = new Object();
    private final Set<String> zzbgv = new HashSet<String>();
    private int zzbgw;
    private ExecutorService zzqp;
    private Messenger zzbgx;
    private ComponentName componentName;

    @CallSuper
    public void onCreate() {
        super.onCreate();
        this.zzqp = this.zzGQ();
        this.zzbgx = new Messenger((Handler)new zza(Looper.getMainLooper()));
        this.componentName = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
    }

    @CallSuper
    public void onDestroy() {
        super.onDestroy();
        List<Runnable> list = this.zzqp.shutdownNow();
        if (!list.isEmpty()) {
            int n = list.size();
            Log.e((String)"GcmTaskService", (String)new StringBuilder(79).append("Shutting down, but not all tasks are finished executing. Remaining: ").append(n).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CallSuper
    public int onStartCommand(Intent intent, int n, int n2) {
        try {
            if (intent == null) {
                return 2;
            }
            intent.setExtrasClassLoader(PendingCallback.class.getClassLoader());
            String string = intent.getAction();
            if (SERVICE_ACTION_EXECUTE_TASK.equals(string)) {
                String string2 = intent.getStringExtra("tag");
                Parcelable parcelable = intent.getParcelableExtra("callback");
                Bundle bundle = intent.getBundleExtra("extras");
                ArrayList arrayList = intent.getParcelableArrayListExtra("triggered_uris");
                if (!(parcelable instanceof PendingCallback)) {
                    String string3 = String.valueOf(this.getPackageName());
                    Log.e((String)"GcmTaskService", (String)new StringBuilder(47 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).append(": Could not process request, invalid callback.").toString());
                    return 2;
                }
                Object object = this.lock;
                synchronized (object) {
                    if (!this.zzbgv.add(string2)) {
                        String string4 = String.valueOf(this.getPackageName());
                        Log.w((String)"GcmTaskService", (String)new StringBuilder(44 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" ").append(string2).append(": Task already running, won't start another").toString());
                        return 2;
                    }
                }
                object = ((PendingCallback)parcelable).getIBinder();
                zzb zzb2 = new zzb(string2, (IBinder)object, bundle, (List<Uri>)arrayList);
                this.zzqp.execute(zzb2);
                return 2;
            }
            if (SERVICE_ACTION_INITIALIZE.equals(string)) {
                this.onInitializeTasks();
                return 2;
            }
            Log.e((String)"GcmTaskService", (String)new StringBuilder(37 + String.valueOf(string).length()).append("Unknown action received ").append(string).append(", terminating").toString());
            return 2;
        }
        finally {
            this.zzjA(n2);
        }
    }

    protected ExecutorService zzGQ() {
        return Executors.newFixedThreadPool(2, new ThreadFactory(this){
            private final AtomicInteger zzbgy = new AtomicInteger(1);

            @Override
            public Thread newThread(@NonNull Runnable runnable) {
                int n = this.zzbgy.getAndIncrement();
                Thread thread = new Thread(runnable, new StringBuilder(20).append("gcm-task#").append(n).toString());
                thread.setPriority(4);
                return thread;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzjA(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.zzbgw = n;
            if (this.zzbgv.isEmpty()) {
                this.stopSelf(this.zzbgw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeD(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.zzbgv.remove(string);
            if (this.zzbgv.isEmpty()) {
                this.stopSelf(this.zzbgw);
            }
        }
    }

    @CallSuper
    public IBinder onBind(Intent intent) {
        if (intent == null || !zzt.zzzo() || !SERVICE_ACTION_EXECUTE_TASK.equals(intent.getAction())) {
            return null;
        }
        return this.zzbgx.getBinder();
    }

    public abstract int onRunTask(TaskParams var1);

    public void onInitializeTasks() {
    }

    private class zzb
    implements Runnable {
        private final String mTag;
        private final Bundle mExtras;
        private final List<Uri> zzbgA;
        @Nullable
        private final com.google.android.gms.gcm.zzb zzbgB;
        @Nullable
        private final Messenger mMessenger;

        zzb(String string, IBinder iBinder, Bundle bundle, List<Uri> list) {
            this.mTag = string;
            this.zzbgB = zzb.zza.zzcV(iBinder);
            this.mExtras = bundle;
            this.zzbgA = list;
            this.mMessenger = null;
        }

        zzb(String string, Messenger messenger, Bundle bundle, List<Uri> list) {
            this.mTag = string;
            this.mMessenger = messenger;
            this.mExtras = bundle;
            this.zzbgA = list;
            this.zzbgB = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskParams taskParams = new TaskParams(this.mTag, this.mExtras, this.zzbgA);
            int n = GcmTaskService.this.onRunTask(taskParams);
            try {
                this.zzjB(n);
            }
            catch (RemoteException remoteException) {
                String string = String.valueOf(this.mTag);
                Log.e((String)"GcmTaskService", (String)(string.length() != 0 ? "Error reporting result of operation to scheduler for ".concat(string) : new String("Error reporting result of operation to scheduler for ")));
            }
            finally {
                if (!this.zzGR()) {
                    GcmTaskService.this.zzeD(this.mTag);
                }
            }
        }

        private void zzjB(int n) throws RemoteException {
            if (this.zzGR()) {
                this.mMessenger.send(this.zzjC(n));
            } else {
                this.zzbgB.zzjD(n);
            }
        }

        private boolean zzGR() {
            return this.mMessenger != null;
        }

        @NonNull
        private Message zzjC(int n) {
            Message message = Message.obtain();
            message.what = 3;
            message.arg1 = n;
            Bundle bundle = new Bundle();
            bundle.putParcelable("component", (Parcelable)GcmTaskService.this.componentName);
            bundle.putString("tag", this.mTag);
            message.setData(bundle);
            return message;
        }
    }

    @TargetApi(value=21)
    private class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (!zzy.zzc((Context)GcmTaskService.this, (int)message.sendingUid, (String)"com.google.android.gms")) {
                Log.e((String)"GcmTaskService", (String)"unable to verify presence of Google Play Services");
                return;
            }
            switch (message.what) {
                case 1: {
                    this.zzc(message);
                    break;
                }
                case 2: {
                    this.zzd(message);
                    break;
                }
                case 4: {
                    GcmTaskService.this.onInitializeTasks();
                    break;
                }
                default: {
                    String string = String.valueOf(message);
                    Log.e((String)"GcmTaskService", (String)new StringBuilder(31 + String.valueOf(string).length()).append("Unrecognized message received: ").append(string).toString());
                }
            }
        }

        private void zzc(Message message) {
            Bundle bundle = message.getData();
            if (bundle == null) {
                return;
            }
            Messenger messenger = message.replyTo;
            if (messenger == null) {
                return;
            }
            String string = bundle.getString("tag");
            ArrayList arrayList = bundle.getParcelableArrayList("triggered_uris");
            GcmTaskService.this.zzqp.execute(new zzb(string, messenger, bundle.getBundle("extras"), (List<Uri>)arrayList));
        }

        private void zzd(Message message) {
            if (Log.isLoggable((String)"GcmTaskService", (int)3)) {
                String string = String.valueOf(message);
                Log.d((String)"GcmTaskService", (String)new StringBuilder(45 + String.valueOf(string).length()).append("ignoring unimplemented stop message for now: ").append(string).toString());
            }
        }
    }
}

