/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import android.util.SparseArray;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.animated.AdditionAnimatedNode;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.AnimatedNodeValueListener;
import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.animated.DecayAnimation;
import com.facebook.react.animated.DiffClampAnimatedNode;
import com.facebook.react.animated.DivisionAnimatedNode;
import com.facebook.react.animated.EventAnimationDriver;
import com.facebook.react.animated.FrameBasedAnimationDriver;
import com.facebook.react.animated.InterpolationAnimatedNode;
import com.facebook.react.animated.ModulusAnimatedNode;
import com.facebook.react.animated.MultiplicationAnimatedNode;
import com.facebook.react.animated.PropsAnimatedNode;
import com.facebook.react.animated.SpringAnimation;
import com.facebook.react.animated.StyleAnimatedNode;
import com.facebook.react.animated.TransformAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcherListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

class NativeAnimatedNodesManager
implements EventDispatcherListener {
    private final SparseArray<AnimatedNode> mAnimatedNodes = new SparseArray();
    private final SparseArray<AnimationDriver> mActiveAnimations = new SparseArray();
    private final SparseArray<AnimatedNode> mUpdatedNodes = new SparseArray();
    private final Map<String, EventAnimationDriver> mEventDrivers = new HashMap<String, EventAnimationDriver>();
    private final Map<String, Map<String, String>> mCustomEventTypes;
    private final UIImplementation mUIImplementation;
    private int mAnimatedGraphBFSColor = 0;

    public NativeAnimatedNodesManager(UIManagerModule uiManager) {
        this.mUIImplementation = uiManager.getUIImplementation();
        uiManager.getEventDispatcher().addListener(this);
        Object customEventTypes = ((Map)Assertions.assertNotNull(uiManager.getConstants())).get("customDirectEventTypes");
        this.mCustomEventTypes = (Map)customEventTypes;
    }

    @Nullable
    AnimatedNode getNodeById(int id2) {
        return (AnimatedNode)this.mAnimatedNodes.get(id2);
    }

    public boolean hasActiveAnimations() {
        return this.mActiveAnimations.size() > 0 || this.mUpdatedNodes.size() > 0;
    }

    public void createAnimatedNode(int tag, ReadableMap config) {
        AnimatedNode node;
        if (this.mAnimatedNodes.get(tag) != null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + tag + " already exists");
        }
        String type = config.getString("type");
        if ("style".equals(type)) {
            node = new StyleAnimatedNode(config, this);
        } else if ("value".equals(type)) {
            node = new ValueAnimatedNode(config);
        } else if ("props".equals(type)) {
            node = new PropsAnimatedNode(config, this);
        } else if ("interpolation".equals(type)) {
            node = new InterpolationAnimatedNode(config);
        } else if ("addition".equals(type)) {
            node = new AdditionAnimatedNode(config, this);
        } else if ("division".equals(type)) {
            node = new DivisionAnimatedNode(config, this);
        } else if ("multiplication".equals(type)) {
            node = new MultiplicationAnimatedNode(config, this);
        } else if ("modulus".equals(type)) {
            node = new ModulusAnimatedNode(config, this);
        } else if ("diffclamp".equals(type)) {
            node = new DiffClampAnimatedNode(config, this);
        } else if ("transform".equals(type)) {
            node = new TransformAnimatedNode(config, this);
        } else {
            throw new JSApplicationIllegalArgumentException("Unsupported node type: " + type);
        }
        node.mTag = tag;
        this.mAnimatedNodes.put(tag, (Object)node);
        this.mUpdatedNodes.put(tag, (Object)node);
    }

    public void dropAnimatedNode(int tag) {
        this.mAnimatedNodes.remove(tag);
        this.mUpdatedNodes.remove(tag);
    }

    public void startListeningToAnimatedNodeValue(int tag, AnimatedNodeValueListener listener) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + tag + " does not exists or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).setValueListener(listener);
    }

    public void stopListeningToAnimatedNodeValue(int tag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + tag + " does not exists or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).setValueListener(null);
    }

    public void setAnimatedNodeValue(int tag, double value) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + tag + " does not exists or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).mValue = value;
        this.mUpdatedNodes.put(tag, (Object)node);
    }

    public void setAnimatedNodeOffset(int tag, double offset) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + tag + " does not exists or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).mOffset = offset;
        this.mUpdatedNodes.put(tag, (Object)node);
    }

    public void flattenAnimatedNodeOffset(int tag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + tag + " does not exists or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).flattenOffset();
    }

    public void extractAnimatedNodeOffset(int tag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + tag + " does not exists or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).extractOffset();
    }

    public void startAnimatingNode(int animationId, int animatedNodeTag, ReadableMap animationConfig, Callback endCallback) {
        AnimationDriver animation;
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + animatedNodeTag + " does not exists");
        }
        if (!(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node should be of type " + ValueAnimatedNode.class.getName());
        }
        String type = animationConfig.getString("type");
        if ("frames".equals(type)) {
            animation = new FrameBasedAnimationDriver(animationConfig);
        } else if ("spring".equals(type)) {
            animation = new SpringAnimation(animationConfig);
        } else if ("decay".equals(type)) {
            animation = new DecayAnimation(animationConfig);
        } else {
            throw new JSApplicationIllegalArgumentException("Unsupported animation type: " + type);
        }
        animation.mId = animationId;
        animation.mEndCallback = endCallback;
        animation.mAnimatedValue = (ValueAnimatedNode)node;
        this.mActiveAnimations.put(animationId, (Object)animation);
    }

    public void stopAnimation(int animationId) {
        for (int i = 0; i < this.mActiveAnimations.size(); ++i) {
            AnimationDriver animation = (AnimationDriver)this.mActiveAnimations.valueAt(i);
            if (animation.mId != animationId) continue;
            WritableMap endCallbackResponse = Arguments.createMap();
            endCallbackResponse.putBoolean("finished", false);
            animation.mEndCallback.invoke(endCallbackResponse);
            this.mActiveAnimations.removeAt(i);
            return;
        }
    }

    public void connectAnimatedNodes(int parentNodeTag, int childNodeTag) {
        AnimatedNode parentNode = (AnimatedNode)this.mAnimatedNodes.get(parentNodeTag);
        if (parentNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + parentNodeTag + " does not exists");
        }
        AnimatedNode childNode = (AnimatedNode)this.mAnimatedNodes.get(childNodeTag);
        if (childNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + childNodeTag + " does not exists");
        }
        parentNode.addChild(childNode);
        this.mUpdatedNodes.put(childNodeTag, (Object)childNode);
    }

    public void disconnectAnimatedNodes(int parentNodeTag, int childNodeTag) {
        AnimatedNode parentNode = (AnimatedNode)this.mAnimatedNodes.get(parentNodeTag);
        if (parentNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + parentNodeTag + " does not exists");
        }
        AnimatedNode childNode = (AnimatedNode)this.mAnimatedNodes.get(childNodeTag);
        if (childNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + childNodeTag + " does not exists");
        }
        parentNode.removeChild(childNode);
        this.mUpdatedNodes.put(childNodeTag, (Object)childNode);
    }

    public void connectAnimatedNodeToView(int animatedNodeTag, int viewTag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + animatedNodeTag + " does not exists");
        }
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node connected to view should beof type " + PropsAnimatedNode.class.getName());
        }
        PropsAnimatedNode propsAnimatedNode = (PropsAnimatedNode)node;
        if (propsAnimatedNode.mConnectedViewTag != -1) {
            throw new JSApplicationIllegalArgumentException("Animated node " + animatedNodeTag + " is " + "already attached to a view");
        }
        propsAnimatedNode.mConnectedViewTag = viewTag;
        this.mUpdatedNodes.put(animatedNodeTag, (Object)node);
    }

    public void disconnectAnimatedNodeFromView(int animatedNodeTag, int viewTag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + animatedNodeTag + " does not exists");
        }
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node connected to view should beof type " + PropsAnimatedNode.class.getName());
        }
        PropsAnimatedNode propsAnimatedNode = (PropsAnimatedNode)node;
        if (propsAnimatedNode.mConnectedViewTag != viewTag) {
            throw new JSApplicationIllegalArgumentException("Attempting to disconnect view that has not been connected with the given animated node");
        }
        propsAnimatedNode.mConnectedViewTag = -1;
    }

    public void addAnimatedEventToView(int viewTag, String eventName, ReadableMap eventMapping) {
        int nodeTag = eventMapping.getInt("animatedValueTag");
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(nodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + nodeTag + " does not exists");
        }
        if (!(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node connected to event should beof type " + ValueAnimatedNode.class.getName());
        }
        ReadableArray path = eventMapping.getArray("nativeEventPath");
        ArrayList<String> pathList = new ArrayList<String>(path.size());
        for (int i = 0; i < path.size(); ++i) {
            pathList.add(path.getString(i));
        }
        EventAnimationDriver event = new EventAnimationDriver(pathList, (ValueAnimatedNode)node);
        this.mEventDrivers.put(viewTag + eventName, event);
    }

    public void removeAnimatedEventFromView(int viewTag, String eventName) {
        this.mEventDrivers.remove(viewTag + eventName);
    }

    @Override
    public void onEventDispatch(Event event) {
        if (!UiThreadUtil.isOnUiThread()) {
            return;
        }
        if (!this.mEventDrivers.isEmpty()) {
            EventAnimationDriver eventDriver;
            String eventName = event.getEventName();
            Map<String, String> customEventType = this.mCustomEventTypes.get(eventName);
            if (customEventType != null) {
                eventName = customEventType.get("registrationName");
            }
            if ((eventDriver = this.mEventDrivers.get(event.getViewTag() + eventName)) != null) {
                event.dispatch(eventDriver);
                this.mUpdatedNodes.put(eventDriver.mValueNode.mTag, (Object)eventDriver.mValueNode);
            }
        }
    }

    public void runUpdates(long frameTimeNanos) {
        AnimatedNode child;
        ValueAnimatedNode valueNode;
        int i;
        UiThreadUtil.assertOnUiThread();
        int activeNodesCount = 0;
        int updatedNodesCount = 0;
        boolean hasFinishedAnimations = false;
        ++this.mAnimatedGraphBFSColor;
        if (this.mAnimatedGraphBFSColor == 0) {
            ++this.mAnimatedGraphBFSColor;
        }
        ArrayDeque<AnimatedNode> nodesQueue = new ArrayDeque<AnimatedNode>();
        for (i = 0; i < this.mUpdatedNodes.size(); ++i) {
            AnimatedNode node = (AnimatedNode)this.mUpdatedNodes.valueAt(i);
            if (node.mBFSColor == this.mAnimatedGraphBFSColor) continue;
            node.mBFSColor = this.mAnimatedGraphBFSColor;
            ++activeNodesCount;
            nodesQueue.add(node);
        }
        for (i = 0; i < this.mActiveAnimations.size(); ++i) {
            AnimationDriver animation = (AnimationDriver)this.mActiveAnimations.valueAt(i);
            animation.runAnimationStep(frameTimeNanos);
            valueNode = animation.mAnimatedValue;
            if (valueNode.mBFSColor != this.mAnimatedGraphBFSColor) {
                valueNode.mBFSColor = this.mAnimatedGraphBFSColor;
                ++activeNodesCount;
                nodesQueue.add(valueNode);
            }
            if (!animation.mHasFinished) continue;
            hasFinishedAnimations = true;
        }
        while (!nodesQueue.isEmpty()) {
            AnimatedNode nextNode = (AnimatedNode)nodesQueue.poll();
            if (nextNode.mChildren == null) continue;
            for (int i2 = 0; i2 < nextNode.mChildren.size(); ++i2) {
                child = nextNode.mChildren.get(i2);
                ++child.mActiveIncomingNodes;
                if (child.mBFSColor == this.mAnimatedGraphBFSColor) continue;
                child.mBFSColor = this.mAnimatedGraphBFSColor;
                ++activeNodesCount;
                nodesQueue.add(child);
            }
        }
        ++this.mAnimatedGraphBFSColor;
        if (this.mAnimatedGraphBFSColor == 0) {
            ++this.mAnimatedGraphBFSColor;
        }
        for (i = 0; i < this.mUpdatedNodes.size(); ++i) {
            AnimatedNode node = (AnimatedNode)this.mUpdatedNodes.valueAt(i);
            if (node.mActiveIncomingNodes != 0 || node.mBFSColor == this.mAnimatedGraphBFSColor) continue;
            node.mBFSColor = this.mAnimatedGraphBFSColor;
            ++updatedNodesCount;
            nodesQueue.add(node);
        }
        for (i = 0; i < this.mActiveAnimations.size(); ++i) {
            AnimationDriver animation = (AnimationDriver)this.mActiveAnimations.valueAt(i);
            valueNode = animation.mAnimatedValue;
            if (valueNode.mActiveIncomingNodes != 0 || valueNode.mBFSColor == this.mAnimatedGraphBFSColor) continue;
            valueNode.mBFSColor = this.mAnimatedGraphBFSColor;
            ++updatedNodesCount;
            nodesQueue.add(valueNode);
        }
        while (!nodesQueue.isEmpty()) {
            AnimatedNode nextNode = (AnimatedNode)nodesQueue.poll();
            nextNode.update();
            if (nextNode instanceof PropsAnimatedNode) {
                try {
                    ((PropsAnimatedNode)nextNode).updateView(this.mUIImplementation);
                }
                catch (IllegalViewOperationException e) {
                    FLog.e((String)"React", (String)"Native animation workaround, frame lost as result of race condition", (Throwable)e);
                }
            }
            if (nextNode instanceof ValueAnimatedNode) {
                ((ValueAnimatedNode)nextNode).onValueUpdate();
            }
            if (nextNode.mChildren == null) continue;
            for (int i3 = 0; i3 < nextNode.mChildren.size(); ++i3) {
                child = nextNode.mChildren.get(i3);
                --child.mActiveIncomingNodes;
                if (child.mBFSColor == this.mAnimatedGraphBFSColor || child.mActiveIncomingNodes != 0) continue;
                child.mBFSColor = this.mAnimatedGraphBFSColor;
                ++updatedNodesCount;
                nodesQueue.add(child);
            }
        }
        if (activeNodesCount != updatedNodesCount) {
            throw new IllegalStateException("Looks like animated nodes graph has cycles, there are " + activeNodesCount + " but toposort visited only " + updatedNodesCount);
        }
        this.mUpdatedNodes.clear();
        if (hasFinishedAnimations) {
            for (i = this.mActiveAnimations.size() - 1; i >= 0; --i) {
                AnimationDriver animation = (AnimationDriver)this.mActiveAnimations.valueAt(i);
                if (!animation.mHasFinished) continue;
                WritableMap endCallbackResponse = Arguments.createMap();
                endCallbackResponse.putBoolean("finished", true);
                animation.mEndCallback.invoke(endCallbackResponse);
                this.mActiveAnimations.removeAt(i);
            }
        }
    }
}

