/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.common.futures.SimpleSettableFuture;
import com.facebook.react.cxxbridge.CxxModuleWrapper;
import com.facebook.react.cxxbridge.LegacyModuleInfo;
import com.facebook.react.cxxbridge.UiThreadUtil;
import com.facebook.react.module.model.Info;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.inject.Provider;

public class ModuleHolder {
    private final Info mInfo;
    @Nullable
    private Provider<? extends NativeModule> mProvider;
    @Nullable
    private NativeModule mModule;
    private boolean mInitializeNeeded;

    public ModuleHolder(ReactModuleInfo info, Provider<? extends NativeModule> provider) {
        this.mInfo = info;
        this.mProvider = provider;
        if (this.mInfo.needsEagerInit()) {
            this.mModule = this.doCreate();
        }
    }

    public ModuleHolder(LegacyModuleInfo info, NativeModule nativeModule) {
        this.mInfo = info;
        this.mModule = nativeModule;
    }

    public synchronized void initialize() {
        if (this.mModule != null) {
            this.doInitialize(this.mModule);
        } else {
            this.mInitializeNeeded = true;
        }
    }

    public synchronized void destroy() {
        if (this.mModule != null) {
            this.mModule.onCatalystInstanceDestroy();
        }
    }

    public Info getInfo() {
        return this.mInfo;
    }

    public synchronized NativeModule getModule() {
        if (this.mModule == null) {
            this.mModule = this.doCreate();
        }
        return this.mModule;
    }

    private NativeModule doCreate() {
        NativeModule module = this.create();
        this.mProvider = null;
        return module;
    }

    private NativeModule create() {
        String name;
        boolean isEagerModule = this.mInfo instanceof LegacyModuleInfo;
        String string = name = isEagerModule ? ((LegacyModuleInfo)this.mInfo).mType.getSimpleName() : this.mInfo.name();
        if (!isEagerModule) {
            ReactMarker.logMarker("CREATE_MODULE_START");
        }
        SystraceMessage.beginSection(0L, "createModule").arg("name", name).flush();
        NativeModule module = (NativeModule)((Provider)Assertions.assertNotNull(this.mProvider)).get();
        if (this.mInitializeNeeded) {
            this.doInitialize(module);
            this.mInitializeNeeded = false;
        }
        Systrace.endSection(0L);
        if (!isEagerModule) {
            ReactMarker.logMarker("CREATE_MODULE_END");
        }
        return module;
    }

    private void doInitialize(NativeModule module) {
        SystraceMessage.Builder section = SystraceMessage.beginSection(0L, "initialize");
        if (module instanceof CxxModuleWrapper) {
            section.arg("className", module.getClass().getSimpleName());
        } else {
            section.arg("name", this.mInfo.name());
        }
        section.flush();
        ModuleHolder.callInitializeOnUiThread(module);
        Systrace.endSection(0L);
    }

    private static void callInitializeOnUiThread(final NativeModule module) {
        if (UiThreadUtil.isOnUiThread()) {
            module.initialize();
            return;
        }
        final SimpleSettableFuture future = new SimpleSettableFuture();
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Systrace.beginSection(0L, "initializeOnUiThread");
                try {
                    module.initialize();
                    future.set(null);
                }
                catch (Exception e) {
                    future.setException(e);
                }
                Systrace.endSection(0L);
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

