/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import com.facebook.react.flat.AndroidView;
import com.facebook.react.flat.FlatShadowNode;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.views.art.ARTVirtualNode;
import com.facebook.yoga.YogaUnit;
import com.facebook.yoga.YogaValue;
import javax.annotation.Nullable;

class FlatARTSurfaceViewShadowNode
extends FlatShadowNode
implements AndroidView,
TextureView.SurfaceTextureListener {
    private boolean mPaddingChanged = false;
    @Nullable
    private Surface mSurface;

    FlatARTSurfaceViewShadowNode() {
        this.forceMountToView();
        this.forceMountChildrenToView();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiUpdater) {
        super.onCollectExtraUpdates(uiUpdater);
        this.drawOutput();
        uiUpdater.enqueueUpdateExtraData(this.getReactTag(), this);
    }

    private void drawOutput() {
        if (this.mSurface == null || !this.mSurface.isValid()) {
            this.markChildrenUpdatesSeen(this);
            return;
        }
        try {
            Canvas canvas = this.mSurface.lockCanvas(null);
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            Paint paint = new Paint();
            for (int i = 0; i < this.getChildCount(); ++i) {
                ARTVirtualNode child = (ARTVirtualNode)this.getChildAt(i);
                child.draw(canvas, paint, 1.0f);
                child.markUpdateSeen();
            }
            if (this.mSurface == null) {
                return;
            }
            this.mSurface.unlockCanvasAndPost(canvas);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            Log.e((String)"React", (String)(e.getClass().getSimpleName() + " in Surface.unlockCanvasAndPost"));
        }
    }

    private void markChildrenUpdatesSeen(ReactShadowNode shadowNode) {
        for (int i = 0; i < shadowNode.getChildCount(); ++i) {
            ReactShadowNode child = shadowNode.getChildAt(i);
            child.markUpdateSeen();
            this.markChildrenUpdatesSeen(child);
        }
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return false;
    }

    @Override
    public boolean isPaddingChanged() {
        return this.mPaddingChanged;
    }

    @Override
    public void resetPaddingChanged() {
        this.mPaddingChanged = false;
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        YogaValue current = this.getStylePadding(spacingType);
        if (current.unit != YogaUnit.PIXEL || current.value != padding) {
            super.setPadding(spacingType, padding);
            this.mPaddingChanged = true;
            this.markUpdated();
        }
    }

    @Override
    public void setPaddingPercent(int spacingType, float percent) {
        YogaValue current = this.getStylePadding(spacingType);
        if (current.unit != YogaUnit.PERCENT || current.value != percent) {
            super.setPadding(spacingType, percent);
            this.mPaddingChanged = true;
            this.markUpdated();
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mSurface = new Surface(surface);
        this.drawOutput();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        surface.release();
        this.mSurface = null;
        return true;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }
}

