/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.annotation.TargetApi;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import com.facebook.react.flat.AndroidView;
import com.facebook.react.flat.FlatShadowNode;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.yoga.YogaUnit;
import com.facebook.yoga.YogaValue;

class FlatReactModalShadowNode
extends FlatShadowNode
implements AndroidView {
    private final Point mMinPoint = new Point();
    private final Point mMaxPoint = new Point();
    private boolean mPaddingChanged;

    FlatReactModalShadowNode() {
        this.forceMountToView();
        this.forceMountChildrenToView();
    }

    @Override
    @TargetApi(value=16)
    public void addChildAt(ReactShadowNode child, int i) {
        int height;
        int width;
        super.addChildAt(child, i);
        ThemedReactContext context = this.getThemedContext();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        display.getCurrentSizeRange(this.mMinPoint, this.mMaxPoint);
        int rotation = display.getRotation();
        if (rotation == 0 || rotation == 2) {
            width = this.mMinPoint.x;
            height = this.mMaxPoint.y;
        } else {
            width = this.mMaxPoint.x;
            height = this.mMinPoint.y;
        }
        child.setStyleWidth(width);
        child.setStyleHeight(height);
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return false;
    }

    @Override
    public boolean isPaddingChanged() {
        return this.mPaddingChanged;
    }

    @Override
    public void resetPaddingChanged() {
        this.mPaddingChanged = false;
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        YogaValue current = this.getStylePadding(spacingType);
        if (current.unit != YogaUnit.PIXEL || current.value != padding) {
            super.setPadding(spacingType, padding);
            this.mPaddingChanged = true;
            this.markUpdated();
        }
    }

    @Override
    public void setPaddingPercent(int spacingType, float percent) {
        YogaValue current = this.getStylePadding(spacingType);
        if (current.unit != YogaUnit.PERCENT || current.value != percent) {
            super.setPadding(spacingType, percent);
            this.mPaddingChanged = true;
            this.markUpdated();
        }
    }
}

